<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit;

class Interactions {
	public static function init() {
		\Bricks\Interactions::$control_options = \Bricks\Interactions::get_controls_data();
		$fields = [];

		\Bricks\Interactions::$control_options['fields']['trigger']['options']['breakpoint'] = esc_html__('Breakpoints', 'bricksultimate');

		$fields['breakpoint'] = [
			'label' 		=> esc_html__( 'Breakpoint', 'bricks' ),
			'type' 			=> 'number',
			'unit' 			=> false,
			'placeholder' 	=> 768,
			'required' 		=> [ 'trigger', '=', 'breakpoint' ],
		];

		$fields['bpOperator'] = [
			'label' 		=> esc_html__( 'Operator', 'bricks' ),
			'type' 			=> 'select',
			'options' 		=> [
				'==' => '==',
				'>=' => '>=',
				'<=' => '<=',
				'<'  => '<',
				'>'  => '>',
			],
			'placeholder' 	=> '<',
			'required' 		=> [ 'trigger', '=', 'breakpoint' ],
		];

		\Bricks\Interactions::$control_options['fields']['trigger']['options']['ocpGroupTitle'] = esc_html__( '(BU)Off Canvas', 'bricksultimate' );
		$triggers = [
			'bu_ocp_open' 	=> esc_html__( '(BU) Off Canvas Opened', 'bricksultimate' ),
			'bu_ocp_close' 	=> esc_html__( '(BU) Off Canvas Closed', 'bricksultimate' ),
		];
		foreach( $triggers as $key => $trigger ) {
			\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $trigger;
		}

		$fields['buOcpSelector'] = [
			'label' 		=> esc_html__( 'Off Canvas Selector', 'bricksultimate' ),
			'type' 			=> 'text',
			'required' 		=> [ 'trigger', '=', [ 'bu_ocp_open', 'bu_ocp_close' ] ],
			'hasDynamicData' => false
		];

		\Bricks\Interactions::$control_options['fields'] = array_slice( \Bricks\Interactions::$control_options['fields'], 0, 4, true ) + $fields + array_slice( \Bricks\Interactions::$control_options['fields'], 4, null, true );

		\Bricks\Interactions::$control_options['fields']['trigger']['options']['wlGroupTitle'] = esc_html__( '(BU)Wishlist', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['buwoo_added_to_wishlist'] = esc_html__( '(BU)Added to wishlist', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['buwoo_removed_from_wishlist'] = esc_html__( '(BU)Removed from wishlist', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['buwoo_update_wishlist'] = esc_html__( '(BU)Updated wishlist', 'bricksultimate' );

		\Bricks\Interactions::$control_options['fields']['trigger']['options']['compGroupTitle'] = esc_html__( '(BU)Compare', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['bu_added_to_compare'] = esc_html__( '(BU)Added to compare', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['bu_removed_from_compare'] = esc_html__( '(BU)Removed from compare', 'bricksultimate' );
		\Bricks\Interactions::$control_options['fields']['trigger']['options']['bu_update_compare'] = esc_html__( '(BU)Updated compare', 'bricksultimate' );

		/**
		 * woocommerce related interactions
		 */
		if( class_exists('WooCommerce') ) {
			\Bricks\Interactions::$control_options['fields']['trigger']['options']['buWooGroupTitle'] = esc_html__( '(BU)WooCommerce', 'bricks' );
			$tiggers = [
				'adding_to_cart' 				=> esc_html__( 'Adding to cart', 'bricks' ),
				'added_to_cart' 				=> esc_html__( 'Added to cart', 'bricks' ),
				'removed_from_cart' 			=> esc_html__( 'Removed from cart', 'bricks' ),
				'wc_fragments_refreshed' 		=> esc_html__( 'Fragments refreshed', 'bricks' ),
				'found_variation'				=> esc_html__( 'Found Variation', 'bricksultimate'),
				'update_checkout' 				=> esc_html__( 'Update checkout', 'bricks' ),
				'empty_cart' 					=> esc_html__( 'Empty cart', 'bricks' ),
				'cart_not_empty' 				=> esc_html__( 'Cart is not empty', 'bricks' ),
				'applied_coupon' 				=> esc_html__( 'Applied coupon', 'bricks' ),
				'applied_coupon_in_checkout' 	=> esc_html__( 'Applied coupon - Checkout Page', 'bricks' ),
				'removed_coupon' 				=> esc_html__( 'Removed coupon', 'bricks' ),
				'removed_coupon_in_checkout' 	=> esc_html__( 'Removed coupon - Checkout Page', 'bricks' ),
			];
			foreach( $tiggers as $key => $tigger ) {
				\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $tigger;
			}

			\Bricks\Interactions::$control_options['fields']['trigger']['options']['wooscGroupTitle'] = esc_html__( 'Shipping Calculator', 'bricksultimate' );

			$scTiggers = [
				'buwoo_shipping_calculated' 	=> esc_html__( 'Shipping cost calculated', 'bricksultimate' ),
				'buwoo_shipping_method_updated' => esc_html__( 'Shipping method updated', 'bricksultimate' ),
			];
			foreach( $scTiggers as $key => $tigger ) {
				\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $tigger;
			}
		}

		/**
		 * fluent form related interactions
		 */
		if( function_exists( 'wpFluentForm' ) ) {
			\Bricks\Interactions::$control_options['fields']['trigger']['options']['ffGroupTitle'] = esc_html__( 'Fluent Form', 'bricks' );
			$triggers = [
				'fluentform_init' 					=> esc_html__( 'Form initialize', 'bricksultimate' ),
				'fluentform_init_single' 			=> esc_html__( 'Form initialise single', 'bricksultimate' ),
				'fluentform_submission_success' 	=> esc_html__( 'Submission successful', 'bricksultimate' ),
				'fluentform_submission_failed' 		=> esc_html__( 'Submission failed', 'bricksultimate' ),
				'fluentform_reset' 					=> esc_html__( 'Form reset', 'bricksultimate' ),
			];
			foreach( $triggers as $key => $trigger ) {
				\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $trigger;
			}
			$forms = \FluentForm\App\Helpers\Helper::getForms();
			unset( $forms[ 0 ] );

			$fields['fluentForm'] = [
				'label' 	=> esc_html__( 'Form', 'bricks' ),
				'type' 		=> 'select',
				'options' 	=> $forms,
				'placeholder' => esc_html__( 'Select', 'bricks' ),
				'required' => [ 'trigger', '=', [ 'fluentform_submission_failed', 'fluentform_init_single' ] ],
			];
		}

		if( class_exists('WS_Form_Form') ) {
			\Bricks\Interactions::$control_options['fields']['trigger']['options']['wsGroupTitle'] = esc_html__( 'WSForms', 'bricksultimate' );
			$triggers = [
				'wsf-submit-success' 	=> esc_html__( 'Submission success', 'bricksultimate' ),
				'wsf-submit-error' 		=> esc_html__( 'Submission error', 'bricksultimate' ),
				'wsf-reset-complete' 	=> esc_html__( 'Form reset', 'bricksultimate' ),
				'wsf-validate-fail' 	=> esc_html__( 'Validate fail', 'bricksultimate' ),
			];

			foreach( $triggers as $key => $trigger ) {
				\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $trigger;
			}
		}

		if( class_exists('WooCommerce') ) {
			\Bricks\Interactions::$control_options['fields']['action']['options']['sku'] = esc_html__( ' Variation Sku', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['weight'] = esc_html__( ' Variation Weight - Value', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['weight_html'] = esc_html__( 'Variation Weight - HTML', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['dimensions'] = esc_html__( 'Variation Dimensions - Value', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['dimensions_html'] = esc_html__( 'Variation Dimensions - HTML', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['variation_description'] = esc_html__( 'Variation Description', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['price_html'] = esc_html__( 'Variation Price', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['variation_unique_id'] = esc_html__( 'Variation GTIN, UPC, EAN, or ISBN', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['variation_cmf'] = esc_html__( 'Variation Custom Field', 'woocommerce' );

			\Bricks\Interactions::$control_options['fields']['action']['options']['apply_coupon'] = esc_html__( 'Apply coupon', 'woocommerce' );
			\Bricks\Interactions::$control_options['fields']['action']['options']['remove_coupon'] = esc_html__( 'Remove coupon', 'woocommerce' );

			\Bricks\Interactions::$control_options['fields']['action']['options']['wishlists_to_cart'] = esc_html__('Add all to cart', 'bricksultimate');

			$fields['variation_cmf_name'] = [
				'label' 		=> esc_html__( 'Custom attribute name', 'bricks' ),
				'type' 			=> 'text',
				'placeholder' 	=> esc_html__('variation_article_number'),
				'required' 		=> [ 'action', '=', 'variation_cmf' ],
				'hasDynamicData' => true
			];

			$fields['wcCoupon'] = [
				'label' 		=> esc_html__( 'Enter coupon code', 'bricks' ),
				'type' 			=> 'text',
				'required' 		=> [ 'action', '=', [ 'apply_coupon', 'remove_coupon' ] ],
				'hasDynamicData' => true
			];

			$fields['wcCouponMsg'] = [
				'label' 		=> esc_html__( 'Show block', 'bricks' ),
				'type' 			=> 'text',
				'required' 		=> [ 'action', '=', [ 'apply_coupon', 'remove_coupon' ] ],
				'placeholder' 	=> '.brxe-block',
				'description' 	=> esc_html__('enter selector', 'bricksultimate' )
			];

			$fields['wcHideCouponBlck'] = [
				'label' 		=> esc_html__( 'Hide block', 'bricks' ),
				'type' 			=> 'text',
				'required' 		=> [ 'action', '=', [ 'apply_coupon', 'remove_coupon' ] ],
				'placeholder' 	=> '.brxe-block',
				'description' 	=> esc_html__('enter selector', 'bricksultimate' )
			];
		}

		\Bricks\Interactions::$control_options['fields']['action']['options']['sync_burger'] = esc_html__('Sync Animated Burger', 'bricksultimate');

		$fields['abDelay'] = [
			'label' 		=> esc_html__( 'Animation delay(ms)', 'bricks' ),
			'type' 			=> 'number',
			'unit' 			=> false,
			'placeholder' 	=> 500,
			'required' 		=> [ 'action', '=', 'sync_burger' ],
		];

		\Bricks\Interactions::$control_options['fields']['action']['options']['delete_wishlist'] = esc_html__('Delete wishlist item', 'bricksultimate');
		\Bricks\Interactions::$control_options['fields']['action']['options']['delete_compare'] = esc_html__('Delete Compare Item', 'bricksultimate');

		$fields['postType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'default' 	=> 'post',
			'required' 	=> [ 'action', '=', [ 'delete_wishlist', 'wishlists_to_cart', 'delete_compare' ] ],
		];

		$fields['dynPostId'] = [
			'label' 		=> esc_html__( 'Post ID', 'bricks' ),
			'type' 			=> 'text',
			'required' 		=> [ 'action', '=', ['delete_wishlist', 'delete_compare'] ],
			'hasDynamicData' => true
		];

		$fields['containerSelector'] = [
			'label' 		=> esc_html__( 'Outer container selector', 'bricks' ),
			'type' 			=> 'text',
			'required' 		=> [ 'action', '=', [ 'delete_wishlist', 'delete_compare' ] ],
			'hasDynamicData' => false
		];

		$fields['pgnSelector'] = [
			'label' 		=> esc_html__( 'Pagination element selector', 'bricks' ),
			'type' 			=> 'text',
			'required' 		=> [ 'action', '=', 'delete_wishlist' ],
			'hasDynamicData' => false
		];

		$fields['tabSelector'] = [
			'label' 		=> esc_html__( 'Tab selector', 'bricks' ),
			'type' 			=> 'text',
			'required' 		=> [ 'action', '=', [ 'delete_wishlist', 'delete_compare' ] ],
			'hasDynamicData' => false,
			'description' 	=> esc_html__('If you are showing the items inside a tab, you will enter that tab ID/CSS classname here.', 'bricksultimate')
		];

		\Bricks\Interactions::$control_options['fields']['action']['options']['tooltip'] = esc_html__('Tooltip', 'bricksultimate');

		$fields['ttText'] = [
			'label' 	=> esc_html__('Tooltip content', 'bricksultimate'),
			'type' 		=> 'text',
			'description' => esc_html__('Enter text or CSS selector', 'bricksultimate'),
			'required' 	=> [ 'action', '=', 'tooltip' ],
			'hasDynamicData' => true
		];

		$fields['ttAppendTo'] = [
			'label' 	=> esc_html__('Append to', 'bricksultimate'),
			'type' 		=> 'text',
			'description' => esc_html__('Enter CSS selector', 'bricksultimate'),
			'required' 	=> [ 'action', '=', 'tooltip' ],
			'hasDynamicData' => false
		];

		$fields['ttPlacement'] = [
			'label' 	=> esc_html__('Position', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'top' 			=> __( 'Top' ), 
				'top-start' 	=> __( 'Top Start' ), 
				'top-end' 		=> __( 'Top End' ),
				'right' 		=> __( 'Right' ), 
				'right-start' 	=> __( 'Right Start' ), 
				'right-end' 	=> __( 'Right End' ),
				'bottom' 		=> __( 'Bottom' ), 
				'bottom-start' 	=> __( 'Bottom Start' ), 
				'bottom-end' 	=> __( 'Bottom End' ),
				'left' 			=> __( 'Left' ), 
				'left-start' 	=> __( 'Left Start' ), 
				'left-end' 		=> __( 'Left End' ), 
				'auto' 			=> __( 'Auto' ), 
				'auto-start' 	=> __( 'Auto Start' ), 
				'auto-end' 		=> __( 'Auto End' ),
			],
			'inline' 		=> true,
			'default' 		=> 'auto',
			'required' 		=> [ 'action', '=', 'tooltip' ],
		];

		$fields['ttAnimation'] = [
			'label' 	=> esc_html__('Animation', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'fade' 			=> __( 'Fade' ), 
				'shift-away' 	=> __( 'Shift Away' ), 
				'shift-toward' 	=> __( 'Shift Toward' ), 
				'perspective' 	=> __( 'Perspective' )
			],
			'inline' 		=> true,
			'default' 	=> 'Fade',
			'required' 	=> [ 'action', '=', 'tooltip' ],
		];

		\Bricks\Interactions::$control_options['fields'] = 
				array_slice( \Bricks\Interactions::$control_options['fields'], 0, 12, true ) 
				+ $fields 
				+ array_slice( \Bricks\Interactions::$control_options['fields'], 12, null, true );
	}
}