<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait TooltipControls {
	public function bu_tooltip_controls( $controls, $group, $return = true ) {
		$controls['hasTooltip'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Enable tooltip', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'reset' 	=> true,
			'rerender' => false
		];

		$controls['ttBG'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Background color', 'bricksultimate'),
			'type' 		=> 'color',
			'inline' 	=> true,
			'css' 	=> [
				[
					'property' => 'background-color', 
					'selector' => '.tippy-box'
				]
			],
			'required' 	=> ['hasTooltip', '=', true],
			'rerender' => false
		];

		$controls['ttAcolor'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Arrow color', 'bricksultimate'),
			'type' 		=> 'color',
			'inline' 	=> true,
			'css' 	=> [
				[ 
					'property' => 'color', 
					'selector' => '.tippy-arrow'
				]
			],
			'required' 	=> ['hasTooltip', '=', true],
			'rerender' => false
		];

		$controls['ttTg'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Typography', 'bricksultimate'),
			'type' 		=> 'typography',
			'inline' 	=> true,
			'css' 	=> [
				[
					'property' => 'font', 
					'selector' => '.tippy-content'
				]
			],
			'required' 	=> ['hasTooltip', '=', true],
			'rerender' => false
		];

		$controls['ttPlacement'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Position', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'top' 			=> __( 'Top' ), 
				'top-start' 	=> __( 'Top Start' ), 
				'top-end' 		=> __( 'Top End' ),
				'right' 		=> __( 'Right' ), 
				'right-start' 	=> __( 'Right Start' ), 
				'right-end' 	=> __( 'Right End' ),
				'bottom' 		=> __( 'Bottom' ), 
				'bottom-start' 	=> __( 'Bottom Start' ), 
				'bottom-end' 	=> __( 'Bottom End' ),
				'left' 			=> __( 'Left' ), 
				'left-start' 	=> __( 'Left Start' ), 
				'left-end' 		=> __( 'Left End' ), 
				'auto' 			=> __( 'Auto' ), 
				'auto-start' 	=> __( 'Auto Start' ), 
				'auto-end' 		=> __( 'Auto End' ),
			],
			'inline' 		=> true,
			'placeholder' 	=> 'top',
			'required' 	=> ['hasTooltip', '=', true],
			'rerender' => false
		];

		$controls['ttAnimation'] = [
			'group' 	=> $group,
			'label' 	=> esc_html__('Animation', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'fade' 			=> __( 'Fade' ), 
				'shift-away' 	=> __( 'Shift Away' ), 
				'shift-toward' 	=> __( 'Shift Toward' ), 
				'perspective' 	=> __( 'Perspective' )
			],
			'inline' 		=> true,
			'placeholder' 	=> 'perspective',
			'required' 	=> ['hasTooltip', '=', true],
			'rerender' => false
		];

		if( $return )
			return $controls;
	}
}