<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

trait UltimateQueryControls {
	/**
	 * Adds controls for ultimate query builder
	 * 
	 * @since 0.4
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	private function add_bu_query_controls( $controls ) {
		$bucontrols['buQueryTpes'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Ultimate query type', 'bricksultimate'),
			'options' 	=> [
				'none' 			=> esc_html__('Select query type', 'bricksultimate'),
				'acfgallery' 	=> esc_html__('ACF Gallery', 'bricksultimate'),
				'acfpobj' 		=> esc_html__('ACF Post Object', 'bricksultimate'),
				'acfcb' 		=> esc_html__('ACF Checkbox', 'bricksultimate'),
				'adjposts' 		=> esc_html__('Adjacent Posts', 'bricksultimate'),
				'authbox' 		=> esc_html__('Author Box', 'bricksultimate'),
				'compare' 		=> esc_html__('Compare Items', 'bricksultimate'),
				'customwp' 		=> esc_html__('Custom WP Query', 'bricksultimate'),
				'termquery' 	=> esc_html__('Custom Taxonomy Query', 'bricksultimate'),
				'mbImgAdv' 		=> esc_html__('Metabox Image Advanced - Clonable', 'bricksultimate'),
				'mbcbl' 		=> esc_html__('Metabox Checkbox List', 'bricksultimate'),
				'mbrel' 		=> esc_html__('Metabox Relationship', 'bricksultimate'),
				'postyear' 		=> esc_html__('Posts Years', 'bricksultimate'),
				'wishlist' 		=> esc_html__('Wishlist Items', 'bricksultimate'),
				'wpmenu' 		=> esc_html__('WP Menu', 'bricksultimate'),
			],
			'default' 	=> 'none',
			'required' 	=> [ [ 'hasLoop', '=', true ], [ 'query.objectType', '=', 'buQuery' ] ]
		];

		/**
		 * Custom WP Query controls
		 */
		$bucontrols['wp_args'] = [
			'tab'       => 'content',
			'type'      => 'code',
			'mode'      => 'php',
			'clearable' => false, // Required to always have 'mode' set for CodeMirror
			'placeholder'  => "Enter query args",
			'required'  => [ 'buQueryTpes', '=', 'customwp' ],
			'rerender'  => true,
		];

		/**
		 * Custom Taxonomy Query controls
		 */
		$bucontrols['tax_args'] = [
			'tab'       => 'content',
			'type'      => 'code',
			'mode'      => 'php',
			'clearable' => false, // Required to always have 'mode' set for CodeMirror
			'placeholder'  => "Enter query args",
			'required'  => [ 'buQueryTpes', '=', 'termquery' ],
			'rerender'  => true,
		];

		/**
		 * Adjacent post controls
		 */
		$bucontrols['postPrevNext'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Showing', 'bricksultimate'),
			'options' 	=> [
				'prev' 	=> esc_html__('Previous Post', 'bricksultimate'),
				'next' 	=> esc_html__('Next Post', 'bricksultimate'),
			],
			'default' 	=> 'prev',
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> [ 'buQueryTpes', '=', 'adjposts' ],
		];

		$bucontrols['inSameTerm'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('In same terms?', 'bricksultimate'),
			'default' 	=> 'no',
			'options' 	=> [
				'no' 	=> esc_html__('No', 'bricksultimate'),
				'yes' 	=> esc_html__('Yes', 'bricksultimate'),
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> [ 'buQueryTpes', '=', 'adjposts' ],
		];

		$bucontrols['taxonomy'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Taxonomy', 'bricksultimate'),
			'default' 	=> 'category',
			'options' 	=> \Bricks\Setup::get_taxonomies_options(),
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> [ 'inSameTerm', '=', 'yes' ],
		];

		$bucontrols['excludedTerms'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Exclude terms', 'bricksultimate'),
			'placeholder' => esc_html__('comma-separated list of excluded term IDs', 'bricksultimate'),
			'required' 	=> [ 'buQueryTpes', '=', 'adjposts' ],
			'hasDynamicData' => false,
		];


		//* Controls for ACF gallery
		$bucontrols['acfGalleryField'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Gallery Field Name', 'bricksultimate'),
			'hasDynamicData' => false,
			'required' 	=> [ 'buQueryTpes', '=', 'acfgallery' ],
		];

		$bucontrols['acfField'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Field Name', 'bricksultimate'),
			'hasDynamicData' => false,
			'required' 	=> [ 'buQueryTpes', '=', [ 'acfpobj', 'acfcb' ] ],
		];

		$bucontrols['isOptionsPpage'] = [
			'tab'  		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Fetching from ACF Option Page?', 'bricksultimate'),
			'reset' 	=> true,
			'required' 	=> [ 'buQueryTpes', '=', [ 'acfgallery', 'acfpobj', 'acfcb' ] ],
		];

		$bucontrols['galleryLimit'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Limit', 'bricksultimate'),
			'units' 	=> false,
			'step' 		=> 1,
			'placeholder' => 10,
			'required' 	=> [ 'buQueryTpes', '=', [ 'acfgallery', 'acfpobj' ] ],
		];

		//* Controls for Metabox gallery
		$bucontrols['mbImgAdvField'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Field Name', 'bricksultimate'),
			'hasDynamicData' => false,
			'required' 	=> [ 'buQueryTpes', '=', 'mbImgAdv' ],
		];

		$bucontrols['mbgLimit'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Limit', 'bricksultimate'),
			'units' 	=> false,
			'step' 		=> 1,
			'placeholder' => 10,
			'required' 	=> [ 'buQueryTpes', '=', 'mbImgAdv' ],
		];

		//* Controls for Metabox field
		$bucontrols['mbFieldId'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Field Id', 'bricksultimate'),
			'hasDynamicData' => false,
			'required' 	=> [ 'buQueryTpes', '=', 'mbcbl' ],
		];

		//* Controld for Metabox relationship
		$bucontrols['mbRelQueryType'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Query type', 'bricksultimate'),
			'options' 	=> ['post' => 'Post'],
			'default' 	=> 'post',
			'required' 	=> [ 'buQueryTpes', '=', 'mbrel' ],
		];

		$bucontrols['mbRelationId'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Relationship ID', 'bricksultimate'),
			'options' 	=> self::getMBRelstionshipIds(),
			'default' 	=> 'none',
			'required' 	=> [ 'buQueryTpes', '=', 'mbrel' ],
		];

		$bucontrols['mbRelFecthing'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Connection type', 'bricksultimate'),
			'options' 	=> ['from' => 'From', 'to' => 'To'],
			'default' 	=> 'from',
			'inline' 	=> true,
			'required' 	=> [ 'buQueryTpes', '=', 'mbrel' ],
		];

		$bucontrols['mbRelObjectId'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Object ID', 'bricksultimate'),
			'hasDynamicData' => true,
			'placeholder' => 'object id',
			'required' 	=> [ 'buQueryTpes', '=', 'mbrel' ],
		];

		//* Controls for menu
		$bucontrols['menuSlug'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Menu', 'bricksultimate'),
			'options'   => Helpers::getWPMenus(),
			'default'   => 'none',
			'required'	=> ['buQueryTpes', '=', 'wpmenu']
		];

		$bucontrols['itemParent'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__('Parent', 'bricksultimate'),
			'placeholder'  => esc_html__('Enter menu item ID. 0 is for top level items', 'bricksultimate'),
			'required'	=> ['buQueryTpes', '=', 'wpmenu'],
			//'hasDynamicData' => false
		];

		$bucontrols['itemInclude'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__('Include', 'bricksultimate'),
			'placeholder'  => esc_html__('Enter menu item IDs with comma', 'bricksultimate'),
			'required'	=> ['buQueryTpes', '=', 'wpmenu'],
			//'hasDynamicData' => false
		];

		$bucontrols['itemExclude'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__('Exclude', 'bricksultimate'),
			'placeholder'  => esc_html__('Enter menu item IDs with comma', 'bricksultimate'),
			'required'	=> ['buQueryTpes', '=', 'wpmenu'],
			//'hasDynamicData' => false
		];

		$bucontrols['pyPostType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'required'    => [ 'buQueryTpes', '=', [ 'postyear', 'wishlist', 'compare' ] ],
		];

		$bucontrols['posts_per_page'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Posts per page', 'bricksultimate'),
			//'default' 	=> 10,
			'placeholder' => 10,
			'required'    => [ 'buQueryTpes', '=', [ 'postyear', 'wishlist', 'compare', 'mbrel' ] ],
		];

		$bucontrols['ignore_sticky_posts'] = [
			'tab'  		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Ignore sticky posts', 'bricksultimate'),
			'required'    => [ 'buQueryTpes', '=', [ 'wishlist', 'compare', 'mbrel' ] ],
		];

		$bucontrols['yearLimit'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Limit', 'bricksultimate'),
			'units' 	=> false,
			'step' 		=> 1,
			'placeholder' => 10,
			'required' 	=> [ 'buQueryTpes', '=', 'postyear' ],
		];

		$bucontrols['orderby'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Order by' ),
			//'default' 	=> 'date',
			'placeholder' => 'date',
			'inline' 	=> true,
			'options' 	=> [
				'ID' 		=> esc_html__( 'ID', 'bricksultimate' ),
				'author' 	=> esc_html__( 'Author', 'bricksultimate' ),
				'title' 	=> esc_html__( 'Title', 'bricksultimate' ),
				'name' 		=> esc_html__( 'Name', 'bricksultimate' ),
				'date' 		=> esc_html__( 'Published Date', 'bricksultimate' ),
				'modified' 	=> esc_html__( 'Modified Date', 'bricksultimate' ),
				'rand' 		=> esc_html__( 'Random', 'bricksultimate' ),
				'menu_order' => esc_html__( 'Menu Order', 'bricksultimate' ),
			],
			'required' 	=> [ 'buQueryTpes', '=', ['wishlist', 'compare', 'mbrel'] ],
		];

		$bucontrols['pyOrder'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Order' ),
			//'default' 	=> 'DESC',
			'placeholder' => 'DESC',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'ASC' 	=> esc_html__( 'ASC' ),
				'DESC' 	=> esc_html__( 'DESC' )
			],
			'required' 	=> [ 'buQueryTpes', '=', [ 'postyear', 'wishlist', 'compare', 'mbrel' ] ],
		];

		$array_search = absint( array_search( 'query', array_keys( $controls ) ) );
		$controls = array_slice( $controls, 0, $array_search + 1, true ) + $bucontrols + array_slice( $controls, $array_search + 1, null, true );

		return $controls;
	}

	/**
	 * Adds controls for Woo query builder
	 * 
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	private function add_woo_controls( $controls ) {
		$woocontrols['wooQueryTpes'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Woo query type', 'bricksultimate'),
			'options' 	=> [
				'none' 		=> esc_html__('Select query type', 'bricksultimate'),
				'product' 	=> esc_html__('Products', 'bricksultimate'),
				'bestsell' 	=> esc_html__('Best Selling Products', 'bricksultimate'),
				'coupons' 	=> esc_html__('Coupons', 'bricksultimate'),
				'corders' 	=> esc_html__('Customer Orders', 'bricksultimate'),
				'corditem' 	=> esc_html__('Customer Ordered Items', 'bricksultimate'),
				'featured' 	=> esc_html__('Featured Products', 'bricksultimate'),
				'onsale' 	=> esc_html__('On-Sale Products', 'bricksultimate'),
				'upsells' 	=> esc_html__('Product Upsells', 'bricksultimate'),
				'csells' 	=> esc_html__('Product Cross-sells', 'bricksultimate'),
				'related' 	=> esc_html__('Related Products (Single Product Page)', 'bricksultimate'),
				'toprated' 	=> esc_html__('Top Rated Products', 'bricksultimate'),
				'recently' 	=> esc_html__('Recently Viewed Products', 'bricksultimate'),
				'bacs' 		=> esc_html__('Bank Details', 'bricksultimate')
			],
			'default' 	=> 'none',
			'required' 	=> [ [ 'hasLoop', '=', true ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['productType'] = [
			'type' 			=> 'select',
			'label' 		=> esc_html__('Product types', 'bricksultimate'),
			'options' 		=>  array_merge( 
				[ 'all' => esc_html__('All types(exclude variation)', 'bricksultimate') ], 
				\wc_get_product_types(), 
				[ 'variation' => esc_html__('Variation product', 'bricksultimate') ], 
			),
			'default' 		=> [ 'all' ],
			'placeholder' 	=> 'all',
			'multiple' 		=> true,
			'required' 		=> [ [ 'wooQueryTpes', '=', 'product' ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['productStatus'] = [
			'type' 			=> 'select',
			'label' 		=> esc_html__('Status', 'bricksultimate'),
			'options' 		=> array( 
				'draft' 	=> esc_html__('draft', 'wrodpress'), 
				'pending' 	=> esc_html__('pending', 'wrodpress'),
				'private' 	=> esc_html__('private', 'wrodpress'), 
				'publish' 	=> esc_html__('publish', 'wrodpress'), 
			),
			'default' 		=> [ 'publish' ],
			'placeholder' 	=> 'publish',
			'inline' 		=> true,
			'multiple' 		=> true,
			'required' 		=> [ [ 'wooQueryTpes', '=', 'product' ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['productsNumber'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Number of items to show', 'bricksultimate'),
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'default' 	=> 3,
			'placeholder' => '3',
			'required' => [ [ 'wooQueryTpes', '!=', [ '', 'none', 'corders', 'corditem', 'bacs' ] ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['include'] = [
			'tab'         => 'content',
			'type'        => 'select',
			'label'       => esc_html__( 'Include', 'bricks' ),
			'optionsAjax' => [
				'action'   => 'bricks_get_posts',
				'postType' => 'product',
			],
			'multiple'    => true,
			'searchable'  => true,
			'required'    => [ [ 'wooQueryTpes', '=', 'product' ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['exclude'] = [
			'tab'         => 'content',
			'type'        => 'select',
			'label'       => esc_html__( 'Exclude', 'bricks' ),
			'optionsAjax' => [
				'action'   => 'bricks_get_posts',
				'postType' => 'product',
			],
			'multiple'    => true,
			'searchable'  => true,
			'required'    => [ [ 'wooQueryTpes', '=', 'product' ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['category_ids'] = [
			'tab'  		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Category(IDs)', 'bricksultimate' ),
			'info' 		=> esc_html__('Comma separated category ids', 'bricksultimate'),
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'related', 'upsells', 'csells', 'coupons', 'corders', 'corditem', 'bacs' ] ], 
				[ 'query.objectType', '=', 'wooQuery' ] 
			],
		];

		$woocontrols['cat_operator'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Category operator', 'bricksultimate' ),
			'info' 		=> esc_html__('Operator to compare categories', 'bricksultimate'),
			'placeholder' => 'IN',
			'medium' 	=> true,
			'inline' 	=> true,
			'default' 	=> 'IN',
			'options' 	=> [
				'IN' 		=> esc_html__( 'IN' ),
				'AND' 		=> esc_html__( 'AND' ),
				'NOT IN' 	=> esc_html__( 'NOT IN' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'related', 'upsells', 'csells', 'coupons', 'corders', 'corditem', 'bacs' ] ], 
				[ 'query.objectType', '=', 'wooQuery' ] 
			]
		];

		$woocontrols['postParent'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Parent', 'bricks' ),
			'description' => esc_html__( 'Fetching all variations of a variable product on single product page', 'bricksultimate'),
			'hasDynamicData' => true,
			'required'    => [ [ 'wooQueryTpes', '=', 'product' ], [ 'query.objectType', '=', 'wooQuery' ] ]
		];

		$woocontrols['outofstock'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Hide out of stock products', 'bricksultimate' ),
			'placeholder' => 'Yes',
			'default' 	=> 'yes',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'yes' 	=> esc_html__( 'Yes' ),
				'no' 	=> esc_html__( 'No' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'toprated', 'related', 'coupons', 'corders', 'corditem', 'bacs' ] ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['show_hidden'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Show hidden products', 'bricksultimate' ),
			'default' 	=> 'no',
			'placeholder' => 'No',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'yes' 	=> esc_html__( 'Yes' ),
				'no' 	=> esc_html__( 'No' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'toprated', 'related', 'coupons', 'corders', 'corditem', 'bacs' ] ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['hide_free'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Hide free products', 'bricksultimate' ),
			'default' 	=> 'no',
			'placeholder' => 'No',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'yes' 	=> esc_html__( 'Yes' ),
				'no' 	=> esc_html__( 'No' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'toprated', 'related', 'coupons', 'corders', 'corditem', 'bacs' ] ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['order_by'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Order by', 'bricks' ),
			'default' 	=> 'date',
			'placeholder' => 'Date',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'date' 		=> __('Date', 'woocommerce' ),
				'price' 	=> __('Price', 'woocommerce' ),
				'rand' 		=> __('Random', 'woocommerce' ),
				'sales' 	=> __('Sales', 'woocommerce' ),
				'ID' 		=> __('ID', 'woocommerce' ),
				'title' 	=> __('Title', 'woocommerce' ),
				'name' 		=> __('Name', 'woocommerce' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'toprated', 'bestsell', 'related', 'recently', 'coupons', 'corders', 'corditem', 'bacs' ] ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		//* Woo Orders start
		$woocontrols['ordersType'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Type'),
			'default' 	=> 'all',
			'placeholder' => esc_html__( 'All', 'bricksultimate' ),
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'all' 				=> esc_html__( 'All', 'bricksultimate' ),
				'shop_order' 		=> esc_html__( 'Orders', 'woocommerce' ),
				'shop_order_refund' => esc_html__( 'Refund Orders', 'bricksultimate' ),
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'corders' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['ordersStatus'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Status'),
			'placeholder' => esc_html__( 'All', 'bricksultimate' ),
			'multiple' 	=> true,
			'inline' 	=> true,
			'options' 	=> \wc_get_order_statuses(),
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'corders' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['ordersCustomer'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Customer'),
			'default' 	=> 'logged_in',
			'options' 	=> [
				'all' 		=> esc_html__( 'All customers', 'bricksultimate' ),
				'logged_in' => esc_html__( 'Currently logged in user', 'bricksultimate' ),
				'custom' 	=> esc_html__( 'Custom user', 'bricksultimate' ),
			],
			'inline' 	=> true,
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'corders' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['customCustomer'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('User ID'),
			'hasDynamicData' => true,
			'inline' 	=> false,
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'corders' ],
				[ 'query.objectType', '=', 'wooQuery' ],
				[ 'ordersCustomer', '=', 'custom' ]
			],
		];
		//* Woo Orders end

		$woocontrols['order'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Order' ),
			'default' 	=> 'DESC',
			'placeholder' => 'DESC',
			'medium' 	=> true,
			'inline' 	=> true,
			'options' 	=> [
				'ASC' 	=> esc_html__( 'ASC' ),
				'DESC' 	=> esc_html__( 'DESC' )
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '!=', [ '', 'none', 'toprated', 'bestsell', 'recently', 'corditem', 'bacs' ] ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['productMeta'] = [
			'label'         => esc_html__('Meta Query', 'bricksultimate'),
			'type'          => 'repeater',
			'titleProperty' => 'metaKey',
			'placeholder'   => esc_html__('Meta Query', 'bricksultimate'),
			'fields'        => [
				'metaKey' => [
					'label'       => esc_html__( 'Meta key', 'bricks' ),
					'type'        => 'text',
				],
				'metaValue'      => [
					'label'       => esc_html__( 'Meta value', 'bricks' ),
					'type'        => 'text',
					'hasDynamicData' => true
				],
				'compare' => [
					'type' 		=> 'select',
					'label' 	=> esc_html__('Compare', 'bricksultimate'),
					'inline' 	=> true,
					'options' 	=> [
						'=' => esc_html__('Equal', 'bricks'), 
						'!=' => esc_html__('Not equal', 'bricks'), 
						'>' => esc_html__('Greater than', 'bricks'), 
						'>=' => esc_html__('Greater than or equal', 'bricks'), 
						'<' => esc_html__('Lesser', 'bricks'), 
						'<=' => esc_html__('Lesser or equal', 'bricks'), 
						'LIKE' => 'LIKE', 
						'NOT LIKE' => 'NOT LIKE', 
						'IN' => 'IN', 
						'NOT IN' => 'NOT IN', 
						'BETWEEN' => 'BETWEEN', 
						'NOT BETWEEN' => 'NOT BETWEEN', 
						'EXISTS' => 'EXISTS', 
						'NOT EXISTS' => 'NOT EXISTS'
					],
					'default' => '='
				],
				'type' => [
					'type' 		=> 'select',
					'label' 	=> esc_html__('Type', 'bricksultimate'),
					'inline' 	=> true,
					'options' 	=> [
						'NUMERIC' 	=> 'NUMERIC', 
						'BINARY' 	=> 'BINARY', 
						'CHAR' 		=> 'CHAR', 
						'DATE' 		=> 'DATE', 
						'DATETIME' 	=> 'DATETIME', 
						'DECIMAL' 	=> 'DECIMAL', 
						'SIGNED' 	=> 'SIGNED', 
						'TIME' 		=> 'TIME', 
						'UNSIGNED' 	=> 'UNSIGNED'
					],
					'default' => 'CHAR'
				]
			],
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'product' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['expiry_coupons'] = [
			'tab'  		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Get only expiry coupons', 'bricksultimate' ),
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'coupons' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		$woocontrols['exclude_expiry_coupons'] = [
			'tab'  		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Exclude expiry coupons', 'bricksultimate' ),
			'default' 	=> true,
			'required' 	=> [ 
				[ 'wooQueryTpes', '=', 'coupons' ],
				[ 'query.objectType', '=', 'wooQuery' ]
			],
		];

		//* Woo Orders
		$woocontrols['ordersLimit'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Orders per page', 'bricksultimate'),
			'min' 		=> 1,
			'max' 		=> 100,
			'unitless' 	=> false,
			'step' 		=> 1,
			'placeholder' => '10',
			'required' => [ 
				[ 'wooQueryTpes', '=', 'corders' ], 
				[ 'query.objectType', '=', 'wooQuery' ] 
			]
		];
		
		//* Woo Order Items
		$woocontrols['orderId'] = [
			'tab'  		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Order ID', 'bricksultimate'),
			'unitless' 	=> false,
			'placeholder' => 366,
			'hasDynamicData' => true,
			'required' => [ 
				[ 'wooQueryTpes', '=', 'corditem' ], 
				[ 'query.objectType', '=', 'wooQuery' ] 
			]
		];
		
		$array_search = absint( array_search( 'query', array_keys( $controls ) ) );
		$controls = array_slice( $controls, 0, $array_search + 1, true ) + $woocontrols + array_slice( $controls, $array_search + 1, null, true );

		return $controls;
	}
}