<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WooCheckoutFieldControls {
	// Set builder control groups
	public function bu_checkout_field_control_groups( $control_groups ) {
		$control_groups['fwrapper'] = [
			'title' 	=> esc_html__( 'Field Wrapper', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' => ['field_design', '!=', 'bu-default']
		];

		$control_groups['label'] = [
			'title' 	=> esc_html__( 'Label', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' => ['billing_field', '!=', 'createaccount']
		];

		$control_groups['description'] = [
			'title' 	=> esc_html__( 'Description', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' => ['billing_field', '!=', 'createaccount']
		];

		$control_groups['input'] = [
			'title' 	=> esc_html__( 'Input Fields', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['field_type', '!=', [ 'radio', 'checkbox' ] ]
		];

		$control_groups['radio'] = [
			'title' 	=> esc_html__( 'Radio', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['field_type', '=', 'radio']
		];

		$control_groups['checkbox'] = [
			'title' 	=> esc_html__( 'Checkbox', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> [ 'field_type', '=', 'checkbox' ],
		];

		$control_groups['acc_checkbox'] = [
			'title' 	=> esc_html__( 'Checkbox', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> [ 'billing_field', '=', 'createaccount' ],
		];

		return $control_groups;
	}

	public function bu_checkout_fields_controls( $controls, $prefix='', $selector='', $return = true ) {
		$controls['field_type'] = [
			'type' 	=> 'select',
			'label' => esc_html__( 'Field type', 'bricksultimate' ),
			'options' => [
				'text' 				=> esc_html__('Text', 'bricksultimate'),
				'textarea' 			=> esc_html__('Textarea', 'bricksultimate'),
				'password' 			=> esc_html__('Password', 'bricksultimate'),
				'number' 			=> esc_html__('Number', 'bricksultimate'),
				'email' 			=> esc_html__('Email', 'bricksultimate'),
				'url' 				=> esc_html__('URL', 'bricksultimate'),
				'tel' 				=> esc_html__('Phone / Tel', 'bricksultimate'),
				'hidden' 			=> esc_html__('Hidden', 'bricksultimate'),
				'radio' 			=> esc_html__('Radio', 'bricksultimate'),
				'checkbox' 			=> esc_html__('Checkbox', 'bricksultimate'),
				'select' 			=> esc_html__('Select', 'bricksultimate'),
				//'datetime' 			=> esc_html__('Datetime', 'bricksultimate'),
				//'datetime-local' 	=> esc_html__('Datetime-local', 'bricksultimate'),
				'date' 				=> esc_html__('Date', 'bricksultimate'),
				'month' 			=> esc_html__('Month', 'bricksultimate'),
				'time' 				=> esc_html__('Time', 'bricksultimate'),
				'week' 				=> esc_html__('Week', 'bricksultimate'),
			],
			'rerender' => true,
			'required' => [ $prefix . '_field', '=', 'custom']
		];

		$controls['field_key'] = [
			'type' 	=> 'text',
			'label' => esc_html__( 'Field key', 'bricksultimate' ),
			'placeholder' => $prefix . '_my_field',
			'description' => 'Enter field key like ' . $prefix . '_myfield',
			'rerender' => true,
			'required' => [ $prefix . '_field', '=', 'custom']
		];

		$controls['rows'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Rows', 'bricksultimate' ),
			'inline' => true,
			'unitless' => true,
			'placeholder' => 2,
			'required' => [ 'field_type', '=', 'textarea']
		];

		$controls['cols'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Cols', 'bricksultimate' ),
			'inline' => true,
			'unitless' => true,
			'placeholder' => 5,
			'required' => [ 'field_type', '=', 'textarea']
		];

		$controls['maxlength'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Max. length', 'bricksultimate' ),
			'inline' => true,
			'unitless' => true,
			'placeholder' => 10,
			'required' => [ 'field_type', '=', [ 'number', 'tel', 'password'] ]
		];

		$controls['fieldOptions'] = [
			'type' 		=> 'textarea',
			'label' 	=> esc_html__( 'Options', 'bricksultimate' ),
			'placeholder' => 'key:value',
			'description' => esc_html__('Per line add one option', 'bricksultimate'),
			'required' 	=> [ 'field_type', '=', ['select', 'radio'] ]
		];

		$controls['hiddenValue'] = [
			'type' 	=> 'text',
			'label' => esc_html__( 'Default value', 'bricksultimate' ),
			'required' => [ 'field_type', '=', ['hidden', 'select', 'radio'] ]
		];

		$controls['minlength'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Min. length', 'bricksultimate' ),
			'inline' => true,
			'unitless' => true,
			'placeholder' => 5,
			'required' => [ 'field_type', '=', [ 'number', 'tel', 'password'] ]
		];

		$controls['isChecked'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Checked by default', 'bricksultimate' ),
			'required' 	=> [ 'field_type', '=', 'checkbox' ],
		];

		$controls['accIsChecked'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Checked by default', 'bricksultimate' ),
			'required' 	=> [ 'billing_field', '=', 'createaccount' ]
		];

		$controls['valueShipDiff'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Is checked?', 'bricksultimate' ),
			'required' 	=> [ 'shipping_field', '=', 'ship_to_diff' ],
		];

		$controls['hideShipDiff'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Will hide this field?', 'bricksultimate' ),
			'required' 	=> [ 'shipping_field', '=', 'ship_to_diff' ]
		];

		$controls['hideAccountFields'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Will hide this field?', 'bricksultimate' ),
			'required' 	=> [ 'billing_field', '=', 'createaccount' ]
		];

		$controls['willHide'] = [
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Will hide this field?', 'bricksultimate' ),
			'required' 	=> [ 'field_type', '=', 'checkbox' ],
		];

		$controls['aria_label'] = [
			'type' 	=> 'text',
			'label' => esc_html__( 'Aria label', 'bricksultimate' ),
			'required' => [ $prefix . '_field', '!=', 'createaccount' ]
		];

		$controls['field_design'] = [
			'type'      => 'select',
			'label'     => esc_html__( 'Field design', 'bricksultimate' ),
			'options'   => [ 'bu-default' => esc_html__('Default'), 'bu-custom' => esc_html__('Custom') ],
			'default' 	=> 'bu-default',
			'inline'    => true,
			'placeholder' => esc_html__( 'Select design', 'bricksultimate' ),
			'required' => [ $prefix . '_field', '!=', 'createaccount' ]
		];

		$controls['acc_labelTg'] = [
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.create-account'
				]
			],
			'required' => [ $prefix . '_field', '=', 'createaccount' ]
		];

		$controls['optional'] = [
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Optional', 'bricksultimate' ),
			'required' => [ $prefix . '_field', '!=', [ 'order_comments' , 'createaccount' ] ]
		];

		$controls['isMandatory'] = [
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Make mandatory', 'bricksultimate' ),
			'required' => ['shipping_field', '=', 'order_comments']
		];

		$controls['hideErrorMsg'] = [
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.checkout-inline-error-message',
					'value' 	=> 'none'
				]
			]
		];

		$controls['errorMsg'] = [
			'type' 	=> 'typography',
			'label' => esc_html__( 'Inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.checkout-inline-error-message'
				]
			],
			'required' => ['hideErrorMsg', '!=', true]
		];

		/**
		 * Wrapper
		 * ----------------------------------------*/
		$selector = '.form-row';
		$controls['fwMrg'] = [
			'group' => 'fwrapper',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			]
		];

		$controls['fwPad'] = [
			'group' => 'fwrapper',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$controls['fwBG'] = [
			'group' => 'fwrapper',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$controls['fwBorder'] = [
			'group' => 'fwrapper',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$controls['fwBS'] = [
			'group' => 'fwrapper',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			]
		];

		/**
		 * Label
		 * ----------------------------------------*/
		$selector = '.form-row label:not(.radio)';

		$controls['labelDisable'] = [
			'group' => 'label',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide label', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector,
					'value' 	=> 'none'
				]
			]
		];

		$controls['labelAsterisk'] = [
			'group' => 'label',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide asterisk', 'bricksultimate' ),
			'css'	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> 'abbr[title]',
					'value' 	=> 'none'
				]
			],
		];

		$controls['label'] = [
			'group' => 'label',
			'type' 	=> 'text',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'rerender' => true,
			'required' => ['labelDisable', '=', false]
		];

		$controls['labelTg'] = [
			'group' => 'label',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
			'required' => ['labelDisable', '=', false]
		];

		$controls['labelBg'] = [
			'group' => 'label',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
			'required' => [ ['labelDisable', '=', false], ['field_design', '!=', 'bu-default'] ]
		];

		$controls['labelMrg'] = [
			'group' => 'label',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
			'required' => [ ['labelDisable', '=', false], ['field_design', '!=', 'bu-default'] ]
		];

		$controls['labelPad'] = [
			'group' => 'label',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
			'required' => [ ['labelDisable', '=', false], ['field_design', '!=', 'bu-default'] ]
		];

		$controls['labelW'] = [
			'group' => 'label',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
			'required' => [ ['labelDisable', '=', false], ['field_design', '!=', 'bu-default'] ]
		];

		$controls['labelSep'] = [
			'group' => 'label',
			'type' 	=> 'separator',
			'required' => ['labelDisable', '=', false]
		];

		$controls['placeholder'] = [
			'group' => 'label',
			'type' 	=> 'text',
			'label' => esc_html__( 'Placeholder text', 'bricksultimate' ),
		];

		$controls['labelP'] = [
			'group' => 'label',
			'type' 	=> 'color',
			'label' => esc_html__( 'Placeholder color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "::placeholder"
				]
			]
		];

		/**
		 * Description
		 * ----------------------------------------*/
		$controls['field_description'] = [
			'group' => 'description',
			'type' 	=> 'textarea',
			'label' => esc_html__( 'Field description', 'bricksultimate' ),
		];

		$selector = '.form-row .description';

		$controls['fdesTg'] = [
			'group' => 'description',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$controls['fdesBg'] = [
			'group' => 'description',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$controls['fdesMrg'] = [
			'group' => 'description',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			]
		];

		$controls['fdesPad'] = [
			'group' => 'description',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$controls['fdesW'] = [
			'group' => 'description',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		/**
		 * Fields
		 * ----------------------------------------*/
		$selector = 'input:not([type=submit]), .select2-selection, select';
		$selector2 = 'input:not([type=submit]), .select2-selection, select, textarea';
		$selector_f = 'input:not([type=submit]):focus, .select2-selection:focus, select:focus, textarea:focus';

		$controls['fieldTg'] = [
			'group' => 'input',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector2
				],
				[
					'property' => 'font',
					'selector' => ".select2-container .select2-selection__rendered"
				],
			]
		];

		$controls['fieldBg'] = [
			'group' => 'input',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector2
				]
			]
		];

		$controls['fieldBrd'] = [
			'group' => 'input',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector2
				]
			]
		];

		$controls['fieldBs'] = [
			'group' => 'input',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector2
				]
			]
		];

		$controls['fieldFSep'] = [
			'group' => 'input',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Focus', 'bricksultimate' ),
		];

		$controls['fieldFColor'] = [
			'group' => 'input',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $selector_f
				]
			]
		];

		$controls['fieldFBg'] = [
			'group' => 'input',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector_f
				]
			]
		];

		$controls['fieldFBrd'] = [
			'group' => 'input',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector_f
				]
			]
		];

		$controls['fieldFBs'] = [
			'group' => 'input',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector_f
				]
			]
		];

		$controls['fieldSep'] = [
			'group' => 'input',
			'type' 	=> 'separator',
		];

		$controls['fieldPad'] = [
			'group' => 'input',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => ""
				]
			],
			'required' => ['field_design', '!=', 'bu-default']
		];

		$controls['fieldW'] = [
			'group' => 'input',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$controls['fieldH'] = [
			'group' => 'input',
			'type' 	=> 'number',
			'label' => esc_html__( 'Height', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];


		/**
		 * Radio
		 * ----------------------------------------*/
		$controls['radioLabel'] = [
			'group' => 'radio',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.bu-radio-buttons label'
				]
			],
		];

		$controls['radioW'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'label' => esc_html__( 'Label width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'width',
					'selector' => '.bu-radio-buttons label'
				]
			],
		];

		$controls['radioSep'] = [
			'group' => 'radio',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Radio button', 'bricksultimate' ),
		];

		$rd_selector = '.bu-radio-buttons input[type=radio]';

		$controls['rdsize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$controls['rdbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
		];

		$controls['rdbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			]
		];

		$rdc_checked = '.bu-radio-buttons input[type=radio]:checked';
		$controls['rdcbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
		];

		$controls['rdcbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rdc_checked,
				]
			]
		];

		$bullet = '.bu-radio-buttons input[type=radio]:checked:after';
		$controls['rdwrdsz'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $bullet
				],
				[
					'property' => 'height',
					'selector' => $bullet
				]
			],
		];

		$controls['rdwrdsz'] = [
			'group' 	=> 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $bullet
				]
			],
		];

		$controls['rdBulletPos'] = [
			'group' 	=> 'radio',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
		];

		/**
		 * Checkbox
		 * ----------------------------------------*/
		$cb_selector = '.bu-checkbox-buttons input[type=checkbox]';

		$controls['cbsize'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'height',
					'selector' => $cb_selector,
				]
			],
		];

		$controls['cbbg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_selector,
				]
			],
		];

		$controls['cbbrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_selector,
				]
			]
		];

		$cb_checked = '.bu-checkbox-buttons input[type=checkbox]:checked';
		$controls['cbcbg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_checked,
				]
			],
		];

		$controls['cbcbrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_checked,
				]
			]
		];

		if( $return )
			return $controls;
	}
}