<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WooElementsControls {

	/**
	 * Enhance the product up/cross sells element's contorls
	 * 
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	public function bu_product_common_controls( $controls ) {
		$controls['alignment'] = [
			'tab'      => 'content',
			'type'     => 'select',
			'label'    => esc_html__( 'Content alignment', 'bricksultimate' ),
			'options'  => [
				'left'  	=> esc_html__('Left'),
				'right' 	=> esc_html__('Right'),
				'center' 	=> esc_html__('Center')
			],
			'inline' => true,
			'css'      => [
				[
					'property'  => 'text-align',
					'selector' 	=> '.products .woocommerce-LoopProduct-link',
				]
			]
		];

		/**
		 * Product layout
		 */
		$controls['display'] = [
			'tab'         => 'content',
			'group'       => 'layout',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => '.products .product',
				],
			],
			'default' => 'flex',
		];

		$controls['flexWrap'] = [
			'tab'         => 'content',
			'group' => 'layout',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => \Bricks\Setup::get_control_options('flexWrap'),
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
					'selector' => '.products .product',
				],
			],
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$controls['direction'] = [
			'tab'      => 'content',
			'group'    => 'layout',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
					'selector' => '.products .product',
				],
			],
			'default'  => 'column',
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];


		/**
		 * Product Title
		 */
		$selector = '.woocommerce-loop-product__title';

		$controls['titleMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				],
			],
		];

		$controls['titleTypography'] = [
			'tab'      => 'content',
			'group'    => 'title',
			'type'     => 'typography',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'css'      => [
				[
					'property'  => 'font',
					'selector' 	=> $selector
				]
			]
		];

		$controls['titleHoverColor'] = [
			'tab'      => 'content',
			'group'    => 'title',
			'type'     => 'color',
			'label'    => esc_html__( 'Hover color', 'bricksultimate' ),
			'css'      => [
				[
					'property'  => 'color',
					'selector' 	=> $selector . ':hover',
				]
			]
		];

		/**
		 * Price
		 */
		$controls['hideRegularPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Hide strick through price', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'selector' => 'del',
					'property' => 'display',
					'value'    => 'none',
				],
			]
		];

		$controls['productPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Price', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.price .amount',
					'property' => 'font',
				]
			]
		];

		$controls['regularPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Strick through price', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' 	=> 'del',
					'property' 	=> 'font'
				],
				[
					'selector' => '.price del .amount',
					'property' => 'font',
				],
			]
		];


		//* add to cart button
		$selector = ".button";

		$controls['buttonBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['buttonWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		unset( $controls['buttonPadding'] );

		$controls['buttonMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['buttonPadding'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'selector' => '.button',
					'property' => 'padding',
				],
			],
		];

		$controls['atcBtnHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['atcBtnHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverColor'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];


		/**
		 * Sale badge
		 */
		$selector = '.badge.onsale';

		$controls['saleBadgeWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['saleBadgeHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'Height',
					'selector' => $selector,
				],
				[
					'property' => 'line-height',
					'selector' => $selector,
				]
			],
		];

		$controls['saleBadgeBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeTypography'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeBorder'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeSpacing'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Sapcing', 'bricks' ),
		];

		$controls['_sbMrginInfo'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'type'  => 'info',
			'content' => esc_html__('Set margin-top: 0, if you want to move the sale badge to the right side.', 'bricksultimate')
		];

		$controls['saleBadgeMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'default' 	=> [
				'top' 	=> 32
			],
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.badge+.badge'
				],
			],
		];

		$controls['saleBadgePadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['saleBadgeSepPos'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Positioning', 'bricks' ),
		];

		$controls['_sbTop'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbRight'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbBottom'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbLeft'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbLeftInfo'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'type'  => 'info',
			'content' => esc_html__('Set left value is auto, if you want to move the new badge to the right side.', 'bricksultimate')
		];

		$controls['_sbzIndex'] = [
			'tab'         => 'content',
			'group'       => 'saleBadge',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => $selector,
				],
			],
			'min'         => -999,
			'placeholder' => 0,
		];


		/**
		 * New badge button
		 */
		$selector = '.badge.new';

		$controls['newBadgeWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['newBadgeHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'Height',
					'selector' => $selector,
				],
				[
					'property' => 'line-height',
					'selector' => $selector,
				]
			],
		];

		$controls['newBadgeBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeTypography'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeBorder'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				],
			],
		];
 
		$controls['newBadgeSepPos'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Positioning', 'bricks' ),
		];

		$controls['_nbTop'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbRight'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbBottom'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbLeft'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbLeftInfo'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'type'  => 'info',
			'content' => esc_html__('Set left value is auto, if you want to move the new badge to the right side.', 'bricksultimate')
		];

		$controls['_nbzIndex'] = [
			'tab'         => 'content',
			'group'       => 'newBadge',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => $selector,
				],
			],
			'min'         => -999,
			'placeholder' => 0,
		];

		return $controls;
	}

}