<?php
defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_mini_cart' ); ?>

<?php if ( ! is_null( WC()->cart ) && ! WC()->cart->is_empty() ) : ?>

	<ul class="woocommerce-mini-cart cart_list product_list_widget <?php echo esc_attr( $args['list_class'] ); ?>">
		<?php
		do_action( 'woocommerce_before_mini_cart_contents' );

		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

			if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
				$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
				$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );

				$removeItem = "yes";
				$class = '';
				if( isset( $cart_item['_buob_bump_id'] ) ) {
					$removeItem = get_post_meta( $cart_item['_buob_bump_id'], '_buob_enable_remove_button', true ) ?? "no";
					$has_quantity_field = get_post_meta( $cart_item['_buob_bump_id'], '_buob_has_quantity_field', true ) ?? "no";

					$class = "bu-order-bump-item ";
				}
				?>
				<li class="woocommerce-mini-cart-item <?php echo $class; echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>" data-key="<?php echo $cart_item_key; ?>">
					<div class="product-image">
						<?php if ( empty( $product_permalink ) ) : ?>
							<?php echo $thumbnail; ?>
						<?php else : ?>
							<a href="<?php echo esc_url( $product_permalink ); ?>">
								<?php echo $thumbnail; ?>
							</a>
						<?php endif; ?>
					</div>
					<div class="product-content">
						<div class="product-title">
							<?php if ( empty( $product_permalink ) ) : ?>
								<?php echo $product_name; ?>
							<?php else : ?>
								<a href="<?php echo esc_url( $product_permalink ); ?>" class="product-title--link">
									<?php echo $product_name; ?>
								</a>
							<?php endif; ?>
							<?php
								if( $removeItem == "yes" ) {
									echo apply_filters(
										'woocommerce_cart_item_remove_link',
										sprintf(
											'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">%s</a>',
											esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
											esc_attr__( 'Remove this item', 'woocommerce' ),
											esc_attr( $product_id ),
											esc_attr( $cart_item_key ),
											esc_attr( $_product->get_sku() ),
											apply_filters('bu_remove_icon', '&times;', $cart_item)
										),
										$cart_item_key
									);
								}
							?>
						</div>
						<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
						<?php 
							echo '<div class="brxe-bu-cart-item-qty" data-cart_item_key="'.$cart_item_key.'" data-product_id="' . $product_id . '">';

							if( isset( $cart_item['_buob_bump_id'] ) && $has_quantity_field && $has_quantity_field == "yes" ) {
								echo \BricksUltimate\WooCommerce::minCartQty($cart_item['data'], $cart_item, $cart_item_key);
							} 

							if( ! isset( $cart_item['_buob_bump_id'] ) ) {
								echo \BricksUltimate\WooCommerce::minCartQty($cart_item['data'], $cart_item, $cart_item_key);
							}

							echo $product_price . "</div>";
						?>
					</div>
				</li>
				<?php
			}
		}

		do_action( 'woocommerce_mini_cart_contents' );
		?>
	</ul>

	<?php do_action( 'woocommerce_mini_cart_before_cart_total' ); ?>

	<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

	<?php do_action( 'woocommerce_widget_shopping_cart_after_buttons' ); ?>

<?php else : ?>

	<p class="woocommerce-mini-cart__empty-message"><?php esc_html_e( 'No products in the cart.', 'woocommerce' ); ?></p>

<?php endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' ); ?>
