### BricksUltimate Plugin

Contributors: bricksultimate

Tags: page builder, editor, visual editor, design, website builder, front-end builder

Requires at least: 5.0.0

Tested up to: 6.4.2

Stable tag: 1.5.2

Requires PHP: 7.4

BricksUltimate is a third-party add-on for Bricks Page Builder which is built by [Paul Chinmoy](https://paulchinmoy.com), the creator of famous Oxygen Plugin [OxyUltimate](https://oxyultimate.com/), this plugin brings in addition to its free version, tools which are meant to help users build their WordPress websites in no-time.

Below are listed the core competencies

General Elements
----------------
* Accordion Menu
* Animated Burger
* Back To Top
* Breadcrumbs
* Business Hours
* CSS Grid Templates
* Contact Form 7 Styler
* Countdown
* Dual Color Text
* Flex Gallery
* Fluent Forms Styler
* Gravity Forms Styler
* Highlighted Heading
* Image Attachment
* Off Canvas
* Piotnet Forms Styler
* Post Grid
* Reading Progress Bar
* Slider(Nestable) Arrows
* Slider(Nestable) Progress Bar
* Sliding Menu
* Star Ratings
* Table (Grid View)
* WPForms Styler
* WPGB Facet Styler
* WSForms Styler
* Wishlist

Woo Elements
----------------
* Add To Cart
* Add To Cart Icon
* Applied Coupons
* Buy Now Button
* Best Selling Badge
* Cart Counter
* Cart Content
* Coupon Form
* Empty Cart Button
* Free Shipping Notice
* Mini Cart
* New Badge
* Product Image
* Product Ratings
* Sales Badge
* Sold Out Badge

Query Loops provider
----------------
* Best Selling Products
* On-Sale Products
* Featured Products
* Related Products (Single Product Page)
* Top Rated Products
* Cross-sells
* Product Upsells
* WooCommerce Product Gallery
* Custom Query Providers: Adjacent Posts, Author Box, ACF Gallery, Custom WP Query, Custom Taxonomy Query
* Wishlist Items

Documentation and Support
----------------
For documentation and tutorials visit our [site](https://www.bricksultimate.com)


## Frequently Asked Questions

1. What are the minimum requirements for BricksUltimate?
This plugin requires Bricks Builder to function correctly.

2. Can I use it on my client's websites?
Absolutely! You can use it on your as well as your client's websites. Your clients do not need to purchase their own copy of BricksUltimate.

3. Do you offer refunds?
Yes. You can request a refund within 7 days of purchase. We shall process the refund action if you find that the plugin is not working as it was described or if you are not getting any help from our support team.

4. How many sites can I use BricksUltimate on?
There are no limits. You can use it on an unlimited number of sites.

5. Do you offer a discount on renewals?
No. There is no renewal discount option for the Basic plan.

6. What payment methods do you accept?
We accept payment securely via PayPal or Stripe.

7. Will BricksUltimate stop working after my license expires?
No. You can use it as long as you wish to. You will not get the support and update option from us.

8. Will the license renew automatically?
Yes. Login to the [site](https://www.bricksultimate.com) and follow the procedure.



## Changelog

### 1.5.2 - 2023-12-14

* New feature – Add To Cart notification
* New element – Wishlist. Compatible with CPTs, Posts etc
* New loop builder provider – Wishlist Items
* Fixed – JS issue in Add To Cart Icon element
* Fixed – PHP warnings in Flex Gallery element
* Improved internal coding, typo mistakes etc.

### 1.5.1 - 2023-11-13 

* Modified the Business Hours element
* Fixed - Flex Gallery element. The grid layout is not working properly.
* New loop builder providers - Posts Years and Coupons(woo)
* Added new dynamic tags
* Improved Countdown element. It supports the coupon expiry date.

### 1.5 - 2023-11-09

* New element - Business Hours
* New interactions - Apply coupon, Remove coupon
* New session storage key - applied_coupon_{COUPONCODE}
* New element condition - Is coupon applied?
* Fixed - Post Terms element. Custom SVG file is not showing
* Fixed - Text of Coupon Form element is not translating

### 1.4.8 - 2023-10-3

* New element - Before After Image

### 1.4.7 - 2023-10-31

* Fixed - License is deactivating automatically.
* Fixed - Cart subtotal price is not updating
* New Interaction - Cart is not empty
* Added new element conditions

### 1.4.6 - 2023-10-17

* Hot fix - PHP warnings.
* Added some new element conditions for terms.

### 1.4.5 - 2023-10-17

* Fixed - JS issue in Item Quantity element. Quantity is not updating after clicking on the +/- buttons.
* Fixed - "Is cart empty" element condition is not working.

### 1.4.4 - 2023-10-15

* Fixed - bubble jumping issue in Cart Counter element
* Improved styler options of WPGB Facets Styler element
* Improved theme style options for WSForms Styler element
* Improved internal scripts
* Added - element conditions

### 1.4.3 - 2023-10-09

* Added theme style options for WSForms Styler element
* Fixed - one updated file was missing

### 1.4.2 - 2023-10-07

* Added more styler options in WSForms Styler element
* Improved internal scripts

### 1.4.1 - 2023-10-05

* Fixed - Post classes dynamic tag
* Improved cart item price element
* Improved some internal scripts and other bugs
* New element - WSForms Styler (#1 phase)

### 1.4 - 2023-09-27

* Improved Gravity Forms Styler element
* Improved Fluent Forms Styler element
* Fixed - PHP Fatal errors
* Fixed - Dynamic tags were not working in AJAX 
* New element - WPGB Facets Styler

### 1.3.23 - 2023-09-19

* Fixed - AJAX popup is not working with the WP Grid Builder Facets
* Fixed - Fatal error in Countdown element

### 1.3.22 - 2023-09-14

* Fixed - AJAX popup is not working with load more interaction action

### 1.3.21 - 2023-09-11

* Fixed - JS error in the Off-Canvas element

### 1.3.20 - 2023-09-10

* Fixed - PHP errors in the Countdown element
* Mini Cart will be revealed automatically when the single add-to-cart button is submitted.
* Fixed some other internal PHP errors.

### 1.3.19 - 2023-09-05

* Fixed - PHP Warnings
* Fixed - toggle JS issue in the Countdown element
* Added - "Disable auto close" option for the mini-cart panel in the Off-Canvas element
* Removed query args in Empty Cart button element

### 1.3.18 - 2023-09-04

* Improved Countdown element. It supports the term meta.

### 1.3.17 - 2023-08-25

* Improved Countdown element
* Fixed PHP warnings
* Added a few new element conditions for WooCommerce

### 1.3.16 - 2023-08-24

* New element - **Countdown**
* Added element conditions for WooCommerce

### 1.3.15 - 2023-08-15

* Improved Product Image element. Added Flip and Slider effects for gallery images.
* Added an option **"Disable autoclose(Mobile only)"** for the Mini-Cart reveal effect.

### 1.3.14 - 2023-07-22

* Improved the Breadcrumbs element. it is now supporting the Zynith seo breadcrumbs.
* Improved the Fluent Form Styler component
* Fixed - AJAX popup is not working
* Added Limit option in Accordion and Sliding Menu elements

### 1.3.13 - 2023-06-27

* Fixed - Fatal error when we are using the WooCommerce Composite Product plugin and Mini Cart Builder element
* Improved Fluent Form Styler element. Added the new option for Checkbox and Radio Photo fields
* Improved the Accordion Menu element. Added the styler option for sub-menu items

### 1.3.12 - 2023-06-22

* Fixed - Off Canvas is adding extra padding
* New element - Applied Coupons

### 1.3.11 - 2023-06-20

* Fixed - CSS file of the quantity field is messed up in the Cart Content element
* New element - Coupon Form
* Removed the pagination from the Admin settings page

### 1.3.10 - 2023-06-15

* Hot fix - Compatibility issue with WooCommerce 7.8.0
* Added the breakpoint interaction trigger

### 1.3.9 - 2023-06-14

* New interaction actions - Empty cart, Sync Animated Burger.
* New element - Cart Content
* Added Misc tab link in BricksUltimate admin menu

### 1.3.8 - 2023-06-08

* Fixed - Compatibility issue with Custom WP Query Pagination element and Bricks 1.8+
* Custom Interaction Actions for WooCommerce and Fluent Form
* Lightgallery JS and CSS files are loading from your server. Removed the CDN links.
* Improved the Off-Canvas element

### 1.3.7 - 2023-05-31

* New elements - Slider(Nestable) Arrows and Slider(Nestable) Progress Bar
* Fixed SVG problem in Cart Counter element
* Improved Featued Image related dynmaic tags(title, alt and caption)

### 1.3.6 - 2023-05-27

* New element - Quantity for Add To Cart button
* New element controls - Styler of the View Cart button in Add To Cart element

### 1.3.5 - 2023-05-26

* New element - Add To Cart Icon
* New dynamic tags - Term has children

### 1.3.4 - 2023-05-22

* New loop builders - ACF Checkbox
* New dynamic tags - ACF Checkbox Value, ACF Checkbox Label

### 1.3.3 - 2023-05-19

* New loop builders - ACF Post Object, Metabox Checkbox List
* Fixed - Author Box loop builder messed up the WP Query
* FIxed - Product variations form was not working in AJAX popup
* Fixed - Ultimate Woo Query conditions

### 1.3.2 - 2023-05-09

* Fixed - CSS for Admin bar -> Ultimate menu item
* Improved JS code in mini-cart builder
* New element - Post Grid. You can easily make the grid layout with the loop builder now. It is using the CSS Grid.

### 1.3.1 - 2023-05-06

* Fixed - Admin bar is messing up the builder editor layout.

### 1.3 - 2023-05-05

* Fixed JS issue in Add To Cart and Mini Cart Builder element
* New element - Breadcrumbs
* Adds some new dynamic tags

### 1.2.9 - 2023-04-30

* Fixed PHP warning
* Improved the WP Menu custom loop builder

### 1.2.8 - 2023-04-27

* Fixed PHP warning
* Fixed JS issue in Table (grid view) element

### 1.2.7 - 2023-04-19

* Fixed Off Canvas element - Off Convas content is not visible when "Push body content" option is enabled
* New element - Reading Progress Bar
* New element - CSS Grid Templates

### 1.2.6 - 2023-04-14

* Updated - JS codes of AJAX Popup feature
* Fixed - Resolution option is not working in Image Attachment element
* New element - Nestable Table (Grid View)

### 1.2.5 - 2023-04-06

* Fixed - PHP errors
* Added some new custom dynamic data tags
* New element - Nestable Back To Top button

### 1.2.4 - 2023-03-28

* Fixed - Free Shipping Notice element.
* Fixed - Upsells and Cross-sells custom query builder.
* Fixed - CSS problem in Off-Canvas element.
* Fixed - some other small internal issues.

### 1.2.3 - 2023-03-17

* Fixed - JS issue in Sliding Menu elements. Menu items from 2nd level is not showing.

### 1.2.2 - 2023-03-15

* New dynamic tag - {bu_post_id}. It is giving the post ID when you are using the custom query loop builder.
* New element - Star Ratings
* Improved the Item Quantity element for Mini Cart builder

### 1.2.1 - 2023-03-07

* Bug Fixed - Cart quantity is not showing

### 1.2 - 2023-02-26

* Fixed - Style issue in Add To Cart element
* Improved the AJAX Popup functionality
* New Loop Provider - Custom Taxonomy Query

### 1.1 - 2023-02-24

* Fixed - Style of Strikethrough price is not working.
* Fixed - Flashing issue in the Off-Canvas element.
* Fixed - Off-canvas cart was closing after clicking on the add to cart button.
* Improved the Add To Cart element.
* Add To Cart element is compatible with the AJAX action of Bricks 1.6.1
* Integrated AJAX action with the native bricks popup builder. You will get the AJAX Popup controls under the Style tab of the Button, DIV, Icon and SVG elements.
* Improved some internal codes

### 1.0.18 - 2022-12-07

* [Item Quantity Element] - Added Font Size option for quantity input field.
* New dynamic tag - Permalink({post_permalink}). It is required when you are using the Custom WP Query
* New dynamic tag - Post Title({bu_post_title}). It is required when you are using the Custom WP Query
* Added the quantity text field for mobile devices

### 1.0.17 - 2022-11-28

* Fixed - JS issues in Off-Canvas and Animated Burger elements

### 1.0.16 - 2022-11-26

* Fixed - Lightbox JS issue
* Fixed - Few dynamic tags of WP Media were not working.

### 1.0.15 - 2022-11-25

* Fixed PHP fatal error or white screen when Bricks theme is disabled.
* Added the Sync option. You can now sync the two sliders from the builder editor.
* New loop builder - WooCommerce Product Gallery
* New dynamic tag - {product_gallery_img} (Limit of Product Gallery Images)

### 1.0.14 - 2022-11-21

* Bug fixed - Metabox gallery loop was not working at frontend.
* Image Attachment is supporting the featured image

### 1.0.13 - 2022-11-20

* New element - Custom WP Query Pagination
* New element - Image Attachment
* Improved Flex Gallery element. Updated the lightbox effect.

### 1.0.12 - 2022-11-16

* Fixed PHP fatal error.
* Compatible with Bricks 1.6 beta
* Removed the all element condition logics which BricksUltimate added
* New loop builders - Cross-sells and Custom WP Query

### 1.0.11 - 2022-11-01

* Fixed PHP fatal error.
* [Animated Burger] - Fixed accessibility issue.

### 1.0.10 - 2022-10-31

* Added new condition logics
* Fixed Fluent Forms Styler element. The forms were not listing in dropdown when there has one fluent form.
* Improved - Variations form was not reseting when AJAX Add To Cart action of the single add to cart button enabled.

### 1.0.9 - 2022-10-03

* Fixed - JS file is missing in Flex Gallery element
* Fixed - JS error in Add To Cart element
* Improved the Add To Cart element
* Added custom conditions for WooCommerce

### 1.0.8 - 2022-09-19
* Compatible with the Bricks 1.5.3
* New element - Sold Out Badge
* New element - Best Selling Badge
* New element - Product Ratings
* Improve - Adds "Buy Now" button feature into Add To Cart element
* Fixed PHP warnings
* Dynamic Tags - Product Total Reviews counter & Product Average Ratings Point

### 1.0.7 - 2022-09-08
* Bug Fixed - Some options of some elements are placed in wrong place
* Bug Fixed - PHP warning in Free Shipping Bar element
* Improved - Add To Cart element
* Added the accordion effect option in Accordion Menu element
* New Element: Product Image

### 1.0.6 - 2022-09-03
* Bug Fixed - PHP errors in Flex Gallery element(due to Bricks 1.5.1)
* Bug Fixed - CSS issue in Animated Burger(due to Bricks 1.5.1)
* Bug Fixed - Quantity element(min cart element) is conflicting with 3rd party woocommerce plugin
* Bug Fixed - Cart item price(min cart element) is not working with 3rd party woocommerce plugin
* BricksUltimate is compatible with Bricks 1.5.1 RC version
* New Element: Free Shipping Notice

### 1.0.5 - 2022-08-23
* Bug Fixed - Photoswipe JS is not loading in Flex Gallery element
* Bug Fixed - ACF/MetaBox gallery images are not showing in Flex Gallery element(Bricks v1.5+)
* Bug Fixed - Conflicting with Happy Files Pro plugin
* Added enable/disable option for White Label tab
* Added custom event listeners(bu_ocp_open & bu_ocp_close) in Off Canvas Panel element for developers

### 1.0.4 - 2022-08-16
* Added two new options in Off Canvas element
* Fixed PHP warnings and fatal error
* Fixed Plugin Updater API
* Fixed - footer is cutting when sticky add to cart bar is adding on the single product page

### 1.0.3 - 2022-08-15
* Fixed JS errors
* Added new option in the Add To Cart element for sticky button

### 1.0.2 - 2022-08-12
* Fixed PHP error
* Added new element "Variations List" for the mini cart

### 1.0.1 - 2022-08-10
* Fixed CSS issue in Animated Burger element
* Fixed link property in Cart Counter element

### 1.0 - 2022-08-09
* Added "Tiles" grid type in Flex Gallery element
* New elements: Off Canvas, Cart Counter, Mini Cart Builder
* New dynamic tags: Cart Counter, Cart Totals, Cart Quantity
* Fixed: JS issue in Add To Cart & Buy Now elements
* Improved Animated Burger element and fully compatible with Bricks now
* Dynamically show the Fluent/Gravity/Piotnet Form on the taxonomy archive page

### 0.9.1 - 2022-07-13
* Fixed bugs: PHP warning

### 0.9 - 2022-07-12
* New element: Flex Gallery

### 0.8 - 2022-06-29
* New dynamic tags: WP Media, Sale Start and End Date
* New providers: ACF Gallery and Metabox Image Advanced
* Enhance Cart Items and Totals element(add the more controls)
* New element: Post Terms
 
### 0.7 - 2022-06-22
* Bug Fixed: Sliding Menu element is conflicting with other plugins
* New Element: Piotnet Forms Styler
* New Element: WPForms Styler
* New Element: Add To Cart

### 0.6 - 2022-06-17
* Enhance Products Up/Cross Sells element and add the more controls
* Enhance Related Products element and add the more controls
* New query loop provider: Product Upsells
* New query loop provider: Author Box
* Fixed: PHP errors

### 0.5 - 2022-06-07
* Enhance Products element and add the more controls
* Enhance Products Filter element and add the more controls
* Bug fixed: File of Empty Cart Button element was missing
* Improve internal functionality

### 0.4 - 2022-06-01
* New Element: Empty Cart Button
* New Element: New Badge
* Added more sub-menu items under the bricksultimate admin menu bar
* Fixed: Preview of sales badge was not showing properly in editor
* New dynamic tags: Parent title, Parent post url, Loop counter, Terms - Posts count, Total Sales

### 0.3 - 2022-05-26
* New Element: Buy Now Button
* New Element: Sales Badge
* Bug Fixed: Form ID is not returning from the custom field in Fluent Forms Styler element
* Bug Fixed: Form ID is not returning from the custom field in Gravity Forms Styler element
* Bug Fixed: Form ID is not returning from the custom field in Contact Form 7 Styler element

### 0.2 - 2022-05-23
* New Element: Gravity Forms Styler
* New Element: Highlighted Heading
* Added: Theme styles of Dual Color Text, GF Styler, CF7 Styler, FF Styler, etc element

### 0.1 - 2022-08-15
* Initial Public Release
