<?php
namespace BricksUltimate\Admin\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait Css {

	function loadCSS()
	{
		add_action( 'admin_footer', [ $this, 'bu_change_settings_ui'] );
	}

	function bu_change_settings_ui() {
		$screen = get_current_screen();

		if( empty( $screen ) || ! strstr( $screen->id, $this->menu_slug ) )
			return;

		$class = 'bricks_page_' . $this->menu_slug;

	    echo "<style type=\"text/css\">
	    	.{$class} .addon-title sup {
	    		color: #000;
				font-size: 10px;
				background: #ffdf0a;
				padding: 4px 8px;
				border-radius: 5px;
	    	}
    		.{$class} .wrap {
				background: #fff;
				padding: 0 40px 40px;
				max-width: 100%;
				margin: 40px 15px 0 0;
				box-shadow: 0 0 18px #ddd;
			}

			.{$class} .wrap .heading {
				font-size: 1.8em;
			}

			.{$class} .bu-docs {
				font-size: 14px;
				font-weight: 600;
				float: right;
				text-decoration: none;
				margin-top: 5px;
				margin-right: 15px;
				border-bottom: 1px solid currentColor;
			}

			.{$class} .nav-tab-wrapper, 
			.{$class} .wrap h2.nav-tab-wrapper {
				padding: 38px 35px 0;
				margin: 0 -40px 30px;
			}

			.{$class} .nav-tab {
				background-color: #fcfcfc;
				color: #777;
				display: flex; 
				align-items: center;
				padding: 10px 18px 6px;
				font-size: 12px;
			}

			.{$class} .about-wrap .nav-tab-active, 
			.{$class} .nav-tab-active, 
			.{$class} .nav-tab-active:hover {
				background-color: #fff;
				border-bottom-color: #fff;
				color: #333;
			}

			.{$class} table.widefat {
				border-left: 0;
				border-right: 0;
			}

			.{$class} .plugins .active td, 
			.{$class} .plugins .active th {
				background-color: #fafafa;
			}

			.{$class} .plugins .active th.check-column {
				border-left: 0;
			}

			.{$class} p.submit {
				padding: 0;
				margin: 0;
			}
			.{$class} .wp-list-table{
				margin-bottom: 10px;
			}
			.{$class} input[type=text],
			.{$class} input[type=email],
			.{$class} input[type=password],
			.{$class} input[type=url] {
				padding: 7px 12px;
			}
			.{$class} form:not(.maep-form) input[type=text],
			.{$class} input[type=email],
			.{$class} input[type=url],
			.{$class} input[type=password],
			.{$class} textarea {
				border: 1px solid #cdcdcd;
				color: #333;
				width: 100%;
			}
			.{$class} ::placeholder {
				color:#999;
			}
			.{$class} .license-activate-form {
				background-color: #fff;
				border: 1px solid #ccd0d4;
				padding: 5px 30px 15px;
			}
			.{$class} .license-activate-form .button {
				margin-top: 12px;
			}

			.{$class} #tab-misc {
				border-spacing: 0;
				margin: 0 0 30px;
				width: 100%;
			}

			.{$class} #tab-misc tbody {
				border-spacing: 0;
				display: flex;
				flex-direction: column;
				width: 100%;
			}

			.{$class} #tab-misc tr {
				background-color: #fff;
				box-shadow: 0 0 0 1px #ddd;
				display: flex;
			}

			.{$class} #tab-misc th {
				border-right: 1px solid #ddd;
				font-weight: 400;
				line-height: 1.7;
				max-width: 40%;
				padding: 15px 20px;
				text-align: initial;
				vertical-align: initial;
				width: 500px;
			}

			th label {
				cursor: default;
				font-size: 14px;
				font-weight: 700;
				display: inline-block;
				margin-right: 20px;
				min-width: 120px;
				text-transform: capitalize;
			}

			.{$class} tr td strong {
				display: inline-block
			}

			.{$class} td .description {
				display: inline-block;
				float: rever-layer;
				margin: 0 12px;
			}

			.{$class} #tab-misc td {
				background-color: #fff;
				padding: 20px 30px;
				text-align: initial;
				width: 100%;
			}

			.{$class} #tab-misc .description {
				display: block;
				color: #9e9e9e;
				font-size: 12px;
				line-height: 1.4;
				margin: 5px 0 0;
			}

			.{$class} #tab-misc input[type=checkbox] {
				appearance: none;
				background-color: #eaecef;
				border: none;
				border-radius: 16px;
				box-shadow: none;
				cursor: pointer;
				display: inline-block;
				height: 16px;
				line-height: 0;
				margin: 0 4px 0 0;
				outline: none;
				padding: 0;
				width: 26px;
				vertical-align: middle;
				transition: .05s border-color ease-in-out;
			}

			.{$class} #tab-misc input[type=checkbox]:checked {
				background-color: #2271b1;
			}

			.{$class} #tab-misc input[type=checkbox]:before {
				-webkit-appearance: none;
				background-color: #9da8b2;
				border-radius: 12px;
				content: '';
				cursor: pointer;
				display: block;
				height: 12px;
				left: 2px;
				margin: 0;
				position: relative;
				top: 2px;
				transition: .1s;
				transition: all .2s ease-out;
				width: 12px;
			}

			.{$class} #tab-misc input[type=checkbox]:checked:before {
				background-color: #fff;
				content: '';
				float: left;
				left: 0;
				opacity: 1;
				transform: translateX(100%);
				vertical-align: middle;
			}

			.{$class} .widefat th {
				font-weight: 700;
				width: auto
			}

			.{$class} select {
				font-size: 13px;
				margin-top: 5px;
			}

			.{$class} .col-2 {
				display: grid;
				grid-template-columns: 1fr 1fr;
				gap: 15px;
			}

			.{$class} th .badge {
				border: 1px solid;
				border-radius: 4px;
				display: inline-block;
				font-size: 10px;
				font-weight: 700;
				margin: 10px 0 0;
				padding: 0 6px;
				text-transform: uppercase;
			}

			.checkout-fields-wrapper {
				display: flex;
				margin-top: 20px;
				gap: 30px
			}

			.billing-fields,
			.shipping-fields {
				border: 1px solid #dedede;
				padding: 10px 30px 30px;
			}

			.header-bar.cols-2 {
				display: flex;
				justify-content: space-between;
				width: 100%;
				align-items: center;
				margin-bottom: 10px;
			}

			.header-bar h3 {
				padding: 0;
				margin: 0;
			}

			.user-guide {
				text-decoration: none;
			}
	    </style>";
	}
}