<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="panel-wrap bu_order_bumps_data product_data">
	<div id="general_product_data" class="panel woocommerce_options_panel">
		<p class="form-field">
			<label for="buob_offer_product"><?php esc_html_e( 'Offer product', 'bricksultimate' ); ?></label>
			<select class="wc-product-search" style="width: 50%;" id="buob_offer_product" name="buob_offer_product" data-placeholder="<?php esc_attr_e( 'Search for a product&hellip;', 'woocommerce' ); ?>" data-action="woocommerce_json_search_products_and_variations">
				<?php
					$product_id = get_post_meta( $post->ID, '_buob_offer_product', true );
					$product = wc_get_product( $product_id );
					if ( is_object( $product ) ) {
						echo '<option value="' . esc_attr( $product_id ) . '"' . selected( true, true, false ) . '>' . esc_html( wp_strip_all_tags( $product->get_formatted_name() ) ) . '</option>';
					}
				?>
			</select>
		</p>
		<div class="options_group">
			<?php
				woocommerce_wp_select(
					array(
						'id'          => '_buob_discount_type',
						'value'       => get_post_meta( $post->ID, '_buob_discount_type', true ) ?? 'percent',
						'label'       => __( 'Discount type', 'bricksultimate' ),
						'options'     => [
							'percent' => __('Percent Off', 'bricksultimate' ), 
							'amount' => __( 'Amount Off' , 'bricksultimate' )
						],
						'style' => 'font-size: 12px',
						'desc_tip'    => 'true',
						'description' => __( 'Amount Off: Remove fixed amount from the product price. Percent Off: Discount product by specified percentage.', 'bricksultimate' ),
					)
				);

				woocommerce_wp_text_input(
					array(
						'id'          => '_buob_offer_discount',
						'value'       => get_post_meta( $post->ID, '_buob_offer_discount', true ) ?? '',
						'type' 		  => 'number',
						'label'       => __( 'Discount', 'bricksultimate' ),
						'style' 	  => 'font-size: 12px',
						'placeholder' => 10,
						'description' => __( 'The amount or percentage applied as a discount to the Offer Product.', 'bricksultimate' ),
					)
				);

				woocommerce_wp_textarea_input(
					array(
						'id'          => '_buob_offer_description',
						'value'       => get_post_meta( $post->ID, '_buob_offer_description', true ) ?? '',
						'label'       => __( 'Offer description', 'bricksultimate' ),
						'placeholder' => __( 'Example: Limited time offer! Get an EXCLUSIVE discount right now! Click the checkbox above to add this product to your order now.', 'bricksultimate' ),
						'style' => 'font-size: 12px;height: auto',
						'rows' 	=> 4
					)
				);

				$quantity = get_post_meta( $post->ID, '_buob_offer_product_quantity', true );
				$quantity = ! empty( $quantity ) ? $quantity : 1;

				woocommerce_wp_text_input(
					array(
						'id'          => 'buob_offer_product_quantity',
						'value'       => $quantity,
						'type' 		  => 'number',
						'label'       => __( 'Quantity', 'bricksultimate' ),
						'style' 	  => 'font-size: 12px',
						'placeholder' => 1,
						'description' => __( 'Quantity of offer product to add in the cart.', 'bricksultimate' ),
					)
				);

				woocommerce_wp_checkbox(
					array(
						'id'          	=> 'buob_has_quantity_field',
						'value'       	=> get_post_meta( $post->ID, '_buob_has_quantity_field', true ) ?? 'no',
						'checked_value' => 'yes',
						'label'       	=> __( 'Change quantity in Cart?', 'bricksultimate' ),
						'description' => __( 'Allow customer to change the quantity of this order bump in the cart.', 'bricksultimate' ),
					)
				);

				woocommerce_wp_checkbox(
					array(
						'id'          	=> 'buob_enable_remove_button',
						'value'       	=> get_post_meta( $post->ID, '_buob_enable_remove_button', true ) ?? 'no',
						'checked_value' => 'yes',
						'label'       	=> __( 'Can remove from Cart?', 'bricksultimate' ),
						'description' 	=> __( 'Allow customer to remove this order bumps item from the cart. It will add the remove button(X) in cart.', 'bricksultimate' ),
					)
				);

				woocommerce_wp_select(
					array(
						'id'          => 'buob_remove_logic',
						'value'       => get_post_meta( $post->ID, '_buob_remove_logic', true ) ?? 'leaveincart',
						'label'       => __( 'Removal logic', 'bricksultimate' ),
						'options'     => [
							'leaveincart' 		=> __( 'Leave in cart with normal price', 'bricksultimate' ),
							'removefromcart' 	=> __( 'Remove offer product from the cart', 'bricksultimate' ), 
						],
						'style' => 'font-size: 12px',
						'desc_tip'    => 'true',
						'description' => __( 'What happens when the display for product is removed from the cart. Default: Order Bump remains in the cart but bump specific discounts are removed.', 'bricksultimate' ),
					)
				);
			?>
		</div>
		<div class="options_group">
			<h2><?php _e('Display Conditions', 'bricksultimate'); ?></h2>
			<p class="description"><?php _e('Show this bump when this condition is true.', 'bricksultimate'); ?></p>
			<?php
				$display_condition = get_post_meta( $post->ID, '_buob_display_condition', true ) ?? 'all';
				woocommerce_wp_select(
					array(
						'id'          => 'buob_display_condition',
						'value'       => $display_condition,
						'label'       => __( 'Display offer product for', 'bricksultimate' ),
						'options'     => [
							'all' 		=> __( 'All products', 'bricksultimate' ),
							//'single' 	=> __( 'Single product(Single Product Page)', 'bricksultimate' ), 
							'sprds' 	=> __( 'Specific products in cart' , 'bricksultimate' ),
							'spcats' 	=> __( 'Specific categories in cart' , 'bricksultimate' ),
							'cartqty' 	=> __( 'Cart Total Quantity' , 'bricksultimate' ),
							'csubttl' 	=> __( 'Cart Subtotal' , 'bricksultimate' ),
							'ccoupon' 	=> __( 'Cart Coupons' , 'bricksultimate' )
						],
						'style' => 'font-size: 12px',
					)
				);

				$class = ( $display_condition == 'single' ) ? '' : ' hidden';
			?>
			<p class="form-field toggle-field show-single<?php echo $class; ?>">
				<label for="buob_single_page"><?php esc_html_e( 'Product', 'bricksultimate' ); ?></label>
				<select class="wc-product-search" style="width: 50%;" id="buob_single_page" name="buob_single_page" data-placeholder="<?php esc_attr_e( 'Select a product&hellip;', 'woocommerce' ); ?>" data-action="woocommerce_json_search_products_and_variations">
					<?php
						$product_id = get_post_meta( $post->ID, '_buob_on_single_page', true );
						$product = wc_get_product( $product_id );
						if ( is_object( $product ) ) {
							echo '<option value="' . esc_attr( $product_id ) . '"' . selected( true, true, false ) . '>' . esc_html( wp_strip_all_tags( $product->get_formatted_name() ) ) . '</option>';
						}
					?>
				</select>
			</p>
			<?php $class = ( $display_condition == 'sprds' ) ? '' : ' hidden'; ?>

			<p class="form-field toggle-field show-sprds<?php echo $class; ?>">
				<label for="buob_specific_products"><?php esc_html_e( 'Products', 'bricksultimate' ); ?></label>
				<select class="wc-product-search" multiple="multiple" style="width: 50%;" id="buob_specific_products" name="buob_specific_products[]" data-placeholder="<?php esc_attr_e( 'Search for products&hellip;', 'woocommerce' ); ?>" data-action="woocommerce_json_search_products_and_variations">
					<?php
						$product_ids = get_post_meta( $post->ID, '_buob_dc_specific_products', true ) ?? array();
						if( is_array( $product_ids ) ) {
							foreach ( $product_ids as $product_id ) {
								$product = wc_get_product( $product_id );
								if ( is_object( $product ) ) {
									echo '<option value="' . esc_attr( $product_id ) . '"' . selected( true, true, false ) . '>' . esc_html( wp_strip_all_tags( $product->get_formatted_name() ) ) . '</option>';
								}
							}
						}
					?>
				</select>
			</p>

			<?php $class = ( $display_condition == 'spcats' ) ? '' : ' hidden'; ?>
			<p class="form-field toggle-field show-spcats<?php echo $class; ?>">
				<label for="buob_specific_categories"><?php esc_html_e( 'Categories', 'bricksultimate' ); ?></label>
				<select class="wc-category-search" multiple="multiple" style="width: 50%;" id="buob_specific_categories" name="buob_specific_categories[]" data-placeholder="<?php esc_attr_e( 'Search for categories&hellip;', 'woocommerce' ); ?>" data-action="woocommerce_json_search_categories" data-allow_clear="true">
					<?php
						$category_slugs = get_post_meta( $post->ID,'_buob_dc_specific_cats', true ) ?? array();
						
						if( is_array($category_slugs) ):
							foreach ( $category_slugs as $category_slug ) {
								$current_category = $category_slug ? get_term_by( 'slug', $category_slug, 'product_cat' ) : false;
								if ( $current_category && $category_slugs ) {
									echo '<option value="' . esc_attr( $category_slug ) . '"' . selected( true, true, false ) . '>' . esc_html( htmlspecialchars( wp_kses_post( $current_category->name ) ) ) . '</option>';
								}
							}
						endif;
					?>
				</select>
			</p>

			<?php
				woocommerce_wp_select(
					array(
						'id'          => 'buob_spprdcat_operator',
						'value'       => get_post_meta( $post->ID, '_buob_spprdcat_operator', true ) ?? 'all',
						'label'       => __( 'Operator', 'bricksultimate' ),
						'options'     => [
							'all' 		=> __( 'All', 'bricksultimate' ), 
							'one' 		=> __( 'Atleast one' , 'bricksultimate' ),
							'none' 		=> __( 'None' , 'bricksultimate' ),
						],
						'style' => 'font-size: 12px',
						'wrapper_class' => ( $display_condition == 'sprds' || $display_condition == "spcats" ) ? 'show-prdcats_operator toggle-field' : 'show-prdcats_operator toggle-field hidden'
					)
				);
			?>

			<?php
				woocommerce_wp_select(
					array(
						'id'          => 'buob_compare',
						'value'       => get_post_meta( $post->ID, '_buob_compare', true ) ?? 'equal',
						'label'       => __( 'Compare', 'bricksultimate' ),
						'options'     => [
							'equal' 		=> __( 'is equal to', 'bricksultimate' ), 
							'notequal' 		=> __( 'is not equal to' , 'bricksultimate' ),
							'greater' 		=> __( 'is greater than' , 'bricksultimate' ),
							'lessthan' 		=> __( 'is less than' , 'bricksultimate' ),
							'gequal' 		=> __( 'is greather or equal to' , 'bricksultimate' ),
							'lequal' 		=> __( 'is less than or equal to' , 'bricksultimate' ),
						],
						'style' => 'font-size: 12px',
						'wrapper_class' => ( $display_condition == 'cartqty' || $display_condition == "csubttl" ) ? 'show-compare toggle-field' : 'show-compare toggle-field hidden'
					)
				);

				woocommerce_wp_text_input(
					array(
						'id'          => 'buob_user_value',
						'value'       => get_post_meta( $post->ID, '_buob_user_value', true ),
						'type' 		  => 'number',
						'label'       => __( 'Value', 'bricksultimate' ),
						'style' 	  => 'font-size: 12px',
						'placeholder' => 0,
						'wrapper_class' => ( $display_condition == 'cartqty' || $display_condition == "csubttl" ) ? 'show-user_value toggle-field' : 'show-user_value toggle-field hidden'
					)
				);

				woocommerce_wp_text_input(
					array(
						'id'          => 'buob_cart_coupons',
						'value'       => get_post_meta( $post->ID, '_buob_cart_coupons', true ),
						'type' 		  => 'text',
						'label'       => __( 'Coupon codes', 'bricksultimate' ),
						'style' 	  => 'font-size: 12px',
						'placeholder' => esc_html__('A comma separated list of coupon codes.', 'bricksultimate' ),
						'wrapper_class' => ( $display_condition == 'ccoupon' ) ? 'show-ccoupon toggle-field' : 'show-ccoupon toggle-field hidden'
					)
				);
			?>
		</div>
	</div>
	<div class="clear"></div>
</div>