<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Walker for Manu Items
 * Adding the Back button
 */
class BuSlidingNavWalker extends \Walker_Nav_Menu {
	public function start_lvl( &$output, $depth = 0, $args = null ) {
		if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = str_repeat( $t, $depth );
 
        // Default class.
        $classes = array( 'sub-menu' );
 
        $class_names = implode( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
 
		if( $args->walker->has_children ) { 
        	$output .= "{$n}{$indent}<ul$class_names>{$n}" . 
        				'<li class="menu-item bu-slide-menu-item bu-slide-menu-back" aria-expanded="false" aria-pressed="false" aria-hidden="true">' . 
						$args->back_arrow_icon . '<span class="bu-menu-sub-item-back" role="button" aria-label="hidden">Back</span></li>' . "\n"; 
		} else {
			$output .= "{$n}{$indent}<ul$class_names>{$n}";
		}
	}
}