<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ProductsElement {
	public function __construct() {
		add_filter( "bricks/elements/woocommerce-products/control_groups", [ $this, 'add_products_control_groups' ], 10, 1 );
		add_filter( "bricks/elements/woocommerce-products/controls", [ $this, 'bu_enhance_products_controls' ], 10, 1 );
	}

	/**
	 * Adds extra control group for products element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_products_control_groups( $control_groups ) {
		$control_groups['atcBtn'] = [
			'title' => esc_html__( 'Add to cart button', 'bricksultimate' ),
			'tab'   => 'content',
		];

		$control_groups['price'] = [
			'title' => esc_html__( 'Price', 'bricks' ),
			'tab'   => 'content',
		];

		$newness_in_days = \Bricks\Database::get_setting( 'woocommerceBadgeNew', false );
		$badge_type = \Bricks\Database::get_setting( 'woocommerceBadgeSale', false );
		if( $badge_type ) {
			$control_groups['saleBadge'] = [
				'title' => esc_html__( 'Sale badge', 'bricksultimate' ),
				'tab'   => 'content',
			];
		}
		
		if( $newness_in_days ) {
			$control_groups['newBadge'] = [
				'title' => esc_html__( 'New badge', 'bricksultimate' ),
				'tab'   => 'content',
			];
		}

		return $control_groups;
	}

	/**
	 * Enhance the products element's contorls
	 * 
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	public function bu_enhance_products_controls( $controls ) {
		/**
		 * Price
		 */
		$controls['hideRegularPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Hide strick through price', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'selector' => 'del',
					'property' => 'display',
					'value'    => 'none',
				],
			]
		];

		$controls['regularPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Strick through price', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' 	=> 'del',
					'property' 	=> 'font'
				],
				[
					'selector' => '.price del .amount',
					'property' => 'font',
				],
			]
		];

		/**
		 * Sale badge
		 */
		$selector = '.badge.onsale';

		$controls['saleBadgeWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['saleBadgeHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				],
				[
					'property' => 'line-height',
					'selector' => $selector,
				]
			],
		];

		$controls['saleBadgeBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeTypography'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeBorder'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				],
			],
		];

		$controls['saleBadgeSpacing'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Spacing', 'bricks' ),
		];

		$controls['_sbMrginInfo'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'type'  => 'info',
			'content' => esc_html__('Set margin-top: 0, if you want to move the sale badge to the right side.', 'bricksultimate')
		];

		$controls['saleBadgeMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'default' 	=> [
				'top' 	=> 32
			],
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.badge+.badge'
				],
			],
		];

		$controls['saleBadgePadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['saleBadgeSepPos'] = [
			'tab' 		=> 'content',
			'group' 	=> 'saleBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Positioning', 'bricks' ),
		];

		$controls['_sbTop'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbRight'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbBottom'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbLeft'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => $selector,
				],
			],
		];

		$controls['_sbLeftInfo'] = [
			'tab'   => 'content',
			'group' => 'saleBadge',
			'type'  => 'info',
			'content' => esc_html__('Set left value is auto, if you want to move the new badge to the right side.', 'bricksultimate')
		];

		$controls['_sbzIndex'] = [
			'tab'         => 'content',
			'group'       => 'saleBadge',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => $selector,
				],
			],
			'min'         => -999,
			'placeholder' => 0,
		];


		/**
		 * New badge button
		 */
		$selector = '.badge.new';

		$controls['newBadgeWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['newBadgeHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				],
				[
					'property' => 'line-height',
					'selector' => $selector,
				]
			],
		];

		$controls['newBadgeBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeTypography'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeBorder'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				],
			],
		];

		$controls['newBadgeSepPos'] = [
			'tab' 		=> 'content',
			'group' 	=> 'newBadge',
			'type'      => 'separator',
			'label'     => esc_html__( 'Positioning', 'bricks' ),
		];

		$controls['_nbTop'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbRight'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbBottom'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbLeft'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => $selector,
				],
			],
		];

		$controls['_nbLeftInfo'] = [
			'tab'   => 'content',
			'group' => 'newBadge',
			'type'  => 'info',
			'content' => esc_html__('Set left value is auto, if you want to move the new badge to the right side.', 'bricksultimate')
		];

		$controls['_nbzIndex'] = [
			'tab'         => 'content',
			'group'       => 'newBadge',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => $selector,
				],
			],
			'min'         => -999,
			'placeholder' => 0,
		];


		/**
		 * Add to cart button
		 */
		$selector = '.button';

		$controls['atcBtnWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'atcBtn',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['atcBtnHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'atcBtn',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['atcBtnPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'atcBtn',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['atcBtnBackground'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['atcBtnBorder'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$controls['atcBtnBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['atcBtnHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'atcBtn',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['atcBtnHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverColor'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['atcBtnHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'atcBtn',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		return $controls;
	}
}