<?php

namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WPGBFacets {
	public function __construct() {
		add_filter( "bricks/elements/wpgb-facet/control_groups", [ $this, 'add_wpgb_facet_control_groups' ] );
		add_filter( "bricks/elements/wpgb-facet/controls", [ $this, 'bu_wpgb_facet_controls' ] );
	}

	public function add_wpgb_facet_control_groups( $control_groups ) {
		$control_groups['title'] = [
			'title' => esc_html__( 'Title', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['checkbox'] = [
			'title' => esc_html__( 'Checkboxes', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['radio'] = [
			'title' => esc_html__( 'Radio', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['dwn'] = [
			'title' => esc_html__( 'Dropdown', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['search'] = [
			'title' => esc_html__( 'Search', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['btn'] = [
			'title' => esc_html__( 'Buttons', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['subBtn'] = [
			'title' => esc_html__( 'Submit/Reset Button', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['hierarchy'] = [
			'title' => esc_html__( 'Hierarchy', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['number'] = [
			'title' => esc_html__( 'Number', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['range'] = [
			'title' => esc_html__( 'Range Slider', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['rating'] = [
			'title' => esc_html__( 'Rating Picker', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['azIndex'] = [
			'title' => esc_html__( 'A-Z Index', 'bricks' ),
			'tab'   => 'content',
		];

		return $control_groups;
	}

	public function bu_wpgb_facet_controls( $controls ) {

		$controls['stylerSep'] = [
			'tab' 		=> 'content',
			'type'      => 'separator',
		];

		$controls['containerSpacing'] = [
			'tab' 		=> 'content',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Container spacing', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.wpgb-facet > fieldset',
				],
				[
					'property' => 'margin',
					'selector' => '.wpgb-facet > fieldset:last-child',
				]
			],
		];

		$controls['cbSpacing'] = [
			'tab' 		=> 'content',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Content spacing', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.wpgb-facet .wpgb-hierarchical-list li, .wpgb-facet .wpgb-number-facet',
				],
				[
					'property' => 'margin',
					'selector' => '.wpgb-facet .wpgb-inline-list li',
				],
				[
					'property' 	=> 'margin-top',
					'selector' 	=> '.wpgb-facet .wpgb-hierarchical-list:first-child>li:first-child',
					'value' 	=> 0
				]
			],
		];

		/***************************
		 * Title
		 ***************************/

		$selector = '.wpgb-facet-title';
		$controls['titleTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['ttlBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['ttlBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['ttlMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$controls['ttlPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'title',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		
		/***************************
		 * Checkbox
		 ***************************/
		$controls['cbLabel'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'typography',
			'label'     => esc_html__( 'Label', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-checkbox-label',
				]
			],
		];

		$controls['cbCount'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'typography',
			'label'     => esc_html__( 'Count', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-checkbox-label span',
				]
			],
		];

		$controls['cbSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'separator',
			'label'     => esc_html__( 'Checkbox', 'bricks' ),
		];

		$controls['cbGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Gap between label', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'padding-left',
					'selector' => '.wpgb-checkbox-label',
				]
			],
		];

		$selector = '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox-control';

		$controls['cbSize'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Size', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				],
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
		];

		$controls['cbWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Border width', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				]
			],
		];

		$controls['cbColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'color',
			'label'     => esc_html__( 'Border color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$controls['cbRadius'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Border radius', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'border-radius',
					'selector' => $selector
				]
			],
		];

		$controls['cbCheckedColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'color',
			'label'     => esc_html__( 'Checked box color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox[aria-pressed="true"] .wpgb-checkbox-control'
				],
				[
					'property' => 'border-color',
					'selector' => '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox[aria-pressed="true"] .wpgb-checkbox-control'
				]
			],
		];

		$controls['alignItems'] = [
			'group' 	=> 'checkbox',
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
					'selector' => '.wpgb-checkbox'
				],
			]
		];

		$controls['cbTickSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'separator',
			'label'     => esc_html__( 'Tick Mark', 'bricks' ),
		];

		$controls['cbTickColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox[aria-pressed="true"] .wpgb-checkbox-control:after'
				]
			],
		];

		$controls['cbTickWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox-control:after'
				]
			]
		];

		$controls['cbTickHeight'] = [
			'group' 	=> 'checkbox',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => '.wpgb-facet .wpgb-checkbox-facet .wpgb-checkbox-control:after'
				]
			]
		];

		/***************************
		 * Radio
		 ***************************/

		$controls['rbLabel'] = [
			'group' 	=> 'radio',
			'type'      => 'typography',
			'label'     => esc_html__( 'Label', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-radio-label',
				]
			],
		];

		$controls['rbCount'] = [
			'group' 	=> 'radio',
			'type'      => 'typography',
			'label'     => esc_html__( 'Count', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-radio-label span',
				]
			],
		];

		$controls['rbSep'] = [
			'group' 	=> 'radio',
			'type'      => 'separator',
			'label'     => esc_html__( 'Radio Buttons', 'bricks' ),
		];

		$selector = '.wpgb-facet .wpgb-radio-facet .wpgb-radio-control';

		$controls['rbGap'] = [
			'group' 	=> 'radio',
			'type'      => 'number',
			'label'     => esc_html__( 'Gap between label', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'padding-left',
					'selector' => '.wpgb-radio-label',
				]
			],
		];

		$controls['rbSize'] = [
			'group' 	=> 'radio',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Size', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				],
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
		];

		$controls['rbWidth'] = [
			'group' 	=> 'radio',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Border Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				]
			],
		];

		$controls['rbColor'] = [
			'group' 	=> 'radio',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$controls['rbHColor'] = [
			'group' 	=> 'radio',
			'type'      => 'color',
			'label'     => esc_html__( 'Hover color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => ".wpgb-facet .wpgb-radio-facet .wpgb-radio:hover .wpgb-radio-control"
				]
			],
		];

		$controls['rbAColor'] = [
			'group' 	=> 'radio',
			'type'      => 'color',
			'label'     => esc_html__( 'Active Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => '.wpgb-facet .wpgb-radio-facet .wpgb-radio[aria-pressed="true"] .wpgb-radio-control'
				],
				[
					'property' => 'background-color',
					'selector' => '.wpgb-facet .wpgb-radio-facet .wpgb-radio-control:after'
				]
			],
		];
		
		$controls['rbBulletSize'] = [
			'group' 	=> 'radio',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Active bullet size', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'min-width',
					'selector' => '.wpgb-facet .wpgb-radio-facet .wpgb-radio-control:after'
				],
				[
					'property' => 'min-height',
					'selector' => '.wpgb-facet .wpgb-radio-facet .wpgb-radio-control:after'
				]
			],
		];

		$controls['tbAlignItems'] = [
			'group' 	=> 'radio',
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
					'selector' => '.wpgb-radio'
				],
			]
		];

		/***************************
		 * Buttons
		 ***************************/
		$selector = ".wpgb-button-label";

		$controls['btnTg'] = [
			'group' 	=> 'btn',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['btnCounter'] = [
			'group' 	=> 'btn',
			'type'      => 'typography',
			'label'     => esc_html__( 'Count', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => "{$selector} span"
				]
			],
		];

		$selector = ".wpgb-button";

		$controls['btnBG'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['btnBrd'] = [
			'group' 	=> 'btn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['btnBS'] = [
			'group' 	=> 'btn',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$controls['btnMargin'] = [
			'group' 	=> 'btn',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$controls['btnPad'] = [
			'group' 	=> 'btn',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['btnHoverSep'] = [
			'group' 	=> 'btn',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover', 'bricks' ),
		];

		$controls['btnHBG'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover'
				]
			],
		];

		$controls['btnHColor'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ':hover .wpgb-button-label'
				]
			],
		];

		$controls['btnHCounter'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Count color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ':hover .wpgb-button-label span'
				]
			],
		];


		$controls['btnHBrd'] = [
			'group' 	=> 'btn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector . ':hover'
				]
			],
		];
		
		$controls['btnHBS'] = [
			'group' 	=> 'btn',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover'
				]
			],
		];

		$selector = '.wpgb-facet .wpgb-button[aria-pressed="true"]';
		$controls['btnSelectSep'] = [
			'group' 	=> 'btn',
			'type'      => 'separator',
			'label'     => esc_html__( 'Selected Button', 'bricks' ),
		];

		$controls['btnSBG'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['btnSColor'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ' .wpgb-button-label'
				]
			],
		];

		$controls['btnSCounter'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__( 'Count color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ' .wpgb-button-label span'
				]
			],
		];


		$controls['btnSBrd'] = [
			'group' 	=> 'btn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];
		
		$controls['btnSBS'] = [
			'group' 	=> 'btn',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		/***************************
		 * Submit Buttons
		 ***************************/
		$selector = ".wpgb-facet button.wpgb-button, .wpgb-facet button.wpgb-range-clear";
		$hover = ".wpgb-facet button.wpgb-button:hover, .wpgb-facet button.wpgb-range-clear:hover";
		$disabled = ".wpgb-facet button.wpgb-button[disabled], .wpgb-facet button[disabled]";

		$controls['sbtnBG'] = [
			'group' 	=> 'subBtn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['sbtnTg'] = [
			'group' 	=> 'subBtn',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
			'exclude' => [
				'text-decoration',
				'text-shadow'
			]
		];

		$controls['sbtnBrd'] = [
			'group' 	=> 'subBtn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];
		
		$controls['sbtnBS'] = [
			'group' 	=> 'subBtn',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$controls['sbtnW'] = [
			'group' 	=> 'subBtn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['sbtnH'] = [
			'group' 	=> 'subBtn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
		];

		$controls['sbtnPad'] = [
			'group' 	=> 'subBtn',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['sbtnDOpacity'] = [
			'group' 	=> 'subBtn',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__( 'Disabled opacity', 'bricks' ),
			'min' 		=> 0,
			'max' 		=> 1,
			'step' 		=> 0.1,
			'css'   	=> [
				[
					'property' => 'opacity',
					'selector' => $selector
				]
			],
			'placeholder' 	=> 0.6
		];

		$controls['sbtnSep'] = [
			'group' 	=> 'subBtn',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover', 'bricks' ),
		];

		$controls['sbtnHBG'] = [
			'group' 	=> 'subBtn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $hover
				]
			],
		];

		$controls['sbtnHColor'] = [
			'group' 	=> 'subBtn',
			'type'      => 'color',
			'label'     => esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $hover
				]
			],
		];

		$controls['sbtnHBrd'] = [
			'group' 	=> 'subBtn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $hover
				]
			],
		];
		
		$controls['sbtnHBS'] = [
			'group' 	=> 'subBtn',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $hover
				]
			],
		];

		/***************************
		 * Dropdown
		 ***************************/
		$selector = '.wpgb-facet select.wpgb-select:not([multiple])';

		$controls['ddWidth'] = [
			'group' 	=> 'dwn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['ddHeight'] = [
			'group' 	=> 'dwn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				],
				[
					'property' => 'min-height',
					'selector' => $selector
				]
			],
		];

		$controls['ddTG'] = [
			'group' 	=> 'dwn',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['ddBG'] = [
			'group' 	=> 'dwn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['ddBrd'] = [
			'group' 	=> 'dwn',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['ddpad'] = [
			'group' 	=> 'dwn',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['ddSep'] = [
			'group' 	=> 'dwn',
			'type'      => 'separator',
			'label'     => esc_html__( 'Select Control', 'bricksultimate' )
		];

		$selector = '.wpgb-facet select.wpgb-select+.wpgb-select-controls';

		$controls['ddControlBG'] = [
			'group' 	=> 'dwn',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['ddArrowColor'] = [
			'group' 	=> 'dwn',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$controls['ddSCWidth'] = [
			'group' 	=> 'dwn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Wrapper width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['ddArrowSize'] = [
			'group' 	=> 'dwn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Arrow size', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => '.wpgb-facet select.wpgb-select+.wpgb-select-controls svg'
				],
				[
					'property' => 'height',
					'selector' => '.wpgb-facet select.wpgb-select+.wpgb-select-controls svg'
				]
			],
		];

		$controls['ddASP'] = [
			'group' 	=> 'dwn',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Spacing arround arrow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.wpgb-facet select.wpgb-select+.wpgb-select-controls svg'
				]
			],
		];

		$controls['ddVW'] = [
			'group' 	=> 'dwn',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Vertical line width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => '.wpgb-facet select.wpgb-select+.wpgb-select-controls .wpgb-select-separator'
				]
			],
		];

		$controls['ddVColor'] = [
			'group' 	=> 'dwn',
			'type'      => 'color',
			'label'     => esc_html__( 'Vertical line color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.wpgb-facet select.wpgb-select+.wpgb-select-controls .wpgb-select-separator'
				]
			],
		];


		/***************************
		 * Dropdown
		 ***************************/
		$selector = '.wpgb-facet .wpgb-hierarchy-label';
		$controls['harchyTg'] = [
			'group' 	=> 'hierarchy',
			'type'      => 'typography',
			'label'     => esc_html__( 'Label', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['harchyCount'] = [
			'group' 	=> 'hierarchy',
			'type'      => 'typography',
			'label'     => esc_html__( 'Count', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector . " span"
				]
			],
		];

		/**************************
		 * Number
		 **************************/

		$selector = ".wpgb-number-label";
		$controls['numLabel'] = [
			'group' 	=> 'number',
			'type'      => 'typography',
			'label'     => esc_html__( 'Label', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['numSpinBtn'] = [
			'group' 	=> 'number',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Disable inner spin button', 'bricks' ),
			'css'   	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> "input::-webkit-inner-spin-button",
					'value' 	=> 'none'
				]
			],
		];

		$selector = ".wpgb-facet .wpgb-number-facet .wpgb-number";

		$controls['numSep'] = [
			'group' 	=> 'number',
			'type'      => 'separator',
			'label'     => esc_html__( 'Number input field', 'bricks' ),
		];

		$controls['numW'] = [
			'group' 	=> 'number',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['numH'] = [
			'group' 	=> 'number',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				],
				[
					'property' => 'min-height',
					'selector' => $selector
				]
			],
		];

		$controls['numBg'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['numTg'] = [
			'group' 	=> 'number',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['numBrd'] = [
			'group' 	=> 'number',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['numPad'] = [
			'group' 	=> 'number',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['numHSep'] = [
			'group' 	=> 'number',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover: Input Field', 'bricks' ),
		];

		$controls['numHBg'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":hover"
				]
			],
		];

		$controls['numHColor'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ":hover"
				]
			],
		];

		$controls['numHBrd'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Border color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $selector . ":hover"
				]
			],
		];

		$controls['numFSep'] = [
			'group' 	=> 'number',
			'type'      => 'separator',
			'label'     => esc_html__( 'Focus: Input Field', 'bricks' ),
		];

		$controls['numFBg'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":focus"
				]
			],
		];

		$controls['numFColor'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ":focus"
				]
			],
		];

		$controls['numFBrd'] = [
			'group' 	=> 'number',
			'type'      => 'color',
			'label'     => esc_html__( 'Border color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $selector . ":focus"
				]
			],
		];

		/**************************
		 * Range slider
		 **************************/

		$selector = ".wpgb-facet .wpgb-range-facet .wpgb-range-slider";
        $circle = ".wpgb-facet .wpgb-range-facet .wpgb-range-slider .wpgb-range-thumb";
        $controls['range_slider_height'] = [
			'group' => 'range',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => $selector,
				],
			],
		];

		$controls['range_slider_bg'] = [
			'group' => 'range',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
		];

		$controls['slider_progress_bg'] = [
			'group' => 'range',
			'label' => esc_html__( 'Progress Background color', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.wpgb-facet .wpgb-range-facet .wpgb-range-slider .wpgb-range-progress'
				],
			],
		];

		$controls['range_slider_border'] = [
			'group' => 'range',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$controls['range_slider_valueh'] = [
			'group' => 'range',
			'label' => esc_html__( 'Hide value(price)', 'bricksultimate' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'property' => 'display',
					'selector' => '.wpgb-range-values',
					'value' => 'none'
				],
			],
		];

		$controls['range_slider_value'] = [
			'group' => 'range',
			'label' => esc_html__( 'Value(price)', 'bricksultimate' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.wpgb-range-values',
				],
			],
			'required' => ['range_slider_valueh', '!=', true]
		];

		$controls['range_slider_sep'] = [
			'group' => 'range',
			'label' => esc_html__( 'Cricles', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$controls['circle_size'] = [
			'group' => 'range',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $circle
				],
				[
					'property' => 'height',
					'selector' => $circle
				],
			],
		];

		$controls['circle_bg'] = [
			'group' => 'range',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $circle
				],
			],
		];

		$controls['circle_border'] = [
			'group' => 'range',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $circle,
				],
			],
		];

		/**************************
		 * Rating Picker
		 **************************/

		$selector = '.wpgb-facet .wpgb-rating-facet .wpgb-rating-control';

		$controls['ratingW'] = [
			'group' 	=> 'rating',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
			'placeholder' => '100px'
		];

		$controls['ratingH'] = [
			'group' 	=> 'rating',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
			'placeholder' => '20px'
		];

		$controls['ratingClr'] = [
			'group' 	=> 'rating',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			]
		];


		$controls['ratingAClr'] = [
			'group' 	=> 'rating',
			'type'      => 'color',
			'label'     => esc_html__( 'Hover/Active Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.wpgb-facet .wpgb-rating-facet .wpgb-rating[aria-pressed="true"] .wpgb-rating-svg, .wpgb-facet .wpgb-rating-facet .wpgb-rating:hover:not([tabindex="-1"]) .wpgb-rating-svg'
				]
			]
		];

		
		/**************************
		 * Search
		 **************************/
		$selector = ".wpgb-facet .wpgb-search-facet input[type=\"search\"], .wpgb-facet .wpgb-autocomplete-facet input[type=\"search\"]";

		$controls['searchPad'] = [
			'group' 	=> 'search',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['searchW'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['searchH'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				],
				[
					'property' => 'min-height',
					'selector' => $selector
				]
			],
		];

		$controls['searchBG'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$controls['searchP'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Placeholder', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => ".wpgb-facet .wpgb-search-facet input[type=\"search\"]::placeholder"
				]
			],
		];

		$controls['searchTG'] = [
			'group' 	=> 'search',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
			'exclude' => [
				'text-align',
				'text-shadow',
				'text-decoration'
			]
		];

		$controls['searchBrd'] = [
			'group' 	=> 'search',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['searchBS'] = [
			'group' 	=> 'search',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$controls['searchHover'] = [
			'group' 	=> 'search',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover', 'bricks' ),
		];

		$controls['searchHBrd'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Border color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => ".wpgb-facet .wpgb-search-facet input[type=\"search\"]:hover, .wpgb-facet .wpgb-autocomplete-facet input[type=\"search\"]:hover"
				]
			],
		];

		$controls['searchHBS'] = [
			'group' 	=> 'search',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => ".wpgb-facet .wpgb-search-facet input[type=\"search\"]:hover, .wpgb-facet .wpgb-autocomplete-facet input[type=\"search\"]:hover"
				]
			],
		];

		$selector = ".wpgb-facet .wpgb-search-facet input[type=\"search\"]:focus, .wpgb-facet .wpgb-autocomplete-facet input[type=\"search\"]:focus";

		$controls['searchFocus'] = [
			'group' 	=> 'search',
			'type'      => 'separator',
			'label'     => esc_html__( 'Focus', 'bricks' ),
		];

		$controls['searchFBg'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['searchFTxt'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$controls['searchFBrd'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Border color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$controls['searchFBS'] = [
			'group' 	=> 'search',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$controls['searchIcon'] = [
			'group' 	=> 'search',
			'type'      => 'separator',
			'label'     => esc_html__( 'Search Icon', 'bricks' ),
		];

		$selector = ".wpgb-facet .wpgb-search-facet .wpgb-input-icon";

		$controls['searchIconMrg'] = [
			'group' 	=> 'search',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$controls['searchIconSize'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Size', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				],
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
			'placeholder' => 16
		];

		$controls['searchIconClr'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$controls['searchIconTop'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Position: Top', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'Top',
					'selector' => $selector
				]
			],
			'placeholder' => "calc( 50% - 8px)"
		];

		$controls['searchIconLeft'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Position: Left', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'left',
					'selector' => $selector
				]
			],
			'placeholder' => 0
		];

		$controls['searchCross'] = [
			'group' 	=> 'search',
			'type'      => 'separator',
			'label'     => esc_html__( 'Cross Button', 'bricks' ),
		];

		$selector = ".wpgb-facet .wpgb-search-facet .wpgb-clear-button";

		$controls['searchCrossW'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
			'placeholder' => 40
		];

		$controls['searchCrossH'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				],
				[
					'property' 	=> 'top',
					'selector' 	=> $selector,
					'value' 	=> '50%'
				],
				[
					'property' => 'transform',
					'selector' => $selector,
					'value' 	=> 'translateY(-50%)'
				]
			]
		];

		$controls['searchCrossRight'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Position: Right', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'right',
					'selector' => $selector
				]
			],
			'placeholder' => 0
		];

		$controls['searchCrossBrd'] = [
			'group' 	=> 'search',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$controls['searchCrossS'] = [
			'group' 	=> 'search',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Icon size', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector . " svg"
				]
			],
			'placeholder' => 20
		];

		$controls['searchCrossBG'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$controls['searchCrossClr'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Icon color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			]
		];

		$controls['searchCrossHover'] = [
			'group' 	=> 'search',
			'type'      => 'separator',
			'label'     => esc_html__( 'Cross Button: Hover', 'bricks' ),
		];

		$controls['searchCrossHBG'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":hover"
				]
			]
		];

		$controls['searchCrossHClr'] = [
			'group' 	=> 'search',
			'type'      => 'color',
			'label'     => esc_html__( 'Icon color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ":hover"
				]
			]
		];

		/**************************
		 * A-Z Index
		 **************************/

		$selector = '.wpgb-az-index-facet .wpgb-inline-list li';

		$controls['azMargin'] = [
			'group' 	=> 'azIndex',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$controls['azPad'] = [
			'group' 	=> 'azIndex',
			'type'      => 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$controls['azWidth'] = [
			'group' 	=> 'azIndex',
			'type'      => 'number',
			'units' 		=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$controls['azHeight'] = [
			'group' 	=> 'azIndex',
			'type'      => 'number',
			'units' 		=> true,
			'label'     => esc_html__( 'Height', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
		];

		$controls['azTG'] = [
			'group' 	=> 'azIndex',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-az-index-label'
				],
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['azCountTG'] = [
			'group' 	=> 'azIndex',
			'type'      => 'typography',
			'label'     => esc_html__( 'Count', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.wpgb-az-index-label span'
				]
			],
		];

		$controls['azBG'] = [
			'group' 	=> 'azIndex',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['azBrd'] = [
			'group' 	=> 'azIndex',
			'type'      => 'border',
			'label'     => esc_html__( 'Borders', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['azhover'] = [
			'group' 	=> 'azIndex',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover', 'bricks' ),
		];

		$controls['azHBG'] = [
			'group' 	=> 'azIndex',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":hover"
				]
			],
		];

		$controls['azHColor'] = [
			'group' 	=> 'azIndex',
			'type'      => 'color',
			'label'     => esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ":hover .wpgb-az-index-label"
				],
				[
					'property' => 'color',
					'selector' => $selector . ":hover .wpgb-az-index-label span"
				]
			],
		];

		$controls['azHBrd'] = [
			'group' 	=> 'azIndex',
			'type'      => 'border',
			'label'     => esc_html__( 'Borders', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector . ":hover"
				]
			],
		];

		return $controls;
	}
}