<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, Compare};

class CompareCounter extends \Bricks\Element {
	public $category = 'compare';
	public $name 	= 'bu-comp-counter';
	public $icon 	= 'ti-reload';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Compare Counter', 'bricksultimate' );
	}

	public function get_keywords() {
		return [ 'compare', 'counter', 'count', 'compare link', 'compare total' ];
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['counter']    = array(
			'title' => esc_html__( 'Counter', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['extra']    = array(
			'title' => esc_html__( 'Extra', 'bricks' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['postType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'default' 		=> 'post'
		];

		$this->controls['ccHideBtn'] = [
			'group' => 'extra',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Hide button when empty', 'bricksultimate')
		];

		$this->controls['ariaLabel'] = array(
			'group' 	=> 'extra',
			'type' 		=> 'text',
			'label'		=> esc_html__( 'Aria label', 'bricksultimate' ),
		);

		$this->controls['cta'] = array(
			'group' 	=> 'extra',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Call to action', 'bricksultimate' ),
			'default' 	=> 'none',
			'options' 	=> [
				'none' 		=> esc_html__( 'None', 'bricksultimate' ),
				//'popup' 	=> esc_html__( 'Show dropdown(on hover/click)', 'bricksultimate' ),
				'link' 		=> esc_html__( 'Link to URL', 'bricksultimate' ),
			]
		);

		$this->controls['pageLink'] = array(
			'tab' 		=> 'content',
			'group' 	=> 'extra',
			'type' 		=> 'link',
			'label'		=> esc_html__( 'URL', 'bricksultimate' ),
			'exclude' 	=> [
				'title',
				'ariaLabel',
				'newTab',
				'rel'
			],
			'required' 	=> [ 'cta', '=', 'link' ]
		);


		/**
		 * Button settings
		 */
		$this->controls['contentSource'] = array(
			'type' 		=> 'select',
			'label' 	=> esc_html__('Type', 'bricksultimate' ),
			'default' 	=> 'icon',
			'options' 	=> [
				'text' 		=> esc_html__( 'Text', 'bricksultimate' ),
				'icon' 		=> esc_html__( 'Icon', 'bricksultimate' ),
				'icontext' 	=> esc_html__( 'Icon + Text', 'bricksultimate' ),
			],
			'inline' 	=> true,
			'medium' 	=> true,
		);

		$this->controls['buttonText'] = array(
			'type' 		=> 'text',
			'label'		=> esc_html__( 'Button Text', 'bricksultimate' ),
			'required' 	=> [ 'contentSource', '!=', 'icon' ]
		);

		$this->controls['buttonTg'] = array(
			'type' 		=> 'typography',
			'label'		=> esc_html__( 'Typography', 'bricks' ),
			'required' 	=> [ 'contentSource', '!=', 'icon' ],
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '.bu-comp-counter-btn-text'
				]
			]
		);

		$this->controls['btnTxtHoverColor'] = [
			'type'     => 'color',
			'label'    => esc_html__( 'Hover Color', 'bricks' ),
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-comp-counter-btn:hover .bu-comp-counter-btn-text',
				]
			],
			'required' 	=> [ 'contentSource', '!=', 'icon' ],
		];

		$this->controls['iconSep'] = array(
			'type' 		=> 'separator',
			'label'   	=> esc_html__( 'Icon', 'bricks' ),
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		);

		$this->controls['compareIcon'] = [
			'label'   => esc_html__( 'Icon', 'bricks' ),
			'type'    => 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-reload',
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ],
		];

		$this->controls['iconPosition'] = array(
			'type' 		=> 'select',
			'label' 	=> esc_html__('Icon Position', 'bricksultimate' ),
			'default' 	=> 'right',
			'options' 	=> [
				'left' 		=> esc_html__( 'Left', 'bricks' ),
				'right' 	=> esc_html__( 'Right', 'bricks' )
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> [ 'contentSource', '=', 'icontext' ]
		);

		$this->controls['iconGap'] = [
			'type'      => 'number',
			'label'     => esc_html__('Gap', 'bricksultimate'),
			'units' 	=> true,
			'default'   => 6,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-comp-icon--right .bu-comp-counter-btn-icon",
					'property' 	=> 'margin-left'
				],
				[
					'selector' 	=> ".bu-comp-icon--left .bu-comp-counter-btn-icon",
					'property' 	=> 'margin-right'
				]
			],
			'required' 	=> [ 'contentSource', '=', 'icontext' ]
		];

		$this->controls['iconColor'] = [
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-comp-counter-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-comp-counter-btn-icon'
				],
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];

		$this->controls['iconHoverColor'] = [
			'label'    => esc_html__( 'Hover Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-comp-counter-btn:hover .bu-comp-counter-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-comp-counter-btn:hover .bu-comp-counter-btn-icon'
				],
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];

		$this->controls['iconSize'] = [
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-comp-counter-btn-icon'
				],
			],
			'placeholder' => '22px',
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];


		/**
		 * Counter settings
		 */
		$selector = '.bu-comp-counter';
		$this->controls['hideCounter'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Completely hide counter', 'bricksultimate')
		];

		$this->controls['hideCounterIsEmpty'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Hide it when empty', 'bricksultimate')
		];

		$this->controls['bubble'] = [
			'tab' 		=> 'content',
			'group' 	=> 'counter',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Show in bubble', 'bricksultimate'),
			'default'	=> true
		];

		$this->controls['counterPosition'] = array(
			'tab'   	=> 'content',
			'group' 	=> 'counter',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Position', 'bricks' ),
			'default' 	=> 'left',
			'options' 	=> [
				'left' 		=> esc_html__( 'Left', 'bricks' ),
				'right' 	=> esc_html__( 'Right', 'bricks' )
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> ['bubble', '!=', true]
		);

		$this->controls['counterGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'counter',
			'type'      => 'number',
			'label'     => esc_html__('Gap(px)', 'bricksultimate'),
			'unitless' 	=> true,
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 1,
			'default'   => 6,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-comp-counter--right .bu-comp-counter",
					'property' 	=> 'margin-left',
					'value'		=> '%spx'
				],
				[
					'selector' 	=> ".bu-comp-counter--left .bu-comp-counter",
					'property' 	=> 'margin-right',
					'value'		=> '%spx'
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['bubbleTop'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Position top', 'bricksultimate'),
			'units' => true,
			'placeholder' => '5px',
			'css'	=> [
				[
					'property' 	=> 'top',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['bubbleRight'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Position right', 'bricksultimate'),
			'units' => true,
			'placeholder' => '-4px',
			'css'	=> [
				[
					'property' 	=> 'right',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['counterWidth'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Width', 'bricks'),
			'units' => true,
			'inline' => true,
			'css'	=> [
				[
					'property' 	=> 'width',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['counterHeight'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Height', 'bricks'),
			'units' => true,
			'css'	=> [
				[
					'property' 	=> 'height',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['bubbleSize'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Bubble size', 'bricksultimate'),
			'units' => true,
			'placeholder' => '16px',
			'css'	=> [
				[
					'property' 	=> 'width',
					'selector' 	=> ".bu-comp-counter-in-bubble {$selector}"
				],
				[
					'property' 	=> 'height',
					'selector' 	=> ".bu-comp-counter-in-bubble {$selector}"
				],
				[
					'property' 	=> 'line-height',
					'selector' 	=> ".bu-comp-counter-in-bubble {$selector}"
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['counterBG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'background-color',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['counterHBG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Hover background', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'background-color',
					'selector' 	=> '&:hover ' . $selector
				]
			]
		];

		$this->controls['counterTG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['counterHClr'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Hover color', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'color',
					'selector' 	=> '&:hover ' . $selector
				]
			]
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-wishlistcompare', Helpers::get_asset_url('css') . 'wishlistcompare.min.css', [], filemtime(Helpers::get_asset_path('css') . 'wishlistcompare.min.css'), 'all' );
		}
	}*/

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$post_type 		= Helpers::get_value( $settings, 'postType', 'post' );
		$counter 		= Compare::get_compare_counter( $post_type );
		$cta 			= Helpers::get_value( $settings, 'cta', 'none' );
		$button_label 	= Helpers::get_value( $settings, 'contentSource', 'icon' );
		$class 			= [ 'bu-comp-counter-btn', 'bu-comp-counter-cta-' . $cta, 'bu-comp-counter-btn--' . $post_type ];

		if( ! empty( $settings['ccHideBtn'] ) ) {
			$this->set_attribute( '_root', 'class', 'bu-comp-hide-counter-btn--' . $post_type );

			if( $counter <= 0 ) {
				$this->set_attribute( '_root', 'class', 'bu-comp-hide-btn' );
			}
		}

		/*$this->set_attribute( '_root', 'data-compc-key', Compare::get_cookie_key( $post_type ) );
		$this->set_attribute( '_root', 'data-comp-counter', $counter );*/

		//* root markup start
		echo "<div {$this->render_attributes("_root")}>";

		$link = Helpers::get_value( $settings, 'pageLink', false );
		if( $link )
			$this->set_link_attributes( '_compbutton', $settings['pageLink'] );
		else
			$this->set_attribute( '_compbutton', 'href', 'JavaScript: void(0)' );

		$wsl_counter_html = '';
		if( empty( $settings['hideCounter'] ) ) {

			$wsl_counter_html = "<span class='bu-comp-counter'>{$counter}</span>";

			if( ! empty( $settings['bubble'] ) )
				$class[] = 'bu-comp-counter-in-bubble';
			else
				$class[] = 'bu-comp-counter--' . Helpers::get_value( $settings, 'counterPosition', 'left' );

			if( ! empty( $settings['hideCounterIsEmpty'] ) ) {
				$class[] = 'hide-empty-comp-counter';
			}

			if( ! empty( $settings['hideCounterIsEmpty'] ) && $counter <= 0 ) {
				$class[] = 'bu-comp-counter-hide-counter';
			}
		}

		if( $button_label == 'icontext' ) {
			$class[] = 'bu-comp-icon--' . Helpers::get_value( $settings, 'iconPosition', 'right' );
		}

		$this->set_attribute( '_compbutton', 'class', $class );
		$this->set_attribute( '_compbutton', 'aria-label', esc_attr( Helpers::get_value( $settings, 'ariaLabel', 'Compare' ) ) );
		$this->set_attribute( '_compbutton', 'role', "button" );

		//* cart button markup start
		echo "<a {$this->render_attributes("_compbutton")}>";

		//*counter markup
		echo $wsl_counter_html;

		//* button contents wrapper start
		$this->set_attribute( '_compbuttoncontents', 'class', 'comp-btn-contents' );
		echo "<span {$this->render_attributes("_compbuttoncontents")}>";

		if( ! empty( $settings['compareIcon'] ) && $button_label !== 'text' )
			echo self::render_icon( $settings['compareIcon'], ['class' => [ 'bu-comp-counter-btn-icon'] ] );
		
		if( ! empty( $settings['buttonText'] ) && $button_label !== 'icon' )
			echo '<span class="bu-comp-counter-btn-text">' . esc_attr( $settings['buttonText'] ) . '</span>';

		echo '</span>'; //* button contents wrapper end

		echo "</a>"; //* comp button markup end

		echo "</div>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-comp-counter">
			<component :is="tag">
				<a 
					:href="settings.cta == 'link' ? settings.pageLink : 'JavaScript: void(0)'" 
					class="bu-comp-counter-btn" 
					:class="[
						`bu-comp-counter-cta-${settings.contentSource}`,
						settings.hideCounter ? 'bu-hide-comp-counter' : 'bu-show-comp-counter',
						settings.contentSource === 'icontext' ? `bu-comp-icon--${settings.iconPosition}`: null,
						!settings.hideCounter && settings.bubble ? 'bu-comp-counter-in-bubble' : null,
						!settings.hideCounter && !settings.bubble ? `bu-comp-counter--${settings.counterPosition}` : null 
					]"
					role="button" 
					:aria-label="settings.ariaLabel"
					:data-comp-config="JSON.stringify({})"
				>
					
					<span class="bu-comp-counter">0</span>

					<span class="comp-btn-contents">
						<icon-svg v-if="settings.compareIcon && settings.contentSource != 'text'" :iconSettings="settings.compareIcon" class="bu-comp-counter-btn-icon"/>
						<span v-if="settings.buttonText != null && settings.contentSource != 'icon'" class="bu-comp-counter-btn-text">{{settings.buttonText}}</span>
					</span>
				</a>
			</component>
		</script>
	<?php 
	}
}