<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, Compare};

class CompareItems extends \Bricks\Element {
	public $category = 'compare';
	public $name 	= 'bu-compare-items';
	public $icon 	= 'ti-reload';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Compare Items', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['itemsContent'] = array(
			'title' 	=> esc_html__( 'Contents', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['cells'] = array(
			'title' 	=> esc_html__( 'Table Cells', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['labels'] = array(
			'title' 	=> esc_html__( 'Labels', 'bricks' ),
			'tab'   	=> 'content'
		);

		/*$this->control_groups['link'] = array(
			'title' 	=> esc_html__( 'Link', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['btext'] = array(
			'title' 	=> esc_html__( 'Basic Text', 'bricks' ),
			'tab'   	=> 'content'
		);*/

		$this->control_groups['rmbtn'] = array(
			'title' 	=> esc_html__( 'Remove Button', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['button'] = array(
			'title' 	=> esc_html__( 'Button', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['wooprice'] = array(
			'title' 	=> esc_html__( 'Woo Price', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['wooqty'] = array(
			'title' 	=> esc_html__( 'Woo Quantity', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['wooatc'] = array(
			'title' 	=> esc_html__( 'Woo Add To Cart', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['woorating'] = array(
			'title' 	=> esc_html__( 'Woo Rating', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['arrows'] = array(
			'title' 	=> esc_html__( 'Arrows', 'bricks' ),
			'tab'   	=> 'content'
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['postType'] = [
			'group' 	=> 'itemsContent',
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'default' 	=> 'post'
		];

		$this->controls['contentSep'] = [
			'group' 	=> 'itemsContent',
			'type'        => 'separator',
			'label'       => esc_html__( 'Add Contents', 'bricks' ),
		];

		$this->controls['ajax'] = [
			'group' 	=> 'itemsContent',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Refresh content via AJAX', 'bricks' ),
		];

		$this->repeater_fields();
		$this->cellControls();
		$this->labelsControls();
		$this->rmButtonsControls();
		$this->buttonsControls();
		$this->priceControls();
		$this->qtyControls();
		$this->atcControls();
		$this->ratingControls();

		$this->arrowsControls();
	}

	public function repeater_fields() {

		$options = [
			'heading' 	=> esc_html__('Heading', 'bricks'),
			'text' 		=> esc_html__('Basic Text', 'bricks'),
			'textlink' 	=> esc_html__('Text Link', 'bricks'),
			'delete' 	=> esc_html__('Remove Item', 'bricks'),
			'btn' 		=> esc_html__('Button', 'bricks'),
			'icon' 		=> esc_html__('Icon', 'bricks'),
		];

		if( class_exists('WooCommerce') ) {
			$options['atc'] = esc_html__('Add To Cart', 'bricksultimate');
			$options['buatc'] = esc_html__('(BU) Add To Cart', 'bricksultimate');
			$options['qty'] = esc_html__('Quantity', 'bricksultimate');
		}

		$this->controls['fields'] = [
			'group' 	=> 'itemsContent',
			'placeholder'   => esc_html__( 'Field', 'bricks' ),
			'type'          => 'repeater',
			'selector' 		=> 'fieldId',
			'titleProperty' => 'label',
			'fields'        => [
				'type' => [
					'label'     => esc_html__( 'Type', 'bricks' ),
					'type'      => 'select',
					'options'   => [
						'dynamicdata' 	=> esc_html__('Dynamic data', 'bricks'),
						'element' 		=> esc_html__('Element', 'bricks'),
					],
					'inline' 	=> true,
					'clearable' => false,
					'default' 	=> 'dynamicdata'
				],
				'label' => [
					'label'     		=> esc_html__( 'Label', 'bricks' ),
					'type'      		=> 'text',
					'hasDynamicData' 	=> true,
					'default' 			=> esc_html__("Put &amp;nbsp; for blank cell", 'bricksultimate')
				],
				'content' => [
					'label'     		=> esc_html__( 'Content', 'bricks' ),
					'type'      		=> 'textarea',
					'linebreak' 		=> 'br',
					'hasDynamicData' 	=> true,
					'required' 			=> [ 'type', '=', 'dynamicdata' ]
				],

				//* Elements controls
				'element' => [
					'label'     => esc_html__( 'Element', 'bricks' ),
					'type'      => 'select',
					'options' 	=> $options,
					'required' 	=> [ 'type', '=', 'element' ]
				],

				//* for heading, text link and button elements
				'headingText' => [
					'label'     	=> esc_html__( 'Text', 'bricks' ),
					'type'        	=> 'text',
					'placeholder' 	=> "{post_title}",
					'hasDynamicData' 	=> true,
					'required' 	=> [ 'element', '=', [ 'heading', 'textlink', 'btn', 'delete'] ]
				],

				//* button element
				'btnSize' => [
					'label'       => esc_html__( 'Size', 'bricks' ),
					'type'        => 'select',
					'options'     => $this->control_options['buttonSizes'],
					'inline'      => true,
					'reset'       => true,
					'default'     => 'sm',
					'placeholder' => esc_html__( 'Default', 'bricks' ),
					'required' 	=> [ 'element', '=', [ 'btn', 'delete'] ],
				],

				'btnStyle' => [
					'label'       => esc_html__( 'Style', 'bricks' ),
					'type'        => 'select',
					'options'     => $this->control_options['styles'],
					'inline'      => true,
					'reset'       => true,
					'default'     => 'primary',
					'placeholder' => esc_html__( 'None', 'bricks' ),
					'required' 	=> [ 'element', '=', [ 'btn', 'delete'] ],
				],

				'btnCircle' => [
					'label' => esc_html__( 'Circle', 'bricks' ),
					'type'  => 'checkbox',
					'reset' => true,
					'required' 	=> [ 'element', '=', [ 'btn', 'delete'] ],
				],

				'btnOutline' => [
					'label' => esc_html__( 'Outline', 'bricks' ),
					'type'  => 'checkbox',
					'reset' => true,
					'required' 	=> [ 'element', '=', [ 'btn', 'delete'] ],
				],

				//* Basic Text element
				'basicText' => [
					'type'        => 'textarea',
					'lineBreak'   => 'br',
					'default'     => esc_html__( 'Here goes your text ... Select any part of your text to access the formatting toolbar.', 'bricks' ),
					'required' 	=> [ 'element', '=', 'text' ]
				],

				'htmlTagText' => [
					'tab'         => 'content',
					'label'       => esc_html__( 'HTML tag', 'bricks' ),
					'type'        => 'select',
					'options'     => [
						'div'        => 'div',
						'p'          => 'p',
						'span'       => 'span',
						'figcaption' => 'figcaption',
						'address'    => 'address',
						'figure'     => 'figure',
						'custom'     => esc_html__( 'Custom', 'bricks' ),
					],
					'lowercase'   => true,
					'inline'      => true,
					'placeholder' => 'div',
					'required' 	=> [ 'element', '=', 'text' ]
				],

				'htmlTag' => [
					'label'       => esc_html__( 'HTML tag', 'bricks' ),
					'type'        => 'select',
					'options'     => [
						'h1'     => 'h1',
						'h2'     => 'h2',
						'h3'     => 'h3',
						'h4'     => 'h4',
						'h5'     => 'h5',
						'h6'     => 'h6',
						'custom' => esc_html__( 'Custom', 'bricks' ),
					],
					'inline'      => true,
					'placeholder' => 'h3',
					'required' 	=> [ 'element', '=', 'heading' ]
				],

				'htmlCustomTag' => [
					'label'       => esc_html__( 'Custom tag', 'bricks' ),
					'type'        => 'text',
					'inline'      => true,
					'placeholder' => 'div',
					'required'    => [[ 'htmlTag', '=', 'custom' ],[ 'element', '=', [ 'heading', 'text' ] ]],
				],

				'linkTo' => [
					'label' => esc_html__( 'Link to', 'bricks' ),
					'type'  => 'link',
					'required' 	=> [ 'element', '=', [ 'heading', 'text', 'textlink', 'btn' ] ]
				],

				'headingTg' => [
					'label' => esc_html__( 'Typography', 'bricks' ),
					'type'  => 'typography',
					'required' 	=> [ 'element', '=', 'heading' ],
					'css' => [
						[
							'selector' => '.brxe-heading',
							'property' => 'font',
						]
					]
				],
				'headingLinkColor' => [
					'label' => esc_html__( 'Link hover color', 'bricks' ),
					'type'  => 'color',
					'css' => [
						[
							'selector' => '.brxe-heading a:hover',
							'property' => 'color'
						]
					],
					'required' 	=> [ [ 'linkTo', '!=', '' ], [ 'element', '=', 'heading' ] ]
				],

				//* Basic Text element
				'wordsLimit' => [
					'label' => esc_html__( 'Words limit', 'bricks' ),
					'type'  => 'number',
					'min'   => 1,
					'required' 	=> [ 'element', '=', 'text' ]
				],
				'readMore' => [
					'label'          => esc_html__( 'Read more', 'bricks' ),
					'type'           => 'text',
					'inline'         => true,
					'hasDynamicData' => false,
					'required'       => [ [ 'wordsLimit', '!=', '' ], [ 'element', '=', 'text' ] ]
				],
				'textTg' => [
					'label' => esc_html__( 'Typography', 'bricks' ),
					'type'  => 'typography',
					'required' 	=> [ 'element', '=', 'text' ],
					'css' => [
						[
							'selector' => '.brxe-text-basic',
							'property' => 'font',
						]
					]
				],

				'linkIcon' => [
					'label' => esc_html__( 'Icon', 'bricks' ),
					'type'  => 'icon',
					'required' 	=> [ 'element', '=', [ 'textlink', 'btn', 'delete' ] ]
				],

				'linkIconPosition' => [
					'label'       => esc_html__( 'Position', 'bricks' ),
					'type'        => 'select',
					'options'     => $this->control_options['iconPosition'],
					'inline'      => true,
					'rerender' 	  => true,
					'placeholder' => esc_html__( 'Left', 'bricks' ),
					'required'    => [ 'linkIcon.icon', '!=', '' ],
				],

				//* Text link typography
				'textLinkTg' => [
					'label' => esc_html__( 'Typography', 'bricks' ),
					'type'  => 'typography',
					'required' 	=> [ 'element', '=', 'textlink' ],
					'css' => [
						[
							'selector' => '.brxe-text-link',
							'property' => 'font',
						]
					]
				],

				'textLinkHoverColor' => [
					'label' => esc_html__( 'Hover color', 'bricks' ),
					'type'  => 'color',
					'required' 	=> [ 'element', '=', 'textlink' ],
					'css' => [
						[
							'selector' => '.brxe-text-link:hover',
							'property' => 'color',
						]
					]
				],

				//* Qty selector
				'triggerSelector' => [
					'label'     	=> esc_html__( 'Add To Cart button selector', 'bricks' ),
					'type'        	=> 'text',
					'placeholder' 	=> ".bu-atc--{post_id} .brxe-bu-atc a",
					'hasDynamicData' 	=> true,
					'required' 	=> [ 'element', '=', [ 'qty' ] ]
				],

				'cssClasses' => [
					'label' => esc_html__( 'CSS Classes', 'bricks' ),
					'type'  => 'text',
					'required' => [ 'type', '!=', 'dynamicdata' ]
				],
			]
		];
	}

	public function cellControls() {
		$this->controls['cntCellMW'] = [
			'group'   => 'cells',
			'label' => esc_html__( 'Content cell min. width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'placeholder' => '225px',
			'css'   => [
				[
					'selector' => '.bu-compare-items td~td',
					'property' => 'min-width',
				],
			],
		];

		$this->controls['cntCellW'] = [
			'group'   => 'cells',
			'label' => esc_html__( 'Content cell width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-items td~td',
					'property' => 'width',
				],
			],
		];

		$this->controls['cellPad'] = [
			'group'   => 'cells',
			'label' => esc_html__( 'Cell padding', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'selector' => '.bu-compare-items td:not(.bu-compare-field--label)',
					'property' => 'padding',
				],
			],
		];

		$this->controls['borderW'] = [
			'group'   => 'cells',
			'label' => esc_html__( 'Border width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-items td, .bu-compare-table-wrapper',
					'property' => 'border-width',
				],
			],
		];

		$this->controls['cellBClr'] = [
			'group'   => 'cells',
			'label' => esc_html__( 'Border color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => '.bu-compare-items td, .bu-compare-table-wrapper',
					'property' => 'border-color',
				],
			],
		];
	}

	public function priceControls() {
		$this->controls['hideRegularPrice'] = [
			'group'   => 'wooprice',
			'label' => esc_html__( 'Hide regular price', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'selector' => 'del',
					'property' => 'display',
					'value'    => 'none',
				],
			],
		];

		$this->controls['regularPriceTypography'] = [
			'group'   => 'wooprice',
			'label' => esc_html__( 'Regular price typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td del',
					'property' => 'font',
				],
			],
		];

		$this->controls['salePriceTypography'] = [
			'group'   => 'wooprice',
			'label' => esc_html__( 'Sale price typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td ins',
					'property' => 'font',
				],
			],
		];
	}

	public function labelsControls() {
		$selector = '.bu-compare-items td.bu-compare-field--label';
		$this->controls['lblPad'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Cell spacing', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'padding',
				],
			],
		];

		$this->controls['lblMW'] = [
			'group' 	=> 'labels',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Min. Width', 'bricks' ),
			'units' 	=> true,
			'placeholder' => '150px',
			'css' 		=> [
				[
					'property' => 'min-width',
					'selector' => $selector
				]
			]
		];

		$this->controls['lblW'] = [
			'group' 	=> 'labels',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['lblBG'] = [
			'group' 	=> 'labels',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['lblFont'] = [
			'group' 	=> 'labels',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['lblAlignment'] = [
			'group' 	=> 'labels',
			'type' 		=> 'text-align',
			'label' 	=> esc_html__( 'Alignment', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'text-align',
					'selector' => $selector
				]
			]
		];
	}

	public function rmButtonsControls() {
		$selector = '.bricks-button.remove-compare-item';

		$this->controls['rmBtnPad'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'padding',
				],
			],
		];

		$this->controls['rmBtnW'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'width',
				],
			],
		];

		$this->controls['rmBtnH'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'height',
				],
			],
		];

		$this->controls['rmBtnBg'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'background-color',
				],
			],
		];

		$this->controls['rmBtnTg'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'font',
				],
			],
		];

		$this->controls['rmBtnBrd'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['rmBtnBs'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'box-shadow',
				],
			],
		];

		$this->controls['rmBtnIconSep'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['rmBtnIconTg'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => $selector . ' i',
					'property' => 'font',
				],
			],
		];

		$this->controls['rmBtnIconHClr'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Hover color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => $selector . ':hover i',
					'property' => 'color',
				],
			],
		];

		$this->controls['rmBtnIconGap'] = [
			'group' => 'rmbtn',
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'gap',
				],
			],
		];
	}

	public function buttonsControls() {
		$selector = '.bricks-button:not(.remove-compare-item)';

		$this->controls['btnPad'] = [
			'group' => 'button',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'padding',
				],
			],
		];

		$this->controls['btnW'] = [
			'group' => 'button',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'width',
				],
			],
		];

		$this->controls['btnH'] = [
			'group' => 'button',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'height',
				],
			],
		];

		$this->controls['btnBg'] = [
			'group' => 'button',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'background-color',
				],
			],
		];

		$this->controls['btnTg'] = [
			'group' => 'button',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'font',
				],
			],
		];

		$this->controls['btnBrd'] = [
			'group' => 'button',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['btnBs'] = [
			'group' => 'button',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'box-shadow',
				],
			],
		];

		$this->controls['btnIconSep'] = [
			'group' => 'button',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['btnIconTg'] = [
			'group' => 'button',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => $selector . ' i',
					'property' => 'font',
				],
			],
		];

		$this->controls['btnIconHClr'] = [
			'group' => 'button',
			'label' => esc_html__( 'Hover color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => $selector . ':hover i',
					'property' => 'color',
				],
			],
		];

		$this->controls['btnIconGap'] = [
			'group' => 'button',
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => $selector,
					'property' => 'gap',
				],
			],
		];
	}

	public function qtyControls(){
		$this->controls['qtyW'] = [
			'group' => 'wooqty',
			'label' => esc_html__( 'Wrapper Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .quantity',
					'property' => 'width',
				],
			],
		];

		$this->controls['qtyBW'] = [
			'group' => 'wooqty',
			'label' => esc_html__( 'Buttons Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .quantity .action',
					'property' => 'width',
				],
			],
		];

		$this->controls['qtyH'] = [
			'group' => 'wooqty',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .brxe-bu-qty',
					'property' => 'height',
				],
			],
		];

		$this->controls['qtyTg'] = [
			'group' => 'wooqty',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .quantity .action',
					'property' => 'font',
				],

				[
					'selector' => '.bu-compare-content-td .quantity .input-text',
					'property' => 'font',
				],
			],
		];

		$this->controls['qtyBC'] = [
			'group' => 'wooqty',
			'label' => esc_html__( 'Border color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .quantity',
					'property' => 'border-color',
				],

				[
					'selector' => '.bu-compare-content-td .quantity .action',
					'property' => 'border-color',
				],
			],
		];
	}
	
	public function atcControls() {

		$this->controls['atcPad'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'padding',
				],
			],
		];

		$this->controls['atcW'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'width',
				],
			],
		];

		$this->controls['atcH'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'height',
				],
			],
		];

		$this->controls['atcBg'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'background-color',
				],
			],
		];

		$this->controls['atcTg'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'font',
				],
			],
		];

		$this->controls['atcBorder'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'border',
				],
			],
		];

		$this->controls['atcBS'] = [
			'group' => 'wooatc',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .add_to_cart_button',
					'property' => 'box-shadow',
				],
			],
		];
	}

	public function ratingControls() {
		$this->controls['starColor'] = [
			'group'   => 'woorating',
			'label' => esc_html__( 'Star color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .star-rating span::before',
					'property' => 'color',
				],
			],
		];

		$this->controls['emptyStarColor'] = [
			'group'   => 'woorating',
			'label' => esc_html__( 'Empty star color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .star-rating::before',
					'property' => 'color',
				],
			],
		];

		$this->controls['starSize'] = [
			'group'   => 'woorating',
			'label' => esc_html__( 'Size', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'selector' => '.bu-compare-content-td .star-rating',
					'property' => 'font-size',
				],
			],
		];
	}

	public function arrowsControls() {

		$this->controls['arrowShow'] = [
			'group'   => 'arrows',
			'label' => esc_html__( 'Display after', 'bricks' ),
			'type'  => 'number',
			'unitless' => false,
			'placeholder' => 3
		];

		$this->controls['leftArrow'] = [
			'group'   => 'arrows',
			'label' => esc_html__( 'Left arrow', 'bricks' ),
			'type'  => 'icon',
			'default' => [
				'library' => 'themify',
				'icon' 	=> 'ti-angle-left'
			]
		];

		$this->controls['rightArrow'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Right arrow', 'bricks' ),
			'type' 		=> 'icon',
			'default' => [
				'library' 	=> 'themify',
				'icon' 		=> 'ti-angle-right'
			]
		];

		$this->controls['arrowSize'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' => [
				[
					'property' 	=> 'font-size',
					'selector' 	=> '.bu-compare-arrow-icon'
				]
			]
		];

		$this->controls['arrowBGColor'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Background color', 'bricks' ),
			'type' 		=> 'color',
			'css' => [
				[
					'property' 	=> 'background-color',
					'selector' 		=> '.bu-compare-table-arrow'
				]
			]
		];

		$this->controls['arrowColor'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Color', 'bricks' ),
			'type' 		=> 'color',
			'css' => [
				[
					'property' 	=> 'color',
					'selector' 		=> '.bu-compare-arrow-icon'
				],
				[
					'property' 	=> 'fill',
					'selector' 		=> '.bu-compare-arrow-icon'
				]
			]
		];

		$this->controls['arrowHColor'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Hover color', 'bricks' ),
			'type' 		=> 'color',
			'css' => [
				[
					'property' 	=> 'color',
					'selector' 		=> '.bu-compare-table-arrow:hover .bu-compare-arrow-icon'
				],
				[
					'property' 	=> 'fill',
					'selector' 		=> '.bu-compare-table-arrow:hover .bu-compare-arrow-icon'
				]
			]
		];

		$this->controls['arrowBorder'] = [
			'group' 	=> 'arrows',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css' => [
				[
					'property' 	=> 'border',
					'selector' 	=> '.bu-compare-table-arrow'
				]
			]
		];

		$this->controls['arrowBW'] = [
			'group' => 'arrows',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'placeholder' => '40px',
			'css'   => [
				[
					'property' => '--arrow-box-width',
				],
			],
		];

		$this->controls['arrowBH'] = [
			'group' => 'arrows',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'placeholder' => '40px',
			'css'   => [
				[
					'selector' => '.bu-compare-table-arrow',
					'property' => 'height',
				],
			],
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-wishlistcompare' );
		}*/

		wp_enqueue_script( 'bu-compare' );
	}

	public function render() {
		$settings = $this->settings;

		if ( empty( $settings['postType'] ) ) {
			return $this->render_element_placeholder(
				[
					'title' => esc_html__( 'Select correct post type.', 'bricks' ),
				]
			);
		}

		if ( empty( $settings['fields'] ) ) {
			return $this->render_element_placeholder(
				[
					'title' => esc_html__( 'No form field added.', 'bricks' ),
				]
			);
		}

		$compareItems = \BricksUltimate\Compare::$compare_ids[ $settings['postType'] ] ?? [];
		$hasItems = true;

		if ( empty( $compareItems ) || count( $compareItems ) <= 0 ) {
			$hasItems = false;
		}

		$this->set_attribute('_root', 'class', "brxe-{$this->id}");

		if( ! empty( $settings['ajax'] ) ) {
			$this->set_attribute( '_root', 'data-comp-ajax-refresh', true );
			$this->set_attribute( '_root', 'data-element-id', $this->id );
			$this->set_attribute( '_root', 'data-post-id', $this->post_id );
		}

		echo "<{$this->tag} {$this->render_attributes( '_root' )}><div class=\"bu-compare-table-wrapper\">";

		$items = count( $compareItems );
		$min_limit = 4;

		if( $hasItems ):
			echo "<table class=\"bu-compare-table repeater-item\">
					<tbody class=\"bu-compare-items brxe-loop-builder-on\">";

			foreach ($settings['fields'] as $key => $field) {
				echo '<tr class="bu-compare-row" data-field-id="'. $field['id'] . '">';

				if( isset( $field['label'] ) )
					echo '<td class="bu-compare-field--label bu-field-label--'. strtolower( str_replace( [' ', '-', '_'], '', $field['label'] ) ) .'">' . $field['label'] . '</td>';

				foreach($compareItems as $index => $item ) {
					$settings['query']['objectType'] 		= 'post';
					$settings['query']['post_type'] 		= [ $settings['postType'], 'product_variation' ];
					$settings['query']['posts_per_page'] 	= 1;
					$settings['query']['post__in']			= [ $item ];

					$query_object = new \Bricks\Query(
						[
							'settings' => $settings,
						]
					);

					$query = $query_object->query_result;

					if ( ! $query->have_posts() ) {
						$query_object->destroy();
						continue;
					}

					$row_content = '';
					$query->original_post_id = $this->post_id;

					while ( $query->have_posts() ) {
						$query->the_post();
						$query->loop_index = $index;
						$query->is_looping = true;
						$query->loop_object = get_post();

						$this->post_id = $item;
						\Bricks\Database::$page_data['original_post_id'] = $item;

						$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'bu-compare-content-td' ]);
						$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'bu-compare-content-type--' . $field['type'], 'bu-compare-content-of--'. $item ] );

						switch( $field['type'] ) {
							case 'element':
								if( ( $element = $field['element'] ?? false ) != false ) {
									$this->set_attribute("_compare_content_{$key}_{$index}", 'class', 'bu-compare-content--' . $element );
									switch( $element ) {
										case 'heading':
											$tag = 'h3';
											$tag = (! empty( $field['htmlTag'] ) && $field['htmlTag'] == 'custom') ? (
												$field['htmlCustomTag'] ?? 'div' ) : ( $field['htmlTag'] ?? 'h3' ); 
											$heading = new \Bricks\Element_Heading([
												'settings' => [
													'text' 	=> bricks_render_dynamic_data( ( $field['headingText'] ?? '{post_title}'), $item ),
													'tag' 	=> $tag,
													'link' 	=> $field['linkTo'] ?? null,
													'_hidden' => [
														'_cssClasses' => 'compare-content-heading ' . ( $field['cssClasses'] ?? '' ),
													],
												]
											]);
											$heading->load();
											ob_start();
											$heading->init();
											$row_content = ob_get_clean();
										break;

										case 'text':
											$tag = 'div';
											$tag = (! empty( $field['htmlTagText'] ) && $field['htmlTagText'] == 'custom') ? (
												$field['htmlCustomTag'] ?? 'div' ) : ( $field['htmlTagText'] ?? 'div' ); 
											$text = new \Bricks\Element_Text_Basic([
												'settings' => [
													'text' 			=> bricks_render_dynamic_data( $field['basicText'], $item ),
													'tag' 			=> $tag,
													'link' 			=> $field['linkTo'] ?? null,
													'wordsLimit' 	=> $field['wordsLimit'] ?? null,
													'readMore' 		=> $field['readMore'] ?? null,
													'_hidden' 		=> [
														'_cssClasses' => 'compare-content-basic-text ' . ( $field['cssClasses'] ?? '' ),
													],
												]
											]);
											$text->load();
											ob_start();
											$text->init();
											$row_content = ob_get_clean();
										break;

										case 'textlink':
											$textLink = new \Bricks\Element_Text_Link([
												'settings' => [
													'text' 	=> bricks_render_dynamic_data( ( $field['headingText'] ?? '{post_title}'), $item, $item ),
													'link' 	=> $field['linkTo'] ?? null,
													'icon' 	=> $field['linkIcon'] ?? null,
													'iconPosition' 	=> $field['linkIconPosition'] ?? "left",
													'_hidden' 		=> [
														'_cssClasses' => $field['cssClasses'] ?? '',
													],
												]
											]);
											$textLink->load();
											ob_start();
											$textLink->init();
											$row_content = ob_get_clean();
										break;

										case 'btn':
											$button = new \Bricks\Element_Button([
												'settings' => [
													'text' 		=> bricks_render_dynamic_data( ( $field['headingText'] ?? esc_html__( 'Button', 'bricks' ) ), $item ),
													'size' 		=> $field['btnSize'] ?? 'sm',
													'style' 	=> $field['btnStyle'] ?? 'primary',
													'circle' 	=> $field['btnCircle'] ?? null,
													'outline' 	=> $field['btnOutline'] ?? null,
													'link' 		=> $field['linkTo'] ?? null,
													'icon' 		=> $field['linkIcon'] ?? null,
													'iconPosition' 	=> $field['linkIconPosition'] ?? "left",
													'_hidden' 	=> [
														'_cssClasses' => 'compare-content-button ' . ( $field['cssClasses'] ?? '' ),
													],
												]
											]);
											$button->load();
											ob_start();
											$button->init();
											$row_content = ob_get_clean();
										break;

										case 'delete':
											$remove = new \Bricks\Element_Button([
												'settings' => [
													'text' 		=> bricks_render_dynamic_data( ( $field['headingText'] ?? null ), $item ),
													'size' 		=> $field['btnSize'] ?? 'sm',
													'style' 	=> $field['btnStyle'] ?? null,
													'circle' 	=> $field['btnCircle'] ?? null,
													'outline' 	=> $field['btnOutline'] ?? null,
													'link' 		=> Array('type' => 'external', 'url' => get_permalink($query->original_post_id) . "?remove={$item}" ),
													'icon' 		=> $field['linkIcon'] ?? null,
													'iconPosition' 	=> $field['linkIconPosition'] ?? "left",
													'_hidden' 	=> [
														'_cssClasses' => 'remove-compare-item ' . ( $field['cssClasses'] ?? '' ),
													],
													'_attributes' => [
														[
															'name' => 'data-item-id',
															'value' => $item
														],

														[
															'name' => 'data-post-type',
															'value' => $settings['postType']
														]
													]
												]
											]);
											$remove->load();
											ob_start();
											$remove->init();
											$row_content = ob_get_clean();
										break;

										case 'icon':
											$icon = new \Bricks\Element_Icon([
												'settings' => [
													'icon' => [
														'icon' 		=> 'ti-star',
														'library' 	=> 'themify',
													],
													'iconSize' => '18px',
													'_hidden' 		=> [
														'_cssClasses' => $field['cssClasses'] ?? '',
													],
												]
											]);
											$icon->load();
											ob_start();
											$icon->init();
											$row_content = ob_get_clean();
										break;

										case 'atc':
											$atc = new \Bricks\Product_Add_To_Cart([
												'settings' => [
													'_hidden' 		=> [
														'_cssClasses' => $field['cssClasses'] ?? '',
													],
												]
											]);
											$atc->load();
											ob_start();
											$atc->init();
											$row_content = ob_get_clean();
											$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'bu-atc--' . $item ]);
										break;

										case 'buatc':
											$buatc = new \BricksUltimate\Elements\WooAddToCart([
												'settings' => [
													'isQueryLoopOn' => true,
													'_hideVC' => true,
													'_hidden' => [
														'_cssClasses' => $field['cssClasses'] ?? '',
													],
												]
											]);
											$buatc->load();
											ob_start();
											$buatc->init();
											$row_content = ob_get_clean();

											//$buatc->enqueue_element_scripts();
											$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'bu-atc--' . $item ]);
										break;

										case 'qty':
											$qty = new \BricksUltimate\Elements\WooQuantity([
												'settings' => [
													'triggerSelector' => bricks_render_dynamic_data( $field['triggerSelector'] ?? '.bu-atc--'. $item . ' .brxe-bu-atc a', $item ),
													'_hidden' 		=> [
														'_cssClasses' => $field['cssClasses'] ?? '',
													],
												]
											]);
											$qty->load();
											ob_start();
											$qty->init();
											$row_content = ob_get_clean();

											//$qty->enqueue_element_scripts();

											$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'bu-compare-content--quantity' ]);
										break;
									}
								} else {
									$row_content = '';
								}
								break;
							default:
								$row_content = ! empty( $field['content'] ) ? bricks_render_dynamic_data( $field['content'], $item ) : '';
								break;
						}
					}

					wp_reset_postdata();

					echo "<td {$this->render_attributes("_compare_content_{$key}_{$index}")}>{$row_content}</td>";

					$this->post_id = \Bricks\Database::$page_data['original_post_id'] = $query->original_post_id;

					if ( $query_object ) {
						$query_object->destroy();
						unset( $query );
					}
				}

				if( $items < $min_limit ) {
					$left = $min_limit - $items;
					for($i = 0; $i < $left; $i++ ) {
						$index = $i + $items + 1;
						$this->set_attribute("_compare_content_{$key}_{$index}", 'class', [ 'blank-cell' ] );
						echo "<td {$this->render_attributes("_compare_content_{$key}_{$index}")}></td>";
					}
				}

				echo '</tr>';
			}

			echo "	</tbody></table>";
		endif;

		echo "</div>";

		//* Adds prev/next button
		$limit = Helpers::get_value( $settings, 'arrowShow', 0);
		if( $hasItems && $items > $limit ) {
			$leftArrow = isset($settings['leftArrow']) ? self::render_icon($settings['leftArrow'], ['bu-compare-arrow-icon', 'left-arrow-icon']) : '';
			$rightArrow = isset($settings['rightArrow']) ? self::render_icon($settings['rightArrow'], ['bu-compare-arrow-icon', 'right-arrow-icon']) : '';

			if( is_rtl() ) {
				echo "<span class=\"bu-compare-table-arrow\" data-side=\"right\">{$rightArrow}</span>&nbsp;&nbsp;&nbsp;
				<span class=\"bu-compare-table-arrow\" data-side=\"left\">{$leftArrow}</span>";
			} else {
				echo "<span class=\"bu-compare-table-arrow\" data-side=\"left\">{$leftArrow}</span>&nbsp;&nbsp;&nbsp;
				<span class=\"bu-compare-table-arrow\" data-side=\"right\">{$rightArrow}</span>";
			}
		}

		echo "</{$this->tag}>";
	}
}