<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class SliderArrows extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-sld-arrows';
	public $icon 			= 'ti-arrows-horizontal';
	public $tag 			= 'div';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Slider arrows', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['sldSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Bricks Nested Slider'),
			'type' 	=> 'separator',
		];

		$this->controls['scriptId'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Script ID'),
			'type' 	=> 'text',
			'inline' => true
		];

		$this->controls['arrowSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Styles'),
			'type' 	=> 'separator',
		];

		$selector = '.splide__arrow';
		$iconSelector = '.splide__arrow--icon';

		$this->controls['arrowMrg'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Margin'),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$this->controls['arrowPad'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Padding'),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['arrowBG'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Background'),
			'type' 	=> 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['arrowColor'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => $iconSelector
				],
				[
					'property' => 'fill',
					'selector' => $iconSelector
				],
				[
					'property' => 'color',
					'selector' => $selector
				],
			],
		];

		$this->controls['arrowSize'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Size', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => $selector
				],
				[
					'property' => 'font-size',
					'selector' => $iconSelector
				],
			],
		];

		$this->controls['border'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$this->controls['hoverSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Hover'),
			'type' 	=> 'separator',
		];

		$this->controls['arrowHColor'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover ' . $iconSelector
				],
				[
					'property' => 'fill',
					'selector' => $selector . ':hover ' . $iconSelector
				],
				[
					'property' => 'color',
					'selector' => $selector . ":hover"
				],
			],
		];

		$this->controls['arrowHBG'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Background'),
			'type' 	=> 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":hover"
				]
			],
		];

		$this->controls['hborder'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => $selector . ":hover"
				]
			],
		];

		$this->controls['_position']['default'] = 'relative';
	}

	public function get_nestable_children() {
		return [
			$this->getPreviousSettings(),
			$this->getNextSettings()
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-sld-arrow', Helpers::get_asset_url('css') . 'sldarrow.min.css', [], filemtime(Helpers::get_asset_path('css') . 'sldarrow.min.css'), 'all' );
		wp_enqueue_script( 'bu-sld-arrow', Helpers::get_asset_url('js') . 'sldarrow.min.js', [], filemtime(Helpers::get_asset_path('js') . 'sldarrow.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$sliderID = Helpers::get_value( $this->settings, 'scriptId', '');
		if( empty( $sliderID ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'Nested slider script ID is required.', 'bricksultimate' ),
					'description' => esc_html__( 'Add a slider(Nestable) element on canvas, copy the 6 digit ID and paste into Script ID input box.', 'bricksultimate' ),
				]
			);
		}
		
		$this->set_attribute( '_root', 'class', [ 'splide__arrows' ] );
		$this->set_attribute( '_root', 'data-sld-script-id', $sliderID );

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
		echo \Bricks\Frontend::render_children( $this );
		echo "</{$this->tag}>";
	}

	function getPreviousSettings() {
		return [
			'name'     	=> 'div',
			'label' 	=> esc_html__('Previous button', 'bricksultimate'),
			'settings' 	=> [
				'tag' 		=> 'custom',
				'customTag' => 'button',
				'_hidden' 	=> [
					'_cssClasses' => 'splide__arrow splide__arrow--prev'
				],
				'_attributes' => [
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'type', 
						'value' => 'button' 
					],
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'aria-label', 
						'value' => 'Previous slide'
					],
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'aria-controls', 
						'value' => 'splide01-track'
					]
				],
			],
			'children' 	=> [
				[
					'name' 		=> 'icon',
					'label' 	=> esc_html__('Prev arrow', 'bricksultimate'),
					'settings' 	=> [
						'icon' => [
							'icon'    => 'ti-angle-left',
							'library' => 'themify',
						],
						'iconSize' => '20px',
						'_hidden' 	=> [
							'_cssClasses' => 'splide__arrow--icon'
						],
					]
				]
			]
		];
	}

	function getNextSettings() {
		return [
			'name' 		=> 'div',
			'label' 	=> esc_html__('Next button', 'bricksultimate'),
			'settings' 	=> [
				'tag' 		=> 'custom',
				'customTag' => 'button',
				'_hidden' 	=> [
					'_cssClasses' => 'splide__arrow splide__arrow--next'
				],
				'_attributes' => [
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'type', 
						'value' => 'button' 
					],
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'aria-label', 
						'value' => 'Next slide'
					],
					[
						'id' => \Bricks\Helpers::generate_random_id( false ), 
						'name' => 'aria-controls', 
						'value' => 'splide01-track'
					]
				],
			],
			'children' 	=> [
				[
					'name' 		=> 'icon',
					'label' 	=> esc_html__('Next arrow', 'bricksultimate'),
					'settings' 	=> [
						'icon' => [
							'icon'    => 'ti-angle-right',
							'library' => 'themify',
						],
						'iconSize' => '20px',
						'_hidden' 	=> [
							'_cssClasses' => 'splide__arrow--icon'
						],
					]
				]
			]
		];
	}
}