<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooAddOrderBumps extends \Bricks\Element {
	public $category = 'ultimate';
	public $name 	= 'bu-add-order-bumps';
	public $icon 	= 'ti-shopping-cart-full';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Add Order Bumps', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['radio'] = [
			'title' 	=> esc_html__( 'Radio', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['actionType', '=', 'rb']
		];

		$this->control_groups['checkbox'] = [
			'title' 	=> esc_html__( 'Checkbox', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['actionType', '=', 'cb'],
		];

		$this->control_groups['icon']  = array(
			'title' => esc_html__( 'Icon', 'bricks' ),
			'tab'   => 'content',
			'required' 	=> ['actionType', '=', 'btn'],
		);

		$this->control_groups['style'] = array(
			'title' => esc_html__( 'Button Styles', 'bricks' ),
			'tab'   => 'content',
			'required' 	=> ['actionType', '=', 'btn'],
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['actionType'] = [
			'label'       => esc_html__( 'Action type', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [
				'cb' 	=> 'Checkbox',
				'rb' 	=> 'Radio',
				'btn' 	=> 'Button'
			],
			'default' => 'cb',
		];

		$this->controls['label'] = [
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'type' 	=> 'text',
		];

		$this->controls['labelTg'] = [
			'label' => esc_html__( 'Label typography', 'bricksultimate' ),
			'type' 	=> 'typography',
			'css' 	=> [
				'property' => 'font',
				'selector' => '.input-label'
			]
		];

		/**
		 * Radio
		 * ----------------------------------------*/
		$rd_selector = 'input[type=radio]';

		$this->controls['rdsize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			]
		];

		$rdc_checked = 'input[type=radio]:checked';
		$this->controls['rdcbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
		];

		$this->controls['rdcbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rdc_checked,
				]
			]
		];

		$bullet = 'input[type=radio]:checked:after';
		$this->controls['rdwrdsz'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $bullet
				],
				[
					'property' => 'height',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdwrdsz'] = [
			'group' 	=> 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdBulletPos'] = [
			'group' 	=> 'radio',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
		];

		/**
		 * Checkbox
		 * ----------------------------------------*/
		$cb_selector = 'input[type=checkbox]';

		$this->controls['cbsize'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'height',
					'selector' => $cb_selector,
				]
			],
		];

		$this->controls['cbbg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_selector,
				]
			],
		];

		$this->controls['cbbrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_selector,
				]
			]
		];

		$cb_checked = 'input[type=checkbox]:checked';
		$this->controls['cbcbg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_checked,
				]
			],
		];

		$this->controls['cbcbrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_checked,
				]
			]
		];


		/**
		 * Icon
		 */
		$this->controls['icon'] = [
			'tab'   => 'content',
			'group' => 'icon',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-close',
			],
		];

		$this->controls['iconPosition'] = [
			'tab'         => 'content',
			'group' 	  => 'icon',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Gap', 'bricksultimate' ),
			'type'     	=> 'number',
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css'      	=> [
				[
					'property' => 'gap',
					'selector' => '',
				],
			],
			'placeholder' => '10px',
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Margin', 'bricks' ),
			'type'     	=> 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => '.remove-icon',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group' 	=> 'icon',
			'label'    => esc_html__( 'Size & Color', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.buob-btn-icon',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconHColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '.buob-btn-icon:hover',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		/**
		 * Styles section
		 */
		$selector = '&';

		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'group' 		=> 'style',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display'
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'group' 		=> 'style',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'default' 		=> 'nowrap',
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['direction'] = [
			'tab'      => 'content',
			'group' 	=> 'style',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      		=> 'content',
			'group' 		=> 'style',
			'label'    		=> esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  		=> [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     		=> 'justify-content',
			'css'      		=> [
				[
					'property' => 'justify-content',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      		=> 'content',
			'group' 		=> 'style',
			'label'    		=> esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip' 		=> [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['spSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Sizing & Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'height'
				]
			]
		];

		//margin field
		$this->controls['margin'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin'
				]
			],
		];

		//padding field
		$this->controls['padding'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding'
				]
			],
		];

		$this->controls['colorsSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Colors & Font', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['backgroundColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnfont'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font'
				],
			]
		];

		$this->controls['brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['bsshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['hoverSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['hBoxshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-add-order-bumps', Helpers::get_asset_url('css') . 'addorderbumps.min.css', [], filemtime(Helpers::get_asset_path('css') . 'addorderbumps.min.css'), 'all' );
		}*/

		wp_enqueue_script( 'bu-checkout', Helpers::get_asset_url('js') . 'checkout.min.js', [], filemtime(Helpers::get_asset_path('js') . 'checkout.min.js') );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		global $product;
		$product_id = get_post_meta( $this->post_id, '_buob_offer_product', true );
		
		if( $product_id ) {
			$product = wc_get_product( $product_id );
		}

		if( empty( $product ) && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if ( empty( $product ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'For better preview select content to show.', 'bricks' ),
					'description' => esc_html__( 'Go to: Settings > Template Settings > Populate Content', 'bricks' ),
				]
			);
		}

		if( ! $product->is_in_stock() || ! $product->is_purchasable() ) {
			$this->set_attribute( '_root', 'class', [ 'buob-sold-out' ] );
			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			echo esc_html__( 'Sold Out', 'woocommerce' );
			echo "</{$this->tag}>";
			return;
		}

		$quantity = get_post_meta( $this->post_id, '_buob_offer_product_quantity', true );
		$quantity = ! empty( $quantity ) ? $quantity : 1;

		$isBundle = get_post_meta( $this->post_id, '_buob_on_single_page', true );

		$label = Helpers::get_value( $settings, 'label', false );
		$actionType = Helpers::get_value( $settings, 'actionType', 'cb' );

		if( 'btn' == $actionType && $label ) { // Button

			$this->tag = "button";
			$this->set_attribute( '_root', 'class', ['buob-add-to-cart-btn'] );
			$this->set_attribute( '_root', 'type', 'button' );
			$this->set_attribute( '_root', 'data-quantity', $quantity );
			$this->set_attribute( '_root', 'data-product_id', $product_id );
			$this->set_attribute( '_root', 'data-order-bumps', $this->post_id );

			if( ! empty( $isBundle ) ) {
				$this->set_attribute( '_root', 'data-offer-type', 'bundle' );
			}

			$icon = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'], [ 'class' => [ 'buob-btn-icon' ] ] ) : '' ;

			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			echo "<span class='input-label'>{$label}</span>";
			echo $icon;
			echo "</{$this->tag}>";

		} elseif( 'rb' == $actionType ) { // Radio

			$this->set_attribute( '_root', 'class', ['buob-radio-button'] );

			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			
			printf( 
				'<input type="radio" data-product_id="%1$s" data-order-bumps="%2$s" data-quantity="%3$s" data-offer-type="%4$s" class="buob-add-to-cart" />', 
				$product_id, 
				$this->post_id, 
				$quantity, 
				( ! empty( $isBundle ) ? "bundle" : "order-bumps" )  
			);

			if( $label ) {
				echo "<label for='rb-label' class='input-label'>{$label}</label>";
			}
			echo "</{$this->tag}>";

		} else { // Checkbox

			$this->set_attribute( '_root', 'class', ['buob-checkbox'] );

			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			printf( 
				'<input type="checkbox" data-product_id="%1$s" data-order-bumps="%2$s" data-quantity="%3$s" data-offer-type="%4$s" class="buob-add-to-cart" />', 
				$product_id, 
				$this->post_id, 
				$quantity,
				( ! empty( $isBundle ) ? "bundle" : "order-bumps" )
			);

			if( $label ) {
				echo "<label for='cb-label' class='input-label'>{$label}</label>";
			}
			echo "</{$this->tag}>";

		}
	}
}