<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;
use BricksUltimate\Trait\TooltipControls;
use BricksUltimate\Trait\WooQuickAddFormControls;

class WooAddToCart extends \Bricks\Element {
	use TooltipControls;
	use WooQuickAddFormControls;

	public $category = 'ultimate';
	public $name 	= 'bu-atc';
	public $icon 	= 'ti-shopping-cart-full';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Add To Cart', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['layout'] = array(
			'title' 	=> esc_html__( 'Wrapper', 'bricks' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['qty'] = array(
			'title' 	=> esc_html__( 'Quantity', 'bricksultimate' ),
			'tab'   	=> 'content',
		);

		$this->control_groups['button'] = array(
			'title' 	=> esc_html__( 'Add To Cart Button', 'bricksultimate' ),
			'tab'   	=> 'content'
		);

		$this->control_groups['qtybtn'] = array(
			'title' 	=> esc_html__( 'Qty + Button Layout', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '=', false ]
		);

		$this->control_groups['_viewCart'] = array(
			'title' 	=> esc_html__( 'View Cart Button', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '=', true ]
		);

		$this->control_groups['quickadd'] = array(
			'title' 	=> esc_html__( 'Quick Add - Variable Products', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '=', true ]
		);

		$this->control_groups['buynow'] = array(
			'title' 	=> esc_html__( 'Buy Now Button', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);

		$this->control_groups['price'] = array(
			'title' 	=> esc_html__( 'Price', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);

		$this->control_groups['_variations'] = array(
			'title' 	=> esc_html__( 'Variations', 'woocommerce' ),
			'tab'   	=> 'content',
			//'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);

		if( ! empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) && \BricksUltimate\Plugin::$bu_settings['swatches'] == 'enabled' ) 
		{
			$this->control_groups['_swatches'] = array(
				'title' 	=> esc_html__( 'Swatches', 'bricksultimate' ),
				'tab'   	=> 'content',
				//'required' 	=> [ 'isQueryLoopOn', '!=', true ]
			);
		}

		$this->control_groups['_clearBtn'] = array(
			'title' 	=> esc_html__( 'Clear Text', 'bricksultimate' ),
			'tab'   	=> 'content',
			//'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);

		$this->control_groups['_availability'] = array(
			'title' 	=> esc_html__( 'Availability', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);

		$this->control_groups['_groupPrd'] = array(
			'title' 	=> esc_html__( 'Group Products', 'bricksultimate' ),
			'tab'   	=> 'content',
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['isQueryLoopOn'] = [
			'tab' 		=> 'content',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Using inside the query loop builder?', 'bricksultimate' ),
			'reset'    => true,
		];

		$this->controls['isStickyButton'] = [
			'tab' 		=> 'content',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Using as sticky button?', 'bricksultimate' ),
			'reset'    => true,
		];

		$this->controls['ajaxATC'] = [
			'tab' 		=> 'content',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'AJAX Add To Cart action', 'bricksultimate' ),
			'info'    	=> esc_html__( 'Sometimes it is conflicting with other plugins and not working properly. You will use at your own risk.', 'bricksultimate' ),
			'reset'    => true,
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		];

		$this->controls['redirectLink'] = [
			'tab' 		=> 'content',
			'type' 		=> 'link',
			'label'		=> esc_html__( 'Redirect URL', 'bricksultimate' ),
			'exclude' 	=> [
				'title',
				'ariaLabel',
				'newTab',
				'rel'
			],
			'required' 	=> [ 'ajaxATC', '=', true ]
		];


		/**
		 * Layout controls
		 */
		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'group'       => 'layout',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => '',
				],
			],
			'placeholder' => 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'group' => 'layout',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['direction'] = [
			'tab'      => 'content',
			'group'    => 'layout',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'default'  => 'row',
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignSelf'] = [
			'tab'      => 'content',
			'group' => 'layout',
			'label'    => esc_html__( 'Align container', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-self',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property'  => 'align-self',
					'important' => true,
				],
				[
					'selector' => '',
					'property' => 'width',
					'value'    => '100%',
					'required' => 'stretch', // NOTE: Undocumented (@since 1.4)
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      => 'content',
			'group' => 'layout',
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      => 'content',
			'group' => 'layout',
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['spacingSeparator'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Spacing', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['margin'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => '',
				]
			],
		];

		$this->controls['padding'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
				]
			],
		];

		// Sizing: (width, height)

		$this->controls['sizingSeparator'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Sizing', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['width'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '',
				],
			],
		];

		$this->controls['height'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
		];


		/**
		 * Price controls
		 */
		$this->controls['showPrice'] = [
			'tab' 		=> 'content',
			'group' 	=> 'price',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Show price', 'bricksultimate' ),
			'reset' 	=> true
		];

		$this->controls['hideRegularPrice'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Hide strick through price', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'selector' => 'del',
					'property' => 'display',
					'value'    => 'none',
				],
			],
			'required' 	=> [ 'showPrice', '!=', false ]
		];

		$this->controls['saleTypography'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Strick through price typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.price del',
					'property' => 'font',
				],
			],
			'required' 	=> [ 'showPrice', '!=', false ]
		];

		$this->controls['priceTypography'] = [
			'tab'   => 'content',
			'group' => 'price',
			'label' => esc_html__( 'Price typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'selector' => '.price ins',
					'property' => 'font',
				],
			],
			'required' 	=> [ 'showPrice', '!=', false ]
		];

		$this->controls['_priceMargin'] = [
			'tab'   	=> 'content',
			'group' 	=> 'price',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' 	=> '.price',
				],
			]
		];



		/**
		 * Quantity controls
		 */
		$selector = '.quantity';

		$this->controls['showQty'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Show quantity field', 'bricksultimate' ),
			'inline'    => true,
			'required' => ['isQueryLoopOn', '=', true ]
		];

		$this->controls['qtyWrapSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['wrapperWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector,
				],
			],
			'placeholder' => '200px'
		];

		$this->controls['wrapperHeight'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => $selector,
				],
			],
			'placeholder' => '40px'
		];

		$this->controls['wrapperMargin'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
			'placeholder' => '40px'
		];

		$this->controls['wrapperBg'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$this->controls['wrapperBorder'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$this->controls['pmBtnQtyText'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Quantity Text', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['showQtyText'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Show quantity text', 'bricksultimate' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		$this->controls['qtyText'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Text', 'bricksultimate' ),
			'type'  => 'text',
			'hasDynamicData' => false,
			'placeholder' => esc_html__('Quantity:', 'bricksultimate')
		];

		$this->controls['qtyTextMD'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Text for Mobile Devices', 'bricksultimate' ),
			'type'  => 'text',
			'hasDynamicData' => false,
			'placeholder' => esc_html__('Qty:', 'bricksultimate')
		];

		$this->controls['columnsWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Grid Columns Width', 'bricksultimate' ),
			'type'  => 'text',
			'hasDynamicData' => false,
			'placeholder' => '150px 160px 1fr',
			'css'   => [
				[
					'property' => 'grid-template-columns',
					'selector' => '.bu-atc-btn-wrapper',
				],
			]
		];

		$this->controls['qtyTextOuterBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Outer Border', 'bricksultimate' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.bu-atc-btn-wrapper',
				],
			]
		];

		$this->controls['qtyTextTG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Text Typography', 'bricksultimate' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.bu-qty-text',
				],
			]
		];

		$this->controls['pmBtnSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( '+/- Buttons', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['hidePMBtns'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hide +/- Buttons', 'bricksultimate' ),
			'type'  => 'checkbox',
			'reset' => true,
			'css' 	=> [
				[
					'selector' 	=> '.quantity .action',
					'property' 	=> 'display',
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['pmBtnWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.quantity .action',
				]
			],
			'placeholder' => '90px'
		];

		$this->controls['pmBtnHeight'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => '.quantity .action',
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
			'placeholder' => '40px'
		];

		$this->controls['pmBtnBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .action',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnHBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .action:hover',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnSize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'unit' 	=> 'px',
			'placeholder' => '12px', 
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['pmBtnColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnHClr'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .action:hover svg',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['pmBtnBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .action',
					'property' 	=> 'border',
					'important' => true,
				]
			]
		];

		$this->controls['inpSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Quantity field', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['inpPosition'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Position', 'bricks' ),
			'type'  => 'select',
			'inline' => true,
			'options'   => [
				'center' 	=> esc_html__( 'Center' ),
				'left' 		=> esc_html__( 'Left' ),
			],
			'default' => 'center'
		];

		$this->controls['inpWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.quantity .qty',
				],
			],
			'default' => '45px'
		];

		$this->controls['inpHeight'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => '.quantity .qty',
				],
			],
			'placeholder' => '40px'
		];

		$this->controls['inpBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .qty',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['inpFocusBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .qty:focus',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['inpFont'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'exclude' => [
				'text-transform',
				'text-shadow',
				'font-style',
				'text-align'
			],
			'css' 	=> [
				[
					'selector' 	=> '.quantity .qty',
					'property' 	=> 'font',
				]
			]
		];

		$this->controls['inpFocusColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> '.quantity .qty:focus',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['inpBorder'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> '.quantity input[type=number]',
					'property' 	=> 'color',
				]
			]
		];


		/**
		 * Button styles
		 */
		$this->controls['_hideATC'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'label'    	=> esc_html__( 'Hide button', 'bricks' ),
			'description' => esc_html__('Button will hide after adding the product to cart.', 'bricksultimate'),
			'type'     	=> 'checkbox',
			'reset' 	=> true,
			'css'      	=> [
				[	
					'value' 	=> 'none',
					'property' 	=> 'display',
					'selector' 	=> '.bricks-button.added',
				],
				[	
					'value' 	=> 'none',
					'property' 	=> 'display',
					'selector' 	=> '.button.added',
				],
				[	
					'value' 	=> 'none',
					'property' 	=> 'display',
					'selector' 	=> '.quantity.added',
				],
			]
		];

		$this->controls['singleATCText'] = [
			'group' => 'button',
			'label' => esc_html__( 'Add To Cart Text', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'Add to cart', 'woocommerce' ),
			'required' 	=> [ 'isQueryLoopOn', '!=', true ]
		];

		$this->controls['changeATCText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Change Button Text', 'bricksultimate' ),
			'type'  => 'checkbox',
			'required' 	=> [ 'isQueryLoopOn', '=', true ],
			'inline' => true,
		];

		$this->controls['simpleBtnText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Add To Cart Text', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'Add to cart', 'woocommerce' ),
			'required' 	=> [ 'changeATCText', '=', true ]
		];

		$this->controls['addedBtnText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Added Button Text', 'bricksultimate' ),
			'description' 	=> esc_html__( 'It would work on shop, archive pages and other places if AJAX add to cart action is enabled.', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'Added', 'woocommerce' ),
		];

		$this->controls['disableTickIcon'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Disable tick icon', 'bricksultimate' ),
			'type'  => 'checkbox',
			'inline' => true,
		];

		$this->controls['variableBtnText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Select Options Text', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'Select options', 'woocommerce' ),
			'required' 	=> [ 'changeATCText', '=', true ]
		];

		$this->controls['rmBtnText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Read More Text', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'Read more', 'woocommerce' ),
			'required' 	=> [ 'changeATCText', '=', true ]
		];

		$this->controls['groupedBtnText'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'View Products Text', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => __( 'View product', 'woocommerce' ),
			'required' 	=> [ 'changeATCText', '=', true ]
		];

		$this->controls['btnSep'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'separator'
		];

		$this->controls['btnWidth'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.button',
				],
				[
					'property' => 'width',
					'selector' => '',
				],
			],
		];

		$this->controls['btnHeight'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => '.button',
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
		];

		$this->controls['btnFlexGrow'] = [
			'tab'         => 'content',
			'group' 		=> 'button',
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
					'selector' => '.button',
				],
			],
			'placeholder' => 0
		];

		$this->controls['circle'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Circle', 'bricks' ),
			'type'  	=> 'checkbox',
			'reset' 	=> true,
			'required' 	=> [ 'isQueryLoopOn', '=', true ],
		];

		$this->controls['btnSpacingSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type' 		=> 'separator'
		];

		$this->controls['btnMargin'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => '.button',
				],
			]
		];

		$this->controls['btnPadding'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '.button',
				],
			]
		];

		$this->controls['btnStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'type' 		=> 'separator'
		];

		$this->controls['btnBgColor'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button',
					'property' => 'background-color'
				],
			]
		];

		$this->controls['atcTypography'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button',
					'property' => 'font'
				],
			]
		];

		$this->controls['atcBorder'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button',
					'property' => 'border'
				],
			]
		];

		$this->controls['atcBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button',
					'property' => 'box-shadow',
				],
			]
		];

		$this->controls['btnHoverSep'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'separator',
			'label' => esc_html__('Hover State', 'bricks'),
		];

		$this->controls['btnHBgColor'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button:hover',
					'property' => 'background-color'
				],
			]
		];

		$this->controls['atcHoverColor'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'color',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button:hover',
					'property' => 'color'
				],
			]
		];

		$this->controls['atcHBorder'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button:hover',
					'property' => 'border'
				],
			]
		];

		$this->controls['atcHBoxshadow'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.button:hover',
					'property' => 'box-shadow',
				],
			]
		];

		$this->controls['btnIconSep'] = [
			'tab'   => 'content',
			'group' => 'button',
			'type'  => 'separator',
			'label' => esc_html__('Icon', 'bricks'),
		];

		$this->controls['icon'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
		];

		$this->controls['optionIcon'] = [
			'tab'   => 'content',
			'group' => 'button',
			'label' => esc_html__( 'Icon of Select Options button', 'bricks' ),
			'type'  => 'icon',
			'required' => [ 'isQueryLoopOn', '=', true ]
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group' 	=> 'button',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => 'i',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconHColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '.button:hover i, .button:hover svg',
				],
				[
					'property' => 'fill',
					'selector' => '.button:hover i, .button:hover svg',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconPosition'] = [
			'tab'         => 'content',
			'group' 	  => 'button',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '.button',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ 'icon.icon', '!=', '' ],
		];


		$this->controls['iconMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'label'    	=> esc_html__( 'Gap between icon & text', 'bricks' ),
			'type'     	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => 'i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];


		/**
		 * Qty + button
		 */
		$this->controls['qtyDisplay'] = [
			'tab'         => 'content',
			'group'       => 'qtybtn',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'inline-flex'  => 'inline-flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => 'form.cart, .woocommerce-variation-add-to-cart',
				],
			],
			'placeholder' => 'flex'
		];

		$this->controls['qtyFlexWrap'] = [
			'tab'         	=> 'content',
			'group' 		=> 'qtybtn',
			'label'       	=> esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     	=> [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        	=> 'select',
			'options'     	=> $this->control_options['flexWrap'],
			'inline'     	=> true,
			'css'         	=> [
				[
					'property' => 'flex-wrap',
					'selector' => 'form.cart, .woocommerce-variation-add-to-cart',
				],
			],
			'placeholder' => esc_html__( 'Wrap', 'bricks' ),
			'required' => ['qtyDisplay', '=', [ '', 'flex' ] ]
		];

		$this->controls['qtyFlexDirection'] = [
			'tab'      => 'content',
			'group'    => 'qtybtn',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
					'selector' => 'form.cart, .woocommerce-variation-add-to-cart',
				],
			],
			'default'  => 'row',
			'inline'   => true,
			'rerender' => true,
			'required' => ['qtyDisplay', '=', [ '', 'flex' ] ]
		];


		/**
		 * View cart button
		 */
		$selector = '.added_to_cart';

		$this->controls['_hideVC'] = [
			'tab' 		=> 'content',
			'group' 	=> '_viewCart',
			'label'    	=> esc_html__( 'Hide button', 'bricks' ),
			'type'     	=> 'checkbox',
			'reset' 	=> true,
			'css'      	=> [
				[	
					'value' 	=> 'none',
					'property' 	=> 'display',
					'selector' 	=> $selector,
				],
			]
		];

		$this->controls['_vcWidth'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' 	=> $selector,
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHeight'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' 	=> $selector,
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['textAxisY'] = [
			'tab'      		=> 'content',
			'group' 		=> '_viewCart',
			'label'    		=> esc_html__( 'Text Align main axis', 'bricks' ),
			'tooltip'  		=> [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     		=> 'justify-content',
			'css'      		=> [
				[
					'property' => 'justify-content',
					'selector' 	=> $selector,
				],
			],
			'default' 	=> 'center',
		];

		$this->controls['textAxisX'] = [
			'tab'      		=> 'content',
			'group' 		=> '_viewCart',
			'label'    		=> esc_html__( 'Text Align cross axis', 'bricks' ),
			'tooltip' 		=> [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
					'selector' 	=> $selector,
				],
			],
			'default' 	=> 'center',
		];

		$this->controls['_vcSpacingSep'] = [
			'tab'   	=> 'content',
			'group' 	=> '_viewCart',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type' 		=> 'separator',
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcMargin'] = [
			'tab'   	=> 'content',
			'group' 	=> '_viewCart',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' 	=> $selector,
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcPadding'] = [
			'tab'   	=> 'content',
			'group' 	=> '_viewCart',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' 	=> $selector,
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> '_viewCart',
			'type' 		=> 'separator',
			'required' 	=> [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcBgColor'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'background-color'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcTypography'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'font'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcBorder'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'border'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcBoxshadow'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'box-shadow',
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHoverSep'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'separator',
			'label' => esc_html__('Hover State', 'bricks'),
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHBgColor'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'background-color'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHoverColor'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'color',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'color'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHBorder'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'border'
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		$this->controls['_vcHBoxshadow'] = [
			'tab'   => 'content',
			'group' => '_viewCart',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'box-shadow',
				],
			],
			'required' => [ '_hideVC', '!=', true ],
		];

		/**
		 * Buy Now Button Style
		 ----------------------------------------------------------------*/
		$this->controls['showBuyNowBtn'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Show Buy Now Button', 'bricksultimate' ),
			'reset' 	=> true
		];

		$this->controls['hideBN'] = [
			'group' 	=> 'buynow',
			'label'    	=> esc_html__( 'Hide button', 'bricks' ),
			'description' => esc_html__( 'When product added to the cart', 'bricksultimate' ),
			'type'     	=> 'checkbox',
			'required' 	  => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bn_button_text'] = [
			'tab'         => 'content',
			'group' 	  => 'buynow',
			'type'        => 'text',
			'label'       => esc_html__( 'Button Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Buy Now', 'bricksultimate' ),
			'required' 	  => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['redirect_link'] = [
			'tab'       => 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Redirect to', 'bricksultimate'),
			'info' 		=> esc_html__( 'Redirecting the customer after adding the product to cart.', 'bricksultimate' ),
			'default' 	=> 'checkout',
			'options' 	=> [
				'checkout' 	=> esc_html__( 'Checkout Page', 'ziultimate' ),
				'custom' 	=> esc_html__( 'Custom URL', 'ziultimate' )
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['page_link'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'link',
			'label' 	=> esc_html__( 'URL', 'bricks' ),
			'exclude' 	=> [
				'title',
				'ariaLabel',
				'newTab',
				'rel'
			],
			'required' 	=> [ 'redirect_link', '=', 'custom'],
		];

		$this->controls['keep_cart_items'] = [
			'tab'       => 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Keep cart items?', 'bricksultimate'),
			'info' 		=> esc_html__( 'Will keep the previously added cart items?', 'bricksultimate' ),
			'default' 	=> 'no',
			'options' 	=> [
				'no' 	=> esc_html__( 'No' ),
				'yes' 	=> esc_html__( 'Yes' )
			],
			'inline' 	=> true,
			'required' 	 => [ 'showBuyNowBtn', '=', true ],
		];

		$selector = '.single_buy_now_button.button';

		$this->controls['bnbtnSize'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'label' 	=> esc_html__( 'Sizing', 'bricks' ),
			'type' 		=> 'separator',
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnWidth'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' 	=> $selector,
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHeight'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' 	=> $selector,
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnFlexGrow'] = [
			'tab'         => 'content',
			'group' 	  => 'buynow',
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
					'selector' => $selector,
				],
			],
			'placeholder' => 1,
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnSpacingSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type' 		=> 'separator',
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnMargin'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnPadding'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'separator',
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnBgColor'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'background-color'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnFont'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'font'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnBorder'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'border'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'box-shadow'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Hover State', 'bricks' ),
			'required'  => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHBgColor'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ":hover",
					'property' => 'background-color'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHoverColor'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'color',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ":hover",
					'property' => 'color'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHBorder'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ":hover",
					'property' => 'border'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnbtnHBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ":hover",
					'property' => 'box-shadow'
				],
			],
			'required' => [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnIconSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'buynow',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Icon', 'bricks' ),
			'required' 	=> [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnIcon'] = [
			'tab'   => 'content',
			'group' => 'buynow',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
			'required' 	=> [ 'showBuyNowBtn', '=', true ],
		];

		$this->controls['bnIconTypography'] = [
			'tab'      => 'content',
			'group' 	=> 'buynow',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.single_buy_now_button i',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'bnIcon.icon', '!=', '' ],
		];

		$this->controls['bnIconPosition'] = [
			'tab'         => 'content',
			'group' 	  => 'buynow',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '.single_buy_now_button',
					'property' => 'flex-direction'
				]
			],
			'required' 	=> [ 'bnIcon.icon', '!=', '' ],
		];

		$this->controls['bnIconGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buynow',
			'label'    	=> esc_html__( 'Gap', 'bricksultimate' ),
			'type'     	=> 'number',
			'min' 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			'css'      	=> [
				[
					'property' => 'gap',
					'selector' => '.single_buy_now_button.button',
				],
			],
			'required' 	=> [ 'bnIcon.icon', '!=', '' ],
		];

		$this->controls['bnIconMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buynow',
			'label'    	=> esc_html__( 'Margin', 'bricks' ),
			'type'     	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => '.single_buy_now_button i',
				],
			],
			'required' 	=> [ 'bnIcon.icon', '!=', '' ],
		];

		$this->controls['bnIconHColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buynow',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '.single_buy_now_button:hover i',
				],
			],
			'required' 	=> [ 'bnIcon.icon', '!=', '' ],
		];


		/**
		 * Quick Add
		 ----------------------------------------------------------------*/
		 $this->controls = $this->bu_quick_add_controls( $this->controls );

		/**
		 * Variations
		 ----------------------------------------------------------------*/
		$this->controls['hideVPrice'] = [
			'group' 	=> '_variations',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Hide price (bottom one)', 'bricksultimate' ),
			'reset' 	=> true
		];

		$this->controls['hideVDesc'] = [
			'group' 	=> '_variations',
			'type' 		=> 'checkbox',
			'label'		=> esc_html__( 'Hide description', 'bricksultimate' ),
			'reset' 	=> true
		];

		$this->controls['variationPriceTypography'] = [
			'tab'   => 'content',
			'group' => '_variations',
			'type'  => 'typography',
			'label' => esc_html__('Price Typography', 'bricksultimate'),
			'css' 	=> [
				[
					'selector' 	=> '.woocommerce-variation-price, .woocommerce-variation-price .price > span.woocommerce-Price-amount',
					'property' => 'font'
				],
			],
			'required' => ['hideVPrice','!=', true]
		];

		$this->controls['variationDescTypography'] = [
			'group' => '_variations',
			'type'  => 'typography',
			'label' => esc_html__('Description Typography', 'bricksultimate'),
			'css' 	=> [
				[
					'selector' 	=> '.woocommerce-variation-description p',
					'property' => 'font'
				],
			],
			'required' => ['hideVDesc','!=', true]
		];

		$this->controls['variationsTypography'] = [
			'group' => '_variations',
			'label' => esc_html__( 'Label Typography', 'bricksultimate' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => 'table.variations label',
				],
			],
		];

		$this->controls['vLabelAlign'] = [
			'group' => '_variations',
			'label' => esc_html__( 'Label Alignment', 'bricksultimate' ),
			'type'  => 'select',
			'inline' => true,
			'options' => [
				'top' => esc_html__('Top'), 
				'middle' => esc_html__('Center'),
				'bottom' => esc_html__('Bottom'),
				'baseline' => esc_html__('Baseline'), 
			],
			'css'   => [
				[
					'property' => 'vertical-align',
					'selector' => 'table.variations th.label',
				],
			],
		];

		$this->controls['variationsBackgroundColor'] = [
			'group' => '_variations',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => 'table.variations tr',
				],
			],
		];

		$this->controls['variationsBorder'] = [
			'group' => '_variations',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.cart .variations tr',
				]
			],
		];

		$this->controls['variationsMargin'] = [
			'group' => '_variations',
			'label'       => esc_html__( 'Margin', 'bricks' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'selector' => '.cart table.variations',
					'property' => 'margin',
				],
			],
			'placeholder' => [
				'bottom' => 30,
			],
		];

		$this->controls['variationsPadding'] = [
			'group' => '_variations',
			'label'       => esc_html__( 'Padding', 'bricks' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'selector' => '.cart table.variations td',
					'property' => 'padding',
				],
			],
			'placeholder' => [
				'top'    => 15,
				'bottom' => 15,
			],
		];

		$selector = 'table.variations td select';

		$this->controls['vDropdownSep'] = [
			'group' => '_variations',
			'label'       => esc_html__( 'Dropdown', 'bricks' ),
			'type'        => 'separator',
		];

		$this->controls['vDropdownW'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => 'width',
				],
			],
		];

		$this->controls['vDropdownTg'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => 'font',
				],
			],
		];

		$this->controls['vDropdownBrd'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['vDropdownBg'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => 'background-color',
				],
			],
		];

		$this->controls['vDropdownArrow'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Down arrow color', 'bricks' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => '--chevron-color',
				],
			],
		];

		$this->controls['vDropdownPad'] = [
			'group' 	=> '_variations',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type' 		=> 'dimensions',
			'css' 		=> [
				[
					'selector' => $selector,
					'property' => 'padding',
				],
			],
		];

		/**
		 * Swatches options
		 ----------------------------------------------------------------*/
		$this->controls['swWhiteTick'] = [
			'group' => '_swatches',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Disable white tick icon', 'bricksultimate' ),
		];

		$this->controls['swGap'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '8px',
			'css' 	=> [
				[
					'property' => 'margin-right',
					'selector' => '.swatch-on-single:not(:last-child)'
				]
			]
		];

		$this->controls['swOuterBrd'] = [
			'group' => '_swatches',
			'type' 	=> 'border',
			'label' => esc_html__( 'Outer border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => '.bu-swatch'
				]
			],
			'exclude' => ['border-radius']
		];

		$this->controls['swActiveBrd'] = [
			'group' => '_swatches',
			'type' 	=> 'border',
			'label' => esc_html__( 'Active swatches border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => '.bu-swatch.active-swatch'
				]
			],
			'exclude' => ['border-radius']
		];

		$this->controls['swDisable'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Opacity - disabled swatches', 'bricksultimate' ),
			'unitless' => true,
			'min' 	=> 0,
			'max' 	=> 1,
			'step' => 0.1,
			'placeholder' => 0.75,
			'css' 	=> [
				[
					'property' => 'opacity',
					'selector' => '.swatch-disabled, .swatch-ofs'
				]
			]
		];

		$this->controls['swPrice'] = [
			'group' => '_swatches',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Update price', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'display',
					'selector' => '.woocommerce-variation-price',
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['swPriceSelector'] = [
			'group' => '_swatches',
			'type' 	=> 'text',
			'label' => esc_html__( 'Price element selector', 'bricksultimate' ),
			'placeholder' => '.brxe-product-price',
			'required' => ['swPrice', '=', true]
		];

		$this->controls['prdImgSelector'] = [
			'group' => '_swatches',
			'type' 	=> 'text',
			'label' => esc_html__( '(BU)Product Image element selector', 'bricksultimate' ),
			'placeholder' => '.brxe-bu-product-image',
			'description' => esc_html__('Replace featured image with selected variations image','bricksultimate')
		];

		$this->controls['swColorSep'] = [
			'group' => '_swatches',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Color swatches', 'bricksultimate' ),
		];

		$this->controls['swColorW'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '25px',
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => '.swatch-with-bg.swatches-color span'
				]
			]
		];

		$this->controls['swColorH'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '25px',
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => '.swatch-with-bg.swatches-color span'
				]
			]
		];

		$this->controls['swColorbrd'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => '.swatch-with-bg.swatches-color, .swatch-with-bg.swatches-color span'
				]
			]
		];

		$this->controls['swImgSep'] = [
			'group' => '_swatches',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Image swatches', 'bricksultimate' ),
		];

		$this->controls['swImgW'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '25px',
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => '.swatch-with-bg.swatches-image span'
				]
			]
		];

		$this->controls['swImgH'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '25px',
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => '.swatch-with-bg.swatches-image span'
				]
			]
		];

		$this->controls['swImgbrd'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'placeholder' => '0px',
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => '.swatch-with-bg.swatches-image, .swatch-with-bg.swatches-image span'
				]
			]
		];

		$this->controls['swTextSep'] = [
			'group' => '_swatches',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Text swatches', 'bricksultimate' ),
		];

		$selector = '.bu-swatch:not(.swatch-with-bg) span';

		$this->controls['swTextW'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['swTextH'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['swTextFont'] = [
			'group' => '_swatches',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['swTextBg'] = [
			'group' => '_swatches',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['swTextABg'] = [
			'group' => '_swatches',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background - Active', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => '.active-swatch.bu-swatch:not(.swatch-with-bg) span'
				]
			]
		];

		$this->controls['swTextAClr'] = [
			'group' => '_swatches',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color - Active', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.bu-swatch.active-swatch:not(.swatch-with-bg) span'
				]
			]
		];

		$this->controls['swTextbrd'] = [
			'group' => '_swatches',
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => $selector
				]
			]
		];

		$this->controls['swTextPad'] = [
			'group' => '_swatches',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['swLabelSep'] = [
			'group' => '_swatches',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Swatches label', 'bricksultimate' ),
		];

		$this->controls['swShowLabel'] = [
			'group' => '_swatches',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Display active swatch label', 'bricksultimate' ),
		];

		$this->controls['swBelowLabel'] = [
			'group' => '_swatches',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Display swatches below the label', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' 	=> '.variations_form .variations th.label, .variations_form .variations td.value',
					'property' 	=> 'display',
					'value' 	=> 'table-row'
				]
			]
		];

		$this->controls['swLabelTg'] = [
			'group' => '_swatches',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Selcted Label Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.bu-swatch-selected'
				]
			]
		];

		$this->controls['swShowName'] = [
			'group' => '_swatches',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Display swatch name', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.bu-swatch-label',
					'value' 	=> 'block;'
				]
			]
		];

		$this->controls['swNameTg'] = [
			'group' => '_swatches',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Swatch Name Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.bu-swatch-label'
				]
			]
		];

		$this->controls['swttSep'] = [
			'group' => '_swatches',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Tooltip', 'bricksultimate' ),
		];

		$this->controls = $this->bu_tooltip_controls( $this->controls, '_swatches' );



		/**
		 * Clear text button
		 ----------------------------------------------------------------*/
		$selector = '.reset_variations';

		$this->controls['_clrBtnHide'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Remove the button?', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector,
					'value' 	=> 'none',
					'important' => true
				],
			]
		];

		$this->controls['_clrBtnWidth'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' 	=> $selector,
				],
			]
		];

		$this->controls['_clrBtnHeight'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' 	=> $selector,
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
		];

		$this->controls['_clrBtnSpacingSep'] = [
			'tab'   	=> 'content',
			'group' 	=> '_clearBtn',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type' 		=> 'separator',
		];

		$this->controls['_clrBtnMargin'] = [
			'tab'   	=> 'content',
			'group' 	=> '_clearBtn',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' 	=> $selector,
				],
			]
		];

		$this->controls['_clrBtnPadding'] = [
			'tab'   	=> 'content',
			'group' 	=> '_clearBtn',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' 	=> $selector,
				],
			]
		];

		$this->controls['_clrBtnStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> '_clearBtn',
			'type' 		=> 'separator',
		];

		$this->controls['_clrBtnBgColor'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'background-color'
				],
			]
		];

		$this->controls['_clrBtnTypography'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'font'
				],
			],
		];

		$this->controls['_clrBtnBorder'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'border'
				],
			],
		];

		$this->controls['_clrBtnBoxshadow'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' 	=> $selector,
					'property' => 'box-shadow',
				],
			],
		];

		$this->controls['_clrBtnHoverSep'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'separator',
			'label' => esc_html__('Hover State', 'bricks'),
		];

		$this->controls['_clrBtnHBgColor'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'background-color'
				],
			],
		];

		$this->controls['_clrBtnHoverColor'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'color',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'color'
				],
			],
		];

		$this->controls['_clrBtnHBorder'] = [
			'tab'   => 'content',
			'group' => '_clearBtn',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'border'
				],
			],
		];

		$this->controls['_clrBtnHBoxshadow'] = [
			'group' => '_clearBtn',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector . ':hover',
					'property' => 'box-shadow',
				],
			],
		];

		$this->controls['_clrBtnIconSep'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['_clrBtnIcon'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
		];

		$this->controls['_clrBtnIconSize'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Size', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css' 	=> [
				[
					'property' => 'font-size',
					'selector' => '.reset-btn-icon'
				]
			]
		];

		$this->controls['_clrBtnIconColor'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.reset-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.reset-btn-icon'
				]
			]
		];

		$this->controls['_clrBtnIconHColor'] = [
			'group' => '_clearBtn',
			'label' => esc_html__( 'Hover color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.reset_variations:hover .reset-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.reset_variations:hover .reset-btn-icon'
				]
			]
		];

		/**
		 * Availability controls
		 */
		$selector = '.stock.in-stock';

		$this->controls['hide_availability'] = [
			'tab'   => 'content',
			'group' => '_availability',
			'type'  => 'checkbox',
			'label' => esc_html__('Hide', 'bricksultimate'),
			'reset' => true
		];

		$this->controls['_avlTypography'] = [
			'tab'   => 'content',
			'group' => '_availability',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'font'
				]
			]
		];

		$this->controls['_outstockTypography'] = [
			'tab'   => 'content',
			'group' => '_availability',
			'type'  => 'typography',
			'label' => esc_html__('Out of stock text', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.stock.out-of-stock',
					'property' => 'font'
				]
			]
		];

		

		/**
		 * Group Products controls
		 */
		$this->controls['_groupPrdVA'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'select',
			'label' => esc_html__('Vertical align', 'bricksultimate'),
			'default' => 'middle',
			'options' => [
				'top' 		=> esc_html__('Top'),
				'middle' 	=> esc_html__('Center')
			],
			'css' 	=> [
				[
					'selector' => 'form.cart .group_table td',
					'property' => 'vertical-align',
				],
			]
		];

		$this->controls['_groupPrdCellPad'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'number',
			'label' => esc_html__('Cell spacing', 'bricksultimate'),
			'unit' 	=> 'px',
			'min' 	=> 0,
			'max' 	=> 100,
			'step' 	=> 1,
			'css' 	=> [
				[
					'selector' 	=> 'form.cart table.group_table',
					'property' 	=> 'border-spacing',
					'value' 	=> '%spx'
				],
			]
		];

		$this->controls['_groupPrdTitleSep'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'separator',
			'label' => esc_html__('Product title', 'bricksultimate'),
		];

		$this->controls['_groupPrdTitleTg'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.woocommerce-grouped-product-list-item__label a',
					'property' => 'font',
				],
			]
		];

		$this->controls['_groupPrdTitleHoverColor'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'color',
			'label' => esc_html__('Hover color', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.woocommerce-grouped-product-list-item__label a:hover',
					'property' => 'color',
				],
			]
		];

		/*$this->controls['_groupPrdPriceSep'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'separator',
		];

		$this->controls['_groupPrdPriceTg'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'typography',
			'label' => esc_html__('Price', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.woocommerce-grouped-product-list-item__price .woocommerce-Price-amount.amount',
					'property' => 'font',
				],
				[
					'selector' => '.woocommerce-grouped-product-list-item__price ins .woocommerce-Price-amount.amount',
					'property' => 'font',
				],
			]
		];

		$this->controls['_groupPrdSalePriceTg'] = [
			'tab'   => 'content',
			'group' => '_groupPrd',
			'type'  => 'typography',
			'label' => esc_html__('Strick through price', 'bricks'),
			'css' 	=> [
				[
					'selector' => '.woocommerce-grouped-product-list-item__price del span.woocommerce-Price-amount',
					'property' => 'font',
				],
				[
					'selector' => '.woocommerce-grouped-product-list-item__price del',
					'property' => 'font',
				],
			]
		];*/
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-atc-el', Helpers::get_asset_url('css') . 'buatc.min.css', [], filemtime(Helpers::get_asset_path('css') . 'buatc.min.css'), 'all' );

			wp_enqueue_script('wc-add-to-cart-variation');
			wp_enqueue_style( 'bu-swatches' );
			wp_enqueue_script( 'bu-swatches' );
		} else {}*/
		
		wp_enqueue_style( 'bu-atc-el', Helpers::get_asset_url('css') . 'buatc.min.css', [], filemtime(Helpers::get_asset_path('css') . 'buatc.min.css'), 'all' );
		wp_enqueue_script( 'bu-atc', Helpers::get_asset_url('js') . 'buatc.min.js', ['wc-add-to-cart'], filemtime(Helpers::get_asset_path('js') . 'buatc.min.js'), true );

		wp_enqueue_script( 'wc-add-to-cart-variation' );
		wp_enqueue_script( 'bu-swatches' );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		global $product;

		$product = wc_get_product( $this->post_id );

		$product_id = get_post_meta( $this->post_id, '_buob_offer_product', true );
		if( empty( $product ) && $product_id ) {
			$product = wc_get_product( $product_id );
		}

		if( empty( $product ) && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if ( empty( $product ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'For better preview select content to show.', 'bricks' ),
					'description' => esc_html__( 'Go to: Settings > Template Settings > Populate Content', 'bricks' ),
				]
			);
		}

		$this->set_attribute( 
			'_root', 
			'class', 
			[ 'woocommerce', 'buatc-container', 'product-type-' . $product->get_type(), 
				( isset( $settings['isQueryLoopOn'] ) ? 'loop-on' : '' ), 
				( ! empty( $settings['disableTickIcon'] ) ? 'hide-tick-icon' : '' ),
				( ( ! empty( $settings['inpPosition'] ) && $settings['inpPosition'] == 'left' ) ? 'bu-qty-inp-left' : '' ),
				( ! empty( $settings['showQtyText'] ) ? 'bu-show-qty-text' : '' ),
			]
		);

		if( ! empty( $settings['swWhiteTick'] ) ){
			$this->set_attribute( '_root', 'class', [ 'no-tick' ] );
		}

		if( ! empty( $settings['showQtyText'] ) ) {
			add_action( 'woocommerce_before_add_to_cart_quantity', [ $this, 'qty_open_markup' ] );
			add_action( 'woocommerce_after_add_to_cart_button', [ $this, 'qty_close_markup' ] );
		}

		$atcContent = get_option('bultimate_client')??'';
		$addedText = Helpers::get_value( $settings, 'addedBtnText', false );
		if( $addedText ) {
			$this->set_attribute( '_root', 'data-atc-config', wp_json_encode( [ 
				'addedText' => esc_attr( $addedText ), 'atcText' => esc_attr( Helpers::get_value( $settings, 'simpleBtnText', __( 'Add to cart', 'woocommerce' ) ) ) ] ) );
		}

		if( 
			$product->get_type() == 'variable' && 
			( 
				( 
					! empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) && \BricksUltimate\Plugin::$bu_settings['swatches'] == 'enabled' 
				) || ! empty( $settings['enableQuickAdd'] ) 
			) 
		)
		{	
			if( ! empty( $settings['swShowLabel'] ) ) {
				$this->set_attribute( '_root',  "data-show-label", 'yes' );
				$this->set_attribute( '_root', 'class', [ 'swatches-is-on'] );
			}

			if( ! empty( $settings['hasTooltip'] ) ) {
				wp_enqueue_style( 'bu-tooltip' );
				wp_enqueue_script( 'bu-popper' );
				wp_enqueue_script( 'bu-tippy' );

				$data = [
					'hasTooltip' => 'yes',
					'animation' => Helpers::get_value($settings, 'ttAnimation', 'perspective'),
					'placement' => Helpers::get_value($settings, 'ttPlacement', 'top')
				];

				$this->set_attribute( '_root',  "data-tooltip-config", wp_json_encode( $data ) );
			}

			if( ! empty( $settings['swPrice'] ) ) {
				$data = [
					'updatePrice' => 'yes',
					'selector' => Helpers::get_value($settings, 'swPriceSelector', false)
				];

				$this->set_attribute( '_root',  "data-price-update", wp_json_encode( $data ) );
			}

			if( ! empty( $settings['prdImgSelector'] ) ) {
				$this->set_attribute( '_root',  "data-prdimg-selector", $settings['prdImgSelector'] );
			}
		}

		// add to cart button for loop
		if( ! empty( $settings['isQueryLoopOn'] ) ) {
			if( ! empty( $settings['enableQuickAdd'] ) && $product->get_type() == 'variable' ) {
				$noQuickAdd = Helpers::get_value($settings, 'excludeQuickAdd', '');

				if( ! in_array( $product->get_id(), explode(',', $noQuickAdd) ) ) {
					$this->set_attribute( '_root', 'class', 'quick-add-btn' );

					$btnReplaceText = Helpers::get_value($settings, 'quickAddBtnText', false);
					if( $btnReplaceText ) {
						$this->set_attribute( '_root', 'data-atc-text', esc_attr( $btnReplaceText ) );
					}
				}
			}

			if ( \Bricks\Woocommerce::use_quantity_in_loop() ) {
				remove_action( 'woocommerce_loop_add_to_cart_link', [ \Bricks\Theme::instance()->woocommerce, 'add_quantity_input_field' ], 10, 2 );
			}

			echo "<div {$this->render_attributes('_root')}>";

			//* Alter button text
			if( isset( $settings['changeATCText'] ) || ! empty( $settings['icon'] ) || ! empty( $settings['optionIcon'] ) ) {
				add_filter( 'woocommerce_product_add_to_cart_text', [ $this, 'bu_product_add_to_cart_text' ], 10, 2 );
			}

			//* Add icon
			if( ! empty( $settings['icon'] ) || ! empty( $settings['optionIcon'] ) ) {
				add_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'bu_add_icon' ], 10, 3 );
			}

			//* Add class
			add_filter( 'woocommerce_loop_add_to_cart_args', [ $this, 'bu_loop_add_to_cart_args' ], 10, 2 );

			echo $atcContent;

			if( ! empty( $settings['showQty'] ) && in_array($product->get_type(), [ 'simple', 'variation' ]) && $product->is_purchasable() ) {
				echo '<form class="cart" data-product_id="' . $product->get_id() .'" action="'. esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ) .'" method="post">
						<div class="quantity">';

							do_action( 'woocommerce_before_quantity_input_field' );

							echo '<input 
								type="number" 
								id="' . uniqid( 'quantity_' ) . '" 
								class="'.  esc_attr( join( ' ', (array) apply_filters( 'woocommerce_quantity_input_classes', array( 'input-text', 'qty', 'text' ), $product ) ) ) . '" 
								step="'. esc_attr( apply_filters( 'woocommerce_quantity_input_step', 1, $product ) ) .'" 
								min="'. esc_attr( apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ) ) . '" 
								max="" 
								name="quantity" 
								value="'. esc_attr( apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ) ) . '" 
								title="Qty" 
								size="4" 
								placeholder="'. esc_attr( apply_filters( 'woocommerce_quantity_input_placeholder', '', $product ) ) .'" 
								inputmode="numeric" 
								onkeyup="JavaScript: ATCUpdateQty(this);" 
								onchange="JavaScript: ATCUpdateQty(this);">';

							do_action( 'woocommerce_after_quantity_input_field' );

				echo '</div></form>';
			}

			woocommerce_template_loop_add_to_cart();

			remove_filter( 'woocommerce_loop_add_to_cart_args', [ $this, 'bu_loop_add_to_cart_args' ], 10, 2 );

			if( isset( $settings['changeATCText'] ) || ! empty( $settings['icon'] ) || ! empty( $settings['optionIcon'] ) ) {
				remove_filter( 'woocommerce_product_add_to_cart_text', [ $this, 'bu_product_add_to_cart_text' ], 10, 2 );
			}

			if( ! empty( $settings['icon'] ) || ! empty( $settings['optionIcon'] ) ) {
				remove_filter( 'woocommerce_loop_add_to_cart_link', [ $this, 'bu_add_icon' ], 10, 3 );
			}

			if( ! empty( $settings['enableQuickAdd'] ) && $product->get_type() == 'variable' ) {
				$noQuickAdd = Helpers::get_value( $settings, 'excludeQuickAdd', '' );
				
				if( ! in_array( $product->get_id(), explode(',', $noQuickAdd) ) ) {
					$closeText = Helpers::get_value($settings, 'qaCloseBtnText', 'Close');
					$iconClose = ! empty( $settings['qaCloseBtnIcon'] ) ? self::render_icon($settings['qaCloseBtnIcon'], ['bu-qa-close-icon']) : '';

					echo "<div class=\"quick-add-wrapper\" data-element-id=\"" . $this->id . "\" data-page-id=\"" .  \Bricks\Database::$page_data['original_post_id'] . "\">
						<div class=\"qa-close-btn\"><a href=\"#\" rel=\"nofollow noopener\">{$iconClose}{$closeText}</a></div>
						<div class=\"qa-cart-form\"></div>
					</div>";
				}
			}

			echo "</div>";

			if ( \Bricks\Woocommerce::use_quantity_in_loop() ) {
				add_action( 'woocommerce_loop_add_to_cart_link', [ \Bricks\Theme::instance()->woocommerce, 'add_quantity_input_field' ], 10, 2 );
			}

		} else { //* single add to cart button

			// Add filter for variation select field if swatches are enabled
			if ( \Bricks\Database::get_setting( 'woocommerceUseVariationSwatches' ) && ( empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) || \BricksUltimate\Plugin::$bu_settings['swatches'] !== 'enabled' ) ) {
				add_filter( 'woocommerce_dropdown_variation_attribute_options_html', [ new \Bricks\Product_Add_To_Cart(), 'maybe_convert_to_swatches' ], 100, 2 );
			}

			$stock = $product->get_stock_quantity();
			if( ! empty( $stock ) && $stock <= 1 ) {
				$this->set_attribute( '_root', 'class', 'hide-qty-box'  );
			}

			if( ( $product->get_type() === 'variable' || $product->get_type() === 'composite' ) ) {
				if( isset( $settings['hideVPrice'] ) )
					$this->set_attribute( '_root', 'class', 'hide-variation-price'  );

				if( isset( $settings['hideVDesc'] ) )
					$this->set_attribute( '_root', 'class', 'hide-variation-description'  );
			}

			if( ! empty( $settings['ajaxATC'] ) ) {
				$this->set_attribute( '_root', 'data-adtcajax', 'yes'  );
			}

			if( isset( $settings['redirectLink'] ) ) {
				$this->set_link_attributes( 'link', $settings['redirectLink'] );
				$redirectUrl = $this->attributes['link'];

				$this->set_attribute( '_root',  "data-redirect", esc_url( $redirectUrl['href'][0] ) );
			}

			echo $atcContent;

			$cart_items = [];
			if( ! is_null( \WC()->cart ) && ! empty( $settings['hideBN'] ) ) {
				foreach( \WC()->cart->get_cart_contents() as $cartItem ) {
					$cart_items[] = $cartItem['product_id'];
				}

				if( in_array( $this->post_id, $cart_items ) )
					$this->set_attribute( '_root',  "class", [ 'product--added' ] );
			}

			echo "<div {$this->render_attributes('_root')}>";
			
			if( ! empty( $settings['showPrice'] ) && $product->get_type() != 'external' )
				woocommerce_template_single_price();

			add_filter( 'woocommerce_product_single_add_to_cart_text', [ $this, 'bu_single_add_to_cart_text' ] );
			add_filter( 'esc_html', [ $this, 'bu_avoid_esc_html' ], 10, 2 );

			if( ! empty( $settings['hide_availability'] ) ) {
				add_filter( 'woocommerce_get_stock_html', '__return_null' );
			}

			if( ( $product->get_type() === 'variable' || $product->get_type() == 'composite' || $product->get_type() === 'grouped' ) && ! empty( $settings['isStickyButton'] ) ) { 
				echo '<button type="submit" class="single_add_to_cart_button button bu-sticky-button">' . esc_html( $product->add_to_cart_text() ) . '</button>';
			} else {
				if( ! empty( $settings['showBuyNowBtn'] ) )
					add_action( 'woocommerce_after_add_to_cart_button', [$this, 'bu_add_buy_now_button'], 2 );

				if( ! empty( $settings['_clrBtnIcon'] ) )
					add_filter( "woocommerce_reset_variations_link", [$this, "add_icon_reset_variations_link" ] );

				\woocommerce_template_single_add_to_cart();

				if( ! empty( $settings['_clrBtnIcon'] ) )
					remove_filter( "woocommerce_reset_variations_link", [$this, "add_icon_reset_variations_link" ] );

				if( ! empty( $settings['showBuyNowBtn'] ) )
					remove_action( 'woocommerce_after_add_to_cart_button', [$this, 'bu_add_buy_now_button'], 2 );
			}

			if( ! empty( $settings['hide_availability'] ) ) {
				remove_filter( 'woocommerce_get_stock_html', '__return_null' );
			}

			remove_filter( 'woocommerce_product_single_add_to_cart_text', [ $this, 'bu_single_add_to_cart_text' ] );
			remove_filter( 'esc_html', [ $this, 'bu_avoid_esc_html' ], 10, 2 );

			echo "</div>";
		}

		if( ! empty( $settings['showQtyText'] ) ) {
			remove_action( 'woocommerce_before_add_to_cart_quantity', [ $this, 'qty_open_markup' ] );
			remove_action( 'woocommerce_after_add_to_cart_button', [ $this, 'qty_close_markup' ] );
		}
	}

	function qty_open_markup() {
		$qtyLabel = Helpers::get_value( $this->settings, 'qtyText', esc_html__( 'Quantity:', 'woocommerce') );
		$qtyLabelMD = Helpers::get_value( $this->settings, 'qtyTextMD', 'Qty:' );
		
		echo '<div class="bu-atc-btn-wrapper">';

		if( $qtyLabel )
			echo '<div class="bu-qty-text">' . $qtyLabel . '</div>';

		if( $qtyLabelMD ) {
			echo '<div class="bu-qty-text text-for-md">' . $qtyLabelMD . '</div>';
		}
	}


	function qty_close_markup() {
		echo '</div>';
	}

	/**
	 * Add Buy Now Button
	 */
	public function bu_add_buy_now_button() {
		global $product;

		$settings = $this->settings;
		$keep_cart 			= Helpers::get_value( $settings, 'keep_cart_items', 'no');
		$redirect_link 		= Helpers::get_value( $settings, 'redirect_link', 'checkout');
		//$link 				= Helpers::get_value( $settings, 'page_link', false );
		$button_text 		= Helpers::get_value( $settings, 'bn_button_text', __('Buy Now', 'bricksultimate') );
		$url 				= wc_get_checkout_url();

		if( $redirect_link == 'custom' && isset( $settings['page_link'] ) ) {
			$this->set_link_attributes( 'pagelink', $settings['page_link'] );
			$redirectUrl = $this->attributes['pagelink'];

			$url = esc_url( $redirectUrl['href'][0] );
		}

		$icon = ! empty( $settings['bnIcon'] ) ? self::render_icon( $settings['bnIcon'] ) : '';
		$button_text .=$icon;

		echo '<button type="submit" name="bu_buy_now" value="yes" class="single_buy_now_button single_add_to_cart_button bricks-button button">' . $button_text . '</button>';
		echo "<input type='hidden' name='bu_redirect_url' value='{$url}' />";
		echo "<input type='hidden' name='keep_cart_items' value='{$keep_cart}' />";

		if( $product->get_type() != 'variable' ) {
			echo "<input type='hidden' name='product_id' value='{$product->get_id()}' />";
		}
	}

	/**
	 * Add icon to button
	 * 
	 * @param string $link button HTML
	 * 
	 * @return string $link button HTML
	 */
	public function bu_add_icon( $link, $product, $args ) {
		$settings = $this->settings;

		if ( empty( $product ) )
			return $link;

		if( ! empty( $settings['icon'] ) && ( $product->get_type() == 'simple' || $product->get_type() == 'variation' ) ) {
			return str_replace( '{atcIcon}', self::render_icon( $settings['icon'] ), $link );
		}

		if( ! empty( $settings['optionIcon'] ) && ( $product->get_type() == 'variable' || $product->get_type() == 'composite' ) ) {
			return str_replace( '{variableIcon}', self::render_icon( $settings['optionIcon'] ), $link );
		}

		return $link;
	}

	/**
	 * Alter button text
	 * 
	 * @param string $text button text
	 * @param object $product product object
	 * @return string $text
	 */
	public function bu_product_add_to_cart_text($text, $product) {
		$settings = $this->settings;

		$atc = Helpers::get_value( $settings, 'simpleBtnText', false );
		$options_text = Helpers::get_value( $settings, 'variableBtnText', false );
		$read_more_txt = Helpers::get_value( $settings, 'rmBtnText', false );
		$grouped_text = Helpers::get_value( $settings, 'groupedBtnText', false );

		if( ( $product->get_type() == 'simple' || $product->get_type() == 'variation') && isset( $settings['changeATCText'] ) ) {
			$text = $product->is_purchasable() && $product->is_in_stock() ? $atc : $read_more_txt;
		}

		if( ( $product->get_type() == 'variable' || $product->get_type() == 'composite' ) && isset( $settings['changeATCText'] ) ) {
			$text = $product->is_purchasable() ? $options_text : $read_more_txt;
		}

		if( $product->get_type() == 'grouped' && isset( $settings['changeATCText'] ) && $grouped_text ) {
			$text = $grouped_text;
		}

		if( ! empty( $settings['icon'] ) && ( $product->get_type() == 'simple' || $product->get_type() == 'variation' ) && $product->is_purchasable() && $product->is_in_stock() ) {
			$text .= ' {atcIcon}';
		}

		if( ! empty( $settings['optionIcon'] ) && ( $product->get_type() == 'variable' || $product->get_type() == 'composite' ) ) {
			$text .= ' {variableIcon}';
		}

		return $text;
	}

	/**
	 * Add the custom CSS class
	 * 
	 * @param array $args
	 * @param object $product 
	 * @return array $args
	 */
	public function bu_loop_add_to_cart_args( $args, $product ) {
		$class = $args['class'] . ' bricks-button';

		if( isset( $this->settings['circle'] ) ) {
			$class .= ' circle';
		}

		$args['class'] = $class;

		return $args;
	}

	public function bu_single_add_to_cart_text( $atc ) {
		$settings = $this->settings;

		$icon = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'], [ 'single-atc-icon' ] ) : '';

		$singleATCText = Helpers::get_value( $settings, 'singleATCText', __( 'Add to cart', 'woocommerce' ) );
		if( empty( $settings['isQueryLoopOn'] ) && $singleATCText ) {
			$atc = $singleATCText; 
		}

		$atc = $singleATCText . $icon;

		return $atc;
	}

	public function bu_avoid_esc_html( $esc_html_text, $text ) {
		return $text;
	}

	public function add_icon_reset_variations_link( $link ) {
		$icon = self::render_icon( $this->settings['_clrBtnIcon'], [ 'reset-btn-icon' ] );

		return str_replace( "</a>", $icon . "</a>", $link );
	}
}