<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;
use BricksUltimate\Trait\LayoutControls;

class WooBankDetails extends \Bricks\Element {
	use LayoutControls;

	public $category = 'checkout';
	public $name 	= 'bu-wc-bank-details';
	public $icon 	= 'ti-book';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Bank Details', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['layout'] = [
			'title' 	=> esc_html__( 'Layout', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {
		$options = ['none' => esc_html__('Select....', 'bricksultimate')];
		$accounts = get_option( 'woocommerce_bacs_accounts' );
		if( $accounts ) {
			$fields = $accounts[0];
			foreach( (array) $fields as $field_slug => $field_data ) {
				$options[$field_slug] = strtolower( str_replace( ['-', '_'], ' ', $field_slug ) );
			}

			$this->controls['field'] = [
				'type'  	=> 'select',
				'label' 	=> esc_html__( 'Content', 'bricksultimate' ),
				'options'   => $options,
				'inline' 	=> true,
				'placeholder' => esc_html__('Select....', 'bricksultimate')
			];
		} else {
			$this->controls['field'] = [
				'type'  	=> 'select',
				'label' 	=> esc_html__( 'Content', 'bricksultimate' ),
				'options'   => $options,
				'inline' 	=> true,
				'placeholder' => esc_html__('Select....', 'bricksultimate')
			];
		}

		$this->controls['valueTg'] = [
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css' 		=> [
				[
					'property' => 'font'
				]
			]
		];

		$this->controls['labelSep'] = [
			'type'  	=> 'separator',
		];

		$this->controls['label'] = [
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Label', 'bricksultimate' ),
			'placeholder' => esc_html__('Account name', 'bricksultimate')
		];

		$this->controls['labelTg'] = [
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Label typography', 'bricksultimate' ),
			'css' 		=> [
				[
					'selector' => '.bacs-title',
					'property' => 'font'
				]
			]
		];

		$this->controls = array_merge( $this->controls, $this->bu_layout_settings([], 'layout', '', true ) );
	}

	// Set builder controls
	public function render() {
		$order = \BricksUltimate\DynamicData\ProviderUltimate::getCustomerOrder();
		$item = \BricksUltimate\DynamicData\ProviderUltimate::getOrderItem();

		if( ! $order )
			return;

		$gateway = $order->get_payment_method();
		$settings = $this->settings;
		$label = Helpers::get_value( $settings, 'label', false );
		if( $item && \BricksUltimate\Helpers::isBricksBuilderEditor() && ! empty( $settings['field'] ) ) {
			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			if( $label ) echo "<span class='bacs-title'>{$label} </span>";
			echo $item[ $settings['field'] ]??'';
			echo "</{$this->tag}>";
		} elseif( $item && $gateway == 'bacs' && ! empty( $settings['field'] ) ) {
			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			if( $label ) echo "<span class='bacs-title'>{$label}</span>";
			echo $item[ $settings['field'] ]??'';
			echo "</{$this->tag}>";
		}
	}
}