<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooBillTo extends \Bricks\Element {
	public $category = 'checkout';
	public $name 	= 'bu-billing-to';
	public $icon 	= 'ti-layout-list-post';
	public $nestable = true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Billing Address Selector', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['radio'] = [
			'title' 	=> esc_html__( 'Radio Buttons', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '=', 'rb' ]]
		];

		$this->control_groups['checkbox'] = [
			'title' 	=> esc_html__( 'Checkbox', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['buttonType', '=', 'cb' ]
		];

		$this->control_groups['innerwrap'] = [
			'title' 	=> esc_html__( 'Billing Fields Container', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->control_groups['inlineMsg'] = [
			'title' 	=> esc_html__( 'Inline error message', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['saInfo'] = [
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Refresh the builder editor for the preview.', 'bricksultimate' ),
		];
		
		$this->controls['radioButtons'] = [
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Disable radio/checkbox buttons', 'bricksultimate' ),
			'description' => esc_html__('If you enable it, this element will work as a form fields container.', 'bricksultimate')
		];

		$this->controls['buttonType'] = [
			'type'  	=> 'select',
			'label' 	=> esc_html__( 'Button type', 'bricksultimate' ),
			'options' => [
				'rb' => esc_html__('Radio'),
				'cb' => esc_html__('Checkbox')
			],
			'default' => 'rb',
			'inline' 	=> true,
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['label1'] = [
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Label', 'bricksultimate' ),
			'placeholder' => esc_html__('Same as shipping address', 'bricksultimate'),
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['label2'] = [
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Label of 2nd radio button', 'bricksultimate' ),
			'placeholder' => esc_html__('Use a different billing address', 'bricksultimate'),
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$selector = '.bu-billing-option';

		$this->controls['btnwpbg'] = [
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['btnsBorderW'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				],
				[
					'property' => 'border-bottom-width',
					'selector' => $selector . ' li'
				]
			],
			'default' => '1px',
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['btnsBorderColor'] = [
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => '--bricks-border-color'
				]
			],
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['btnsBorderStyle'] = [
			'type' 	=> 'select',
			'label' => esc_html__( 'Border style', 'bricksultimate' ),
			'options' => [ 'none' => 'none', 'solid' => 'Solid', 'dashed' => 'Dashed', 'dotted' => 'Dotted'],
			'css'	=> [
				[
					'property' => 'border-style',
					'selector' => '.bu-billing-option, .bu-billing-option li'
				]
			],
			'default' => 'solid',
			'inline' => true,
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['btnsBorderRadius'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => '--bricks-border-radius'
				]
			],
			'default' => '4px',
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['btnSpacing'] = [
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Spacing', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector . ' li .bu-billing-option-wrapper',
				]
			],
			'required' 	=> [['radioButtons', '!=', true], ['buttonType', '!=', 'cb' ]]
		];

		$this->controls['cbGap'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Space between label & button', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'margin-left',
					'selector' => '.bu-checkbox-buttons label'
				]
			],
			'required' 	=> ['buttonType', '=', 'cb' ]
		];

		/**
		 * Checkbox
		 * ----------------------------------------*/
		$cb_selector = '.bu-checkbox-buttons input[type=checkbox]';

		$this->controls['blCbSize'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'height',
					'selector' => $cb_selector,
				]
			],
			'required' => ['buttonType', '=', 'cb']
		];

		$this->controls['blCbBg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_selector,
				]
			],
			'required' => ['buttonType', '=', 'cb']
		];

		$this->controls['blCbBrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_selector,
				]
			],
			'required' => ['buttonType', '=', 'cb']
		];

		$cb_checked = '.bu-checkbox-buttons input[type=checkbox]:checked';
		$this->controls['blCbCbg'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_checked,
				]
			],
			'required' => ['buttonType', '=', 'cb']
		];

		$this->controls['blCbCBrd'] = [
			'group' 	=> 'checkbox',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_checked,
				]
			],
			'required' => ['buttonType', '=', 'cb']
		];

		/**
		 * Radio
		 * ----------------------------------------*/
		$this->controls['radioLabel'] = [
			'group' => 'radio',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.bu-billing-option-wrapper label'
				]
			],
		];

		$this->controls['radioGap'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'label' => esc_html__( 'Gap between Label & button', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'gap',
					'selector' => '.bu-billing-option-wrapper'
				]
			],
		];

		$this->controls['radioSep'] = [
			'group' => 'radio',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Radio button', 'bricksultimate' ),
		];

		$rd_selector = '.bu-billing-option-wrapper input[type=radio]';

		$this->controls['rdsize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			]
		];

		$rdc_checked = '.bu-billing-option-wrapper input[type=radio]:checked';
		$this->controls['rdcbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
		];

		$this->controls['rdcbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rdc_checked,
				]
			]
		];

		$bullet = '.bu-billing-option-wrapper input[type=radio]:checked:after';
		$this->controls['rdBulletSize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $bullet
				],
				[
					'property' => 'height',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdBulletolor'] = [
			'group' 	=> 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdBulletPos'] = [
			'group' 	=> 'radio',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
		];

		/**
		 * Inner wrapper
		 * ----------------------------------------*/
		$selector = '.bu-billing-form-fields';
		$this->controls['innerBg'] = [
			'group' => 'innerwrap',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['innerBrdClr'] = [
			'group' => 'innerwrap',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border top color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['innerSpacing'] = [
			'group' => 'innerwrap',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['hideErrorMsg'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.checkout-inline-error-message',
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['errorMsg'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.checkout-inline-error-message'
				]
			],
			'required' => ['hideErrorMsg', '!=', true]
		];

		$this->controls['errorMsgSp'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => '.checkout-inline-error-message'
				]
			]
		];
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$label_1 = Helpers::get_value($settings, 'label1', esc_html__( 'Same as shipping address', 'bricksultimate' ));
		$label_2 = Helpers::get_value($settings, 'label2', esc_html__( 'Use a different billing address', 'bricksultimate' ));

		$classes = [ 'woocommerce-billing-fields' ];

		$buttonType = ! empty( $settings['buttonType'] ) ? $settings['buttonType'] : 'rb';

		$this->set_attribute( '_root', 'class', [ 'woocommerce-billing-fields' ] );

		if( $buttonType == 'cb')
			$classes[] = 'woocommerce-billing-fields-button-cb';
			
		$this->set_attribute( '_root', 'class', $classes );

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		$children = \Bricks\Frontend::render_children( $this );
		if( empty( $settings['radioButtons'] ) ):
		?>
		<h3 id="ship-to-different-address" style="display: none;">
			<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox hidden" checked="checked" type="checkbox" name="ship_to_different_address" value="1" />
		</h3>
		<ul id="bu-billing-option" class="bu-billing-option bu-radio-buttons">
			<?php if( $buttonType == 'rb'): ?>
			<li>
				<div class="bu-billing-option-wrapper">
					<input type="radio" name="bill_to_different_address" data-index="0" id="billing_same_as_shipping_radio" value="same_as_shipping" class="billing_option" checked="checked"><label for="billing_same_as_shipping_radio"><?php echo $label_1; ?></label>
				</div>
			</li>
			<?php endif; ?>
			<li class="wc-block-components-address-address-wrapper is-editing">

				<div class="bu-billing-option-wrapper<?php if( $buttonType == 'cb') { echo ' bu-checkbox-buttons'; } ?>">
					<?php if( $buttonType == 'rb'): ?>
					<input type="radio" name="bill_to_different_address" data-index="1" id="billing_diff_from_shipping_radio" value="diff_from_shipping" class="billing_option"><label for="billing_diff_from_shipping_radio"><?php echo $label_2; ?></label>
					<?php else: ?>
						<input type="checkbox" name="bill_to_different_address" data-index="0" id="billing_same_as_shipping" value="same_as_shipping" class="billing_option" checked="checked"><label for="billing_same_as_shipping"><?php echo $label_1; ?></label>
					<?php endif; ?>
				</div>

				<div class="bu-billing-form-fields screen-reader-text"><?php echo $children; ?></div>
			</li>
		</ul>
		<?php
		else:
			echo '<div class="wc-block-components-address-address-wrapper is-editing">' . $children . '</div>';
		endif;
		echo "</{$this->tag}>"; //woocommerce-billing-fields__field-wrapper 
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-billing-to">
			<component :is="tag" 
				:class="{'woocommerce-billing-fields-button-cb': settings.buttonType == 'cb'}"
			>
				<ul v-if="!settings.radioButtons" id="bu-billing-option" class="bu-billing-option bu-radio-buttons">
					<li v-if="settings.buttonType != 'cb'">
						<div class="bu-billing-option-wrapper">
							<input type="radio" name="bill_to_different_address" data-index="0" id="billing_same_as_shipping_radio" value="same_as_shipping" class="billing_option" checked="checked"><label for="billing_same_as_shipping_radio">{{ settings.label1 ? settings.label1 : 'Same as shipping address' }}</label>
						</div>
					</li>
					<li>
						<div class="bu-billing-option-wrapper"
							:class="{'bu-checkbox-buttons': settings.buttonType == 'cb'}"
						>
							<input type="radio" name="bill_to_different_address" data-index="1" id="billing_diff_from_shipping_radio" value="diff_from_shipping" class="billing_option" v-if="settings.buttonType != 'cb'"><label for="billing_diff_from_shipping_radio" v-if="settings.buttonType != 'cb'">{{ settings.label2 ? settings.label2 : 'Use a different billing address' }}</label>

							<input type="checkbox" name="bill_to_different_address" data-index="0" id="billing_same_as_shipping" value="same_as_shipping" class="billing_option" checked="checked" v-if="settings.buttonType == 'cb'"><label for="billing_same_as_shipping" v-if="settings.buttonType == 'cb'">{{ settings.label1 ? settings.label1 : 'Same as shipping address' }}</label>

						</div>
						<div class="bu-billing-form-fields wc-block-components-address-address-wrapper is-editing">
							<bricks-element-children :element="element" />
						</div>
					</li>
				</ul>
				<div v-if="settings.radioButtons" class="wc-block-components-address-address-wrapper is-editing">
					<bricks-element-children :element="element" />
				</div>
			</component>
		</script>
	<?php
	}
}