<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooCouponForm extends \Bricks\Element {
	public $category 	= 'coupon';
	public $name 		= 'bu-coupon-form';
	public $icon 		= 'ti-layout-cta-left';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Coupon Form', 'bricksultimate' );
	}

	public function get_keywords() {
		return [ 'coupon', 'form', 'coupon form' ];
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['inp'] = [
			'title' 	=> esc_html__( 'Input Field', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
		
		$this->control_groups['button'] = [
			'title' 	=> esc_html__( 'Apply Button', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['spinner'] = [
			'title' 	=> esc_html__( 'Spinner', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['animation'] = [
			'title' 	=> esc_html__( 'Animation', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['success'] = [
			'title' 	=> esc_html__( 'Success Message', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['error'] = [
			'title' 	=> esc_html__( 'Error Message', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder control groups
	public function set_controls() {

		$this->controls['cssGrid'] = [
			'tab' 	=> 'content',
			'type' 	=> 'text',
			'label' => esc_html__('Grid template columns', 'bricks'),
			'placeholder' => "60% 1fr",
			'css' 	=> [
				[
					'property' 	=> 'grid-template-columns',
				]
			]
		];

		$this->controls['colGap'] = [
			'tab' 	=> 'content',
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'label' => esc_html__('Gap', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> 'gap',
				]
			]
		];

		$this->inputControls();
		$this->applyButtonControls();
		$this->spinnerControls();
		$this->animationControls();
		$this->successControls();
		$this->errorControls();
	}

	public function inputControls() {
		$selector = '.bu-coupon-inp-field';

		$this->controls['placeholder'] = [
			'tab' 	=> 'content',
			'group' => 'inp',
			'type' 	=> 'text',
			'label' => esc_html__('Label/Placeholder', 'bricks'),
			'placeholder' => esc_html__('Enter coupon code', 'woocommerce')
		];

		$this->controls['inpPadding'] = [
			'tab' 	=> 'content',
			'group' => 'inp',
			'type' 	=> 'dimensions',
			'label' => esc_html__('Padding', 'bricks'),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['inpWidth'] = [
			'tab' 	=> 'content',
			'group' => 'inp',
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'medium' => true,
			'label' => esc_html__('Width', 'bricks'),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['inpheight'] = [
			'tab' 	=> 'content',
			'group' => 'inp',
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'medium' => true,
			'label' => esc_html__('Height', 'bricks'),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['inpOrder'] = [
			'tab' 	=> 'content',
			'group' => 'inp',
			'type' 	=> 'number',
			'unit' 	=> false,
			'inline' => true,
			'label' => esc_html__('Order', 'bricks'),
			'css' 	=> [
				[
					'property' => 'order',
					'selector' => $selector
				]
			]
		];

		$this->controls['inpsep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator'
		];

		$this->controls['inpBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inpTG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'font',
				]
			]
		];

		$this->controls['placeholderColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Placeholder color', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . "::placeholder",
					'property'  => 'color',
				]
			]
		];

		$this->controls['inpBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['inpBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['inpFSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label'     => esc_html__('Focus', 'bricks'),
		];

		$this->controls['inpFBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inpfclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'color',
				]
			]
		];

		$this->controls['inpfbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'border',
				]
			]
		];

		$this->controls['inpfbs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'box-shadow',
				]
			]
		];
	}

	public function successControls() {
		$selector = '.woocommerce-message';

		$this->controls['previewMessage'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Preview In-Builder', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector . ".bu-in-builder",
					'value' 	=> 'block',
					'important' => true
				]
			]
		];

		$this->controls['disableMsg'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Disable the message', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector,
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['msgPadding'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'dimensions',
			'label' => esc_html__('Padding', 'bricks'),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['msgBG'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['msgTG'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['msgBorder'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['messageOrder'] = [
			'tab' 	=> 'content',
			'group' => 'success',
			'type' 	=> 'number',
			'unit' 	=> false,
			'inline' => true,
			'label' => esc_html__('Order', 'bricks'),
			'css' 	=> [
				[
					'property' => 'order',
					'selector' => $selector
				]
			]
		];
	}

	public function spinnerControls() {
		$this->controls['spinnerColor'] = [
			'group' => 'spinner',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> '--loading-color'
				]
			]
		];

		$this->controls['spinnerSize'] = [
			'group' => 'spinner',
			'type' 	=> 'number',
			'label' => esc_html__('Size', 'bricks'),
			'units' => true,
			'css' 	=> [
				[
					'property' 	=> '--loading-size'
				]
			]
		];
	}

	public function errorControls() {
		$selector = '.woocommerce-error, .wc-block-components-notice-banner.is-error';

		$this->controls['previewError'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Preview In-Builder', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector . ".bu-in-builder",
					'value' 	=> 'block',
					'important' => true
				]
			]
		];

		$this->controls['disableError'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Disable the message', 'bricks'),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector,
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['errorPadding'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'dimensions',
			'label' => esc_html__('Padding', 'bricks'),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['errorBG'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['errorTG'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['errorBorder'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['errorOrder'] = [
			'tab' 	=> 'content',
			'group' => 'error',
			'type' 	=> 'number',
			'unit' 	=> false,
			'inline' => true,
			'label' => esc_html__('Order', 'bricks'),
			'css' 	=> [
				[
					'property' => 'order',
					'selector' => $selector
				]
			]
		];
	}

	public function applyButtonControls() {
		$selector = '.apply-coupon-button';
		$hover = '.apply-coupon-button:hover';

		$this->controls['btnText'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'text',
			'label' => esc_html__('Text', 'bricks'),
			'placeholder' => esc_html__('Apply', 'woocommerce'),
		];

		$this->controls['btnTextSep'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'separator',
		];

		$this->controls['btnMargin'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'dimensions',
			'label' => esc_html__('Margin', 'bricks'),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnPadding'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'dimensions',
			'label' => esc_html__('Padding', 'bricks'),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnWidth'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'medium' => true,
			'label' => esc_html__('Width', 'bricks'),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnheight'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'medium' => true,
			'label' => esc_html__('Height', 'bricks'),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnOrder'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'number',
			'unit' 	=> false,
			'inline' => true,
			'label' => esc_html__('Order', 'bricks'),
			'css' 	=> [
				[
					'property' => 'order',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnStyleSep'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'separator',
		];

		$this->controls['btnBG'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnTG'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnBorder'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnBS'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			]
		];

		$this->controls['btnHoverSep'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__('Hover', 'bricks')
		];

		$this->controls['btnHBG'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $hover
				]
			]
		];

		$this->controls['btnHC'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $hover
				]
			]
		];

		$this->controls['btnHBorder'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $hover
				]
			]
		];

		$this->controls['btnHBS'] = [
			'tab' 	=> 'content',
			'group' => 'button',
			'type' 	=> 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $hover
				]
			]
		];
	}

	public function animationControls() {
		$selector = 'label';

		$this->controls['isAnimate'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Animate label?', 'bricks'),
		];

		$this->controls['labelTypography'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'typography',
			'label' => esc_html__('Label typography', 'bricks'),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['labelTransition'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'number',
			'unit' 	=> false,
			'min' 	=> 0,
			'max' 	=> 10,
			'step' 	=> 0.1,
			'label' => esc_html__('Animation duration(s)', 'bricks'),
			'css' 	=> [
				[
					'property' => 'transition-duration',
					'selector' => $selector,
					'value' 	=> '%ss'
				]
			],
			'placeholder' => 0.3
		];

		$this->controls['labelLeft'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'number',
			'units' => true,
			'min' 	=> 0,
			'max' 	=> 100,
			'step' 	=> 1,
			'label' => esc_html__('Position: Left', 'bricks'),
			'css' 	=> [
				[
					'property' => 'left',
					'selector' => $selector,
				]
			],
			'placeholder' => '12px'
		];

		$this->controls['labelSep'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'separator',
			'label' => esc_html__('After animation', 'bricksultimate'),
		];

		$this->controls['labelSize'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Font size', 'bricks'),
			'css' 	=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-coupon-inp-field:focus ~ label',
				],
				[
					'property' => 'font-size',
					'selector' => '.bu-coupon-inp-field:valid ~ label',
				]
			],
			'placeholder' => 10
		];

		$this->controls['labelBg'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'color',
			'inline' => true,
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => '.bu-coupon-inp-field:focus ~ label',
				],
				[
					'property' => 'background-color',
					'selector' => '.bu-coupon-inp-field:valid ~ label',
				]
			]
		];

		$this->controls['labelColor'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'color',
			'inline' => true,
			'label' => esc_html__('Color', 'bricks'),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.bu-coupon-inp-field:focus ~ label',
				],
				[
					'property' => 'color',
					'selector' => '.bu-coupon-inp-field:valid ~ label',
				]
			]
		];

		$this->controls['labelAnimLeft'] = [
			'tab' 	=> 'content',
			'group' => 'animation',
			'type' 	=> 'number',
			'units' => true,
			'min' 	=> 0,
			'max' 	=> 100,
			'step' 	=> 1,
			'label' => esc_html__('Position: Left', 'bricks'),
			'css' 	=> [
				[
					'property' => 'left',
					'selector' => '.bu-coupon-inp-field:focus ~ label',
				],
				[
					'property' => 'left',
					'selector' => '.bu-coupon-inp-field:valid ~ label',
				]
			],
			'placeholder' => '10px'
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ) {
			wp_enqueue_style( 'bu-coupon', Helpers::get_asset_url('css') . 'coupon.min.css', [], filemtime(Helpers::get_asset_path('css') . 'coupon.min.css'), 'all' );
			wp_enqueue_script( 'bu-coupon-form', Helpers::get_asset_url('js') . 'couponform.min.js', [], filemtime(Helpers::get_asset_path('js') . 'couponform.min.js' ),true);
		}*/

		wp_enqueue_script( 'bu-coupon-form', Helpers::get_asset_url('js') . 'couponform.min.js', [], filemtime(Helpers::get_asset_path('js') . 'couponform.min.js' ),true);

		wp_localize_script( 
			'bu-coupon-form', 
			'COUPON', 
			array( 
				'nonce' 				=> wp_create_nonce( "bu-applied-coupons" ), 
				'remove_coupon_nonce' 	=> wp_create_nonce( 'remove-coupon' ),
				'i18n_remove' 			=> __( 'Remove', 'woocommerce' ),
				'i18n_fstext' 			=> __( 'Free shipping coupon', 'woocommerce' ),
				'i18n_discount' 		=> __( 'Discount', 'bricksultimate' )
			) 
		);
	}

	// Render element HTML
	public function render() {
		$class = "bu-input-field";
		$label = Helpers::get_value($this->settings,'placeholder',__("Enter coupon code", "woocommerce"));

		if( isset( $this->settings['isAnimate'] ) ) {
			$class .= " bu-input-field--anim";
			$this->set_attribute("bu-inp-field", 'required', '');
		} else {
			$this->set_attribute("bu-inp-field", 'placeholder', $label);
		}
		
		$this->set_attribute( '_root', 'data-coupon-nonce', wp_create_nonce('apply-coupon') );
		echo "<div {$this->render_attributes("_root")}>";

		if( bricks_is_builder() || Helpers::isBricksBuilderActive() ) {
			echo "<div class=\"woocommerce-message bu-in-builder\" role=\"alert\">Coupon code applied successfully.</div><ul class=\"woocommerce-error bu-in-builder\" role=\"alert\"><li>Coupon \"earlybird\" does not exist!</li></ul>";
		}

		echo '<div class="' . $class .'"><input type="text" name="bu_coupon_code" class="bu-coupon-inp-field" value="" ' . $this->render_attributes("bu-inp-field") .'/><label>'. $label .'</label></div><button type="button" name="applycoupon" class="apply-coupon-button"><span>'. Helpers::get_value($this->settings,'btnText',__('Apply', 'woocommerce')) .'</span></button>';
		echo "</div>";
	}
}