<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooProductGallerySlider extends \Bricks\Element {
	public $category 	= 'ultimate';
	public $name 		= 'bu-product-gallery-slider';
	public $icon 		= 'ti-layout-slider';
	public $tag 		= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Product Gallery Slider', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['type'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Type', 'bricksultimate'),
			'options'   => [ 'main' => esc_html__('Main', 'bricksultimate'), 'thumbs' => esc_html__('Thumbnails') ],
			'default'   => 'main',
			'placeholder' => 'main',
			'inline' 	=> true,
		];

		$this->controls['source'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Source', 'bricksultimate'),
			'options'   => [ 'wc' => esc_html__('WooCommerce default galleries', 'bricksultimate'), 'cmf' => esc_html__('Custom Field - ACF/MB') ],
			'default'   => 'wc',
			'placeholder' => 'wc',
		];

		$this->controls['cmfKey'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__('Custom Field Name', 'bricksultimate'),
			'hasDynamicData' => false,
			'placeholder' => esc_html__('Enter custom field key here', 'bricksultimate'),
			'required' 	=> ['source', '=', 'cmf']
		];

		$this->controls['imageSize'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Image resolution', 'bricksultimate'),
			'options'   => $this->control_options['imageSizes'],
			'default'   => 'woocommerce_single'
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		wp_enqueue_script( 'bu-prd-imgsld', Helpers::get_asset_url('js') . 'prdimgsld.min.js', [], filemtime(Helpers::get_asset_path('js') . 'prdimgsld.min.js') );
	}*/

	// Render element HTML
	public function render() {
		global $product;

		$product = wc_get_product( $this->post_id );

		if( $product === false )
			return;

		$settings = $this->settings;

		if( $settings['type'] === 'main' ) {
			$this->generate_main_slider();
		}

		if( $settings['type'] === 'thumbs' ) {
			$this->generate_thumbs_slider();
		}
	}

	private function generate_main_slider() {
		--
	}

	private function generate_thumbs_slider() {
		//--
	}
}