<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class DualColorTextStyles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add BricksUltimate elements style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['bu-dual-color-text'] = [
			'title' => 'Ultimate - ' . esc_html__( 'Dual Color Text', 'bricksultimate' ),
		];

		return $control_groups;
	}

	/**
	 * Add BricksUltimate elements style controls
	 */
	public function set_controls( $controls ) {
		$dualcolor_controls = [];
		$dualcolor_controls['bu-dual-color-text'] = [
			'text1' => [
				'group'  => 'bu-dual-color-text',
				'label'  => esc_html__( 'First Text', 'bricksultimate' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css' 		=> [
					[
						'selector' => '.bu-dual-text',
						'property' => 'font'
					]
				]
			],
			'text2' => [
				'group'  => 'bu-dual-color-text',
				'label'  => esc_html__( 'Second Text', 'bricksultimate' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css' 		=> [
					[
						'selector' => '.bu-dual-text-alt',
						'property' => 'font'
					]
				]
			],
		];

		return array_merge( $controls, $dualcolor_controls ); 
	}
}