(function($) {
    'use strict';

	$(document).ready(function () {

		$('[data-toggle="popover"]').popover();
    	$('[data-bs-toggle="tooltip"]').tooltip();
		
		$(document).find('#ays-title').on('input', function () {
            $(document).find('.ays_chart_title_in_top').text($(this).val());
        });
		
    	$(document).find('.form-check-input.select-all').on('click', function() {
			var checkboxes = $(document).find('.check-current-row');
			if ($(this).prop('checked') == true && checkboxes.length !== 0) {
				$(this).parents('thead').next('tbody').find('tr').addClass("ays-chart-tr-selected");
				checkboxes.prop('checked',true);
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
				$(document).find('#ays-chart-bulk-delete-bottom').prop('disabled', false);
			} else {
				$(this).parents('thead').next('tbody').find('tr').removeClass("ays-chart-tr-selected");
				checkboxes.prop('checked',false);
				$(document).find('#ays-chart-bulk-delete').prop('disabled', true);
				$(document).find('#ays-chart-bulk-delete-bottom').prop('disabled', true);
			}
		});

		$(document).find('.check-current-row').on('click', function() {
			var checkboxesArr = $(document).find('.check-current-row');
			var selectAllCheckBox = $(document).find('.form-check-input.select-all'); 
			var count = 0;

			for (var i = 0; i < checkboxesArr.length; i++) {
				if (checkboxesArr.eq(i).prop('checked') == true) {
					count++;
				}
			}	

			if ((count == 0 && selectAllCheckBox.prop('checked') == true) || (count != 0 && selectAllCheckBox.prop('checked') == true)) {
				selectAllCheckBox.prop('checked', false);	
			} else if (count == checkboxesArr.length && selectAllCheckBox.prop('checked') == false) {
				selectAllCheckBox.prop('checked', true);
			}

			if ( $(this).prop('checked') ) {
				$(this).parents('tr').addClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
				$(document).find('#ays-chart-bulk-delete-bottom').prop('disabled', false);
			} else if ( !$(this).prop('checked') && count > 0) {
				$(this).parents('tr').removeClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
				$(document).find('#ays-chart-bulk-delete-bottom').prop('disabled', false);
			} else {
				$(this).parents('tr').removeClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', true);
				$(document).find('#ays-chart-bulk-delete-bottom').prop('disabled', true);
			}
		});

		// Bulk delete confirmation
		$(document).on('click', '#ays-chart-bulk-delete', function(e) {
			e.preventDefault();
			var confirm = window.confirm(aysChartBuilderAdmin.confirmDelete);
			if (confirm) {
				$(document).find('#ays-chart-bulk-delete-confirm').trigger('click');
			}
		});
		$(document).on('click', '#ays-chart-bulk-delete-bottom', function(e) {
			e.preventDefault();
			var confirm = window.confirm(aysChartBuilderAdmin.confirmDelete);
			if (confirm) {
				$(document).find('#ays-chart-bulk-delete-confirm-bottom').trigger('click');
			}
		});

		// Delete confirmation
		$(document).on('click', '.ays_chart_delete_confirm', function(e){            
			e.preventDefault();
			var confirm = window.confirm(aysChartBuilderAdmin.confirmDelete);
			if (confirm){
				window.location.replace($(this).attr('href'));
			}
		});

		$(document).find("input#ays-chart-search-input + button#ays-chart-search").on("click", function (e) {
			var _this  = $(this);
            var parent = _this.parents('form');
            
            var search_input = parent.find('input#ays-chart-search-input');
            var input_value  = search_input.val();
			
            var field = 's';
            var flag = false;
            var url = window.location.href;
            if (url.indexOf('?' + field + '=') != -1) {
				flag = true;
            } else if (url.indexOf('&' + field + '=') != -1) {
				flag = true;
            }
			
			// location.href = location.href.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
            if (flag) {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = location.href.replace(/&s=([^&]$|[^&]*)/i, "&s="+input_value);
				} else if (input_value == "") {
					url = location.href.replace(/&s=([^&]$|[^&]*)/i, "");
				}
            } else {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = location.href + "&s=" + input_value;
				}
			}

			e.preventDefault();
			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
        });

		$(document).on("click", "button[id^='ays-chart-filter']", function (e) {
			e.preventDefault();
			var _this  = $(this);
            var parent = _this.parents('form');
            
			var inputSelectors = ['#ays-chart-filter-select', '#ays-chart-filter-author', '#ays-chart-filter-source', '#ays-chart-filter-date', '#ays-chart-order-by', '#ays-chart-order'];
			var inputValues = inputSelectors.map(selector => parent.find(selector).val());

			var filterFields = ['filterbytype', 'filterbyauthor', 'filterbysource', 'filterbydate', 'orderby', 'order'];
			
			addFiltersUrl(inputValues, filterFields);
        });

		$(document).on("click", "button[id^='ays-chart-filter-clear']", function (e) {
			e.preventDefault();
			clearFiltersUrl();
		});
            
		function addFiltersUrl(inputValues, filterFields) {
            var url = window.location.href;
			for (var i = 0; i < inputValues.length; i++) {
				var flag = url.includes('?' + filterFields[i] + '=') || url.includes('&' + filterFields[i] + '=');
            if (flag) {
					url = url.replace(new RegExp('&?' + filterFields[i] + '=([^&]*)'), '');
				}
				if (inputValues[i]) {
					url += '&' + filterFields[i] + '=' + inputValues[i];
				}
			}

			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
		}

		function clearFiltersUrl () {
            var url = window.location.href;
			var filterFields = ['filterbytype', 'filterbyauthor', 'filterbysource', 'filterbydate', 'orderby', 'order'];

			for (var i = 0; i < filterFields.length; i++) {
				url = url.replace(new RegExp('&?' + filterFields[i] + '=([^&]*)'), '');
			}

			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
		}

		$(document).find('#ays-chart-filter-author').select2({
			placeholder: aysChartBuilderAdmin.selectUser,
			dropdownAutoWidth: true,
			minimumInputLength: 1,
			allowClear: true,
			language: {
				searching: function() {
					return aysChartBuilderAdmin.searching;
				},
				inputTooShort: function () {
					return aysChartBuilderAdmin.pleaseEnterMore;
				}
			},
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				data: function (response) {
					var checkedUsers = $(document).find('#ays-chart-filter-author').val();
					return {
						action: 'ays_chart_admin_ajax',
						function: window.aysChartBuilderChartSettings.ajax['actions']['author_user_search'],
						security: window.aysChartBuilderChartSettings.ajax['nonces']['author_user_search'],
						params: {
							search: response.term,
							val: checkedUsers
						}
					};
				}
			}
		});
		$(document).find('#ays-chart-filter-author-bottom').select2({
			placeholder: aysChartBuilderAdmin.selectUser,
			dropdownAutoWidth: true,
			minimumInputLength: 1,
			allowClear: true,
			language: {
				searching: function() {
					return aysChartBuilderAdmin.searching;
				},
				inputTooShort: function () {
					return aysChartBuilderAdmin.pleaseEnterMore;
				}
			},
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				data: function (response) {
					var checkedUsers = $(document).find('#ays-chart-filter-author-bottom').val();
					return {
						action: 'ays_chart_admin_ajax',
						function: window.aysChartBuilderChartSettings.ajax['actions']['author_user_search'],
						security: window.aysChartBuilderChartSettings.ajax['nonces']['author_user_search'],
						params: {
							search: response.term,
							val: checkedUsers
						}
					};
				}
			}
		});

		$(document).on('mouseenter', 'td.column-title', function() {
			// $(this).find('.chart-list-table-actions-row').css('visibility', 'visible');
			$(this).find('.chart-list-table-actions-row').css('display', 'flex');
			// $(this).css('padding', '8px 8px');
		});
		$(document).on('mouseleave', 'td.column-title', function() {
			// $(this).find('.chart-list-table-actions-row').css('visibility', 'hidden');
			$(this).find('.chart-list-table-actions-row').hide();
			// $(this).css('padding', '23px 8px');
		});

		$(document).find('.ays-chart-copy-image').on('click', function(){
			var _this = this;
			var input = $(_this).parent().find('input.ays-chart-shortcode-input');
			var length = input.val().length;

			input[0].focus();
			input[0].setSelectionRange(0, length);
			document.execCommand('copy');
			// document.getSelection().removeAllRanges();

			$(_this).attr('data-original-title', aysChartBuilderAdmin.copied);
			$(_this).attr("data-bs-original-title", aysChartBuilderAdmin.copied);
			$(_this).attr("title", aysChartBuilderAdmin.copied);
			$(_this).tooltip('show');
		});

		$(document).find('.ays-chart-shortcode-input').on('focus', function(){
			this.setSelectionRange(0, $(this).val().length);
		});

		$(document).find('.ays-chart-copy-image').on('mouseleave', function(){
			var _this = this;

			$(_this).attr('data-original-title', aysChartBuilderAdmin.clickForCopy);
			$(_this).attr("data-bs-original-title", aysChartBuilderAdmin.clickForCopy);
			$(_this).attr("title", aysChartBuilderAdmin.clickForCopy);
		});

		$(document).on('click', '.notice-dismiss', function (e) {
			changeCurrentUrl('status');
		});

		var toggle_ddmenu = $(document).find('.toggle_ddmenu');
    	toggle_ddmenu.on('click', function () {
    	    var ddmenu = $(this).next();
    	    var state = ddmenu.attr('data-expanded');
    	    switch (state) {
    	        case 'true':
    	            $(this).find('.ays_fa').css({
    	                transform: 'rotate(0deg)'
    	            });
    	            ddmenu.attr('data-expanded', 'false');
    	            break;
    	        case 'false':
    	            $(this).find('.ays_fa').css({
    	                transform: 'rotate(90deg)'
    	            });
    	            ddmenu.attr('data-expanded', 'true');
    	            break;
    	    }
    	});

		function changeCurrentUrl(key){
			var linkModified = location.href.split('?')[1].split('&');
			for(var i = 0; i < linkModified.length; i++){
				if(linkModified[i].split("=")[0] == key){
					linkModified.splice(i, 1);
				}
			}
			linkModified = linkModified.join('&');
			window.history.replaceState({}, document.title, '?'+linkModified);
		}

		// Select message vars charts page
        $(document).find('.ays-chart-message-vars-icon').on('click', function(e){
            $(this).parents(".ays-chart-message-vars-box").find(".ays-chart-message-vars-data").toggle('fast');
        });

        $(document).find('.ays-chart-open-charts-list').on('click', function(e){
            $(this).parents(".ays-chart-subtitle-main-box").find(".ays-chart-charts-data").toggle('fast');
        });
        
        $(document).on( "click" , function(e){
            if($(e.target).closest('.ays-chart-message-vars-box,.ays-chart-subtitle-main-box').length != 0){
                
            } 
            else{
                $(document).find(".ays-chart-message-vars-box .ays-chart-message-vars-data,.ays-chart-subtitle-main-box .ays-chart-charts-data").hide('fast');
            }
        });

        $(document).find(".ays-chart-go-to-charts").on("click" , function(e){
            e.preventDefault();
            var confirmRedirect = window.confirm('Are you sure you want to redirect to another chart? Note that the changes made in this chart will not be saved.');
            if(confirmRedirect){
                window.location = $(this).attr("href");
            }
        });

        $(document).find('.ays-chart-message-vars-each-data').on('click', function(e){
            var messageVar = $(this).find(".ays-chart-message-vars-each-var").val();
            var mainParent = $(this).parents('.ays-chart-box-for-mv');
            var dataTMCE   = mainParent.find('.ays-chart-message-vars-data').attr('data-tmce');
            
            if ( mainParent.find("#wp-"+dataTMCE+"-wrap").hasClass("tmce-active") ){
                window.tinyMCE.get(dataTMCE).setContent( window.tinyMCE.get(dataTMCE).getContent() + messageVar + " " );
            }else{
                mainParent.find('#'+dataTMCE).append( " " + messageVar + " ");
            }
        });
        
        $(document).on("click", ".ays-chart-cards-block .ays-chart-card__footer button.status-missing", function(e){
			var $this = $(this);
			var thisParent = $this.parents(".ays-chart-cards-block");
	
			$this.prop('disabled', true);
			$this.addClass('disabled');
	
			var loader_html = '<i class="fa fa-spinner fa-spin" aria-hidden="true"></i>';
	
			$this.html(loader_html);
	
			var attr_plugin = $this.attr('data-plugin');
			var wp_nonce = thisParent.find('#ays_chart_ajax_install_plugin_nonce').val();
	
			var data = {
				action: 'ays_chart_install_plugin',
				_ajax_nonce: wp_nonce,
				plugin: attr_plugin,
				type: 'plugin'
			};
	
			$.ajax({
				url: aysChartBuilderAdmin.ajaxUrl,
				method: 'post',
				dataType: 'json',
				data: data,
				success: function (response) {
					if (response.success) {
						swal.fire({
							type: 'success',
							html: "<h4>"+ response['data']['msg'] +"</h4>"
						}).then( function(res) {
							if ( $this.hasClass('status-missing') ) {
								$this.removeClass('status-missing');
							}
							$this.text(aysChartBuilderAdmin.activated);
							$this.addClass('status-active');
						});
					}
					else {
						swal.fire({
							type: 'info',
							html: "<h4>"+ response['data'][0]['message'] +"</h4>"
						}).then( function(res) {
							$this.text(aysChartBuilderAdmin.errorMsg);
						});
					}
				},
				error: function(){
					swal.fire({
						type: 'info',
						html: "<h2>"+ aysChartBuilderAdmin.loadResource +"</h2><br><h6>"+ aysChartBuilderAdmin.somethingWentWrong +"</h6>"
					}).then( function(res) {
						$this.text(aysChartBuilderAdmin.errorMsg);
					});
					// $this.prop('disabled', false);
					// if ( $this.hasClass('disabled') ) {
					//     $this.removeClass('disabled');
					// }
				}
			});
		});
	
		$(document).on("click", ".ays-chart-cards-block .ays-chart-card__footer button.status-installed", function(e){
			var $this = $(this);
			var thisParent = $this.parents(".ays-chart-cards-block");
	
			$this.prop('disabled', true);
			$this.addClass('disabled');
	
			var loader_html = '<i class="fa fa-spinner fa-spin" aria-hidden="true"></i>';
	
			$this.html(loader_html);
	
			var attr_plugin = $this.attr('data-plugin');
			var wp_nonce = thisParent.find('#ays_chart_ajax_install_plugin_nonce').val();
	
			var data = {
				action: 'ays_chart_activate_plugin',
				_ajax_nonce: wp_nonce,
				plugin: attr_plugin,
				type: 'plugin'
			};
	
			$.ajax({
				url: aysChartBuilderAdmin.ajaxUrl,
				method: 'post',
				dataType: 'json',
				data: data,
				success: function (response) {
					if( response.success ){
						swal.fire({
							type: 'success',
							html: "<h4>"+ response['data'] +"</h4>"
						}).then( function(res) {
							if ( $this.hasClass('status-installed') ) {
								$this.removeClass('status-installed');
							}
							$this.text(aysChartBuilderAdmin.activated);
							$this.addClass('status-active disabled');
						});
					} else {
						swal.fire({
							type: 'info',
							html: "<h4>"+ response['data'][0]['message'] +"</h4>"
						});
					}
				},
				error: function(){
					swal.fire({
						type: 'info',
						html: "<h2>"+ aysChartBuilderAdmin.loadResource +"</h2><br><h6>"+ aysChartBuilderAdmin.somethingWentWrong +"</h6>"
					}).then( function(res) {
						$this.text(aysChartBuilderAdmin.errorMsg);
					});;
					// $this.prop('disabled', false);
					// if ( $this.hasClass('disabled') ) {
					//     $this.removeClass('disabled');
					// }
				}
			});
		});


		var createdNewChart = getCookie('ays_chart_created_new');
        if (createdNewChart && createdNewChart > 1) {
            swal({
                title: '<strong>Great job</strong>',
                type: 'success',
                html: '<p>Your chart is Created!<br>Copy the generated shortcode and paste it into any post or page to display the chart.</p><input type="text" id="ays-chart-create-new" onClick="this.setSelectionRange(0, this.value.length)" readonly value="[ays_chart id=\'' + createdNewChart + '\']" />',
                showCloseButton: true,
                focusConfirm: false,
                confirmButtonText: '<i class="ays_fa ays_fa_thumbs_up"></i> Done',
                confirmButtonAriaLabel: 'Thumbs up, done!',
            });
			deleteCookie('ays_chart_created_new');
        }

		function getCookie (cname) {
			let name = cname + "=";
			let decodedCookie = decodeURIComponent(document.cookie);
			let ca = decodedCookie.split(';');
			for(let i = 0; i <ca.length; i++) {
			  let c = ca[i];
			  while (c.charAt(0) == ' ') {
				c = c.substring(1);
			  }
			  if (c.indexOf(name) == 0) {
				return c.substring(name.length, c.length);
			  }
			}
			return "";
		}
	
		function deleteCookie (name) {
			document.cookie = name + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
		}

	});

})(jQuery);