<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Chart_Builder
 * @subpackage Chart_Builder/includes
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Chart_Builder
 * @subpackage Chart_Builder/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Chart_Builder_Integrations
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $settings_obj;

    private $capability;

    private $blockquote_content;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string $plugin_name The name of this plugin.
     * @param      string $version The version of this plugin.
     */
    public function __construct($plugin_name, $version){

        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->settings_obj = new Chart_Builder_Settings_DB_Actions($this->plugin_name);

        $settings_url = sprintf(
            __( "For enabling this option, please go to %s page and fill all options.", $this->plugin_name ),
            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=".$this->plugin_name."-settings&ays_tab=tab2' target='_blank'>". __( "this", $this->plugin_name ) ."</a>"
        );
        $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
        $this->blockquote_content = $blockquote_content;
    }

    // ===== INTEGRATIONS HOOKS =====

    // Integrations chart page action hook
    public function ays_chart_page_integrations_content( $args ){

        if( ! $this->settings_obj->get_permission_for_editing_plugin() ){
            $settings_url = __( "This functionality is disabled.", $this->plugin_name );
            $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
            $this->blockquote_content = $blockquote_content;
        }

        $integrations_contents = apply_filters( 'ays_cb_chart_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset>';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            $content .= $integrations_content['content'];

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);

    }

    // Integrations settings page action hook
    public function ays_settings_page_integrations_content( $args ){

        $integrations_contents = apply_filters( 'ays_cb_settings_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset>';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            if(isset($integrations_content['content'])){
                $content .= $integrations_content['content'];
            }

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Google sheet starts =====

        // Google sheet integration / chart page
        // Google sheet integration / chart page content
		public function source_contents_import_from_google_sheet_settings( $sources, $args ){
			$chart_id = $args['chart_id'];
			$html_class_prefix = $args['html_class_prefix'];
			$html_name_prefix = $args['html_name_prefix'];
			$chart = $args['chart'];
			$source = $args['source'];
			$spreadsheet_id = $chart['source'];
			$source_type = $args['source_type'];

			if( $source_type != 'google_sheet' ){
				$spreadsheet_id = '';
			}

            $settings_obj = new Chart_Builder_Settings_DB_Actions( $this->plugin_name );

			$google_res = ($settings_obj->get_setting('google') === false) ? json_encode(array()) : $settings_obj->get_setting('google');
			$google     = json_decode($google_res, true);

			if( empty( $google ) ) {
                $title = __( 'Connect to Google Sheets', $this->plugin_name ) . ' <a class="ays_help" data-bs-toggle="tooltip" title="' . __("Activate Google Integration to import the information from the Google Sheets.",$this->plugin_name) . '">
                            <i class="ays_fa ays_fa_info_circle"></i>
                        </a>';
                $content = $this->blockquote_content;
			    $sources['google_sheet'] = array(
				    'content' => $content,
				    'title' => $title
			    );
                return $sources;
			}

			$google_client = isset($google['client']) ? $google['client'] : '';
			$google_secret = isset($google['secret']) ? $google['secret'] : '';
			$google_token  = isset($google['token']) ? $google['token'] : '';
			$google_email  = isset($google['user_email']) ? $google['user_email'] : '';

			$google_refresh_token = isset($google['refresh_token']) ? $google['refresh_token'] : '';

			$spreadsheets = array();
            if( $google ) {
                $google_sheet_data = array(
                    "refresh_token" => $google_refresh_token,
                    "client_id"     => $google_client,
                    "client_secret" => $google_secret,
                    "user_email"    => $google_email,
                );

	            $result = $this->ays_chart_get_google_spreadsheets( $google_sheet_data );
	            if( isset( $result['files'] ) && !empty( $result['files'] ) ){
		            $spreadsheets = $result['files'];
	            }
            }

			ob_start();
			?>
			<div class="ays-accordion-data-main-wrap">
				<div class="<?= $html_class_prefix ?>source-data-main-wrap">
					<div class="<?= $html_class_prefix ?>chart-source-data-main">
						<div id="ays-chart-google-sheet-form">
							<div class="<?= $html_class_prefix ?>google-sheet-select-wrap">
                                <select name="<?= $html_name_prefix ?>google_sheet_id" id="<?= $html_name_prefix ?>google_sheet_id_select" class="<?= $html_class_prefix ?>google-sheet-select" data-chart-id="<?= $chart_id ?>">
                                    <option value=""><?= __( 'Select spreadsheet', $this->plugin_name ) ?></option>
                                    <?php foreach ( $spreadsheets as $spreadsheet): ?>
                                        <option value="<?= $spreadsheet['id'] ?>" <?= $spreadsheet_id == $spreadsheet['id'] ? 'selected' : '' ?> ><?= $spreadsheet['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
							</div>
                            <p class="<?= $html_class_prefix ?>csv-export-example" style="font-size: 15px; font-style: italic;">
                                <a class="ays_help" data-bs-toggle="tooltip" title="<?php echo __("With the help of this file, you will be able to learn about the needed Data Structure. Each Chart Type has its own Data Structure, that is why you will need to download the attached file for each type separately. To make everything work properly, you will need to insert the data to the Google Sheet as it is displayed in the attached example.",$this->plugin_name) ?>">
                                    <i class="ays_fa ays_fa_info_circle"></i>
                                </a>
                                <?php echo __( 'Example of chart data: ', $this->plugin_name ) ?>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-other-types cb-line_chart-opt cb-bar_chart-opt cb-pie_chart-opt cb-column_chart-opt cb-donut_chart-opt cb-histogram-opt cb-area_chart-opt cb-combo_chart-opt cb-stepped_area_chart-opt cb-3dpie_chart-opt cb-csv-gauge_chart-ex" style="cursor: pointer;" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/example.csv" download="example.csv">example.csv</a> 
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-org-type cb-org_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/org-chart-example.csv" download="org-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-geo-type cb-geo_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/geo-chart-example.csv" download="geo-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-bubble-type cb-bubble_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/bubble-chart-example.csv" download="bubble-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-scatter-type cb-scatter_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/scatter-chart-example.csv" download="scatter-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-table-type cb-table_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/table-chart-example.csv" download="table-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-timeline-type cb-timeline_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/timeline-chart-example.csv" download="timeline-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-candlestick-type cb-candlestick_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/candlestick-chart-example.csv" download="candlestick-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-gantt-type cb-gantt_chart-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/gantt-chart-example.csv" download="gantt-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-sankey-type cb-sankey_diagram-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/sankey-chart-example.csv" download="sankey-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-treemap-type cb-treemap-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/treemap-chart-example.csv" download="treemap-chart-example.csv">example.csv</a>
                                <a class="<?= $html_class_prefix ?>csv-export-example-link cb-changable-opt <?= $html_class_prefix ?>csv-export-example-link-wordtree-type cb-word_tree-opt display_none" style="cursor: pointer" href="<?php echo CHART_BUILDER_ADMIN_URL;?>/partials/charts/export_files/wordtree-chart-example.csv" download="wordtree-chart-example.csv">example.csv</a>
                            </p>
                            <div class='ays-chart-google-sheet-success'></div>
                            <div class='ays-chart-google-sheet-error'><?php echo isset($result['error']['message']) ? $result['error']['message'] : ''; ?></div>
                            <div class="ays-chart-buttons-group">
                                <div class="ays-chart-buttons-group-main">
                                    <button class="<?php echo esc_attr($html_class_prefix) ?>show-on-chart-bttns" id="ays-chart-gsheet-fetch">
                                        <?php echo __( 'Show Results', "chart-builder" ); ?>
                                    </button>
                                    <button class="<?php echo esc_attr($html_class_prefix) ?>show-on-chart-bttns" id="ays-chart-gsheet-show-on-chart">
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.722 6.59785C12.2407 3.47754 10.0017 1.90723 7.00009 1.90723C3.99697 1.90723 1.75947 3.47754 0.278215 6.59941C0.218802 6.72522 0.187988 6.86263 0.187988 7.00176C0.187988 7.14089 0.218802 7.27829 0.278215 7.4041C1.75947 10.5244 3.99853 12.0947 7.00009 12.0947C10.0032 12.0947 12.2407 10.5244 13.722 7.40254C13.8423 7.14941 13.8423 6.85566 13.722 6.59785ZM7.00009 10.9697C4.47978 10.9697 2.63447 9.6916 1.3329 7.00098C2.63447 4.31035 4.47978 3.03223 7.00009 3.03223C9.5204 3.03223 11.3657 4.31035 12.6673 7.00098C11.3673 9.6916 9.52197 10.9697 7.00009 10.9697ZM6.93759 4.25098C5.41884 4.25098 4.18759 5.48223 4.18759 7.00098C4.18759 8.51973 5.41884 9.75098 6.93759 9.75098C8.45634 9.75098 9.68759 8.51973 9.68759 7.00098C9.68759 5.48223 8.45634 4.25098 6.93759 4.25098ZM6.93759 8.75098C5.9704 8.75098 5.18759 7.96816 5.18759 7.00098C5.18759 6.03379 5.9704 5.25098 6.93759 5.25098C7.90478 5.25098 8.68759 6.03379 8.68759 7.00098C8.68759 7.96816 7.90478 8.75098 6.93759 8.75098Z" fill="#14524A"/></svg>
                                        <?php echo __( 'Preview', "chart-builder" ); ?>
                                    </button>
                                    <button class="<?php echo esc_attr($html_class_prefix) ?>show-on-chart-bttns" id="ays-chart-gsheet-save">
                                        <?php echo __( 'Save data', "chart-builder" ); ?>
                                    </button>
                                </div>
                                <div class="ays-chart-buttons-group-columns">
                                    <button class="<?php echo esc_attr($html_class_prefix) ?>show-on-chart-bttns" id="ays-chart-gsheet-columns">
                                        <?php echo __( 'Columns', "chart-builder" ); ?>
                                    </button>
                                </div>
                            </div>
						</div>
					</div>
				</div>
			</div>
			<?php
			$content = ob_get_clean();

			$title = __( 'Connect to Google Sheets', $this->plugin_name ) . ' <a class="ays_help" data-bs-toggle="tooltip" title="' . __("Activate Google Integration to import the information from the Google Sheets.",$this->plugin_name) . '">
                            <i class="ays_fa ays_fa_info_circle"></i>
                        </a>';

			$sources['google_sheet'] = array(
				'content' => $content,
				'title' => $title
			);

			return $sources;
		}
    
        // Google sheet integration / settings page
        // Google sheet integration / settings page content    
        public function ays_settings_page_google_sheet_content($integrations, $args){
            $actions = $this->settings_obj;
            
            // Google sheets Xcho
            $google_res          = ($actions->get_setting('google') === false) ? json_encode(array()) : $actions->get_setting('google');
            $google_sheets       = json_decode($google_res, true);
            $google_client       = isset($google_sheets['client']) ? $google_sheets['client'] : '';
            $google_secret       = isset($google_sheets['secret']) ? $google_sheets['secret'] : '';
            $google_redirect_uri = isset($google_sheets['redirect_uri']) ? $google_sheets['redirect_uri'] : '';
            $google_token        = isset($google_sheets['token']) ? $google_sheets['token'] : '';
            $google_redirect_url = menu_page_url( $this->plugin_name . "-settings", false );

            $google_code         = !empty($_GET['code']) ? $_GET['code'] : "";
            $google_scope        = !empty($_GET['scope']) ? $_GET['scope'] : "";
            $google_code_check   = !empty($_GET['code']) && !isset($_GET['oauth']) ? true : false;

            if( $google_code && $google_scope ){
                $ays_tab = 'tab2';
            }

            // Disconect account and redirect back
            if( isset( $_REQUEST['ays_disconnect_google'] ) ){
                
                $result = $actions->update_setting('google', '');
                $this->delete_sheet_ids();
        
                $url = menu_page_url( $this->plugin_name . "-settings", false);
                $url = add_query_arg( array(
                    'ays_tab' => 'tab2',
                    'status' => 'gdisconnected'
                ), $url );
                
                wp_redirect( $url );
                exit();
            }
            
            // Save credentials and account , redirect back
            if( isset( $_REQUEST['ays_googleOAuth2'] ) ){
                // Google sheets
                $gclient_id = isset($_REQUEST['ays_google_client']) && $_REQUEST['ays_google_client'] != '' ? $_REQUEST['ays_google_client'] : '';
                $gclient_secret = isset($_REQUEST['ays_google_secret']) && $_REQUEST['ays_google_secret'] != '' ? $_REQUEST['ays_google_secret'] : '';
                $gredirect_url = isset($_REQUEST['ays_google_redirect']) && $_REQUEST['ays_google_redirect'] != '' ? $_REQUEST['ays_google_redirect'] : '';
                
                $google_sheets = array(
                    'client' => $gclient_id,
                    'secret' => $gclient_secret,
                    'redirect_uri' => $gredirect_url
                );
                
                $result = $actions->update_setting( 'google', json_encode( $google_sheets ) );
        
                $scopes = array(
                    'https://www.googleapis.com/auth/userinfo.profile',
                    'https://www.googleapis.com/auth/userinfo.email',
                    'https://www.googleapis.com/auth/drive',
                    'https://www.googleapis.com/auth/drive.file',
                    'https://www.googleapis.com/auth/drive.readonly',
                    'https://www.googleapis.com/auth/spreadsheets',
                    'https://www.googleapis.com/auth/spreadsheets.readonly',
                );

                
                $glogin_url = 'https://accounts.google.com/o/oauth2/v2/auth?scope=' .
                    urlencode( implode( ' ', $scopes ) ) .
                    '&redirect_uri=' . urlencode( $gredirect_url ) . '&response_type=code&client_id=' . $gclient_id . '&access_type=offline&prompt=consent';
        
                wp_redirect( $glogin_url );
                exit();
            }
        
            $gerror_message = '';
            // Google passes a parameter 'code' in the Redirect Url
            if( $google_code && $google_scope ){
                try {
                    // Get the access token
                    $gtokens = $this->GetGoogleUserToken_RefreshToken( $google_client, $google_redirect_url, $google_secret, $_GET['code'] );
        
                    // Access Token
                    $gaccess_token = $gtokens['access_token'];
        
                    // Get user information
                    $google_user_info = $this->GetGoogleUserProfileInfo( $gaccess_token );
        
                    $google_sheets = array(
                        'client'        => $google_client,
                        'secret'        => $google_secret,
                        'redirect_uri'  => $google_redirect_uri,
                        'token'         => $gaccess_token,
                        'refresh_token' => $gtokens['refresh_token'],
                        'user_email'    => $google_user_info['email'],
                        'user_name'     => $google_user_info['name'],
                        'user_picture'  => $google_user_info['picture'],
                        'user_gid'      => $google_user_info['id']
                    );
        
                    $result = $actions->update_setting( 'google', json_encode( $google_sheets ) );
                    $url = menu_page_url( $this->plugin_name . "-settings", false );
                    
                    $url = add_query_arg( array(
                        'ays_tab' => 'tab2',
                        'status' => 'gconnected'
                    ), $url );
                    
                    wp_redirect( $url );
                    exit();
                }catch(Exception $e) {
                    $gerror_message = $e->getMessage();
                }
            }
        
            $google_res     = ($actions->get_setting('google') === false) ? json_encode(array()) : $actions->get_setting('google');
            $google_sheets  = json_decode($google_res, true);
            $google_email   = isset($google_sheets['user_email']) ? $google_sheets['user_email'] : '';
            $google_name    = isset($google_sheets['user_name']) ? $google_sheets['user_name'] : '';
            $google_picture = isset($google_sheets['user_picture']) ? $google_sheets['user_picture'] : '';
            $google_token   = isset($google_sheets['token']) ? $google_sheets['token'] : '';

            $icon  = CHART_BUILDER_ADMIN_URL . '/images/integrations/google_logo.png';
            $title = __( 'Google', $this->plugin_name );
            $not_connected = sprintf(__( "You are connected to Google with %s (%s) account.", $this->plugin_name ),"<strong><em>" . $google_name . "</em></strong>","<a href='mailto:" . $google_email . "'><strong><em>" . $google_email . "</em></strong></a>");
            $content = "";

            if( $google_token ){
                $content .= '<div class="form-group row">
                                <div class="col-sm-12">
                                    <blockquote>
                                        <span style="margin:0;font-weight:normal;font-style:normal;">'.$not_connected.'</span>
                                    </blockquote>
                                    <br>
                                    <input type="submit" class="btn btn-outline-danger" name="ays_disconnect_google" value="'.__( 'Disconnect', $this->plugin_name ).'">
                                    <div>
                                        <a href="https://www.youtube.com/watch?v=Qox2ev6OgUM&" target="_blank" style="font-size: 13px; margin-top: 7px;">
                                            '. __("How to Connect Charts with Google Spreadsheets", $this->plugin_name) .'
                                        </a>
                                    </div>
                                </div>
                            </div>';
            } else {
                $content .= '<div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <button id="googleInstructionsPopOver" type="button" class="btn btn-info" data-original-title="Google Integration Setup Instructions" >'. __("Instructions", $this->plugin_name). '</button>
                                            <div class="d-none" id="googleInstructions">
                                                <p>1. '. __("Turn on Your Google Sheets API and Google Drive API", $this->plugin_name) .'
                                                    <a href="https://console.developers.google.com" target="_blank">https://console.developers.google.com</a>
                                                </p>
                                                <p>2. '. __("Go to ", $this->plugin_name) .'<a href="https://console.developers.google.com/apis/credentials" target="_blank">'. __("Credentials", $this->plugin_name) .'</a>'. __(" , tap '+ CREATE CREDENTIALS', choose 'OAuth Client ID', and create
                                                new <b>Google OAuth Client ID</b> credentials (if you don't have)", $this->plugin_name).'</p>
                                                <p>3. '. __("Choose the application type as <b>Web application</b>", $this->plugin_name) .'</p>
                                                <p>4. '. __("Add the following link in the <b>Authorized redirect URIs</b> field", $this->plugin_name) .'</p>
                                                <p>
                                                    <code>'. $google_redirect_url .'</code>
                                                </p>
                                                <p>5. '. __("Click on the <b>Create</b> button", $this->plugin_name) .'</p>
                                                <p>6. '. __("Copy the <b>Your Client ID</b> and <b>Your Client Secret</b> from the opened popup and paste them in the corresponding fields.", $this->plugin_name) .'</p>
                                                <p>7. '. __("Click on the <b>Connect</b> button to complete authorization (Make sure to check all checkboxes in opened additional access dialog box)", $this->plugin_name) .'</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_google_client">
                                                '. __("Google Client ID", $this->plugin_name) .'
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_google_client" name="ays_google_client" value="'. $google_client.'">
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_google_secret">
                                                '. __("Google Client Secret", $this->plugin_name) .'
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_google_secret" name="ays_google_secret" value="">
                                            <input type="hidden" id="ays_google_redirect" name="ays_google_redirect" value="'.$google_redirect_url.'">
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row">
                                        <div class="col-sm-3"></div>
                                        <div class="col-sm-9">
                                            <button type="submit" name="ays_googleOAuth2" id="ays_googleOAuth2" class="btn btn-outline-info">
                                                '. __("Connect", $this->plugin_name) .'
                                            </button>
                                            <div>
                                                <a href="https://www.youtube.com/watch?v=Qox2ev6OgUM&" target="_blank" style="font-size: 13px; margin-top: 7px;">
                                                    '. __("How to Connect Charts with Google Spreadsheets", $this->plugin_name) .'
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>';
            }
            $integrations['google'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title
            );
            return $integrations;        
        }
        
    // =====  Google sheet end   =====

    // ===== Database starts =====

        // Database integration / settings page
        public function ays_settings_page_database_content($integrations, $args) {
            $actions = $this->settings_obj;

            // Database settings
            $databaseb_res = ($actions->get_setting('database') === false) ? json_encode(array()) : $actions->get_setting('database');
            $db_settings = json_decode($databaseb_res, true);
            $db_host = isset($db_settings['host']) ? $db_settings['host'] : '';
            $db_name = isset($db_settings['db_name']) ? $db_settings['db_name'] : '';
            $db_user = isset($db_settings['user']) ? $db_settings['user'] : '';
            $db_password = isset($db_settings['password']) ? openssl_decrypt(base64_decode($db_settings['password']), 'aes-256-cbc', SECURE_AUTH_KEY, 0, substr(md5(SECURE_AUTH_KEY), 0, 16)) : '';
            $db_port = isset($db_settings['port']) ? $db_settings['port'] : '3306';

            $nonce = wp_create_nonce('ays_test_database_nonce');

            // Create the form content for database settings
            $content = '
                        <div class="form-group row" aria-describedby="aaa">
                            <div class="col-sm-3">
                                <button id="dbInstructionsPopOver" type="button" class="btn btn-info" data-original-title="Database Integration Setup Instructions" >' . __("Instructions", $this->plugin_name) . '</button>
                                <div class="d-none" id="dbInstructions">
                                    <p><strong>' . __("IP Access:", $this->plugin_name) . '</strong></p>
                                    <p>'. __("In some cases, your database may block connections from unknown IP addresses. You might need to whitelist your IP in the database settings to allow access.", $this->plugin_name) .'</p>
                                    <p><strong>' . __("Database Host:", $this->plugin_name) . '</strong> ' . __("Enter the address of your database (e.g., 'localhost', or a host like 'db.example.com').", $this->plugin_name) . '</p>
                                    <p><strong>' . __("Database Name:", $this->plugin_name) . '</strong> ' . __("Enter the name of the database you want to connect to.", $this->plugin_name) . '</p>
                                    <p><strong>' . __("Database User:", $this->plugin_name) . '</strong> ' . __("Enter the username for accessing the database.", $this->plugin_name) . '</p>
                                    <p><strong>' . __("Database Password:", $this->plugin_name) . '</strong> ' . __("Enter the password for your database user. Make sure this is correct.", $this->plugin_name) . '</p>
                                    <p><strong>' . __("Database Port (Optional):", $this->plugin_name) . '</strong> ' . __("The default MySQL port is '3306'. You can leave this field empty. If your host doesn't specify a port, we'll use the default value.", $this->plugin_name) . '</p>
                                    <p><strong>' . __("Test Connection:", $this->plugin_name) . '</strong> ' . __("Click on the 'Test Connection' button to verify that the connection is successful.", $this->plugin_name) . '</p>
                                    <p><strong>' . __("If the test fails:", $this->plugin_name) . '</strong> ' . __("Please recheck your details or verify if your IP address is whitelisted.", $this->plugin_name) . '</p>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_database_host">'. __("Database Host", $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_database_host" name="ays_database_host" value="'. esc_attr($db_host) .'">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_database_name">'. __("Database Name", $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_database_name" name="ays_database_name" value="'. esc_attr($db_name) .'">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_database_user">'. __("Database User", $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_database_user" name="ays_database_user" value="'. esc_attr($db_user) .'">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_database_password">'. __("Database Password", $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="password" class="ays-text-input" id="ays_database_password" name="ays_database_password" value="'. esc_attr($db_password) .'">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_database_port">'. __("Database Port (optional)", $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_database_port" name="ays_database_port" value="'. esc_attr($db_port) .'" placeholder="3306">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-9">
                                <button id="ays_database_test_connection" class="btn btn-outline-info">
                                    '. __("Test Connection", $this->plugin_name) .'
                                </button>
                                <span class="ays_cb_loader display_none_not_important"><img src=' . CHART_BUILDER_ADMIN_URL . '/images/loaders/loading.gif></span>
                                <input type="hidden" id="ays_database_nonce" value="'. esc_attr($nonce) .'">
                            </div>
                        </div>';

            $icon  = CHART_BUILDER_ADMIN_URL . '/images/integrations/database_logo.png';
            $title = __( 'Database', $this->plugin_name );
            $integrations['database'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title
            );

            return $integrations;
        }

        public function ays_settings_page_database_save($fields) {
            $db_host = isset($_REQUEST['ays_database_host']) ? sanitize_text_field($_REQUEST['ays_database_host']) : '';
            $db_name = isset($_REQUEST['ays_database_name']) ? sanitize_text_field($_REQUEST['ays_database_name']) : '';
            $db_user = isset($_REQUEST['ays_database_user']) ? sanitize_text_field($_REQUEST['ays_database_user']) : '';
            $db_password = isset($_REQUEST['ays_database_password']) ? sanitize_text_field($_REQUEST['ays_database_password']) : '';
            $db_port = isset($_REQUEST['ays_database_port']) ? sanitize_text_field($_REQUEST['ays_database_port']) : '3306';

            if (!empty($db_password)) {
                $db_password = base64_encode(openssl_encrypt($db_password, 'aes-256-cbc', SECURE_AUTH_KEY, 0, substr(md5(SECURE_AUTH_KEY), 0, 16)));
            }

            $database_options = array(
                'host' => $db_host,
                'db_name' => $db_name,
                'user' => $db_user,
                'password' => $db_password,
                'port' => $db_port,
            );

            $fields['database'] = $database_options;

            return $fields;
        }
    // ===== Database end =====
    
    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////
    

    // ===== Integration calls for admin dashboard start =====

  
    // ===== Integration calls for admin dashboard end =====

    
    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    
    // ===== Front end calls start =====
    

    // ===== Front end calls end =====

    
    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    
    // ==== Google Sheet integration API Calls start ====

        // Google sheet == Get spreadsheet files ==
        public function ays_chart_get_google_spreadsheets( $data ) {
            error_reporting(0);
            if ( empty( $data ) ) {
                return array(
                    'Code' => 0
                );
            }

            $new_token = '';
            $refresh_token = isset( $data['refresh_token'] ) && $data['refresh_token'] != '' ? $data['refresh_token'] : '';

            if( $refresh_token != '' ){
                $new_token = self::ays_chart_get_refreshed_token( $data );
            }

            $url = "https://www.googleapis.com/drive/v3/files?q=mimeType='application/vnd.google-apps.spreadsheet' and '". $data['user_email'] ."' in owners+and+trashed=false&corpora=user";

            // ===== API CALL =====
            $data = array(
                'sslverify' => false,
                "headers" => array(
                    "Authorization"  => "Bearer $new_token",
                    "Content-Type"  => "application/json; charset=utf-8",
                    "cache-control" => "no-cache"
                )
            );

            $response = wp_remote_get($url, $data);
            
            if ( is_wp_error( $response ) ) {
	            return $response->get_error_message();
            }
            
            $body = wp_remote_retrieve_body( $response );

            if( empty( $body )){
                return false;
            }else{
                $body = json_decode( $body,true );
            }
            return $body;
        }

        // Google sheet == Get spreadsheet data == data in dashboard
        public function ays_chart_get_google_spreadsheet_data( $data ) {
            error_reporting(0);
            if ( empty( $data ) ) {
                return false;
            }
            $new_token = '';
            $refresh_token = isset($data['refresh_token']) && $data['refresh_token'] != '' ? $data['refresh_token'] : '';
            $spreadsheet_id = isset($data['spreadsheet_id']) && $data['spreadsheet_id'] != '' ? $data['spreadsheet_id'] : '';

            if( $spreadsheet_id == '' ){
                return false;
            }

            if($refresh_token != ''){
                $new_token = $this->ays_chart_get_refreshed_token($data);
            }

            $url = "https://sheets.googleapis.com/v4/spreadsheets/" . $spreadsheet_id . "/values:batchGet";
	        $url .= '?' . http_build_query( array(
                'majorDimension' => 'ROWS',
                'ranges' => 'A:AAA',
                'valueRenderOption' => 'UNFORMATTED_VALUE',
            ) );

            // ==== API CALL ====
            $data = array(
                'sslverify' => false,
                "headers" => array(
                    "Content-Type"  => "application/json; charset=utf-8",
                    "cache-control" => "no-cache",
                    "Authorization" => "Bearer ".$new_token
                )
            );

            $response = wp_remote_get( $url, $data );
            
            if ( is_wp_error( $response ) ) {
	            return $response->get_error_message();
            }
            
            $body = wp_remote_retrieve_body( $response );
            if( empty( $body )){
                return false;
            }

            $body = json_decode( $body,true );

            return $body;
        }

        // Google sheet == Get == refreshed token
        public function ays_chart_get_refreshed_token( $data ){
            if (empty($data)) {
                return array(
                    'Code' => 0
                );
            }
            $token = isset($data['refresh_token']) && $data['refresh_token'] != '' ? $data['refresh_token'] : '';
            $client_id = isset($data['client_id']) && $data['client_id'] != '' ? $data['client_id'] : '';
            $client_secret = isset($data['client_secret']) && $data['client_secret'] != '' ? $data['client_secret'] : '';
            // ==== API CALL ====
            $url = "https://accounts.google.com/o/oauth2/token?grant_type=refresh_token&refresh_token=".$token."&client_id=".$client_id."&client_secret=".$client_secret."";

	        $scopes = array(
		        'https://www.googleapis.com/auth/drive',
		        'https://www.googleapis.com/auth/drive.file',
		        'https://www.googleapis.com/auth/drive.readonly',
		        'https://www.googleapis.com/auth/spreadsheets',
		        'https://www.googleapis.com/auth/spreadsheets.readonly',
	        );
            $url .= "&scope=" . urlencode( implode(' ', $scopes) ) . '&access_type=offline&prompt=consent';

            $response = wp_remote_post( $url );
            
            if ( is_wp_error( $response ) ) {
	            return $response->get_error_message();
            }
            
            $body = wp_remote_retrieve_body( $response );

            if( empty( $body )){
                return false;
            }else{
                $body = json_decode( $body,true );
                return isset($body['access_token']) ? $body['access_token'] : '';
            }
        }

        // Googel sheet RefreshToken
        public function GetGoogleUserToken_RefreshToken( $client_id, $redirect_uri, $client_secret, $code ){
            // $url = 'https://www.googleapis.com/oauth2/v4/token';
            $url = 'https://accounts.google.com/o/oauth2/token';

            $curl = curl_init();
            $curlPost = array(
                'grant_type' => 'authorization_code',
                'client_id' => $client_id,
                'code' => $code,
                'client_secret' => $client_secret,
                'redirect_uri' => $redirect_uri,
                'scope' => 'https://www.googleapis.com/auth/spreadsheets'
            );

            $curlPost = http_build_query( $curlPost );

            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $curlPost,
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/x-www-form-urlencoded"
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
            $new_response = json_decode($response, true);
            $http_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

            curl_close($curl);

            if($http_code != 200){
                throw new Exception( __( 'Error: Failed to get token', CHART_BUILDER_NAME ) );
            }

            return $new_response;
        }
        
        // Googel sheet == GET == User info
        public function GetGoogleUserProfileInfo( $access_token ){
            $url = 'https://www.googleapis.com/oauth2/v2/userinfo?fields=name,email,gender,id,picture';

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_POSTFIELDS => NULL,
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer ". $access_token,
                    "response_type: webapplications",
                    "Content-Type: application/json"
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
            $new_response = json_decode($response, true);
            $http_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

            curl_close($curl);

            if($http_code != 200){
                throw new Exception( __( 'Error: Failed to get user information', CHART_BUILDER_NAME ) );
            }

            return $new_response;
        }

    // ==== Google Sheet integration API Calls end ====
    
    // Google Sheet delete data from DB
    public function delete_sheet_ids(){
        global $wpdb;

        $table = $wpdb->prefix . CHART_BUILDER_DB_PREFIX . "charts";
        $sql = "SELECT id, source, source_type FROM {$table} WHERE source_type = 'google_sheet'";
        $results = $wpdb->get_results( $sql, "ARRAY_A" );

        foreach( $results as $key => $result ){
            $id = absint( $result['id'] );

	        $gsheet_data_option_name = 'ays_chart_google_sheet_results_' . $id;
	        $gsheet_data = get_option( $gsheet_data_option_name, array() );
            $values = $gsheet_data['data']['valueRanges'];
	        $values = isset( $values[0]['values'] ) && !empty( $values[0]['values'] ) ? $values[0]['values'] : array();

            if( ! empty( $values ) ){
                unset( $values[0] );
            }

	        $source = json_encode( $values );

            $wpdb->update(
	            $table,
                array(
                    'source'        => $source,
                    'source_type'   => 'manual',
                ),
                array( 'id' => $id ),
                array( '%s', '%s' ),
                array( '%d' )
            );

            delete_option( $gsheet_data_option_name );
        }

        return true;
    }

    // ===== Integration calls end =====

}
