<?php
namespace Amazon\Affiliate\Admin;

/**
 * Dashboard handler class
 *
 * @package Amazon\Affiliate\Admin
 */

use Amazon\Affiliate\Api\Amazon_Product_Api;

if (!function_exists('get_amazon_api_usage')) {
    function get_amazon_api_usage() {
        return Amazon_Product_Api::get_api_usage();
    }
}

class Dashboard {

/**
 * Dashboard page load
 */
public function dashboard_page() {
        // Include the Amazon_Product_Api class file
        $plugin_root = plugin_dir_path(dirname(dirname(__FILE__)));
        $api_file = $plugin_root . 'includes/Api/Amazon_Product_Api.php';
        if (file_exists($api_file)) {
            require_once $api_file;
        } else {
            error_log('Amazon_Product_Api.php file not found at: ' . $api_file);
        }

        // Original functionality
        $products_info = ams_get_all_products_info();

        // Get API usage data
        $amazon_api_usage = \Amazon\Affiliate\Api\Amazon_Product_Api::get_api_usage();

        // Include the template and pass variables
        $template = __DIR__ . '/views/dashboard.php';
        if (file_exists($template)) {
            include $template;
        } else {
            error_log('Dashboard template file not found at: ' . $template);
        }
    }
/**
 * In This function who is sending the dashboard information
 */

public function dashboard_info() {
    header('Content-Type: application/json');

    // First check if license is active
    $license_active = get_option('ams_activated_license');
    if (!$license_active) {
        wp_send_json(array(
            'status' => 'inactive',
            'message' => 'License is not active'
        ));
        return;
    }

    // Check for nonce existence
    if (!isset($_POST['nonce_ams_dashboard_info'])) {
        wp_send_json(array(
            'status' => 'error',
            'message' => 'Nonce not provided'
        ));
    }

    // Verify nonce
    if (!wp_verify_nonce($_POST['nonce_ams_dashboard_info'], 'ams_dashboard_info')) {
        wp_send_json(array(
            'status' => 'error',
            'message' => 'Invalid nonce'
        ));
    }

    $products_info = ams_get_all_products_info();
    
    wp_send_json(array(
        'status' => 'success',
        'products_count' => $products_info['products_count'],
        'total_view_count' => $products_info['total_view_count'],
        'total_product_added_to_cart' => $products_info['total_product_added_to_cart'],
        'total_product_direct_redirected' => $products_info['total_product_direct_redirected'],
        'products_search_count' => $products_info['products_search_count']
    ));
}
}