<?php include "common-header.php"; ?>

<!-- Ensure Bootstrap Icons CSS is loaded with absolute URLs -->
<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL; ?>assets/vendor/bootstrap-icons/bootstrap-icons.css">

<!-- Force load icons with inline styles as backup -->
<style>
/* Bootstrap Icons Backup - Force load with absolute paths */
@font-face {
  font-display: block;
  font-family: "bootstrap-icons";
  src: url("<?php echo AMS_PLUGIN_URL; ?>assets/vendor/bootstrap-icons/fonts/bootstrap-icons.woff2") format("woff2"),
       url("<?php echo AMS_PLUGIN_URL; ?>assets/vendor/bootstrap-icons/fonts/bootstrap-icons.woff") format("woff");
}

/* Force icon display */
.bi::before,
[class^="bi-"]::before,
[class*=" bi-"]::before {
  display: inline-block !important;
  font-family: "bootstrap-icons" !important;
  font-style: normal !important;
  font-weight: normal !important;
  vertical-align: top !important;
  line-height: 1 !important;
  -webkit-font-smoothing: antialiased !important;
  -moz-osx-font-smoothing: grayscale !important;
}

/* Fallback: Use text content if font fails */
.bi-flask::before { content: "🧪"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-play-fill::before { content: "▶️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-gear::before { content: "⚙️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-trash::before { content: "🗑️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-plus-circle::before { content: "➕"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-journal-text::before { content: "📄"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-arrow-repeat::before { content: "🔄"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-check-circle::before { content: "✅"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-x-circle::before { content: "❌"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-arrow-clockwise::before { content: "🔄"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-box-seam::before { content: "📦"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-chat-square-text::before { content: "💬"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-pause-circle::before { content: "⏸️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-clock::before { content: "🕐"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-list-ul::before { content: "📋"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-robot::before { content: "🤖"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-exclamation-triangle-fill::before { content: "⚠️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-terminal::before { content: "💻"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-download::before { content: "⬇️"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-clipboard::before { content: "📋"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
.bi-check::before { content: "✓"; font-family: "Segoe UI Emoji", "Apple Color Emoji", "Noto Color Emoji", sans-serif !important; }
</style>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Page Header -->
            <div class="mb-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <h2 class="mb-1 fw-bold text-dark">
                            <i class="bi bi-robot me-2 text-primary"></i>
                            <?php esc_html_e('Automation Center', 'ams-wc-amazon'); ?>
                        </h2>
                        <p class="text-muted mb-0"><?php esc_html_e('Manage your automated processes', 'ams-wc-amazon'); ?></p>
                    </div>
                    <div class="text-end">
                        <div class="badge bg-light text-dark fs-6 px-3 py-2">
                            <i class="bi bi-clock me-1"></i>
                            <span id="serverTime"><?php echo current_time('g:i A'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Server Setup Notice -->
            <div class="alert alert-warning border-0 mb-4">
                <div class="d-flex align-items-center">
                    <i class="bi bi-exclamation-triangle-fill me-3 fs-5"></i>
                    <div class="flex-grow-1">
                        <h6 class="mb-1 fw-semibold"><?php esc_html_e('Server Cron Setup Required', 'ams-wc-amazon'); ?></h6>
                        <p class="mb-0 small"><?php esc_html_e('For reliable automation, configure server cron or install WP Crontrol plugin.', 'ams-wc-amazon'); ?></p>
                    </div>
                    <div class="d-flex gap-2">
                        <button class="btn btn-sm btn-outline-warning" data-bs-toggle="collapse" data-bs-target="#cronSetup">
                            <i class="bi bi-terminal me-1"></i><?php esc_html_e('Setup', 'ams-wc-amazon'); ?>
                        </button>
                        <a href="https://wordpress.org/plugins/wp-crontrol/" target="_blank" class="btn btn-sm btn-warning">
                            <i class="bi bi-download me-1"></i><?php esc_html_e('Plugin', 'ams-wc-amazon'); ?>
                        </a>
                    </div>
                </div>
                <div class="collapse mt-3" id="cronSetup">
                    <div class="bg-dark rounded p-3">
                        <p class="text-light mb-2 small"><?php esc_html_e('Add this command to your server cron (runs every minute):', 'ams-wc-amazon'); ?></p>
                        <div class="input-group">
                            <input type="text" class="form-control font-monospace bg-secondary text-light border-0" 
                                   id="cronCmd" 
                                   value="wget -q -O - <?php echo esc_url(get_bloginfo('wpurl')); ?>/wp-cron.php?doing_wp_cron >/dev/null 2>&1" 
                                   readonly>
                            <button class="btn btn-primary" type="button" 
                                    onclick="navigator.clipboard.writeText(document.getElementById('cronCmd').value); this.innerHTML='<i class=\'bi bi-check\'></i> Copied!'; setTimeout(() => this.innerHTML='<i class=\'bi bi-clipboard\'></i> Copy', 2000);">
                                <i class="bi bi-clipboard"></i> <?php esc_html_e('Copy', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>



            <!-- Advanced Cron Management -->
            <div class="card shadow-sm border-0 ams-common-card-fix">
                <div class="card-header bg-info text-white">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-semibold">
                            <i class="bi bi-list-ul me-2"></i>
                            <?php esc_html_e('Advanced Cron Management', 'ams-wc-amazon'); ?>
                        </h5>
                        <div class="d-flex gap-1 align-items-center">
                            <button class="btn btn-sm btn-outline-light" id="refreshCronList">
                                <?php esc_html_e('Refresh', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th><?php esc_html_e('Process Name', 'ams-wc-amazon'); ?></th>
                                    <th><?php esc_html_e('Status', 'ams-wc-amazon'); ?></th>
                                    <th><?php esc_html_e('Next Run', 'ams-wc-amazon'); ?></th>
                                    <th><?php esc_html_e('Frequency', 'ams-wc-amazon'); ?></th>
                                    <th><?php esc_html_e('Enable/Disable', 'ams-wc-amazon'); ?></th>
                                    <th><?php esc_html_e('Actions', 'ams-wc-amazon'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Get all AMS cron events
                                $ams_crons = array(
                                    'ams_product_availability' => array(
                                        'name' => 'Product Availability',
                                        'description' => 'Monitor product availability and update prices automatically',
                                        'option_key' => 'enable_product_cron',
                                        'action' => 'ams_product_availability_toggle',
                                        'icon' => 'bi-box-seam text-primary'
                                    ),
                                    'ams_review_automation_event' => array(
                                        'name' => 'Review Import',
                                        'description' => 'Import Amazon customer reviews for your products',
                                        'option_key' => 'enable_review_cron',
                                        'action' => 'ams_review_automation',
                                        'icon' => 'bi-chat-square-text text-success'
                                    )
                                );
                                
                                foreach ($ams_crons as $hook => $config):
                                    $next_run = wp_next_scheduled($hook);
                                    $schedules = wp_get_schedules();
                                    $is_enabled = get_option($config['option_key'], '1') === '1';
                                    
                                    // Get recurrence info
                                    $recurrence = 'Not Scheduled';
                                    if ($next_run) {
                                        $crons = _get_cron_array();
                                        foreach ($crons as $timestamp => $cron) {
                                            if (isset($cron[$hook])) {
                                                $schedule_key = array_keys($cron[$hook])[0];
                                                $schedule_info = $cron[$hook][$schedule_key];
                                                if (isset($schedule_info['schedule'])) {
                                                    $recurrence = $schedules[$schedule_info['schedule']]['display'] ?? $schedule_info['schedule'];
                                                }
                                                break;
                                            }
                                        }
                                    }
                                ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="bi <?php echo $config['icon']; ?> me-2 fs-5"></i>
                                            <div>
                                                <strong><?php echo esc_html($config['name']); ?></strong>
                                                <br><small class="text-muted"><?php echo esc_html($config['description']); ?></small>
                                                <br><small class="text-muted font-monospace"><?php echo esc_html($hook); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo $next_run ? 'bg-success' : 'bg-secondary'; ?> fs-6 px-3 py-2">
                                            <i class="bi <?php echo $next_run ? 'bi-check-circle' : 'bi-pause-circle'; ?> me-2"></i>
                                            <?php echo $next_run ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($next_run): ?>
                                            <span class="text-success fw-semibold">
                                                <?php echo wp_date('M j, g:i A', $next_run); ?>
                                            </span>
                                            <br><small class="text-muted">
                                                <?php echo human_time_diff(time(), $next_run); ?> 
                                                <?php echo $next_run > time() ? esc_html__('from now', 'ams-wc-amazon') : esc_html__('ago', 'ams-wc-amazon'); ?>
                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted"><?php esc_html_e('Not Scheduled', 'ams-wc-amazon'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo esc_html($recurrence); ?></span>
                                    </td>
                                    <td>
                                        <form method="post" action="admin.php?page=automation" class="d-inline toggle-form" data-hook="<?php echo esc_attr($hook); ?>">
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="<?php echo esc_attr($config['option_key']); ?>" value="1" <?php checked($is_enabled, true); ?> class="toggle-checkbox" data-hook="<?php echo esc_attr($hook); ?>" data-name="<?php echo esc_attr($config['name']); ?>">
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                            <button type="submit" class="btn btn-sm btn-outline-primary ms-2 save-toggle-btn" style="display: none;">
                                                <i class="bi bi-check-circle"></i>
                                            </button>
                                            <span class="toggle-status ms-2" style="display: none;">
                                                <i class="bi bi-arrow-repeat spin text-primary"></i>
                                            </span>
                                            <input type="hidden" name="action" value="<?php echo esc_attr($config['action']); ?>">
                                            <?php wp_nonce_field("automation_setting_nonce", "automation_nonce") ?>
                                        </form>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <!-- Test & Run Group -->
                                            <div class="btn-group" role="group">
                                                <?php if ($hook === 'ams_review_automation_event'): ?>
                                                    <button class="btn btn-sm btn-outline-info test-automation-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Test with 3 products only - Safe for testing', 'ams-wc-amazon'); ?>">
                                                        <?php esc_html_e('Test', 'ams-wc-amazon'); ?>
                                                    </button>
                                                <?php elseif ($hook === 'ams_product_availability'): ?>
                                                    <button class="btn btn-sm btn-outline-info test-product-availability-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Test availability check with 3 products only - Safe for testing', 'ams-wc-amazon'); ?>">
                                                        <?php esc_html_e('Test', 'ams-wc-amazon'); ?>
                                                    </button>
                                                <?php endif; ?>
                                                
                                                <?php if ($next_run): ?>
                                                    <button class="btn btn-sm btn-outline-warning cron-run-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Run NOW for ALL products - This processes your entire catalog!', 'ams-wc-amazon'); ?>">
                                                        <?php esc_html_e('Run All', 'ams-wc-amazon'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Management Group -->
                                            <div class="btn-group" role="group">
                                                <?php if ($next_run): ?>
                                                    <button class="btn btn-sm btn-outline-primary cron-edit-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Edit Schedule - Change frequency and timing', 'ams-wc-amazon'); ?>"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#cronEditModal">
                                                        <?php esc_html_e('Edit', 'ams-wc-amazon'); ?>
                                                    </button>
                                                    <button class="btn btn-sm btn-outline-danger cron-delete-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Unschedule - Stop automatic execution', 'ams-wc-amazon'); ?>">
                                                        <?php esc_html_e('Delete', 'ams-wc-amazon'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline-success cron-schedule-btn" 
                                                            data-hook="<?php echo esc_attr($hook); ?>" 
                                                            data-name="<?php echo esc_attr($config['name']); ?>"
                                                            title="<?php esc_attr_e('Schedule - Set up automatic execution', 'ams-wc-amazon'); ?>"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#cronEditModal">
                                                        <?php esc_html_e('Schedule', 'ams-wc-amazon'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Logs Group (Review Import only) -->
                                            <?php if ($hook === 'ams_review_automation_event'): ?>
                                                <a href="admin.php?page=automation-logs" target="_blank" 
                                                   class="btn btn-sm btn-outline-secondary"
                                                   title="<?php esc_attr_e('View Logs - Check execution history and errors', 'ams-wc-amazon'); ?>">
                                                    <?php esc_html_e('Logs', 'ams-wc-amazon'); ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cron Schedule Edit Modal -->
<div class="modal fade" id="cronEditModal" tabindex="-1" aria-labelledby="cronEditModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cronEditModalLabel">
                    <i class="bi bi-gear me-2"></i>
                    <span id="modalTitle"><?php esc_html_e('Edit Cron Schedule', 'ams-wc-amazon'); ?></span>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="cronScheduleForm">
                    <input type="hidden" id="cronHook" name="hook">
                    
                    <!-- Frequency Selection -->
                    <div class="mb-3">
                        <label for="cronFrequency" class="form-label"><?php esc_html_e('Frequency', 'ams-wc-amazon'); ?></label>
                        <select class="form-select" id="cronFrequency" name="frequency">
                            <option value="hourly"><?php esc_html_e('Every Hour', 'ams-wc-amazon'); ?></option>
                            <option value="twicedaily"><?php esc_html_e('Twice Daily', 'ams-wc-amazon'); ?></option>
                            <option value="daily" selected><?php esc_html_e('Daily', 'ams-wc-amazon'); ?></option>
                            <option value="weekly"><?php esc_html_e('Weekly', 'ams-wc-amazon'); ?></option>
                        </select>
                    </div>
                    
                    <!-- Start Time -->
                    <div class="mb-3" id="timeSection">
                        <label for="cronTime" class="form-label"><?php esc_html_e('Start Time', 'ams-wc-amazon'); ?></label>
                        <input type="time" class="form-control" id="cronTime" name="time" value="03:00">
                        <div class="form-text">
                            <?php esc_html_e('Server timezone:', 'ams-wc-amazon'); ?> 
                            <strong><?php echo wp_timezone_string(); ?></strong>
                        </div>
                    </div>
                    
                    <!-- Next Run Preview -->
                    <div class="mb-3">
                        <label class="form-label"><?php esc_html_e('Next Run Preview', 'ams-wc-amazon'); ?></label>
                        <div class="alert alert-info" id="nextRunPreview">
                            <i class="bi bi-clock me-2"></i>
                            <span id="previewText"><?php esc_html_e('Select frequency to see next run time', 'ams-wc-amazon'); ?></span>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <?php esc_html_e('Cancel', 'ams-wc-amazon'); ?>
                </button>
                <button type="button" class="btn btn-primary" id="saveCronSchedule">
                    <i class="bi bi-check-circle me-2"></i>
                    <?php esc_html_e('Save Schedule', 'ams-wc-amazon'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update server time
    function updateTime() {
        const now = new Date();
        const timeStr = now.toLocaleTimeString('en-US', { hour: 'numeric', minute: '2-digit', hour12: true });
        const timeEl = document.getElementById('serverTime');
        if (timeEl) timeEl.textContent = timeStr;
    }
    updateTime();
    setInterval(updateTime, 60000); // Update every minute
    
    // Handle toggle changes
    document.querySelectorAll('.toggle-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const form = this.closest('.toggle-form');
            const saveBtn = form.querySelector('.save-toggle-btn');
            const statusSpan = form.querySelector('.toggle-status');
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            
            // Show loading state
            statusSpan.style.display = 'inline';
            statusSpan.innerHTML = '<i class="bi bi-arrow-repeat spin text-primary"></i>';
            
            // Auto-submit the form
            const formData = new FormData(form);
            
            fetch('admin.php?page=automation', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (response.ok) {
                    // Show success state
                    statusSpan.innerHTML = '<i class="bi bi-check-circle text-success"></i>';
                    showToast(`${name} ${this.checked ? 'enabled' : 'disabled'} successfully!`, 'success');
                    
                    // Hide status after 2 seconds and refresh to update the page
                    setTimeout(() => {
                        statusSpan.style.display = 'none';
                        location.reload(); // Refresh to update cron status
                    }, 1500);
                } else {
                    throw new Error('Network response was not ok');
                }
            })
            .catch(error => {
                // Show error state and revert toggle
                statusSpan.innerHTML = '<i class="bi bi-x-circle text-danger"></i>';
                this.checked = !this.checked; // Revert the toggle
                showToast(`Failed to ${this.checked ? 'enable' : 'disable'} ${name}`, 'error');
                
                setTimeout(() => {
                    statusSpan.style.display = 'none';
                }, 2000);
            });
        });
    });
    
    // Test automation functionality
    document.querySelectorAll('.test-automation-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            const originalHtml = this.innerHTML;
            
            this.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i>Testing...';
            this.disabled = true;
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'ams_test_review_automation',
                    nonce: '<?php echo wp_create_nonce("ams_automation_nonce"); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    this.innerHTML = '<i class="bi bi-check-circle me-1"></i>Done!';
                    this.className = 'btn btn-sm btn-success';
                    showToast(`${name} test completed successfully! Check logs for details.`, 'success');
                } else {
                    this.innerHTML = '<i class="bi bi-x-circle me-1"></i>Failed';
                    this.className = 'btn btn-sm btn-danger';
                    showToast(`${name} test failed: ${data.data?.message || 'Unknown error'}`, 'error');
                }
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-info test-automation-btn';
                    this.disabled = false;
                }, 3000);
            })
            .catch(error => {
                this.innerHTML = '<i class="bi bi-x-circle me-1"></i>Error';
                this.className = 'btn btn-sm btn-danger';
                showToast(`Network error: ${error.message}`, 'error');
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-info test-automation-btn';
                    this.disabled = false;
                }, 3000);
            });
        });
    });
    
    // Test product availability functionality
    document.querySelectorAll('.test-product-availability-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            const originalHtml = this.innerHTML;
            
            this.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i>Testing...';
            this.disabled = true;
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'ams_test_product_availability',
                    nonce: '<?php echo wp_create_nonce("ams_product_availability"); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    this.innerHTML = '<i class="bi bi-check-circle me-1"></i>Done!';
                    this.className = 'btn btn-sm btn-success';
                    showToast(`${name} test completed successfully! ${data.data?.message || ''}`, 'success');
                } else {
                    this.innerHTML = '<i class="bi bi-x-circle me-1"></i>Failed';
                    this.className = 'btn btn-sm btn-danger';
                    showToast(`${name} test failed: ${data.data?.message || 'Unknown error'}`, 'error');
                }
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-info test-product-availability-btn';
                    this.disabled = false;
                }, 3000);
            })
            .catch(error => {
                this.innerHTML = '<i class="bi bi-x-circle me-1"></i>Error';
                this.className = 'btn btn-sm btn-danger';
                showToast(`Network error: ${error.message}`, 'error');
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-info test-product-availability-btn';
                    this.disabled = false;
                }, 3000);
            });
        });
    });
    
    // Cron management functionality
    document.querySelectorAll('.cron-run-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            const originalHtml = this.innerHTML;
            
            // Show confirmation dialog for "Run All" operations
            if (!confirm(`⚠️ IMPORTANT: This will run ${name} for ALL products in your catalog!\n\nThis may take a significant amount of time and server resources.\n\nFor testing purposes, use the "Test" button instead (processes only 3 products).\n\nAre you sure you want to continue with the full run?`)) {
                return;
            }
            
            this.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i>Running...';
            this.disabled = true;
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'ams_run_cron_hook',
                    hook: hook,
                    nonce: '<?php echo wp_create_nonce("ams_cron_management"); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    this.innerHTML = '<i class="bi bi-check"></i>';
                    this.className = 'btn btn-sm btn-success';
                    showToast(`${name} executed successfully!`, 'success');
                } else {
                    this.innerHTML = '<i class="bi bi-x"></i>';
                    this.className = 'btn btn-sm btn-danger';
                    showToast(`Failed to execute ${name}: ${data.data?.message || 'Unknown error'}`, 'error');
                }
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-success cron-run-btn';
                    this.disabled = false;
                }, 2000);
            })
            .catch(error => {
                this.innerHTML = '<i class="bi bi-x"></i>';
                this.className = 'btn btn-sm btn-danger';
                showToast(`Network error: ${error.message}`, 'error');
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-success cron-run-btn';
                    this.disabled = false;
                }, 2000);
            });
        });
    });
    
    document.querySelectorAll('.cron-delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            
            if (!confirm(`Are you sure you want to unschedule "${name}"?\n\nThis will stop the cron from running automatically.`)) {
                return;
            }
            
            const originalHtml = this.innerHTML;
            this.innerHTML = '<i class="bi bi-arrow-repeat spin"></i>';
            this.disabled = true;
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'ams_delete_cron_hook',
                    hook: hook,
                    nonce: '<?php echo wp_create_nonce("ams_cron_management"); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showToast(`${name} unscheduled successfully!`, 'success');
                    location.reload(); // Refresh to update the table
                } else {
                    this.innerHTML = '<i class="bi bi-x"></i>';
                    this.className = 'btn btn-sm btn-danger';
                    showToast(`Failed to unschedule ${name}: ${data.data?.message || 'Unknown error'}`, 'error');
                    
                    setTimeout(() => {
                        this.innerHTML = originalHtml;
                        this.className = 'btn btn-sm btn-outline-danger cron-delete-btn';
                        this.disabled = false;
                    }, 2000);
                }
            })
            .catch(error => {
                this.innerHTML = '<i class="bi bi-x"></i>';
                this.className = 'btn btn-sm btn-danger';
                showToast(`Network error: ${error.message}`, 'error');
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.className = 'btn btn-sm btn-outline-danger cron-delete-btn';
                    this.disabled = false;
                }, 2000);
            });
        });
    });
    

    
    // Refresh cron list button
    document.getElementById('refreshCronList')?.addEventListener('click', function() {
        showToast('<?php esc_html_e("Refreshing page...", "ams-wc-amazon"); ?>', 'success');
        setTimeout(() => {
            location.reload();
        }, 500);
    });
    
    // Cron edit/schedule modal functionality
    document.querySelectorAll('.cron-edit-btn, .cron-schedule-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const hook = this.dataset.hook;
            const name = this.dataset.name;
            const isScheduled = this.classList.contains('cron-edit-btn');
            
            document.getElementById('cronHook').value = hook;
            document.getElementById('modalTitle').textContent = isScheduled ? 
                `Edit Schedule: ${name}` : `Schedule: ${name}`;
            
            // Update preview when frequency or time changes
            updateNextRunPreview();
        });
    });
    
    // Update next run preview
    function updateNextRunPreview() {
        const frequency = document.getElementById('cronFrequency').value;
        const time = document.getElementById('cronTime').value;
        const previewText = document.getElementById('previewText');
        
        let nextRun = new Date();
        
        switch(frequency) {
            case 'hourly':
                nextRun.setHours(nextRun.getHours() + 1);
                break;
            case 'twicedaily':
                nextRun.setHours(nextRun.getHours() + 12);
                break;
            case 'daily':
            case 'ams_every_day':
                const [hours, minutes] = time.split(':');
                nextRun.setHours(parseInt(hours), parseInt(minutes), 0, 0);
                if (nextRun <= new Date()) {
                    nextRun.setDate(nextRun.getDate() + 1);
                }
                break;
            case 'weekly':
                const [wHours, wMinutes] = time.split(':');
                nextRun.setHours(parseInt(wHours), parseInt(wMinutes), 0, 0);
                nextRun.setDate(nextRun.getDate() + (7 - nextRun.getDay()));
                break;
        }
        
        previewText.textContent = nextRun.toLocaleString('en-US', {
            weekday: 'long',
            year: 'numeric',
            month: 'long',
            day: 'numeric',
            hour: 'numeric',
            minute: '2-digit',
            hour12: true
        });
    }
    
    // Update preview when inputs change
    document.getElementById('cronFrequency')?.addEventListener('change', updateNextRunPreview);
    document.getElementById('cronTime')?.addEventListener('change', updateNextRunPreview);
    
    // Save cron schedule
    document.getElementById('saveCronSchedule')?.addEventListener('click', function() {
        const btn = this;
        const originalHtml = btn.innerHTML;
        const hook = document.getElementById('cronHook').value;
        const frequency = document.getElementById('cronFrequency').value;
        const time = document.getElementById('cronTime').value;
        
        btn.innerHTML = '<i class="bi bi-arrow-repeat spin me-2"></i><?php esc_html_e("Saving...", "ams-wc-amazon"); ?>';
        btn.disabled = true;
        
        fetch(ajaxurl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                action: 'ams_schedule_cron_hook',
                hook: hook,
                frequency: frequency,
                time: time,
                nonce: '<?php echo wp_create_nonce("ams_cron_management"); ?>'
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                btn.innerHTML = '<i class="bi bi-check-circle me-2"></i><?php esc_html_e("Saved!", "ams-wc-amazon"); ?>';
                btn.className = 'btn btn-sm btn-success';
                
                setTimeout(() => {
                    const modal = bootstrap.Modal.getInstance(document.getElementById('cronEditModal'));
                    modal.hide();
                    location.reload(); // Refresh to show updated schedule
                }, 1000);
            } else {
                btn.innerHTML = '<i class="bi bi-x-circle me-2"></i><?php esc_html_e("Failed", "ams-wc-amazon"); ?>';
                btn.className = 'btn btn-sm btn-danger';
                showToast(`Failed to save schedule: ${data.data?.message || 'Unknown error'}`, 'error');
                
                setTimeout(() => {
                    btn.innerHTML = originalHtml;
                    btn.className = 'btn btn-primary';
                    btn.disabled = false;
                }, 2000);
            }
        })
        .catch(error => {
            btn.innerHTML = '<i class="bi bi-x-circle me-2"></i><?php esc_html_e("Error", "ams-wc-amazon"); ?>';
            btn.className = 'btn btn-danger';
            showToast(`Network error: ${error.message}`, 'error');
            
            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.className = 'btn btn-primary';
                btn.disabled = false;
            }, 2000);
        });
    });
});
</script>

<?php include "common-footer.php"; ?>