<?php include "common-header.php"; ?>

<!-- Breadcrumbs -->
<nav aria-label="breadcrumb" class="mb-4">
    <div class="container-fluid">
        <ol class="breadcrumb mb-0 bg-light rounded p-3">
            <li class="breadcrumb-item">
                <a href="?page=wc-amazon-affiliate" class="text-decoration-none">
                    <i class="bi bi-house-door me-1"></i><?= esc_html__('Dashboard', 'ams-wc-amazon'); ?>
                </a>
            </li>
            <li class="breadcrumb-item">
                <i class="bi bi-gear me-1"></i><?= esc_html__('Settings', 'ams-wc-amazon'); ?>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <i class="bi bi-tags me-1"></i><?= esc_html__('Brand Settings', 'ams-wc-amazon'); ?>
            </li>
        </ol>
    </div>
</nav>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Main Brand Settings Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-tags text-primary me-2"></i>
                            <?= esc_html__('Brand Settings', 'ams-wc-amazon'); ?>
                        </h5>
                        <div class="d-flex gap-2">
                            <button class="btn btn-outline-secondary btn-sm" onclick="location.reload()">
                                <i class="bi bi-arrow-clockwise me-1"></i><?= esc_html__('Refresh', 'ams-wc-amazon'); ?>
                            </button>
                                            <button class="btn btn-outline-info btn-sm" id="refreshBrandCounts">
                                                <i class="bi bi-calculator me-1"></i><?= esc_html__('Fix Counts', 'ams-wc-amazon'); ?>
                                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <!-- Navigation Tabs -->
                    <div class="bg-light border-bottom">
                        <ul class="nav nav-tabs nav-fill border-0 bg-light" id="brandSettingsTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active fw-semibold text-dark bg-white border border-bottom-0 px-4 py-3" id="module-tab" data-bs-toggle="tab" data-bs-target="#module-activation" type="button" role="tab">
                                    <i class="bi bi-toggle-on me-2 text-primary"></i><?= esc_html__('Module Activation', 'ams-wc-amazon'); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link fw-semibold text-dark bg-light border border-bottom-0 px-4 py-3" id="display-tab" data-bs-toggle="tab" data-bs-target="#display-options" type="button" role="tab">
                                    <i class="bi bi-grid-3x3-gap me-2 text-secondary"></i><?= esc_html__('Display Options', 'ams-wc-amazon'); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link fw-semibold text-dark bg-light border border-bottom-0 px-4 py-3" id="css-tab" data-bs-toggle="tab" data-bs-target="#custom-css" type="button" role="tab">
                                    <i class="bi bi-code-slash me-2 text-secondary"></i><?= esc_html__('Custom CSS', 'ams-wc-amazon'); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link fw-semibold text-dark bg-light border border-bottom-0 px-4 py-3" id="stats-tab" data-bs-toggle="tab" data-bs-target="#statistics" type="button" role="tab">
                                    <i class="bi bi-bar-chart me-2 text-secondary"></i><?= esc_html__('Statistics', 'ams-wc-amazon'); ?>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link fw-semibold text-dark bg-light border border-bottom-0 px-4 py-3" id="seo-tab" data-bs-toggle="tab" data-bs-target="#seo-tools" type="button" role="tab">
                                    <i class="bi bi-search me-2 text-secondary"></i><?= esc_html__('SEO Tools', 'ams-wc-amazon'); ?>
                                </button>
                            </li>
                        </ul>
                    </div>

                    <!-- Tab Content -->
                    <form method="post" action="options.php" class="p-4" id="brandSettingsForm">
                        <?php settings_fields('ams_brand_settings'); ?>
                        <input type="hidden" name="active_tab" id="activeTabInput" value="<?php echo isset($_GET['tab']) ? esc_attr($_GET['tab']) : 'module-activation'; ?>">
                        <input type="hidden" name="current_css_template" id="currentTemplateInput" value="<?php echo esc_attr(get_option('current_css_template', '')); ?>">
                        
                        <div class="tab-content" id="brandSettingsTabContent">
                            <!-- Module Activation Tab -->
                            <div class="tab-pane fade show active" id="module-activation" role="tabpanel">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="card border-0 bg-light">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <label class="fw-bold mb-1" for="brandModuleEnabled">
                                                        <?= esc_html__('Enable Brands Module', 'ams-wc-amazon'); ?>
                                                    </label>
                                                    <div class="form-text text-muted">
                                                        <?= esc_html__('Enable brands functionality across your site', 'ams-wc-amazon'); ?>
                                                    </div>
                                                    </div>
                                                    <label class="ams-common-toggle-switch">
                                                        <input type="checkbox" name="ams_brand_module_enabled" 
                                                               id="brandModuleEnabled" value="1" 
                                                               <?php checked(get_option('ams_brand_module_enabled', '1'), '1'); ?>>
                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Instructions & Preview -->
                                    <div class="col-12">
                                        <div class="row g-4">
                                            <!-- Setup Instructions -->
                                            <div class="col-lg-8">
                                                <div class="card border-primary h-100">
                                            <div class="card-header bg-primary text-white">
                                                <h6 class="mb-0">
                                                            <i class="bi bi-rocket me-2"></i><?= esc_html__('Quick Setup Guide', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="row g-4">
                                                    <div class="col-md-6">
                                                                <div class="setup-step">
                                                                    <div class="d-flex align-items-start">
                                                                        <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px; font-size: 14px; font-weight: bold;">1</div>
                                                                        <div class="flex-grow-1">
                                                                            <h6 class="text-primary mb-2"><?= esc_html__('Create Brands Page', 'ams-wc-amazon'); ?></h6>
                                                                            
                                                                            <?php
                                                                            // Check if brands page already exists
                                                                            $brands_page_id = get_option('ams_brands_page_id');
                                                                            $brands_page = $brands_page_id ? get_post($brands_page_id) : null;
                                                                            $page_exists = $brands_page && $brands_page->post_status === 'publish';
                                                                            
                                                                            if ($page_exists) {
                                                                                echo '<div class="alert alert-success border-0 bg-success bg-opacity-10 py-2 px-3 mb-3">
                                                                                        <div class="d-flex align-items-center">
                                                                                            <i class="bi bi-check-circle text-success me-2"></i>
                                                                                            <div class="small">
                                                                                                <strong>' . esc_html__('Brands page created successfully!', 'ams-wc-amazon') . '</strong><br>
                                                                                                <a href="' . esc_url(get_permalink($brands_page_id)) . '" target="_blank" class="text-success text-decoration-none">
                                                                                                    <i class="bi bi-eye me-1"></i>' . esc_html__('View Page', 'ams-wc-amazon') . '
                                                                                                </a>
                                                                                                <span class="text-muted mx-2">|</span>
                                                                                                <a href="' . esc_url(admin_url('post.php?post=' . $brands_page_id . '&action=edit')) . '" target="_blank" class="text-success text-decoration-none">
                                                                                                    <i class="bi bi-pencil me-1"></i>' . esc_html__('Edit Page', 'ams-wc-amazon') . '
                                                                                                </a>
                                                                                            </div>
                                                                                        </div>
                                                                                      </div>';
                                                                            } else {
                                                                                echo '<p class="mb-3 small text-muted">' . esc_html__('Automatically create a WordPress page with the brand filter shortcode:', 'ams-wc-amazon') . '</p>';
                                                                            }
                                                                            ?>
                                                                            
                                                                            <div class="d-flex align-items-center gap-2 mb-3">
                                                                                <?php if (!$page_exists): ?>
                                                                                    <button type="button" class="btn btn-primary btn-sm" id="createBrandsPage">
                                                                                        <i class="bi bi-plus-circle me-1"></i><?= esc_html__('Auto Create Brands Page', 'ams-wc-amazon'); ?>
                                                                                    </button>
                                                                                <?php else: ?>
                                                                                    <button type="button" class="btn btn-outline-danger btn-sm" id="recreateBrandsPage">
                                                                                        <i class="bi bi-arrow-clockwise me-1"></i><?= esc_html__('Recreate Page', 'ams-wc-amazon'); ?>
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                                
                                                                                <div class="dropdown">
                                                                                    <button class="btn btn-outline-secondary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                        <i class="bi bi-gear me-1"></i><?= esc_html__('Options', 'ams-wc-amazon'); ?>
                                                                                    </button>
                                                                                    <ul class="dropdown-menu">
                                                                                        <li>
                                                                                            <div class="px-3 py-2">
                                                                                                <label class="form-label small mb-1"><?= esc_html__('Page Title:', 'ams-wc-amazon'); ?></label>
                                                                                                <input type="text" class="form-control form-control-sm" id="brandsPageTitle" 
                                                                                                       value="<?= esc_attr__('Our Brands', 'ams-wc-amazon'); ?>" placeholder="<?= esc_attr__('Enter page title', 'ams-wc-amazon'); ?>">
                                                                                            </div>
                                                                                        </li>
                                                                                        <li>
                                                                                            <div class="px-3 py-2">
                                                                                                <label class="form-label small mb-1"><?= esc_html__('Page Slug:', 'ams-wc-amazon'); ?></label>
                                                                                                <input type="text" class="form-control form-control-sm" id="brandsPageSlug" 
                                                                                                       value="brands" placeholder="<?= esc_attr__('Enter page slug', 'ams-wc-amazon'); ?>">
                                                                                            </div>
                                                                                        </li>
                                                                                        <li><hr class="dropdown-divider"></li>
                                                                                        <li>
                                                                                            <div class="px-3 py-2">
                                                                                                <div class="form-check">
                                                                                                    <input class="form-check-input" type="checkbox" id="addToMenu" checked>
                                                                                                    <label class="form-check-label small" for="addToMenu">
                                                                                                        <?= esc_html__('Add to navigation menu', 'ams-wc-amazon'); ?>
                                                                                                    </label>
                                                                                                </div>
                                                                                                <small class="text-muted d-block mb-2"><?= esc_html__('Automatically add page to your site\'s main navigation menu', 'ams-wc-amazon'); ?></small>
                                                                                                
                                                                                                <?php
                                                                                                // Get available menus for selection
                                                                                                $menus = wp_get_nav_menus();
                                                                                                if (!empty($menus)) {
                                                                                                    echo '<select class="form-select form-select-sm" id="targetMenu" style="display: none;">';
                                                                                                    echo '<option value="auto">' . esc_html__('Auto-detect main menu', 'ams-wc-amazon') . '</option>';
                                                                                                    foreach ($menus as $menu) {
                                                                                                        $menu_name = esc_html($menu->name);
                                                                                                        // Mark likely main menus
                                                                                                        $menu_name_lower = strtolower($menu->name);
                                                                                                        if (strpos($menu_name_lower, 'footer') === false && 
                                                                                                            strpos($menu_name_lower, 'bottom') === false &&
                                                                                                            strpos($menu_name_lower, 'secondary') === false) {
                                                                                                            $menu_name .= ' ⭐';
                                                                                                        }
                                                                                                        echo '<option value="' . esc_attr($menu->term_id) . '">' . $menu_name . '</option>';
                                                                                                    }
                                                                                                    echo '</select>';
                                                                                                }
                                                                                                ?>
                                                                                            </div>
                                                                                        </li>
                                                                                    </ul>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <!-- Manual Instructions (Collapsible) -->
                                                                            <div class="border-top pt-2">
                                                                                <a class="btn btn-link btn-sm p-0 text-decoration-none" data-bs-toggle="collapse" href="#manualInstructions" role="button">
                                                                                    <i class="bi bi-chevron-down me-1"></i><?= esc_html__('Show manual instructions', 'ams-wc-amazon'); ?>
                                                                                </a>
                                                                                <div class="collapse mt-2" id="manualInstructions">
                                                                                    <div class="small text-muted">
                                                                                        <p class="mb-2"><?= esc_html__('To create manually:', 'ams-wc-amazon'); ?></p>
                                                        <ul class="list-unstyled">
                                                                                            <li class="mb-1"><i class="bi bi-arrow-right text-primary me-2"></i><?= esc_html__('Go to Pages → Add New', 'ams-wc-amazon'); ?></li>
                                                                                            <li class="mb-1"><i class="bi bi-arrow-right text-primary me-2"></i><?= esc_html__('Title: "Our Brands" or similar', 'ams-wc-amazon'); ?></li>
                                                                                            <li class="mb-1"><i class="bi bi-arrow-right text-primary me-2"></i><?= esc_html__('Content: Add shortcode', 'ams-wc-amazon'); ?> <code class="bg-light px-2 py-1 rounded small">[brand_filter]</code></li>
                                                                                            <li class="mb-1"><i class="bi bi-arrow-right text-primary me-2"></i><?= esc_html__('Publish the page', 'ams-wc-amazon'); ?></li>
                                                        </ul>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                                <div class="setup-step">
                                                                    <div class="d-flex align-items-start">
                                                                        <div class="step-number bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px; font-size: 14px; font-weight: bold;">2</div>
                                                                        <div>
                                                                            <h6 class="text-success mb-2"><?= esc_html__('Import Products', 'ams-wc-amazon'); ?></h6>
                                                                            <p class="mb-2 small"><?= esc_html__('Brands are automatically created when you import Amazon products:', 'ams-wc-amazon'); ?></p>
                                                                            <ul class="list-unstyled small">
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-success me-2"></i><?= esc_html__('Import products from Amazon', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-success me-2"></i><?= esc_html__('Brands are extracted automatically', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-success me-2"></i><?= esc_html__('View at Products → Brands', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-success me-2"></i><?= esc_html__('Upload custom logos if needed', 'ams-wc-amazon'); ?></li>
                                                        </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                    </div>
                                                </div>
                                                
                                                        <div class="row g-4 mt-2">
                                                            <div class="col-md-6">
                                                                <div class="setup-step">
                                                                    <div class="d-flex align-items-start">
                                                                        <div class="step-number bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px; font-size: 14px; font-weight: bold;">3</div>
                                                    <div>
                                                                            <h6 class="text-info mb-2"><?= esc_html__('Configure Display', 'ams-wc-amazon'); ?></h6>
                                                                            <p class="mb-2 small"><?= esc_html__('Customize how brands appear on your site:', 'ams-wc-amazon'); ?></p>
                                                                            <ul class="list-unstyled small">
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-info me-2"></i><?= esc_html__('Use Display Options tab above', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-info me-2"></i><?= esc_html__('Set logo dimensions', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-info me-2"></i><?= esc_html__('Choose brands per row/page', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-info me-2"></i><?= esc_html__('Enable/disable product counts', 'ams-wc-amazon'); ?></li>
                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="setup-step">
                                                                    <div class="d-flex align-items-start">
                                                                        <div class="step-number bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 30px; height: 30px; font-size: 14px; font-weight: bold;">4</div>
                                                                        <div>
                                                                            <h6 class="text-warning mb-2"><?= esc_html__('Style & Customize', 'ams-wc-amazon'); ?></h6>
                                                                            <p class="mb-2 small"><?= esc_html__('Make it look perfect with custom CSS:', 'ams-wc-amazon'); ?></p>
                                                                            <ul class="list-unstyled small">
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-warning me-2"></i><?= esc_html__('Use Custom CSS tab above', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-warning me-2"></i><?= esc_html__('Choose from ready templates', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-warning me-2"></i><?= esc_html__('Preview changes live', 'ams-wc-amazon'); ?></li>
                                                                                <li class="mb-1"><i class="bi bi-arrow-right text-warning me-2"></i><?= esc_html__('Save and enjoy!', 'ams-wc-amazon'); ?></li>
                                                        </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="alert alert-success d-flex align-items-center mt-4" role="alert">
                                                            <i class="bi bi-check-circle-fill me-2"></i>
                                                            <div>
                                                                <strong><?= esc_html__('Pro Tip:', 'ams-wc-amazon'); ?></strong> 
                                                                <?= esc_html__('Enable "Show Brands on Shop Page" in Display Options to automatically show brand filters on your WooCommerce shop page!', 'ams-wc-amazon'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Brand Module Preview -->
                                            <div class="col-lg-4">
                                                <div class="card border-secondary h-100">
                                                    <div class="card-header bg-secondary text-white">
                                                        <h6 class="mb-0">
                                                            <i class="bi bi-eye me-2"></i><?= esc_html__('How It Looks', 'ams-wc-amazon'); ?>
                                                        </h6>
                                                    </div>
                                                    <div class="card-body">
                                                        <p class="small text-muted mb-3"><?= esc_html__('This is how your brand page will look:', 'ams-wc-amazon'); ?></p>
                                                        
                                                        <!-- Mini Brand Preview -->
                                                        <div class="brand-preview-demo">
                                                            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; font-size: 12px;">
                                                                <div style="text-align: center; padding: 10px; border: 1px solid #dee2e6; border-radius: 6px;">
                                                                    <div style="width: 40px; height: 40px; background: #f8f9fa; border-radius: 4px; margin: 0 auto 8px; display: flex; align-items: center; justify-content: center; color: #6c757d;">
                                                                        <i class="bi bi-image"></i>
                                                                    </div>
                                                                    <div style="font-weight: bold; margin-bottom: 2px;">Apple</div>
                                                                    <div style="color: #6c757d; font-size: 11px;">24 Products</div>
                                                                </div>
                                                                <div style="text-align: center; padding: 10px; border: 1px solid #dee2e6; border-radius: 6px;">
                                                                    <div style="width: 40px; height: 40px; background: #f8f9fa; border-radius: 4px; margin: 0 auto 8px; display: flex; align-items: center; justify-content: center; color: #6c757d;">
                                                                        <i class="bi bi-image"></i>
                                                                    </div>
                                                                    <div style="font-weight: bold; margin-bottom: 2px;">Samsung</div>
                                                                    <div style="color: #6c757d; font-size: 11px;">18 Products</div>
                                                                </div>
                                                                <div style="text-align: center; padding: 10px; border: 1px solid #dee2e6; border-radius: 6px;">
                                                                    <div style="width: 40px; height: 40px; background: #f8f9fa; border-radius: 4px; margin: 0 auto 8px; display: flex; align-items: center; justify-content: center; color: #6c757d;">
                                                                        <i class="bi bi-image"></i>
                                                                    </div>
                                                                    <div style="font-weight: bold; margin-bottom: 2px;">Sony</div>
                                                                    <div style="color: #6c757d; font-size: 11px;">12 Products</div>
                                                                </div>
                                                                <div style="text-align: center; padding: 10px; border: 1px solid #dee2e6; border-radius: 6px;">
                                                                    <div style="width: 40px; height: 40px; background: #f8f9fa; border-radius: 4px; margin: 0 auto 8px; display: flex; align-items: center; justify-content: center; color: #6c757d;">
                                                                        <i class="bi bi-image"></i>
                                                                    </div>
                                                                    <div style="font-weight: bold; margin-bottom: 2px;">Nike</div>
                                                                    <div style="color: #6c757d; font-size: 11px;">31 Products</div>
                                                                </div>
                                                    </div>
                                                </div>
                                                
                                                        <div class="mt-3 pt-3 border-top">
                                                            <h6 class="small fw-bold text-dark mb-2"><?= esc_html__('Features:', 'ams-wc-amazon'); ?></h6>
                                                            <ul class="list-unstyled small">
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Automatic brand extraction', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Custom logo uploads', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Product count display', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Responsive grid layout', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Pagination support', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Click tracking analytics', 'ams-wc-amazon'); ?></li>
                                                                <li class="mb-1"><i class="bi bi-check text-success me-2"></i><?= esc_html__('Custom CSS styling', 'ams-wc-amazon'); ?></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Display Options Tab -->
                            <div class="tab-pane fade" id="display-options" role="tabpanel">
                                <div class="row g-4">
                                    <!-- Logo Settings -->
                                    <div class="col-lg-6">
                                        <div class="card h-100">
                                            <div class="card-header">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-image me-2"></i><?= esc_html__('Logo Settings', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label"><?= esc_html__('Logo Dimensions', 'ams-wc-amazon'); ?></label>
                                                    <div class="row g-2">
                                                        <div class="col-6">
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="brand_logo_width" 
                                                                       value="<?php echo esc_attr(get_option('brand_logo_width', '150')); ?>" 
                                                                       placeholder="Width">
                                                                <span class="input-group-text">px</span>
                                                            </div>
                                                        </div>
                                                        <div class="col-6">
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="brand_logo_height" 
                                                                       value="<?php echo esc_attr(get_option('brand_logo_height', '150')); ?>" 
                                                                       placeholder="Height">
                                                                <span class="input-group-text">px</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <label class="form-label mb-0" for="displayBrandLogo">
                                                        <?= esc_html__('Display Brand Logo', 'ams-wc-amazon'); ?>
                                                    </label>
                                                    <label class="ams-common-toggle-switch">
                                                        <input type="checkbox" name="display_brand_logo" 
                                                           id="displayBrandLogo" value="1" 
                                                           <?php checked(get_option('display_brand_logo', '1'), '1'); ?>>
                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Layout Settings -->
                                    <div class="col-lg-6">
                                        <div class="card h-100">
                                            <div class="card-header">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-grid-3x3 me-2"></i><?= esc_html__('Layout Settings', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label"><?= esc_html__('Brands per Row', 'ams-wc-amazon'); ?></label>
                                                    <select name="brands_per_row" class="form-select">
                                                        <?php
                                                        $selected = get_option('brands_per_row', '4');
                                                        for($i = 2; $i <= 6; $i++) {
                                                            echo '<option value="' . $i . '" ' . selected($selected, $i, false) . '>' . $i . '</option>';
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label"><?= esc_html__('Brands per Page', 'ams-wc-amazon'); ?></label>
                                                    <input type="number" class="form-control" name="brands_per_page" 
                                                           value="<?php echo esc_attr(get_option('brands_per_page', '12')); ?>">
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <label class="form-label mb-0" for="displayProductCount">
                                                        <?= esc_html__('Display Product Count', 'ams-wc-amazon'); ?>
                                                    </label>
                                                    <label class="ams-common-toggle-switch">
                                                        <input type="checkbox" name="display_product_count" 
                                                           id="displayProductCount" value="1" 
                                                           <?php checked(get_option('display_product_count', '1'), '1'); ?>>
                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Integration Settings -->
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-puzzle me-2"></i><?= esc_html__('Integration Settings', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <div class="card border-0 bg-light h-100">
                                                            <div class="card-body">
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <label class="form-label mb-0" for="displayBrandOnProduct">
                                                                        <?= esc_html__('Show Brand on Product Page', 'ams-wc-amazon'); ?>
                                                                    </label>
                                                                    <label class="ams-common-toggle-switch">
                                                                        <input type="checkbox" name="display_brand_on_product_page" 
                                                                   id="displayBrandOnProduct" value="1" 
                                                                   <?php checked(get_option('display_brand_on_product_page', '1'), '1'); ?>>
                                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                            </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="card border-0 bg-light h-100">
                                                            <div class="card-body">
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <label class="form-label mb-0" for="showBrandsShop">
                                                                        <?= esc_html__('Show Brands on Shop Page', 'ams-wc-amazon'); ?>
                                                                    </label>
                                                                    <label class="ams-common-toggle-switch">
                                                                        <input type="checkbox" name="show_brands_shop_page" 
                                                                   id="showBrandsShop" value="1" 
                                                                   <?php checked(get_option('show_brands_shop_page'), '1'); ?>>
                                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                            </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="card border-0 bg-light h-100">
                                                            <div class="card-body">
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <label class="form-label mb-0" for="showBrandsCategory">
                                                                        <?= esc_html__('Show Brands on Category Pages', 'ams-wc-amazon'); ?>
                                                                    </label>
                                                                    <label class="ams-common-toggle-switch">
                                                                        <input type="checkbox" name="show_brands_category_page" 
                                                                   id="showBrandsCategory" value="1" 
                                                                   <?php checked(get_option('show_brands_category_page'), '1'); ?>>
                                                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                            </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Custom CSS Tab -->
                            <div class="tab-pane fade" id="custom-css" role="tabpanel">
                                <div class="row g-4">
                                    <!-- CSS Editor -->
                                    <div class="col-lg-8">
                                        <div class="card h-100">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-code-slash me-2"></i><?= esc_html__('Custom CSS Editor', 'ams-wc-amazon'); ?>
                                                </h6>
                                                <div class="d-flex gap-2">
                                                    <button type="button" class="btn btn-sm btn-outline-secondary" id="clearCssBtn">
                                                        <?= esc_html__('Clear', 'ams-wc-amazon'); ?>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-outline-info" id="previewCssBtn">
                                                        <?= esc_html__('Preview', 'ams-wc-amazon'); ?>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <textarea name="custom_brand_css" id="customCssEditor" rows="15" class="form-control font-monospace" 
                                                          placeholder="/* Add your custom CSS here - Click on examples to insert them */&#10;&#10;/* Example: Style brand items */&#10;.ams-brand-item {&#10;    box-shadow: 0 2px 8px rgba(0,0,0,0.1);&#10;    border-radius: 8px;&#10;    padding: 15px;&#10;}"><?php echo esc_textarea(get_option('custom_brand_css')); ?></textarea>
                                                
                                                <!-- Preview Area -->
                                                <div id="cssPreviewArea" class="mt-3 p-3 border rounded bg-light d-none">
                                                    <h6 class="text-primary mb-2"><?= esc_html__('Live Preview:', 'ams-wc-amazon'); ?></h6>
                                                    <div class="ams-brand-container">
                                                        <div class="ams-brand-grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px;">
                                                            <div class="ams-brand-item" style="text-align: center;">
                                                                <img src="<?php echo AMS_PLUGIN_URL; ?>assets/plugin/img/brand/no-logo.png" alt="Sample Brand" style="width: 80px; height: 80px; object-fit: contain; margin-bottom: 10px;">
                                                                <div class="ams-brand-name" style="font-weight: bold;">Sample Brand</div>
                                                                <div class="ams-brand-count">12 Products</div>
                                            </div>
                                                            <div class="ams-brand-item" style="text-align: center;">
                                                                <img src="<?php echo AMS_PLUGIN_URL; ?>assets/plugin/img/brand/no-logo.png" alt="Another Brand" style="width: 80px; height: 80px; object-fit: contain; margin-bottom: 10px;">
                                                                <div class="ams-brand-name" style="font-weight: bold;">Another Brand</div>
                                                                <div class="ams-brand-count">8 Products</div>
                                        </div>
                                                            <div class="ams-brand-item" style="text-align: center;">
                                                                <img src="<?php echo AMS_PLUGIN_URL; ?>assets/plugin/img/brand/no-logo.png" alt="Third Brand" style="width: 80px; height: 80px; object-fit: contain; margin-bottom: 10px;">
                                                                <div class="ams-brand-name" style="font-weight: bold;">Third Brand</div>
                                                                <div class="ams-brand-count">25 Products</div>
                                    </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- CSS Examples & Selector -->
                                    <div class="col-lg-4">
                                        <div class="card h-100">
                                            <div class="card-header">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-palette me-2"></i><?= esc_html__('Style Templates', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <!-- Template Categories -->
                                                <div class="mb-4">
                                                    <h6 class="text-primary mb-3"><?= esc_html__('Choose a Style Template:', 'ams-wc-amazon'); ?></h6>
                                                    
                                                    <!-- Minimal Modern -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="minimal-modern">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Minimal Modern', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Clean, minimal design with subtle spacing', 'ams-wc-amazon'); ?></small>
                                                    </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                                    </div>
                                                    </div>

                                                    <!-- Soft Cards -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="soft-cards">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Soft Cards', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Gentle shadows with rounded corners', 'ams-wc-amazon'); ?></small>
                                                    </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                                    </div>
                                                    </div>

                                                    <!-- Clean Grid -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="clean-grid">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Clean Grid', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Simple grid with hover effects', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                            </div>
                                        </div>

                                                    <!-- Elegant Borders -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="elegant-borders">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Elegant Borders', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Refined borders with subtle highlights', 'ams-wc-amazon'); ?></small>
                                                            </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                                        </div>
                                                    </div>

                                                    <!-- Floating Cards -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="floating-cards">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Floating Cards', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Elevated cards with smooth animations', 'ams-wc-amazon'); ?></small>
                                                            </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                                        </div>
                                                    </div>

                                                    <!-- Monochrome -->
                                                    <div class="css-template-card mb-3 p-3 border rounded cursor-pointer" data-template="monochrome">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <div>
                                                                <strong class="text-dark"><?= esc_html__('Monochrome', 'ams-wc-amazon'); ?></strong>
                                                                <small class="d-block text-muted"><?= esc_html__('Black and white minimalist design', 'ams-wc-amazon'); ?></small>
                                                            </div>
                                                            <button class="btn btn-sm btn-outline-primary"><?= esc_html__('Use', 'ams-wc-amazon'); ?></button>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Quick Actions -->
                                                <div class="mb-4">
                                                    <h6 class="text-success mb-2"><?= esc_html__('Quick Customizations:', 'ams-wc-amazon'); ?></h6>
                                                    <div class="row g-2">
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-info css-quick-action w-100" data-action="add-shadows">
                                                                <?= esc_html__('Add Shadows', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-info css-quick-action w-100" data-action="hover-effects">
                                                                <?= esc_html__('Hover Effects', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-info css-quick-action w-100" data-action="custom-spacing">
                                                                <?= esc_html__('Spacing', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-info css-quick-action w-100" data-action="typography">
                                                                <?= esc_html__('Typography', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-secondary css-quick-action w-100" data-action="rounded-corners">
                                                                <?= esc_html__('Rounded', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                        <div class="col-6">
                                                            <button class="btn btn-sm btn-outline-secondary css-quick-action w-100" data-action="color-accents">
                                                                <?= esc_html__('Accents', 'ams-wc-amazon'); ?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- CSS Classes Reference -->
                                                <div>
                                                    <h6 class="text-secondary mb-2"><?= esc_html__('CSS Classes Reference:', 'ams-wc-amazon'); ?></h6>
                                                    <div class="small">
                                                        <div class="mb-1"><code>.ams-brand-container</code> - <?= esc_html__('Main wrapper', 'ams-wc-amazon'); ?></div>
                                                        <div class="mb-1"><code>.ams-brand-grid</code> - <?= esc_html__('Grid container', 'ams-wc-amazon'); ?></div>
                                                        <div class="mb-1"><code>.ams-brand-item</code> - <?= esc_html__('Individual brand', 'ams-wc-amazon'); ?></div>
                                                        <div class="mb-1"><code>.ams-brand-name</code> - <?= esc_html__('Brand name', 'ams-wc-amazon'); ?></div>
                                                        <div class="mb-1"><code>.ams-brand-count</code> - <?= esc_html__('Product count', 'ams-wc-amazon'); ?></div>
                                                        <div class="mb-1"><code>.product-brand-container</code> - <?= esc_html__('Single product brand', 'ams-wc-amazon'); ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Statistics Tab -->
                            <div class="tab-pane fade" id="statistics" role="tabpanel">
                                <?php
                                $brand_clicks = get_option('ams_brand_clicks', array());
                                
                                // Initialize default values to prevent undefined variable errors
                                $hourly_stats = array_fill(0, 24, 0);
                                $device_stats = array('desktop' => 0, 'mobile' => 0, 'tablet' => 0);
                                $browser_stats = array();
                                $daily_stats = array();
                                $total_clicks = 0;
                                $mobile_percentage = 0;
                                $avg_time_on_page = 0;
                                
                                if (empty($brand_clicks)) {
                                    // Empty state with better design
                                                                        echo '<div class="row justify-content-center">
                                            <div class="col-lg-8 col-xl-6">
                                                <div class="text-center py-5">
                                                    <div class="empty-state-icon">
                                                        <i class="bi bi-bar-chart-line text-muted" style="font-size: 2rem;"></i>
                                        </div>
                                                    <h5 class="text-muted mb-3">' . esc_html__('No Statistics Available', 'ams-wc-amazon') . '</h5>
                                                    <p class="text-muted mb-4">' . esc_html__('Brand click statistics will appear here once visitors start interacting with your brand filters and links.', 'ams-wc-amazon') . '</p>
                                                    <div class="card border-0 bg-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-start">
                                                                <div class="stats-icon-wrapper bg-info bg-opacity-20 me-3" style="width: 32px; height: 32px; margin: 0;">
                                                                    <i class="bi bi-lightbulb text-info" style="font-size: 0.875rem;"></i>
                                    </div>
                                                                <div class="text-start">
                                                                    <h6 class="mb-2">' . esc_html__('How to generate statistics:', 'ams-wc-amazon') . '</h6>
                                                                    <ul class="list-unstyled mb-0 small">
                                                                        <li class="mb-2 d-flex align-items-center">
                                                                            <span class="badge bg-primary bg-opacity-10 text-primary me-2" style="width: 20px; height: 20px; border-radius: 50%; font-size: 0.75rem; display: flex; align-items: center; justify-content: center;">1</span>
                                                                            ' . esc_html__('Add the [brand_filter] shortcode to a page', 'ams-wc-amazon') . '
                                                                        </li>
                                                                        <li class="mb-2 d-flex align-items-center">
                                                                            <span class="badge bg-success bg-opacity-10 text-success me-2" style="width: 20px; height: 20px; border-radius: 50%; font-size: 0.75rem; display: flex; align-items: center; justify-content: center;">2</span>
                                                                            ' . esc_html__('Enable brand display on product/shop pages', 'ams-wc-amazon') . '
                                                                        </li>
                                                                        <li class="d-flex align-items-center">
                                                                            <span class="badge bg-info bg-opacity-10 text-info me-2" style="width: 20px; height: 20px; border-radius: 50%; font-size: 0.75rem; display: flex; align-items: center; justify-content: center;">3</span>
                                                                            ' . esc_html__('Visitor clicks will be tracked automatically', 'ams-wc-amazon') . '
                                                                        </li>
                                                                    </ul>
                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                          </div>';
                                } else {
                                    // Calculate summary statistics
                                    $total_clicks = array_sum(array_column($brand_clicks, 'total'));
                                    $total_brands = count($brand_clicks);
                                    $avg_clicks = $total_brands > 0 ? round($total_clicks / $total_brands, 1) : 0;
                                    
                                    // Find most popular brand
                                    $most_popular = null;
                                    $max_clicks = 0;
                                    foreach ($brand_clicks as $brand_id => $data) {
                                        if ($data['total'] > $max_clicks) {
                                            $max_clicks = $data['total'];
                                            $brand = get_term($brand_id, 'product_brand');
                                            if ($brand && !is_wp_error($brand)) {
                                                $most_popular = $brand->name;
                                            }
                                        }
                                    }
                                    
                                    echo '<div class="row g-4">';
                                    
                                    // Calculate enhanced statistics
                                    $device_stats = array('desktop' => 0, 'mobile' => 0, 'tablet' => 0);
                                    $browser_stats = array();
                                    $hourly_stats = array_fill(0, 24, 0);
                                    $daily_stats = array();
                                    $total_time_on_page = 0;
                                    $click_count_for_avg = 0;
                                    
                                    foreach ($brand_clicks as $brand_data) {
                                        if (isset($brand_data['devices'])) {
                                            foreach ($brand_data['devices'] as $device => $count) {
                                                if (isset($device_stats[$device])) {
                                                    $device_stats[$device] += $count;
                                                }
                                            }
                                        }
                                        if (isset($brand_data['browsers'])) {
                                            foreach ($brand_data['browsers'] as $browser => $count) {
                                                $browser_stats[$browser] = ($browser_stats[$browser] ?? 0) + $count;
                                            }
                                        }
                                        if (isset($brand_data['hourly_stats'])) {
                                            foreach ($brand_data['hourly_stats'] as $hour => $count) {
                                                $hourly_stats[intval($hour)] += $count;
                                            }
                                        }
                                        if (isset($brand_data['daily_stats'])) {
                                            foreach ($brand_data['daily_stats'] as $date => $count) {
                                                $daily_stats[$date] = ($daily_stats[$date] ?? 0) + $count;
                                            }
                                        }
                                        if (isset($brand_data['avg_time_on_page']) && $brand_data['avg_time_on_page'] > 0) {
                                            $total_time_on_page += $brand_data['avg_time_on_page'] * $brand_data['total'];
                                            $click_count_for_avg += $brand_data['total'];
                                        }
                                    }
                                    
                                    $avg_time_on_page = $click_count_for_avg > 0 ? round($total_time_on_page / $click_count_for_avg, 1) : 0;
                                    $mobile_percentage = $total_clicks > 0 ? round(($device_stats['mobile'] / $total_clicks) * 100, 1) : 0;
                                    
                                    // Enhanced Summary Cards
                                    echo '<div class="col-12">
                                            <div class="row g-3 mb-4">
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-primary bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-primary bg-opacity-20">
                                                                <i class="bi bi-mouse text-primary"></i>
                                                            </div>
                                                            <div class="stats-number text-primary">' . number_format($total_clicks) . '</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Total Clicks', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-success bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-success bg-opacity-20">
                                                                <i class="bi bi-tags text-success"></i>
                                                            </div>
                                                            <div class="stats-number text-success">' . $total_brands . '</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Active Brands', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-info bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-info bg-opacity-20">
                                                                <i class="bi bi-graph-up text-info"></i>
                                                            </div>
                                                            <div class="stats-number text-info">' . $avg_clicks . '</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Avg per Brand', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-warning bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-warning bg-opacity-20">
                                                                <i class="bi bi-star text-warning"></i>
                                                            </div>
                                                            <div class="stats-number text-warning text-truncate" title="' . esc_attr($most_popular ?: 'N/A') . '">' . esc_html($most_popular ?: 'N/A') . '</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Top Brand', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-secondary bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-secondary bg-opacity-20">
                                                                <i class="bi bi-phone text-secondary"></i>
                                                            </div>
                                                            <div class="stats-number text-secondary">' . $mobile_percentage . '%</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Mobile Traffic', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-xl-2">
                                                    <div class="card stats-summary-card bg-dark bg-opacity-10 h-100">
                                                        <div class="card-body text-center">
                                                            <div class="stats-icon-wrapper bg-dark bg-opacity-20">
                                                                <i class="bi bi-clock text-dark"></i>
                                                            </div>
                                                            <div class="stats-number text-dark">' . $avg_time_on_page . 's</div>
                                                            <small class="text-muted fw-medium">' . esc_html__('Avg Time', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                          </div>';
                                    
                                    // Interactive Charts Section
                                    echo '<div class="col-12 mb-4">
                                            <div class="row g-4">
                                                <div class="col-lg-8">
                                                    <div class="card">
                                                        <div class="card-header bg-white border-bottom">
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <h6 class="mb-0">
                                                                    <i class="bi bi-graph-up me-2 text-primary"></i>' . esc_html__('Click Trends', 'ams-wc-amazon') . '
                                                                </h6>
                                                                <div class="btn-group btn-group-sm" role="group">
                                                                    <input type="radio" class="btn-check" name="chartPeriod" id="hourly" value="hourly" checked>
                                                                    <label class="btn btn-outline-primary" for="hourly">' . esc_html__('24h', 'ams-wc-amazon') . '</label>
                                                                    <input type="radio" class="btn-check" name="chartPeriod" id="daily" value="daily">
                                                                    <label class="btn btn-outline-primary" for="daily">' . esc_html__('7d', 'ams-wc-amazon') . '</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="card-body">
                                                            <canvas id="clickTrendsChart" height="120"></canvas>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="card h-100">
                                                        <div class="card-header bg-white border-bottom">
                                                            <h6 class="mb-0">
                                                                <i class="bi bi-pie-chart me-2 text-success"></i>' . esc_html__('Device Breakdown', 'ams-wc-amazon') . '
                                                            </h6>
                                                        </div>
                                                        <div class="card-body">
                                                            <canvas id="deviceChart" height="120"></canvas>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                          </div>';
                                    
                                    // Performance Insights Section
                                    echo '<div class="col-12 mb-4">
                                            <div class="card">
                                                <div class="card-header bg-white border-bottom">
                                                    <h6 class="mb-0">
                                                        <i class="bi bi-lightbulb me-2 text-warning"></i>' . esc_html__('Performance Insights', 'ams-wc-amazon') . '
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row g-3" id="performanceInsights">
                                                        <!-- Insights will be populated by JavaScript -->
                                                    </div>
                                                </div>
                                            </div>
                                          </div>';
                                    
                                    // Detailed Statistics Table
                                    echo '<div class="col-12">
                                            <div class="card stats-card-enhanced">
                                                <div class="card-header bg-white border-bottom">
                                                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                                        <div>
                                                            <h6 class="mb-0 text-dark">
                                                                <i class="bi bi-table me-2 text-primary"></i>' . esc_html__('Detailed Brand Analytics', 'ams-wc-amazon') . '
                                                            </h6>
                                                            <small class="text-muted">' . esc_html__('Click performance by brand', 'ams-wc-amazon') . '</small>
                                                        </div>
                                                        
                                                        <!-- Enhanced Search and Controls -->
                                                        <div class="d-flex align-items-center gap-2 flex-wrap">
                                                            <div class="input-group" style="width: 250px;">
                                                                <input type="text" class="form-control form-control-sm" 
                                                                       id="brandSearch" 
                                                                       placeholder="' . esc_attr__('Search brands...', 'ams-wc-amazon') . '"
                                                                       value="">
                                                                <button class="btn btn-outline-secondary btn-sm" type="button" id="searchBtn">
                                                                    <i class="bi bi-search"></i>
                                                                </button>
                                                            </div>
                                                            
                                                            <!-- Date Range Filter -->
                                                            <div class="input-group" style="width: 200px;">
                                                                <select class="form-select form-select-sm" id="dateRangeFilter">
                                                                    <option value="all">' . esc_html__('All Time', 'ams-wc-amazon') . '</option>
                                                                    <option value="today">' . esc_html__('Today', 'ams-wc-amazon') . '</option>
                                                                    <option value="week">' . esc_html__('Last 7 Days', 'ams-wc-amazon') . '</option>
                                                                    <option value="month">' . esc_html__('Last 30 Days', 'ams-wc-amazon') . '</option>
                                                                </select>
                                                            </div>
                                                            
                                                            <!-- Bulk Actions -->
                                                            <div class="dropdown">
                                                                <button class="btn btn-outline-primary btn-sm dropdown-toggle" type="button" id="bulkActionsDropdown" data-bs-toggle="dropdown">
                                                                    <i class="bi bi-gear me-1"></i>' . esc_html__('Bulk Actions', 'ams-wc-amazon') . '
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="#" id="bulkExportCSV">
                                                                        <i class="bi bi-download me-2"></i>' . esc_html__('Export to CSV', 'ams-wc-amazon') . '
                                                                    </a></li>
                                                                    <li><a class="dropdown-item" href="#" id="bulkExportExcel">
                                                                        <i class="bi bi-file-earmark-excel me-2"></i>' . esc_html__('Export to Excel', 'ams-wc-amazon') . '
                                                                    </a></li>
                                                                    <li><hr class="dropdown-divider"></li>
                                                                    <li><a class="dropdown-item" href="#" id="bulkResetSelected">
                                                                        <i class="bi bi-trash me-2"></i>' . esc_html__('Reset Selected', 'ams-wc-amazon') . '
                                                                    </a></li>
                                                                </ul>
                                                            </div>
                                                            
                                                            <button type="button" class="btn reset-btn-enhanced btn-sm" id="resetBrandStats">
                                                                <i class="bi bi-trash me-1"></i>' . esc_html__('Reset All', 'ams-wc-amazon') . '
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-0">';
                                    
                                    // Sort brands by click count (descending)
                                    uasort($brand_clicks, function($a, $b) {
                                        return $b['total'] - $a['total'];
                                    });
                                    
                                    echo '<div class="table-responsive">
                                            <table class="table table-enhanced table-hover mb-0" id="brandStatsTable">
                                                <thead>
                                                    <tr>
                                                        <th class="ps-4" style="width: 50px;">
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox" id="selectAllBrands">
                                                            </div>
                                                        </th>
                                                        <th class="sortable" data-sort="name">
                                                            ' . esc_html__('Brand Name', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="total">
                                                            ' . esc_html__('Total Clicks', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="shop">
                                                            ' . esc_html__('Shop Page', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="category">
                                                            ' . esc_html__('Category Page', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="product">
                                                            ' . esc_html__('Product Page', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="brand_page">
                                                            ' . esc_html__('Brand Page', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th class="text-center sortable" data-sort="products">
                                                            ' . esc_html__('Products', 'ams-wc-amazon') . ' 
                                                            <i class="bi bi-arrow-down-up ms-1 text-muted"></i>
                                                        </th>
                                                        <th>' . esc_html__('Last Click Info', 'ams-wc-amazon') . '</th>
                                                        <th class="text-center">' . esc_html__('Actions', 'ams-wc-amazon') . '</th>
                                                    </tr>
                                                </thead>
                                                <tbody>';

                                    foreach ($brand_clicks as $brand_id => $data) {
                                        $brand = get_term($brand_id, 'product_brand');
                                        if ($brand && !is_wp_error($brand)) {
                                            // Make sure all data keys exist with defaults
                                            $total = isset($data['total']) ? $data['total'] : 0;
                                            $shop = isset($data['shop']) ? $data['shop'] : 0;
                                            $category = isset($data['category']) ? $data['category'] : 0;
                                            $product = isset($data['product']) ? $data['product'] : 0;
                                            $brand_page = isset($data['brand_page']) ? $data['brand_page'] : 0;

                                            // Get last click data
                                            $last_click = isset($data['clicks_data']) && !empty($data['clicks_data']) 
                                                ? end($data['clicks_data']) : null;

                                            // Format last click info with detailed IP/country data
                                            $last_click_info = '<span class="text-muted small">' . esc_html__('No clicks yet', 'ams-wc-amazon') . '</span>';
                                            
                                            if ($last_click) {
                                                $ip_info = '';
                                                if ($last_click['country_code'] === 'LOCAL') {
                                                    $ip_info = '🖥️ ' . $last_click['ip']; // Computer emoji for localhost
                                                } else {
                                                    $flag_img = !empty($last_click['country_code']) 
                                                        ? '<img src="https://flagcdn.com/16x12/' . strtolower($last_click['country_code']) . '.png" 
                                                             style="margin-right:5px; vertical-align:middle;" 
                                                             title="' . esc_attr($last_click['country_name']) . '" />' 
                                                        : '';
                                                    $ip_info = $flag_img . $last_click['ip'];
                                                }
                                                
                                                $location_display = $last_click['location'];
                                                if ($location_display === 'unknown') {
                                                    $location_display = 'Unknown Page';
                                                } else {
                                                    $location_display = ucfirst(str_replace('_', ' ', $location_display));
                                                }
                                                
                                                $last_click_info = sprintf(
                                                    '%s - %s ago - from %s',
                                                    $ip_info,
                                                    human_time_diff(strtotime($last_click['time']), current_time('timestamp')),
                                                    $location_display
                                                );
                                            }

                                            echo '<tr class="brand-row" data-brand-id="' . $brand_id . '" data-brand-name="' . esc_attr($brand->name) . '">
                                                    <td class="ps-4">
                                                        <div class="form-check">
                                                            <input class="form-check-input brand-checkbox" type="checkbox" value="' . $brand_id . '">
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="brand-icon me-3">
                                                                <i class="bi bi-tag text-primary"></i>
                                                            </div>
                                                            <div>
                                                                <a href="' . esc_url(get_term_link($brand)) . '" target="_blank" class="fw-medium text-decoration-none">' 
                                                                . esc_html(str_replace('Visita la tienda de ', '', $brand->name)) . '</a>
                                                                <div class="small text-muted">' . sprintf(esc_html__('ID: %d', 'ams-wc-amazon'), $brand_id) . '</div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="click-badge">' . number_format($total) . '</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-info bg-opacity-10 text-info px-2 py-1">' . number_format($shop) . '</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-success bg-opacity-10 text-success px-2 py-1">' . number_format($category) . '</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-warning bg-opacity-10 text-warning px-2 py-1">' . number_format($product) . '</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-secondary bg-opacity-10 text-secondary px-2 py-1">' . number_format($brand_page) . '</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="text-muted fw-medium">' . number_format($brand->count) . '</span>
                                                    </td>
                                                    <td>
                                                        <div class="small">' . $last_click_info . '</div>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewBrandDetails(' . $brand_id . ')" title="' . esc_attr__('View Details', 'ams-wc-amazon') . '">
                                                                <i class="bi bi-eye"></i>
                                                            </button>
                                                            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="editBrand(' . $brand_id . ')" title="' . esc_attr__('Edit Brand', 'ams-wc-amazon') . '">
                                                                <i class="bi bi-pencil"></i>
                                                            </button>
                                                            <button type="button" class="btn btn-outline-danger btn-sm" onclick="resetBrandStats(' . $brand_id . ')" title="' . esc_attr__('Reset Stats', 'ams-wc-amazon') . '">
                                                                <i class="bi bi-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                  </tr>';
                                        }
                                    }
                                    
                                    echo '</tbody>
                                          </table>
                                          </div>
                                        </div>
                                        <div class="card-footer bg-light border-top-0">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <small class="text-muted">
                                                    <i class="bi bi-clock me-1"></i>' . esc_html__('Statistics update in real-time', 'ams-wc-amazon') . '
                                                </small>
                                                <small class="text-muted">
                                                    ' . sprintf(esc_html__('Last updated: %s', 'ams-wc-amazon'), date_i18n(get_option('date_format') . ' ' . get_option('time_format'))) . '
                                                </small>
                                            </div>
                                        </div>
                                      </div>
                                    </div>';
                                    
                                    echo '</div>'; // Close row
                                }
                                ?>
                            </div>

                            <!-- SEO Tools Tab -->
                            <div class="tab-pane fade" id="seo-tools" role="tabpanel">
                                <div class="row g-4">
                                    <!-- SEO Overview -->
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header bg-primary text-white">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-search me-2"></i><?= esc_html__('Brand SEO Optimization', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="row g-4">
                                                    <!-- Schema Markup -->
                                                    <div class="col-lg-6">
                                                        <div class="card h-100">
                                                            <div class="card-header bg-light">
                                                                <h6 class="mb-0">
                                                                    <i class="bi bi-code-square me-2 text-info"></i><?= esc_html__('Schema Markup', 'ams-wc-amazon'); ?>
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <p class="text-muted small mb-3"><?= esc_html__('Automatic schema markup is enabled for all brand pages to improve search engine visibility.', 'ams-wc-amazon'); ?></p>
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <span class="badge bg-success">
                                                                        <i class="bi bi-check-circle me-1"></i><?= esc_html__('Active', 'ams-wc-amazon'); ?>
                                                                    </span>
                                                                    <button type="button" class="btn btn-outline-info btn-sm" onclick="testSchemaMarkup()">
                                                                        <i class="bi bi-eye me-1"></i><?= esc_html__('Test Schema', 'ams-wc-amazon'); ?>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- Brand Sitemap -->
                                                    <div class="col-lg-6">
                                                        <div class="card h-100">
                                                            <div class="card-header bg-light">
                                                                <h6 class="mb-0">
                                                                    <i class="bi bi-diagram-3 me-2 text-warning"></i><?= esc_html__('Brand Sitemap', 'ams-wc-amazon'); ?>
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <p class="text-muted small mb-3"><?= esc_html__('Generate XML sitemap for all brand pages to help search engines discover your content.', 'ams-wc-amazon'); ?></p>
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <code class="small"><?= esc_url(home_url('?ams_brand_sitemap=1')); ?></code>
                                                                    <button type="button" class="btn btn-outline-warning btn-sm" onclick="generateSitemap()">
                                                                        <i class="bi bi-download me-1"></i><?= esc_html__('Generate', 'ams-wc-amazon'); ?>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Brand SEO Scores -->
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header bg-white border-bottom">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <h6 class="mb-0">
                                                        <i class="bi bi-speedometer2 me-2 text-success"></i><?= esc_html__('Brand SEO Scores', 'ams-wc-amazon'); ?>
                                                    </h6>
                                                    <button type="button" class="btn btn-outline-success btn-sm" onclick="refreshSEOScores()">
                                                        <i class="bi bi-arrow-clockwise me-1"></i><?= esc_html__('Refresh Scores', 'ams-wc-amazon'); ?>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div id="seoScoresContainer">
                                                    <div class="text-center py-4">
                                                        <div class="spinner-border text-primary" role="status">
                                                            <span class="visually-hidden"><?= esc_html__('Loading...', 'ams-wc-amazon'); ?></span>
                                                        </div>
                                                        <p class="text-muted mt-2"><?= esc_html__('Calculating SEO scores...', 'ams-wc-amazon'); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- SEO Recommendations -->
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header bg-light">
                                                <h6 class="mb-0">
                                                    <i class="bi bi-lightbulb me-2 text-warning"></i><?= esc_html__('SEO Recommendations', 'ams-wc-amazon'); ?>
                                                </h6>
                                            </div>
                                            <div class="card-body">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <div class="d-flex align-items-start">
                                                            <div class="me-3">
                                                                <i class="bi bi-check-circle text-success" style="font-size: 1.2rem;"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1"><?= esc_html__('Add Brand Descriptions', 'ams-wc-amazon'); ?></h6>
                                                                <p class="text-muted small mb-0"><?= esc_html__('Ensure all brands have detailed descriptions for better SEO.', 'ams-wc-amazon'); ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="d-flex align-items-start">
                                                            <div class="me-3">
                                                                <i class="bi bi-check-circle text-success" style="font-size: 1.2rem;"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1"><?= esc_html__('Upload Brand Logos', 'ams-wc-amazon'); ?></h6>
                                                                <p class="text-muted small mb-0"><?= esc_html__('Brand logos improve visual appeal and schema markup.', 'ams-wc-amazon'); ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="d-flex align-items-start">
                                                            <div class="me-3">
                                                                <i class="bi bi-check-circle text-success" style="font-size: 1.2rem;"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1"><?= esc_html__('Optimize URL Structure', 'ams-wc-amazon'); ?></h6>
                                                                <p class="text-muted small mb-0"><?= esc_html__('Use SEO-friendly URLs for brand pages.', 'ams-wc-amazon'); ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="d-flex align-items-start">
                                                            <div class="me-3">
                                                                <i class="bi bi-check-circle text-success" style="font-size: 1.2rem;"></i>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-1"><?= esc_html__('Monitor Performance', 'ams-wc-amazon'); ?></h6>
                                                                <p class="text-muted small mb-0"><?= esc_html__('Regularly check brand statistics and engagement metrics.', 'ams-wc-amazon'); ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Save Button -->
                        <div class="border-top pt-3 mt-4">
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    <?= esc_html__('Changes will be saved automatically when you click Save Changes.', 'ams-wc-amazon'); ?>
                                </small>
                                <button type="submit" class="btn btn-primary" id="saveChangesBtn">
                                    <i class="bi bi-floppy me-2"></i><?= esc_html__('Save Changes', 'ams-wc-amazon'); ?>
                                </button>
                            </div>
                        </div>
                    </form>

                    <?php
                    // Handle form submission and redirect to correct tab
                    if (isset($_POST['active_tab']) && !empty($_POST['active_tab'])) {
                        $active_tab = sanitize_text_field($_POST['active_tab']);
                        echo '<script>
                            if (window.location.search.indexOf("settings-updated=true") !== -1) {
                                const url = new URL(window.location);
                                url.searchParams.set("tab", "' . esc_js($active_tab) . '");
                                window.history.replaceState({}, "", url);
                            }
                        </script>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const cssEditor = document.getElementById('customCssEditor');
    const previewArea = document.getElementById('cssPreviewArea');
    const previewBtn = document.getElementById('previewCssBtn');
    const clearBtn = document.getElementById('clearCssBtn');
    const activeTabInput = document.getElementById('activeTabInput');
    const currentTemplateInput = document.getElementById('currentTemplateInput');
    
    // Handle tab persistence
    function initializeTabs() {
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = urlParams.get('tab') || 'module-activation';
        
        // Remove active classes from all tabs and panes
        document.querySelectorAll('.nav-link').forEach(tab => {
            tab.classList.remove('active');
            // Reset to inactive styling
            tab.classList.remove('bg-white', 'text-dark');
            tab.classList.add('bg-light', 'text-dark');
            // Update icon color to secondary
            const icon = tab.querySelector('i');
            if (icon) {
                icon.classList.remove('text-primary');
                icon.classList.add('text-secondary');
            }
        });
        document.querySelectorAll('.tab-pane').forEach(pane => {
            pane.classList.remove('show', 'active');
        });
        
        // Activate the correct tab
        const targetTab = document.querySelector(`[data-bs-target="#${activeTab}"]`);
        const targetPane = document.getElementById(activeTab);
        
        if (targetTab && targetPane) {
            targetTab.classList.add('active');
            // Apply active styling
            targetTab.classList.remove('bg-light');
            targetTab.classList.add('bg-white', 'text-dark');
            // Update icon color to primary
            const icon = targetTab.querySelector('i');
            if (icon) {
                icon.classList.remove('text-secondary');
                icon.classList.add('text-primary');
            }
            targetPane.classList.add('show', 'active');
            activeTabInput.value = activeTab;
        }
    }
    
    // Update active tab when clicking tabs
    document.querySelectorAll('[data-bs-toggle="tab"]').forEach(tab => {
        tab.addEventListener('click', function() {
            const target = this.getAttribute('data-bs-target').replace('#', '');
            activeTabInput.value = target;
            
            // Update styling for all tabs
            document.querySelectorAll('.nav-link').forEach(t => {
                t.classList.remove('active', 'bg-white');
                t.classList.add('bg-light');
                const icon = t.querySelector('i');
                if (icon) {
                    icon.classList.remove('text-primary');
                    icon.classList.add('text-secondary');
                }
            });
            
            // Apply active styling to clicked tab
            this.classList.add('active', 'bg-white');
            this.classList.remove('bg-light');
            const activeIcon = this.querySelector('i');
            if (activeIcon) {
                activeIcon.classList.remove('text-secondary');
                activeIcon.classList.add('text-primary');
            }
            
            // Update URL without page reload
            const url = new URL(window.location);
            url.searchParams.set('tab', target);
            window.history.replaceState({}, '', url);
        });
    });
    
    // Initialize tabs on page load
    initializeTabs();
    
    // Show current template status
    function updateTemplateStatus() {
        const currentTemplate = currentTemplateInput.value;
        document.querySelectorAll('.css-template-card').forEach(card => {
            const btn = card.querySelector('button');
            const template = card.dataset.template;
            
            if (template === currentTemplate) {
                btn.textContent = '<?= esc_html__('Current', 'ams-wc-amazon'); ?>';
                btn.classList.remove('btn-outline-primary');
                btn.classList.add('btn-success');
                card.style.borderColor = '#198754';
                card.style.backgroundColor = '#f8fff9';
            } else {
                btn.textContent = '<?= esc_html__('Use', 'ams-wc-amazon'); ?>';
                btn.classList.remove('btn-success');
                btn.classList.add('btn-outline-primary');
                card.style.borderColor = '';
                card.style.backgroundColor = '';
            }
        });
    }
    
    // Initialize template status
    updateTemplateStatus();
    
    // CSS Templates - Modern, Minimalist, Theme-Agnostic
    const cssTemplates = {
        'minimal-modern': `/* Minimal Modern - Ultra clean with perfect spacing */
.ams-brand-container {
    margin: 2rem 0 !important;
}

.ams-brand-grid {
    gap: 1.5rem !important;
}

.ams-brand-item {
    background: #ffffff !important;
    border: 1px solid rgba(0,0,0,0.08) !important;
    border-radius: 8px !important;
    padding: 1.5rem !important;
    text-align: center !important;
    transition: all 0.2s ease !important;
    position: relative !important;
    overflow: hidden !important;
}

.ams-brand-item:hover {
    border-color: rgba(0,0,0,0.12) !important;
    transform: translateY(-2px) !important;
}

.ams-brand-name {
    font-size: 0.95rem !important;
    font-weight: 500 !important;
    color: #1a1a1a !important;
    margin: 0.75rem 0 0.25rem 0 !important;
    line-height: 1.3 !important;
}

.ams-brand-count {
    font-size: 0.8rem !important;
    color: #666666 !important;
    margin: 0 !important;
    font-weight: 400 !important;
}`,

        'soft-cards': `/* Soft Cards - Gentle shadows and rounded design */
.ams-brand-container {
    margin: 2rem 0 !important;
}

.ams-brand-grid {
    gap: 2rem !important;
}

.ams-brand-item {
    background: #ffffff !important;
    border: none !important;
    border-radius: 16px !important;
    padding: 2rem 1.5rem !important;
    text-align: center !important;
    box-shadow: 0 2px 12px rgba(0,0,0,0.04) !important;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
    position: relative !important;
}

.ams-brand-item:hover {
    box-shadow: 0 8px 24px rgba(0,0,0,0.08) !important;
    transform: translateY(-4px) !important;
}

.ams-brand-name {
    font-size: 1rem !important;
    font-weight: 600 !important;
    color: #2d3748 !important;
    margin: 1rem 0 0.5rem 0 !important;
    line-height: 1.4 !important;
}

.ams-brand-count {
    font-size: 0.85rem !important;
    color: #718096 !important;
    margin: 0 !important;
    font-weight: 400 !important;
}`,

        'clean-grid': `/* Clean Grid - Simple and functional */
.ams-brand-container {
    margin: 1.5rem 0 !important;
}

.ams-brand-grid {
    gap: 1rem !important;
}

.ams-brand-item {
    background: transparent !important;
    border: 1px solid #e2e8f0 !important;
    border-radius: 4px !important;
    padding: 1.25rem !important;
    text-align: center !important;
    transition: border-color 0.2s ease !important;
    position: relative !important;
}

.ams-brand-item:hover {
    border-color: #cbd5e0 !important;
    background: #f7fafc !important;
}

.ams-brand-name {
    font-size: 0.9rem !important;
    font-weight: 500 !important;
    color: #2d3748 !important;
    margin: 0.75rem 0 0.25rem 0 !important;
    line-height: 1.3 !important;
}

.ams-brand-count {
    font-size: 0.75rem !important;
    color: #a0aec0 !important;
    margin: 0 !important;
    font-weight: 400 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.05em !important;
}`,

        'elegant-borders': `/* Elegant Borders - Refined with subtle highlights */
.ams-brand-container {
    margin: 2rem 0 !important;
}

.ams-brand-grid {
    gap: 1.75rem !important;
}

.ams-brand-item {
    background: #ffffff !important;
    border: 2px solid #f1f5f9 !important;
    border-radius: 12px !important;
    padding: 1.75rem 1.5rem !important;
    text-align: center !important;
    transition: all 0.25s ease !important;
    position: relative !important;
}

.ams-brand-item:hover {
    border-color: #e2e8f0 !important;
    box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.05) !important;
}

.ams-brand-item::before {
    content: '' !important;
    position: absolute !important;
    top: 0 !important;
    left: 0 !important;
    right: 0 !important;
    height: 3px !important;
    background: linear-gradient(90deg, #3b82f6, #8b5cf6) !important;
    border-radius: 12px 12px 0 0 !important;
    opacity: 0 !important;
    transition: opacity 0.25s ease !important;
}

.ams-brand-item:hover::before {
    opacity: 1 !important;
}

.ams-brand-name {
    font-size: 1rem !important;
    font-weight: 600 !important;
    color: #1e293b !important;
    margin: 1rem 0 0.5rem 0 !important;
    line-height: 1.4 !important;
}

.ams-brand-count {
    font-size: 0.8rem !important;
    color: #64748b !important;
    margin: 0 !important;
    font-weight: 500 !important;
}`,

        'floating-cards': `/* Floating Cards - Elevated with smooth animations */
.ams-brand-container {
    margin: 2.5rem 0 !important;
}

.ams-brand-grid {
    gap: 2.5rem !important;
}

.ams-brand-item {
    background: #ffffff !important;
    border: none !important;
    border-radius: 20px !important;
    padding: 2.5rem 2rem !important;
    text-align: center !important;
    box-shadow: 0 4px 20px rgba(0,0,0,0.06) !important;
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275) !important;
    position: relative !important;
    transform: translateY(0) !important;
}

.ams-brand-item:hover {
    box-shadow: 0 12px 40px rgba(0,0,0,0.12) !important;
    transform: translateY(-8px) scale(1.02) !important;
}

.ams-brand-name {
    font-size: 1.1rem !important;
    font-weight: 600 !important;
    color: #1a202c !important;
    margin: 1.25rem 0 0.75rem 0 !important;
    line-height: 1.3 !important;
}

.ams-brand-count {
    font-size: 0.85rem !important;
    color: #718096 !important;
    margin: 0 !important;
    font-weight: 500 !important;
    padding: 0.25rem 0.75rem !important;
    background: #f7fafc !important;
    border-radius: 12px !important;
    display: inline-block !important;
}`,

        'monochrome': `/* Monochrome - Pure black and white minimalism */
.ams-brand-container {
    margin: 2rem 0 !important;
}

.ams-brand-grid {
    gap: 1px !important;
    background: #000000 !important;
    padding: 1px !important;
}

.ams-brand-item {
    background: #ffffff !important;
    border: none !important;
    border-radius: 0 !important;
    padding: 2rem 1.5rem !important;
    text-align: center !important;
    transition: all 0.2s ease !important;
    position: relative !important;
}

.ams-brand-item:hover {
    background: #000000 !important;
    color: #ffffff !important;
}

.ams-brand-item:hover .ams-brand-name {
    color: #ffffff !important;
}

.ams-brand-item:hover .ams-brand-count {
    color: #cccccc !important;
}

.ams-brand-name {
    font-size: 1rem !important;
    font-weight: 700 !important;
    color: #000000 !important;
    margin: 1rem 0 0.5rem 0 !important;
    line-height: 1.2 !important;
    text-transform: uppercase !important;
    letter-spacing: 0.1em !important;
    transition: color 0.2s ease !important;
}

.ams-brand-count {
    font-size: 0.75rem !important;
    color: #666666 !important;
    margin: 0 !important;
    font-weight: 400 !important;
    transition: color 0.2s ease !important;
}`
    };

    // Quick Actions CSS - Modern and Theme-Agnostic
    const quickActions = {
        'add-shadows': `
/* Subtle Modern Shadows */
.ams-brand-item {
    box-shadow: 0 1px 3px rgba(0,0,0,0.06), 0 1px 2px rgba(0,0,0,0.04) !important;
    border-radius: 8px !important;
    transition: box-shadow 0.2s ease !important;
}

.ams-brand-item:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.08), 0 2px 4px rgba(0,0,0,0.06) !important;
}`,
        'hover-effects': `
/* Smooth Hover Animations */
.ams-brand-item {
    transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1) !important;
    transform: translateY(0) !important;
}

.ams-brand-item:hover {
    transform: translateY(-3px) !important;
}`,
        'custom-spacing': `
/* Optimized Spacing */
.ams-brand-container {
    margin: 2rem 0 !important;
}

.ams-brand-grid {
    gap: 2rem !important;
}

.ams-brand-item {
    padding: 1.75rem !important;
}`,
        'typography': `
/* Clean Typography */
.ams-brand-name {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif !important;
    font-size: 1rem !important;
    font-weight: 600 !important;
    color: #1a202c !important;
    margin: 1rem 0 0.5rem 0 !important;
    line-height: 1.4 !important;
}

.ams-brand-count {
    font-size: 0.85rem !important;
    color: #718096 !important;
    font-weight: 500 !important;
    margin: 0 !important;
}`,
        'rounded-corners': `
/* Rounded Corners */
.ams-brand-item {
    border-radius: 16px !important;
    overflow: hidden !important;
}

.ams-brand-item img {
    border-radius: 12px !important;
}`,
        'color-accents': `
/* Subtle Color Accents */
.ams-brand-item {
    border-left: 3px solid transparent !important;
    transition: all 0.25s ease !important;
}

.ams-brand-item:hover {
    border-left-color: #3b82f6 !important;
    background: linear-gradient(90deg, rgba(59, 130, 246, 0.02), transparent) !important;
}

.ams-brand-count {
    color: #3b82f6 !important;
    font-weight: 600 !important;
}`
    };

    // Template selection
    document.querySelectorAll('.css-template-card').forEach(card => {
        card.addEventListener('click', function() {
            const template = this.dataset.template;
            if (cssTemplates[template]) {
                cssEditor.value = cssTemplates[template];
                currentTemplateInput.value = template;
                
                // Update template status immediately
                updateTemplateStatus();
                
                // Show success feedback
                const btn = this.querySelector('button');
                btn.textContent = '<?= esc_html__('Applied!', 'ams-wc-amazon'); ?>';
                btn.classList.remove('btn-outline-primary', 'btn-success');
                btn.classList.add('btn-warning');
                
                setTimeout(() => {
                    updateTemplateStatus();
                }, 1500);
            }
        });
    });

    // Quick actions
    document.querySelectorAll('.css-quick-action').forEach(btn => {
        btn.addEventListener('click', function() {
            const action = this.dataset.action;
            if (quickActions[action]) {
                // Append to existing CSS
                const currentCSS = cssEditor.value.trim();
                const newCSS = currentCSS ? currentCSS + '\n\n' + quickActions[action] : quickActions[action];
                cssEditor.value = newCSS;
                
                // Show feedback
                const originalText = this.textContent;
                this.textContent = '<?= esc_html__('Added!', 'ams-wc-amazon'); ?>';
                this.classList.remove('btn-outline-info');
                this.classList.add('btn-success');
                
                setTimeout(() => {
                    this.textContent = originalText;
                    this.classList.remove('btn-success');
                    this.classList.add('btn-outline-info');
                }, 1500);
            }
        });
    });

    // Preview functionality
    previewBtn.addEventListener('click', function() {
        const css = cssEditor.value.trim();
        
        if (css) {
            // Remove existing preview styles
            const existingStyle = document.getElementById('brand-preview-styles');
            if (existingStyle) {
                existingStyle.remove();
            }
            
            // Add new styles
            const styleElement = document.createElement('style');
            styleElement.id = 'brand-preview-styles';
            styleElement.textContent = css;
            document.head.appendChild(styleElement);
            
            // Show preview area
            previewArea.classList.remove('d-none');
            
            // Update button text
            this.textContent = '<?= esc_html__('Preview Updated', 'ams-wc-amazon'); ?>';
            this.classList.remove('btn-outline-info');
            this.classList.add('btn-success');
            
            setTimeout(() => {
                this.textContent = '<?= esc_html__('Preview', 'ams-wc-amazon'); ?>';
                this.classList.remove('btn-success');
                this.classList.add('btn-outline-info');
            }, 2000);
        } else {
            previewArea.classList.add('d-none');
        }
    });

    // Clear functionality
    clearBtn.addEventListener('click', function() {
        if (confirm('<?= esc_html__('Are you sure you want to clear all CSS?', 'ams-wc-amazon'); ?>')) {
            cssEditor.value = '';
            previewArea.classList.add('d-none');
            
            // Remove preview styles
            const existingStyle = document.getElementById('brand-preview-styles');
            if (existingStyle) {
                existingStyle.remove();
            }
        }
    });

    // Auto-hide preview when CSS is empty
    cssEditor.addEventListener('input', function() {
        if (!this.value.trim()) {
            previewArea.classList.add('d-none');
        }
    });

    // Handle form submission with tab persistence
    document.getElementById('brandSettingsForm').addEventListener('submit', function() {
        // Update the active tab input before submission
        const currentActiveTab = document.querySelector('.nav-link.active')?.getAttribute('data-bs-target')?.replace('#', '') || 'module-activation';
        activeTabInput.value = currentActiveTab;
        
        // Add tab parameter to form action
        const form = this;
        const originalAction = form.action;
        const separator = originalAction.includes('?') ? '&' : '?';
        form.action = originalAction + separator + 'tab=' + encodeURIComponent(currentActiveTab);
    });

    // Handle "Fix Counts" button
    const refreshBrandCountsBtn = document.getElementById('refreshBrandCounts');
    if (refreshBrandCountsBtn) {
        refreshBrandCountsBtn.addEventListener('click', function() {
            const btn = this;
            const originalText = btn.innerHTML;
            
            // Show loading state
            btn.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i><?= esc_html__('Fixing...', 'ams-wc-amazon'); ?>';
            btn.disabled = true;
            
            // Make AJAX request
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ams_refresh_brand_counts',
                    nonce: '<?= wp_create_nonce('ams_refresh_brand_counts'); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Show success
                    btn.innerHTML = '<i class="bi bi-check-circle me-1"></i><?= esc_html__('Fixed!', 'ams-wc-amazon'); ?>';
                    btn.classList.remove('btn-outline-info');
                    btn.classList.add('btn-success');
                    
                    // Show toast notification
                    if (typeof showToast === 'function') {
                        showToast('Brand counts updated successfully!', 'success');
                    }
                    
                    setTimeout(() => {
                        btn.innerHTML = originalText;
                        btn.classList.remove('btn-success');
                        btn.classList.add('btn-outline-info');
                        btn.disabled = false;
                    }, 3000);
                } else {
                    // Show error
                    btn.innerHTML = '<i class="bi bi-exclamation-circle me-1"></i><?= esc_html__('Error', 'ams-wc-amazon'); ?>';
                    btn.classList.remove('btn-outline-info');
                    btn.classList.add('btn-danger');
                    
                    setTimeout(() => {
                        btn.innerHTML = originalText;
                        btn.classList.remove('btn-danger');
                        btn.classList.add('btn-outline-info');
                        btn.disabled = false;
                    }, 3000);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
        });
    }

    // Handle brand search functionality
    const brandSearch = document.getElementById('brandSearch');
    const searchBtn = document.getElementById('searchBtn');
    
    if (brandSearch && searchBtn) {
        function performSearch() {
            const searchTerm = brandSearch.value.toLowerCase().trim();
            const tableRows = document.querySelectorAll('.brand-row');
            
            tableRows.forEach(row => {
                const brandName = row.querySelector('a').textContent.toLowerCase();
                if (searchTerm === '' || brandName.includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
            
            // Update visible count
            const visibleRows = document.querySelectorAll('.brand-row[style=""], .brand-row:not([style*="display: none"])');
            const totalRows = tableRows.length;
            
            // Show/hide no results message
            let noResultsMsg = document.getElementById('noResultsMessage');
            if (visibleRows.length === 0 && searchTerm !== '') {
                if (!noResultsMsg) {
                    noResultsMsg = document.createElement('tr');
                    noResultsMsg.id = 'noResultsMessage';
                    noResultsMsg.innerHTML = '<td colspan="8" class="text-center py-4 text-muted"><i class="bi bi-search me-2"></i><?= esc_html__('No brands found matching your search.', 'ams-wc-amazon'); ?></td>';
                    document.querySelector('.table-enhanced tbody').appendChild(noResultsMsg);
                }
                noResultsMsg.style.display = '';
            } else if (noResultsMsg) {
                noResultsMsg.style.display = 'none';
            }
        }
        
        searchBtn.addEventListener('click', performSearch);
        brandSearch.addEventListener('keyup', function(e) {
            if (e.key === 'Enter') {
                performSearch();
            } else {
                // Real-time search with debounce
                clearTimeout(this.searchTimeout);
                this.searchTimeout = setTimeout(performSearch, 300);
            }
        });
        
        // Clear search
        brandSearch.addEventListener('input', function() {
            if (this.value === '') {
                performSearch();
            }
        });
    }

    // Handle "Auto Create Brands Page" functionality
    const createBrandsPageBtn = document.getElementById('createBrandsPage');
    const recreateBrandsPageBtn = document.getElementById('recreateBrandsPage');
    
    function handleCreateBrandsPage(isRecreate = false) {
        const btn = isRecreate ? recreateBrandsPageBtn : createBrandsPageBtn;
        if (!btn) return;
        
        const originalText = btn.innerHTML;
        const pageTitle = document.getElementById('brandsPageTitle')?.value || '<?= esc_js(__('Our Brands', 'ams-wc-amazon')); ?>';
        const pageSlug = document.getElementById('brandsPageSlug')?.value || 'brands';
        const addToMenu = document.getElementById('addToMenu')?.checked || false;
        const targetMenu = document.getElementById('targetMenu')?.value || 'auto';
        
        // Show loading state
        btn.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i><?= esc_js(__('Creating...', 'ams-wc-amazon')); ?>';
        btn.disabled = true;
        
        // Make AJAX request
        fetch(ajaxurl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                action: 'ams_create_brands_page',
                nonce: '<?= wp_create_nonce('create_brands_page'); ?>',
                page_title: pageTitle,
                page_slug: pageSlug,
                add_to_menu: addToMenu ? '1' : '0',
                target_menu: targetMenu,
                recreate: isRecreate ? '1' : '0'
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success state
                btn.innerHTML = '<i class="bi bi-check-circle me-1"></i><?= esc_js(__('Created!', 'ams-wc-amazon')); ?>';
                btn.classList.remove('btn-primary', 'btn-outline-danger');
                btn.classList.add('btn-success');
                
                // Show toast notification
                if (typeof showToast === 'function') {
                    showToast(data.data.message, 'success');
                }
                
                // Reload page after 2 seconds to show the success state
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                // Show error state
                btn.innerHTML = '<i class="bi bi-exclamation-circle me-1"></i><?= esc_js(__('Error', 'ams-wc-amazon')); ?>';
                btn.classList.remove('btn-primary', 'btn-outline-danger');
                btn.classList.add('btn-danger');
                
                // Show error message
                if (typeof showToast === 'function') {
                    showToast(data.data || '<?= esc_js(__('Failed to create page', 'ams-wc-amazon')); ?>', 'error');
                } else {
                    alert(data.data || '<?= esc_js(__('Failed to create page', 'ams-wc-amazon')); ?>');
                }
                
                // Reset button after 3 seconds
                setTimeout(() => {
                    btn.innerHTML = originalText;
                    btn.classList.remove('btn-danger');
                    btn.classList.add(isRecreate ? 'btn-outline-danger' : 'btn-primary');
                    btn.disabled = false;
                }, 3000);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            btn.innerHTML = originalText;
            btn.disabled = false;
            
            if (typeof showToast === 'function') {
                showToast('<?= esc_js(__('Network error occurred', 'ams-wc-amazon')); ?>', 'error');
            } else {
                alert('<?= esc_js(__('Network error occurred', 'ams-wc-amazon')); ?>');
            }
        });
    }
    
    if (createBrandsPageBtn) {
        createBrandsPageBtn.addEventListener('click', () => handleCreateBrandsPage(false));
    }
    
    if (recreateBrandsPageBtn) {
        recreateBrandsPageBtn.addEventListener('click', function() {
            if (confirm('<?= esc_js(__('Are you sure you want to recreate the brands page? This will replace the existing page.', 'ams-wc-amazon')); ?>')) {
                handleCreateBrandsPage(true);
            }
        });
    }
    
    // Handle menu selection toggle
    const addToMenuCheckbox = document.getElementById('addToMenu');
    const targetMenuSelect = document.getElementById('targetMenu');
    
    if (addToMenuCheckbox && targetMenuSelect) {
        addToMenuCheckbox.addEventListener('change', function() {
            if (this.checked) {
                targetMenuSelect.style.display = 'block';
            } else {
                targetMenuSelect.style.display = 'none';
            }
        });
        
        // Show menu selector if checkbox is initially checked
        if (addToMenuCheckbox.checked) {
            targetMenuSelect.style.display = 'block';
        }
    }

    // Handle "Reset Statistics" button
    const resetBrandStatsBtn = document.getElementById('resetBrandStats');
    if (resetBrandStatsBtn) {
        resetBrandStatsBtn.addEventListener('click', function() {
            if (confirm('<?= esc_html__('Are you sure you want to reset all brand statistics? This action cannot be undone.', 'ams-wc-amazon'); ?>')) {
                const btn = this;
                const originalText = btn.innerHTML;
                
                // Show loading state
                btn.innerHTML = '<i class="bi bi-arrow-repeat spin me-1"></i><?= esc_html__('Resetting...', 'ams-wc-amazon'); ?>';
                btn.disabled = true;
                
                // Make AJAX request
                fetch(ajaxurl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        action: 'ams_reset_stats',
                        nonce: '<?= wp_create_nonce('reset_brand_stats'); ?>'
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Show success and reload page
                        btn.innerHTML = '<i class="bi bi-check-circle me-1"></i><?= esc_html__('Reset!', 'ams-wc-amazon'); ?>';
                        btn.classList.remove('btn-outline-danger');
                        btn.classList.add('btn-success');
                        
                        // Show toast notification
                        if (typeof showToast === 'function') {
                            showToast('Brand statistics reset successfully!', 'success');
                        }
                        
                        setTimeout(() => {
                            window.location.reload();
                        }, 1500);
                    } else {
                        // Show error
                        btn.innerHTML = '<i class="bi bi-exclamation-circle me-1"></i><?= esc_html__('Error', 'ams-wc-amazon'); ?>';
                        btn.classList.remove('btn-outline-danger');
                        btn.classList.add('btn-danger');
                        
                        setTimeout(() => {
                            btn.innerHTML = originalText;
                            btn.classList.remove('btn-danger');
                            btn.classList.add('btn-outline-danger');
                            btn.disabled = false;
                        }, 3000);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });
            }
        });
    }
});
</script>

<style>
.css-template-card {
    transition: all 0.2s ease;
    cursor: pointer;
}

.css-template-card:hover {
    border-color: #007cba !important;
    background-color: #f8f9fa;
}

.cursor-pointer {
    cursor: pointer;
}

#cssPreviewArea {
    max-height: 300px;
    overflow-y: auto;
}

#customCssEditor {
    font-family: 'Courier New', Consolas, monospace;
    font-size: 13px;
    line-height: 1.4;
}

.spin {
    animation: spin 1s linear infinite;
}

/* Enhanced Statistics UI */
.stats-summary-card {
    transition: all 0.3s ease;
    border: none !important;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.stats-summary-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0,0,0,0.12);
}

.stats-summary-card .card-body {
    padding: 1.5rem;
}

.stats-icon-wrapper {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    transition: all 0.3s ease;
}

.stats-summary-card:hover .stats-icon-wrapper {
    transform: scale(1.1);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 0.25rem;
}

.activity-indicator {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 0.5rem;
    animation: pulse 2s infinite;
}

.activity-indicator.recent {
    background-color: #28a745;
    box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
}

.activity-indicator.moderate {
    background-color: #ffc107;
    box-shadow: 0 0 0 0 rgba(255, 193, 7, 0.7);
}

.activity-indicator.old {
    background-color: #6c757d;
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
    }
    70% {
        box-shadow: 0 0 0 10px rgba(40, 167, 69, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);
    }
}

.performance-bar {
    height: 8px;
    border-radius: 4px;
    background-color: #e9ecef;
    overflow: hidden;
    position: relative;
}

.performance-bar .progress-bar {
    border-radius: 4px;
    transition: width 1s ease-in-out;
    background: linear-gradient(90deg, #007bff 0%, #0056b3 100%);
}

.brand-row {
    transition: all 0.2s ease;
}

.brand-row:hover {
    background-color: rgba(0, 123, 255, 0.05) !important;
}

.brand-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, rgba(0, 123, 255, 0.1) 0%, rgba(0, 123, 255, 0.2) 100%);
    transition: all 0.3s ease;
}

.brand-row:hover .brand-icon {
    transform: scale(1.1);
    background: linear-gradient(135deg, rgba(0, 123, 255, 0.2) 0%, rgba(0, 123, 255, 0.3) 100%);
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% {
        transform: translateY(0px);
    }
    50% {
        transform: translateY(-10px);
    }
}

.stats-card-enhanced {
    border: none;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.stats-card-enhanced:hover {
    box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

.table-enhanced {
    border-radius: 8px;
    overflow: hidden;
}

.table-enhanced thead th {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-enhanced tbody tr {
    border: none;
}

.table-enhanced tbody td {
    padding: 1rem;
    border-top: 1px solid #f1f3f4;
    vertical-align: middle;
}

.click-badge {
    font-size: 0.875rem;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    border: none;
    box-shadow: 0 2px 8px rgba(0, 123, 255, 0.3);
}

.reset-btn-enhanced {
    border-radius: 8px;
    padding: 0.5rem 1rem;
    font-weight: 500;
    transition: all 0.3s ease;
    border: 2px solid #dc3545;
    background: transparent;
    color: #dc3545;
}

.reset-btn-enhanced:hover {
    background: #dc3545;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
}

/* Enhanced table column styling */
.table-enhanced th {
    white-space: nowrap;
    font-size: 0.8rem;
}

.table-enhanced .brand-row td {
    vertical-align: middle;
}

.table-enhanced .brand-row a {
    color: #007bff;
    transition: color 0.2s ease;
}

.table-enhanced .brand-row a:hover {
    color: #0056b3;
}

/* Column-specific badges */
.table-enhanced .badge {
    font-size: 0.75rem;
    font-weight: 500;
    min-width: 30px;
}

/* Search input styling */
.input-group .form-control-sm {
    border-radius: 6px 0 0 6px;
}

.input-group .btn-sm {
    border-radius: 0 6px 6px 0;
    border-left: none;
}

/* Responsive table improvements */
@media (max-width: 768px) {
    .table-enhanced th,
    .table-enhanced td {
        padding: 0.5rem 0.25rem;
        font-size: 0.75rem;
    }
    
    .brand-icon {
        width: 32px;
        height: 32px;
    }
    
    .stats-icon-wrapper {
        width: 40px;
        height: 40px;
    }
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Sortable column styling */
.sortable {
    cursor: pointer;
    user-select: none;
    transition: background-color 0.2s ease;
}

.sortable:hover {
    background-color: rgba(0, 123, 255, 0.1);
}

.sortable.sort-asc i::before {
    content: "\f148"; /* bi-arrow-up */
    color: #007bff;
}

.sortable.sort-desc i::before {
    content: "\f149"; /* bi-arrow-down */
    color: #007bff;
}

/* Chart container styling */
.chart-container {
    position: relative;
    height: 240px;
    margin: 1rem 0;
}

/* Ensure charts don't get too large */
#clickTrendsChart, #deviceChart {
    max-height: 300px !important;
}

/* Performance insights styling */
.insight-card {
    border-left: 4px solid #007bff;
    background: linear-gradient(135deg, rgba(0, 123, 255, 0.05) 0%, rgba(0, 123, 255, 0.02) 100%);
    transition: all 0.3s ease;
}

.insight-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.insight-card.warning {
    border-left-color: #ffc107;
    background: linear-gradient(135deg, rgba(255, 193, 7, 0.05) 0%, rgba(255, 193, 7, 0.02) 100%);
}

.insight-card.success {
    border-left-color: #28a745;
    background: linear-gradient(135deg, rgba(40, 167, 69, 0.05) 0%, rgba(40, 167, 69, 0.02) 100%);
}

.insight-card.danger {
    border-left-color: #dc3545;
    background: linear-gradient(135deg, rgba(220, 53, 69, 0.05) 0%, rgba(220, 53, 69, 0.02) 100%);
}
</style>

<!-- Chart.js Library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Enhanced Brand Analytics JavaScript
    
    // Global variables
    let clickTrendsChart = null;
    let deviceChart = null;
    let currentSortColumn = 'total';
    let currentSortDirection = 'desc';
    
    // Initialize all functionality
    initializeCharts();
    initializeTableSorting();
    initializeBulkActions();
    initializePerformanceInsights();
    initializeRealTimeUpdates();
    
    // Chart initialization
    function initializeCharts() {
        // Prepare data from PHP
        const hourlyData = <?php echo json_encode(array_values($hourly_stats)); ?>;
        const deviceData = <?php echo json_encode(array_values($device_stats)); ?>;
        const dailyData = <?php 
            $last_7_days = array();
            for ($i = 6; $i >= 0; $i--) {
                $date = date('Y-m-d', strtotime("-$i days"));
                $last_7_days[] = isset($daily_stats[$date]) ? $daily_stats[$date] : 0;
            }
            echo json_encode($last_7_days);
        ?>;
        
        // Click Trends Chart
        const trendsCtx = document.getElementById('clickTrendsChart');
        if (trendsCtx) {
            clickTrendsChart = new Chart(trendsCtx, {
                type: 'line',
                data: {
                    labels: Array.from({length: 24}, (_, i) => i + ':00'),
                    datasets: [{
                        label: '<?= esc_js(__('Clicks', 'ams-wc-amazon')); ?>',
                        data: hourlyData,
                        borderColor: '#007bff',
                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.1)'
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        }
        
        // Device Chart
        const deviceCtx = document.getElementById('deviceChart');
        if (deviceCtx) {
            deviceChart = new Chart(deviceCtx, {
                type: 'doughnut',
                data: {
                    labels: ['<?= esc_js(__('Desktop', 'ams-wc-amazon')); ?>', '<?= esc_js(__('Mobile', 'ams-wc-amazon')); ?>', '<?= esc_js(__('Tablet', 'ams-wc-amazon')); ?>'],
                    datasets: [{
                        data: deviceData,
                        backgroundColor: ['#007bff', '#28a745', '#ffc107'],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 20,
                                usePointStyle: true
                            }
                        }
                    }
                }
            });
        }
        
        // Chart period toggle
        document.querySelectorAll('input[name="chartPeriod"]').forEach(radio => {
            radio.addEventListener('change', function() {
                updateTrendsChart(this.value);
            });
        });
    }
    
    function updateTrendsChart(period) {
        if (!clickTrendsChart) return;
        
        if (period === 'daily') {
            clickTrendsChart.data.labels = ['6d ago', '5d ago', '4d ago', '3d ago', '2d ago', '1d ago', 'Today'];
            clickTrendsChart.data.datasets[0].data = <?php echo json_encode($last_7_days); ?>;
        } else {
            clickTrendsChart.data.labels = Array.from({length: 24}, (_, i) => i + ':00');
            clickTrendsChart.data.datasets[0].data = <?php echo json_encode(array_values($hourly_stats)); ?>;
        }
        clickTrendsChart.update();
    }
    
    // Table sorting functionality
    function initializeTableSorting() {
        document.querySelectorAll('.sortable').forEach(header => {
            header.addEventListener('click', function() {
                const column = this.dataset.sort;
                
                // Update sort direction
                if (currentSortColumn === column) {
                    currentSortDirection = currentSortDirection === 'asc' ? 'desc' : 'asc';
                } else {
                    currentSortColumn = column;
                    currentSortDirection = 'desc';
                }
                
                // Update UI
                document.querySelectorAll('.sortable').forEach(h => {
                    h.classList.remove('sort-asc', 'sort-desc');
                });
                this.classList.add('sort-' + currentSortDirection);
                
                // Sort table
                sortTable(column, currentSortDirection);
            });
        });
    }
    
    function sortTable(column, direction) {
        const tbody = document.querySelector('#brandStatsTable tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        
        rows.sort((a, b) => {
            let aVal, bVal;
            
            if (column === 'name') {
                aVal = a.dataset.brandName.toLowerCase();
                bVal = b.dataset.brandName.toLowerCase();
                return direction === 'asc' ? aVal.localeCompare(bVal) : bVal.localeCompare(aVal);
            } else {
                const aCell = a.querySelector(`td:nth-child(${getColumnIndex(column)})`);
                const bCell = b.querySelector(`td:nth-child(${getColumnIndex(column)})`);
                aVal = parseInt(aCell.textContent.replace(/[^0-9]/g, '')) || 0;
                bVal = parseInt(bCell.textContent.replace(/[^0-9]/g, '')) || 0;
                return direction === 'asc' ? aVal - bVal : bVal - aVal;
            }
        });
        
        // Reorder DOM
        rows.forEach(row => tbody.appendChild(row));
    }
    
    function getColumnIndex(column) {
        const columns = {
            'name': 2,
            'total': 3,
            'shop': 4,
            'category': 5,
            'product': 6,
            'brand_page': 7,
            'products': 8
        };
        return columns[column] || 2;
    }
    
    // Bulk actions functionality
    function initializeBulkActions() {
        // Select all checkbox
        const selectAllCheckbox = document.getElementById('selectAllBrands');
        if (selectAllCheckbox) {
            selectAllCheckbox.addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('.brand-checkbox');
                checkboxes.forEach(cb => cb.checked = this.checked);
                updateBulkActionsState();
            });
        }
        
        // Individual checkboxes
        document.addEventListener('change', function(e) {
            if (e.target.classList.contains('brand-checkbox')) {
                updateBulkActionsState();
            }
        });
        
        // Bulk export CSV
        const exportCSVBtn = document.getElementById('bulkExportCSV');
        if (exportCSVBtn) {
            exportCSVBtn.addEventListener('click', function(e) {
                e.preventDefault();
                exportToCSV();
            });
        }
        
        // Bulk export Excel
        const exportExcelBtn = document.getElementById('bulkExportExcel');
        if (exportExcelBtn) {
            exportExcelBtn.addEventListener('click', function(e) {
                e.preventDefault();
                exportToExcel();
            });
        }
        
        // Bulk reset selected
        const bulkResetBtn = document.getElementById('bulkResetSelected');
        if (bulkResetBtn) {
            bulkResetBtn.addEventListener('click', function(e) {
                e.preventDefault();
                resetSelectedBrands();
            });
        }
    }
    
    function updateBulkActionsState() {
        const selectedCount = document.querySelectorAll('.brand-checkbox:checked').length;
        const bulkActionsBtn = document.getElementById('bulkActionsDropdown');
        
        if (bulkActionsBtn) {
            if (selectedCount > 0) {
                bulkActionsBtn.textContent = `<?= esc_js(__('Bulk Actions', 'ams-wc-amazon')); ?> (${selectedCount})`;
                bulkActionsBtn.classList.remove('btn-outline-primary');
                bulkActionsBtn.classList.add('btn-primary');
            } else {
                bulkActionsBtn.innerHTML = '<i class="bi bi-gear me-1"></i><?= esc_js(__('Bulk Actions', 'ams-wc-amazon')); ?>';
                bulkActionsBtn.classList.remove('btn-primary');
                bulkActionsBtn.classList.add('btn-outline-primary');
            }
        }
    }
    
    function exportToCSV() {
        const selectedBrands = getSelectedBrands();
        if (selectedBrands.length === 0) {
            alert('<?= esc_js(__('Please select brands to export.', 'ams-wc-amazon')); ?>');
            return;
        }
        
        // Generate CSV content
        let csvContent = "Brand Name,Total Clicks,Shop Page,Category Page,Product Page,Brand Page,Products,Last Click\n";
        
        selectedBrands.forEach(brandId => {
            const row = document.querySelector(`tr[data-brand-id="${brandId}"]`);
            if (row) {
                const cells = row.querySelectorAll('td');
                const csvRow = [
                    `"${cells[1].textContent.trim()}"`,
                    cells[2].textContent.trim(),
                    cells[3].textContent.trim(),
                    cells[4].textContent.trim(),
                    cells[5].textContent.trim(),
                    cells[6].textContent.trim(),
                    cells[7].textContent.trim(),
                    `"${cells[8].textContent.trim()}"`
                ].join(',');
                csvContent += csvRow + "\n";
            }
        });
        
        // Download CSV
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `brand-statistics-${new Date().toISOString().split('T')[0]}.csv`;
        a.click();
        window.URL.revokeObjectURL(url);
    }
    
    function exportToExcel() {
        // For now, export as CSV with .xlsx extension
        // In a real implementation, you'd use a library like SheetJS
        exportToCSV();
    }
    
    function resetSelectedBrands() {
        const selectedBrands = getSelectedBrands();
        if (selectedBrands.length === 0) {
            alert('<?= esc_js(__('Please select brands to reset.', 'ams-wc-amazon')); ?>');
            return;
        }
        
        if (confirm(`<?= esc_js(__('Are you sure you want to reset statistics for', 'ams-wc-amazon')); ?> ${selectedBrands.length} <?= esc_js(__('selected brands?', 'ams-wc-amazon')); ?>`)) {
            // Make AJAX request to reset selected brands
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ams_reset_selected_brand_stats',
                    brand_ids: selectedBrands.join(','),
                    nonce: '<?= wp_create_nonce('reset_brand_stats'); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('<?= esc_js(__('Error resetting brand statistics.', 'ams-wc-amazon')); ?>');
                }
            });
        }
    }
    
    function getSelectedBrands() {
        return Array.from(document.querySelectorAll('.brand-checkbox:checked')).map(cb => cb.value);
    }
    
    // Performance insights
    function initializePerformanceInsights() {
        const insights = generatePerformanceInsights();
        displayInsights(insights);
    }
    
    function generatePerformanceInsights() {
        const insights = [];
        const totalClicks = <?php echo (int)$total_clicks; ?>;
        const mobilePercentage = <?php echo (float)$mobile_percentage; ?>;
        const avgTimeOnPage = <?php echo (float)$avg_time_on_page; ?>;
        
        // Mobile traffic insight
        if (mobilePercentage > 60) {
            insights.push({
                type: 'success',
                icon: 'bi-phone',
                title: '<?= esc_js(__('Great Mobile Engagement', 'ams-wc-amazon')); ?>',
                message: `<?= esc_js(__('Your mobile traffic is', 'ams-wc-amazon')); ?> ${mobilePercentage}%! <?= esc_js(__('Consider optimizing mobile brand layouts.', 'ams-wc-amazon')); ?>`
            });
        } else if (mobilePercentage < 30) {
            insights.push({
                type: 'warning',
                icon: 'bi-exclamation-triangle',
                title: '<?= esc_js(__('Low Mobile Traffic', 'ams-wc-amazon')); ?>',
                message: `<?= esc_js(__('Only', 'ams-wc-amazon')); ?> ${mobilePercentage}% <?= esc_js(__('mobile traffic. Consider mobile-first design improvements.', 'ams-wc-amazon')); ?>`
            });
        }
        
        // Engagement insight
        if (avgTimeOnPage > 30) {
            insights.push({
                type: 'success',
                icon: 'bi-clock',
                title: '<?= esc_js(__('High Engagement', 'ams-wc-amazon')); ?>',
                message: `<?= esc_js(__('Users spend', 'ams-wc-amazon')); ?> ${avgTimeOnPage}s <?= esc_js(__('on average before clicking brands.', 'ams-wc-amazon')); ?>`
            });
        } else if (avgTimeOnPage < 10) {
            insights.push({
                type: 'danger',
                icon: 'bi-speedometer2',
                title: '<?= esc_js(__('Quick Clicks', 'ams-wc-amazon')); ?>',
                message: `<?= esc_js(__('Users click quickly (', 'ams-wc-amazon')); ?>${avgTimeOnPage}s). <?= esc_js(__('Consider adding more brand information.', 'ams-wc-amazon')); ?>`
            });
        }
        
        // Activity insight
        if (totalClicks > 1000) {
            insights.push({
                type: 'success',
                icon: 'bi-graph-up',
                title: '<?= esc_js(__('High Activity', 'ams-wc-amazon')); ?>',
                message: `<?= esc_js(__('Excellent! You have', 'ams-wc-amazon')); ?> ${totalClicks.toLocaleString()} <?= esc_js(__('total brand clicks.', 'ams-wc-amazon')); ?>`
            });
        } else if (totalClicks < 100) {
            insights.push({
                type: 'warning',
                icon: 'bi-arrow-up',
                title: '<?= esc_js(__('Growing Activity', 'ams-wc-amazon')); ?>',
                message: '<?= esc_js(__('Consider promoting your brand pages more to increase engagement.', 'ams-wc-amazon')); ?>'
            });
        }
        
        return insights;
    }
    
    function displayInsights(insights) {
        const container = document.getElementById('performanceInsights');
        if (!container) return;
        
        if (insights.length === 0) {
            container.innerHTML = '<div class="col-12"><p class="text-muted text-center"><?= esc_js(__('No insights available yet.', 'ams-wc-amazon')); ?></p></div>';
            return;
        }
        
        container.innerHTML = insights.map(insight => `
            <div class="col-md-6 col-lg-4">
                <div class="card insight-card ${insight.type} h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                <i class="bi ${insight.icon} text-${insight.type === 'warning' ? 'warning' : insight.type === 'danger' ? 'danger' : 'success'}" style="font-size: 1.5rem;"></i>
                            </div>
                            <div>
                                <h6 class="card-title mb-2">${insight.title}</h6>
                                <p class="card-text small mb-0">${insight.message}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `).join('');
    }
    
    // Real-time updates (optional)
    function initializeRealTimeUpdates() {
        // Update statistics every 30 seconds
        setInterval(function() {
            // In a real implementation, you'd fetch updated data via AJAX
            // For now, we'll just update the timestamp
            const timestampElements = document.querySelectorAll('.last-updated-timestamp');
            timestampElements.forEach(el => {
                el.textContent = new Date().toLocaleString();
            });
        }, 30000);
    }
    
    // Individual brand actions
    window.viewBrandDetails = function(brandId) {
        // Open brand details modal or navigate to brand page
        const brandRow = document.querySelector(`tr[data-brand-id="${brandId}"]`);
        const brandName = brandRow ? brandRow.dataset.brandName : 'Brand';
        
        alert(`<?= esc_js(__('View details for:', 'ams-wc-amazon')); ?> ${brandName}\n<?= esc_js(__('Feature coming soon!', 'ams-wc-amazon')); ?>`);
    };
    
    window.editBrand = function(brandId) {
        // Navigate to brand edit page
        window.open(`<?= admin_url('edit-tags.php?taxonomy=product_brand&tag_ID='); ?>${brandId}`, '_blank');
    };
    
    window.resetBrandStats = function(brandId) {
        const brandRow = document.querySelector(`tr[data-brand-id="${brandId}"]`);
        const brandName = brandRow ? brandRow.dataset.brandName : 'Brand';
        
        if (confirm(`<?= esc_js(__('Reset statistics for', 'ams-wc-amazon')); ?> "${brandName}"?`)) {
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ams_reset_single_brand_stats',
                    brand_id: brandId,
                    nonce: '<?= wp_create_nonce('reset_brand_stats'); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('<?= esc_js(__('Error resetting brand statistics.', 'ams-wc-amazon')); ?>');
                }
            });
        }
    };
    
    // SEO Tools Functions
    window.testSchemaMarkup = function() {
        const testUrl = 'https://search.google.com/test/rich-results?url=' + encodeURIComponent(window.location.origin);
        window.open(testUrl, '_blank');
    };
    
    window.generateSitemap = function() {
        const sitemapUrl = '<?= esc_js(home_url('?ams_brand_sitemap=1')); ?>';
        window.open(sitemapUrl, '_blank');
    };
    
    window.refreshSEOScores = function() {
        const container = document.getElementById('seoScoresContainer');
        if (!container) return;
        
        container.innerHTML = `
            <div class="text-center py-4">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden"><?= esc_js(__('Loading...', 'ams-wc-amazon')); ?></span>
                </div>
                <p class="text-muted mt-2"><?= esc_js(__('Calculating SEO scores...', 'ams-wc-amazon')); ?></p>
            </div>
        `;
        
        // Simulate loading and generate SEO scores
        setTimeout(() => {
            generateSEOScoresDisplay();
        }, 2000);
    };
    
    function generateSEOScoresDisplay() {
        const container = document.getElementById('seoScoresContainer');
        if (!container) return;
        
        // Get brand data from PHP (simplified for demo)
        const brands = <?php
            $brands = get_terms(array(
                'taxonomy' => 'product_brand',
                'hide_empty' => false,
                'number' => 10
            ));
            
            $brand_data = array();
            if (!empty($brands) && !is_wp_error($brands)) {
                foreach ($brands as $brand) {
                    $seo_score = ams_calculate_brand_seo_score($brand->term_id);
                    $performance_score = ams_calculate_brand_performance_score($brand->term_id);
                    
                    $brand_data[] = array(
                        'id' => $brand->term_id,
                        'name' => $brand->name,
                        'seo_score' => $seo_score,
                        'performance_score' => $performance_score,
                        'products' => $brand->count
                    );
                }
            }
            echo json_encode($brand_data);
        ?>;
        
        if (brands.length === 0) {
            container.innerHTML = `
                <div class="text-center py-4">
                    <i class="bi bi-info-circle text-muted" style="font-size: 2rem;"></i>
                    <p class="text-muted mt-2"><?= esc_js(__('No brands found. Create some brands first.', 'ams-wc-amazon')); ?></p>
                </div>
            `;
            return;
        }
        
        let html = '<div class="row g-3">';
        
        brands.forEach(brand => {
            const seoClass = brand.seo_score >= 75 ? 'success' : brand.seo_score >= 50 ? 'warning' : 'danger';
            const performanceClass = brand.performance_score >= 75 ? 'success' : brand.performance_score >= 50 ? 'warning' : 'danger';
            
            html += `
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h6 class="card-title text-truncate" title="${brand.name}">${brand.name}</h6>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <small class="text-muted"><?= esc_js(__('SEO Score', 'ams-wc-amazon')); ?></small>
                                    <small class="fw-bold text-${seoClass}">${brand.seo_score}%</small>
                                </div>
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar bg-${seoClass}" style="width: ${brand.seo_score}%"></div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <small class="text-muted"><?= esc_js(__('Performance', 'ams-wc-amazon')); ?></small>
                                    <small class="fw-bold text-${performanceClass}">${brand.performance_score.toFixed(1)}%</small>
                                </div>
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar bg-${performanceClass}" style="width: ${brand.performance_score}%"></div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">${brand.products} <?= esc_js(__('products', 'ams-wc-amazon')); ?></small>
                                <button class="btn btn-outline-primary btn-sm" onclick="viewBrandDetails(${brand.id})">
                                    <i class="bi bi-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        
        html += '</div>';
        container.innerHTML = html;
    }
    
    // Initialize SEO scores on page load
    if (document.getElementById('seoScoresContainer')) {
        setTimeout(() => {
            generateSEOScoresDisplay();
        }, 1000);
    }
});
</script>

<?php include "common-footer.php"; ?>
