<input type="hidden" id="wca_license_status" value="<?php echo esc_attr($wca_license_status); ?>">

<?php
// Hide WordPress admin footer on AMS plugin pages only
$page = isset($_GET['page']) ? $_GET['page'] : '';
$ams_pages = [
    'wc-amazon-affiliate',
    'wc-product-search',
    'products-search-without-api',
    'amazon-bestsellers',
    'product-import-by-url',
    'product-review-import',
    'wc-product-setting-page',
    'view-logs',
    'automation',
    'automation-logs',
    'brand-settings',
];
if (in_array($page, $ams_pages, true)) {
    echo '<style>#wpfooter{display:none !important;}</style>';
}
?>

<script type="text/javascript">
    jQuery(document).ready(function($) {
        // Global handler for form submissions
        $(document).on('submit', 'form', function(event) {
            checkLicenseAndBlock(event);
        });

        // Block any file input changes (file upload interaction)
        $(document).on('change', 'input[type="file"]', function(event) {
            checkLicenseAndBlock(event);
        });

        // Also block clicks on buttons that may trigger file uploads or other actions
        $(document).on('click', 'button, input[type="submit"]', function(event) {
            checkLicenseAndBlock(event);
        });

        // Function to check license and block the action
        function checkLicenseAndBlock(event) {
            // Check license status
            var licenseStatus = $('#wca_license_status').val();
            if (licenseStatus === 'Not Activated') {
                event.preventDefault();
                event.stopPropagation();

                // Show our beautiful header alert instead of creating a new one
                if (typeof updateLicenseAlert === 'function') {
                    updateLicenseAlert(true);
                } else {
                    // Fallback: show the existing header alert
                    $('#license-header-alert').removeClass('d-none').addClass('show');
                }
            }
        }
        
        // Smart Toast Notification System - Only one toast at a time
        window.showToast = function(message, type = 'success', persistent = false) {
            // Create toast container if it doesn't exist
            if ($('#global-toast-container').length === 0) {
                $('body').append('<div id="global-toast-container" style="position: fixed; top: 50px; right: 20px; z-index: 9999;"></div>');
            }
            
            // Clear any existing toasts first
            $('#global-toast-container').empty();
            
            const toastId = 'current-toast';
            const bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
            const iconClass = type === 'success' ? 'bi bi-check-circle' : 'bi bi-exclamation-circle';
            
            // For persistent toasts (like loading), don't auto-hide and show spinner
            const autoHide = persistent ? false : (type === 'success');
            const delay = persistent ? 0 : (type === 'success' ? 3000 : 0);
            const spinnerHtml = persistent ? '<div class="spinner-border spinner-border-sm me-2" role="status"><span class="visually-hidden">Loading...</span></div>' : `<i class="${iconClass} me-2"></i>`;
            
            const toastHtml = `
                <div id="${toastId}" class="toast align-items-center text-white ${bgClass} border-0 mb-2" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body">
                            ${spinnerHtml}${message}
                        </div>
                        ${persistent ? '' : '<button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>'}
                    </div>
                </div>
            `;
            
            $('#global-toast-container').html(toastHtml);
            
            // Initialize and show the toast
            const toastElement = document.getElementById(toastId);
            const toast = new bootstrap.Toast(toastElement, {
                autohide: autoHide,
                delay: delay
            });
            
            toast.show();
            
            // Remove toast element after it's hidden (only for non-persistent toasts)
            if (!persistent) {
                toastElement.addEventListener('hidden.bs.toast', function() {
                    this.remove();
                });
            }
        };
    });
</script>