<?php include "common-header.php"; ?>

<?php
// Get dashboard stats with real trends
$dashboard_stats = ams_get_dashboard_stats_with_trends();
$trends = isset($dashboard_stats['trends']) ? $dashboard_stats['trends'] : array();

// Initialize trends with fallback values if not available
$products_trend = isset($trends['products_count']) ? $trends['products_count'] : '0%';
$views_trend = isset($trends['total_view_count']) ? $trends['total_view_count'] : '0%';
$cart_trend = isset($trends['total_product_added_to_cart']) ? $trends['total_product_added_to_cart'] : '0%';
$redirects_trend = isset($trends['total_product_direct_redirected']) ? $trends['total_product_direct_redirected'] : '0%';

// Get products info for dashboard cards (use the more comprehensive function)
$products_info = ams_get_all_products_info_with_parent();

// Get Amazon API usage data
$amazon_api_usage = \Amazon\Affiliate\Api\Amazon_Product_Api::get_api_usage();

// Track daily stats (this will be called once per day)
$today = date('Y-m-d');
$last_tracked = get_option('ams_dashboard_last_tracked', '');
if ($last_tracked !== $today) {
    ams_track_daily_dashboard_stats();
    update_option('ams_dashboard_last_tracked', $today);
}
?>

<div class="container-fluid">
  <!-- Professional Dashboard Header -->
  <header class="bg-light border-bottom mb-5 py-4">
    <div class="container-fluid position-relative">
      <div class="header-body">
        <div class="row align-items-center mb-3">
          <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
              <h1 class="display-6 fw-bold text-primary mb-0">
                <?php esc_html_e('AMS - WooCommerce Amazon Dashboard', 'ams-wc-amazon'); ?>
              </h1>
              <div class="d-flex align-items-center gap-3">
                <button type="button" class="btn btn-primary" data-bs-toggle="offcanvas" data-bs-target="#quickActions" aria-controls="quickActions">
                  <i class="bi bi-lightning me-2"></i><?php esc_html_e('Quick Actions', 'ams-wc-amazon'); ?>
                </button>
                
                <!-- Reset Statistics Dropdown -->
                <div class="dropdown">
                  <button class="btn btn-outline-danger btn-sm dropdown-toggle" type="button" id="resetStatsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-arrow-clockwise me-1"></i><?php esc_html_e('Reset Stats', 'ams-wc-amazon'); ?>
                  </button>
                  <ul class="dropdown-menu" aria-labelledby="resetStatsDropdown">
                    <li><h6 class="dropdown-header"><?php esc_html_e('Reset Statistics', 'ams-wc-amazon'); ?></h6></li>
                    <li><a class="dropdown-item reset-stats-btn" href="#" data-type="products">
                      <i class="bi bi-box me-2"></i><?php esc_html_e('Reset Product Views', 'ams-wc-amazon'); ?>
                    </a></li>
                    <li><a class="dropdown-item reset-stats-btn" href="#" data-type="cart">
                      <i class="bi bi-cart me-2"></i><?php esc_html_e('Reset Cart Additions', 'ams-wc-amazon'); ?>
                    </a></li>
                    <li><a class="dropdown-item reset-stats-btn" href="#" data-type="redirects">
                      <i class="bi bi-box-arrow-up-right me-2"></i><?php esc_html_e('Reset Amazon Clicks', 'ams-wc-amazon'); ?>
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item reset-stats-btn text-danger" href="#" data-type="all">
                      <i class="bi bi-exclamation-triangle me-2"></i><?php esc_html_e('Reset All Statistics', 'ams-wc-amazon'); ?>
                    </a></li>
                  </ul>
                </div>
                
                <span class="badge bg-secondary align-self-center">
                  <?php echo esc_html(sprintf(__('Version %s', 'ams-wc-amazon'), get_file_data(AMS_PLUGIN_FILE, array('Version' => 'Version'))['Version'])); ?>
                </span>
              </div>
            </div>
          </div>
        </div>
        <p class="lead text-muted mb-3">
          <?php esc_html_e('Manage your Amazon affiliate business with powerful tools and insights', 'ams-wc-amazon'); ?>
        </p>
        
        <!-- Analytics Notification -->

        
        <!-- Enhanced Professional Statistics Cards -->
        <div class="row g-4 ams-common-card-fix">
          <?php
          // Ensure data integrity with fallbacks
          $products_count = isset($products_info['products_count']) ? (int)$products_info['products_count'] : 0;
          $total_views = isset($products_info['total_view_count']) ? (int)$products_info['total_view_count'] : 0;
          $cart_additions = isset($products_info['total_product_added_to_cart']) ? (int)$products_info['total_product_added_to_cart'] : 0;
          $amazon_redirects = isset($products_info['total_product_direct_redirected']) ? (int)$products_info['total_product_direct_redirected'] : 0;
          
          // Calculate engagement metrics
          $avg_views_per_product = $products_count > 0 ? round($total_views / $products_count, 1) : 0;
          $cart_conversion_rate = $total_views > 0 ? round(($cart_additions / $total_views) * 100, 1) : 0;
          $redirect_conversion_rate = $total_views > 0 ? round(($amazon_redirects / $total_views) * 100, 1) : 0;
          
          $card_data = [
            [
              'title' => __('Total Products', 'ams-wc-amazon'),
              'value' => number_format($products_count),
              'raw_value' => $products_count,
              'icon' => 'fa-box-open',
              'color' => 'primary',
              'trend' => $products_trend,
              'description' => __('Amazon products imported', 'ams-wc-amazon'),
              'metric' => $products_count > 0 ? sprintf(__('Avg %s views/product', 'ams-wc-amazon'), number_format($avg_views_per_product, 1)) : __('No products yet', 'ams-wc-amazon')
            ],
            [
              'title' => __('Product Views', 'ams-wc-amazon'),
              'value' => number_format($total_views),
              'raw_value' => $total_views,
              'icon' => 'fa-eye',
              'color' => 'info',
              'trend' => $views_trend,
              'description' => __('Total page views (all time)', 'ams-wc-amazon'),
              'metric' => $total_views > 0 ? sprintf(__('%s%% cart rate', 'ams-wc-amazon'), $cart_conversion_rate) : __('No views yet', 'ams-wc-amazon')
            ],
            [
              'title' => __('Cart Additions', 'ams-wc-amazon'),
              'value' => number_format($cart_additions),
              'raw_value' => $cart_additions,
              'icon' => 'fa-shopping-cart',
              'color' => 'success',
              'trend' => $cart_trend,
              'description' => __('Products added to cart', 'ams-wc-amazon'),
              'metric' => $total_views > 0 ? sprintf(__('%s%% of total views', 'ams-wc-amazon'), $cart_conversion_rate) : __('No additions yet', 'ams-wc-amazon')
            ],
            [
              'title' => __('Amazon Clicks', 'ams-wc-amazon'),
              'value' => number_format($amazon_redirects),
              'raw_value' => $amazon_redirects,
              'icon' => 'fa-external-link-alt',
              'color' => 'warning',
              'trend' => $redirects_trend,
              'description' => __('Clicks to Amazon (conversions)', 'ams-wc-amazon'),
              'metric' => $total_views > 0 ? sprintf(__('%s%% click-through rate', 'ams-wc-amazon'), $redirect_conversion_rate) : __('No clicks yet', 'ams-wc-amazon')
            ]
          ];
          foreach ($card_data as $index => $card) : ?>
            <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-12">
              <div class="card h-100 shadow-sm ams-dashboard-stat-card">
              <div class="card-body d-flex align-items-center">
                <div class="rounded-circle bg-<?php echo $card['color']; ?> text-white d-flex align-items-center justify-content-center me-3" style="width: 60px; height: 60px;">
                  <span class="icon-shape bg-white text-<?php echo $card['color']; ?> d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                    <i class="fas <?php echo $card['icon']; ?> fa-lg"></i>
                  </span>
                  <span class="badge bg-light text-dark ms-2">
                    <?php echo $card['trend']; ?>
                  </span>
                </div>
                <div class="flex-grow-1">
                  <h6 class="card-title mb-1"><?php echo $card['title']; ?></h6>
                  <div class="h4 mb-1 fw-bold text-primary" title="<?php echo esc_attr(sprintf(__('Raw value: %s', 'ams-wc-amazon'), number_format($card['raw_value']))); ?>">
                    <?php echo esc_html($card['value']); ?>
                  </div>
                  <p class="text-muted mb-1"><?php echo $card['description']; ?></p>
                  <div class="small text-muted">
                    <i class="bi bi-graph-up me-1"></i><?php echo esc_html($card['metric']); ?>
                  </div>
                </div>
              </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </header>

  <!-- Enhanced Quick Actions Offcanvas -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="quickActions" aria-labelledby="quickActionsLabel">
    <div class="offcanvas-header bg-gradient-primary py-4">
      <h5 class="offcanvas-title text-white fs-5" id="quickActionsLabel">
        <i class="bi bi-lightning me-2"></i>Quick Actions
      </h5>
      <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body pt-3">
      <div class="list-group list-group-flush">
        <a href="?page=wc-product-search" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="bi bi-file-earmark-arrow-down me-3 text-primary"></i>Import By PA-API 5</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
        <a href="?page=products-search-without-api" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="bi bi-search me-3 text-warning"></i>Import by Search (No API)</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
        <a href="?page=product-import-by-url" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="bi bi-link me-3 text-info"></i>Import by URL (No API)</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
        <a href="?page=product-review-import" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="bi bi-star me-3 text-warning"></i>Import Reviews</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
        <a href="?page=wc-product-setting-page&tab=pills-general-tab" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="bi bi-sliders me-3 text-primary"></i>General Settings</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
        <a href="?page=wc-product-setting-page&tab=pills-az-settings-tab" class="list-group-item list-group-item-action py-3 fs-6 border-0 hover-bg-light transition-all" target="_blank" rel="noopener noreferrer">
          <div class="d-flex w-100 justify-content-between align-items-center">
            <span><i class="fab fa-amazon me-3 text-warning"></i>Amazon API Settings</span>
            <i class="bi bi-box-arrow-up-right text-muted"></i>
          </div>
        </a>
      </div>

      <div class="mt-4">
        <a href="?page=view-logs" class="btn btn-outline-info d-block mb-3 py-2 fs-5 hover-shadow transition-all">
          <i class="bi bi-graph-up me-2"></i><?php esc_html_e('Analytics & Logs', 'ams-wc-amazon'); ?>
          <small class="d-block text-muted mt-1"><?php esc_html_e('View detailed tracking statistics, geographic data, and system logs', 'ams-wc-amazon'); ?></small>
        </a>
        <a href="https://affiliatepro.org/knowledge-base/" class="btn btn-outline-info d-block mb-3 py-2 fs-5 hover-shadow transition-all" target="_blank" rel="noopener noreferrer">
          <i class="bi bi-question-circle me-2"></i><?php esc_html_e('Help & Documentation', 'ams-wc-amazon'); ?>
        </a>
        <a href="https://affiliatepro.org/suggestion-request/" class="btn btn-outline-success d-block py-2 fs-5 hover-shadow transition-all" target="_blank" rel="noopener noreferrer">
          <i class="bi bi-lightbulb me-2"></i><?php esc_html_e('Submit Suggestion', 'ams-wc-amazon'); ?>
        </a>
      </div>
    </div>
    
    <div class="offcanvas-footer bg-light p-3">
      <div class="d-flex justify-content-between align-items-center">
        <span class="text-muted fs-6"><?php esc_html_e('AMS - WooCommerce Amazon', 'ams-wc-amazon'); ?></span>
        <span class="badge bg-primary fs-6">v<?php echo esc_html(AMS_PLUGIN_VERSION); ?></span>
      </div>
    </div>
  </div>

  <!-- Enhanced Status Cards Row - All 5 cards in one responsive row -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="row g-3 ams-common-card-fix">
    <!-- AMAZON API -->
      <div class="col-xxl col-xl col-lg col-md-6 col-12">
        <div class="card h-100 shadow-sm ams-dashboard-service-card">
      <?php
      // Amazon API Usage Metrics
      $requests_today = isset($amazon_api_usage['used_requests']) ? (int)$amazon_api_usage['used_requests'] : 0;
      $requests_limit = isset($amazon_api_usage['total_requests']) ? (int)$amazon_api_usage['total_requests'] : 8640;
      $usage_percent = isset($amazon_api_usage['used_percentage']) ? $amazon_api_usage['used_percentage'] : 0;
      $last_request_time = (int)get_option('amazon_api_last_request_time', 0);
      $now = time();
      $last_request_human = $last_request_time ? human_time_diff($last_request_time, $now) . ' ' . __('ago', 'ams-wc-amazon') : __('Never', 'ams-wc-amazon');
      
      // Get Amazon API credentials and settings
      $access_key = get_option('ams_access_key_id');
      $secret_key = get_option('ams_secret_access_key');
      $associate_tag = get_option('ams_associate_tag');
      $amazon_region = get_option('ams_amazon_country', 'com');
      
      // Get region info
      $regions = ams_get_amazon_regions();
      $region_name = isset($regions[$amazon_region]['RegionName']) ? $regions[$amazon_region]['RegionName'] : 'United States';
      $region_flags = array(
          'com.au' => '🇦🇺', 'com.br' => '🇧🇷', 'ca' => '🇨🇦', 'cn' => '🇨🇳',
          'fr' => '🇫🇷', 'de' => '🇩🇪', 'in' => '🇮🇳', 'it' => '🇮🇹',
          'jp' => '🇯🇵', 'mx' => '🇲🇽', 'nl' => '🇳🇱', 'pl' => '🇵🇱',
          'sg' => '🇸🇬', 'sa' => '🇸🇦', 'se' => '🇸🇪', 'tr' => '🇹🇷',
          'ae' => '🇦🇪', 'co.uk' => '🇬🇧', 'com' => '🇺🇸', 'es' => '🇪🇸'
      );
      $region_flag = isset($region_flags[$amazon_region]) ? $region_flags[$amazon_region] . ' ' : '';
      
      // Better status logic
      $has_credentials = ($access_key && $secret_key && $associate_tag);
      $has_api_activity = ($requests_today > 0 || $last_request_time > 0);
      $status = ($has_api_activity || $has_credentials) ? 'active' : 'inactive';
      
      $reset_time = strtotime('tomorrow') - $now;
      $reset_human = $reset_time > 0 ? human_time_diff($now, strtotime('tomorrow')) : __('Soon', 'ams-wc-amazon');
      ?>
      <!-- Minimalist Header -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="mb-0 fw-bold text-danger"><?php esc_html_e('Amazon API', 'ams-wc-amazon'); ?></h5>
          <small class="text-muted"><?php esc_html_e('PA-API 5.0', 'ams-wc-amazon'); ?></small>
        </div>
        <div class="text-end">
          <small class="status-badge status-<?php echo $status; ?> mb-1 d-block"><?php echo $status === 'active' ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
          <a href="?page=wc-product-setting-page&tab=pills-az-settings-tab" class="btn btn-outline-danger btn-sm" target="_blank" rel="noopener noreferrer">
            <?php esc_html_e('Setup', 'ams-wc-amazon'); ?>
          </a>
        </div>
      </div>
      
      <!-- Visual Usage Display -->
      <?php if ($has_credentials) : ?>
        <!-- Circular Progress Ring -->
        <div class="text-center mb-3">
          <div class="position-relative d-inline-block">
            <svg width="80" height="80" class="circular-progress">
              <circle cx="40" cy="40" r="35" fill="none" stroke="#f8f9fa" stroke-width="6"/>
              <circle cx="40" cy="40" r="35" fill="none" stroke="#dc3545" stroke-width="6" 
                      stroke-dasharray="<?php echo 2 * 3.14159 * 35; ?>" 
                      stroke-dashoffset="<?php echo 2 * 3.14159 * 35 * (1 - $usage_percent / 100); ?>"
                      stroke-linecap="round" class="progress-ring"/>
            </svg>
            <div class="position-absolute top-50 start-50 translate-middle text-center">
              <div class="fw-bold text-danger" style="font-size: 0.9rem;" data-counter="<?php echo $usage_percent; ?>">0%</div>
              <small class="text-muted" style="font-size: 0.65rem;">Used</small>
            </div>
          </div>
        </div>
        
        <!-- Visual Stats Grid -->
        <div class="row g-2 mb-3">
          <div class="col-4">
            <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
              <div class="bg-danger opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
              <div class="position-relative">
                <i class="bi bi-graph-up text-danger fs-5 mb-1"></i>
                <div class="fw-semibold text-danger lh-1" style="font-size: 0.65rem; white-space: nowrap;">
                  <span data-counter="<?php echo $requests_today; ?>">0</span> / <?php echo esc_html(number_format($requests_limit)); ?>
                </div>
                <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Today</small>
              </div>
            </div>
          </div>
          <div class="col-4">
            <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
              <div class="bg-success opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
              <div class="position-relative">
                <i class="bi bi-clock text-success fs-5 mb-1"></i>
                <div class="fw-semibold text-success lh-1" style="font-size: 0.65rem;">
                  <?php echo $last_request_time > 0 ? esc_html(human_time_diff($last_request_time, $now)) : esc_html__('Never', 'ams-wc-amazon'); ?>
                </div>
                <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Last Used</small>
              </div>
            </div>
          </div>
          <div class="col-4">
            <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
              <div class="bg-warning opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
              <div class="position-relative">
                <i class="bi bi-arrow-clockwise text-warning fs-5 mb-1"></i>
                <div class="fw-semibold text-warning lh-1" style="font-size: 0.65rem;">
                  <?php echo esc_html($reset_human); ?>
                </div>
                <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Reset</small>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Status Indicator -->
        <div class="d-flex align-items-center justify-content-center">
          <div class="status-indicator status-<?php echo $status; ?> me-2"></div>
          <small class="text-muted">
            <?php echo $status === 'active' ? esc_html__('API Active & Healthy', 'ams-wc-amazon') : esc_html__('API Inactive', 'ams-wc-amazon'); ?>
          </small>
        </div>
      <?php else : ?>
        <!-- Not Configured Visual State -->
        <div class="text-center py-4">
          <div class="position-relative d-inline-block mb-3">
            <svg width="80" height="80" class="circular-progress opacity-25">
              <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
            </svg>
            <div class="position-absolute top-50 start-50 translate-middle">
              <i class="bi bi-gear text-muted fs-3"></i>
            </div>
          </div>
          <div class="text-muted mb-2"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></div>
          <a href="?page=wc-product-setting-page&tab=pills-az-settings-tab" class="btn btn-danger btn-sm">
            <i class="bi bi-plus me-1"></i><?php esc_html_e('Setup Now', 'ams-wc-amazon'); ?>
          </a>
        </div>
      <?php endif; ?>
        </div>
    </div>

    <!-- SCRAPER API -->
      <div class="col-xxl col-xl col-lg col-md-6 col-12">
        <div class="card h-100 shadow-sm ams-dashboard-service-card">
      <?php
        $is_import = (get_option('ams_scraper_api_is_active') === '1');
        $is_update = (get_option('ams_scraper_api_on_update') === '1');
        $is_service_active = ($is_import || $is_update); // Service is active if either import or update is enabled
        $has_api_key = !empty(get_option('ams_scraper_api_key', ''));
        $scraper_credits = ams_scraper_api_credits_count();
      ?>
      <!-- Minimalist Header -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="mb-0 fw-bold text-primary"><?php esc_html_e('Scraper API', 'ams-wc-amazon'); ?></h5>
          <small class="text-muted"><?php esc_html_e('#', 'ams-wc-amazon'); ?><?php echo esc_html(get_option('ams_scraperapi_priority', 1)); ?></small>
        </div>
        <div class="text-end">
          <small class="status-badge status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> mb-1 d-block"><?php echo $is_service_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-outline-primary btn-sm" target="_blank" rel="noopener noreferrer">
            <?php esc_html_e('Setup', 'ams-wc-amazon'); ?>
          </a>
        </div>
      </div>
      
      <!-- Visual Usage Display -->
      <?php if ($has_api_key) : ?>
        <?php if ($scraper_credits && isset($scraper_credits['requestCount']) && isset($scraper_credits['requestLimit'])) : ?>
          <?php 
          $usage_percent = $scraper_credits['requestLimit'] > 0 ? round(($scraper_credits['requestCount'] / $scraper_credits['requestLimit']) * 100, 1) : 0;
          ?>
          <!-- Circular Progress Ring -->
          <div class="text-center mb-3">
            <div class="position-relative d-inline-block">
              <svg width="80" height="80" class="circular-progress">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#f8f9fa" stroke-width="6"/>
                <circle cx="40" cy="40" r="35" fill="none" stroke="#007bff" stroke-width="6" 
                        stroke-dasharray="<?php echo 2 * 3.14159 * 35; ?>" 
                        stroke-dashoffset="<?php echo 2 * 3.14159 * 35 * (1 - $usage_percent / 100); ?>"
                        stroke-linecap="round" class="progress-ring"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle text-center">
                <div class="fw-bold text-primary" style="font-size: 0.9rem;" data-counter="<?php echo $usage_percent; ?>">0%</div>
                <small class="text-muted" style="font-size: 0.65rem;">Used</small>
              </div>
            </div>
          </div>
          
          <!-- Visual Stats Grid -->
          <div class="row g-2 mb-3">
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-primary opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-cloud text-primary fs-5 mb-1"></i>
                  <div class="fw-semibold text-primary lh-1" style="font-size: 0.65rem; white-space: nowrap;">
                    <span data-counter="<?php echo $scraper_credits['requestCount']; ?>">0</span> / <?php echo esc_html(number_format($scraper_credits['requestLimit'])); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Used</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-success opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-shield-check text-success fs-5 mb-1"></i>
                  <div class="fw-semibold text-success lh-1" style="font-size: 0.65rem;">
                    <?php echo $is_service_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Status</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-warning opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-list-ol text-warning fs-5 mb-1"></i>
                  <div class="fw-semibold text-warning lh-1" style="font-size: 0.65rem;">
                    #<?php echo esc_html(get_option('ams_scraperapi_priority', 1)); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Priority</small>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Status Indicator -->
          <div class="d-flex align-items-center justify-content-center">
            <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
            <small class="text-muted">
              <?php echo $is_service_active ? esc_html__('Service Active & Ready', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
            </small>
          </div>
        <?php else : ?>
          <!-- Data Unavailable Visual State -->
          <div class="text-center py-4">
            <div class="position-relative d-inline-block mb-3">
              <svg width="80" height="80" class="circular-progress opacity-25">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle">
                <i class="bi bi-question-circle text-muted fs-3"></i>
              </div>
            </div>
            <div class="text-muted mb-2"><?php esc_html_e('Usage data unavailable', 'ams-wc-amazon'); ?></div>
            <div class="d-flex align-items-center justify-content-center">
              <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
              <small class="text-muted">
                <?php echo $is_service_active ? esc_html__('Service Active', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
              </small>
            </div>
          </div>
        <?php endif; ?>
      <?php else : ?>
        <!-- Not Configured Visual State -->
        <div class="text-center py-4">
          <div class="position-relative d-inline-block mb-3">
            <svg width="80" height="80" class="circular-progress opacity-25">
              <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
            </svg>
            <div class="position-absolute top-50 start-50 translate-middle">
              <i class="bi bi-cloud text-muted fs-3"></i>
            </div>
          </div>
          <div class="text-muted mb-2"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></div>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-primary btn-sm">
            <i class="bi bi-plus me-1"></i><?php esc_html_e('Setup Now', 'ams-wc-amazon'); ?>
          </a>
        </div>
      <?php endif; ?>
        </div>
    </div>

    <!-- SCRAPINGANT API -->
      <div class="col-xxl col-xl col-lg col-md-6 col-12">
        <div class="card h-100 shadow-sm ams-dashboard-service-card">
      <?php
        $is_import = (get_option('ams_scrapingant_is_active') === '1');
        $is_update = (get_option('ams_scrapingant_on_update') === '1');
        $is_service_active = ($is_import || $is_update); // Service is active if either import or update is enabled
        $has_api_key = !empty(get_option('ams_scrapingant_api_key', ''));
        $scrapingant_credits = scrapingant_api_credits_status();
      ?>
      <!-- Minimalist Header -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="mb-0 fw-bold text-success"><?php esc_html_e('ScrapingAnt API', 'ams-wc-amazon'); ?></h5>
          <small class="text-muted"><?php esc_html_e('#', 'ams-wc-amazon'); ?><?php echo esc_html(get_option('ams_scrapingant_priority', 2)); ?></small>
        </div>
        <div class="text-end">
          <small class="status-badge status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> mb-1 d-block"><?php echo $is_service_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-outline-success btn-sm" target="_blank" rel="noopener noreferrer">
            <?php esc_html_e('Setup', 'ams-wc-amazon'); ?>
          </a>
        </div>
      </div>
      
      <!-- Visual Usage Display -->
      <?php if ($has_api_key) : ?>
        <?php if ($scrapingant_credits && isset($scrapingant_credits['plan_total_credits']) && isset($scrapingant_credits['remained_credits'])) : ?>
          <?php 
          $scrapingant_total = (int)$scrapingant_credits['plan_total_credits'];
          $scrapingant_remaining = (int)$scrapingant_credits['remained_credits'];
          $scrapingant_used = $scrapingant_total - $scrapingant_remaining;
          $scrapingant_usage_percent = $scrapingant_total > 0 ? round(($scrapingant_used / $scrapingant_total) * 100, 1) : 0;
          ?>
          <!-- Circular Progress Ring -->
          <div class="text-center mb-3">
            <div class="position-relative d-inline-block">
              <svg width="80" height="80" class="circular-progress">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#f8f9fa" stroke-width="6"/>
                <circle cx="40" cy="40" r="35" fill="none" stroke="#28a745" stroke-width="6" 
                        stroke-dasharray="<?php echo 2 * 3.14159 * 35; ?>" 
                        stroke-dashoffset="<?php echo 2 * 3.14159 * 35 * (1 - $scrapingant_usage_percent / 100); ?>"
                        stroke-linecap="round" class="progress-ring"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle text-center">
                <div class="fw-bold text-success" style="font-size: 0.9rem;" data-counter="<?php echo $scrapingant_usage_percent; ?>">0%</div>
                <small class="text-muted" style="font-size: 0.65rem;">Used</small>
              </div>
            </div>
          </div>
          
          <!-- Visual Stats Grid -->
          <div class="row g-2 mb-3">
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-success opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-bug text-success fs-5 mb-1"></i>
                  <div class="fw-semibold text-success lh-1" style="font-size: 0.65rem; white-space: nowrap;">
                    <span data-counter="<?php echo $scrapingant_used; ?>">0</span> / <?php echo esc_html(number_format($scrapingant_total)); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Used</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-info opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-battery-half text-info fs-5 mb-1"></i>
                  <div class="fw-semibold text-info lh-1" style="font-size: 0.65rem;" data-counter="<?php echo $scrapingant_remaining; ?>">0</div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Left</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-warning opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-list-ol text-warning fs-5 mb-1"></i>
                  <div class="fw-semibold text-warning lh-1" style="font-size: 0.65rem;">
                    #<?php echo esc_html(get_option('ams_scrapingant_priority', 2)); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Priority</small>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Status Indicator -->
          <div class="d-flex align-items-center justify-content-center">
            <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
            <small class="text-muted">
              <?php echo $is_service_active ? esc_html__('ScrapingAnt Ready', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
            </small>
          </div>
        <?php else : ?>
          <!-- Data Unavailable Visual State -->
          <div class="text-center py-4">
            <div class="position-relative d-inline-block mb-3">
              <svg width="80" height="80" class="circular-progress opacity-25">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle">
                <i class="bi bi-question-circle text-muted fs-3"></i>
              </div>
            </div>
            <div class="text-muted mb-2"><?php esc_html_e('Usage data unavailable', 'ams-wc-amazon'); ?></div>
            <div class="d-flex align-items-center justify-content-center">
              <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
              <small class="text-muted">
                <?php echo $is_service_active ? esc_html__('Service Active', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
              </small>
            </div>
          </div>
        <?php endif; ?>
      <?php else : ?>
        <!-- Not Configured Visual State -->
        <div class="text-center py-4">
          <div class="position-relative d-inline-block mb-3">
            <svg width="80" height="80" class="circular-progress opacity-25">
              <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
            </svg>
            <div class="position-absolute top-50 start-50 translate-middle">
              <i class="bi bi-bug text-muted fs-3"></i>
            </div>
          </div>
          <div class="text-muted mb-2"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></div>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-success btn-sm">
            <i class="bi bi-plus me-1"></i><?php esc_html_e('Setup Now', 'ams-wc-amazon'); ?>
          </a>
        </div>
      <?php endif; ?>
        </div>
      </div>

      <!-- DECODO API -->
      <div class="col-xxl col-xl col-lg col-md-6 col-12">
        <div class="card h-100 shadow-sm ams-dashboard-service-card">
      <?php
        $is_import = (get_option('ams_decodo_is_active') === '1');
        $is_update = (get_option('ams_decodo_on_update') === '1');
        $is_service_active = ($is_import || $is_update); // Service is active if either import or update is enabled
        $has_api_key = !empty(get_option('ams_decodo_auth_token', ''));
        $decodo_credits = decodo_api_credits_status();
      ?>
      <!-- Minimalist Header -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="mb-0 fw-bold text-warning"><?php esc_html_e('Decodo API', 'ams-wc-amazon'); ?></h5>
          <small class="text-muted"><?php esc_html_e('#', 'ams-wc-amazon'); ?><?php echo esc_html(get_option('ams_decodo_priority', 3)); ?></small>
        </div>
        <div class="text-end">
          <small class="status-badge status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> mb-1 d-block"><?php echo $is_service_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-outline-warning btn-sm" target="_blank" rel="noopener noreferrer">
            <?php esc_html_e('Setup', 'ams-wc-amazon'); ?>
          </a>
        </div>
      </div>
      
      <!-- Visual Usage Display -->
      <?php if ($has_api_key) : ?>
        <?php if ($decodo_credits && isset($decodo_credits['requests_made']) && isset($decodo_credits['plan_limit'])) : ?>
          <?php 
          $decodo_requests = (int)$decodo_credits['requests_made'];
          $decodo_total = (int)$decodo_credits['plan_limit'];
          $decodo_remaining = isset($decodo_credits['remaining']) ? (int)$decodo_credits['remaining'] : max(0, $decodo_total - $decodo_requests);
          $decodo_usage_percent = $decodo_total > 0 ? round(($decodo_requests / $decodo_total) * 100, 1) : 0;
          ?>
          <!-- Circular Progress Ring -->
          <div class="text-center mb-3">
            <div class="position-relative d-inline-block">
              <svg width="80" height="80" class="circular-progress">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#f8f9fa" stroke-width="6"/>
                <circle cx="40" cy="40" r="35" fill="none" stroke="#ffc107" stroke-width="6" 
                        stroke-dasharray="<?php echo 2 * 3.14159 * 35; ?>" 
                        stroke-dashoffset="<?php echo 2 * 3.14159 * 35 * (1 - $decodo_usage_percent / 100); ?>"
                        stroke-linecap="round" class="progress-ring"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle text-center">
                <div class="fw-bold text-warning" style="font-size: 0.9rem;" data-counter="<?php echo $decodo_usage_percent; ?>">0%</div>
                <small class="text-muted" style="font-size: 0.65rem;">Used</small>
              </div>
            </div>
          </div>
          
          <!-- Visual Stats Grid -->
          <div class="row g-2 mb-3">
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-warning opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-code-slash text-warning fs-5 mb-1"></i>
                  <div class="fw-semibold text-warning lh-1" style="font-size: 0.65rem; white-space: nowrap;">
                    <span data-counter="<?php echo $decodo_requests; ?>">0</span> / <?php echo esc_html(number_format($decodo_total)); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Used</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-info opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-hourglass-split text-info fs-5 mb-1"></i>
                  <div class="fw-semibold text-info lh-1" style="font-size: 0.65rem;" data-counter="<?php echo $decodo_remaining; ?>">0</div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Left</small>
                </div>
              </div>
            </div>
            <div class="col-4">
              <div class="text-center p-2 bg-light rounded position-relative overflow-hidden d-flex flex-column justify-content-center align-items-center" style="height: 75px;">
                <div class="bg-secondary opacity-10 position-absolute top-0 start-0 w-100 h-100"></div>
                <div class="position-relative">
                  <i class="bi bi-list-ol text-secondary fs-5 mb-1"></i>
                  <div class="fw-semibold text-secondary lh-1" style="font-size: 0.65rem;">
                    #<?php echo esc_html(get_option('ams_decodo_priority', 3)); ?>
                  </div>
                  <small class="text-muted m-0 lh-1" style="font-size: 0.6rem;">Priority</small>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Status Indicator -->
          <div class="d-flex align-items-center justify-content-center">
            <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
            <small class="text-muted">
              <?php echo $is_service_active ? esc_html__('Decodo Ready', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
            </small>
          </div>
        <?php else : ?>
          <!-- Data Unavailable Visual State -->
          <div class="text-center py-4">
            <div class="position-relative d-inline-block mb-3">
              <svg width="80" height="80" class="circular-progress opacity-25">
                <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
              </svg>
              <div class="position-absolute top-50 start-50 translate-middle">
                <i class="bi bi-question-circle text-muted fs-3"></i>
              </div>
            </div>
            <div class="text-muted mb-2"><?php esc_html_e('Usage data unavailable', 'ams-wc-amazon'); ?></div>
            <div class="d-flex align-items-center justify-content-center">
              <div class="status-indicator status-<?php echo $is_service_active ? 'active' : 'inactive'; ?> me-2"></div>
              <small class="text-muted">
                <?php echo $is_service_active ? esc_html__('Service Active', 'ams-wc-amazon') : esc_html__('Service Inactive', 'ams-wc-amazon'); ?>
              </small>
            </div>
          </div>
        <?php endif; ?>
      <?php else : ?>
        <!-- Not Configured Visual State -->
        <div class="text-center py-4">
          <div class="position-relative d-inline-block mb-3">
            <svg width="80" height="80" class="circular-progress opacity-25">
              <circle cx="40" cy="40" r="35" fill="none" stroke="#dee2e6" stroke-width="6"/>
            </svg>
            <div class="position-absolute top-50 start-50 translate-middle">
              <i class="bi bi-code-slash text-muted fs-3"></i>
            </div>
          </div>
          <div class="text-muted mb-2"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></div>
          <a href="?page=wc-product-setting-page&tab=pills-general-tab#proxy-settings" class="btn btn-warning btn-sm">
            <i class="bi bi-plus me-1"></i><?php esc_html_e('Setup Now', 'ams-wc-amazon'); ?>
          </a>
        </div>
      <?php endif; ?>
        </div>
    </div>

    <!-- LICENSE -->
      <div class="col-xxl col-xl col-lg col-md-6 col-12">
        <div id="license-card" class="card h-100 shadow-sm ams-dashboard-license-card">
      <?php
        $ams_activated_status = get_option('ams_activated_status', '');
        $saved_license_key = get_option('ams_activated_license', '');
        $activated_site = get_option('ams_activated_site', '');
        $is_active = ($ams_activated_status === 'success');
        
        // Get plugin info
        $plugin_data = get_file_data(AMS_PLUGIN_FILE, array(
            'Version' => 'Version',
            'Author' => 'Author',
            'Last Updated' => 'Last Updated'
        ));
        $plugin_version = $plugin_data['Version'];
        
        // Check for updates using existing logic
        $new_version = ams_check_version();
        $update_available = $new_version && version_compare(AMS_PLUGIN_VERSION, $new_version, '<');
        $update_status = $update_available ? __('Available', 'ams-wc-amazon') : __('Up to Date', 'ams-wc-amazon');
        $update_color = $update_available ? 'warning' : 'success';
        $update_icon = $update_available ? 'fa-exclamation-triangle' : 'fa-check-circle';
        
        // Parse domain from activated site
        $licensed_domain = $activated_site ? parse_url($activated_site, PHP_URL_HOST) : home_url();
        if (!$licensed_domain) {
            $licensed_domain = parse_url(home_url(), PHP_URL_HOST);
        }
      ?>
      <!-- Minimalist Header -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h5 class="mb-0 fw-bold text-info"><?php esc_html_e('License', 'ams-wc-amazon'); ?></h5>
          <small class="text-muted"><?php esc_html_e('CodeCanyon', 'ams-wc-amazon'); ?></small>
        </div>
        <div class="text-end">
          <small id="license-status-badge" class="status-badge status-<?php echo $is_active ? 'active' : 'inactive'; ?> mb-1 d-block">
            <span id="license-status-text"><?php echo $is_active ? esc_html(strtoupper(__('Active', 'ams-wc-amazon'))) : esc_html(strtoupper(__('Inactive', 'ams-wc-amazon'))); ?></span>
          </small>
        </div>
      </div>
      
      <!-- License Input -->
      <div class="card mb-3">
        <div class="input-group input-group-sm">
          <input type="text"
                 id="purchase_code"
                 name="purchase_code"
                 class="form-control form-control"
                 placeholder="<?php esc_attr_e('Enter license key', 'ams-wc-amazon'); ?>"
                 value="<?php echo esc_attr($saved_license_key); ?>"
                 <?php echo $is_active ? 'disabled' : ''; ?>>
          <?php if ($is_active): ?>
            <button type="button" class="btn btn-outline-danger ams-deactivated">
              <i class="bi bi-power"></i>
            </button>
          <?php else: ?>
            <button type="button" class="btn btn-primary btn btn-primary">
              <i class="bi bi-check"></i>
            </button>
          <?php endif; ?>
        </div>
        <div class="alert alert-success" style="display:none;"></div>
      </div>
      
      <!-- License Message -->
      <div class="mb-3" id="license-message-container">
        <?php if ($is_active): ?>
          <div class="alert alert-success border-0 py-2 px-3 mb-0" role="alert">
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0 me-2">
                <div class="bg-success bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                  <i class="bi bi-check-circle-fill text-success"></i>
                </div>
              </div>
              <div class="flex-grow-1">
                <h6 class="alert-heading mb-0 fw-semibold text-success">
                  <?php esc_html_e('License Active', 'ams-wc-amazon'); ?>
                </h6>
                <small class="text-success-emphasis">
                  <?php esc_html_e('Your license is active. Thank you for your purchase!', 'ams-wc-amazon'); ?>
                </small>
              </div>
            </div>
          </div>
        <?php else: ?>
          <div class="alert alert-info border-0 py-2 px-3 mb-0" role="alert">
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0 me-2">
                <div class="bg-info bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                  <i class="bi bi-key-fill text-info"></i>
                </div>
              </div>
              <div class="flex-grow-1">
                <h6 class="alert-heading mb-0 fw-semibold text-info">
                  <?php esc_html_e('License Required', 'ams-wc-amazon'); ?>
                </h6>
                <small class="text-info-emphasis">
                  <?php esc_html_e('Enter your CodeCanyon purchase code below to activate the plugin.', 'ams-wc-amazon'); ?>
                </small>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>
      
      <!-- Status Info -->
      <div id="license-status-info" class="text-center py-2 bg-light rounded">
        <?php if ($is_active): ?>
          <small class="text-success d-block" id="license-status-subtext"><i class="bi bi-check-circle me-1"></i><?php esc_html_e('Licensed', 'ams-wc-amazon'); ?></small>
          <?php if ($licensed_domain): ?>
            <small class="text-muted"><?php echo esc_html($licensed_domain); ?></small>
          <?php endif; ?>
        <?php else: ?>
          <small class="text-muted" id="license-status-subtext"><?php esc_html_e('Not activated', 'ams-wc-amazon'); ?></small>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>


  <!-- System Requirements -->
  <div class="row mt-4">
    <div class="col-12">
      <div class="card shadow-sm border-0 ams-common-card-fix">
        <?php 
        $settings = displayServerSettings(); 
        $total = count($settings);
        $passed = count(array_filter($settings, function($s) { return $s['meets_requirement']; }));
        $allPassed = ($passed === $total);
        ?>
        
        <div class="card-header bg-light">
          <div class="d-flex justify-content-between align-items-center">
            <h4 class="mb-0 fw-bold">
              <i class="bi bi-server me-2"></i>
              <?php esc_html_e('System Requirements', 'ams-wc-amazon'); ?>
            </h4>
            <div class="d-flex align-items-center gap-2">
              <span class="badge bg-<?php echo $allPassed ? 'success' : 'warning'; ?> px-3 py-2">
                <i class="bi bi-<?php echo $allPassed ? 'check-circle' : 'exclamation-triangle'; ?> me-1"></i>
                <?php echo esc_html($passed . '/' . $total); ?> <?php esc_html_e('Passed', 'ams-wc-amazon'); ?>
              </span>
              <button class="btn btn-outline-secondary btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#systemRequirementsDetails" aria-expanded="false">
                <i class="bi bi-chevron-down"></i> <?php esc_html_e('Details', 'ams-wc-amazon'); ?>
              </button>
            </div>
          </div>
        </div>
        
        <div class="card-body pb-2">
          <div class="row g-3 ams-common-card-fix">
            <?php foreach ($settings as $s): ?>
              <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm <?php echo $s['meets_requirement'] ? 'border-start border-success border-3' : 'border-start border-danger border-3'; ?>">
                  <div class="card-body p-3">
                    <div class="d-flex align-items-center justify-content-between">
                      <div class="flex-grow-1">
                        <h6 class="card-title mb-1 fw-bold text-dark text-truncate" title="<?php echo esc_attr($s['name']); ?>"><?php echo esc_html($s['name']); ?></h6>
                        <?php if (isset($s['ini_name'])): ?>
                          <small class="text-muted d-block mb-2 font-monospace" style="font-size: 0.75rem;">
                            <code class="bg-light px-2 py-1 rounded copy-ini-setting" 
                                  style="cursor: pointer; transition: all 0.2s ease;" 
                                  onclick="copyIniSetting('<?php echo esc_js($s['ini_name']); ?>', this)" 
                                  title="<?php esc_attr_e('Click to copy ini setting name', 'ams-wc-amazon'); ?>">
                              <?php echo esc_html($s['ini_name']); ?>
                              <i class="bi bi-copy ms-1 text-primary"></i>
                            </code>
                          </small>
                        <?php endif; ?>
                        <div class="d-flex align-items-center gap-2">
                          <span class="badge <?php echo $s['meets_requirement'] ? 'bg-success' : 'bg-danger'; ?> text-white">
                            <?php echo esc_html($s['value']); ?>
                          </span>
                          <small class="text-muted">/ <?php echo esc_html($s['required']); ?></small>
                        </div>
                      </div>
                      <div class="ms-2">
                        <i class="bi bi-<?php echo $s['meets_requirement'] ? 'check-circle-fill' : 'x-circle-fill'; ?> fs-4 text-<?php echo $s['meets_requirement'] ? 'success' : 'danger'; ?>"></i>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>

        <div class="collapse" id="systemRequirementsDetails">
          <div class="card-body pt-0">
            <div class="table-responsive">
              <table class="table table-sm table-hover mb-0">
                <thead class="table-light">
                  <tr>
                    <th><?php esc_html_e('Setting', 'ams-wc-amazon'); ?></th>
                    <th><?php esc_html_e('Required', 'ams-wc-amazon'); ?></th>
                    <th><?php esc_html_e('Current', 'ams-wc-amazon'); ?></th>
                    <th class="text-center"><?php esc_html_e('Status', 'ams-wc-amazon'); ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($settings as $s): ?>
                    <tr>
                      <td><strong><?php echo esc_html($s['name']); ?></strong></td>
                      <td><?php echo esc_html($s['required']); ?></td>
                      <td><?php echo esc_html($s['value']); ?></td>
                      <td class="text-center">
                        <?php if ($s['meets_requirement']): ?>
                          <span class="badge bg-success text-white">
                            <i class="bi bi-check"></i>
                          </span>
                        <?php else : ?>
                          <span class="badge bg-danger text-white">
                            <i class="bi bi-x"></i>
                          </span>
                        <?php endif; ?>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modern Professional Footer -->
  <footer class="mt-5">
    <div class="card border-0 shadow-sm bg-light ams-common-card-fix">
      <div class="card-body py-4">
        <div class="container-fluid">
          <!-- Main Footer Grid -->
          <div class="row align-items-center">
            
            <!-- Left: Branding & Copyright -->
            <div class="col-lg-4 col-md-6 col-12 text-center text-md-start mb-3 mb-lg-0">
              <div class="d-flex align-items-center justify-content-center justify-content-md-start">
                <img src="<?php echo esc_url(AMS_PLUGIN_URL . 'assets/plugin/img/brand/ams.png'); ?>" 
                     alt="AMS Amazon Logo" 
                     style="height: 28px; border-radius: 6px; box-shadow: 0 2px 6px rgba(0,0,0,0.1);" 
                     class="me-2">
                <div>
                  <div class="fw-bold text-dark small">AMS Amazon</div>
                  <div class="text-muted" style="font-size: 0.8rem;">&copy; <?php echo date("Y"); ?> All rights reserved</div>
                </div>
              </div>
            </div>
            
            <!-- Center: Quick Stats -->
            <div class="col-lg-4 col-md-6 col-12 text-center mb-3 mb-lg-0">
              <div class="d-flex justify-content-center gap-3">
                <div class="text-center">
                  <div class="badge bg-light text-primary border border-primary px-2 py-1">
                    <i class="bi bi-git me-1"></i>
                    v<?php echo esc_html(get_file_data(AMS_PLUGIN_FILE, array('Version' => 'Version'))['Version']); ?>
                  </div>
                  <div class="small text-muted mt-1"><?php esc_html_e('Version', 'ams-wc-amazon'); ?></div>
                </div>
                <div class="text-center">
                  <div class="badge bg-light text-success border border-success px-2 py-1">
                    <i class="bi bi-wordpress me-1"></i>
                    <?php echo get_bloginfo('version'); ?>
                  </div>
                  <div class="small text-muted mt-1"><?php esc_html_e('WordPress', 'ams-wc-amazon'); ?></div>
                </div>
                <div class="text-center">
                  <div class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25 px-2 py-1">
                    <i class="bi bi-filetype-php me-1"></i>
                    <?php echo PHP_VERSION; ?>
                  </div>
                  <div class="small text-muted mt-1"><?php esc_html_e('PHP', 'ams-wc-amazon'); ?></div>
                </div>
              </div>
            </div>
            
            <!-- Right: Quick Links -->
            <div class="col-lg-4 col-12 text-center text-lg-end">
              <div class="d-flex justify-content-center justify-content-lg-end gap-2 flex-wrap">
                <a href="https://affiliatepro.org/knowledge-base/" 
                   class="btn btn-outline-primary btn-sm" 
                   target="_blank" 
                   rel="noopener noreferrer">
                  <i class="bi bi-book me-1"></i><?php esc_html_e('Docs', 'ams-wc-amazon'); ?>
                </a>
                <a href="https://codecanyon.net/item/affiliate-management-system-woocommerce-amazon/29955429/support" 
                   class="btn btn-outline-success btn-sm" 
                   target="_blank" 
                   rel="noopener noreferrer">
                  <i class="bi bi-headset me-1"></i><?php esc_html_e('Support', 'ams-wc-amazon'); ?>
                </a>
                <a href="https://affiliatepro.org/woocommerce-amazon-logs/" 
                   class="btn btn-outline-info btn-sm" 
                   target="_blank" 
                   rel="noopener noreferrer">
                  <i class="bi bi-clipboard-check me-1"></i><?php esc_html_e('Changelog', 'ams-wc-amazon'); ?>
                </a>
              </div>
              <div class="mt-2">
                <a href="https://affiliatepro.org/suggestion-request/" 
                   class="text-muted text-decoration-none small" 
                   target="_blank" 
                   rel="noopener noreferrer">
                  <i class="bi bi-lightbulb me-1"></i><?php esc_html_e('Feature Suggestions', 'ams-wc-amazon'); ?>
                </a>
              </div>
            </div>
            
          </div>
          
          <!-- Bottom Divider & Additional Info -->
          <hr class="my-3 text-muted">
          <div class="row">
            <div class="col-12 text-center">
              <small class="text-muted">
                <?php esc_html_e('Transform your WooCommerce store into a powerful Amazon affiliate platform', 'ams-wc-amazon'); ?>
                <span class="mx-2">•</span>
                <a href="https://codecanyon.net/item/affiliate-management-system-woocommerce-amazon/29955429" 
                   class="text-muted text-decoration-none" 
                   target="_blank" 
                   rel="noopener noreferrer">
                  <?php esc_html_e('Rate us on CodeCanyon', 'ams-wc-amazon'); ?> ⭐
                </a>
              </small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </footer>
</div>

<!-- Enhanced JavaScript -->
<script>
jQuery(document).ready(function($) {
    // Initialize Bootstrap dropdowns if not already initialized
    if (typeof bootstrap !== 'undefined' && bootstrap.Dropdown) {
        var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'));
        var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
            return new bootstrap.Dropdown(dropdownToggleEl);
        });
    }

    // Copy ini setting function with visual feedback
    window.copyIniSetting = function(iniName, element) {
        navigator.clipboard.writeText(iniName).then(function() {
            // Visual feedback - change icon and show success
            const icon = element.querySelector('i');
            const originalIcon = icon.className;
            
            // Change to success icon
            icon.className = 'bi bi-check-circle-fill ms-1 text-success';
            element.style.backgroundColor = '#d1e7dd';
            element.style.borderColor = '#badbcc';
            
            // Show toast notification if available
            if (typeof showToast === 'function') {
                showToast('Copied: ' + iniName, 'success');
            }
            
            // Reset after 2 seconds
            setTimeout(function() {
                icon.className = originalIcon;
                element.style.backgroundColor = '';
                element.style.borderColor = '';
            }, 2000);
        }).catch(function(err) {
            console.error('Failed to copy: ', err);
            if (typeof showToast === 'function') {
                showToast('Failed to copy ini setting name', 'error');
            }
        });
    };

    const input = $('#purchase_code');
    const activateBtn = $('.btn btn-primary');
    const licenseStatusText = $('#license-status-text');
    const licenseStatusSubtext = $('#license-status-subtext');
    const licenseSuccessAlert = $('.alert alert-success');

    // Initialize Bootstrap popover (only if element exists)
    var popover = null;
    var licenseInfoIcon = document.getElementById('license-info-icon');
    
    if (licenseInfoIcon && typeof bootstrap !== 'undefined' && bootstrap.Popover) {
        popover = new bootstrap.Popover(licenseInfoIcon, {
            trigger: 'manual',
            html: true
        });

        // Show popover on hover or focus
        $('#license-info-icon').on('mouseenter focus', function() {
            if (popover) popover.show();
        });

        // Hide popover when mouse leaves the icon and the popover itself
        $('#license-info-icon').on('mouseleave', function(e) {
            setTimeout(function() {
                if (!$('.popover:hover').length && popover) {
                    popover.hide();
                }
            }, 300);
        });

        // Hide popover when mouse leaves the popover
        $(document).on('mouseleave', '.popover', function() {
            if (popover) popover.hide();
        });

        // Hide popover when clicking outside
        $(document).on('click', function(e) {
            if ($(e.target).closest('#license-info-icon, .popover').length === 0 && popover) {
                popover.hide();
            }
        });
    }

    // Enable/disable activate button based on input
    input.on('input', function() {
        activateBtn.prop('disabled', !this.value.trim());
    });

    // Add hover effects for cards
    $('.card').hover(
        function() {
            $(this).addClass('shadow-lg');
        },
        function() {
            $(this).removeClass('shadow-lg');
        }
    );

    // Add smooth scrolling for navigation (only for valid anchors)
    $('a[href^="#"]:not([href="#"])').on('click', function(e) {
        var href = this.getAttribute('href');
        if (href && href.length > 1) { // Ensure href has content after #
            e.preventDefault();
            const target = $(href);
            if (target.length) {
                $('html, body').animate({
                    scrollTop: target.offset().top - 100
                }, 800);
            }
        }
    });

    // Listen for existing license activation success
    $(document).on('licenseActivated', function() {
        // Update status badge
        $('#license-status-badge')
            .removeClass('status-inactive')
            .addClass('status-active');
        $('#license-status-text').text('<?php echo esc_js(strtoupper(__('Active', 'ams-wc-amazon'))); ?>');
        
        // Update entire status info section for activation
        $('#license-status-info').html(
            '<small class="text-success d-block"><i class="bi bi-check-circle me-1"></i><?php echo esc_js(__('Licensed', 'ams-wc-amazon')); ?></small>' +
            '<small class="text-muted"><?php echo esc_js(parse_url(home_url(), PHP_URL_HOST)); ?></small>'
        );
        
        // Show success alert
        licenseSuccessAlert.show();
    });

    // Listen for existing license deactivation success
    $(document).on('licenseDeactivated', function() {
        // Update status badge
        $('#license-status-badge')
            .removeClass('status-active')
            .addClass('status-inactive');
        $('#license-status-text').text('<?php echo esc_js(strtoupper(__('Inactive', 'ams-wc-amazon'))); ?>');
        
        // Update entire status info section for deactivation
        $('#license-status-info').html(
            '<small class="text-muted"><?php echo esc_js(__('Not activated', 'ams-wc-amazon')); ?></small>'
        );
        
        // Hide success alert
        licenseSuccessAlert.hide();
    });

    // Reset dashboard statistics functionality
    $(document).on('click', '.reset-stats-btn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var resetType = $(this).data('type');
        var resetTypeText = $(this).text().trim();
        
        // Confirmation dialog
        if (!confirm('Are you sure you want to ' + resetTypeText.toLowerCase() + '? This action cannot be undone and will reset all related statistics to zero.')) {
            return;
        }
        
        var $btn = $(this);
        var originalHtml = $btn.html();
        
        // Show loading state
        $btn.html('<i class="bi bi-arrow-clockwise me-2"></i>Resetting...').addClass('disabled');
        
        // AJAX request
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'ams_reset_dashboard_stats',
                reset_type: resetType,
                nonce: '<?php echo wp_create_nonce('ams_reset_dashboard_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    // Show success message using global showToast if available, otherwise alert
                    if (typeof showToast === 'function') {
                        showToast('success', response.data.message);
                    } else {
                        alert(response.data.message);
                    }
                    
                    // Update statistics cards with reset values
                    if (response.data.reset_stats) {
                        updateStatisticsCards(response.data.reset_stats, resetType);
                    }
                    
                    // Reload page after short delay to show updated data
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                } else {
                    var errorMsg = response.data.message || 'An error occurred while resetting statistics.';
                    if (typeof showToast === 'function') {
                        showToast('error', errorMsg);
                    } else {
                        alert(errorMsg);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                var errorMsg = 'Network error occurred. Please try again.';
                if (typeof showToast === 'function') {
                    showToast('error', errorMsg);
                } else {
                    alert(errorMsg);
                }
            },
            complete: function() {
                // Restore button state
                $btn.html(originalHtml).removeClass('disabled');
            }
        });
    });

    // Function to update statistics cards with reset values
    function updateStatisticsCards(resetStats, resetType) {
        if (resetType === 'all' || resetType === 'products') {
            $('.row .card').eq(0).find('.h4').text('0');
        }
        if (resetType === 'all' || resetType === 'views') {
            $('.row .card').eq(1).find('.h4').text('0');
        }
        if (resetType === 'all' || resetType === 'cart') {
            $('.row .card').eq(2).find('.h4').text('0');
        }
        if (resetType === 'all' || resetType === 'redirects') {
            $('.row .card').eq(3).find('.h4').text('0');
        }
    }

    // Global toast function for dashboard (if not already defined)
    if (typeof showToast === 'undefined') {
        window.showToast = function(type, message) {
            // Create toast element
            var toast = $('<div class="toast align-items-center text-white bg-' + (type === 'success' ? 'success' : 'danger') + ' border-0" role="alert" aria-live="assertive" aria-atomic="true">')
                .css({
                    position: 'fixed',
                    top: '50px', // Below WordPress admin bar
                    right: '20px',
                    zIndex: '999999' // Higher than WordPress admin bar
                })
                .html(`
                    <div class="d-flex">
                        <div class="toast-body">
                            <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-triangle'} me-2"></i>
                            ${message}
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                `);
            
            $('body').append(toast);
            
            // Initialize and show toast
            var bsToast = new bootstrap.Toast(toast[0]);
            bsToast.show();
            
            // Remove from DOM after it's hidden
            toast[0].addEventListener('hidden.bs.toast', function() {
                toast.remove();
            });
        };
    }
    
    // Handle license card anchor navigation and auto-focus
    function handleLicenseCardNavigation() {
        if (window.location.hash === '#license-card') {
            // Scroll to license card with smooth animation
            const licenseCard = document.getElementById('license-card');
            if (licenseCard) {
                // Add enhanced highlight effect with border and glow
                licenseCard.style.transition = 'all 0.4s cubic-bezier(0.4, 0, 0.2, 1)';
                licenseCard.style.transform = 'scale(1.03)';
                licenseCard.style.boxShadow = '0 12px 35px rgba(255, 193, 7, 0.4), 0 0 0 3px rgba(255, 193, 7, 0.3)';
                licenseCard.style.border = '2px solid #ffc107';
                licenseCard.style.borderRadius = '12px';
                
                // Scroll to card
                licenseCard.scrollIntoView({ 
                    behavior: 'smooth', 
                    block: 'center' 
                });
                
                // Focus on license input field after scroll
                setTimeout(function() {
                    const licenseInput = document.getElementById('purchase_code');
                    if (licenseInput && !licenseInput.disabled) {
                        // Add input field highlight
                        licenseInput.style.transition = 'all 0.3s ease';
                        licenseInput.style.borderColor = '#ffc107';
                        licenseInput.style.boxShadow = '0 0 0 0.2rem rgba(255, 193, 7, 0.25)';
                        
                        licenseInput.focus();
                        licenseInput.select(); // Select any existing text
                        
                        // Prevent blur events for the first few seconds
                        let preventBlur = function(e) {
                            e.preventDefault();
                            licenseInput.focus();
                        };
                        
                        licenseInput.addEventListener('blur', preventBlur);
                        
                        // Remove blur prevention after 3 seconds
                        setTimeout(function() {
                            licenseInput.removeEventListener('blur', preventBlur);
                        }, 3000);
                        
                        // Keep the visual highlight longer
                        setTimeout(function() {
                            // Only remove visual effects, never touch focus
                            licenseInput.style.borderColor = '';
                            licenseInput.style.boxShadow = '';
                        }, 5000);
                    }
                    
                    // Remove card highlight effect after focus
                    setTimeout(function() {
                        licenseCard.style.transform = '';
                        licenseCard.style.boxShadow = '';
                        licenseCard.style.border = '';
                        licenseCard.style.borderRadius = '';
                    }, 1500);
                }, 800);
                
                // Remove hash from URL after navigation
                setTimeout(function() {
                    history.replaceState(null, null, window.location.pathname + window.location.search);
                }, 1500);
            }
        }
    }
    
    // Check for anchor on page load
    handleLicenseCardNavigation();
    
    // Handle anchor changes (if user navigates with hash)
    window.addEventListener('hashchange', handleLicenseCardNavigation);
    
    // Initialize visual enhancements
    initializeVisualEnhancements();
});

// Visual Enhancements Functions
function initializeVisualEnhancements() {
    // Animate circular progress rings
    animateProgressRings();
    
    // Animate counters
    animateCounters();
    
    // Initialize status indicators
    initializeStatusIndicators();
}

function animateProgressRings() {
    const rings = document.querySelectorAll('.progress-ring');
    rings.forEach(ring => {
        const circumference = 2 * Math.PI * 35;
        ring.style.strokeDasharray = circumference;
        ring.style.strokeDashoffset = circumference;
        
        // Animate the ring
        setTimeout(() => {
            ring.style.transition = 'stroke-dashoffset 2s ease-in-out';
            const targetOffset = ring.getAttribute('stroke-dashoffset');
            ring.style.strokeDashoffset = targetOffset;
        }, 500);
    });
}

function animateCounters() {
    const counters = document.querySelectorAll('[data-counter]');
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-counter'));
        const isPercentage = counter.textContent.includes('%');
        const isSpan = counter.tagName.toLowerCase() === 'span';
        let current = 0;
        const increment = target / 50; // 50 steps
        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }
            if (isSpan) {
                // For spans inside "used / total" format, only update the span content
                counter.textContent = Math.floor(current).toLocaleString();
            } else {
                // For percentage displays, update with %
                counter.textContent = Math.floor(current) + (isPercentage ? '%' : '');
            }
        }, 40);
    });
}

function initializeStatusIndicators() {
    const indicators = document.querySelectorAll('.status-indicator');
    indicators.forEach(indicator => {
        if (indicator.classList.contains('status-active')) {
            // Add pulsing animation for active status
            indicator.style.animation = 'pulse 2s infinite';
        }
    });
}
</script>

<style>
/* Visual Enhancement Styles */
.circular-progress {
    transform: rotate(-90deg);
    transition: all 0.3s ease;
}

.progress-ring {
    transition: stroke-dashoffset 2s ease-in-out;
}

.status-indicator {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    display: inline-block;
}

.status-indicator.status-active {
    background-color: #28a745;
    box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.3);
}

.status-indicator.status-inactive {
    background-color: #6c757d;
    box-shadow: 0 0 0 2px rgba(108, 117, 125, 0.3);
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.3);
    }
    50% {
        box-shadow: 0 0 0 6px rgba(40, 167, 69, 0.1);
    }
    100% {
        box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.3);
    }
}

/* Card hover effects */
.ams-dashboard-service-card {
    transition: all 0.3s ease;
}

.ams-dashboard-service-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

/* Subtle background animations */
.bg-danger.opacity-10,
.bg-success.opacity-10,
.bg-warning.opacity-10,
.bg-primary.opacity-10,
.bg-info.opacity-10,
.bg-secondary.opacity-10 {
    animation: subtleGlow 3s ease-in-out infinite alternate;
}

@keyframes subtleGlow {
    0% { opacity: 0.05; }
    100% { opacity: 0.15; }
}

/* Enhanced visual effects */
.circular-progress:hover {
    transform: rotate(-90deg) scale(1.05);
}

/* Stat box hover effects */
.row .col-4 > div:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

/* Progress ring animation enhancement */
.progress-ring {
    filter: drop-shadow(0 0 3px rgba(0,0,0,0.1));
}

/* Status indicator enhancement */
.status-indicator.status-active {
    animation: pulse 2s infinite, glow 3s ease-in-out infinite alternate;
}

@keyframes glow {
    0% { 
        box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.3);
    }
    100% { 
        box-shadow: 0 0 0 4px rgba(40, 167, 69, 0.2), 0 0 8px rgba(40, 167, 69, 0.1);
    }
}

/* Icon animations */
.fs-5 {
    transition: all 0.3s ease;
}

.row .col-4 > div:hover .fs-5 {
    transform: scale(1.1);
    filter: brightness(1.2);
}

/* Card gradient backgrounds */
.ams-dashboard-service-card {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    border: 1px solid rgba(0,0,0,0.05);
}

.ams-dashboard-service-card:hover {
    background: linear-gradient(135deg, #ffffff 0%, #f1f3f4 100%);
    border: 1px solid rgba(0,0,0,0.1);
}

/* Counter animation enhancement */
[data-counter] {
    font-variant-numeric: tabular-nums;
    transition: all 0.3s ease;
}


/* Not configured state enhancement */
.text-center.py-4 {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 2px dashed #dee2e6;
    border-radius: 12px;
    transition: all 0.3s ease;
}

.text-center.py-4:hover {
    border-color: #adb5bd;
    background: linear-gradient(135deg, #f1f3f4 0%, #e9ecef 100%);
}
</style>

</div>
<?php include "common-footer.php"; ?>
