<?php include "common-header.php"; ?>

<div class="container-fluid">
            <div class="row">
        <div class="col-12">
            <!-- Main Review Import Card -->
            <div class="card shadow-sm ams-common-card-fix" style="overflow-x: hidden; word-wrap: break-word;">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-star text-primary me-2"></i>
                            <?= esc_html__('Product Review Import', 'ams-wc-amazon'); ?>
                            </h5>
                        <div class="d-flex gap-2">
                            <span class="badge bg-primary px-3 py-2">
                                <i class="bi bi-shop me-1"></i><?= esc_html__('Amazon Integration', 'ams-wc-amazon'); ?>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (isset($_GET['settings_saved']) && $_GET['settings_saved'] == '1'): ?>
                        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
                            <i class="bi bi-check-circle me-2"></i>
                            <?php esc_html_e('Review settings saved successfully!', 'ams-wc-amazon'); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Navigation Tabs -->
                    <ul class="nav nav-tabs" id="reviewTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="import-tab" data-bs-toggle="tab" data-bs-target="#import-panel" type="button" role="tab">
                                <i class="bi bi-download me-2"></i><?= esc_html__('Import Reviews', 'ams-wc-amazon'); ?>
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="bulk-tab" data-bs-toggle="tab" data-bs-target="#bulk-panel" type="button" role="tab">
                                <i class="bi bi-layers me-2"></i><?= esc_html__('Bulk Operations', 'ams-wc-amazon'); ?>
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="settings-tab" data-bs-toggle="tab" data-bs-target="#settings-panel" type="button" role="tab">
                                <i class="bi bi-gear me-2"></i><?= esc_html__('Review Settings', 'ams-wc-amazon'); ?>
                            </button>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content pt-3" id="reviewTabContent">
        <!-- Import Reviews Tab -->
        <div class="tab-pane fade show active" id="import-panel" role="tabpanel">
            <div class="row g-3">
                <!-- Product Selection -->
                <div class="col-xl-5 col-lg-6 col-md-12">
                    <div class="card shadow-sm h-100 border-0 ams-common-card-fix">
                        <div class="card-header bg-primary text-white py-2">
                            <h6 class="mb-0 fw-semibold">
                                <i class="bi bi-box me-2"></i><?= esc_html__('Select Product', 'ams-wc-amazon'); ?>
                            </h6>
                        </div>
                        <div class="card-body">
                            <div id="validation-error-message" class="alert alert-danger d-none" role="alert"></div>
                            
                            <form id="ams_product_review" class="wca-product-review-import" method="POST">
                                <div class="mb-4">
                                    <label class="form-label fw-semibold text-dark mb-3">
                                        <i class="bi bi-box-seam me-2 text-primary"></i><?= esc_html__('Choose a Product', 'ams-wc-amazon'); ?>
                                    </label>
                                    <select name="ams_product" id="ams_product" class="form-select form-select-lg shadow-sm" required>
                                        <option value="" disabled selected><?= esc_html__('Select a Product...', 'ams-wc-amazon'); ?></option>
                                        <?php 
                                        // Get unique products with Amazon URLs, excluding variations
                                        $args = array(
                                            'post_type' => 'product',
                                            'post_status' => 'publish',
                                            'posts_per_page' => -1,
                                            'meta_query' => array(
                                                array(
                                                    'key' => '_ams_product_url',
                                                    'value' => '',
                                                    'compare' => '!='
                                                )
                                            ),
                                            'orderby' => 'title',
                                            'order' => 'ASC'
                                        );
                                        
                                        $posts = get_posts($args);
                                        $processed_products = array(); // Track processed products to avoid duplicates
                                        
                                        foreach ($posts as $post) {
                                            $amazon_url = get_post_meta($post->ID, '_ams_product_url', true);
                                            if (!$amazon_url) continue;
                                            
                                            $product = wc_get_product($post->ID);
                                            if (!$product) continue;
                                            
                                            // Skip variations - only show parent products
                                            if ($product->get_type() === 'variation') {
                                                continue;
                                            }
                                            
                                            // Check for duplicates based on title and ASIN
                                            $asin = '';
                                            if (preg_match('/\/dp\/([A-Z0-9]{10})/', $amazon_url, $matches)) {
                                                $asin = $matches[1];
                                            }
                                            
                                            $product_key = sanitize_title($post->post_title) . '_' . $asin;
                                            if (in_array($product_key, $processed_products)) {
                                                continue; // Skip duplicate
                                            }
                                            $processed_products[] = $product_key;
                                            
                                            $review_count = get_comments(['post_id' => $post->ID, 'type' => 'review', 'status' => 'approve', 'count' => true]);
                                            $rating = get_post_meta($post->ID, '_wc_average_rating', true);
                                            
                                            // Generate Amazon reviews URL
                                            $amazon_reviews_url = '';
                                            if ($asin) {
                                                $domain = parse_url($amazon_url, PHP_URL_HOST);
                                                $amazon_reviews_url = 'https://' . $domain . '/product-reviews/' . $asin;
                                            }
                                            
                                            // Clean product title for display
                                            $display_title = wp_trim_words($post->post_title, 8, '...');
                                            
                                            echo '<option value="' . esc_attr($post->ID) . '" 
                                                    data-review-count="' . esc_attr($review_count) . '" 
                                                    data-rating="' . esc_attr($rating ?: '0') . '"
                                                    data-amazon-url="' . esc_attr($amazon_url) . '"
                                                    data-amazon-reviews-url="' . esc_attr($amazon_reviews_url) . '"
                                                    data-asin="' . esc_attr($asin) . '">' . 
                                                    esc_html($display_title) . 
                                                    ($review_count > 0 ? ' (' . $review_count . ' reviews)' : ' (no reviews)') .
                                                  '</option>';
                                        }
                                        ?>
                                    </select>
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1 text-info"></i>
                                        <?= esc_html__('Only products with Amazon URLs are shown', 'ams-wc-amazon'); ?>
                                    </div>
                                </div>

                                <!-- Advanced Import Filters -->
                                <div class="mb-4">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <label class="form-label fw-semibold text-dark mb-0">
                                            <i class="bi bi-funnel me-2 text-success"></i><?= esc_html__('Import Filters', 'ams-wc-amazon'); ?>
                                        </label>
                                        <button type="button" class="btn btn-sm btn-outline-primary shadow-sm" data-bs-toggle="collapse" data-bs-target="#advancedFilters">
                                            <i class="bi bi-gear me-1"></i><?= esc_html__('Advanced', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    
                                    <div class="row g-3">
                                        <div class="col-6">
                                            <label class="form-label small fw-medium text-secondary">
                                                <i class="bi bi-hash me-1"></i><?= esc_html__('Review Limit', 'ams-wc-amazon'); ?>
                                            </label>
                                            <select name="review_limit" class="form-select form-select-sm shadow-sm border-primary-subtle">
                                                <option value="5">5 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                                <option value="10" selected>10 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                                <option value="20">20 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                                <option value="50">50 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-6">
                                            <label class="form-label small fw-medium text-secondary">
                                                <i class="bi bi-star me-1"></i><?= esc_html__('Min Rating', 'ams-wc-amazon'); ?>
                                            </label>
                                            <select name="min_rating" class="form-select form-select-sm shadow-sm border-warning-subtle">
                                                <option value="1"><?= esc_html__('All Ratings', 'ams-wc-amazon'); ?></option>
                                                <option value="2">2+ <?= esc_html__('Stars', 'ams-wc-amazon'); ?></option>
                                                <option value="3">3+ <?= esc_html__('Stars', 'ams-wc-amazon'); ?></option>
                                                <option value="4">4+ <?= esc_html__('Stars', 'ams-wc-amazon'); ?></option>
                                                <option value="5">5 <?= esc_html__('Stars Only', 'ams-wc-amazon'); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="collapse mt-3" id="advancedFilters">
                                        <div class="card card-body bg-light border-0 shadow-sm ams-common-card-fix">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label small fw-medium text-secondary">
                                                        <i class="bi bi-type me-1"></i><?= esc_html__('Min Review Length', 'ams-wc-amazon'); ?>
                                                    </label>
                                                    <select name="min_length" class="form-select form-select-sm shadow-sm border-info-subtle">
                                                        <option value="0"><?= esc_html__('Any Length', 'ams-wc-amazon'); ?></option>
                                                        <option value="20">20+ <?= esc_html__('characters', 'ams-wc-amazon'); ?></option>
                                                        <option value="50">50+ <?= esc_html__('characters', 'ams-wc-amazon'); ?></option>
                                                        <option value="100">100+ <?= esc_html__('characters', 'ams-wc-amazon'); ?></option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label small fw-medium text-secondary">
                                                        <i class="bi bi-calendar-date me-1"></i><?= esc_html__('Review Age', 'ams-wc-amazon'); ?>
                                                    </label>
                                                    <select name="review_age" class="form-select form-select-sm shadow-sm border-success-subtle">
                                                        <option value="0"><?= esc_html__('All Reviews', 'ams-wc-amazon'); ?></option>
                                                        <option value="30"><?= esc_html__('Last 30 days', 'ams-wc-amazon'); ?></option>
                                                        <option value="90"><?= esc_html__('Last 3 months', 'ams-wc-amazon'); ?></option>
                                                        <option value="365"><?= esc_html__('Last year', 'ams-wc-amazon'); ?></option>
                                                    </select>
                                                </div>
                                                <div class="col-12">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input shadow-sm" type="checkbox" name="verified_only" id="verifiedOnly">
                                                        <label class="form-check-label small fw-medium text-secondary" for="verifiedOnly">
                                                            <i class="bi bi-shield-check me-1 text-success"></i>
                                                            <?= esc_html__('Import only verified purchase reviews', 'ams-wc-amazon'); ?>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Product Info Preview -->
                                <div id="product-preview" class="d-none">
                                    <div class="product-info-card bg-gradient bg-light rounded-3 p-4 mb-4 border border-primary-subtle shadow-sm">
                                        <div class="d-flex align-items-center">
                                            <div class="product-image me-3">
                                                <img src="" alt="Product" class="rounded-3 shadow-sm border border-light" style="width: 60px; height: 60px; object-fit: cover;">
                                            </div>
                                            <div class="product-details flex-grow-1">
                                                <h6 class="product-title mb-2 fw-semibold text-dark"></h6>
                                                <div class="product-meta mb-3">
                                                    <span class="badge bg-warning text-dark me-2 px-3 py-2">
                                                        <i class="bi bi-star-fill me-1"></i><span class="rating-text"></span>
                                                    </span>
                                                    <span class="badge bg-info text-white px-3 py-2">
                                                        <i class="bi bi-chat-dots me-1"></i><span class="review-count-text"></span> reviews
                                                    </span>
                                                </div>
                                                <div class="amazon-links d-flex gap-2">
                                                    <a href="#" id="amazon-product-link" target="_blank" class="btn btn-sm btn-primary shadow-sm">
                                                        <i class="bi bi-box-arrow-up-right me-1"></i><?= esc_html__('View Product', 'ams-wc-amazon'); ?>
                                                    </a>
                                                    <a href="#" id="amazon-reviews-link" target="_blank" class="btn btn-sm btn-success shadow-sm">
                                                        <i class="bi bi-star-fill me-1"></i><?= esc_html__('View Reviews', 'ams-wc-amazon'); ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="d-grid gap-2">
                                    <input type="hidden" name="action" value="ams_product_review_import">
                                    <?php wp_nonce_field('ams_product_review_import_nonce'); ?>
                                    <button type="submit" class="btn btn-primary btn-lg shadow-sm">
                                        <i class="bi bi-cloud-download me-2"></i><?= esc_html__('Import Reviews', 'ams-wc-amazon'); ?>
                                    </button>
                                    <button type="button" id="debug-scraping" class="btn btn-outline-info shadow-sm">
                                        <i class="bi bi-bug me-2"></i><?= esc_html__('Debug Review Scraping', 'ams-wc-amazon'); ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Import Progress & Results -->
                <div class="col-xl-7 col-lg-6 col-md-12">
                    <div class="card shadow-sm h-100 border-0 ams-common-card-fix">
                        <div class="card-header bg-success text-white py-2">
                            <h6 class="mb-0 fw-semibold">
                                <i class="bi bi-graph-up me-2"></i><?= esc_html__('Import Progress & Results', 'ams-wc-amazon'); ?>
                            </h6>
                        </div>
                        <div class="card-body">
                            <!-- Import Status -->
                            <div id="review-import-status" class="d-none">
                                <div class="import-progress-card bg-light rounded p-4 mb-4">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <h6 class="mb-0"><?= esc_html__('Importing Reviews...', 'ams-wc-amazon'); ?></h6>
                                        <span class="progress-percentage">0%</span>
                                    </div>
                                    <div class="progress mb-3" style="height: 8px;">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%"></div>
                                    </div>
                                    <div class="import-status-text text-muted">
                                        <i class="bi bi-arrow-clockwise me-2"></i><?= esc_html__('Connecting to Amazon...', 'ams-wc-amazon'); ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Error Message -->
                            <div id="review_error_message" class="alert alert-danger d-none" role="alert">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <span class="error-text"></span>
                            </div>

                            <!-- Results Container -->
                            <div class="wca-amazon-product-import">
                                <!-- Empty State -->
                                <div class="text-center py-5" id="empty-state">
                                    <div class="mb-4">
                                        <i class="bi bi-star fa-3x text-muted opacity-50"></i>
                                    </div>
                                    <h5 class="text-muted mb-3"><?= esc_html__('Ready to Import Reviews', 'ams-wc-amazon'); ?></h5>
                                    <p class="text-muted mb-4"><?= esc_html__('Select a product from the left panel and click "Import Reviews" to get started.', 'ams-wc-amazon'); ?></p>
                                    <div class="row justify-content-center">
                                        <div class="col-md-8">
                                            <div class="alert alert-info border-0 bg-info-subtle">
                                                <div class="d-flex align-items-start">
                                                    <i class="bi bi-info-circle text-info me-2 mt-1"></i>
                                                    <div class="text-start">
                                                        <strong><?= esc_html__('How it works:', 'ams-wc-amazon'); ?></strong>
                                                        <ul class="mb-0 mt-2 text-muted small">
                                                            <li><?= esc_html__('Choose a product with an Amazon URL', 'ams-wc-amazon'); ?></li>
                                                            <li><?= esc_html__('Click "Import Reviews" to fetch reviews from Amazon', 'ams-wc-amazon'); ?></li>
                                                            <li><?= esc_html__('Reviews will be added to your WooCommerce product', 'ams-wc-amazon'); ?></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Loading Section -->
            <div class="mt-4">
                <div class="text-center">
                    <button type="button" class="loadmore btn btn-primary shadow-sm d-none">
                        <i class="bi bi-plus-circle me-2"></i><?= esc_html__('Load More Reviews', 'ams-wc-amazon'); ?>
                    </button>
                    
                    <div class="wca-loading-icon d-none">
                        <div class="loading-card bg-gradient bg-light rounded-3 p-5 shadow-sm border border-primary-subtle">
                            <div class="spinner-border text-primary mb-4" role="status" style="width: 3rem; height: 3rem;">
                                <span class="visually-hidden"><?= esc_html__('Loading...', 'ams-wc-amazon'); ?></span>
                            </div>
                            <h5 class="text-dark fw-semibold mb-2"><?= esc_html__('Processing Reviews', 'ams-wc-amazon'); ?></h5>
                            <p class="text-muted mb-0"><?= esc_html__('Please wait while we import your reviews...', 'ams-wc-amazon'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bulk Operations Tab -->
        <div class="tab-pane fade" id="bulk-panel" role="tabpanel">
            <div class="row g-3">
                <!-- Product Selection for Bulk -->
                <div class="col-xl-7 col-lg-8 col-md-12">
                    <div class="card shadow-sm border-0 ams-common-card-fix">
                        <div class="card-header bg-info text-white py-2">
                            <h6 class="mb-0 fw-semibold">
                                <i class="bi bi-layers me-2"></i><?= esc_html__('Bulk Product Selection', 'ams-wc-amazon'); ?>
                            </h6>
                        </div>
                        <div class="card-body">
                                                        <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <label class="form-label fw-semibold text-dark mb-0">
                                        <i class="bi bi-check2-square me-2 text-primary"></i><?= esc_html__('Select Products', 'ams-wc-amazon'); ?>
                                    </label>
                                    <div class="btn-group shadow-sm" role="group">
                                        <button type="button" class="btn btn-sm btn-primary" id="selectAllProducts">
                                            <i class="bi bi-check-all me-1"></i><?= esc_html__('Select All', 'ams-wc-amazon'); ?>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-outline-secondary" id="clearAllProducts">
                                            <i class="bi bi-x-lg me-1"></i><?= esc_html__('Clear', 'ams-wc-amazon'); ?>
                                        </button>
    </div>
</div>

                                <div class="bulk-product-list border border-primary-subtle rounded-3 p-3 bg-light shadow-sm" style="max-height: 400px; overflow-y: auto; overflow-x: hidden;">
                                    <?php 
                                    // Reuse the same product query for bulk operations
                                    $args = array(
                                        'post_type' => 'product',
                                        'post_status' => 'publish',
                                        'posts_per_page' => -1,
                                        'meta_query' => array(
                                            array(
                                                'key' => '_ams_product_url',
                                                'value' => '',
                                                'compare' => '!='
                                            )
                                        ),
                                        'orderby' => 'title',
                                        'order' => 'ASC'
                                    );
                                    
                                    $posts = get_posts($args);
                                    $processed_products = array();
                                    
                                    foreach ($posts as $post) {
                                        $amazon_url = get_post_meta($post->ID, '_ams_product_url', true);
                                        if (!$amazon_url) continue;
                                        
                                        $product = wc_get_product($post->ID);
                                        if (!$product || $product->get_type() === 'variation') continue;
                                        
                                        $asin = '';
                                        if (preg_match('/\/dp\/([A-Z0-9]{10})/', $amazon_url, $matches)) {
                                            $asin = $matches[1];
                                        }
                                        
                                        $product_key = sanitize_title($post->post_title) . '_' . $asin;
                                        if (in_array($product_key, $processed_products)) continue;
                                        $processed_products[] = $product_key;
                                        
                                        $review_count = get_comments(['post_id' => $post->ID, 'type' => 'review', 'status' => 'approve', 'count' => true]);
                                        $rating = get_post_meta($post->ID, '_wc_average_rating', true);
                                        $display_title = wp_trim_words($post->post_title, 6, '...');
                                        
                                        echo '<div class="form-check mb-2 p-3 rounded-3 bg-white shadow-sm border border-light-subtle hover-shadow">
                                                <input class="form-check-input bulk-product-checkbox shadow-sm" type="checkbox" 
                                                       value="' . esc_attr($post->ID) . '" 
                                                       id="bulk_product_' . esc_attr($post->ID) . '"
                                                       data-title="' . esc_attr($display_title) . '"
                                                       data-reviews="' . esc_attr($review_count) . '"
                                                       data-rating="' . esc_attr($rating ?: '0') . '">
                                                <label class="form-check-label w-100 fw-medium" for="bulk_product_' . esc_attr($post->ID) . '">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <div class="fw-semibold text-dark">' . esc_html($display_title) . '</div>
                                                            <div class="mt-1">
                                                                <span class="badge bg-info text-white me-1">
                                                                    <i class="bi bi-chat-dots me-1"></i>' . 
                                                                    ($review_count > 0 ? $review_count . ' reviews' : 'No reviews') . 
                                                                '</span>' .
                                                                ($rating > 0 ? '<span class="badge bg-warning text-dark">
                                                                    <i class="bi bi-star-fill me-1"></i>' . number_format($rating, 1) . '
                                                                </span>' : '') . 
                                                            '</div>
                                                        </div>
                                                    </div>
                                                </label>
                                              </div>';
                                    }
                                    ?>
                                </div>
                                
                                <div class="mt-3 p-2 bg-primary-subtle rounded-3 border border-primary-subtle">
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-info-circle text-primary me-2"></i>
                                        <span class="fw-medium text-primary">
                                            <span id="selectedCount">0</span> <?= esc_html__('products selected', 'ams-wc-amazon'); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bulk Operations Controls -->
                <div class="col-xl-5 col-lg-4 col-md-12">
                    <div class="card shadow-sm border-0 ams-common-card-fix">
                        <div class="card-header bg-warning text-dark py-2">
                            <h6 class="mb-0 fw-semibold">
                                <i class="bi bi-gears me-2"></i><?= esc_html__('Bulk Operations', 'ams-wc-amazon'); ?>
                            </h6>
                        </div>
                        <div class="card-body">
                            <!-- Bulk Import Settings -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold text-dark mb-3">
                                    <i class="bi bi-sliders me-2 text-warning"></i><?= esc_html__('Bulk Import Settings', 'ams-wc-amazon'); ?>
                                </label>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <label class="form-label small fw-medium text-secondary">
                                            <i class="bi bi-hash me-1"></i><?= esc_html__('Reviews per Product', 'ams-wc-amazon'); ?>
                                        </label>
                                        <select name="bulk_review_limit" class="form-select form-select-sm shadow-sm border-warning-subtle">
                                            <option value="5">5 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                            <option value="10" selected>10 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                            <option value="15">15 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                            <option value="20">20 <?= esc_html__('reviews', 'ams-wc-amazon'); ?></option>
                                        </select>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small fw-medium text-secondary">
                                            <i class="bi bi-star me-1"></i><?= esc_html__('Min Rating', 'ams-wc-amazon'); ?>
                                        </label>
                                        <select name="bulk_min_rating" class="form-select form-select-sm shadow-sm border-success-subtle">
                                            <option value="1"><?= esc_html__('All Ratings', 'ams-wc-amazon'); ?></option>
                                            <option value="3">3+ <?= esc_html__('Stars', 'ams-wc-amazon'); ?></option>
                                            <option value="4" selected>4+ <?= esc_html__('Stars', 'ams-wc-amazon'); ?></option>
                                            <option value="5">5 <?= esc_html__('Stars Only', 'ams-wc-amazon'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Bulk Actions -->
                            <div class="d-grid gap-3">
                                <button type="button" id="bulkImportReviews" class="btn btn-success btn-lg shadow-sm" disabled>
                                    <i class="bi bi-cloud-download me-2"></i><?= esc_html__('Start Bulk Import', 'ams-wc-amazon'); ?>
                                </button>
                                <button type="button" id="bulkDeleteReviews" class="btn btn-outline-danger shadow-sm" disabled>
                                    <i class="bi bi-trash3 me-2"></i><?= esc_html__('Delete Reviews from Selected', 'ams-wc-amazon'); ?>
                                </button>
                            </div>

                            <!-- Bulk Progress -->
                            <div id="bulkProgress" class="mt-4 d-none">
                                <div class="card bg-light border-0 shadow-sm ams-common-card-fix">
                                    <div class="card-body">
                                        <h6 class="mb-3 fw-semibold text-dark">
                                            <i class="bi bi-graph-up me-2 text-success"></i><?= esc_html__('Bulk Import Progress', 'ams-wc-amazon'); ?>
                                        </h6>
                                        <div class="progress mb-3 shadow-sm" style="height: 10px;">
                                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar" style="width: 0%"></div>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <small class="fw-medium text-secondary" id="bulkProgressText">Preparing...</small>
                                            <small class="fw-bold text-primary" id="bulkProgressPercent">0%</small>
                                        </div>
                                        <div class="d-flex gap-3">
                                            <span class="badge bg-success-subtle text-success px-3 py-2">
                                                <i class="bi bi-check-circle me-1"></i>
                                                <span id="bulkSuccessCount">0 completed</span>
                                            </span>
                                            <span class="badge bg-danger-subtle text-danger px-3 py-2">
                                                <i class="bi bi-x-circle me-1"></i>
                                                <span id="bulkErrorCount">0 failed</span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>





        <!-- Review Settings Tab -->
        <div class="tab-pane fade" id="settings-panel" role="tabpanel">
            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" enctype="multipart/form-data">
                <input type="hidden" name="action" value="ams-wc-review-settings">
                <?php wp_nonce_field("review_settings_nonce", "review_settings_nonce"); ?>
                
                <div class="card shadow-sm border-0 ams-common-card-fix">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0 fw-semibold">
                            <i class="bi bi-star me-2"></i><?php esc_html_e('Amazon Review Settings', 'ams-wc-amazon'); ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-4">
                            <!-- Enable Amazon Review -->
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 fw-semibold"><?php esc_html_e('Enable Amazon Review', 'ams-wc-amazon'); ?></h6>
                                        <small class="text-muted"><?php esc_html_e('Allow importing reviews from Amazon product pages', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    <div class="ms-3">
                                        <label class="ams-common-toggle-switch">
                                            <input type="checkbox" id="enable_amazon_review" name="enable_amazon_review" value="1" <?php checked(get_option('enable_amazon_review'), '1'); ?>>
                                            <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Enable Reviewer Image -->
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 fw-semibold"><?php esc_html_e('Enable Reviewer Image', 'ams-wc-amazon'); ?></h6>
                                        <small class="text-muted"><?php esc_html_e('Display reviewer profile images with reviews', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    <div class="ms-3">
                                        <label class="ams-common-toggle-switch">
                                            <input type="checkbox" id="enable_reviewer_image" name="enable_reviewer_image" value="1" <?php checked(get_option('enable_reviewer_image'), '1'); ?>>
                                            <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Enable Review Title -->
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 fw-semibold"><?php esc_html_e('Enable Review Title', 'ams-wc-amazon'); ?></h6>
                                        <small class="text-muted"><?php esc_html_e('Show review titles from Amazon reviews', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    <div class="ms-3">
                                        <label class="ams-common-toggle-switch">
                                            <input type="checkbox" id="enable_review_title" name="enable_review_title" value="1" <?php checked(get_option('enable_review_title'), '1'); ?>>
                                            <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Review Limit Options -->
                            <div class="col-12" id="review-limit-options">
                                <div class="card border-0 bg-light">
                                    <div class="card-header bg-transparent border-0 pb-0">
                                        <h6 class="mb-0 fw-semibold text-dark">
                                            <i class="bi bi-sliders me-2"></i><?php esc_html_e('Import Limits', 'ams-wc-amazon'); ?>
                                        </h6>
                                    </div>
                                    <div class="card-body pt-3">
                                        <div class="row g-3">
                                            <!-- Single Import Review Limit -->
                                            <div class="col-md-6">
                                                <label for="single_import_review_limit" class="form-label fw-medium"><?php esc_html_e('Single Import Review Limit', 'ams-wc-amazon'); ?></label>
                                                <select class="form-select" id="single_import_review_limit" name="single_import_review_limit">
                                                    <option value="5" <?php selected(get_option('single_import_review_limit'), '5'); ?>>5 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="10" <?php selected(get_option('single_import_review_limit'), '10'); ?>>10 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="15" <?php selected(get_option('single_import_review_limit'), '15'); ?>>15 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="20" <?php selected(get_option('single_import_review_limit'), '20'); ?>>20 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                </select>
                                                <div class="form-text">
                                                    <?php esc_html_e('Maximum number of reviews to import per single product', 'ams-wc-amazon'); ?>
                                                </div>
                                            </div>
                                            
                                            <!-- Multiple Import Review Limit -->
                                            <div class="col-md-6">
                                                <label for="multiple_import_review_limit" class="form-label fw-medium"><?php esc_html_e('Multiple Import Review Limit', 'ams-wc-amazon'); ?></label>
                                                <select class="form-select" id="multiple_import_review_limit" name="multiple_import_review_limit">
                                                    <option value="5" <?php selected(get_option('multiple_import_review_limit'), '5'); ?>>5 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="10" <?php selected(get_option('multiple_import_review_limit'), '10'); ?>>10 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="15" <?php selected(get_option('multiple_import_review_limit'), '15'); ?>>15 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                    <option value="20" <?php selected(get_option('multiple_import_review_limit'), '20'); ?>>20 <?php esc_html_e('reviews', 'ams-wc-amazon'); ?></option>
                                                </select>
                                                <div class="form-text">
                                                    <?php esc_html_e('Maximum number of reviews to import per product in bulk operations', 'ams-wc-amazon'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Save Button -->
                            <div class="col-12">
                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="submit" name="review-settings-submit" class="btn btn-primary btn-lg px-4 py-2 d-flex align-items-center gap-2 fw-semibold">
                                        <i class="bi bi-floppy fs-5"></i>
                                        <span><?php esc_html_e('Save Review Settings', 'ams-wc-amazon'); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

                </div>
            </div>
        </div>
    </div>
</div>



<?php include "common-footer.php"; ?>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Initialize tab state persistence
    initializeTabPersistence();
    
    // Initialize advanced features
    initializeBulkOperations();
    
    // Product selection change handler
    $('#ams_product').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const productId = $(this).val();
        
        if (productId) {
            const reviewCount = selectedOption.data('review-count') || 0;
            const rating = selectedOption.data('rating') || 0;
            const productTitle = selectedOption.text();
            const amazonUrl = selectedOption.data('amazon-url') || '';
            const amazonReviewsUrl = selectedOption.data('amazon-reviews-url') || '';
            const asin = selectedOption.data('asin') || '';
            
            // Update product preview
            $('#product-preview').removeClass('d-none');
            $('.product-title').text(productTitle);
            $('.rating-text').text(rating > 0 ? rating.toFixed(1) : 'No rating');
            $('.review-count-text').text(reviewCount);
            
            // Update Amazon links
            if (amazonUrl) {
                $('#amazon-product-link').attr('href', amazonUrl).removeClass('d-none');
            } else {
                $('#amazon-product-link').addClass('d-none');
            }
            
            if (amazonReviewsUrl) {
                $('#amazon-reviews-link').attr('href', amazonReviewsUrl).removeClass('d-none');
            } else {
                $('#amazon-reviews-link').addClass('d-none');
            }
            
            // Update product image (placeholder for now)
            $('.product-image img').attr('src', '<?= AMS_PLUGIN_URL; ?>assets/plugin/img/brand/no-logo.png');
        } else {
            $('#product-preview').addClass('d-none');
        }
    });

    // Debug scraping functionality
    $('#debug-scraping').on('click', function() {
        const selectedProduct = $("#ams_product").val();
        const selectedOption = $("#ams_product").find('option:selected');
        
        if (!selectedProduct) {
            alert('<?= esc_js(__('Please select a product first.', 'ams-wc-amazon')); ?>');
            return;
        }
        
        const amazonUrl = selectedOption.data('amazon-url') || '';
        const amazonReviewsUrl = selectedOption.data('amazon-reviews-url') || '';
        const asin = selectedOption.data('asin') || '';
        const productTitle = selectedOption.text();
        
        // Show debug information
        let debugInfo = `
            <div class="alert alert-info">
                <h5><i class="bi bi-bug me-2"></i><?= esc_js(__('Debug Information', 'ams-wc-amazon')); ?></h5>
                <p><strong><?= esc_js(__('Product:', 'ams-wc-amazon')); ?></strong> ${productTitle}</p>
                <p><strong><?= esc_js(__('Product ID:', 'ams-wc-amazon')); ?></strong> ${selectedProduct}</p>
                <p><strong><?= esc_js(__('ASIN:', 'ams-wc-amazon')); ?></strong> ${asin || 'Not found'}</p>
                <p><strong><?= esc_js(__('Amazon URL:', 'ams-wc-amazon')); ?></strong> <a href="${amazonUrl}" target="_blank">${amazonUrl}</a></p>
                <p><strong><?= esc_js(__('Amazon Reviews URL:', 'ams-wc-amazon')); ?></strong> <a href="${amazonReviewsUrl}" target="_blank">${amazonReviewsUrl}</a></p>
                <hr>
                <p class="mb-0"><strong><?= esc_js(__('Troubleshooting Tips:', 'ams-wc-amazon')); ?></strong></p>
                <ul class="mb-0">
                    <li><?= esc_js(__('Check if the Amazon product page has reviews by clicking the "View Reviews" link above', 'ams-wc-amazon')); ?></li>
                    <li><?= esc_js(__('Verify that the Amazon URL is accessible and not blocked', 'ams-wc-amazon')); ?></li>
                    <li><?= esc_js(__('Check the error logs for detailed scraping information', 'ams-wc-amazon')); ?></li>
                    <li><?= esc_js(__('Try importing reviews from a different product to test functionality', 'ams-wc-amazon')); ?></li>
                </ul>
            </div>
        `;
        
        $('.wca-amazon-product-import').html(debugInfo);
        $('#empty-state').addClass('d-none');
    });



    // Enhanced form submission with progress tracking
    $("#ams_product_review").submit(function(e) {
        e.preventDefault();
        let form = $(this);
        let selectedProduct = $("#ams_product").val();
        let $validationError = $('#validation-error-message');
        let $reviewError = $('#review_error_message');
        let $importStatus = $('#review-import-status');
        let $submitButton = form.find('button[type="submit"]');
        let $reviewsContainer = $('.wca-amazon-product-import');
        let $progressBar = $('.progress-bar');
        let $progressPercentage = $('.progress-percentage');
        let $statusText = $('.import-status-text');

        // Hide any previous messages and clear container
        $validationError.addClass('d-none').html('');
        $reviewError.addClass('d-none').html('');
        $('#empty-state').addClass('d-none');
        $reviewsContainer.html('');

        // Check if the product is selected
        if (!selectedProduct) {
            $validationError
                .removeClass('d-none')
                .html('<i class="bi bi-exclamation-triangle me-2"></i><?= esc_js(__('Please choose a product from the dropdown list to proceed with the review retrieval.', 'ams-wc-amazon')); ?>');
            return false;
        }
        
        // Show import status with enhanced progress
        $importStatus.removeClass('d-none');
        $submitButton.prop('disabled', true);
        
        // Simulate progress updates
        let progress = 0;
        const progressInterval = setInterval(function() {
            progress += Math.random() * 15;
            if (progress > 90) progress = 90;
            
            $progressBar.css('width', progress + '%');
            $progressPercentage.text(Math.round(progress) + '%');
            
            if (progress < 30) {
                $statusText.html('<i class="bi bi-arrow-clockwise me-2"></i><?= esc_js(__('Connecting to Amazon...', 'ams-wc-amazon')); ?>');
            } else if (progress < 60) {
                $statusText.html('<i class="bi bi-arrow-clockwise me-2"></i><?= esc_js(__('Fetching product reviews...', 'ams-wc-amazon')); ?>');
            } else if (progress < 90) {
                $statusText.html('<i class="bi bi-arrow-clockwise me-2"></i><?= esc_js(__('Processing and importing reviews...', 'ams-wc-amazon')); ?>');
            }
        }, 500);
        
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                clearInterval(progressInterval);
                $progressBar.css('width', '100%');
                $progressPercentage.text('100%');
                $statusText.html('<i class="bi bi-check-circle text-success me-2"></i><?= esc_js(__('Import completed successfully!', 'ams-wc-amazon')); ?>');
                
                console.log("Ajax response:", response);
                if (response.status) {
                    let successMessage = $('<div class="alert alert-success" role="alert"></div>')
                        .append('<h4><i class="bi bi-check-circle me-2"></i><?= esc_js(__('Review Import Complete!', 'ams-wc-amazon')); ?></h4>')
                        .append('<p>' + response.message + '</p>');
                    
                    $reviewsContainer.html(successMessage);

                    if (response.data && response.data.length > 0) {
                        let dataList = $('<div class="import-results mt-4"></div>');

                        // Enhanced results display
                                                 let resultsCard = $('<div class="card border-success"></div>');
                         let cardHeader = $('<div class="card-header bg-success text-white"></div>')
                             .append('<h5 class="mb-0"><i class="bi bi-bar-chart me-2"></i><?= esc_js(__('Import Summary', 'ams-wc-amazon')); ?></h5>');
                        
                        let cardBody = $('<div class="card-body"></div>');
                        
                        // Product info
                        let productInfo = $('<div class="row mb-3"></div>');
                        productInfo.append(`
                            <div class="col-md-6">
                                <strong><i class="bi bi-box me-2"></i><?= esc_js(__('Product Page:', 'ams-wc-amazon')); ?></strong>
                                <a href="${amsbackend.site_url}?p=${selectedProduct}" target="_blank" class="btn btn-sm btn-outline-primary ms-2">
                                    <i class="bi bi-box-arrow-up-right me-1"></i><?= esc_js(__('View Product', 'ams-wc-amazon')); ?>
                                </a>
                            </div>
                            <div class="col-md-6">
                                <strong><i class="bi bi-shop me-2"></i><?= esc_js(__('Amazon URL:', 'ams-wc-amazon')); ?></strong>
                                <a href="${response.data[0]}" target="_blank" class="btn btn-sm btn-outline-secondary ms-2">
                                    <i class="bi bi-box-arrow-up-right me-1"></i><?= esc_js(__('View on Amazon', 'ams-wc-amazon')); ?>
                                </a>
                            </div>
                        `);
                        
                        cardBody.append(productInfo);

                        // Review summary
                        if (response.data[2]) {
                            let summary = response.data[2];
                            let summaryRow = $('<div class="row"></div>');
                            
                            summaryRow.append(`
                                <div class="col-md-3">
                                    <div class="text-center p-3 bg-light rounded">
                                        <h4 class="text-primary mb-1">${summary.existingReviews}</h4>
                                        <small class="text-muted"><?= esc_js(__('Existing Reviews', 'ams-wc-amazon')); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center p-3 bg-light rounded">
                                        <h4 class="text-success mb-1">${summary.totalReview}</h4>
                                        <small class="text-muted"><?= esc_js(__('New Reviews', 'ams-wc-amazon')); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center p-3 bg-light rounded">
                                        <h4 class="text-info mb-1">${summary.existingReviews + summary.totalReview}</h4>
                                        <small class="text-muted"><?= esc_js(__('Total Reviews', 'ams-wc-amazon')); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center p-3 bg-light rounded">
                                        <h4 class="text-warning mb-1">${summary.totalReview > 0 ? (summary.totalRating / summary.totalReview).toFixed(1) : '0.0'}</h4>
                                        <small class="text-muted"><?= esc_js(__('Avg Rating', 'ams-wc-amazon')); ?></small>
                                    </div>
                                </div>
                            `);
                            
                            cardBody.append(summaryRow);

                            // Only show detailed reviews if we have new ones
                            if (summary.result && summary.result.length > 0 && summary.totalReview > 0) {
                                let detailsSection = $('<div class="mt-4"></div>');
                                let detailsButton = $('<button class="btn btn-outline-primary mb-3"><i class="bi bi-eye me-2"></i><?= esc_js(__('Show Detailed Reviews', 'ams-wc-amazon')); ?></button>');
                                let detailedResults = $('<div id="detailedResults" class="d-none"></div>');

                                summary.result.forEach(function(review) {
                                    let reviewCard = $('<div class="card mb-3 border-0 shadow-sm"></div>');
                                    let cardBody = $('<div class="card-body"></div>');

                                    if (review.title) {
                                        cardBody.append('<h6 class="card-title text-primary">' + review.title + '</h6>');
                                    }

                                    cardBody.append(`
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="text-muted"><i class="bi bi-person me-1"></i>${review.user}</span>
                                            <span class="badge bg-warning text-dark">
                                                <i class="bi bi-star me-1"></i>${review.rating} <?= esc_js(__('stars', 'ams-wc-amazon')); ?>
                                            </span>
                                        </div>
                                    `);

                                    cardBody.append('<p class="card-text">' + review.content + '</p>');
                                    
                                    reviewCard.append(cardBody);
                                    detailedResults.append(reviewCard);
                                });

                                detailsButton.click(function() {
                                    detailedResults.toggleClass('d-none');
                                    $(this).html(function(i, html) {
                                        return html.includes("Show") ? 
                                            '<i class="bi bi-eye-slash me-2"></i><?= esc_js(__('Hide Detailed Reviews', 'ams-wc-amazon')); ?>' : 
                                            '<i class="bi bi-eye me-2"></i><?= esc_js(__('Show Detailed Reviews', 'ams-wc-amazon')); ?>';
                                    });
                                });

                                detailsSection.append(detailsButton);
                                detailsSection.append(detailedResults);
                                cardBody.append(detailsSection);
                            }
                        }

                        resultsCard.append(cardHeader);
                        resultsCard.append(cardBody);
                        dataList.append(resultsCard);
                        $reviewsContainer.append(dataList);
                    }
                } else {
                    $reviewError.removeClass('d-none').html('<i class="bi bi-exclamation-triangle me-2"></i>' + response.message);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                clearInterval(progressInterval);
                console.error("Ajax error:", textStatus, errorThrown);
                $reviewError.removeClass('d-none')
                    .html('<i class="bi bi-exclamation-triangle me-2"></i><?= esc_js(__('An error occurred while importing reviews.', 'ams-wc-amazon')); ?>');
            },
            complete: function() {
                // Hide import status after a delay
                setTimeout(function() {
                    $importStatus.addClass('d-none');
                }, 2000);
                // Re-enable the submit button
                $submitButton.prop('disabled', false);
            }
        });
    });

    // ========================================
    // BULK OPERATIONS FUNCTIONALITY
    // ========================================
    function initializeBulkOperations() {
        // Bulk product selection handlers
        $('.bulk-product-checkbox').on('change', function() {
            updateSelectedCount();
            updateBulkButtons();
        });

        $('#selectAllProducts').on('click', function() {
            $('.bulk-product-checkbox').prop('checked', true);
            updateSelectedCount();
            updateBulkButtons();
        });

        $('#clearAllProducts').on('click', function() {
            $('.bulk-product-checkbox').prop('checked', false);
            updateSelectedCount();
            updateBulkButtons();
        });

        // Bulk import handler
        $('#bulkImportReviews').on('click', function() {
            const selectedProducts = $('.bulk-product-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

            if (selectedProducts.length === 0) {
                alert('Please select at least one product for bulk import.');
                return;
            }

            if (!confirm(`Start bulk import for ${selectedProducts.length} products? This may take several minutes.`)) {
                return;
            }

            startBulkImport(selectedProducts);
        });

        // Bulk delete handler
        $('#bulkDeleteReviews').on('click', function() {
            const selectedProducts = $('.bulk-product-checkbox:checked').map(function() {
                return $(this).val();
            }).get();

            if (selectedProducts.length === 0) {
                alert('Please select at least one product.');
                return;
            }

            if (!confirm(`Delete all imported reviews from ${selectedProducts.length} selected products?`)) {
                return;
            }

            const userInput = prompt('Type "DELETE" to confirm:');
            if (userInput !== 'DELETE') {
                alert('Action cancelled. You must type "DELETE" exactly to confirm.');
                return;
            }

            startBulkDelete(selectedProducts);
        });
    }

    function updateSelectedCount() {
        const count = $('.bulk-product-checkbox:checked').length;
        $('#selectedCount').text(count);
    }

    function updateBulkButtons() {
        const hasSelection = $('.bulk-product-checkbox:checked').length > 0;
        $('#bulkImportReviews, #bulkDeleteReviews').prop('disabled', !hasSelection);
    }

    function startBulkImport(productIds) {
        const $progress = $('#bulkProgress');
        const $progressBar = $progress.find('.progress-bar');
        const $progressText = $('#bulkProgressText');
        const $progressPercent = $('#bulkProgressPercent');
        const $successCount = $('#bulkSuccessCount');
        const $errorCount = $('#bulkErrorCount');

        $progress.removeClass('d-none');
        $('#bulkImportReviews').prop('disabled', true);

        let completed = 0;
        let successful = 0;
        let failed = 0;
        const total = productIds.length;

        function processNext() {
            if (completed >= total) {
                $progressText.text('Bulk import completed!');
                $('#bulkImportReviews').prop('disabled', false);
                $progressBar.addClass('bg-success');
                
                // Hide progress after 3 seconds
                setTimeout(function() {
                    $progress.addClass('d-none');
                    $progressBar.removeClass('bg-success').css('width', '0%');
                    $progressText.text('Preparing...');
                    $progressPercent.text('0%');
                    $successCount.text('✓ 0 completed');
                    $errorCount.text('✗ 0 failed');
                }, 3000);
                

                return;
            }

            const productId = productIds[completed];
            const reviewLimit = $('select[name="bulk_review_limit"]').val();
            const minRating = $('select[name="bulk_min_rating"]').val();

            $progressText.text(`Processing product ${completed + 1} of ${total}...`);

            $.ajax({
                url: amsbackend.ajax_url,
                type: 'POST',
                data: {
                    action: 'ams_product_review_import',
                    ams_product: productId,
                    review_limit: reviewLimit,
                    min_rating: minRating,
                    _wpnonce: $('input[name="_wpnonce"]').val()
                },
                success: function(response) {
                    if (response.status) {
                        successful++;
                    } else {
                        failed++;
                    }
                },
                error: function() {
                    failed++;
                },
                complete: function() {
                    completed++;
                    const percent = Math.round((completed / total) * 100);
                    $progressBar.css('width', percent + '%');
                    $progressPercent.text(percent + '%');
                    $successCount.text(`✓ ${successful} completed`);
                    $errorCount.text(`✗ ${failed} failed`);
                    
                    setTimeout(processNext, 1000); // Delay between requests
                }
            });
        }

        processNext();
    }

    function startBulkDelete(productIds) {
        const $progress = $('#bulkProgress');
        const $progressBar = $progress.find('.progress-bar');
        const $progressText = $('#bulkProgressText');
        const $progressPercent = $('#bulkProgressPercent');
        const $successCount = $('#bulkSuccessCount');
        const $errorCount = $('#bulkErrorCount');

        $progress.removeClass('d-none');
        $('#bulkDeleteReviews').prop('disabled', true);

        let completed = 0;
        let successful = 0;
        let failed = 0;
        const total = productIds.length;

        $progressText.text('Starting bulk delete...');
        $progressBar.removeClass('progress-bar-striped progress-bar-animated');
        $progressBar.addClass('bg-danger');

        function processNext() {
            if (completed >= total) {
                $progressText.text('Bulk delete completed!');
                $('#bulkDeleteReviews').prop('disabled', false);
                $progressBar.removeClass('bg-danger').addClass('bg-success');
                
                // Hide progress after 3 seconds
                setTimeout(function() {
                    $progress.addClass('d-none');
                    $progressBar.removeClass('bg-success').css('width', '0%');
                    $progressText.text('Preparing...');
                    $progressPercent.text('0%');
                    $successCount.text('✓ 0 completed');
                    $errorCount.text('✗ 0 failed');
                }, 3000);
                

                return;
            }

            const productId = productIds[completed];
            $progressText.text(`Deleting reviews from product ${completed + 1} of ${total}...`);

            $.ajax({
                url: amsbackend.ajax_url,
                type: 'POST',
                data: {
                    action: 'ams_bulk_delete_product_reviews',
                    product_id: productId,
                    nonce: '<?= wp_create_nonce('ams_bulk_delete_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        successful++;
                    } else {
                        failed++;
                        console.error('Failed to delete reviews for product ' + productId + ':', response.data.message);
                    }
                },
                error: function() {
                    failed++;
                    console.error('Network error while deleting reviews for product ' + productId);
                },
                complete: function() {
                    completed++;
                    const percent = Math.round((completed / total) * 100);
                    $progressBar.css('width', percent + '%');
                    $progressPercent.text(percent + '%');
                    $successCount.text(`✓ ${successful} completed`);
                    $errorCount.text(`✗ ${failed} failed`);
                    
                    setTimeout(processNext, 500); // Shorter delay for delete operations
                }
            });
        }

        processNext();
    }







    // ========================================
    // TAB PERSISTENCE FUNCTIONALITY
    // ========================================
    function initializeTabPersistence() {
        const STORAGE_KEY = 'ams_review_import_active_tab';
        
        // Restore previously active tab on page load
        const savedTab = localStorage.getItem(STORAGE_KEY);
        if (savedTab) {
            console.log('AMS Tab Persistence: Restoring tab:', savedTab);
            
            // Check if the saved tab exists
            const $savedTabButton = $(`#${savedTab}`);
            const $savedTabPanel = $($savedTabButton.attr('data-bs-target'));
            
            if ($savedTabButton.length && $savedTabPanel.length) {
                console.log('AMS Tab Persistence: Successfully restored tab:', savedTab);
                // Deactivate current active tab
                $('.nav-link.active').removeClass('active');
                $('.tab-pane.show.active').removeClass('show active');
                
                // Activate saved tab with animation
                $savedTabButton.addClass('active tab-restored');
                $savedTabPanel.addClass('show active');
                
                // Remove animation class after animation completes
                setTimeout(function() {
                    $savedTabButton.removeClass('tab-restored');
                }, 500);
                
                // Trigger any tab-specific initialization
                // No special initialization needed for remaining tabs
            }
        }
        
        // Save tab state when user switches tabs
        $('#reviewTabs button[data-bs-toggle="tab"]').on('shown.bs.tab', function(e) {
            const activeTabId = $(e.target).attr('id');
            localStorage.setItem(STORAGE_KEY, activeTabId);
            console.log('AMS Tab Persistence: Saved active tab:', activeTabId);
        });
        
        // Clear tab state when user navigates away (optional - keeps state across sessions)
        // Uncomment the next line if you want to clear state when leaving the page
        // $(window).on('beforeunload', function() { localStorage.removeItem(STORAGE_KEY); });
        
        // Add visual indicator for active tab persistence
        if (savedTab) {
            const $activeTab = $(`#${savedTab}`);
            if ($activeTab.length) {
                // Add a subtle indicator that the tab was restored
                $activeTab.append(' <i class="bi bi-clock-history text-muted ms-1" title="Restored from last visit" style="font-size: 0.8em;"></i>');
                
                // Remove the indicator after 3 seconds
                setTimeout(function() {
                    $activeTab.find('.fa-history').fadeOut(500, function() {
                        $(this).remove();
                    });
                }, 3000);
            }
        }
        
        // Add keyboard shortcut to clear tab state (Ctrl+Shift+R)
        $(document).on('keydown', function(e) {
            if (e.ctrlKey && e.shiftKey && e.keyCode === 82) { // Ctrl+Shift+R
                localStorage.removeItem(STORAGE_KEY);
                console.log('AMS Tab Persistence: Tab state cleared');
                // Show a brief notification using toast system
                if (typeof showToast === 'function') {
                    showToast('Tab state cleared!', 'success');
                } else {
                    // Fallback notification with correct positioning
                    $('body').append('<div id="tabStateClearedNotice" style="position: fixed; top: 50px; right: 20px; background: #28a745; color: white; padding: 10px 15px; border-radius: 4px; z-index: 9999; font-size: 14px;">Tab state cleared!</div>');
                    setTimeout(function() {
                        $('#tabStateClearedNotice').fadeOut(500, function() { $(this).remove(); });
                    }, 2000);
                }
                e.preventDefault();
            }
        });
    }
});
</script>