<?php include "common-header.php"; ?>

<?php
// Display error message if nonce expired
if (isset($_GET['error']) && $_GET['error'] === 'nonce_expired') {
    echo '<div class="notice notice-error is-dismissible" style="margin-top: 20px;">
        <p><strong>Security Error:</strong> Your session has expired. Please refresh the page and try saving your settings again.</p>
    </div>';
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            
            <!-- Main Settings Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-gear text-primary me-2"></i>
                            <?php esc_html_e('Plugin Settings', 'ams-wc-amazon'); ?>
                        </h5>

                    </div>
                </div>
                <div class="card-body">

    <!-- Floating Quick Navigation Button -->
    <div class="position-fixed top-50 end-0 translate-middle-y">
        <button class="btn btn-primary shadow-sm py-2 px-2 rounded-start-3 rounded-end-0" 
                type="button" 
                data-bs-toggle="offcanvas" 
                data-bs-target="#settingsSidebar"
                title="<?php esc_attr_e('Quick Navigation', 'ams-wc-amazon'); ?>">
            <i class="bi bi-chevron-left text-white"></i>
        </button>
    </div>

    <!-- Sidebar -->
    <div class="offcanvas offcanvas-end w-auto mt-4" tabindex="-1" id="settingsSidebar">
        <div class="card shadow-sm h-100 overflow-y-auto">
            <div class="card-header bg-gradient bg-primary text-white border-0">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <div class="bg-light bg-opacity-25 rounded-circle p-2 me-3">
                            <i class="bi bi-compass text-white"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 fw-bold"><?php esc_html_e('Quick Navigation', 'ams-wc-amazon'); ?></h6>
                            <small class="opacity-75"><?php esc_html_e('Jump to any setting', 'ams-wc-amazon'); ?></small>
                        </div>
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
                </div>
            </div>
            <div class="card-body p-0">
                <!-- Settings toggles -->
                <div class="p-3 border-bottom bg-light bg-opacity-50">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-gear-fill text-primary me-2"></i>
                                <span class="small fw-medium text-dark">
                                    <?php esc_html_e('Auto-close after navigation', 'ams-wc-amazon'); ?>
                                </span>
                            </div>
                        </div>
                        <div class="ms-3">
                            <label class="ams-common-toggle-switch">
                                <input type="checkbox" name="sidebar_autoclose" id="autoCloseSwitch" value="1" <?php checked(get_option('ams_sidebar_autoclose', '1'), '1'); ?>>
                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Navigation links -->
                <div class="list-group list-group-flush">
                    <!-- General Import Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#general-settings">
                        <i class="bi bi-gear me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('General Import Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Basic import configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Theme Auto-Detection -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#theme-detection">
                        <i class="bi bi-search me-3 text-info fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Theme Auto-Detection', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Automatic theme hook and CSS detection', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Cron Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#daily-cron-settings">
                        <i class="bi bi-clock me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Cron Job Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Configure automated tasks', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- AMSWOO Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#amswoo-settings">
                        <i class="bi bi-tools me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('AMSWOO Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Advanced AMSWOO configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Shortcode Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#shortcode-settings">
                        <i class="bi bi-code me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('ShortCode Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('ShortCode configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Theme Hook Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#custom-theme-hook-settings">
                        <i class="bi bi-plug me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Theme Hook Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Theme Hook configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Buy Now Button Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#buy-now-settings">
                        <i class="bi bi-cart me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Buy Now Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Configure button behavior', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Image Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#image-settings">
                        <i class="bi bi-image me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Image Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Product image configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>

                    <!-- Proxy Settings -->
                    <a class="list-group-item list-group-item-action d-flex align-items-center py-3 border-0" href="#proxy-settings">
                        <i class="bi bi-shield me-3 text-primary fs-5"></i>
                        <div>
                            <strong class="d-block mb-1 text-dark fw-semibold"><?php esc_html_e('Proxy Settings', 'ams-wc-amazon'); ?></strong>
                            <small class="text-muted fw-normal"><?php esc_html_e('Proxy service configuration', 'ams-wc-amazon'); ?></small>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const autoCloseSwitch = document.getElementById('autoCloseSwitch');
    
    // Load saved preference from localStorage
    const savedAutoClose = localStorage.getItem('sidebarAutoClose');
    autoCloseSwitch.checked = savedAutoClose === null ? true : savedAutoClose === 'true';
    
    // Save preference when changed
    autoCloseSwitch.addEventListener('change', function() {
        localStorage.setItem('sidebarAutoClose', this.checked);
    });
    
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            
            // Skip if targetId is just "#" or empty
            if (!targetId || targetId === '#' || targetId.length <= 1) {
                return;
            }
            
            const targetElement = document.querySelector(targetId);
            
            // Remove active class from all items
            document.querySelectorAll('.list-group-item').forEach(item => {
                item.classList.remove('active', 'bg-primary', 'text-white');
            });
            
            // Add active state using Bootstrap classes
            this.classList.add('active', 'bg-primary', 'text-white');
            
            if (targetElement) {
                targetElement.scrollIntoView({
                    behavior: 'smooth'
                });
                
                if (autoCloseSwitch.checked) {
                    const sidebar = bootstrap.Offcanvas.getInstance(document.getElementById('settingsSidebar'));
                    if (sidebar) {
                        sidebar.hide();
                    }
                }
            }
        });
    });
    
    // Emergency cleanup button
    document.getElementById('emergency-cleanup-btn')?.addEventListener('click', function() {
        if (!confirm('This will attempt to fix corrupted WooCommerce product gallery data. Continue?')) {
            return;
        }
        
        const button = this;
        const originalText = button.innerHTML;
        button.innerHTML = '<i class="spinner-border spinner-border-sm me-1"></i>Fixing...';
        button.disabled = true;
        
        fetch(ajaxurl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'action=ams_manual_cleanup&nonce=' + '<?php echo wp_create_nonce('ams_cleanup_nonce'); ?>'
        })
        .then(response => response.json())
        .then(data => {
            button.innerHTML = originalText;
            button.disabled = false;
            
            if (data.success) {
                alert('Emergency cleanup completed! Fixed ' + data.fixed_count + ' corrupted entries. Please refresh the page.');
                window.location.reload();
            } else {
                alert('Cleanup failed: ' + (data.data || 'Unknown error'));
            }
        })
        .catch(error => {
            button.innerHTML = originalText;
            button.disabled = false;
            alert('Network error during cleanup: ' + error.message);
        });
    });
    
    
    
    // Reset to defaults functionality
    document.querySelectorAll('.js-reset-defaults').forEach(function(button){
      button.addEventListener('click', function() {
        if (confirm('<?php esc_html_e('Reset all theme compatibility settings to optimal defaults for remote images?', 'ams-wc-amazon'); ?>')) {
            const originalText = button.innerHTML;
            
            button.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Resetting...';
            button.disabled = true;
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'ams_reset_theme_defaults',
                    nonce: '<?php echo wp_create_nonce('ams_reset_defaults_nonce'); ?>'
                })
            })
            .then(response => response.json())
            .then(data => {
                button.innerHTML = originalText;
                button.disabled = false;
                
                if (data.success) {
                    // Update all dropdowns to show 'url' as selected
                    document.getElementById('theme_image_format').value = 'url';
                    document.getElementById('theme_thumb_format').value = 'url';
                    document.getElementById('theme_full_format').value = 'url';
                    
                    if (typeof showToast === 'function') {
                        showToast('<?php esc_html_e('Settings reset to optimal defaults for remote images!', 'ams-wc-amazon'); ?>', 'success');
                    } else {
                        alert('<?php esc_html_e('Settings reset successfully!', 'ams-wc-amazon'); ?>');
                    }
                } else {
                    if (typeof showToast === 'function') {
                        showToast(data.data || '<?php esc_html_e('Failed to reset settings.', 'ams-wc-amazon'); ?>', 'error');
                    } else {
                        alert('<?php esc_html_e('Failed to reset settings.', 'ams-wc-amazon'); ?>');
                    }
                }
            })
            .catch(error => {
                button.innerHTML = originalText;
                button.disabled = false;
                console.error('Reset error:', error);
                if (typeof showToast === 'function') {
                    showToast('<?php esc_html_e('Network error. Please try again.', 'ams-wc-amazon'); ?>', 'error');
                } else {
                    alert('<?php esc_html_e('Network error. Please try again.', 'ams-wc-amazon'); ?>');
                }
            });
        }
      });
    });
    
    // Section memory functionality
    const SECTION_MEMORY_KEY = 'ams_settings_last_section';
    const SCROLL_POSITION_KEY = 'ams_settings_scroll_position';
    
    // Function to save current section and scroll position
    function saveCurrentSection() {
        // Get meaningful sections (skip very small elements)
        const allElements = document.querySelectorAll('[id]');
        const sections = Array.from(allElements).filter(el => {
            // Only consider elements that are substantial sections
            return el.offsetHeight >= 150 && 
                   el.offsetWidth >= 200 && 
                   !el.id.includes('modal') && 
                   !el.id.includes('popup') &&
                   !el.id.includes('tooltip');
        });
        
        let currentSection = '';
        let currentScrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        // Only save if user has actually scrolled or interacted (not on initial page load)
        if (currentScrollTop > 100) {
            // Find which section is currently most visible in the viewport
            let bestSection = '';
            let bestScore = 0;
            
            sections.forEach(section => {
                const rect = section.getBoundingClientRect();
                const viewportHeight = window.innerHeight;
                
                // Calculate visibility score based on multiple factors
                const visibleTop = Math.max(0, Math.min(rect.bottom, viewportHeight) - Math.max(rect.top, 0));
                const visibleHeight = Math.min(rect.height, viewportHeight);
                const visibility = visibleTop / visibleHeight;
                
                // Calculate position score (prefer sections in upper viewport)
                const positionScore = rect.top <= viewportHeight * 0.2 ? 1.5 : 
                                    rect.top <= viewportHeight * 0.5 ? 1.0 : 0.5;
                
                // Calculate final score
                const finalScore = visibility * positionScore;
                
                // Section must be significantly visible and in good position
                if (finalScore > bestScore && visibility > 0.4 && rect.top <= viewportHeight * 0.6) {
                    bestScore = finalScore;
                    bestSection = section.id;
                }
            });
            
            if (bestSection && bestScore > 0.4) {
                currentSection = bestSection;
            }
        }
        
        if (currentSection) {
            localStorage.setItem(SECTION_MEMORY_KEY, currentSection);
            localStorage.setItem(SCROLL_POSITION_KEY, currentScrollTop.toString());
        }
    }
    
    // Function to restore last section and scroll position
    function restoreLastSection() {
        const lastSection = localStorage.getItem(SECTION_MEMORY_KEY);
        const lastScrollPosition = localStorage.getItem(SCROLL_POSITION_KEY);
        
        if (lastSection && lastScrollPosition) {
            const targetElement = document.getElementById(lastSection);
            if (targetElement) {
                // Small delay to ensure page is fully loaded
                setTimeout(() => {
                    targetElement.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    
                    // Restore exact scroll position for better precision
                    setTimeout(() => {
                        window.scrollTo({
                            top: parseInt(lastScrollPosition),
                            behavior: 'smooth'
                        });
                        
                        // Mark that restoration is complete to prevent interference
                        window.amsSectionRestorationComplete = true;
                        //console.log('Section restoration completed for:', lastSection);
                    }, 500);
                    
                    // Highlight the section in navigation
                    highlightNavigationItem(lastSection);
                }, 300);
            }
        }
    }
    
    // Function to highlight navigation item for current section
    function highlightNavigationItem(sectionId) {
        // Remove all active states
        document.querySelectorAll('.list-group-item').forEach(item => {
            item.classList.remove('active', 'bg-primary', 'text-white');
        });
        
        // Find and highlight the corresponding navigation item
        const navItems = document.querySelectorAll('.list-group-item');
        navItems.forEach(item => {
            const href = item.getAttribute('href');
            if (href === '#' + sectionId) {
                item.classList.add('active', 'bg-primary', 'text-white');
            }
        });
    }
    
    // Save section when user scrolls or interacts with form elements
    let scrollTimeout;
    window.addEventListener('scroll', function() {
        // Don't save if restoration is still in progress
        if (window.amsSectionRestorationComplete !== true) {
            return;
        }
        
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(saveCurrentSection, 100);
    });
    
    // Save section when user interacts with form elements
    document.addEventListener('change', function(e) {
        if (e.target.matches('input, select, textarea')) {
            saveCurrentSection();
        }
    });
    
    // Save section when user clicks on form elements
    document.addEventListener('click', function(e) {
        if (e.target.matches('button, .btn, label, .form-check-input')) {
            saveCurrentSection();
        }
    });
    
    // Auto-restore last section when page loads (only if user has actually been on the page before)
    const hasVisitedBefore = localStorage.getItem('ams_settings_has_visited');
    if (hasVisitedBefore) {
        restoreLastSection();
        
        // Add visual indicator for remembered section
        const lastSection = localStorage.getItem(SECTION_MEMORY_KEY);
        if (lastSection) {
            const targetElement = document.getElementById(lastSection);
            if (targetElement) {
                // Add a subtle highlight to the remembered section
                targetElement.style.transition = 'box-shadow 0.3s ease';
                targetElement.style.boxShadow = '0 0 0 2px rgba(13, 110, 253, 0.25)';
                
                // Remove highlight after 3 seconds
                setTimeout(() => {
                    targetElement.style.boxShadow = '';
                }, 3000);
            }
        }
    } else {
        // Mark that user has visited this page
        localStorage.setItem('ams_settings_has_visited', 'true');
    }
    
    // Add protection against automatic scrolling after restoration
    let protectionTimeout;
    function enableScrollProtection() {
        // Disable any automatic scrolling for 3 seconds after restoration
        const originalScrollTo = window.scrollTo;
        const originalScrollIntoView = Element.prototype.scrollIntoView;
        
        window.scrollTo = function() {
            if (window.amsSectionRestorationComplete === true) {
                //console.log('Blocked automatic scrollTo call');
                return;
            }
            return originalScrollTo.apply(this, arguments);
        };
        
        Element.prototype.scrollIntoView = function() {
            if (window.amsSectionRestorationComplete === true) {
                //console.log('Blocked automatic scrollIntoView call on:', this.id || this.className);
                return;
            }
            return originalScrollIntoView.apply(this, arguments);
        };
        
        // Re-enable after 3 seconds
        clearTimeout(protectionTimeout);
        protectionTimeout = setTimeout(() => {
            window.scrollTo = originalScrollTo;
            Element.prototype.scrollIntoView = originalScrollIntoView;
            //console.log('Scroll protection disabled');
        }, 3000);
    }
    
    // Enable protection after restoration
    if (hasVisitedBefore) {
        setTimeout(enableScrollProtection, 1000);
    }
});
</script>


<div class="container-fluid">
    <div class="setting_wrapper text-left">
          <div class="tab-content" id="pills-tabContent">

<div class="tab-pane fade <?= ( !isset($_GET['tab']) || $_GET['tab'] == "pills-general-tab")?'show active':''; ?> " id="pills-general" role="tabpanel" aria-labelledby="pills-general-tab">
    <form method="post" action="<?php echo admin_url( 'admin-post.php' ); ?>" enctype="multipart/form-data">
        <div class="setting_inner">

            <!--General Import Settings section-->
            <?php
            $enable_no_follow_link = get_option('ams_enable_no_follow_link', 'follow');
            $is_no_follow_enabled = ($enable_no_follow_link === 'nofollow');

            $remove_unavailable_products = $this->get_option('ams_remove_unavailable_products', 'No');
            $is_remove_enabled = ($remove_unavailable_products === 'Yes');

            $fast_product_importer = $this->get_option('ams_fast_product_importer', 'No');
            $is_fast_import_enabled = ($fast_product_importer === 'Yes');
            ?>

            <div class="card shadow-sm mb-4 ams-common-card-fix" id="general-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0 fw-bold">
                        <i class="bi bi-gear me-2"></i>
                        <?php esc_html_e('General Import Settings', 'ams-wc-amazon'); ?>
                    </h4>
                </div>
                <div class="card-body">

                    <div class="mb-4">
                        <?php
                        $options = [
                            'no_follow' => [
                                'title' => __('No Follow Link', 'ams-wc-amazon'),
                                'description' => __('Add "nofollow" attribute to external links', 'ams-wc-amazon'),
                                'icon' => 'bi bi-link',
                                'name' => 'enable_no_follow_link',
                                'value' => 'nofollow',
                                'checked' => $is_no_follow_enabled
                            ],
                            'remove_unavailable' => [
                                'title' => __('Remove Unavailable/Zero Price Products', 'ams-wc-amazon'),
                                'description' => __('Remove products that are unavailable or have zero price from your store', 'ams-wc-amazon'),
                                'icon' => 'bi bi-trash',
                                'name' => 'remove_unavailable_products',
                                'value' => 'Yes',
                                'checked' => $is_remove_enabled
                            ],
                            'fast_import' => [
                                'title' => __('Enable Fast Import', 'ams-wc-amazon'),
                                'description' => __('Speed up product import process', 'ams-wc-amazon'),
                                'icon' => 'bi bi-lightning',
                                'name' => 'fast_product_importer',
                                'value' => 'Yes',
                                'checked' => $is_fast_import_enabled
                            ]
                        ];

                        foreach ($options as $key => $option) :
                            $isChecked = $option['checked'] ? 'checked' : '';
                        ?>
                            <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                                <div class="flex-grow-1">
                                    <h6 class="mb-1 fw-semibold text-dark">
                                        <i class="<?php echo esc_attr($option['icon']); ?> me-2 text-primary"></i>
                                        <?php echo esc_html($option['title']); ?>
                                    </h6>
                                    <p class="mb-0 text-muted small fw-normal"><?php echo esc_html($option['description']); ?></p>
                                </div>
                                <div class="ms-3">
                                    <label class="ams-common-toggle-switch">
                                        <input type="checkbox" name="<?php echo esc_attr($option['name']); ?>" value="<?php echo esc_attr($option['value']); ?>" <?php echo $isChecked; ?>>
                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>


                    <!-- Product Import Default Category -->
                    <div class="mb-4">
                       <label for="settings_ams_default_category" class="form-label text-dark fw-semibold d-flex align-items-center">
                           <i class="bi bi-list-ul me-2 text-primary"></i>
                           <?php esc_html_e('Default Category', 'ams-wc-amazon'); ?>
                       </label>
                       <div class="d-flex align-items-center mb-2">
                           <div class="dropdown">
                               <button class="btn btn-outline-primary btn-sm dropdown-toggle w-auto text-start" type="button" id="dropdownCategoryButton" data-bs-toggle="dropdown" aria-expanded="false">
                                   <span id="selectedCategoryLabel">
                                       <?php
                                       $saved_category = $this->get_option('ams_default_category', '_auto_import_amazon');
                                       echo $saved_category === '_auto_import_amazon'
                                           ? esc_html__('Auto Import From Amazon', 'ams-wc-amazon')
                                           : esc_html($saved_category);
                                       ?>
                                   </span>
                               </button>
                               <ul class="dropdown-menu w-auto" aria-labelledby="dropdownCategoryButton" style="max-height: 300px; overflow-y: auto;">
                                   <!-- Search Bar -->
                                   <li class="px-3 py-2">
                                       <input type="text" id="categorySearch" class="form-control form-control-sm" placeholder="<?php esc_attr_e('Search categories...', 'ams-wc-amazon'); ?>">
                                   </li>
                                   <li>
                                       <hr class="dropdown-divider">
                                   </li>
                                   <!-- Categories -->
                                   <li>
                                       <label class="dropdown-item">
                                           <input type="radio" name="ams_default_category" value="_auto_import_amazon" <?php checked($saved_category, "_auto_import_amazon"); ?> class="category-item">
                                           <?php esc_html_e('Auto Import From Amazon', 'ams-wc-amazon'); ?>
                                       </label>
                                   </li>
                                   <?php foreach ($this->get_wc_terms() as $value) : ?>
                                       <li>
                                           <label class="dropdown-item">
                                               <input type="radio" name="ams_default_category" value="<?php echo esc_attr($value['name']); ?>" <?php checked($saved_category, $value['name']); ?> class="category-item">
                                               <?php echo esc_html($value['name']); ?>
                                           </label>
                                       </li>
                                   <?php endforeach; ?>
                               </ul>
                           </div>
                           <div class="ms-3 d-flex align-items-center">
                               <?php $category_updates_enabled = get_option('product_category_cron', true); ?>
                               <div class="d-flex flex-column">
                                   <label class="form-label small mb-0 text-dark fw-medium">
                                       <?php esc_html_e('Category Updates', 'ams-wc-amazon'); ?>
                                   </label>
                                   <div class="d-flex align-items-center">
                                       <label class="ams-common-toggle-switch">
                                           <input type="checkbox" 
                                               name="product_category_cron" 
                                               value="1" 
                                               <?php checked($category_updates_enabled, 1); ?>>
                                           <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                       </label>
                                       <span class="ms-1 small fw-medium <?php echo $category_updates_enabled ? 'text-success' : 'text-danger'; ?>">
                                           <?php echo $category_updates_enabled 
                                               ? esc_html__('Enabled', 'ams-wc-amazon') 
                                               : esc_html__('Disabled', 'ams-wc-amazon'); ?>
                                       </span>
                                   </div>
                               </div>
                           </div>
                       </div>
                       <p class="text-muted small">
                           <?php esc_html_e('Select default category for imports. When updates are enabled, categories will be updated during scheduled updates.', 'ams-wc-amazon'); ?>
                       </p>
                    </div>

                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            const categoryItems = document.querySelectorAll('.category-item');
                            const selectedCategoryLabel = document.getElementById('selectedCategoryLabel');
                            const categorySearch = document.getElementById('categorySearch');
                            const categoryListItems = document.querySelectorAll('.dropdown-item');

                            // Update the selected category dynamically
                            categoryItems.forEach(item => {
                                item.addEventListener('change', function () {
                                    const selectedText = this.parentNode.textContent.trim();
                                    selectedCategoryLabel.textContent = selectedText;
                                });
                            });

                            // Filter categories dynamically
                            categorySearch.addEventListener('input', function () {
                                const query = this.value.toLowerCase();
                                categoryListItems.forEach(item => {
                                    const text = item.textContent.toLowerCase();
                                    item.style.display = text.includes(query) ? 'block' : 'none';
                                });
                            });
                        });
                    </script>
                    <!-- Product Import Default Category -->



                    <!-- Product Import Default Status -->
                    <div class="mb-4">
                        <label class="form-label d-flex align-items-center text-dark fw-semibold">
                            <i class="bi bi-list-task me-2 text-primary"></i>
                            <?php esc_html_e('Set Default Product Status', 'ams-wc-amazon'); ?>
                        </label>
                        <p class="text-muted small mb-3 fw-normal">
                            <?php esc_html_e('Choose the default status for imported products.', 'ams-wc-amazon'); ?>
                        </p>
                        <div class="btn-group" role="group">
                            <!-- Publish -->
                            <input type="radio" class="btn-check" name="ams_product_import_status" id="product_status_publish" value="publish" <?php checked($this->get_option('ams_product_import_status'), "publish"); ?>>
                            <label class="btn btn-outline-primary btn-sm" for="product_status_publish">
                                <i class="bi bi-check-circle me-2"></i><?php esc_html_e('Publish', 'ams-wc-amazon'); ?>
                            </label>

                            <!-- Pending -->
                            <input type="radio" class="btn-check" name="ams_product_import_status" id="product_status_pending" value="pending" <?php checked($this->get_option('ams_product_import_status'), "pending"); ?>>
                            <label class="btn btn-outline-primary btn-sm" for="product_status_pending">
                                <i class="bi bi-clock me-2"></i><?php esc_html_e('Pending', 'ams-wc-amazon'); ?>
                            </label>

                            <!-- Draft -->
                            <input type="radio" class="btn-check" name="ams_product_import_status" id="product_status_draft" value="draft" <?php checked($this->get_option('ams_product_import_status'), "draft"); ?>>
                            <label class="btn btn-outline-primary btn-sm" for="product_status_draft">
                                <i class="bi bi-pencil me-2"></i><?php esc_html_e('Draft', 'ams-wc-amazon'); ?>
                            </label>
                        </div>
                    </div>


                    <!-- Variation Import Limit -->
                        <?php
                        // Get the current max_execution_time from the server
                        $max_execution_time = ini_get('max_execution_time');
                        $variation_limit = $this->get_option('ams_variation_limit', 5);
                        ?>

                        <div class="mb-4">
                            <label for="variation_limit" class="form-label text-dark fw-semibold">
                                <i class="bi bi-layers me-2 text-primary"></i>
                                <?php esc_html_e('Variation Import Limit', 'ams-wc-amazon'); ?>
                            </label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="number" class="form-control" id="variation_limit" name="variation_limit" min="1" max="100" value="<?php echo esc_attr($variation_limit); ?>">
                                </div>
                            </div>
                            <div class="form-text text-muted">
                                <?php esc_html_e('Set the maximum number of variations to import. Default is 5.', 'ams-wc-amazon'); ?>
                            </div>

                            <!-- Badge Message (Initially Hidden or Visible Based on Initial Value) -->
                            <div id="executionTimeWarning" class="alert alert-warning mt-2" style="display: <?php echo ($variation_limit > 10) ? 'block' : 'none'; ?>;">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <?php printf(esc_html__('The current max_execution_time is set to %d seconds. It is recommended to set it to 600 or higher for importing more than 10 variations.', 'ams-wc-amazon'), $max_execution_time); ?>
                            </div>
                        </div>

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                const variationLimitField = document.getElementById('variation_limit');
                                const warningElement = document.getElementById('executionTimeWarning');

                                // Function to check and display the warning based on the input value
                                function checkVariationLimit() {
                                    const value = parseInt(variationLimitField.value, 10);
                                    if (value > 10) {
                                        warningElement.style.display = 'block';
                                    } else {
                                        warningElement.style.display = 'none';
                                    }
                                }

                                // Trigger check on page load in case the value is already greater than 10
                                checkVariationLimit();

                                // Attach event listener for dynamic update when typing
                                variationLimitField.addEventListener('input', checkVariationLimit);
                            });
                        </script>
                </div>
            </div>

            <script>
            document.addEventListener('DOMContentLoaded', function() {
                const toggles = document.querySelectorAll('.ams-common-toggle-switch input[type="checkbox"]');
                toggles.forEach(toggle => {
                    toggle.addEventListener('change', function() {
                        const card = this.closest('.d-flex');
                        if (this.checked) {
                            card.classList.add('text-primary');
                        } else {
                            card.classList.remove('text-primary');
                        }
                    });
                });
            });
            </script>
            <!--General Import Settings section-->

            <!-- Daily Cron & Cleanup Settings -->
            <div class="card shadow-sm mb-5 ams-common-card-fix" id="daily-cron-settings">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0 fw-bold">
                        <i class="bi bi-gears me-2"></i>
                        <?php esc_html_e('Automation & Cleanup Settings', 'ams-wc-amazon'); ?>
                    </h5>
                </div>

                <div class="card-body">

                    <!-- WordPress Cron -->
                    <div class="mb-4 p-3 bg-light rounded">
                        <h6 class="fw-bold text-dark mb-3">
                            <i class="bi bi-clock me-2 text-primary"></i>
                            <?php esc_html_e('WordPress Cron (Default)', 'ams-wc-amazon'); ?>
                        </h6>
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-grow-1">
                                <p class="text-muted small mb-0 fw-normal">
                                    <?php esc_html_e('Enable or disable WP Cron-based daily jobs. Works with WP Crontrol.', 'ams-wc-amazon'); ?>
                                </p>
                            </div>
                            <div>
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" name="enable_daily_cron" value="1" <?php checked(get_option('enable_daily_cron'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="alert <?php echo wp_next_scheduled('ams_daily_cron_event') ? 'alert-success' : 'alert-danger'; ?> mb-3">
                            <i class="fas <?php echo wp_next_scheduled('ams_daily_cron_event') ? 'fa-check-circle' : 'fa-exclamation-triangle'; ?> me-2"></i>
                            <strong>
                                <?php echo wp_next_scheduled('ams_daily_cron_event')
                                    ? esc_html__('Cron job is scheduled via WordPress.', 'ams-wc-amazon')
                                    : esc_html__('Cron job is NOT scheduled via WordPress.', 'ams-wc-amazon'); ?>
                            </strong>
                        </div>
                        <a href="https://wordpress.org/plugins/wp-crontrol/" target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-download me-2"></i>
                            <?php esc_html_e('Download WP Crontrol Plugin', 'ams-wc-amazon'); ?>
                        </a>
                    </div>

                    <hr class="my-4">

                    <!-- Server-Side Cron -->
                    <div class="mb-4 p-3 bg-light rounded">
                        <h6 class="fw-bold text-dark mb-3">
                            <i class="bi bi-server me-2 text-primary"></i>
                            <?php esc_html_e('Server-Side Cron (Advanced)', 'ams-wc-amazon'); ?>
                        </h6>
                        <p class="text-muted small mb-3 fw-normal">
                            <?php esc_html_e('Use a server-level cron for better reliability. Click below for setup instructions.', 'ams-wc-amazon'); ?>
                        </p>
                        <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#cronGuideModal">
                            <i class="bi bi-book me-2"></i>
                            <?php esc_html_e('Server-Side Cron Guide', 'ams-wc-amazon'); ?>
                        </button>
                    </div>

                    <hr class="my-4">

                    <!-- Cleanup Options -->
                    <div class="p-3 bg-light rounded">
                        <h6 class="fw-bold text-dark mb-3">
                            <i class="bi bi-brush me-2 text-primary"></i>
                            <?php esc_html_e('Automatic Cleanup Options', 'ams-wc-amazon'); ?>
                        </h6>

                        <!-- Clean Completed Actions -->
                        <div class="d-flex align-items-center mb-3 p-2 bg-white rounded">
                            <div class="flex-grow-1">
                                <p class="text-muted small mb-0 fw-normal">
                                    <?php esc_html_e('Delete completed WooCommerce Action Scheduler tasks automatically.', 'ams-wc-amazon'); ?>
                                </p>
                            </div>
                            <div>
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" name="enable_clean_completed_actions" value="1" <?php checked(get_option('enable_clean_completed_actions'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>

                        <!-- Clean Logs -->
                        <div class="d-flex align-items-center p-2 bg-white rounded">
                            <div class="flex-grow-1">
                                <p class="text-muted small mb-0 fw-normal">
                                    <?php esc_html_e('Truncate Action Scheduler logs to reduce database size.', 'ams-wc-amazon'); ?>
                                </p>
                            </div>
                            <div>
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" name="enable_clean_action_logs" value="1" <?php checked(get_option('enable_clean_action_logs'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--AMSWOO Settings-->
            <div class="card shadow-lg rounded-lg mb-4" id="amswoo-settings">
                <!-- Header -->
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0 fw-bold">
                        <i class="bi bi-tools me-2"></i>
                        <?php esc_html_e('AMSWOO Settings', 'ams-wc-amazon'); ?>
                    </h4>
                </div>

                <div class="card-body">
                    <!-- Data Cleanup Section -->
                    <div class="settings-section mb-4 pb-4 border-bottom">
                        <div class="section-header d-flex align-items-center mb-3">
                            <i class="bi bi-trash text-danger me-2 fs-4"></i>
                            <h4 class="m-0"><?php esc_html_e('Data Cleanup', 'ams-wc-amazon'); ?></h4>
                        </div>

                        <div class="bg-light p-4 rounded-3">
                            <div class="mb-3">
                                <button id="delete-amswoofiu-data" class="btn btn-danger d-flex align-items-center">
                                    <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                    <i class="bi bi-trash me-2"></i>
                                    <span class="button-text"><?php esc_html_e('Delete AMSWOO Data', 'ams-wc-amazon'); ?></span>
                                </button>
                            </div>

                            <div class="alert alert-warning mb-0">
                                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <strong><?php esc_html_e('Warning:', 'ams-wc-amazon'); ?></strong>
                                <p class="mb-2"><?php esc_html_e('This will delete:', 'ams-wc-amazon'); ?></p>
                                <ol class="ps-3 mb-0">
                                    <li><?php esc_html_e('All product image URLs (_thumbnail_id_url, _amswoofiu_wcgallary, _amswoofiu_url, _thumbnail_ext_url)', 'ams-wc-amazon'); ?></li>
                                    <li><?php esc_html_e('All uploaded product images and their variations from Media Library', 'ams-wc-amazon'); ?></li>
                                    <li><?php esc_html_e('All related image metadata', 'ams-wc-amazon'); ?></li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- Unlinked Variants Cleanup Section -->
                    <div class="settings-section mb-4 pb-4 border-bottom">
                        <div class="section-header d-flex align-items-center mb-3">
                            <i class="bi bi-eye-slash text-warning me-2 fs-4"></i>
                            <h4 class="m-0"><?php esc_html_e('Unlinked Variants/Products', 'ams-wc-amazon'); ?></h4>
                        </div>

                        <div class="bg-light p-4 rounded-3">
                            <?php
                            // Fetch unlinked variants
                            $unlinked_variants = get_unlinked_variants();

                            if (!empty($unlinked_variants)) {
                                echo '<table class="table table-bordered mb-3">';
                                echo '<thead><tr>';
                                echo '<th>' . esc_html__('SKU', 'ams-wc-amazon') . '</th>';
                                echo '<th>' . esc_html__('Post ID', 'ams-wc-amazon') . '</th>';
                                echo '</tr></thead>';
                                echo '<tbody>';
                                foreach ($unlinked_variants as $variant) {
                                    echo '<tr>';
                                    echo '<td>' . esc_html($variant->sku) . '</td>';
                                    echo '<td>' . esc_html($variant->post_id) . '</td>';
                                    echo '</tr>';
                                }
                                echo '</tbody>';
                                echo '</table>';
                            } else {
                                echo '<p class="text-muted">' . esc_html__('No unlinked variants/products found.', 'ams-wc-amazon') . '</p>';
                            }
                            ?>

                            <div class="mb-3">
                                <button id="delete-unlinked-variants" class="btn btn-danger d-flex align-items-center">
                                    <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                    <i class="bi bi-trash me-2"></i>
                                    <span class="button-text"><?php esc_html_e('Clean Up Unlinked Variants', 'ams-wc-amazon'); ?></span>
                                </button>
                            </div>

                            <div class="alert alert-warning mb-0">
                                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <strong><?php esc_html_e('Warning:', 'ams-wc-amazon'); ?></strong>
                                <p class="mb-2"><?php esc_html_e('This action will permanently delete all SKUs that are not linked to any valid WooCommerce products or variations.', 'ams-wc-amazon'); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Variation Image Settings -->
                    <div class="settings-section mb-4 pb-4 border-bottom">
                        <div class="section-header d-flex align-items-center mb-3">
                            <i class="bi bi-image text-primary me-2 fs-4"></i>
                            <h4 class="m-0"><?php esc_html_e('Variation meta-key for custom Themes', 'ams-wc-amazon'); ?></h4>
                        </div>

                        <div class="bg-light p-4 rounded-3">
                            <!-- Theme Meta Key Scanner -->
                            <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <!-- Manual Configuration Only -->
                                    <div class="alert alert-info mb-3">
                                        <div class="d-flex mb-3">
                                            <i class="bi bi-info-circle-fill me-2 mt-1"></i>
                                            <div>
                                                <strong><?php esc_html_e('Manual Configuration', 'ams-wc-amazon'); ?></strong>
                                                <p class="mb-2 mt-1"><?php esc_html_e('Configure the variation image settings manually by typing the values in the fields below.', 'ams-wc-amazon'); ?></p>
                                            </div>
                                        </div>
                                        <div class="d-flex flex-wrap gap-2">
                                            <button type="button" class="btn btn-outline-danger btn-sm" id="emergency-cleanup-btn">
                                                <i class="bi bi-exclamation-triangle me-1"></i>
                                                <?php esc_html_e('Emergency Database Fix', 'ams-wc-amazon'); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="variation_image_meta_key" class="form-label fw-bold">
                                    <?php esc_html_e('Custom Theme Variation Image Meta Key', 'ams-wc-amazon'); ?>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-key"></i>
                                    </span>
                                    <input type="text" 
                                           id="variation_image_meta_key" 
                                           name="variation_image_meta_key"
                                           class="form-control"
                                           placeholder="<?php esc_attr_e('Leave empty for default WooCommerce behavior', 'ams-wc-amazon'); ?>"
                                           value="<?php echo esc_attr(get_option('variation_image_meta_key', '')); ?>" />
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="variation_ajax_action" class="form-label fw-bold">
                                    <?php esc_html_e('Theme AJAX Action Name', 'ams-wc-amazon'); ?>
                                    <span class="text-muted">(<?php esc_html_e('Optional', 'ams-wc-amazon'); ?>)</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-lightning"></i>
                                    </span>
                                    <input type="text" 
                                           id="variation_ajax_action" 
                                           name="variation_ajax_action"
                                           class="form-control"
                                           placeholder="<?php esc_attr_e('e.g., ideapark_variation_images', 'ams-wc-amazon'); ?>"
                                           value="<?php echo esc_attr(get_option('variation_ajax_action', '')); ?>" />
                                </div>
                                <small class="text-muted">
                                    <?php esc_html_e('The AJAX action name your theme uses for variation gallery switching. Leave empty for auto-detection.', 'ams-wc-amazon'); ?>
                                </small>
                            </div>


                            <div class="alert alert-info mb-3">
                                <div class="d-flex mb-2">
                                    <i class="bi bi-info-circle-fill me-2 mt-1"></i>
                                    <strong><?php esc_html_e('Important Information:', 'ams-wc-amazon'); ?></strong>
                                </div>
                                <ul class="mb-0 ps-3">
                                    <li><?php esc_html_e('Only required for custom themes using different meta keys', 'ams-wc-amazon'); ?></li>
                                    <li><?php esc_html_e('Leave empty if using default WooCommerce setup', 'ams-wc-amazon'); ?></li>
                                    <li><?php esc_html_e('Consult your theme developer for the correct meta key', 'ams-wc-amazon'); ?></li>
                                </ul>
                            </div>

                            <div class="text-muted">
                                <i class="bi bi-lightbulb me-2"></i>
                                <small><?php esc_html_e('Example: Some custom themes use "theme_variation_images" as their meta key.', 'ams-wc-amazon'); ?></small>
                            </div>
                        </div>
                    </div>

                    <!-- Theme Scanner JavaScript -->
                    <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        // No JavaScript functionality needed for manual configuration
                    });
                    </script>
                    
                    <style>
                    .spin {
                        animation: spin 1s linear infinite;
                    }
                    @keyframes spin {
                        from { transform: rotate(0deg); }
                        to { transform: rotate(360deg); }
                    }
                    </style>

                    <!-- Page Speed Test Settings -->
                    <div class="settings-section mb-4 pb-4 border-bottom">
                        <div class="section-header d-flex align-items-center justify-content-between mb-3">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-speedometer2 text-primary me-2 fs-4"></i>
                                <h4 class="m-0"><?php esc_html_e('Page Speed Test Settings', 'ams-wc-amazon'); ?></h4>
                            </div>
                            <div class="ms-3">
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" id="enable_page_speed_test" 
                                           name="enable_page_speed_test" value="1" 
                                           <?php checked(get_option('enable_page_speed_test'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="bg-light p-4 rounded-3">
                            <p class="text-muted mb-3">
                                <?php esc_html_e('Display page speed test results and performance metrics on your product pages to build trust and showcase your site\'s performance.', 'ams-wc-amazon'); ?>
                            </p>

                            <!-- Test Configuration -->
                            <div class="mb-4">
                                <h6 class="fw-bold mb-3">
                                    <i class="bi bi-gear text-primary me-2"></i>
                                    <?php esc_html_e('Test Configuration', 'ams-wc-amazon'); ?>
                                </h6>
                                
                                <!-- Speed Test Provider Badges -->
                                <div class="row g-3 mb-4">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold mb-2">
                                            <i class="bi bi-speedometer2 text-primary me-2"></i>
                                            <?php esc_html_e('Speed Test Provider', 'ams-wc-amazon'); ?>
                                </label>
                                        <div class="row g-1 mb-2">
                                            <div class="col-3">
                                                <div class="provider-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-provider="google_pagespeed" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-google text-primary mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Google', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 provider-check d-none"></i>
                                    </div>
                                    </div>
                                            <div class="col-3">
                                                <div class="provider-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-provider="gtmetrix" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-graph-up text-warning mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('GTmetrix', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 provider-check d-none"></i>
                                </div>
                            </div>
                                            <div class="col-3">
                                                <div class="provider-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-provider="pingdom" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-stopwatch text-info mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Pingdom', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 provider-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <div class="provider-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-provider="webpagetest" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-globe text-success mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('WebPage', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 provider-check d-none"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" id="speed_test_provider" name="speed_test_provider" value="<?php echo esc_attr(get_option('speed_test_provider', 'google_pagespeed')); ?>">
                                        <small class="text-muted"><?php esc_html_e('Choose your preferred speed testing service', 'ams-wc-amazon'); ?></small>
                                        
                                        <!-- API Key Configuration for Selected Provider -->
                                        <div class="mt-3 p-3 bg-light rounded" id="apiKeySection">
                                            <h6 class="fw-bold mb-2">
                                                <i class="bi bi-key text-primary me-2"></i>
                                                <span id="apiKeyTitle"><?php esc_html_e('API Configuration', 'ams-wc-amazon'); ?></span>
                                </h6>
                                
                                            <!-- Google PageSpeed API -->
                                            <div class="api-config-section" data-provider="google_pagespeed">
                                                <div class="row align-items-end">
                                    <div class="col-md-6">
                                                        <label for="google_pagespeed_api_key" class="form-label small fw-medium">
                                                            <i class="bi bi-google text-primary me-1"></i>
                                                            <?php esc_html_e('Google PageSpeed Insights API Key', 'ams-wc-amazon'); ?>
                                            </label>
                                                        <input type="password" class="form-control form-control-sm" id="google_pagespeed_api_key" 
                                                               name="google_pagespeed_api_key" 
                                                               value="<?php echo esc_attr(get_option('google_pagespeed_api_key', '')); ?>"
                                                               placeholder="<?php esc_attr_e('Enter your Google API key for real data', 'ams-wc-amazon'); ?>">
                                        </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label small fw-medium text-muted"><?php esc_html_e('Actions & Status', 'ams-wc-amazon'); ?></label>
                                                        <div class="d-flex gap-1 flex-wrap align-items-center">
                                                            <button type="button" class="btn btn-outline-success btn-sm test-api-btn" 
                                                                    data-provider="google_pagespeed" data-api-field="google_pagespeed_api_key">
                                                                <i class="bi bi-check-circle me-1"></i>
                                                                <?php esc_html_e('Test API', 'ams-wc-amazon'); ?>
                                                            </button>
                                                            <a href="https://developers.google.com/speed/docs/insights/v5/get-started" target="_blank" 
                                                               class="btn btn-outline-primary btn-sm">
                                                                <i class="bi bi-box-arrow-up-right me-1"></i>
                                                                <?php esc_html_e('Get Key', 'ams-wc-amazon'); ?>
                                                            </a>
                                                            <span class="badge <?php echo !empty(get_option('google_pagespeed_api_key')) ? 'bg-success' : 'bg-secondary'; ?> api-status-badge" 
                                                                  data-provider="google_pagespeed">
                                                                <?php echo !empty(get_option('google_pagespeed_api_key')) ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?>
                                                            </span>
                                    </div>
                                                    </div>
                                    </div>
                                                <small class="text-muted d-block mt-1">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    <?php esc_html_e('Free API key provides real PageSpeed Insights data. Without it, simulated data will be used.', 'ams-wc-amazon'); ?>
                                                </small>
                                            </div>
                                            
                                            <!-- GTmetrix API -->
                                            <div class="api-config-section d-none" data-provider="gtmetrix">
                                                <div class="row align-items-end">
                                    <div class="col-md-6">
                                                        <label for="gtmetrix_api_key" class="form-label small fw-medium">
                                                            <i class="bi bi-graph-up text-warning me-1"></i>
                                                            <?php esc_html_e('GTmetrix API Key', 'ams-wc-amazon'); ?>
                                            </label>
                                                        <input type="password" class="form-control form-control-sm" id="gtmetrix_api_key" 
                                                               name="gtmetrix_api_key" 
                                                               value="<?php echo esc_attr(get_option('gtmetrix_api_key', '')); ?>"
                                                               placeholder="<?php esc_attr_e('Enter your GTmetrix API key', 'ams-wc-amazon'); ?>">
                                        </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label small fw-medium text-muted"><?php esc_html_e('Actions & Status', 'ams-wc-amazon'); ?></label>
                                                        <div class="d-flex gap-1 flex-wrap align-items-center">
                                                            <button type="button" class="btn btn-outline-success btn-sm test-api-btn" 
                                                                    data-provider="gtmetrix" data-api-field="gtmetrix_api_key">
                                                                <i class="bi bi-check-circle me-1"></i>
                                                                <?php esc_html_e('Test API', 'ams-wc-amazon'); ?>
                                                            </button>
                                                            <a href="https://gtmetrix.com/api/" target="_blank" 
                                                               class="btn btn-outline-warning btn-sm">
                                                                <i class="bi bi-box-arrow-up-right me-1"></i>
                                                                <?php esc_html_e('Get Key', 'ams-wc-amazon'); ?>
                                                            </a>
                                                            <span class="badge <?php echo !empty(get_option('gtmetrix_api_key')) ? 'bg-success' : 'bg-secondary'; ?> api-status-badge" 
                                                                  data-provider="gtmetrix">
                                                                <?php echo !empty(get_option('gtmetrix_api_key')) ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?>
                                                            </span>
                                    </div>
                                                    </div>
                                                </div>
                                                <small class="text-muted d-block mt-1">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    <?php esc_html_e('Requires GTmetrix account. API implementation coming soon - currently using simulated data.', 'ams-wc-amazon'); ?>
                                                </small>
                                            </div>
                                            
                                            <!-- Pingdom API -->
                                            <div class="api-config-section d-none" data-provider="pingdom">
                                                <div class="row align-items-end">
                                    <div class="col-md-6">
                                                        <label for="pingdom_api_key" class="form-label small fw-medium">
                                                            <i class="bi bi-stopwatch text-info me-1"></i>
                                                            <?php esc_html_e('Pingdom API Key', 'ams-wc-amazon'); ?>
                                            </label>
                                                        <input type="password" class="form-control form-control-sm" id="pingdom_api_key" 
                                                               name="pingdom_api_key" 
                                                               value="<?php echo esc_attr(get_option('pingdom_api_key', '')); ?>"
                                                               placeholder="<?php esc_attr_e('Enter your Pingdom API key', 'ams-wc-amazon'); ?>">
                                        </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label small fw-medium text-muted"><?php esc_html_e('Actions & Status', 'ams-wc-amazon'); ?></label>
                                                        <div class="d-flex gap-1 flex-wrap align-items-center">
                                                            <button type="button" class="btn btn-outline-success btn-sm test-api-btn" 
                                                                    data-provider="pingdom" data-api-field="pingdom_api_key">
                                                                <i class="bi bi-check-circle me-1"></i>
                                                                <?php esc_html_e('Test API', 'ams-wc-amazon'); ?>
                                                            </button>
                                                            <a href="https://docs.pingdom.com/api/" target="_blank" 
                                                               class="btn btn-outline-info btn-sm">
                                                                <i class="bi bi-box-arrow-up-right me-1"></i>
                                                                <?php esc_html_e('Get Key', 'ams-wc-amazon'); ?>
                                                            </a>
                                                            <span class="badge <?php echo !empty(get_option('pingdom_api_key')) ? 'bg-success' : 'bg-secondary'; ?> api-status-badge" 
                                                                  data-provider="pingdom">
                                                                <?php echo !empty(get_option('pingdom_api_key')) ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?>
                                                            </span>
                                    </div>
                                                    </div>
                                                </div>
                                                <small class="text-muted d-block mt-1">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    <?php esc_html_e('Requires Pingdom account. API implementation coming soon - currently using simulated data.', 'ams-wc-amazon'); ?>
                                                </small>
                            </div>

                                            <!-- WebPageTest API -->
                                            <div class="api-config-section d-none" data-provider="webpagetest">
                                                <div class="row align-items-end">
                                    <div class="col-md-6">
                                                        <label for="webpagetest_api_key" class="form-label small fw-medium">
                                                            <i class="bi bi-globe text-success me-1"></i>
                                                            <?php esc_html_e('WebPageTest API Key', 'ams-wc-amazon'); ?>
                                            </label>
                                                        <input type="password" class="form-control form-control-sm" id="webpagetest_api_key" 
                                                               name="webpagetest_api_key" 
                                                               value="<?php echo esc_attr(get_option('webpagetest_api_key', '')); ?>"
                                                               placeholder="<?php esc_attr_e('Enter your WebPageTest API key', 'ams-wc-amazon'); ?>">
                                        </div>
                                                    <div class="col-md-6">
                                                        <label class="form-label small fw-medium text-muted"><?php esc_html_e('Actions & Status', 'ams-wc-amazon'); ?></label>
                                                        <div class="d-flex gap-1 flex-wrap align-items-center">
                                                            <button type="button" class="btn btn-outline-success btn-sm test-api-btn" 
                                                                    data-provider="webpagetest" data-api-field="webpagetest_api_key">
                                                                <i class="bi bi-check-circle me-1"></i>
                                                                <?php esc_html_e('Test API', 'ams-wc-amazon'); ?>
                                                            </button>
                                                            <a href="https://www.webpagetest.org/getkey.php" target="_blank" 
                                                               class="btn btn-outline-success btn-sm">
                                                                <i class="bi bi-box-arrow-up-right me-1"></i>
                                                                <?php esc_html_e('Get Key', 'ams-wc-amazon'); ?>
                                                            </a>
                                                            <span class="badge <?php echo !empty(get_option('webpagetest_api_key')) ? 'bg-success' : 'bg-secondary'; ?> api-status-badge" 
                                                                  data-provider="webpagetest">
                                                                <?php echo !empty(get_option('webpagetest_api_key')) ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <small class="text-muted d-block mt-1">
                                                    <i class="bi bi-info-circle me-1"></i>
                                                    <?php esc_html_e('Free API key available. API implementation coming soon - currently using simulated data.', 'ams-wc-amazon'); ?>
                                                </small>
                                    </div>
                                </div>
                            </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold mb-2">
                                            <i class="bi bi-clock text-primary me-2"></i>
                                            <?php esc_html_e('Update Frequency', 'ams-wc-amazon'); ?>
                                        </label>
                                        <div class="row g-1 mb-2">
                                            <div class="col-3">
                                                <div class="frequency-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-frequency="daily" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-calendar-day text-primary mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Daily', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 frequency-check d-none"></i>
                                            </div>
                                                    </div>
                                            <div class="col-3">
                                                <div class="frequency-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-frequency="weekly" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-calendar-week text-info mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Weekly', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 frequency-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <div class="frequency-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-frequency="monthly" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-calendar-month text-warning mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Monthly', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 frequency-check d-none"></i>
                                        </div>
                                    </div>
                                            <div class="col-3">
                                                <div class="frequency-option btn btn-outline-secondary btn-sm d-flex flex-column align-items-center justify-content-center p-2 h-100" 
                                                     data-frequency="manual" tabindex="0" role="button" style="min-height: 80px;">
                                                    <i class="bi bi-hand-index text-secondary mb-1 fs-5"></i>
                                                    <span class="small text-center"><?php esc_html_e('Manual', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success mt-1 frequency-check d-none"></i>
                                            </div>
                                                    </div>
                                                </div>
                                        <input type="hidden" id="test_frequency" name="test_frequency" value="<?php echo esc_attr(get_option('test_frequency', 'daily')); ?>">
                                        <small class="text-muted"><?php esc_html_e('How often to run speed tests automatically', 'ams-wc-amazon'); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    
                            <!-- Display Metrics Badges -->
                            <div class="mb-4">
                                <h6 class="fw-bold mb-3">
                                    <i class="bi bi-eye text-primary me-2"></i>
                                    <?php esc_html_e('Display Metrics', 'ams-wc-amazon'); ?>
                                </h6>
                                
                                <div class="row g-1 mb-2">
                                    <div class="col-md-3 col-sm-6">
                                        <div class="metric-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                             data-metric="show_performance_score" tabindex="0" role="button">
                                            <i class="bi bi-speedometer me-1"></i>
                                            <span class="small"><?php esc_html_e('Score', 'ams-wc-amazon'); ?></span>
                                            <i class="bi bi-check-circle-fill text-success ms-1 metric-check d-none"></i>
                                            </div>
                                                    </div>
                                    <div class="col-md-3 col-sm-6">
                                        <div class="metric-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                             data-metric="show_load_time" tabindex="0" role="button">
                                            <i class="bi bi-clock me-1"></i>
                                            <span class="small"><?php esc_html_e('Load Time', 'ams-wc-amazon'); ?></span>
                                            <i class="bi bi-check-circle-fill text-success ms-1 metric-check d-none"></i>
                                                </div>
                                            </div>
                                    <div class="col-md-3 col-sm-6">
                                        <div class="metric-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                             data-metric="show_page_size" tabindex="0" role="button">
                                            <i class="bi bi-file-earmark me-1"></i>
                                            <span class="small"><?php esc_html_e('Page Size', 'ams-wc-amazon'); ?></span>
                                            <i class="bi bi-check-circle-fill text-success ms-1 metric-check d-none"></i>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-6">
                                        <div class="metric-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                             data-metric="show_requests_count" tabindex="0" role="button">
                                            <i class="bi bi-arrow-repeat me-1"></i>
                                            <span class="small"><?php esc_html_e('Requests', 'ams-wc-amazon'); ?></span>
                                            <i class="bi bi-check-circle-fill text-success ms-1 metric-check d-none"></i>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" id="show_performance_score" name="show_performance_score" value="<?php echo esc_attr(get_option('show_performance_score', '1')); ?>">
                                <input type="hidden" id="show_load_time" name="show_load_time" value="<?php echo esc_attr(get_option('show_load_time', '1')); ?>">
                                <input type="hidden" id="show_page_size" name="show_page_size" value="<?php echo esc_attr(get_option('show_page_size', '1')); ?>">
                                <input type="hidden" id="show_requests_count" name="show_requests_count" value="<?php echo esc_attr(get_option('show_requests_count', '1')); ?>">
                                <small class="text-muted"><?php esc_html_e('Select which performance metrics to display', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    
                            <!-- Visual Style Selector -->
                            <div class="mb-4">
                                <h6 class="fw-bold mb-3">
                                    <i class="bi bi-palette text-primary me-2"></i>
                                    <?php esc_html_e('Visual Style', 'ams-wc-amazon'); ?>
                                </h6>
                                <p class="text-muted mb-3">
                    <?php esc_html_e('Choose how the speed test results appear on your product pages.', 'ams-wc-amazon'); ?>
                                </p>
                                
                                <!-- Hidden input for form submission -->
                                <input type="hidden" id="page_speed_test_style" name="page_speed_test_style" value="<?php echo esc_attr(get_option('page_speed_test_style', 'style1')); ?>">
                                
                                <!-- Visual Style Options -->
                <div class="row g-2 mb-3">
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style1" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-dark text-white px-3 py-2 rounded mb-2" style="font-size: 12px; min-width: 80px; height: 40px; display: flex; align-items: center;">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <span class="small">Perf</span>
                                    <span class="badge bg-success" style="font-size: 10px;">95</span>
                                            </div>
                                                        </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Professional Dark', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                                        </div>
                                                    </div>
                                    
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style2" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-light border px-3 py-2 rounded mb-2" style="font-size: 12px; min-width: 80px; height: 40px; display: flex; align-items: center;">
                                <div class="d-flex justify-content-between align-items-center w-100">
                                    <span class="small text-dark">Perf</span>
                                    <span class="badge bg-primary" style="font-size: 10px;">92</span>
                                                </div>
                                            </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Clean Light', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                        </div>
                                    </div>
                                    
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style3" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-primary text-white px-3 py-2 rounded mb-2 text-center" style="font-size: 14px; min-width: 80px; height: 40px; display: flex; flex-column; justify-content: center;">
                                <div class="fw-bold">89</div>
                                <small style="font-size: 10px;">Score</small>
                                            </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Compact Score', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                                        </div>
                                                    </div>
                    
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style4" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-success-subtle border border-success px-3 py-2 rounded mb-2" style="font-size: 11px; min-width: 80px; height: 40px; display: flex; align-items: center;">
                                <div class="d-flex justify-content-between w-100">
                                    <span class="text-success fw-bold">94</span>
                                    <span class="text-muted">1.1s</span>
                                                </div>
                                            </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Detailed Metrics', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                        </div>
                                    </div>
                                    
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style5" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-warning text-dark px-3 py-2 rounded mb-2 d-flex align-items-center justify-content-center" style="font-size: 12px; min-width: 80px; height: 40px;">
                                <i class="bi bi-speedometer2 me-1"></i>
                                <span class="fw-medium">Fast</span>
                                            </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Badge Style', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                                    </div>
                                                </div>
                    
                    <div class="col-md-4 col-sm-6">
                        <div class="visual-style-option btn btn-outline-secondary d-flex flex-column align-items-center justify-content-center p-3 h-100" 
                             data-style="style6" tabindex="0" role="button" style="min-height: 120px;">
                            <div class="bg-info text-white px-3 py-2 rounded mb-2 text-center d-flex align-items-center justify-content-center" style="min-width: 80px; height: 40px;">
                                <i class="bi bi-lightning-charge fs-4"></i>
                                            </div>
                            <span class="fw-semibold text-center small"><?php esc_html_e('Minimal Icon', 'ams-wc-amazon'); ?></span>
                            <i class="bi bi-check-circle-fill text-success mt-1 visual-style-check d-none"></i>
                                        </div>
                                    </div>
                                </div>
                <small class="text-muted"><?php esc_html_e('Compact style previews - click to select and see full preview below', 'ams-wc-amazon'); ?></small>
                            </div>

                            <!-- Live Preview -->
                            <div class="mb-4">
                                <h6 class="fw-bold mb-3">
                                    <i class="bi bi-eye text-primary me-2"></i>
                                    <?php esc_html_e('Live Preview', 'ams-wc-amazon'); ?>
                                </h6>
                                <div id="speedTestPreview" class="border rounded p-3 bg-white">
                                    <!-- Preview will be populated by JavaScript -->
                                </div>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>
                                    <?php esc_html_e('This preview updates automatically when you change settings. Use "Update Preview" button below to refresh manually.', 'ams-wc-amazon'); ?>
                                </small>
                            </div>

                            <!-- Advanced Settings -->
                            <div class="mb-3">
                                <h6 class="fw-bold mb-3">
                                    <i class="bi bi-sliders text-primary me-2"></i>
                                    <?php esc_html_e('Advanced Settings', 'ams-wc-amazon'); ?>
                                </h6>
                                
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label fw-bold mb-3">
                                            <i class="bi bi-geo-alt text-primary me-2"></i>
                                            <?php esc_html_e('Display Position', 'ams-wc-amazon'); ?>
                                        </label>
                                        <p class="text-muted mb-3 small">
                                            <?php esc_html_e('Choose where the speed test results will appear on your website. Click any position to select it.', 'ams-wc-amazon'); ?>
                                        </p>
                                        
                                        <!-- Hidden input for form submission -->
                                        <input type="hidden" id="display_position" name="display_position" value="<?php echo esc_attr(get_option('display_position', 'footer_left')); ?>">
                                        
                                        <!-- Position Badge Options - All in One Row -->
                                        <div class="row g-1 mb-3">
                                            <div class="col">
                                                <div class="position-badge-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-position="footer_left" tabindex="0" role="button">
                                                    <i class="bi bi-arrow-down-left me-1"></i>
                                                    <span class="small"><?php esc_html_e('Bottom Left', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 position-check d-none"></i>
                                                </div>
                                            </div>
                                            
                                            <div class="col">
                                                <div class="position-badge-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-position="footer_right" tabindex="0" role="button">
                                                    <i class="bi bi-arrow-down-right me-1"></i>
                                                    <span class="small"><?php esc_html_e('Bottom Right', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 position-check d-none"></i>
                                                </div>
                                            </div>
                                            
                                            <div class="col">
                                                <div class="position-badge-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-position="top_left" tabindex="0" role="button">
                                                    <i class="bi bi-arrow-up-left me-1"></i>
                                                    <span class="small"><?php esc_html_e('Top Left', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 position-check d-none"></i>
                                                </div>
                                            </div>
                                            
                                            <div class="col">
                                                <div class="position-badge-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-position="top_right" tabindex="0" role="button">
                                                    <i class="bi bi-arrow-up-right me-1"></i>
                                                    <span class="small"><?php esc_html_e('Top Right', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 position-check d-none"></i>
                                                </div>
                                            </div>
                                            
                                            <div class="col">
                                                <div class="position-badge-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-position="sidebar" tabindex="0" role="button">
                                                    <i class="bi bi-layout-sidebar me-1"></i>
                                                    <span class="small"><?php esc_html_e('Sidebar', 'ams-wc-amazon'); ?></span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 position-check d-none"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold mb-2">
                                            <?php esc_html_e('Cache Duration', 'ams-wc-amazon'); ?>
                                        </label>
                                        <div class="row g-1 mb-2">
                                            <div class="col">
                                                <div class="cache-duration-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-duration="1" tabindex="0" role="button">
                                                    <span class="small">1h</span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 cache-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="cache-duration-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-duration="6" tabindex="0" role="button">
                                                    <span class="small">6h</span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 cache-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="cache-duration-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-duration="24" tabindex="0" role="button">
                                                    <span class="small">24h</span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 cache-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="cache-duration-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-duration="72" tabindex="0" role="button">
                                                    <span class="small">72h</span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 cache-check d-none"></i>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="cache-duration-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                     data-duration="168" tabindex="0" role="button">
                                                    <span class="small">1w</span>
                                                    <i class="bi bi-check-circle-fill text-success ms-1 cache-check d-none"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" id="cache_duration" name="cache_duration" value="<?php echo esc_attr(get_option('cache_duration', '24')); ?>">
                                        <small class="text-muted"><?php esc_html_e('Cache test results duration', 'ams-wc-amazon'); ?></small>
                                    </div>
                                </div>
                                
                                <div class="mt-3">
                                    <label class="form-label fw-bold mb-2">
                                        <?php esc_html_e('Display Options', 'ams-wc-amazon'); ?>
                                        </label>
                                    <div class="row g-1">
                                        <div class="col-md-6">
                                            <div class="mobile-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                 data-mobile="1" tabindex="0" role="button">
                                                <i class="bi bi-phone me-1"></i>
                                                <span class="small"><?php esc_html_e('Show on Mobile', 'ams-wc-amazon'); ?></span>
                                                <i class="bi bi-check-circle-fill text-success ms-1 mobile-check d-none"></i>
                                    </div>
                                    </div>
                                        <div class="col-md-6">
                                            <div class="debug-option btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center p-2" 
                                                 data-debug="1" tabindex="0" role="button">
                                                <i class="bi bi-bug me-1"></i>
                                                <span class="small"><?php esc_html_e('Debug Mode', 'ams-wc-amazon'); ?></span>
                                                <i class="bi bi-check-circle-fill text-success ms-1 debug-check d-none"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" id="show_on_mobile" name="show_on_mobile" value="<?php echo esc_attr(get_option('show_on_mobile', '1')); ?>">
                                    <input type="hidden" id="speed_test_debug" name="speed_test_debug" value="<?php echo esc_attr(get_option('speed_test_debug', '0')); ?>">
                                    <small class="text-muted d-block mt-1"><?php esc_html_e('Mobile display and public visibility options', 'ams-wc-amazon'); ?></small>
                                </div>
                            </div>

                            <!-- Test Now Button -->
                            <div class="text-center">
                                <button type="button" class="btn btn-primary" id="runSpeedTest">
                                    <i class="bi bi-play-circle me-2"></i>
                                    <?php esc_html_e('Run Speed Test Now', 'ams-wc-amazon'); ?>
                                </button>
                                <button type="button" class="btn btn-outline-secondary ms-2" id="clearSpeedCache">
                                    <i class="bi bi-arrow-clockwise me-2"></i>
                                    <?php esc_html_e('Clear Cache', 'ams-wc-amazon'); ?>
                                </button>
                                <button type="button" class="btn btn-outline-info ms-2" id="testPreviewUpdate">
                                    <i class="bi bi-eye me-2"></i>
                                    <?php esc_html_e('Update Preview', 'ams-wc-amazon'); ?>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Last Updated Date Settings -->
                    <div class="settings-section mb-4 pb-4 border-bottom">
                        <div class="section-header d-flex align-items-center justify-content-between mb-3">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-calendar-check text-primary me-2 fs-4"></i>
                                <h4 class="m-0"><?php esc_html_e('Last Updated Date Settings', 'ams-wc-amazon'); ?></h4>
                            </div>
                            <div class="ms-3">
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" id="enable_last_updated_date" 
                                           name="enable_last_updated_date" value="1" 
                                           <?php checked(get_option('enable_last_updated_date'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="bg-light p-4 rounded-3">
                            <p class="text-muted mb-2">
                                <?php esc_html_e('Enable or disable the display of the "Last Updated Date" for products on the front end.', 'ams-wc-amazon'); ?>
                            </p>

                            <!-- Enable/Disable Custom Notice -->
                            <div class="d-flex align-items-center mb-3">
                                <label for="enable_custom_message" class="form-label me-2 fw-bold">
                                    <?php esc_html_e('Enable Custom Notice Message', 'ams-wc-amazon'); ?>
                                </label>
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" id="enable_custom_message" 
                                           name="enable_custom_message" value="1" 
                                           <?php checked(get_option('enable_custom_message'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>

                            <!-- Custom Notice Message -->
                            <div class="mb-3">
                                <label for="last_updated_custom_message" class="form-label fw-bold">
                                    <?php esc_html_e('Custom Notice Message', 'ams-wc-amazon'); ?>
                                </label>
                                <textarea id="last_updated_custom_message" 
                                          name="last_updated_custom_message" 
                                          class="form-control" 
                                          rows="3"><?php 
                                              echo esc_html(get_option('last_updated_custom_message', 'Important Notice: Product details may change. Please check regularly for updates.')); 
                                          ?></textarea>
                            </div>
                            <p class="text-muted">
                                <?php esc_html_e('This message will be displayed above the "Last Updated On" date. Leave blank to use the default message.', 'ams-wc-amazon'); ?>
                            </p>

                            <!-- Notice Style -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">
                                    <?php esc_html_e('Select Notice Style', 'ams-wc-amazon'); ?>
                                </label>
                                <p class="text-muted mb-3">
                                    <?php esc_html_e('Choose a predefined style for the custom notice message displayed on the product page.', 'ams-wc-amazon'); ?>
                                </p>
                                
                                <!-- Hidden input for form submission -->
                                <input type="hidden" id="last_updated_notice_style" name="last_updated_notice_style" value="<?php echo esc_attr(get_option('last_updated_notice_style', 'style1')); ?>">
                                
                                <!-- Visual Style Selector -->
                                <div class="row g-2" id="styleSelector">
                                    <?php 
                                    $current_style = get_option('last_updated_notice_style', 'style1');
                                    $styles = [
                                        'style1' => ['name' => 'Default', 'icon' => 'ℹ️', 'desc' => 'Clean'],
                                        'style2' => ['name' => 'Alert', 'icon' => '⚠️', 'desc' => 'Attention'],
                                        'style3' => ['name' => 'Success', 'icon' => '✅', 'desc' => 'Positive'],
                                        'style4' => ['name' => 'Warning', 'icon' => '⚠️', 'desc' => 'Important'],
                                        'style5' => ['name' => 'Modern', 'icon' => '📋', 'desc' => 'Contemporary'],
                                        'style6' => ['name' => 'Gradient', 'icon' => 'ℹ️', 'desc' => 'Colorful'],
                                        'style7' => ['name' => 'Glass', 'icon' => '🔔', 'desc' => 'Glass blur'],
                                        'style8' => ['name' => 'Neon', 'icon' => '⚡', 'desc' => 'Futuristic'],
                                        'style9' => ['name' => 'Minimal', 'icon' => '📅', 'desc' => 'Clean card'],
                                        'style10' => ['name' => 'Dark', 'icon' => '⚠️', 'desc' => 'Dark theme']
                                    ];
                                    
                                    foreach ($styles as $style_key => $style_info) :
                                        $is_selected = ($current_style === $style_key) ? 'selected' : '';
                                    ?>
                                    <div class="col-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                                        <div class="card h-100 border-2 ams-style-option <?php echo $is_selected; ?>" 
                                             data-style="<?php echo esc_attr($style_key); ?>" 
                                             role="button" 
                                             tabindex="0">
                                            
                                            <!-- Preview Area -->
                                            <div class="card-body p-2 d-flex flex-column">
                                                <div class="flex-grow-1 d-flex align-items-center justify-content-center mb-2">
                                                    <div class="custom-dynamic-notice <?php echo esc_attr($style_key); ?> text-center small" style="padding: 8px 12px; margin: 0; font-size: 11px;">
                                                        Notice
                                                    </div>
                                                </div>
                                                
                                                <!-- Style Info -->
                                                <div class="text-center mb-2">
                                                    <h6 class="card-title mb-1 small fw-bold"><?php echo esc_html($style_info['name']); ?></h6>
                                                    <small class="text-muted"><?php echo esc_html($style_info['desc']); ?></small>
                                                </div>
                                                
                                                <!-- Preview Button -->
                                                <div class="text-center">
                                                    <button type="button" 
                                                            class="btn btn-outline-primary btn-sm preview-btn" 
                                                            data-style="<?php echo esc_attr($style_key); ?>"
                                                            data-bs-toggle="tooltip" 
                                                            title="Preview Full Size">
                                                        <i class="bi bi-eye"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <!-- Selection Check -->
                                            <div class="position-absolute top-0 end-0 p-2 ams-style-check">
                                                <i class="bi bi-check-circle-fill text-primary fs-5"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                                
                                <!-- Preview Modal - Bootstrap 5 -->
                                <div class="modal fade" id="stylePreviewModal" tabindex="-1" aria-labelledby="stylePreviewModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg modal-dialog-centered">
                                        <div class="modal-content shadow">
                                            <div class="modal-header bg-primary text-white">
                                                <h5 class="modal-title" id="stylePreviewModalLabel">
                                                    <i class="bi bi-eye me-2"></i>Style Preview
                                                </h5>
                                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body p-4">
                                                <div class="alert alert-info d-flex align-items-center mb-3" role="alert">
                                                    <i class="bi bi-info-circle me-2"></i>
                                                    <div>This is how your notice will appear on the frontend product pages.</div>
                                                </div>
                                                <div id="fullPreviewContainer" class="bg-light p-4 rounded-3 text-center">
                                                    <!-- Full preview will be inserted here -->
                                                </div>
                                            </div>
                                            <div class="modal-footer bg-light">
                                                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                    <i class="bi bi-x-circle me-1"></i>Close
                                                </button>
                                                <button type="button" class="btn btn-primary" id="selectPreviewedStyle">
                                                    <i class="bi bi-check-circle me-1"></i>Select This Style
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Live Preview -->
                            <div class="mb-4">
                                <label class="form-label fw-bold">
                                    <?php esc_html_e('Live Preview', 'ams-wc-amazon'); ?>
                                </label>
                                <div id="noticePreview" class="border rounded p-3 bg-light">
                                    <div class="custom-dynamic-notice style1">
                                        <?php echo esc_html(get_option('last_updated_custom_message', 'Product details may change - check for updates.')); ?>
                                    </div>
                                    <small class="text-muted"><?php esc_html_e('Last updated: 2 hours ago', 'ams-wc-amazon'); ?></small>
                                </div>
                            </div>

                            <!-- Advanced Date Formatting -->
                            <div class="mb-3">
                                <label for="date_format_type" class="form-label fw-bold">
                                    <?php esc_html_e('Date Format Type', 'ams-wc-amazon'); ?>
                                </label>
                                <select id="date_format_type" name="date_format_type" class="form-select">
                                    <option value="standard" <?php selected(get_option('date_format_type'), 'standard'); ?>>
                                        <?php esc_html_e('Standard (March 15, 2024)', 'ams-wc-amazon'); ?>
                                    </option>
                                    <option value="relative" <?php selected(get_option('date_format_type'), 'relative'); ?>>
                                        <?php esc_html_e('Relative (2 hours ago)', 'ams-wc-amazon'); ?>
                                    </option>
                                    <option value="short" <?php selected(get_option('date_format_type'), 'short'); ?>>
                                        <?php esc_html_e('Short (15/03/2024)', 'ams-wc-amazon'); ?>
                                    </option>
                                    <option value="custom" <?php selected(get_option('date_format_type'), 'custom'); ?>>
                                        <?php esc_html_e('Custom Format', 'ams-wc-amazon'); ?>
                                    </option>
                                </select>
                            </div>

                            <!-- Custom Date Format -->
                            <div class="mb-3" id="customDateFormatDiv" style="display: none;">
                                <label for="custom_date_format" class="form-label fw-bold">
                                    <?php esc_html_e('Custom Date Format', 'ams-wc-amazon'); ?>
                                </label>
                                <input type="text" id="custom_date_format" name="custom_date_format" 
                                       class="form-control" 
                                       value="<?php echo esc_attr(get_option('custom_date_format', 'F j, Y')); ?>"
                                       placeholder="F j, Y">
                                <small class="text-muted">
                                    <?php esc_html_e('Use PHP date format. Examples: F j, Y (March 15, 2024), d/m/Y (15/03/2024)', 'ams-wc-amazon'); ?>
                                </small>
                        </div>

                            <!-- Smart Display Logic -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">
                                    <?php esc_html_e('Smart Display Options', 'ams-wc-amazon'); ?>
                                </label>
                                
                                <div class="d-flex align-items-center mb-2">
                                    <input type="checkbox" id="show_only_old_products" name="show_only_old_products" 
                                           value="1" class="form-check-input me-2"
                                           <?php checked(get_option('show_only_old_products'), '1'); ?>>
                                    <label for="show_only_old_products" class="form-check-label">
                                        <?php esc_html_e('Show notice only for products older than', 'ams-wc-amazon'); ?>
                                    </label>
                                    <input type="number" name="old_product_days" class="form-control ms-2" 
                                           style="width: 80px;" min="1" max="365"
                                           value="<?php echo esc_attr(get_option('old_product_days', '30')); ?>">
                                    <span class="ms-1"><?php esc_html_e('days', 'ams-wc-amazon'); ?></span>
                    </div>


                            </div>

                            <!-- Message Templates -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">
                                    <?php esc_html_e('Message Templates', 'ams-wc-amazon'); ?>
                                </label>
                                <div class="row g-2">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-outline-primary btn-sm w-100" 
                                                onclick="insertTemplate('urgent')">
                                            <?php esc_html_e('Urgent Update', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-outline-success btn-sm w-100" 
                                                onclick="insertTemplate('info')">
                                            <?php esc_html_e('Information', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-outline-warning btn-sm w-100" 
                                                onclick="insertTemplate('price')">
                                            <?php esc_html_e('Price Change', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-outline-info btn-sm w-100" 
                                                onclick="insertTemplate('availability')">
                                            <?php esc_html_e('Availability', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>
            </div>
            <!--End AMSWOO Settings-->

            <!-- Enhanced Last Updated Date Settings JavaScript -->
            <style>
            /* Minimal Custom CSS - Use Bootstrap 5 Classes Where Possible */
            
            /* Style Option Cards - Bootstrap 5 Enhanced */
            .ams-style-option {
                min-height: 120px;
                transition: all 0.3s ease;
            }
            
            .ams-style-option:hover {
                transform: translateY(-2px);
            }
            
            .ams-style-option.selected {
                border-color: var(--bs-primary) !important;
                background-color: var(--bs-light) !important;
            }
            
            .ams-style-check {
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
                         .ams-style-option.selected .ams-style-check {
                 opacity: 1;
             }
             
             /* Speed Test Style Options */
             .speed-style-option {
                 min-height: 120px;
                 transition: all 0.3s ease;
                 cursor: pointer;
             }
             
             .speed-style-option:hover {
                 transform: translateY(-2px);
                 box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
             }
             
             .speed-style-option.selected {
                 border-color: var(--bs-primary) !important;
                 background-color: var(--bs-light) !important;
             }
             
             .speed-style-check {
                 opacity: 0;
                 transition: opacity 0.3s ease;
             }
             
             .speed-style-option.selected .speed-style-check {
                 opacity: 1;
             }
            
            /* Preview Styles - Exact Copy from Frontend CSS */
            .custom-dynamic-notice {
                display: block !important;
                margin: 15px 0 !important;
                padding: 15px 20px !important;
                font-family: inherit !important;
                font-size: 14px !important;
                line-height: 1.6 !important;
                border-radius: 6px !important;
                box-sizing: border-box !important;
                position: relative !important;
                word-wrap: break-word !important;
                overflow-wrap: break-word !important;
                transition: all 0.3s ease !important;
            }

            /* Style 1: Classic Blue Info */
            .custom-dynamic-notice.style1 {
                background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%) !important;
                border: none !important;
                border-left: 5px solid #2196f3 !important;
                border-radius: 8px !important;
                color: #1565c0 !important;
                box-shadow: 0 2px 8px rgba(33, 150, 243, 0.15) !important;
            }

            /* Style 2: Warning Orange */
            .custom-dynamic-notice.style2 {
                background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%) !important;
                border: none !important;
                border-left: 5px solid #ff9800 !important;
                border-radius: 10px !important;
                color: #e65100 !important;
                box-shadow: 0 3px 12px rgba(255, 152, 0, 0.2) !important;
            }

            /* Style 3: Success Green */
            .custom-dynamic-notice.style3 {
                background: linear-gradient(135deg, #e8f5e8 0%, #c8e6c9 100%) !important;
                border: none !important;
                border-radius: 12px !important;
                color: #2e7d32 !important;
                border: 2px solid #4caf50 !important;
                box-shadow: 0 4px 16px rgba(76, 175, 80, 0.25) !important;
            }

            /* Style 4: Elegant Pink */
            .custom-dynamic-notice.style4 {
                background: linear-gradient(45deg, #fce4ec 0%, #f8bbd9 100%) !important;
                border: none !important;
                border-radius: 15px !important;
                color: #ad1457 !important;
                box-shadow: 0 5px 20px rgba(233, 30, 99, 0.3) !important;
                border: 2px solid #e91e63 !important;
            }

            /* Style 5: Modern Purple */
            .custom-dynamic-notice.style5 {
                background: linear-gradient(135deg, #f3e5f5 0%, #e1bee7 100%) !important;
                border: none !important;
                border-radius: 8px !important;
                color: #6a1b9a !important;
                box-shadow: 0 3px 10px rgba(156, 39, 176, 0.2) !important;
                border-left: 4px solid #9c27b0 !important;
            }

            /* Style 6: Fresh Teal */
            .custom-dynamic-notice.style6 {
                background: linear-gradient(135deg, #e0f2f1 0%, #b2dfdb 100%) !important;
                border: none !important;
                border-radius: 10px !important;
                color: #00695c !important;
                box-shadow: 0 4px 12px rgba(0, 150, 136, 0.18) !important;
                border-left: 4px solid #009688 !important;
            }

            /* Style 7: Professional Indigo */
            .custom-dynamic-notice.style7 {
                background: linear-gradient(135deg, #e8eaf6 0%, #c5cae9 100%) !important;
                border: none !important;
                border-radius: 12px !important;
                color: #283593 !important;
                box-shadow: 0 6px 18px rgba(63, 81, 181, 0.25) !important;
                border-left: 5px solid #3f51b5 !important;
            }

            /* Style 8: Energetic Yellow */
            .custom-dynamic-notice.style8 {
                background: linear-gradient(135deg, #fffde7 0%, #fff9c4 100%) !important;
                border: none !important;
                border-radius: 8px !important;
                color: #f57f17 !important;
                box-shadow: 0 3px 15px rgba(255, 193, 7, 0.3) !important;
                border-left: 4px solid #ffc107 !important;
            }
            
            /* Style 9: Minimalist Card */
            .custom-dynamic-notice.style9 {
                background: #ffffff !important;
                border: none !important;
                border-radius: 8px !important;
                color: #555 !important;
                border-left: 4px solid #3498db !important;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1) !important;
            }
            
            /* Style 10: Dark Theme */
            .custom-dynamic-notice.style10 {
                background: #2c3e50 !important;
                color: #ecf0f1 !important;
                border: none !important;
                border-radius: 10px !important;
                border-left: 5px solid #e74c3c !important;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3) !important;
            }
            
            /* Icon Prefixes for Preview */
            /* Icons removed - no pseudo-elements needed */
            
            /* Mobile Responsive */
            @media (max-width: 768px) {
                .ams-style-option {
                    min-height: 100px;
                }
            }
            </style>
            
            <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Initialize Bootstrap tooltips
                const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl);
                });
                
                // Visual Style Selector
                const styleOptions = document.querySelectorAll('.ams-style-option');
                const hiddenStyleInput = document.getElementById('last_updated_notice_style');
                const messageTextarea = document.getElementById('last_updated_custom_message');
                const previewDiv = document.getElementById('noticePreview');
                const dateFormatSelect = document.getElementById('date_format_type');
                const customDateFormatDiv = document.getElementById('customDateFormatDiv');
                
                // Style definitions for preview
                const styleDefinitions = {
                    'style1': { name: 'Default', icon: 'ℹ️' },
                    'style2': { name: 'Alert', icon: '⚠️' },
                    'style3': { name: 'Success', icon: '✅' },
                    'style4': { name: 'Warning', icon: '⚠️' },
                    'style5': { name: 'Modern', icon: '📋' },
                    'style6': { name: 'Gradient', icon: 'ℹ️' },
                    'style7': { name: 'Glass Effect', icon: '🔔' },
                    'style8': { name: 'Neon Glow', icon: '⚡' },
                    'style9': { name: 'Minimalist', icon: '📅' },
                    'style10': { name: 'Dark Theme', icon: '⚠️' }
                };
                
                // Handle style selection
                styleOptions.forEach(option => {
                    option.addEventListener('click', function(e) {
                        // Don't select if clicking on preview button
                        if (e.target.closest('.preview-btn')) {
                            return;
                        }
                        
                        // Remove selected class from all options
                        styleOptions.forEach(opt => opt.classList.remove('selected'));
                        
                        // Add selected class to clicked option
                        this.classList.add('selected');
                        
                        // Update hidden input value
                        const selectedStyle = this.dataset.style;
                        if (hiddenStyleInput) {
                            hiddenStyleInput.value = selectedStyle;
                        }
                        
                        // Update preview
                        updatePreview();
                    });
                    
                    // Keyboard support
                    option.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Handle preview buttons
                const previewButtons = document.querySelectorAll('.preview-btn');
                const previewModalEl = document.getElementById('stylePreviewModal');
                const previewModal = new bootstrap.Modal(previewModalEl);
                const fullPreviewContainer = document.getElementById('fullPreviewContainer');
                const selectPreviewedStyleBtn = document.getElementById('selectPreviewedStyle');
                let currentPreviewStyle = '';
                
                previewButtons.forEach(btn => {
                    btn.addEventListener('click', function(e) {
                        e.stopPropagation();
                        const style = this.dataset.style;
                        currentPreviewStyle = style;
                        
                        // Get current message
                        const message = messageTextarea ? messageTextarea.value || 'Important Notice: Product details may change. Please check regularly for updates.' : 'Important Notice: Product details may change. Please check regularly for updates.';
                        
                        // Get style info
                        const styleInfo = styleDefinitions[style] || { name: 'Unknown', icon: '❓' };
                        
                        // Show full preview in modal with proper styling
                        fullPreviewContainer.innerHTML = `
                            <div class="mb-3">
                                <h6 class="text-primary mb-2">${styleInfo.name} Style Preview</h6>
                            </div>
                            <div class="custom-dynamic-notice ${style}" style="max-width: 600px; margin: 0 auto;">
                                ${message}
                            </div>
                            <div class="mt-3">
                                <small class="text-muted">Last updated: 2 hours ago</small>
                            </div>
                        `;
                        
                        previewModal.show();
                    });
                });
                
                // Handle "Select This Style" button in modal
                if (selectPreviewedStyleBtn) {
                    selectPreviewedStyleBtn.addEventListener('click', function() {
                        if (currentPreviewStyle) {
                            // Remove selected class from all options
                            styleOptions.forEach(opt => opt.classList.remove('selected'));
                            
                            // Add selected class to the previewed style
                            const targetOption = document.querySelector(`[data-style="${currentPreviewStyle}"]`);
                            if (targetOption) {
                                targetOption.classList.add('selected');
                            }
                            
                            // Update hidden input
                            if (hiddenStyleInput) {
                                hiddenStyleInput.value = currentPreviewStyle;
                            }
                            
                            // Update main preview
                            updatePreview();
                            
                            // Close modal
                            previewModal.hide();
                        }
                    });
                }
                
                // Update preview when style or message changes
                function updatePreview() {
                    if (!hiddenStyleInput || !messageTextarea || !previewDiv) return;
                    
                    const selectedStyle = hiddenStyleInput.value;
                    const message = messageTextarea.value || 'Product details may change - check for updates.';
                    
                    previewDiv.innerHTML = `
                        <div class="custom-dynamic-notice ${selectedStyle}">
                            ${message}
                        </div>
                        <small class="text-muted mt-2 d-block"><?= esc_js(__('Last updated: 2 hours ago', 'ams-wc-amazon')); ?></small>
                    `;
                }
                
                if (messageTextarea) messageTextarea.addEventListener('input', updatePreview);
                
                // Show/hide custom date format
                function toggleCustomDateFormat() {
                    if (!dateFormatSelect || !customDateFormatDiv) return;
                    
                    if (dateFormatSelect.value === 'custom') {
                        customDateFormatDiv.style.display = 'block';
                    } else {
                        customDateFormatDiv.style.display = 'none';
                    }
                }
                
                if (dateFormatSelect) {
                    dateFormatSelect.addEventListener('change', toggleCustomDateFormat);
                    toggleCustomDateFormat(); // Initial check
                }
                
                // Initialize preview
                updatePreview();
            });
            
            // Message Templates
            function insertTemplate(type) {
                const textarea = document.getElementById('last_updated_custom_message');
                if (!textarea) return;
                
                const templates = {
                    urgent: 'URGENT: Product info updated - review before purchase.',
                    info: 'Product details regularly updated for accuracy.',
                    price: 'Price Alert: Verify current price before purchase.',
                    availability: 'Stock levels may vary - check availability.'
                };
                
                if (templates[type]) {
                    textarea.value = templates[type];
                    textarea.dispatchEvent(new Event('input')); // Trigger preview update
                }
            }
            
            // Analytics Dashboard (if enabled)
            function showAnalyticsDashboard() {
                // This would open a modal or redirect to analytics page
                if (typeof showToast === 'function') {
                    showToast('<?= esc_js(__('Analytics dashboard coming soon!', 'ams-wc-amazon')); ?>', 'success');
                }
            }
            
            // Speed Test Settings JavaScript
            function initializeSpeedTestSettings() {
                const speedStyleOptions = document.querySelectorAll('.speed-style-option');
                const speedHiddenInput = document.getElementById('page_speed_test_style');
                const speedPreviewDiv = document.getElementById('speedTestPreview');
                
                // Handle speed test style selection
                speedStyleOptions.forEach(option => {
                    option.addEventListener('click', function(e) {
                        // Remove selected class and hide check icons from all options
                        speedStyleOptions.forEach(opt => {
                            opt.classList.remove('selected', 'border-primary', 'bg-primary-subtle');
                            const checkIcon = opt.querySelector('.speed-style-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        // Add selected class and show check icon for clicked option
                        this.classList.add('selected', 'border-primary', 'bg-primary-subtle');
                        const checkIcon = this.querySelector('.speed-style-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        // Update hidden input value
                        const selectedStyle = this.dataset.style;
                        if (speedHiddenInput) {
                            speedHiddenInput.value = selectedStyle;
                        }
                        
                        // Update preview
                        updateSpeedTestPreview();
                        
                        // Show success message
                        if (typeof showToast === 'function') {
                            const styleName = this.querySelector('h6').textContent;
                            showToast(`Selected style: ${styleName}`, 'success');
                        }
                    });
                    
                    // Keyboard support
                    option.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Update speed test preview function
                function updateSpeedTestPreview() {
                    if (!speedPreviewDiv || !speedHiddenInput) {
                        console.log('Speed test preview elements not found');
                        return;
                    }
                    
                    const selectedStyle = speedHiddenInput.value || 'style1';
                    const showScore = document.getElementById('show_performance_score')?.value === '1';
                    const showLoadTime = document.getElementById('show_load_time')?.value === '1';
                    const showPageSize = document.getElementById('show_page_size')?.value === '1';
                    const showRequests = document.getElementById('show_requests_count')?.value === '1';
                    
                    console.log('Speed test preview update:', {
                        selectedStyle,
                        showScore,
                        showLoadTime,
                        showPageSize,
                        showRequests
                    });
                    
                    let previewHTML = '';
                    
                    switch(selectedStyle) {
                        case 'style1':
                            previewHTML = `
                                <div class="bg-dark text-white p-3 rounded">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="small">Performance</span>
                                        ${showScore ? '<span class="badge bg-success">95</span>' : ''}
                                    </div>
                                    ${showLoadTime ? '<div class="small text-light">Load Time: 1.2s</div>' : ''}
                                    ${showPageSize ? '<div class="small text-light">Size: 2.1MB</div>' : ''}
                                    ${showRequests ? '<div class="small text-light">Requests: 45</div>' : ''}
                                    ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<div class="small text-muted">Select display options above to see metrics</div>' : ''}
                                </div>
                            `;
                            break;
                        case 'style2':
                            previewHTML = `
                                <div class="bg-light border p-3 rounded">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="small">Performance</span>
                                        ${showScore ? '<span class="badge bg-primary">92</span>' : ''}
                                    </div>
                                    ${showLoadTime ? '<div class="small text-muted">Load Time: 1.4s</div>' : ''}
                                    ${showPageSize ? '<div class="small text-muted">Size: 1.8MB</div>' : ''}
                                    ${showRequests ? '<div class="small text-muted">Requests: 38</div>' : ''}
                                    ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<div class="small text-muted">Select display options above to see metrics</div>' : ''}
                                </div>
                            `;
                            break;
                        case 'style3':
                            previewHTML = `
                                <div class="bg-gradient bg-primary text-white p-3 rounded text-center">
                                    ${showScore ? '<div class="h5 mb-0">89</div><small>Score</small>' : ''}
                                    ${showLoadTime ? '<div class="mt-2"><small>1.6s load</small></div>' : ''}
                                    ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<div class="small">Select display options above to see metrics</div>' : ''}
                                </div>
                            `;
                            break;
                        case 'style4':
                            previewHTML = `
                                <div class="border-2 border-success p-3 rounded">
                                    <div class="row text-center">
                                        ${showScore ? '<div class="col-6"><div class="h6 mb-0 text-success">94</div><small>Score</small></div>' : ''}
                                        ${showLoadTime ? '<div class="col-6"><div class="h6 mb-0">1.1s</div><small>Load</small></div>' : ''}
                                    </div>
                                    ${showPageSize ? '<div class="text-center mt-2"><small>Size: 1.9MB</small></div>' : ''}
                                    ${showRequests ? '<div class="text-center"><small>42 requests</small></div>' : ''}
                                    ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<div class="text-center text-muted"><small>Select display options above to see metrics</small></div>' : ''}
                                </div>
                            `;
                            break;
                        case 'style5':
                            previewHTML = `
                                <div class="bg-warning text-dark p-3 rounded">
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-speedometer2 me-2"></i>
                                        <div>
                                            <div class="fw-bold">Fast Site</div>
                                            ${showLoadTime ? '<small>1.0s load time</small>' : ''}
                                            ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<small class="text-muted">Select display options above</small>' : ''}
                                        </div>
                                    </div>
                                </div>
                            `;
                            break;
                        case 'style6':
                            previewHTML = `
                                <div class="bg-gradient bg-info text-white p-3 rounded text-center">
                                    <i class="bi bi-lightning-charge fs-4"></i>
                                    <div class="small">Optimized Performance</div>
                                    ${showLoadTime ? '<div class="small mt-1">Fast Loading</div>' : ''}
                                    ${!showScore && !showLoadTime && !showPageSize && !showRequests ? '<div class="small mt-1">Select display options above</div>' : ''}
                                </div>
                            `;
                            break;
                    }
                    
                    speedPreviewDiv.innerHTML = `
                        <div class="preview-content">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0">Live Preview</h6>
                                <small class="text-muted">Style: ${selectedStyle.charAt(0).toUpperCase() + selectedStyle.slice(1)}</small>
                            </div>
                            <div class="text-center p-3 bg-white rounded border">${previewHTML}</div>
                            <div class="mt-3 p-2 bg-light rounded">
                                <small class="text-muted d-block text-center">
                                    <i class="bi bi-info-circle me-1"></i>
                                    This preview shows how the speed test results will appear on your product pages
                                </small>
                            </div>
                        </div>
                    `;
                }
                
                // Handle display options changes - now handled by metric badges
                // The updateSpeedTestPreview will be called by initializeMetricBadges when badges are clicked
                
                // Handle Run Speed Test button
                const runTestBtn = document.getElementById('runSpeedTest');
                if (runTestBtn) {
                    runTestBtn.addEventListener('click', function() {
                        const btn = this;
                        const originalHTML = btn.innerHTML;
                        
                        btn.disabled = true;
                        btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i><?php esc_html_e('Running Test...', 'ams-wc-amazon'); ?>';
                        
                        // Make AJAX call to run speed test
                        fetch('<?php echo admin_url("admin-ajax.php"); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                            },
                            body: new URLSearchParams({
                                action: 'ams_run_speed_test',
                                nonce: '<?php echo wp_create_nonce('ams_speed_test_nonce'); ?>',
                                provider: document.getElementById('speed_test_provider')?.value || 'google_pagespeed'
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            btn.disabled = false;
                            btn.innerHTML = originalHTML;
                            
                            if (data.success) {
                                updateSpeedTestPreview();
                                if (typeof showToast === 'function') {
                                    showToast('<?php esc_html_e('Speed test completed successfully!', 'ams-wc-amazon'); ?>', 'success');
                                }
                            } else {
                                if (typeof showToast === 'function') {
                                    showToast(data.data?.message || '<?php esc_html_e('Speed test failed. Please try again.', 'ams-wc-amazon'); ?>', 'error');
                                }
                            }
                        })
                        .catch(error => {
                            btn.disabled = false;
                            btn.innerHTML = originalHTML;
                            console.error('Speed test error:', error);
                            if (typeof showToast === 'function') {
                                showToast('<?php esc_html_e('Network error. Please check your connection.', 'ams-wc-amazon'); ?>', 'error');
                            }
                        });
                    });
                }
                
                // Handle Clear Cache button
                const clearCacheBtn = document.getElementById('clearSpeedCache');
                if (clearCacheBtn) {
                    clearCacheBtn.addEventListener('click', function() {
                        if (confirm('<?php esc_html_e('Are you sure you want to clear the speed test cache?', 'ams-wc-amazon'); ?>')) {
                            const btn = this;
                            const originalHTML = btn.innerHTML;
                            
                            btn.disabled = true;
                            btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i><?php esc_html_e('Clearing...', 'ams-wc-amazon'); ?>';
                            
                            // Make AJAX call to clear cache
                            fetch('<?php echo admin_url("admin-ajax.php"); ?>', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded',
                                },
                                body: new URLSearchParams({
                                    action: 'ams_clear_speed_cache',
                                    nonce: '<?php echo wp_create_nonce('ams_speed_cache_nonce'); ?>'
                                })
                            })
                            .then(response => response.json())
                            .then(data => {
                                btn.disabled = false;
                                btn.innerHTML = originalHTML;
                                
                                if (data.success) {
                                    if (typeof showToast === 'function') {
                                        showToast('<?php esc_html_e('Speed test cache cleared successfully!', 'ams-wc-amazon'); ?>', 'success');
                                    }
                                } else {
                                    if (typeof showToast === 'function') {
                                        showToast(data.data?.message || '<?php esc_html_e('Failed to clear cache.', 'ams-wc-amazon'); ?>', 'error');
                                    }
                                }
                            })
                            .catch(error => {
                                btn.disabled = false;
                                btn.innerHTML = originalHTML;
                                console.error('Clear cache error:', error);
                                if (typeof showToast === 'function') {
                                    showToast('<?php esc_html_e('Network error. Please try again.', 'ams-wc-amazon'); ?>', 'error');
                                }
                            });
                        }
                    });
                }
                
                // Handle Test Preview button - refreshes the live preview with current settings
                const testPreviewBtn = document.getElementById('testPreviewUpdate');
                if (testPreviewBtn) {
                    testPreviewBtn.addEventListener('click', function() {
                        const btn = this;
                        const originalHTML = btn.innerHTML;
                        
                        // Show loading state
                        btn.disabled = true;
                        btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i><?php esc_html_e('Updating...', 'ams-wc-amazon'); ?>';
                        
                        // Simulate a brief delay to show the loading state
                        setTimeout(() => {
                            // Force update preview with current settings
                        updateSpeedTestPreview();
                            
                            // Scroll to preview area so user can see the result
                            const previewDiv = document.getElementById('speedTestPreview');
                            if (previewDiv) {
                                previewDiv.scrollIntoView({ behavior: 'smooth', block: 'center' });
                                
                                // Add a brief highlight effect to draw attention
                                previewDiv.style.boxShadow = '0 0 15px rgba(0, 123, 255, 0.5)';
                                setTimeout(() => {
                                    previewDiv.style.boxShadow = '';
                                }, 2000);
                            }
                            
                            // Restore button
                            btn.disabled = false;
                            btn.innerHTML = originalHTML;
                        
                        if (typeof showToast === 'function') {
                                showToast('<?php esc_html_e('Preview updated! Check the Live Preview section above.', 'ams-wc-amazon'); ?>', 'success');
                        }
                        }, 500);
                    });
                }
                
                // Initialize preview on page load
                updateSpeedTestPreview();
                
                // Mark current selection
                const currentSpeedStyle = speedHiddenInput ? speedHiddenInput.value : 'style1';
                const currentSpeedOption = document.querySelector(`.speed-style-option[data-style="${currentSpeedStyle}"]`);
                if (currentSpeedOption) {
                    currentSpeedOption.classList.add('selected', 'border-primary', 'bg-primary-subtle');
                    const checkIcon = currentSpeedOption.querySelector('.speed-style-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
            }
            
            // Position Badge Selection JavaScript
            function initializePositionBadges() {
                const positionBadges = document.querySelectorAll('.position-badge-option');
                const positionHiddenInput = document.getElementById('display_position');
                
                // Handle position badge selection
                positionBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        // Remove selected class and hide check icons from all badges
                        positionBadges.forEach(opt => {
                            opt.classList.remove('btn-primary');
                            opt.classList.add('btn-outline-secondary');
                            const checkIcon = opt.querySelector('.position-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        // Add selected class and show check icon for clicked badge
                        this.classList.remove('btn-outline-secondary');
                        this.classList.add('btn-primary');
                        const checkIcon = this.querySelector('.position-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        // Update hidden input value
                        const selectedPosition = this.dataset.position;
                        if (positionHiddenInput) {
                            positionHiddenInput.value = selectedPosition;
                        }
                        
                        // Show success message
                        if (typeof showToast === 'function') {
                            const positionName = this.querySelector('h6').textContent;
                            showToast(`Selected position: ${positionName}`, 'success');
                        }
                    });
                    
                    // Keyboard support
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Mark current selection
                const currentPosition = positionHiddenInput ? positionHiddenInput.value : 'footer_left';
                const currentBadge = document.querySelector(`.position-badge-option[data-position="${currentPosition}"]`);
                if (currentBadge) {
                    currentBadge.classList.remove('btn-outline-secondary');
                    currentBadge.classList.add('btn-primary');
                    const checkIcon = currentBadge.querySelector('.position-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
            }
            
            // Initialize cache duration badges
            function initializeCacheDurationBadges() {
                const cacheBadges = document.querySelectorAll('.cache-duration-option');
                const cacheHiddenInput = document.getElementById('cache_duration');
                
                // Handle cache duration badge selection
                cacheBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        // Remove selected class and hide check icons from all badges
                        cacheBadges.forEach(opt => {
                            opt.classList.remove('btn-primary');
                            opt.classList.add('btn-outline-secondary');
                            const checkIcon = opt.querySelector('.cache-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        // Add selected class and show check icon for clicked badge
                        this.classList.remove('btn-outline-secondary');
                        this.classList.add('btn-primary');
                        const checkIcon = this.querySelector('.cache-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        // Update hidden input value
                        const selectedDuration = this.dataset.duration;
                        if (cacheHiddenInput) {
                            cacheHiddenInput.value = selectedDuration;
                        }
                        
                        // Show toast notification
                        if (typeof showToast === 'function') {
                            showToast('Cache duration set to: ' + this.textContent.trim(), 'success');
                        }
                    });
                    
                    // Handle keyboard navigation
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Mark current selection
                const currentDuration = cacheHiddenInput ? cacheHiddenInput.value : '24';
                const currentBadge = document.querySelector(`.cache-duration-option[data-duration="${currentDuration}"]`);
                if (currentBadge) {
                    currentBadge.classList.remove('btn-outline-secondary');
                    currentBadge.classList.add('btn-primary');
                    const checkIcon = currentBadge.querySelector('.cache-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
            }
            
            // Initialize display option badges (mobile and debug)
            function initializeDisplayOptionBadges() {
                // Mobile option
                const mobileOption = document.querySelector('.mobile-option');
                const mobileHiddenInput = document.getElementById('show_on_mobile');
                
                if (mobileOption && mobileHiddenInput) {
                    mobileOption.addEventListener('click', function(e) {
                        const isCurrentlySelected = this.classList.contains('btn-primary');
                        
                        if (isCurrentlySelected) {
                            // Deselect
                            this.classList.remove('btn-primary');
                            this.classList.add('btn-outline-secondary');
                            const checkIcon = this.querySelector('.mobile-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                            mobileHiddenInput.value = '0';
                            
                            if (typeof showToast === 'function') {
                                showToast('Mobile display disabled', 'info');
                            }
                        } else {
                            // Select
                            this.classList.remove('btn-outline-secondary');
                            this.classList.add('btn-primary');
                            const checkIcon = this.querySelector('.mobile-check');
                            if (checkIcon) checkIcon.classList.remove('d-none');
                            mobileHiddenInput.value = '1';
                            
                            if (typeof showToast === 'function') {
                                showToast('Mobile display enabled', 'success');
                            }
                        }
                    });
                    
                    // Set initial state
                    const currentMobile = mobileHiddenInput.value;
                    if (currentMobile === '1') {
                        mobileOption.classList.remove('btn-outline-secondary');
                        mobileOption.classList.add('btn-primary');
                        const checkIcon = mobileOption.querySelector('.mobile-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                    }
                }
                
                // Debug option
                const debugOption = document.querySelector('.debug-option');
                const debugHiddenInput = document.getElementById('speed_test_debug');
                
                if (debugOption && debugHiddenInput) {
                    debugOption.addEventListener('click', function(e) {
                        const isCurrentlySelected = this.classList.contains('btn-primary');
                        
                        if (isCurrentlySelected) {
                            // Deselect
                            this.classList.remove('btn-primary');
                            this.classList.add('btn-outline-secondary');
                            const checkIcon = this.querySelector('.debug-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                            debugHiddenInput.value = '0';
                            
                            if (typeof showToast === 'function') {
                                showToast('Debug mode disabled (admin only)', 'info');
                            }
                        } else {
                            // Select
                            this.classList.remove('btn-outline-secondary');
                            this.classList.add('btn-primary');
                            const checkIcon = this.querySelector('.debug-check');
                            if (checkIcon) checkIcon.classList.remove('d-none');
                            debugHiddenInput.value = '1';
                            
                            if (typeof showToast === 'function') {
                                showToast('Debug mode enabled (public visibility)', 'success');
                            }
                        }
                    });
                    
                    // Set initial state
                    const currentDebug = debugHiddenInput.value;
                    if (currentDebug === '1') {
                        debugOption.classList.remove('btn-outline-secondary');
                        debugOption.classList.add('btn-primary');
                        const checkIcon = debugOption.querySelector('.debug-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                    }
                }
            }
            
            // Initialize visual style badges
            function initializeVisualStyleBadges() {
                const styleBadges = document.querySelectorAll('.visual-style-option');
                const styleHiddenInput = document.getElementById('page_speed_test_style');
                
                // Handle visual style badge selection
                styleBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        // Remove selected class and hide check icons from all badges
                        styleBadges.forEach(opt => {
                            opt.classList.remove('btn-primary');
                            opt.classList.add('btn-outline-secondary');
                            const checkIcon = opt.querySelector('.visual-style-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        // Add selected class and show check icon for clicked badge
                        this.classList.remove('btn-outline-secondary');
                        this.classList.add('btn-primary');
                        const checkIcon = this.querySelector('.visual-style-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        // Update hidden input value
                        const selectedStyle = this.dataset.style;
                        if (styleHiddenInput) {
                            styleHiddenInput.value = selectedStyle;
                        }
                        
                        // Update live preview
                        updateSpeedTestPreview();
                        
                        // Show toast notification
                        if (typeof showToast === 'function') {
                            const styleName = this.querySelector('span').textContent.trim();
                            showToast('Visual style set to: ' + styleName, 'success');
                        }
                    });
                    
                    // Handle keyboard navigation
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Mark current selection
                const currentStyle = styleHiddenInput ? styleHiddenInput.value : 'style1';
                const currentBadge = document.querySelector(`.visual-style-option[data-style="${currentStyle}"]`);
                if (currentBadge) {
                    currentBadge.classList.remove('btn-outline-secondary');
                    currentBadge.classList.add('btn-primary');
                    const checkIcon = currentBadge.querySelector('.visual-style-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
            }
            
            // Initialize provider badges
            function initializeProviderBadges() {
                const providerBadges = document.querySelectorAll('.provider-option');
                const providerHiddenInput = document.getElementById('speed_test_provider');
                
                providerBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        providerBadges.forEach(opt => {
                            opt.classList.remove('btn-primary');
                            opt.classList.add('btn-outline-secondary');
                            const checkIcon = opt.querySelector('.provider-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        this.classList.remove('btn-outline-secondary');
                        this.classList.add('btn-primary');
                        const checkIcon = this.querySelector('.provider-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        const selectedProvider = this.dataset.provider;
                        if (providerHiddenInput) {
                            providerHiddenInput.value = selectedProvider;
                        }
                        
                        // Show/hide appropriate API configuration
                        showApiConfigForProvider(selectedProvider);
                        
                        if (typeof showToast === 'function') {
                            showToast('Provider set to: ' + this.textContent.trim(), 'success');
                        }
                    });
                    
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                const currentProvider = providerHiddenInput ? providerHiddenInput.value : 'google_pagespeed';
                const currentBadge = document.querySelector(`.provider-option[data-provider="${currentProvider}"]`);
                if (currentBadge) {
                    currentBadge.classList.remove('btn-outline-secondary');
                    currentBadge.classList.add('btn-primary');
                    const checkIcon = currentBadge.querySelector('.provider-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
                
                // Show API config for current provider
                showApiConfigForProvider(currentProvider);
            }
            
            // Initialize frequency badges
            function initializeFrequencyBadges() {
                const frequencyBadges = document.querySelectorAll('.frequency-option');
                const frequencyHiddenInput = document.getElementById('test_frequency');
                
                frequencyBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        frequencyBadges.forEach(opt => {
                            opt.classList.remove('btn-primary');
                            opt.classList.add('btn-outline-secondary');
                            const checkIcon = opt.querySelector('.frequency-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                        });
                        
                        this.classList.remove('btn-outline-secondary');
                        this.classList.add('btn-primary');
                        const checkIcon = this.querySelector('.frequency-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                        
                        const selectedFrequency = this.dataset.frequency;
                        if (frequencyHiddenInput) {
                            frequencyHiddenInput.value = selectedFrequency;
                        }
                        
                        if (typeof showToast === 'function') {
                            showToast('Frequency set to: ' + this.textContent.trim(), 'success');
                        }
                    });
                    
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                const currentFrequency = frequencyHiddenInput ? frequencyHiddenInput.value : 'daily';
                const currentBadge = document.querySelector(`.frequency-option[data-frequency="${currentFrequency}"]`);
                if (currentBadge) {
                    currentBadge.classList.remove('btn-outline-secondary');
                    currentBadge.classList.add('btn-primary');
                    const checkIcon = currentBadge.querySelector('.frequency-check');
                    if (checkIcon) checkIcon.classList.remove('d-none');
                }
            }
            
            // Initialize metric badges (multi-select)
            function initializeMetricBadges() {
                const metricBadges = document.querySelectorAll('.metric-option');
                
                metricBadges.forEach(badge => {
                    badge.addEventListener('click', function(e) {
                        const metricName = this.dataset.metric;
                        const hiddenInput = document.getElementById(metricName);
                        const isCurrentlySelected = this.classList.contains('btn-primary');
                        
                        if (isCurrentlySelected) {
                            // Deselect
                            this.classList.remove('btn-primary');
                            this.classList.add('btn-outline-secondary');
                            const checkIcon = this.querySelector('.metric-check');
                            if (checkIcon) checkIcon.classList.add('d-none');
                            if (hiddenInput) hiddenInput.value = '0';
                            
                            if (typeof showToast === 'function') {
                                showToast('Metric disabled: ' + this.textContent.trim(), 'info');
                            }
                        } else {
                            // Select
                            this.classList.remove('btn-outline-secondary');
                            this.classList.add('btn-primary');
                            const checkIcon = this.querySelector('.metric-check');
                            if (checkIcon) checkIcon.classList.remove('d-none');
                            if (hiddenInput) hiddenInput.value = '1';
                            
                            if (typeof showToast === 'function') {
                                showToast('Metric enabled: ' + this.textContent.trim(), 'success');
                            }
                        }
                        
                        // Update preview after metric change
                        updateSpeedTestPreview();
                    });
                    
                    badge.addEventListener('keydown', function(e) {
                        if (e.key === 'Enter' || e.key === ' ') {
                            e.preventDefault();
                            this.click();
                        }
                    });
                });
                
                // Set initial states
                metricBadges.forEach(badge => {
                    const metricName = badge.dataset.metric;
                    const hiddenInput = document.getElementById(metricName);
                    if (hiddenInput && hiddenInput.value === '1') {
                        badge.classList.remove('btn-outline-secondary');
                        badge.classList.add('btn-primary');
                        const checkIcon = badge.querySelector('.metric-check');
                        if (checkIcon) checkIcon.classList.remove('d-none');
                    }
                });
            }
            
            // Show/hide API configuration based on selected provider
            function showApiConfigForProvider(provider) {
                // Hide all API config sections
                document.querySelectorAll('.api-config-section').forEach(section => {
                    section.classList.add('d-none');
                });
                
                // Show the selected provider's API config
                const selectedSection = document.querySelector(`.api-config-section[data-provider="${provider}"]`);
                if (selectedSection) {
                    selectedSection.classList.remove('d-none');
                }
                
                // Update the API section title
                const apiTitle = document.getElementById('apiKeyTitle');
                const providerNames = {
                    'google_pagespeed': 'Google PageSpeed API Configuration',
                    'gtmetrix': 'GTmetrix API Configuration',
                    'pingdom': 'Pingdom API Configuration',
                    'webpagetest': 'WebPageTest API Configuration'
                };
                
                if (apiTitle && providerNames[provider]) {
                    apiTitle.textContent = providerNames[provider];
                }
            }
            
            // Initialize API test buttons
            function initializeApiTestButtons() {
                const testButtons = document.querySelectorAll('.test-api-btn');
                
                testButtons.forEach(button => {
                    button.addEventListener('click', function() {
                        const provider = this.dataset.provider;
                        const apiField = this.dataset.apiField;
                        const apiKeyInput = document.getElementById(apiField);
                        const apiKey = apiKeyInput ? apiKeyInput.value.trim() : '';
                        
                        if (!apiKey) {
                            if (typeof showToast === 'function') {
                                showToast('Please enter an API key first', 'warning');
                            }
                            return;
                        }
                        
                        // Show loading state
                        const originalContent = this.innerHTML;
                        this.disabled = true;
                        this.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Testing...';
                        
                        // Test the API
                        testApiKey(provider, apiKey, this, originalContent);
                    });
                });
            }
            
            // Test API key function
            function testApiKey(provider, apiKey, button, originalContent) {
                const data = new FormData();
                data.append('action', 'ams_test_api_key');
                data.append('provider', provider);
                data.append('api_key', apiKey);
                data.append('nonce', '<?php echo wp_create_nonce("ams_test_api_nonce"); ?>');
                
                fetch('<?php echo admin_url("admin-ajax.php"); ?>', {
                    method: 'POST',
                    body: data
                })
                .then(response => response.json())
                .then(result => {
                    // Restore button
                    button.disabled = false;
                    button.innerHTML = originalContent;
                    
                    // Update status badge
                    const statusBadge = document.querySelector(`.api-status-badge[data-provider="${provider}"]`);
                    
                    if (result.success) {
                        // API key is valid
                        if (statusBadge) {
                            statusBadge.className = 'badge bg-success d-flex align-items-center api-status-badge';
                            statusBadge.textContent = 'Valid';
                        }
                        
                        if (typeof showToast === 'function') {
                            showToast(`${getProviderName(provider)} API key is valid!`, 'success');
                        }
                    } else {
                        // API key is invalid
                        if (statusBadge) {
                            statusBadge.className = 'badge bg-danger d-flex align-items-center api-status-badge';
                            statusBadge.textContent = 'Invalid';
                        }
                        
                        if (typeof showToast === 'function') {
                            showToast(`${getProviderName(provider)} API key is invalid: ${result.data.message || 'Unknown error'}`, 'error');
                        }
                    }
                })
                .catch(error => {
                    // Handle network errors
                    button.disabled = false;
                    button.innerHTML = originalContent;
                    
                    const statusBadge = document.querySelector(`.api-status-badge[data-provider="${provider}"]`);
                    if (statusBadge) {
                        statusBadge.className = 'badge bg-warning d-flex align-items-center api-status-badge';
                        statusBadge.textContent = 'Error';
                    }
                    
                    if (typeof showToast === 'function') {
                        showToast('Network error while testing API key', 'error');
                    }
                });
            }
            
            // Get provider display name
            function getProviderName(provider) {
                const names = {
                    'google_pagespeed': 'Google PageSpeed',
                    'gtmetrix': 'GTmetrix',
                    'pingdom': 'Pingdom',
                    'webpagetest': 'WebPageTest'
                };
                return names[provider] || provider;
            }
            
            // Initialize speed test settings when page loads
            document.addEventListener('DOMContentLoaded', function() {
                initializeSpeedTestSettings();
                initializePositionBadges();
                initializeCacheDurationBadges();
                initializeDisplayOptionBadges();
                initializeVisualStyleBadges();
                initializeProviderBadges();
                initializeFrequencyBadges();
                initializeMetricBadges();
                initializeApiTestButtons();
            });
            </script>

             <!-- Unlinked Variants Cleanup js -->
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                $('#delete-unlinked-variants').on('click', function (e) {
                    e.preventDefault();
                    var $button = $(this);
                    var $spinner = $button.find('.spinner-border');
                    var $buttonText = $button.find('.button-text');

                    if (confirm('<?php esc_html_e('Are you sure you want to clean up all unlinked variants?', 'ams-wc-amazon'); ?>')) {
                        // Disable button and show spinner
                        $button.prop('disabled', true);
                        $spinner.removeClass('d-none');
                        $buttonText.text('<?php esc_html_e('Cleaning...', 'ams-wc-amazon'); ?>');

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'delete_unlinked_variants_cleanup'
                            },
                            success: function (response) {
                                $button.prop('disabled', false);
                                $spinner.addClass('d-none');
                                $buttonText.text('<?php esc_html_e('Clean Up Unlinked Variants', 'ams-wc-amazon'); ?>');
                                if (response.success) {
                                    if (typeof showToast === 'function') {
                                        showToast('<?php esc_html_e('Unlinked variants cleaned up successfully!', 'ams-wc-amazon'); ?> - <?php esc_html_e('SKUs deleted: ', 'ams-wc-amazon'); ?>' + response.data.deleted_count, 'success');
                                    }
                                    location.reload();
                                } else {
                                    if (typeof showToast === 'function') {
                                        showToast('<?php esc_html_e('There was an error cleaning up unlinked variants.', 'ams-wc-amazon'); ?>', 'error');
                                    }
                                }
                            },
                            error: function () {
                                $button.prop('disabled', false);
                                $spinner.addClass('d-none');
                                $buttonText.text('<?php esc_html_e('Clean Up Unlinked Variants', 'ams-wc-amazon'); ?>');

                                if (typeof showToast === 'function') {
                                    showToast('<?php esc_html_e('There was an issue with the request.', 'ams-wc-amazon'); ?>', 'error');
                                }
                            }
                        });
                    }
                });
            });
            </script>
             <!-- Unlinked Variants Cleanup js -->


            <!-- AMSWOO Data Cleanup section -->
            <script type="text/javascript">
            var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
                jQuery(document).ready(function($) {
                    $('#delete-amswoofiu-data').on('click', function(e) {
                        e.preventDefault();
                        var $button = $(this);
                        var $spinner = $button.find('.spinner-border');
                        var $buttonText = $button.find('.button-text');

                        if (confirm('<?php esc_html_e('Are you sure you want to delete all AMSWOO data?', 'ams-wc-amazon'); ?>')) {
                            // Disable button and show spinner
                            $button.prop('disabled', true);
                            $spinner.removeClass('d-none');
                            $buttonText.text('<?php esc_html_e('Deleting...', 'ams-wc-amazon'); ?>');

                            $.ajax({
                                url: ajaxurl,
                                type: 'POST',
                                data: {
                                    action: 'delete_amswoofiu_data_cleanup'
                                },
                                success: function(response) {
                                    $button.prop('disabled', false);
                                    $spinner.addClass('d-none');
                                    $buttonText.text('<?php esc_html_e('Delete AMSWOO Data', 'ams-wc-amazon'); ?>');
                                    if (response.success) {
                                        var urls_deleted = response.data.urls_deleted;
                                        var images_deleted = response.data.images_deleted;
                                        if (typeof showToast === 'function') {
                                            showToast('<?php esc_html_e('AMSWOO data deleted successfully!', 'ams-wc-amazon'); ?> - <?php esc_html_e('URLs deleted: ', 'ams-wc-amazon'); ?>' + urls_deleted + ', <?php esc_html_e('Images deleted: ', 'ams-wc-amazon'); ?>' + images_deleted, 'success');
                                        }
                                        location.reload();
                                    } else {
                                        if (typeof showToast === 'function') {
                                            showToast('<?php esc_html_e('There was an error deleting AMSWOO data.', 'ams-wc-amazon'); ?>', 'error');
                                        }
                                    }
                                },
                                error: function() {
                                    // Re-enable button and hide spinner on error
                                    $button.prop('disabled', false);
                                    $spinner.addClass('d-none');
                                    $buttonText.text('<?php esc_html_e('Delete AMSWOO Data', 'ams-wc-amazon'); ?>');

                                    if (typeof showToast === 'function') {
                                        showToast('<?php esc_html_e('There was an issue with the request.', 'ams-wc-amazon'); ?>', 'error');
                                    }
                                }
                            });
                        }
                    });
                });
            </script>
            <!-- AMSWOO Data Cleanup section -->


            <!--WooCommerce Shortcode Settings-->
            <div class="card shadow-lg rounded-lg mb-4" id="shortcode-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0 fw-bold">
                        <i class="bi bi-code me-2"></i>
                        <?php esc_html_e('WooCommerce Shortcode Settings', 'ams-wc-amazon'); ?>
                    </h4>
                </div>
                <div class="card-body p-4">

                    <!-- Shortcode Examples Section -->
                    <div class="mb-4 p-3 bg-white border rounded shadow-sm">
                        <h3 class="fw-bold text-info"><?php esc_html_e('How to Use Shortcodes', 'ams-wc-amazon'); ?></h3>
                        <p class="text-muted">
                            <?php esc_html_e('Use the following shortcodes to display WooCommerce products on your WordPress posts or pages:', 'ams-wc-amazon'); ?>
                        </p>
                        <div class="bg-dark text-white p-3 mb-3 rounded shadow-sm">
                            <strong>[ams_display_products ids="123" layout="single"]</strong>
                            <p class="mb-0 text-light">
                                <?php esc_html_e('Displays a single product. Replace 123 with the product ID.', 'ams-wc-amazon'); ?>
                            </p>
                        </div>
                        <div class="bg-dark text-white p-3 rounded shadow-sm">
                            <strong>[ams_display_products ids="123,456,789" columns="3" layout="grid"]</strong>
                            <p class="mb-0 text-light">
                                <?php esc_html_e('Displays multiple products in a grid layout. Replace 123, 456, 789 with your product IDs.', 'ams-wc-amazon'); ?>
                            </p>
                        </div>

                        <!-- Auto Create Shortcode Pages/Posts Section -->
                        <div class="mt-4 p-3 bg-white border rounded shadow-sm">
                            <h3 class="fw-bold text-info"><?php esc_html_e('Auto Create Shortcode Pages/Posts', 'ams-wc-amazon'); ?></h3>
                            <p class="text-muted">
                                <?php esc_html_e('Automatically create pages or posts for the shortcode examples.', 'ams-wc-amazon'); ?>
                            </p>

                            <!-- Page/Post Selector -->
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="create_type" id="create_page" value="page" checked>
                                <label class="form-check-label" for="create_page"><?php esc_html_e('Page', 'ams-wc-amazon'); ?></label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="create_type" id="create_post" value="post">
                                <label class="form-check-label" for="create_post"><?php esc_html_e('Post', 'ams-wc-amazon'); ?></label>
                            </div>

                            <!-- Create and Delete Buttons -->
                            <div class="mt-3">
                                <button type="button" class="btn btn-primary" id="autoCreatePagesButton">
                                    <i class="bi bi-plus me-2"></i><?php esc_html_e('Create Pages/Posts', 'ams-wc-amazon'); ?>
                                </button>
                                <button type="button" class="btn btn-danger ms-2" id="deletePagesButton">
                                    <i class="bi bi-trash me-2"></i><?php esc_html_e('Delete Pages/Posts', 'ams-wc-amazon'); ?>
                                </button>
                            </div>

                            <!-- Success/Failure Messages -->
                            <div id="autoCreateMessage" class="mt-3"></div>
                        </div>
                    </div>


                    <!-- Finding Product IDs Section -->
                    <div class="mb-4 p-3 bg-white border rounded shadow-sm">
                        <h3 class="fw-bold text-info"><?php esc_html_e('Finding Product IDs', 'ams-wc-amazon'); ?></h3>
                        <p class="text-muted mb-2">
                            <?php esc_html_e('You can find product IDs in the WooCommerce Products page of your WordPress admin dashboard.', 'ams-wc-amazon'); ?>
                        </p>
                        <ul class="list-group">
                            <li class="list-group-item">
                                <?php esc_html_e('1. Navigate to the "Products" section in the WordPress admin dashboard.', 'ams-wc-amazon'); ?>
                            </li>
                            <li class="list-group-item">
                                <?php esc_html_e('2. Hover over the product name to see its ID appear beneath the name.', 'ams-wc-amazon'); ?>
                            </li>
                        </ul>
                    </div>

                    <!-- Display Settings Section -->
                    <div class="mb-4 p-3 bg-white border rounded shadow-sm">
                        <h3 class="fw-bold text-info"><?php esc_html_e('Display Settings', 'ams-wc-amazon'); ?></h3>

                        <!-- Enable/Disable Legal Notice -->
                        <div class="d-flex align-items-center mb-3">
                            <label for="enable_legal_notice" class="form-label me-3 fw-bold text-dark">
                                <?php esc_html_e('Enable Legal Notice', 'ams-wc-amazon'); ?>
                            </label>
                            <label class="ams-common-toggle-switch">
                                <input type="checkbox" id="enable_legal_notice" 
                                       name="enable_legal_notice" value="1" 
                                       <?php checked(get_option('enable_legal_notice'), '1'); ?>>
                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                            </label>
                        </div>

                        <!-- Editable Legal Notice -->
                        <div class="mb-4">
                            <label for="legal_notice_text" class="form-label fw-bold text-dark">
                                <?php esc_html_e('Legal Notice Text', 'ams-wc-amazon'); ?>
                            </label>
                            <textarea id="legal_notice_text" 
                                      name="legal_notice_text" 
                                      class="form-control rounded" 
                                      rows="2"><?php 
                                          echo esc_html(get_option('legal_notice_text', 'Affiliate Products | Advertisement | Sponsored')); 
                                      ?></textarea>
                            <p class="text-muted mt-1">
                                <?php esc_html_e('Customize the legal notice text displayed above the products.', 'ams-wc-amazon'); ?>
                            </p>
                        </div>

                        <!-- Enable/Disable Per-Product Last Updated Message -->
                        <div class="d-flex align-items-center mb-3">
                            <label for="enable_product_last_updated" class="form-label me-3 fw-bold text-dark">
                                <?php esc_html_e('Enable Per-Product Last Updated Message', 'ams-wc-amazon'); ?>
                            </label>
                            <label class="ams-common-toggle-switch">
                                <input type="checkbox" id="enable_product_last_updated" 
                                       name="enable_product_last_updated" value="1" 
                                       <?php checked(get_option('enable_product_last_updated'), '1'); ?>>
                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                            </label>
                        </div>

                        <!-- Editable Message for Per-Product Last Updated -->
                        <div class="mb-4">
                            <label for="product_last_updated_message" class="form-label fw-bold text-dark">
                                <?php esc_html_e('Per-Product Last Updated Message', 'ams-wc-amazon'); ?>
                            </label>
                            <textarea id="product_last_updated_message" 
                                      name="product_last_updated_message" 
                                      class="form-control rounded" 
                                      rows="2"><?php 
                                          echo esc_html(get_option('product_last_updated_message', 'Last updated: {date}')); 
                                      ?></textarea>
                            <p class="text-muted mt-1">
                                <?php esc_html_e('Use {date} as a placeholder for the date and time.', 'ams-wc-amazon'); ?>
                            </p>
                        </div>

                        <!-- Enable/Disable Global Last Updated Message -->
                        <div class="d-flex align-items-center mb-3">
                            <label for="enable_global_last_updated" class="form-label me-3 fw-bold text-dark">
                                <?php esc_html_e('Enable Global Last Updated Message', 'ams-wc-amazon'); ?>
                            </label>
                            <label class="ams-common-toggle-switch">
                                <input type="checkbox" id="enable_global_last_updated" 
                                       name="enable_global_last_updated" value="1" 
                                       <?php checked(get_option('enable_global_last_updated'), '1'); ?>>
                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                            </label>
                        </div>

                        <!-- Editable Global Last Updated Message -->
                        <div class="mb-4">
                            <label for="global_last_updated_message" class="form-label fw-bold text-dark">
                                <?php esc_html_e('Global Last Updated Message', 'ams-wc-amazon'); ?>
                            </label>
                            <textarea id="global_last_updated_message" 
                                      name="global_last_updated_message" 
                                      class="form-control rounded" 
                                      rows="2"><?php 
                                          echo esc_html(get_option('global_last_updated_message', 'Last updated on {date}.')); 
                                      ?></textarea>
                            <p class="text-muted mt-1">
                                <?php esc_html_e('Use {date} as a placeholder for the date and time.', 'ams-wc-amazon'); ?>
                            </p>
                        </div>

                        <!-- Enable/Disable Custom Notification -->
                        <div class="d-flex align-items-center mb-3">
                            <label for="enable_custom_notification" class="form-label me-3 fw-bold text-dark">
                                <?php esc_html_e('Enable Custom Notification', 'ams-wc-amazon'); ?>
                            </label>
                            <label class="ams-common-toggle-switch">
                                <input type="checkbox" id="enable_custom_notification" 
                                       name="enable_custom_notification" value="1" 
                                       <?php checked(get_option('enable_custom_notification'), '1'); ?>>
                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                            </label>
                        </div>

                        <!-- Editable Custom Notification Message -->
                        <div class="mb-4">
                            <label for="custom_notification_message" class="form-label fw-bold text-dark">
                                <?php esc_html_e('Custom Notification Message', 'ams-wc-amazon'); ?>
                            </label>
                            <textarea id="custom_notification_message" 
                                      name="custom_notification_message" 
                                      class="form-control rounded" 
                                      rows="3"><?php 
                                          echo esc_html(get_option('custom_notification_message', 'Please note: Product details may change.')); 
                                      ?></textarea>
                        </div>

                        <!-- Alignment Options -->
                        <div class="mb-4">
                            <label for="message_alignment" class="form-label fw-bold text-dark">
                                <?php esc_html_e('Message Alignment', 'ams-wc-amazon'); ?>
                            </label>
                            <select id="message_alignment" 
                                    name="message_alignment" 
                                    class="form-select rounded">
                                <option value="left" <?php selected(get_option('message_alignment'), 'left'); ?>>
                                    <?php esc_html_e('Left', 'ams-wc-amazon'); ?>
                                </option>
                                <option value="right" <?php selected(get_option('message_alignment'), 'right'); ?>>
                                    <?php esc_html_e('Right', 'ams-wc-amazon'); ?>
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <script>
                document.getElementById('autoCreatePagesButton').addEventListener('click', () => {
                    const createType = document.querySelector('input[name="create_type"]:checked').value;
                    const nonce = '<?php echo wp_create_nonce('auto_create_pages_nonce'); ?>';

                    fetch(ajaxurl, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: `action=auto_create_pages&type=${createType}&_ajax_nonce=${nonce}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        const message = document.getElementById('autoCreateMessage');
                        if (data.success) {
                            message.innerHTML = `<div class="alert alert-success">
                                <strong><?php esc_html_e('Success:', 'ams-wc-amazon'); ?></strong> 
                                <?php esc_html_e('Pages/Posts created successfully!', 'ams-wc-amazon'); ?>
                            </div>`;
                        } else {
                            message.innerHTML = `<div class="alert alert-danger">
                                <strong><?php esc_html_e('Error:', 'ams-wc-amazon'); ?></strong> 
                                ${data.data.message}
                            </div>`;
                        }
                    });
                });

                document.getElementById('deletePagesButton').addEventListener('click', () => {
                    const nonce = '<?php echo wp_create_nonce('delete_pages_nonce'); ?>';

                    fetch(ajaxurl, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: `action=delete_existing_pages&_ajax_nonce=${nonce}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        const message = document.getElementById('autoCreateMessage');
                        if (data.success) {
                            message.innerHTML = `<div class="alert alert-success">
                                <strong><?php esc_html_e('Success:', 'ams-wc-amazon'); ?></strong> 
                                <?php esc_html_e('Pages/Posts deleted successfully!', 'ams-wc-amazon'); ?>
                            </div>`;
                        } else {
                            message.innerHTML = `<div class="alert alert-danger">
                                <strong><?php esc_html_e('Error:', 'ams-wc-amazon'); ?></strong> 
                                ${data.data.message}
                            </div>`;
                        }
                    });
                });
            </script>
            <!--WooCommerce Shortcode Settings-->


            <!--Custom Theme Hook Settings-->
            <div class="card shadow-sm mb-4 ams-common-card-fix" id="custom-theme-hook-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php esc_html_e('Custom Theme Hook Settings', 'ams-wc-amazon'); ?></h4>
                </div>
                <div class="card-body">
                    <!-- Enable Custom Theme Hook Toggle -->
                    <div class="mb-4">
                        <div class="d-flex align-items-center">
                            <label class="form-label mb-0"><?php esc_html_e('Enable Custom Theme Hook', 'ams-wc-amazon'); ?></label>
                            <div class="ms-3">
                                <label class="ams-common-toggle-switch">
                                    <input type="checkbox" 
                                           id="use_custom_button" 
                                           name="use_custom_button" 
                                           value="1" 
                                           <?php checked(get_option('ams_use_custom_button', '0'), '1'); ?>>
                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Theme Status -->
                    <div class="mb-4">
                        <?php 
                        $current_theme = wp_get_theme();
                        $theme_name = $current_theme->get('Name');
                        $use_custom_button = get_option('ams_use_custom_button', '0');
                        $current_hook = get_option('ams_theme_hook', '');
                        
                        // Simple universal approach - works with all themes
                        $auto_detected_hook = 'Universal WooCommerce Filter (woocommerce_loop_add_to_cart_link)';
                        $detection_method = 'Universal Compatibility';
                        ?>
                        <div class="alert alert-info" role="alert">
                            <i class="bi bi-info-circle-fill me-2"></i>
                            <strong><?php esc_html_e('Current Theme:', 'ams-wc-amazon'); ?></strong>
                            <?php echo esc_html($theme_name); ?>
                            <br>
                            <small class="text-muted">
                                <?php if ($use_custom_button === '1'): ?>
                                    <span class="text-success"><?php esc_html_e('Status: Active', 'ams-wc-amazon'); ?></span>
                                    <br>
                                    <strong><?php esc_html_e('Auto-detected hook:', 'ams-wc-amazon'); ?></strong> 
                                    <code><?php echo esc_html($auto_detected_hook); ?></code>
                                    <?php if (!empty($current_hook) && $current_hook !== $auto_detected_hook): ?>
                                        <br><strong><?php esc_html_e('Currently using:', 'ams-wc-amazon'); ?></strong> 
                                        <code class="text-primary"><?php echo esc_html($current_hook); ?></code>
                                        <small class="text-muted">(<?php esc_html_e('manual override', 'ams-wc-amazon'); ?>)</small>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted"><?php esc_html_e('Status: Disabled', 'ams-wc-amazon'); ?></span>
                                <?php endif; ?>
                            </small>
                        </div>
                    </div>

                    <!-- Manual Theme Hook Input -->
                    <div class="mb-4">
                        <label for="theme_hook" class="form-label"><?php esc_html_e('Custom Theme Hook (Optional)', 'ams-wc-amazon'); ?></label>
                            <input type="text" 
                                   class="form-control" 
                                   id="theme_hook" 
                                   name="theme_hook" 
                                   value="<?php echo esc_attr(get_option('ams_theme_hook', '')); ?>"
                               placeholder="e.g., woocommerce_after_shop_loop_item">
                        <div class="form-text">
                            <?php esc_html_e('Leave empty for automatic detection. Only add if you need a specific hook for your theme.', 'ams-wc-amazon'); ?>
                        </div>
                    </div>

                    <!-- Simple Information -->
                    <div class="alert alert-info mb-0" role="alert">
                        <i class="bi bi-info-circle-fill me-2"></i>
                        <strong><?php esc_html_e('How it works:', 'ams-wc-amazon'); ?></strong>
                        <ul class="mt-2 mb-0">
                            <li><?php esc_html_e('Automatically detects your theme and finds the best button placement', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Works with all popular WooCommerce themes', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('No manual configuration needed - just toggle on/off', 'ams-wc-amazon'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>

            <!--Buy now button section-->
            <div class="card shadow-sm mb-4 ams-common-card-fix" id="buy-now-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php esc_html_e('Buy Now Button Action', 'ams-wc-amazon'); ?></h4>
                </div>
                <div class="card-body">

                <!-- Buy Now Label -->
                <div class="mb-4">
                    <label for="buy_now_label" class="form-label"><?php esc_html_e('Buy Now Label', 'ams-wc-amazon'); ?></label>
                    <input type="text" class="form-control" id="buy_now_label" name="buy_now_label" placeholder="Buy on Amazon" value="<?php echo esc_attr($this->get_option('ams_buy_now_label')); ?>">
                </div>
                    <div class="mb-4">
                        <?php
                        $options = [
                            'redirect' => [
                                'title' => __('Direct Amazon Details Page', 'ams-wc-amazon'),
                                'description' => __('For Affiliate 24 hour cookie', 'ams-wc-amazon'),
                                'icon' => 'bi-box-arrow-up-right'
                            ],
                            'cart_page' => [
                                'title' => __('Direct Amazon Cart Page', 'ams-wc-amazon'),
                                'description' => __('For Affiliate 90 day cookie', 'ams-wc-amazon'),
                                'icon' => 'bi-cart'
                            ],
                            'multi_cart' => [
                                'title' => __('Site Cart Then Amazon', 'ams-wc-amazon'),
                                'description' => __('Add to site cart, redirect to Amazon on checkout', 'ams-wc-amazon'),
                                'icon' => 'bi-arrow-left-right',
                                'warning' => __('To use for multi countries you need to choose either the "Direct Amazon Details Page" or "Direct Amazon Cart Page"', 'ams-wc-amazon')
                            ],
                            'dropship' => [
                                'title' => __('Dropship', 'ams-wc-amazon'),
                                'description' => __('Add to site with DropShip fee, checkout on your site', 'ams-wc-amazon'),
                                'icon' => 'bi-shop'
                            ]
                        ];

                        foreach ($options as $value => $option) :
                            $isChecked = checked($this->get_option('ams_buy_action_btn'), $value, false);
                        ?>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="radio" name="buy_action_btn" id="<?php echo esc_attr($value); ?>" value="<?php echo esc_attr($value); ?>" <?php echo $isChecked; ?>>
                                <label class="form-check-label" for="<?php echo esc_attr($value); ?>">
                                    <i class="bi <?php echo esc_attr($option['icon']); ?> me-2"></i>
                                    <?php echo esc_html($option['title']); ?>
                                    <small class="d-block text-muted mt-1"><?php echo esc_html($option['description']); ?></small>
                                </label>
                                <?php if (isset($option['warning'])) : ?>
                                    <div class="ams-warning mt-2 small text-warning <?php echo $isChecked ? '' : 'd-none'; ?>">
                                        <?php echo esc_html($option['warning']); ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Checkout Settings placed exactly under multi_cart option -->
                                <?php if ($value === 'multi_cart'): ?>
                                    <div id="checkout_settings" class="card shadow-sm mb-4 mt-3 <?php echo $this->get_option('ams_buy_action_btn') != 'multi_cart' ? 'd-none' : ''; ?>">
                                        <div class="card-header bg-primary text-white">
                                            <h5 class="mb-0"><?php esc_html_e('Site Cart & Redirect Amazon - Settings', 'ams-wc-amazon'); ?></h5>
                                        </div>
                                        <div class="card-body">
                                            <!-- Checkout Message -->
                                            <div class="mb-3">
                                                <label for="checkout_mass_redirected" class="form-label"><?php esc_html_e('Checkout Message', 'ams-wc-amazon'); ?></label>
                                                <textarea 
                                                    class="form-control" 
                                                    id="checkout_mass_redirected" 
                                                    name="checkout_mass_redirected" 
                                                    rows="3"><?php echo esc_textarea(get_option('ams_checkout_mass_redirected')); ?></textarea>
                                                <small class="form-text text-muted">
                                                    <?php esc_html_e('Message displayed to users while redirecting to Amazon.', 'ams-wc-amazon'); ?>
                                                </small>
                                            </div>

                                            <!-- Checkout Redirect Timer -->
                                            <div class="mb-3">
                                                <label for="checkout_redirected_seconds" class="form-label"><?php esc_html_e('Checkout Redirect Time (seconds)', 'ams-wc-amazon'); ?></label>
                                                <div class="input-group">
                                                    <input 
                                                        type="number" 
                                                        class="form-control" 
                                                        id="checkout_redirected_seconds" 
                                                        name="checkout_redirected_seconds"  
                                                        value="<?php echo esc_attr(get_option('ams_checkout_redirected_seconds')); ?>"
                                                    >
                                                    <span class="input-group-text"><?php esc_html_e('seconds', 'ams-wc-amazon'); ?></span>
                                                </div>
                                                <small class="form-text text-muted">
                                                    <?php esc_html_e('Specify how many seconds to wait before redirecting to Amazon.', 'ams-wc-amazon'); ?>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>

                        <!-- Dropship Percentage (Displayed only when 'dropship' is selected) -->
                        <div id="dropshipPercentage" class="card shadow-sm mb-4 <?php echo $this->get_option('ams_buy_action_btn') != 'dropship' ? 'd-none' : ''; ?>">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0"><?php esc_html_e('Dropship Settings', 'ams-wc-amazon'); ?></h5>
                            </div>
                            <div class="card-body">
                                <label for="percentage_profit" class="form-label"><?php esc_html_e('Custom Tax (% Percentage)', 'ams-wc-amazon'); ?></label>
                                <div class="input-group mb-2">
                                    <input type="text" class="form-control" id="percentage_profit" name="percentage_profit" value="<?php echo esc_attr(get_option('ams_percentage_profit')); ?>">
                                    <span class="input-group-text">%</span>
                                </div>
                                <small class="form-text text-muted">
                                    <?php esc_html_e('Percentage added to the price as profit amount for single product', 'ams-wc-amazon'); ?>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const buyActionBtns = document.querySelectorAll('input[name="buy_action_btn"]');
                    const dropshipPercentage = document.getElementById('dropshipPercentage');
                    const warnings = document.querySelectorAll('.ams-warning');
                    const checkoutSettings = document.getElementById('checkout_settings');

                    buyActionBtns.forEach(function(btn) {
                        btn.addEventListener('change', function() {
                            // Handle dropshipPercentage visibility
                            if (dropshipPercentage) {
                                dropshipPercentage.classList.toggle('d-none', this.value !== 'dropship');
                            }

                            // Handle warnings visibility
                            warnings.forEach(warning => warning.classList.add('d-none'));
                            const selectedWarning = this.parentElement.querySelector('.ams-warning');
                            if (selectedWarning) selectedWarning.classList.remove('d-none');

                            // Handle Checkout Settings visibility
                            if (checkoutSettings) {
                                checkoutSettings.classList.toggle('d-none', this.value !== 'multi_cart');
                            }
                        });
                    });
                });
            </script>
            <!--Buy now button section-->


            <!-- Images Section -->
            <div class="card shadow-sm mb-4 ams-common-card-fix" id="image-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php esc_html_e('Amazon Product Image Settings', 'ams-wc-amazon'); ?></h4>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <!-- Remote Amazon Images -->
                        <div class="col-md-6">
                            <label for="remote_amazon_images" class="form-label"><?php esc_html_e('Remote Amazon Images', 'ams-wc-amazon'); ?></label>
                            <select id="remote_amazon_images" name="remote_amazon_images" class="form-select">
                                <option value="Yes" <?php selected($this->get_option('ams_remote_amazon_images'), 'Yes', true); ?>><?php esc_html_e('Yes', 'ams-wc-amazon'); ?></option>
                                <option value="No" <?php selected($this->get_option('ams_remote_amazon_images'), 'No', true); ?>><?php esc_html_e('No', 'ams-wc-amazon'); ?></option>
                            </select>
                        </div>

                        <!-- Remote Image Sizes -->
                        <div class="col-md-6">
                            <label for="product_thumbnail_size" class="form-label"><?php esc_html_e('Select Remote Image Sizes', 'ams-wc-amazon'); ?></label>
                            <select id="product_thumbnail_size" name="product_thumbnail_size" class="form-select">
                                <option value="hd" <?php selected($this->get_option('ams_product_thumbnail_size'), 'hd', true); ?>><?php esc_html_e('HD (2048 X 2048)', 'ams-wc-amazon'); ?></option>
                                <option value="extra_large" <?php selected($this->get_option('ams_product_thumbnail_size'), 'extra_large', true); ?>><?php esc_html_e('Extra Large (1024 X 1024)', 'ams-wc-amazon'); ?></option>
                                <option value="Large" <?php selected($this->get_option('ams_product_thumbnail_size'), 'Large', true); ?>><?php esc_html_e('Large (500 X 500)', 'ams-wc-amazon'); ?></option>
                                <option value="Medium" <?php selected($this->get_option('ams_product_thumbnail_size'), 'Medium', true); ?>><?php esc_html_e('Medium (160 X 160)', 'ams-wc-amazon'); ?></option>
                                <option value="Small" <?php selected($this->get_option('ams_product_thumbnail_size'), 'Small', true); ?>><?php esc_html_e('Small (75 X 75)', 'ams-wc-amazon'); ?></option>
                            </select>
                        </div>

                        <!-- Variation Image Limit -->
                        <div class="col-md-6">
                            <label for="variation_image_limit" class="form-label"><?php esc_html_e('Variation Image Limit', 'ams-wc-amazon'); ?></label>
                            <div class="input-group">
                                <input type="number" id="variation_image_limit" name="variation_image_limit" class="form-control" 
                                       value="<?php echo esc_attr(get_option('ams_variation_image_limit', 5)); ?>" min="1" max="10">
                                <span class="input-group-text"><?php esc_html_e('Images', 'ams-wc-amazon'); ?></span>
                            </div>
                            <div class="form-text"><?php esc_html_e('Set a value between 1 and 10 images.', 'ams-wc-amazon'); ?></div>
                        </div>

                        <!-- Image Fit Option -->
                        <div class="col-md-6">
                            <label for="ams_image_fit" class="form-label"><?php esc_html_e('Product Image Fit', 'ams-wc-amazon'); ?></label>
                            <select id="ams_image_fit" name="ams_image_fit" class="form-select">
                                <option value="cover" <?php selected($this->get_option('ams_image_fit'), 'cover', true); ?>><?php esc_html_e('Cover (Recommended) - Crops the image to fill the container.', 'ams-wc-amazon'); ?></option>
                                <option value="contain" <?php selected($this->get_option('ams_image_fit'), 'contain', true); ?>><?php esc_html_e('Contain - Fits the entire image inside the container, no cropping.', 'ams-wc-amazon'); ?></option>
                                <option value="fill" <?php selected($this->get_option('ams_image_fit'), 'fill', true); ?>><?php esc_html_e('Fill - Stretches the image to fill the container, may distort.', 'ams-wc-amazon'); ?></option>
                                <option value="none" <?php selected($this->get_option('ams_image_fit'), 'none', true); ?>><?php esc_html_e('None - Displays the image at its original size.', 'ams-wc-amazon'); ?></option>
                                <option value="scale-down" <?php selected($this->get_option('ams_image_fit'), 'scale-down', true); ?>><?php esc_html_e('Scale Down - Displays the image at its original size or smaller if necessary.', 'ams-wc-amazon'); ?></option>
                            </select>
                            <div class="form-text"><?php esc_html_e('Choose how product images will fit inside containers.', 'ams-wc-amazon'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End of Images Section -->

            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    $('#ams_image_fit').on('change', function() {
                        var imageFitValue = $(this).val();

                        // AJAX call to save the selected option
                        $.ajax({
                            url: ajaxurl, // WordPress's built-in AJAX handler URL
                            type: 'POST',
                            data: {
                                action: 'ams_save_image_fit', // Custom action hook
                                image_fit: imageFitValue,     // Send the selected value
                                _wpnonce: '<?php echo wp_create_nonce("ams_image_fit_nonce"); ?>' // Security nonce
                            },
                            success: function(response) {
                                if (response.success) {
                                    console.log('Image Fit option saved: ' + imageFitValue); // Success log
                                } else {
                                    console.error('Error saving Image Fit option.');
                                }
                            },
                            error: function() {
                                console.error('AJAX error while saving Image Fit option.');
                            }
                        });
                    });
                });
            </script>






            <!--Proxy section-->
            <div class="card shadow-sm mb-4 ams-common-card-fix" id="proxy-settings">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php esc_html_e('Proxy Service Configuration', 'ams-wc-amazon'); ?></h4>
                    <small class="text-light opacity-75">
                        <i class="bi bi-info-circle me-1"></i>
                        <?php esc_html_e('Configure scraping services and their priority order. Lower priority numbers are tried first.', 'ams-wc-amazon'); ?>
                    </small>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <!-- ScraperAPI Section -->
                        <div class="col-lg-4">
                            <div class="card h-100 shadow-sm">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0 text-white">ScraperAPI</h5>
                                    <small>High-speed Amazon product import and updates</small>
                                </div>
                                <div class="card-body">
                                    <?php
                                    $is_scraper_active = ($this->get_option('ams_scraper_api_is_active') == '1' || $this->get_option('ams_scraper_api_on_update') == '1');
                                    $scraper_status_class = $is_scraper_active ? 'bg-success' : 'bg-danger';
                                    $scraper_status_text = $is_scraper_active ? __('Active', 'ams-wc-amazon') : __('Inactive', 'ams-wc-amazon');
                                    ?>
                                    <div class="mb-3 text-end">
                                        <span class="badge <?php echo $scraper_status_class; ?> px-3 py-2">
                                            <?php echo $scraper_status_text; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Priority Setting -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0">
                                                <i class="bi bi-sort-numeric-down me-1"></i>
                                                <?php esc_html_e('Priority Order', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <select name="scraperapi_priority" class="form-select form-select-sm" style="width: auto;">
                                                <option value="1" <?php selected(get_option('ams_scraperapi_priority', 1), '1'); ?>>1 - <?php esc_html_e('First', 'ams-wc-amazon'); ?></option>
                                                <option value="2" <?php selected(get_option('ams_scraperapi_priority', 1), '2'); ?>>2 - <?php esc_html_e('Second', 'ams-wc-amazon'); ?></option>
                                                <option value="3" <?php selected(get_option('ams_scraperapi_priority', 1), '3'); ?>>3 - <?php esc_html_e('Third', 'ams-wc-amazon'); ?></option>
                                            </select>
                                        </div>
                                        <small class="text-muted"><?php esc_html_e('Lower numbers have higher priority', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="scraper_api_is_active" value="1" <?php checked($this->get_option('ams_scraper_api_is_active'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Update Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="scraper_api_on_update" value="1" <?php checked($this->get_option('ams_scraper_api_on_update'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <h6 class="mb-2"><?php esc_html_e('ScraperAPI Key', 'ams-wc-amazon'); ?></h6>
                                        <div class="input-group">
                                            <input type="text" id="scraper_api_key" name="scraper_api_key" class="form-control" value="<?php echo esc_attr($this->get_option('ams_scraper_api_key')); ?>" placeholder="<?php esc_html_e('Enter API KEY', 'ams-wc-amazon'); ?>">
                                            <button type="button" name="test-it" id="test-it" class="btn btn-primary"><?php esc_html_e('Test', 'ams-wc-amazon'); ?></button>
                                        </div>
                                    </div>
                                    <div id="test-it-response" class="alert alert-primary d-none mt-3"></div>
                                    
                                    <!-- API Usage Display -->
                                    <?php 
                                    $scraper_api_key = $this->get_option('ams_scraper_api_key');
                                    $scraper_credits = ams_scraper_api_credits_count();
                                    if ($scraper_api_key): ?>
                                        <div class="mt-3 p-3 bg-light rounded">
                                            <h6 class="mb-2 text-primary">
                                                <i class="bi bi-bar-chart me-1"></i><?php esc_html_e('API Usage', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <?php if ($scraper_credits): ?>
                                                <div class="progress mb-2" style="height: 8px;">
                                                    <?php 
                                                    $scraper_usage = ($scraper_credits['requestCount'] / $scraper_credits['requestLimit']) * 100;
                                                    ?>
                                                    <div class="progress-bar bg-primary" style="width: <?php echo esc_attr($scraper_usage); ?>%"></div>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <small class="text-muted">
                                                        <?php echo esc_html($scraper_credits['requestCount']); ?> / <?php echo esc_html($scraper_credits['requestLimit']); ?> requests used
                                                    </small>
                                                    <small class="text-muted">
                                                        <?php echo esc_html(number_format($scraper_usage, 1)); ?>%
                                                    </small>
                                                </div>
                                            <?php else: ?>
                                                <small class="text-warning">
                                                    <i class="bi bi-exclamation-triangle me-1"></i><?php esc_html_e('Unable to fetch usage data', 'ams-wc-amazon'); ?>
                                                </small>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="mt-3 pt-3 border-top">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="badge bg-primary me-2">Free</span>
                                                <small class="text-muted">
                                                    <?php echo wp_kses_post(sprintf(__('<strong>%s</strong> API calls/month', 'ams-wc-amazon'), '1,000')); ?>
                                                </small>
                                            </div>
                                            <a href="https://www.scraperapi.com/?fp_ref=ams" target="_blank" rel="noopener noreferrer" class="btn btn-outline-primary btn-sm">
                                                <?php esc_html_e('Create Account', 'ams-wc-amazon'); ?>
                                                <i class="bi bi-box-arrow-up-right ms-1"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ScrapingAnt Section -->
                        <div class="col-lg-4">
                            <div class="card h-100 shadow-sm">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">ScrapingAnt</h5>
                                    <small>Reliable Amazon product import and updates</small>
                                </div>
                                <div class="card-body">
                                    <?php
                                    $is_scrapingant_active = ($this->get_option('ams_scrapingant_is_active') == '1' || $this->get_option('ams_scrapingant_on_update') == '1');
                                    $scrapingant_status_class = $is_scrapingant_active ? 'bg-success' : 'bg-danger';
                                    $scrapingant_status_text = $is_scrapingant_active ? __('Active', 'ams-wc-amazon') : __('Inactive', 'ams-wc-amazon');
                                    ?>
                                    <div class="mb-3 text-end">
                                        <span class="badge <?php echo $scrapingant_status_class; ?> px-3 py-2">
                                            <?php echo $scrapingant_status_text; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Priority Setting -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0">
                                                <i class="bi bi-sort-numeric-down me-1"></i>
                                                <?php esc_html_e('Priority Order', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <select name="scrapingant_priority" class="form-select form-select-sm" style="width: auto;">
                                                <option value="1" <?php selected(get_option('ams_scrapingant_priority', 2), '1'); ?>>1 - <?php esc_html_e('First', 'ams-wc-amazon'); ?></option>
                                                <option value="2" <?php selected(get_option('ams_scrapingant_priority', 2), '2'); ?>>2 - <?php esc_html_e('Second', 'ams-wc-amazon'); ?></option>
                                                <option value="3" <?php selected(get_option('ams_scrapingant_priority', 2), '3'); ?>>3 - <?php esc_html_e('Third', 'ams-wc-amazon'); ?></option>
                                            </select>
                                        </div>
                                        <small class="text-muted"><?php esc_html_e('Lower numbers have higher priority', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="scrapingant_is_active" value="1" <?php checked($this->get_option('ams_scrapingant_is_active'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Update Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="scrapingant_on_update" value="1" <?php checked($this->get_option('ams_scrapingant_on_update'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <h6 class="mb-2"><?php esc_html_e('ScrapingAnt API Key', 'ams-wc-amazon'); ?></h6>
                                        <div class="input-group">
                                            <input type="text" id="scrapingant_api_key" name="scrapingant_api_key" class="form-control" value="<?php echo esc_attr($this->get_option('ams_scrapingant_api_key')); ?>" placeholder="<?php esc_html_e('Enter API KEY', 'ams-wc-amazon'); ?>">
                                            <button type="button" name="test-scrapingant" id="test-scrapingant" class="btn btn-success"><?php esc_html_e('Test', 'ams-wc-amazon'); ?></button>
                                        </div>
                                    </div>
                                    <div id="test-scrapingant-response" class="alert alert-success d-none mt-3"></div>
                                    
                                    <!-- API Usage Display -->
                                    <?php 
                                    $scrapingant_api_key = $this->get_option('ams_scrapingant_api_key');
                                    $scrapingant_credits = scrapingant_api_credits_status();
                                    if ($scrapingant_api_key): ?>
                                        <div class="mt-3 p-3 bg-light rounded">
                                            <h6 class="mb-2 text-success">
                                                <i class="bi bi-bar-chart me-1"></i><?php esc_html_e('API Usage', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <?php if ($scrapingant_credits): ?>
                                                <?php 
                                                $scrapingant_total = $scrapingant_credits['plan_total_credits'] ?? 10000;
                                                $scrapingant_used = $scrapingant_total - ($scrapingant_credits['remained_credits'] ?? $scrapingant_total);
                                                $scrapingant_usage = $scrapingant_total > 0 ? ($scrapingant_used / $scrapingant_total) * 100 : 0;
                                                ?>
                                                <div class="progress mb-2" style="height: 8px;">
                                                    <div class="progress-bar bg-success" style="width: <?php echo esc_attr($scrapingant_usage); ?>%"></div>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <small class="text-muted">
                                                        <?php echo esc_html($scrapingant_used); ?> / <?php echo esc_html($scrapingant_total); ?> requests used
                                                    </small>
                                                    <small class="text-muted">
                                                        <?php echo esc_html(number_format($scrapingant_usage, 1)); ?>%
                                                    </small>
                                                </div>
                                            <?php else: ?>
                                                <small class="text-warning">
                                                    <i class="bi bi-exclamation-triangle me-1"></i><?php esc_html_e('Unable to fetch usage data', 'ams-wc-amazon'); ?>
                                                </small>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="mt-3 pt-3 border-top">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="badge bg-success me-2">Free</span>
                                                <small class="text-muted">
                                                    <?php echo wp_kses_post(sprintf(__('<strong>%s</strong> API calls/month', 'ams-wc-amazon'), '10,000')); ?>
                                                </small>
                                            </div>
                                            <a href="https://scrapingant.com/?ref=n2mzmtb" target="_blank" rel="noopener noreferrer" class="btn btn-outline-success btn-sm">
                                                <?php esc_html_e('Create Account', 'ams-wc-amazon'); ?>
                                                <i class="bi bi-box-arrow-up-right ms-1"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Decodo Section -->
                        <div class="col-lg-4">
                            <div class="card h-100 shadow-sm">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">Decodo</h5>
                                    <small>All-in-one scraping API with ready Amazon templates</small>
                                </div>
                                <div class="card-body">
                                    <?php
                                    $is_decodo_active = ($this->get_option('ams_decodo_is_active') == '1' || $this->get_option('ams_decodo_on_update') == '1');
                                    $decodo_status_class = $is_decodo_active ? 'bg-success' : 'bg-danger';
                                    $decodo_status_text = $is_decodo_active ? __('Active', 'ams-wc-amazon') : __('Inactive', 'ams-wc-amazon');
                                    ?>
                                    <div class="mb-3 text-end">
                                        <span class="badge <?php echo $decodo_status_class; ?> px-3 py-2">
                                            <?php echo $decodo_status_text; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- Priority Setting -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0">
                                                <i class="bi bi-sort-numeric-down me-1"></i>
                                                <?php esc_html_e('Priority Order', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <select name="decodo_priority" class="form-select form-select-sm" style="width: auto;">
                                                <option value="1" <?php selected(get_option('ams_decodo_priority', 3), '1'); ?>>1 - <?php esc_html_e('First', 'ams-wc-amazon'); ?></option>
                                                <option value="2" <?php selected(get_option('ams_decodo_priority', 3), '2'); ?>>2 - <?php esc_html_e('Second', 'ams-wc-amazon'); ?></option>
                                                <option value="3" <?php selected(get_option('ams_decodo_priority', 3), '3'); ?>>3 - <?php esc_html_e('Third', 'ams-wc-amazon'); ?></option>
                                            </select>
                                        </div>
                                        <small class="text-muted"><?php esc_html_e('Lower numbers have higher priority', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="decodo_is_active" value="1" <?php checked($this->get_option('ams_decodo_is_active'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0"><?php esc_html_e('Update Products', 'ams-wc-amazon'); ?></h6>
                                            <label class="ams-common-toggle-switch">
                                                <input type="checkbox" name="decodo_on_update" value="1" <?php checked($this->get_option('ams_decodo_on_update'), '1', true); ?>>
                                                <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <h6 class="mb-2"><?php esc_html_e('Decodo Auth Token', 'ams-wc-amazon'); ?></h6>
                                        <div class="input-group">
                                            <input type="text" id="decodo_auth_token" name="decodo_auth_token" class="form-control" value="<?php echo esc_attr($this->get_option('ams_decodo_auth_token')); ?>" placeholder="<?php esc_html_e('VTAwMDAzMDAxMTM6UFdfMTZjNmMyODY1MTNhOGE1YjIyM2NkNjQzM2U4Yzg2YTdj', 'ams-wc-amazon'); ?>">
                                            <button type="button" name="test-decodo" id="test-decodo" class="btn btn-warning"><?php esc_html_e('Test', 'ams-wc-amazon'); ?></button>
                                        </div>
                                        <small class="text-muted mt-1 d-block">
                                            <i class="bi bi-info-circle me-1"></i>
                                            <?php esc_html_e('Copy the "Basic auth. token" from your Decodo dashboard "Authentication" section', 'ams-wc-amazon'); ?>
                                            <a href="https://decodo.com/" target="_blank" rel="noopener noreferrer" class="text-primary ms-1">
                                                <?php esc_html_e('Dashboard', 'ams-wc-amazon'); ?> <i class="bi bi-box-arrow-up-right fa-xs"></i>
                                            </a>
                                        </small>
                                    </div>
                                    <div id="test-decodo-response" class="alert alert-warning d-none mt-3"></div>
                                    
                                    <!-- API Usage Display -->
                                    <?php 
                                    $decodo_auth_token = $this->get_option('ams_decodo_auth_token');
                                    $decodo_credits = decodo_api_credits_status();
                                    if ($decodo_auth_token): ?>
                                        <div class="mt-3 p-3 bg-light rounded">
                                            <h6 class="mb-2 text-warning">
                                                <i class="bi bi-bar-chart me-1"></i><?php esc_html_e('API Usage', 'ams-wc-amazon'); ?>
                                            </h6>
                                            <?php if ($decodo_credits): ?>
                                                <?php 
                                                $decodo_requests = $decodo_credits['requests_made'] ?? 0;
                                                $decodo_pricing = $decodo_credits['pricing'] ?? 'From $0.08/1K requests';
                                                ?>
                                                <div class="d-flex justify-content-between mb-2">
                                                    <small class="text-muted">
                                                        <i class="bi bi-send me-1"></i><?php echo esc_html($decodo_requests); ?> requests made
                                                    </small>
                                                    <small class="text-success">
                                                        <i class="bi bi-check-circle me-1"></i>100% success rate
                                                    </small>
                                                </div>
                                                <div class="mt-1">
                                                    <small class="text-muted">
                                                        <i class="bi bi-currency-dollar me-1"></i><?php echo esc_html($decodo_pricing); ?>
                                                    </small>
                                                </div>
                                            <?php else: ?>
                                                <small class="text-warning">
                                                    <i class="bi bi-exclamation-triangle me-1"></i><?php esc_html_e('Enter credentials to see usage', 'ams-wc-amazon'); ?>
                                                </small>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- Features -->
                                    <div class="mt-3 p-3 bg-light rounded">
                                        <h6 class="mb-2 text-warning">
                                            <i class="bi bi-star me-1"></i><?php esc_html_e('Why Decodo?', 'ams-wc-amazon'); ?>
                                        </h6>
                                        <ul class="small text-muted mb-0 ps-3">
                                            <li><?php esc_html_e('Ready-made Amazon scraper templates', 'ams-wc-amazon'); ?></li>
                                            <li><?php esc_html_e('No robot training or setup required', 'ams-wc-amazon'); ?></li>
                                            <li><?php esc_html_e('100% success rate guarantee', 'ams-wc-amazon'); ?></li>
                                            <li><?php esc_html_e('7-day free trial available', 'ams-wc-amazon'); ?></li>
                                        </ul>
                                    </div>
                                    
                                    <div class="mt-3 pt-3 border-top">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="badge bg-warning me-2">Premium</span>
                                                <small class="text-muted">
                                                    <?php echo wp_kses_post(sprintf(__('<strong>%s</strong> success rate', 'ams-wc-amazon'), '100%')); ?>
                                                </small>
                                            </div>
                                            <a href="https://decodo.com/scraping" target="_blank" rel="noopener noreferrer" class="btn btn-outline-warning btn-sm">
                                                <?php esc_html_e('Get Started', 'ams-wc-amazon'); ?>
                                                <i class="bi bi-box-arrow-up-right ms-1"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--Proxy section-->

            <!-- ======================================== -->
            <!-- THEME AUTO-DETECTION SECTION -->
            <!-- ======================================== -->
            <!-- All settings and controls related to automatic theme detection -->
            <div class="card shadow-sm mb-4 ams-common-card-fix" id="theme-detection">
                <div class="card-header bg-info text-white">
                    <h4 class="mb-0 fw-bold">
                        <i class="bi bi-search me-2"></i>
                        <?php esc_html_e('Theme Auto-Detection', 'ams-wc-amazon'); ?>
                    </h4>
                </div>
                <div class="card-body">
                    
                    <!-- Enable/Disable Auto-Detection -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="alert alert-warning" role="alert">
                                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <strong><?php esc_html_e('Control Panel:', 'ams-wc-amazon'); ?></strong>
                                <?php esc_html_e('Use this to enable or disable automatic theme detection. Disable if you experience layout issues.', 'ams-wc-amazon'); ?>
                            </div>
                            
                            <div class="d-flex align-items-center justify-content-between p-3 border rounded bg-light">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-search text-primary me-3 fs-4"></i>
                                    <div>
                                        <h6 class="mb-1 fw-bold text-dark"><?php esc_html_e('Enable Theme Auto-Detection', 'ams-wc-amazon'); ?></h6>
                                        <p class="text-muted small mb-0 fw-normal">
                                            <?php esc_html_e('When disabled, the plugin will use safe default button styling without theme-specific detection.', 'ams-wc-amazon'); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="ms-3">
                                    <label class="ams-common-toggle-switch">
                                        <input type="checkbox" id="ams_enable_auto_detection" name="ams_enable_auto_detection" value="1" <?php checked(get_option('ams_enable_auto_detection', '1'), '1'); ?>>
                                        <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Auto-Detection Results Display -->
                    <div id="auto-detection-content" style="<?php echo get_option('ams_enable_auto_detection', '1') === '1' ? '' : 'display: none;'; ?>">
                        <?php
                        // Get theme detection results
                        $woocommerce_cart = new \Amazon\Affiliate\Frontend\WooCommerceCart();
                        $detection_results = $woocommerce_cart->get_theme_detection_results();
                        ?>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="card border-0 bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">
                                            <i class="bi bi-palette text-primary me-2"></i>
                                            <?php esc_html_e('Current Theme', 'ams-wc-amazon'); ?>
                                        </h6>
                                        <p class="mb-1"><strong><?php echo esc_html($detection_results['theme_name']); ?></strong></p>
                                        <p class="text-muted small mb-0"><?php echo esc_html($detection_results['theme']); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card border-0 bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">
                                            <i class="bi bi-clock text-primary me-2"></i>
                                            <?php esc_html_e('Last Scan', 'ams-wc-amazon'); ?>
                                        </h6>
                                        <p class="mb-1"><strong><?php echo esc_html($detection_results['scan_time']); ?></strong></p>
                                        <p class="text-muted small mb-0"><?php echo esc_html($detection_results['css_files_found']); ?> CSS files scanned</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="card h-100">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="mb-0">
                                            <i class="bi bi-link me-2"></i>
                                            <?php esc_html_e('Detected Hooks', 'ams-wc-amazon'); ?>
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <?php if (!empty($detection_results['hooks'])): ?>
                                            <?php 
                                            // Show only the most relevant hooks (limit to 5)
                                            $relevant_hooks = array_slice($detection_results['hooks'], 0, 5, true);
                                            $total_hooks = count($detection_results['hooks']);
                                            ?>
                                            
                                            <div class="list-group list-group-flush">
                                                <?php foreach ($relevant_hooks as $hook => $priority): ?>
                                                    <div class="list-group-item d-flex justify-content-between align-items-center border-0 px-0 py-2">
                                                        <code class="text-primary small"><?php echo esc_html($hook); ?></code>
                                                        <span class="badge bg-secondary"><?php echo esc_html($priority); ?></span>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                            
                                            <?php if ($total_hooks > 5): ?>
                                                <div class="mt-2">
                                                    <small class="text-muted">
                                                        <?php echo sprintf(esc_html__('Showing 5 of %d detected hooks', 'ams-wc-amazon'), $total_hooks); ?>
                                                    </small>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="text-center py-3">
                                                <i class="bi bi-exclamation-circle text-warning fs-4"></i>
                                                <p class="text-muted mt-2 mb-0"><?php esc_html_e('No hooks detected', 'ams-wc-amazon'); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card h-100">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">
                                            <i class="bi bi-palette me-2"></i>
                                            <?php esc_html_e('Detected CSS Classes', 'ams-wc-amazon'); ?>
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <?php if (!empty($detection_results['classes'])): ?>
                                            <?php 
                                            // Filter out irrelevant classes and show only button-related ones
                                            $button_classes = array_filter($detection_results['classes'], function($class) {
                                                return stripos($class, 'button') !== false || 
                                                       stripos($class, 'btn') !== false || 
                                                       stripos($class, 'add-to-cart') !== false ||
                                                       stripos($class, 'cart') !== false;
                                            });
                                            
                                            // If no button-specific classes, show first 8 classes
                                            if (empty($button_classes)) {
                                                $button_classes = array_slice($detection_results['classes'], 0, 8, true);
                                            }
                                            
                                            $total_classes = count($detection_results['classes']);
                                            $displayed_classes = count($button_classes);
                                            ?>
                                            
                                            <div class="d-flex flex-wrap gap-1 mb-2">
                                                <?php foreach ($button_classes as $class): ?>
                                                    <span class="badge bg-light text-dark border small"><?php echo esc_html($class); ?></span>
                                                <?php endforeach; ?>
                                            </div>
                                            
                                            <?php if ($total_classes > $displayed_classes): ?>
                                                <div class="mt-2">
                                                    <small class="text-muted">
                                                        <?php echo sprintf(esc_html__('Showing %d of %d detected classes', 'ams-wc-amazon'), $displayed_classes, $total_classes); ?>
                                                    </small>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="text-center py-3">
                                                <i class="bi bi-exclamation-circle text-warning fs-4"></i>
                                                <p class="text-muted mt-2 mb-0"><?php esc_html_e('No CSS classes detected', 'ams-wc-amazon'); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">
                                            <i class="bi bi-cpu me-2"></i>
                                            <?php esc_html_e('Intelligent Selection Results', 'ams-wc-amazon'); ?>
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h6 class="text-muted mb-2">
                                                    <i class="bi bi-bullseye text-success me-1"></i>
                                                    <?php esc_html_e('Smart Selection Summary', 'ams-wc-amazon'); ?>
                                                </h6>
                                                <p class="mb-2">
                                                    <?php if (isset($detection_results['selected_hook']) && $detection_results['selected_hook']): ?>
                                                        <span class="badge bg-success me-2">✅</span>
                                                        <?php esc_html_e('Best hook selected:', 'ams-wc-amazon'); ?> 
                                                        <code><?php echo esc_html($detection_results['selected_hook']['hook']); ?></code>
                                                        <small class="text-muted">(<?php echo esc_html($detection_results['selected_hook']['source']); ?>)</small>
                                                    <?php else: ?>
                                                        <span class="badge bg-warning me-2">⚠️</span>
                                                        <?php esc_html_e('No optimal hook found', 'ams-wc-amazon'); ?>
                                                    <?php endif; ?>
                                                </p>
                                                <p class="mb-0">
                                                    <?php if (!empty($detection_results['selected_classes'])): ?>
                                                        <span class="badge bg-success me-2">✅</span>
                                                        <?php esc_html_e('Best CSS classes selected:', 'ams-wc-amazon'); ?>
                                                        <?php foreach ($detection_results['selected_classes'] as $type => $class_info): ?>
                                                            <code><?php echo esc_html($class_info['class']); ?></code>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <span class="badge bg-warning me-2">⚠️</span>
                                                        <?php esc_html_e('No optimal CSS classes found', 'ams-wc-amazon'); ?>
                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="text-muted mb-2">
                                                    <i class="bi bi-info-circle text-info me-1"></i>
                                                    <?php esc_html_e('Detection Statistics', 'ams-wc-amazon'); ?>
                                                </h6>
                                                <ul class="list-unstyled small">
                                                    <li><strong><?php esc_html_e('Theme:', 'ams-wc-amazon'); ?></strong> <?php echo esc_html($detection_results['theme_name']); ?></li>
                                                    <li><strong><?php esc_html_e('Hooks Found:', 'ams-wc-amazon'); ?></strong> <?php echo count($detection_results['hooks']); ?></li>
                                                    <li><strong><?php esc_html_e('CSS Classes Found:', 'ams-wc-amazon'); ?></strong> <?php echo count($detection_results['classes']); ?></li>
                                                    <li><strong><?php esc_html_e('CSS Files Scanned:', 'ams-wc-amazon'); ?></strong> <?php echo esc_html($detection_results['css_files_found']); ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="text-center mt-3">
                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="location.reload()">
                                <i class="bi bi-arrow-clockwise me-2"></i>
                                <?php esc_html_e('Re-scan Theme', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!--Save settings section-->
            <div class="card shadow-sm mb-4 ams-common-card-fix">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h5 class="mb-0"><?php esc_html_e('Save All Settings', 'ams-wc-amazon'); ?></h5>
                            <p class="text-muted small mb-0"><?php esc_html_e('Click to save all changes', 'ams-wc-amazon'); ?></p>
                        </div>
                        <div class="col-md-6 text-md-end mt-3 mt-md-0">
                            <input type="hidden" name="action" value="<?php echo esc_attr( 'ams-wc-general-setting' ); ?>">
                            <input type="hidden" name="action_tab" value="pills-general-tab">
                            
                            <?php wp_nonce_field("general_setting_nonce", "general_setting_nonce") ?>
                            <button type="submit" name="general-setting-submit" id="general-setting-submit-main" value="Save Settings" class="btn btn-primary btn-lg px-4 py-3 d-flex align-items-center justify-content-center gap-2 fw-semibold rounded-3 shadow">
                                <i class="bi bi-floppy fs-5"></i>
                                <span><?php esc_html_e("Save Settings", "ams-wc-amazon"); ?></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <!--Save settings section-->


            <!-- Floating Save Button -->
            <div class="position-fixed bottom-0 end-0 m-4">
                <button 
                    type="button" 
                    id="floating-save-btn" 
                    class="btn btn-success shadow-lg rounded-circle d-flex align-items-center justify-content-center p-4 border border-2 border-light"
                    data-bs-toggle="tooltip" 
                    data-bs-placement="left" 
                    title="<?php esc_attr_e('Save Settings', 'ams-wc-amazon'); ?>"
                    style="width: 64px; height: 64px;"
                >
                    <i class="bi bi-floppy fs-4"></i>
                </button>
            </div>


            <script>
                // Initialize Bootstrap tooltips and floating save button
                document.addEventListener('DOMContentLoaded', function () {
                    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                        new bootstrap.Tooltip(tooltipTriggerEl);
                    });
                    
                    // Floating save button functionality
                    const floatingSaveBtn = document.getElementById('floating-save-btn');
                    const mainSaveBtn = document.getElementById('general-setting-submit-main');
                    
                    if (floatingSaveBtn && mainSaveBtn) {
                        floatingSaveBtn.addEventListener('click', function() {
                            // Add loading state
                            const originalIcon = floatingSaveBtn.innerHTML;
                            floatingSaveBtn.innerHTML = '<div class="spinner-border spinner-border-sm" role="status"><span class="visually-hidden">Loading...</span></div>';
                            floatingSaveBtn.disabled = true;
                            floatingSaveBtn.classList.add('btn-warning');
                            floatingSaveBtn.classList.remove('btn-success');
                            
                            // Trigger the main save button
                            mainSaveBtn.click();
                        });
                    }
                    
                    // Show success toast after form submission
                    const urlParams = new URLSearchParams(window.location.search);
                    if (urlParams.get('settings') === 'saved') {
                        // Try multiple methods to show toast
                        if (typeof showToast === 'function') {
                            showToast('<?php echo esc_js(__("Settings saved successfully!", "ams-wc-amazon")); ?>', 'success');
                        } else if (typeof window.showToast === 'function') {
                            window.showToast('<?php echo esc_js(__("Settings saved successfully!", "ams-wc-amazon")); ?>', 'success');
                        } else {
                            // Fallback: Create a simple alert-style notification
                            const alertDiv = document.createElement('div');
                            alertDiv.className = 'alert alert-success alert-dismissible fade show position-fixed';
                            alertDiv.style.cssText = 'top: 50px; right: 20px; min-width: 300px; z-index: 9999;';
                            alertDiv.innerHTML = `
                                <i class="bi bi-check-circle me-2"></i><?php echo esc_js(__("Settings saved successfully!", "ams-wc-amazon")); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            `;
                            document.body.appendChild(alertDiv);
                            
                            // Auto-remove after 5 seconds
                            setTimeout(() => {
                                if (alertDiv.parentNode) {
                                    alertDiv.remove();
                                }
                            }, 5000);
                        }
                        
                        // Remove the parameter from URL to prevent showing toast on refresh
                        const newUrl = window.location.pathname + window.location.search.replace(/[?&]settings=saved/, '');
                        window.history.replaceState({}, document.title, newUrl);
                    }
                });
            </script>

        </div>
    </form>
</div>

<script>
// ========================================
// THEME AUTO-DETECTION JAVASCRIPT
// ========================================
// Handle auto-detection toggle and related functionality
document.addEventListener('DOMContentLoaded', function() {
    const autoDetectionToggle = document.getElementById('ams_enable_auto_detection');
    const autoDetectionContent = document.getElementById('auto-detection-content');
    
    if (autoDetectionToggle && autoDetectionContent) {
        // Initial state
        const card = autoDetectionToggle.closest('.d-flex');
        if (autoDetectionToggle.checked) {
            if (card) card.classList.add('text-primary');
            autoDetectionContent.style.display = '';
        } else {
            if (card) card.classList.remove('text-primary');
            autoDetectionContent.style.display = 'none';
        }
        
        // Handle toggle change
        autoDetectionToggle.addEventListener('change', function() {
            if (this.checked) {
                if (card) card.classList.add('text-primary');
                autoDetectionContent.style.display = '';
            } else {
                if (card) card.classList.remove('text-primary');
                autoDetectionContent.style.display = 'none';
            }
        });
    }
});
</script>

<div class="tab-pane fade <?= ( isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab")?'show active':''; ?> " id="pills-az-settings" role="tabpanel" aria-labelledby="pills-az-settings-tab">
    <div class="container-fluid">
        <div class="row">
            <!-- Left Column: Compact API Settings -->
            <div class="col-lg-5">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-header bg-primary text-white border-0 py-2">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h6 class="mb-0 d-flex align-items-center text-white">
                                    <i class="bi bi-shield me-2"></i>
                                    <?php esc_html_e('API Settings', 'ams-wc-amazon'); ?>
                                </h6>
                            </div>
                            <div class="d-flex align-items-center gap-1">
                                <button type="button" class="btn btn-light btn-sm px-2 py-1" data-bs-toggle="modal" data-bs-target="#apiHelpModal" title="<?php esc_attr_e('Get API Keys', 'ams-wc-amazon'); ?>">
                                    <i class="bi bi-question-circle text-primary"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-3">
                        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" enctype="multipart/form-data" class="flex-grow-1 d-flex flex-column">
                            
                            <!-- Compact Credentials Section -->
                            <div class="mb-2">
                                <h6 class="text-dark mb-1 small fw-bold">
                                    <i class="bi bi-key me-1 text-warning"></i>
                                    <?php esc_html_e('Credentials', 'ams-wc-amazon'); ?>
                                </h6>
                                
                                <div class="mb-2">
                                    <label class="form-label small text-muted mb-1"><?php esc_html_e('Access Key', 'ams-wc-amazon'); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="bi bi-key text-warning"></i>
                                        </span>
                                        <input type="password" id="access_key_id" name="access_key_id"
                                               class="form-control"
                                               placeholder="<?php echo esc_attr__('Enter your Amazon Access Key ID', 'ams-wc-amazon'); ?>"
                                               value="<?php echo esc_attr($this->get_option('ams_access_key_id')); ?>"
                                               onfocus="this.removeAttribute('readonly');"
                                               onblur="this.setAttribute('readonly', 'readonly');"
                                               autocomplete="off" readonly>
                                        <button class="btn btn-outline-secondary" type="button" onclick="toggleVisibility('access_key_id', 'toggle-password-access-key')">
                                            <i class="bi bi-eye toggle-password-access-key"></i>
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="mb-2">
                                    <label class="form-label small text-muted mb-1"><?php esc_html_e('Secret Key', 'ams-wc-amazon'); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="bi bi-shield text-danger"></i>
                                        </span>
                                        <input type="password" id="secret_access_key" name="secret_access_key"
                                               class="form-control"
                                               placeholder="<?php echo esc_attr__('Enter your Amazon Secret Access Key', 'ams-wc-amazon'); ?>"
                                               value="<?php echo esc_attr($this->get_option('ams_secret_access_key')); ?>"
                                               onfocus="this.removeAttribute('readonly');"
                                               onblur="this.setAttribute('readonly', 'readonly');"
                                               autocomplete="off" readonly>
                                        <button class="btn btn-outline-secondary" type="button" onclick="toggleVisibility('secret_access_key', 'toggle-password-secret')">
                                            <i class="bi bi-eye toggle-password-secret"></i>
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label small text-muted mb-1"><?php esc_html_e('Associate Tag', 'ams-wc-amazon'); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light">
                                            <i class="bi bi-tag text-success"></i>
                                        </span>
                                        <input type="password" id="input-username" name="ams_associate_tag"
                                               class="form-control"
                                               placeholder="<?php echo esc_attr__('Enter your Amazon Associate Tag', 'ams-wc-amazon'); ?>"
                                               value="<?php echo esc_attr($this->get_option('ams_associate_tag')); ?>"
                                               onfocus="this.removeAttribute('readonly');"
                                               onblur="this.setAttribute('readonly', 'readonly');"
                                               autocomplete="off" readonly>
                                        <button class="btn btn-outline-secondary" type="button" onclick="toggleVisibility('input-username', 'toggle-password-associate')">
                                            <i class="bi bi-eye toggle-password-associate"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Compact Configuration -->
                            <div class="mb-2">
                                <h6 class="text-dark mb-1 small fw-bold">
                                    <i class="bi bi-sliders me-1 text-info"></i>
                                    <?php esc_html_e('Configuration', 'ams-wc-amazon'); ?>
                                </h6>
                                
                                <div class="row g-1 mb-1">
                                    <div class="col-8">
                                        <label class="form-label small text-muted mb-0"><?php esc_html_e('Country', 'ams-wc-amazon'); ?></label>
                                        <select name="ams_amazon_country" id="amazon_country" class="form-select form-select-sm">
                                            <?php
                                            $regions = ams_get_amazon_regions();
                                            $current_country = $this->get_option('ams_amazon_country');
                                            foreach ($regions as $key => $value) {
                                                $selected = selected($current_country, $key, false);
                                                echo '<option value="' . esc_attr($key) . '" ' . $selected . '>' . esc_html($value['RegionName']) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label small text-muted mb-0"><?php esc_html_e('Currency', 'ams-wc-amazon'); ?></label>
                                        <div class="input-group input-group-sm">
                                            <select name="woocommerce_currency" id="woocommerce_currency" class="form-select form-select-sm" disabled>
                                                <?php 
                                                $store_currency = get_woocommerce_currency();
                                                $currency_code_options = get_woocommerce_currencies();
                                                foreach ($currency_code_options as $code => $value) {
                                                    $selected = selected($store_currency, $code, false);
                                                    echo '<option value="' . esc_attr($code) . '" ' . $selected . '>' . esc_html($value) . '</option>';
                                                }
                                                ?>
                                            </select>
                                            <span class="input-group-text">
                                                <i class="bi bi-lock text-muted"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <small class="text-info">
                                    <i class="bi bi-info-circle me-1"></i>
                                    <span id="currency-status-text">Auto-updated with country</span>
                                </small>
                            </div>

                            <!-- Action Buttons -->
                            <div class="d-grid gap-2 mb-3">
                                <button type="submit" name="general-setting-submit" id="general-setting-submit-api" 
                                        class="btn btn-primary btn-lg w-100 fw-bold shadow">
                                    <i class="bi bi-floppy me-2"></i>
                                    <?php esc_html_e('Save API Settings', 'ams-wc-amazon'); ?>
                                </button>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <button type="button" class="btn btn-info w-100 ams-test-api-btn">
                                            <i class="bi bi-flask me-1"></i>
                                            <?php esc_html_e('Test API', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    <div class="col-6">
                                        <button type="button" class="btn btn-outline-warning w-100" data-bs-toggle="modal" data-bs-target="#apiErrorReferenceModal">
                                            <i class="bi bi-question-circle me-1"></i>
                                            <?php esc_html_e('Help', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <input type="hidden" name="action" value="<?php echo esc_attr('ams_wc_amazon_general_setting'); ?>">
                            <input type="hidden" name="action_tab" value="pills-az-settings-tab">
                            <?php wp_nonce_field('general_amazon_setting_nonce'); ?>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Right Column: API Status & Information -->
            <div class="col-lg-7">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-header bg-dark text-white border-0">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-graph-up me-2 text-warning"></i>
                                <h5 class="mb-0 text-white"><?php esc_html_e('API Status & Information', 'ams-wc-amazon'); ?></h5>
                            </div>
                            <div class="console-controls">
                                <button type="button" class="btn btn-outline-light btn-sm" data-bs-toggle="collapse" data-bs-target="#apiStatusCollapse" aria-expanded="false">
                                    <i class="bi bi-chevron-down"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body bg-dark p-0 d-flex flex-column">
                        <div id="api-status-window" class="text-light p-3 flex-grow-1" style="background: #23272b; font-family: 'Courier New', monospace; font-size: 0.875rem; border: none;">
                            <?php
                            // Get real API usage data
                            $api_usage = \Amazon\Affiliate\Api\Amazon_Product_Api::get_api_usage();
                            $last_request_time = get_option('amazon_api_last_request_time', 0);
                            $last_request_formatted = $last_request_time ? date('Y-m-d H:i:s', $last_request_time) : 'Never';
                            
                            // Get API credentials status
                            $access_key = get_option('ams_access_key_id');
                            $secret_key = get_option('ams_secret_access_key');
                            $associate_tag = get_option('ams_associate_tag');
                            $has_credentials = !empty($access_key) && !empty($secret_key) && !empty($associate_tag);
                            
                            // Get ScraperAPI status
                            $scraper_api_key = get_option('ams_scraper_api_key');
                            $scraper_is_active = get_option('ams_scraper_api_is_active') === '1';
                            $scraper_credits = ams_scraper_api_credits_count();
                            
                            // Get ScrapingAnt status
                            $scrapingant_api_key = get_option('ams_scrapingant_api_key');
                            $scrapingant_is_active = get_option('ams_scrapingant_is_active') === '1';
                            $scrapingant_credits = scrapingant_api_credits_status();
                            ?>
                            
                            <div id="api-status-output">
                                <!-- Quick Status Overview -->
                                <div class="mb-4">
                                    <h6 class="text-warning mb-3">
                                        <i class="bi bi-speedometer me-2"></i>
                                        <?php esc_html_e('Quick Status Overview', 'ams-wc-amazon'); ?>
                                    </h6>
                                    <div class="row g-3 mb-3">
                                        <div class="col-6">
                                            <div class="card bg-<?php echo $has_credentials ? 'success' : 'warning'; ?> bg-opacity-10 border-<?php echo $has_credentials ? 'success' : 'warning'; ?> text-center">
                                                <div class="card-body py-2">
                                                    <div class="h4 mb-1 text-<?php echo $has_credentials ? 'success' : 'warning'; ?>">
                                                        <i class="bi bi-<?php echo $has_credentials ? 'check-circle' : 'exclamation-triangle'; ?>"></i>
                                                    </div>
                                                    <small class="text-secondary d-block fw-bold"><?php esc_html_e('Amazon API', 'ams-wc-amazon'); ?></small>
                                                    <div class="small fw-bold text-<?php echo $has_credentials ? 'success' : 'warning'; ?>">
                                                        <?php echo $has_credentials ? esc_html__('Configured', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="card bg-<?php echo $api_usage['used_percentage'] > 80 ? 'danger' : ($api_usage['used_percentage'] > 60 ? 'warning' : 'success'); ?> bg-opacity-10 border-<?php echo $api_usage['used_percentage'] > 80 ? 'danger' : ($api_usage['used_percentage'] > 60 ? 'warning' : 'success'); ?> text-center">
                                                <div class="card-body py-2">
                                                    <div class="h4 mb-1 text-<?php echo $api_usage['used_percentage'] > 80 ? 'danger' : ($api_usage['used_percentage'] > 60 ? 'warning' : 'success'); ?>">
                                                        <?php echo esc_html($api_usage['used_percentage']); ?>%
                                                    </div>
                                                    <small class="text-secondary d-block fw-bold"><?php esc_html_e('Daily Usage', 'ams-wc-amazon'); ?></small>
                                                    <div class="small fw-bold text-<?php echo $api_usage['used_percentage'] > 80 ? 'danger' : ($api_usage['used_percentage'] > 60 ? 'warning' : 'success'); ?>">
                                                        <?php echo esc_html($api_usage['used_requests']); ?>/<?php echo esc_html($api_usage['total_requests']); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3">
                                        <div class="col-6">
                                            <div class="card bg-info bg-opacity-10 border-info text-center">
                                                <div class="card-body py-2">
                                                    <div class="h4 mb-1 text-info">
                                                        <i class="bi bi-clock"></i>
                                                    </div>
                                                    <small class="text-secondary d-block fw-bold"><?php esc_html_e('Last Request', 'ams-wc-amazon'); ?></small>
                                                    <div class="small fw-bold text-info">
                                                        <?php echo $last_request_time ? date('H:i', $last_request_time) : esc_html__('Never', 'ams-wc-amazon'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="card bg-primary bg-opacity-10 border-primary text-center">
                                                <div class="card-body py-2">
                                                    <div class="h4 mb-1 text-primary">
                                                        <i class="bi bi-server"></i>
                                                    </div>
                                                    <small class="text-secondary d-block fw-bold"><?php esc_html_e('Services', 'ams-wc-amazon'); ?></small>
                                                    <div class="small fw-bold text-primary">
                                                        <?php 
                                                        $active_services = 0;
                                                        if ($scraper_is_active) $active_services++;
                                                        if ($scrapingant_is_active) $active_services++;
                                                        if ($is_decodo_active) $active_services++;
                                                        echo $active_services . '/3 ' . esc_html__('Active', 'ams-wc-amazon');
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- API Test Results Area -->
                                <div id="api-test-results" class="mb-4" style="display: none;">
                                    <h6 class="text-success mb-3">
                                        <i class="bi bi-flask me-2"></i>
                                        <?php esc_html_e('API Test Results', 'ams-wc-amazon'); ?>
                                    </h6>
                                    <div id="api-test-output"></div>
                                </div>
                                
                                <!-- Detailed Status -->
                                <div class="collapse" id="apiStatusCollapse">
                                    <div class="border-top border-secondary pt-3">
                                        <h6 class="text-warning mb-3">
                                            <i class="bi bi-info-circle me-2"></i>
                                            <?php esc_html_e('Detailed Status', 'ams-wc-amazon'); ?>
                                        </h6>
                                        
                                        <!-- Amazon API Details -->
                                        <div class="mb-3">
                                            <h6 class="text-secondary mb-2 fw-bold"><?php esc_html_e('Amazon API Credentials', 'ams-wc-amazon'); ?></h6>
                                            <div class="d-flex align-items-center mb-1">
                                                <div class="rounded-circle bg-<?php echo !empty($access_key) ? 'success' : 'danger'; ?> me-2" style="width: 8px; height: 8px;"></div>
                                                <small class="text-secondary">Access Key: <?php echo !empty($access_key) ? esc_html__('Set', 'ams-wc-amazon') : esc_html__('Missing', 'ams-wc-amazon'); ?></small>
                                            </div>
                                            <div class="d-flex align-items-center mb-1">
                                                <div class="rounded-circle bg-<?php echo !empty($secret_key) ? 'success' : 'danger'; ?> me-2" style="width: 8px; height: 8px;"></div>
                                                <small class="text-secondary">Secret Key: <?php echo !empty($secret_key) ? esc_html__('Set', 'ams-wc-amazon') : esc_html__('Missing', 'ams-wc-amazon'); ?></small>
                                            </div>
                                            <div class="d-flex align-items-center mb-2">
                                                <div class="rounded-circle bg-<?php echo !empty($associate_tag) ? 'success' : 'danger'; ?> me-2" style="width: 8px; height: 8px;"></div>
                                                <small class="text-secondary">Associate Tag: <?php echo !empty($associate_tag) ? esc_html__('Set', 'ams-wc-amazon') : esc_html__('Missing', 'ams-wc-amazon'); ?></small>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <h6 class="text-secondary mb-2 fw-bold"><?php esc_html_e('Usage Statistics', 'ams-wc-amazon'); ?></h6>
                                                <div class="progress mb-2" style="height: 8px;">
                                                    <div class="progress-bar bg-<?php echo $api_usage['used_percentage'] > 80 ? 'danger' : ($api_usage['used_percentage'] > 60 ? 'warning' : 'success'); ?>" 
                                                         style="width: <?php echo esc_attr($api_usage['used_percentage']); ?>%"></div>
                                                </div>
                                                <small class="text-secondary">
                                                    <?php echo esc_html($api_usage['used_requests']); ?> <?php esc_html_e('of', 'ams-wc-amazon'); ?> <?php echo esc_html($api_usage['total_requests']); ?> <?php esc_html_e('requests used today', 'ams-wc-amazon'); ?>
                                                </small>
                                                <br>
                                                <small class="text-secondary">
                                                    <?php esc_html_e('Last request:', 'ams-wc-amazon'); ?> <?php echo esc_html($last_request_formatted); ?>
                                                </small>
                                            </div>
                                        </div>
                                        
                                        <!-- Scraping Services -->
                                        <div class="mb-3">
                                            <h6 class="text-secondary mb-2 fw-bold"><?php esc_html_e('Scraping Services', 'ams-wc-amazon'); ?></h6>
                                            
                                            <!-- ScraperAPI -->
                                            <div class="mb-2">
                                                <div class="d-flex align-items-center mb-1">
                                                    <div class="rounded-circle bg-<?php echo $scraper_is_active ? 'success' : 'secondary'; ?> me-2" style="width: 8px; height: 8px;"></div>
                                                    <small class="text-secondary">ScraperAPI: <?php echo $scraper_is_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <?php if ($scraper_api_key): ?>
                                                    <?php if ($scraper_credits): ?>
                                                        <!-- Real API Usage -->
                                                        <div class="progress mb-1" style="height: 6px;">
                                                            <?php 
                                                            $scraper_usage = isset($scraper_credits['requestCount']) && isset($scraper_credits['requestLimit']) 
                                                                ? ($scraper_credits['requestCount'] / $scraper_credits['requestLimit']) * 100 
                                                                : 0;
                                                            ?>
                                                            <div class="progress-bar bg-info" style="width: <?php echo esc_attr($scraper_usage); ?>%"></div>
                                                        </div>
                                                        <small class="text-secondary">
                                                            <i class="bi bi-cloud me-1"></i><?php echo esc_html($scraper_credits['requestCount'] ?? 0); ?> / <?php echo esc_html($scraper_credits['requestLimit'] ?? 1000); ?> <?php esc_html_e('requests (API)', 'ams-wc-amazon'); ?>
                                                        </small>
                                                    <?php else: ?>
                                                        <small class="text-warning">
                                                            <i class="bi bi-exclamation-triangle me-1"></i>Unable to fetch API usage - check API key
                                                        </small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <small class="text-secondary"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></small>
                                                <?php endif; ?>
                                                
                                                <?php 
                                                // Show internal plugin usage statistics
                                                $scraper_stats = ams_get_scraping_usage_stats('scraperapi');
                                                if ($scraper_api_key && ($scraper_stats['total'] > 0 || !$scraper_credits)): ?>
                                                    <div class="mt-1">
                                                        <small class="text-secondary">
                                                            <i class="bi bi-graph-up me-1"></i><?php esc_html_e('Plugin usage (30d):', 'ams-wc-amazon'); ?> <?php echo $scraper_stats['total']; ?> 
                                                            (<?php echo $scraper_stats['success']; ?> <?php esc_html_e('success', 'ams-wc-amazon'); ?>, <?php echo $scraper_stats['failed']; ?> <?php esc_html_e('failed', 'ams-wc-amazon'); ?>)
                                                        </small>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- ScrapingAnt -->
                                            <div class="mb-2">
                                                <div class="d-flex align-items-center mb-1">
                                                    <div class="rounded-circle bg-<?php echo $scrapingant_is_active ? 'success' : 'secondary'; ?> me-2" style="width: 8px; height: 8px;"></div>
                                                    <small class="text-secondary">ScrapingAnt: <?php echo $scrapingant_is_active ? esc_html__('Active', 'ams-wc-amazon') : esc_html__('Inactive', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <?php if ($scrapingant_api_key): ?>
                                                    <?php if ($scrapingant_credits): ?>
                                                        <!-- Real API Usage -->
                                                        <div class="progress mb-1" style="height: 6px;">
                                                            <?php 
                                                            $scrapingant_total = $scrapingant_credits['plan_total_credits'] ?? 10000;
                                                            $scrapingant_used = $scrapingant_total - ($scrapingant_credits['remained_credits'] ?? $scrapingant_total);
                                                            $scrapingant_usage = $scrapingant_total > 0 ? ($scrapingant_used / $scrapingant_total) * 100 : 0;
                                                            ?>
                                                            <div class="progress-bar bg-info" style="width: <?php echo esc_attr($scrapingant_usage); ?>%"></div>
                                                        </div>
                                                        <small class="text-secondary">
                                                            <i class="bi bi-cloud me-1"></i><?php echo esc_html($scrapingant_used); ?> / <?php echo esc_html($scrapingant_total); ?> <?php esc_html_e('requests (API)', 'ams-wc-amazon'); ?>
                                                        </small>
                                                    <?php else: ?>
                                                        <small class="text-warning">
                                                            <i class="bi bi-exclamation-triangle me-1"></i>Unable to fetch API usage - check API key
                                                        </small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <small class="text-secondary"><?php esc_html_e('Not configured', 'ams-wc-amazon'); ?></small>
                                                <?php endif; ?>
                                                
                                                <?php 
                                                // Show internal plugin usage statistics
                                                $scrapingant_stats = ams_get_scraping_usage_stats('scrapingant');
                                                if ($scrapingant_api_key && ($scrapingant_stats['total'] > 0 || !$scrapingant_credits)): ?>
                                                    <div class="mt-1">
                                                        <small class="text-secondary">
                                                            <i class="bi bi-graph-up me-1"></i><?php esc_html_e('Plugin usage (30d):', 'ams-wc-amazon'); ?> <?php echo $scrapingant_stats['total']; ?> 
                                                            (<?php echo $scrapingant_stats['success']; ?> <?php esc_html_e('success', 'ams-wc-amazon'); ?>, <?php echo $scrapingant_stats['failed']; ?> <?php esc_html_e('failed', 'ams-wc-amazon'); ?>)
                                                        </small>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer bg-dark text-light border-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-clock me-2 text-muted"></i>
                                    <span id="api-status-footer-message"><?php esc_html_e('API status monitoring active', 'ams-wc-amazon'); ?></span>
                                </div>
                                <div class="api-stats">
                                    <span class="badge bg-light text-dark"><?php echo $has_credentials ? esc_html__('Configured', 'ams-wc-amazon') : esc_html__('Not Set', 'ams-wc-amazon'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="tab-pane fade <?= (isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab") ? 'show active' : ''; ?>" id="pills-az-products" role="tabpanel" aria-labelledby="pills-az-products-tab">
    <div class="row g-3">
        <!-- Left Column: Compact Automation Settings -->
        <div class="col-lg-6">
            <div class="card border-0 shadow-sm h-100 ams-common-card-fix">
                <div class="card-header bg-primary text-white border-0 py-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="bg-white bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 48px; height: 48px;">
                                <i class="bi bi-sliders text-primary fs-4"></i>
                            </div>
                            <div>
                                <h5 class="mb-1 fw-bold text-white"><?php esc_html_e('Automation Settings', 'ams-wc-amazon'); ?></h5>
                                <p class="mb-0 text-white text-opacity-75 small"><?php esc_html_e('Configure automated product updates', 'ams-wc-amazon'); ?></p>
                            </div>
                        </div>
                        <button class="btn btn-outline-light btn-sm px-3 py-2" type="button" data-bs-toggle="collapse" data-bs-target="#statusOverview" aria-expanded="false">
                            <i class="bi bi-bar-chart me-2"></i>
                            <?php esc_html_e('View Status', 'ams-wc-amazon'); ?>
                        </button>
                    </div>
                </div>
                
                <div class="card-body p-3">
                    <!-- Enhanced Status Overview -->
                    <div class="collapse mb-4" id="statusOverview">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-info text-white border-0 py-3">
                                <div class="d-flex align-items-center">
                                    <div class="bg-white bg-opacity-25 rounded-circle p-2 me-3">
                                        <i class="bi bi-graph-up text-info"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-0 fw-bold text-white"><?php esc_html_e('Automation Status Overview', 'ams-wc-amazon'); ?></h6>
                                        <small class="text-white text-opacity-75"><?php esc_html_e('Current automation configuration summary', 'ams-wc-amazon'); ?></small>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-3">
                                <?php
                                $all_options = [
                                    'product_name_cron', 'product_price_cron', 'product_sku_cron',
                                    'product_description_cron', 'product_image_cron', 'product_category_cron',
                                    'product_variants_cron', 'product_variant_image_cron', 'product_variant_description_cron',
                                    'product_out_of_stock_cron', 'product_review_cron'
                                ];
                                $enabled_count = 0;
                                foreach ($all_options as $option) {
                                    if ($this->get_option($option) === '1') $enabled_count++;
                                }
                                $percentage = round(($enabled_count / count($all_options)) * 100);
                                $total_options = count($all_options);
                                ?>
                                
                                <!-- Status Cards -->
                                <div class="row g-3 mb-4">
                                    <div class="col-4">
                                        <div class="card border-0 text-center bg-success text-white">
                                            <div class="card-body py-3">
                                                <i class="bi bi-check-circle fs-2 mb-2 d-block"></i>
                                                <div class="h4 mb-1 fw-bold"><?php echo $enabled_count; ?></div>
                                                <small class="text-white-75 fw-medium"><?php esc_html_e('Active', 'ams-wc-amazon'); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="card border-0 text-center bg-secondary text-white">
                                            <div class="card-body py-3">
                                                <i class="bi bi-x-circle fs-2 mb-2 d-block"></i>
                                                <div class="h4 mb-1 fw-bold"><?php echo $total_options - $enabled_count; ?></div>
                                                <small class="text-white-75 fw-medium"><?php esc_html_e('Inactive', 'ams-wc-amazon'); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="card border-0 text-center bg-primary text-white">
                                            <div class="card-body py-3">
                                                <i class="bi bi-percent fs-2 mb-2 d-block"></i>
                                                <div class="h4 mb-1 fw-bold"><?php echo $percentage; ?>%</div>
                                                <small class="text-white-75 fw-medium"><?php esc_html_e('Coverage', 'ams-wc-amazon'); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Progress Bar -->
                                <div class="mb-4">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="mb-0 text-dark fw-semibold"><?php esc_html_e('Overall Automation Progress', 'ams-wc-amazon'); ?></h6>
                                        <span class="badge bg-primary fs-6"><?php echo $enabled_count; ?>/<?php echo $total_options; ?></span>
                                    </div>
                                    <div class="progress mb-2" style="height: 12px;">
                                        <div class="progress-bar bg-gradient bg-success" style="width: <?php echo $percentage; ?>%;" role="progressbar" aria-valuenow="<?php echo $percentage; ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="text-center">
                                        <small class="text-muted fw-medium"><?php echo $percentage; ?>% <?php esc_html_e('of automation features enabled', 'ams-wc-amazon'); ?></small>
                                    </div>
                                </div>
                                
                                <!-- Status Message -->
                                <div class="text-center">
                                    <?php if ($percentage >= 80): ?>
                                        <div class="alert alert-success py-2 mb-0">
                                            <i class="bi bi-star me-1"></i>
                                            <small class="fw-bold"><?php esc_html_e('Excellent! Most automation features are active.', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    <?php elseif ($percentage >= 50): ?>
                                        <div class="alert alert-info py-2 mb-0">
                                            <i class="bi bi-info-circle me-1"></i>
                                            <small class="fw-bold"><?php esc_html_e('Good progress! Consider enabling more features.', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-secondary py-2 mb-0">
                                            <i class="bi bi-lightbulb me-1"></i>
                                            <small class="fw-bold"><?php esc_html_e('Limited automation. Enable more features for better results.', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" enctype="multipart/form-data">
                        <!-- Server Command Section -->
                        <div class="mb-3">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text bg-info text-white border-0">
                                    <i class="bi bi-terminal me-1"></i>
                                    <?php esc_html_e('Cron', 'ams-wc-amazon'); ?>
                                </span>
                                <input type="text" class="form-control font-monospace" id="cron-command" value="wget -q -O - <?php echo esc_url(get_bloginfo('wpurl')); ?>/wp-cron.php?doing_wp_cron >/dev/null 2>&1" readonly>
                                <button class="btn btn-outline-primary btn-sm" type="button" id="copy-cron-command" data-bs-toggle="tooltip" title="<?php esc_attr_e('Copy', 'ams-wc-amazon'); ?>">
                                    <i class="bi bi-clipboard"></i>
                                </button>
                                <button class="btn btn-outline-secondary btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#cronGuideModal">
                                    <i class="bi bi-info-circle"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Automation Options -->
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-circle p-2 me-3">
                                    <i class="bi bi-sliders text-primary"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0 fw-semibold text-dark"><?php esc_html_e('Update Options', 'ams-wc-amazon'); ?></h6>
                                    <small class="text-muted"><?php esc_html_e('Choose which product data to update automatically', 'ams-wc-amazon'); ?></small>
                                </div>
                            </div>
                            <div class="accordion shadow-sm" id="updateOptionsAccordion">
                                <!-- Basic Info -->
                                <div class="accordion-item border-0">
                                    <h2 class="accordion-header" id="headingBasic">
                                        <button class="accordion-button collapsed bg-light fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseBasic" aria-expanded="false" aria-controls="collapseBasic">
                                            <i class="bi bi-info-circle text-primary me-2"></i>
                                            <?php esc_html_e('Basic Info', 'ams-wc-amazon'); ?> 
                                            <span class="badge bg-primary ms-2"><?php echo ($this->get_option('product_name_cron')==='1' ? 1 : 0) + ($this->get_option('product_price_cron')==='1' ? 1 : 0) + ($this->get_option('product_sku_cron')==='1' ? 1 : 0); ?>/3</span>
                                        </button>
                                    </h2>
                                    <div id="collapseBasic" class="accordion-collapse collapse" aria-labelledby="headingBasic" data-bs-parent="#updateOptionsAccordion">
                                        <div class="accordion-body bg-light bg-opacity-50">
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_name_cron"><?php esc_html_e('Product Name', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update product titles automatically', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_name_cron" id="product_name_cron" value="1" <?php checked($this->get_option('product_name_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_price_cron"><?php esc_html_e('Product Price', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Keep prices synchronized with Amazon', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_price_cron" id="product_price_cron" value="1" <?php checked($this->get_option('product_price_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_sku_cron"><?php esc_html_e('Product SKU', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update product SKU codes', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_sku_cron" id="product_sku_cron" value="1" <?php checked($this->get_option('product_sku_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Content & Media -->
                                <div class="accordion-item border-0">
                                    <h2 class="accordion-header" id="headingContent">
                                        <button class="accordion-button collapsed bg-light fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseContent" aria-expanded="false" aria-controls="collapseContent">
                                            <i class="bi bi-file-text text-success me-2"></i>
                                            <?php esc_html_e('Content & Media', 'ams-wc-amazon'); ?> 
                                            <span class="badge bg-success ms-2"><?php echo ($this->get_option('product_description_cron')==='1' ? 1 : 0) + ($this->get_option('product_image_cron')==='1' ? 1 : 0) + ($this->get_option('product_category_cron')==='1' ? 1 : 0); ?>/3</span>
                                        </button>
                                    </h2>
                                    <div id="collapseContent" class="accordion-collapse collapse" aria-labelledby="headingContent" data-bs-parent="#updateOptionsAccordion">
                                        <div class="accordion-body bg-light bg-opacity-50">
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_description_cron"><?php esc_html_e('Product Description', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update product descriptions from Amazon', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_description_cron" id="product_description_cron" value="1" <?php checked($this->get_option('product_description_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_image_cron"><?php esc_html_e('Product Image', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Sync product images with Amazon', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_image_cron" id="product_image_cron" value="1" <?php checked($this->get_option('product_image_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_category_cron"><?php esc_html_e('Product Category', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update product categories automatically', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_category_cron" id="product_category_cron" value="1" <?php checked($this->get_option('product_category_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Variants -->
                                <div class="accordion-item border-0">
                                    <h2 class="accordion-header" id="headingVariants">
                                        <button class="accordion-button collapsed bg-light fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseVariants" aria-expanded="false" aria-controls="collapseVariants">
                                            <i class="bi bi-layers text-warning me-2"></i>
                                            <?php esc_html_e('Variants', 'ams-wc-amazon'); ?> 
                                            <span class="badge bg-warning ms-2"><?php echo ($this->get_option('product_variants_cron')==='1' ? 1 : 0) + ($this->get_option('product_variant_image_cron')==='1' ? 1 : 0) + ($this->get_option('product_variant_description_cron')==='1' ? 1 : 0); ?>/3</span>
                                        </button>
                                    </h2>
                                    <div id="collapseVariants" class="accordion-collapse collapse" aria-labelledby="headingVariants" data-bs-parent="#updateOptionsAccordion">
                                        <div class="accordion-body bg-light bg-opacity-50">
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_variants_cron"><?php esc_html_e('Product Variants', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update product variations and options', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_variants_cron" id="product_variants_cron" value="1" <?php checked($this->get_option('product_variants_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_variant_image_cron"><?php esc_html_e('Product Variant Image', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Sync variant images with Amazon', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_variant_image_cron" id="product_variant_image_cron" value="1" <?php checked($this->get_option('product_variant_image_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_variant_description_cron"><?php esc_html_e('Product Variant Description', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Update variant descriptions automatically', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_variant_description_cron" id="product_variant_description_cron" value="1" <?php checked($this->get_option('product_variant_description_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Status & Reviews -->
                                <div class="accordion-item border-0">
                                    <h2 class="accordion-header" id="headingStatus">
                                        <button class="accordion-button collapsed bg-light fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseStatus" aria-expanded="false" aria-controls="collapseStatus">
                                            <i class="bi bi-star text-info me-2"></i>
                                            <?php esc_html_e('Status & Reviews', 'ams-wc-amazon'); ?> 
                                            <span class="badge bg-info ms-2"><?php echo ($this->get_option('product_out_of_stock_cron')==='1' ? 1 : 0) + ($this->get_option('product_review_cron')==='1' ? 1 : 0); ?>/2</span>
                                        </button>
                                    </h2>
                                    <div id="collapseStatus" class="accordion-collapse collapse" aria-labelledby="headingStatus" data-bs-parent="#updateOptionsAccordion">
                                        <div class="accordion-body bg-light bg-opacity-50">
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded mb-3">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_out_of_stock_cron"><?php esc_html_e('Product Out Of Stock', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Monitor and update stock status', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_out_of_stock_cron" id="product_out_of_stock_cron" value="1" <?php checked($this->get_option('product_out_of_stock_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between p-3 bg-white rounded">
                                                <div>
                                                    <label class="fw-medium text-dark mb-1" for="product_review_cron"><?php esc_html_e('Product Review', 'ams-wc-amazon'); ?></label>
                                                    <small class="text-muted d-block"><?php esc_html_e('Sync product reviews from Amazon', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <label class="ams-common-toggle-switch">
                                                    <input type="checkbox" name="product_review_cron" id="product_review_cron" value="1" <?php checked($this->get_option('product_review_cron'), '1'); ?>>
                                                    <span class="ams-common-toggle-slider ams-common-toggle-round"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Save Button -->
                        <div class="d-grid mt-4">
                            <button type="submit" name="general-setting-submit" id="general-setting-submit-cron" class="btn btn-primary btn-lg py-3 fw-semibold">
                                <i class="bi bi-floppy me-2"></i>
                                <?php esc_html_e('Save Automation Settings', 'ams-wc-amazon'); ?>
                            </button>
                        </div>

                        <input type="hidden" name="action" value="<?php echo esc_attr('ams_product_cron'); ?>">
                        <input type="hidden" name="action_tab" value="pills-az-products-tab">
                        <?php wp_nonce_field("general_setting_nonce", "cron_setting_nonce") ?>
                    </form>
                </div>
            </div>
        </div>

        <!-- Right Column: Enhanced Console -->
        <div class="col-lg-6">
            <?php
                global $wpdb;
                @$product_name_cron = get_option('product_name_cron');
                @$product_price_cron = get_option('product_price_cron');
                @$product_sku_cron = get_option('product_sku_cron');
                @$product_variants_cron = get_option('product_variants_cron');
                @$product_variant_image_cron = get_option('product_variant_image_cron');
                @$product_variant_description_cron = get_option('product_variant_description_cron');
                @$product_out_of_stock_cron = get_option('product_out_of_stock_cron');
                @$product_description_cron = get_option('product_description_cron');
                @$product_image_cron = get_option('product_image_cron');
                @$product_category_cron = get_option('product_category_cron');
                @$product_review_cron = get_option('product_review_cron');
                @$product_tags_cron = get_option('product_tags_cron');

                @$asins = ams_get_all_products_info();
                @$id_asin = (is_array($asins['id'])) ? array_combine( $asins['id'], $asins['asin'] ) : array();
                @$import_id = $asins['product_id'];
                @$ids_bunch = array_chunk( $id_asin, 1, true);
                $url = 'ams_product_availability';
                $region = null;
                if(isset($import_ids['method']) && $import_ids['method'] == 1){
                    $url = 'ams_product_availability';
                } else if(isset($import_ids['method']) && $import_ids['method'] == 2){
                    $url = 'ams_product_availability';
                }
            ?>
            <div class="card border-0 shadow-sm h-100 ams-common-card-fix">
                <div class="card-header bg-dark text-white border-0 py-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="bg-warning bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 48px; height: 48px;">
                                <i class="bi bi-terminal text-warning fs-4"></i>
                            </div>
                            <div>
                                <h5 class="mb-1 fw-bold text-white"><?php esc_html_e('Product Update Console', 'ams-wc-amazon'); ?></h5>
                                <p class="mb-0 text-white text-opacity-75 small"><?php esc_html_e('Monitor and control automated updates', 'ams-wc-amazon'); ?></p>
                            </div>
                        </div>
                        <button id="prod_cron" class="btn btn-warning btn-sm px-3 py-2" onclick="cron_run();">
                            <i class="bi bi-play me-2"></i>
                            <?php esc_html_e('Start Update', 'ams-wc-amazon'); ?>
                        </button>
                    </div>
                </div>
                
                <div class="card-body bg-dark p-0 d-flex flex-column flex-grow-1">
                    <div id="console-window" class="text-light p-3 flex-grow-1" style="height: 300px; overflow-y: auto; font-family: 'Courier New', monospace; font-size: 0.875rem;">
                        <div id="console-output"></div>
                    </div>
                    <div class="bg-dark p-2 border-top border-secondary">
                        <div class="progress mb-2" style="height: 6px;">
                            <div id="progress-bar" class="progress-bar bg-success" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-light" id="status-message"><?php esc_html_e('Ready to start update process', 'ams-wc-amazon'); ?></small>
                            <small class="text-light" id="product-count">0 / <?php echo esc_html($asins['products_count']); ?> <?php esc_html_e('products', 'ams-wc-amazon'); ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
            </div>
        </div>
    </div>
</div>

<!-- Right side scripts -->
<script type="text/javascript">
    var cronIndex = 0;
    var count = 0;
    var idArr = [];
    var import_id = <?php echo json_encode($import_id); ?>;
    var total_products = <?php echo $asins['products_count']; ?>;

    // Function to update setting box appearance immediately
    function updateSettingBox(optionName, isEnabled) {
        const settingBox = document.getElementById('setting-box-' + optionName);
        const icon = settingBox.querySelector('i');
        const label = settingBox.querySelector('small');
        
        if (isEnabled) {
            // Enable state - green theme
            settingBox.className = 'd-flex justify-content-between align-items-center p-2 rounded bg-success bg-opacity-10 border border-success border-opacity-25';
            icon.className = 'bi bi-check-circle text-success me-2';
            label.className = 'fw-bold text-success';
        } else {
            // Disable state - light theme
            settingBox.className = 'd-flex justify-content-between align-items-center p-2 rounded bg-light border border-light';
            icon.className = 'bi bi-x-circle text-muted me-2';
            label.className = 'text-muted fw-medium';
        }
    }

    function cron_run() {
        cronIndex = 0;
        count = 0;
        idArr = <?php echo json_encode($ids_bunch); ?>;
        
        // Clear the console
        jQuery('#console-output').empty();
        
        updateConsole('Initializing cron job...', 'text-info');
        jQuery('#prod_cron').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Running').attr('disabled', true);
        jQuery('#status-message').text('Cron job in progress');
        updateProgress(0);
        run_cron_single_bunch(idArr[cronIndex]);
    }

    function run_cron_single_bunch(id_array) {
        if (!id_array || Object.keys(id_array).length === 0) {
            finishCron();
            return;
        }

        var pid = Object.keys(id_array)[0];
        var url = 'ams_product_availability';
        var region = asin = product_url = '';
        
        if (import_id[pid]) {
            if (import_id[pid]['method'] == 1) {
                url = 'ams_product_import';
                region = import_id[pid]['region'];
                asin = id_array[pid];
            } else {
                url = 'ams_product_availability';
                region = import_id[pid]['region'];
                asin = id_array[pid];
            }
            product_url = import_id[pid]['url'];
        }
        
        var data = {data:id_array, action:url, region:region, is_cron:'1', asin:asin, prod_id:pid, product_url:product_url};
        
        updateConsole(`Processing product ID: ${pid}`, 'text-warning');
        
        jQuery.ajax({
            url: "<?php echo admin_url("admin-ajax.php") ?>",
            type: 'POST',
            data: data,
            success: function(data) {
                count += Object.keys(id_array).length;
                updateProgress((count / total_products) * 100);
                updateProductCount(count);
                updateConsole(data, 'text-success');
                
                cronIndex++;
                if (idArr[cronIndex]) {
                    run_cron_single_bunch(idArr[cronIndex]);
                } else {
                    finishCron();
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                updateConsole(`Error updating product ID: ${pid}. ${textStatus}`, 'text-danger');
                cronIndex++;
                if (idArr[cronIndex]) {
                    run_cron_single_bunch(idArr[cronIndex]);
                } else {
                    finishCron();
                }
            }
        });
    }

    function updateConsole(message, className = '') {
        var timestamp = new Date().toLocaleTimeString();
        jQuery('#console-output').append(`<div class="${className}">[${timestamp}] ${message}</div>`);
        jQuery('#console-window').scrollTop(jQuery('#console-window')[0].scrollHeight);
    }

    function updateProgress(percentage) {
        jQuery('#progress-bar').css('width', percentage + '%').attr('aria-valuenow', percentage);
    }

    function updateProductCount(count) {
        jQuery('#product-count').text(`${count} / ${total_products} <?php esc_html_e('products updated', 'ams-wc-amazon'); ?>`);
    }

    function finishCron() {
        updateConsole('Cron job completed.', 'text-info font-weight-bold');
        jQuery('#prod_cron').html('<?php esc_html_e('Start Cron', 'ams-wc-amazon'); ?>').removeAttr('disabled');
        jQuery('#status-message').text('<?php esc_html_e('Cron job completed', 'ams-wc-amazon'); ?>');
        updateProgress(100);
    }

    // Add event listener for page unload
    window.addEventListener('beforeunload', function (e) {
        if (cronIndex > 0 && cronIndex < idArr.length) {
            e.preventDefault();
            e.returnValue = '';
        }
    });
</script>
<!-- Right side scripts -->


<!-- Left side scripts -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy functionality for cron command
    const copyButton = document.getElementById('copy-cron-command');
    const cronCommand = document.getElementById('cron-command');

    if (copyButton && cronCommand) {
        const tooltip = new bootstrap.Tooltip(copyButton);

        copyButton.addEventListener('click', function() {
            cronCommand.select();
            document.execCommand('copy');
            
            copyButton.setAttribute('data-bs-original-title', '<?php esc_attr_e('Copied!', 'ams-wc-amazon'); ?>');
            tooltip.show();
            
            setTimeout(() => {
                copyButton.setAttribute('data-bs-original-title', '<?php esc_attr_e('Copy to clipboard', 'ams-wc-amazon'); ?>');
                tooltip.hide();
            }, 2000);
        });
    }

    // Initialize all tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
<!-- Left side scripts -->


<!-- Cron Guide Modal -->
<div class="modal fade" id="cronGuideModal" tabindex="-1" aria-labelledby="cronGuideModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cronGuideModalLabel"><?php esc_html_e('How to Set Up Cron Jobs', 'ams-wc-amazon'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Instructions for WP Crontrol -->
                <h6 class="text-primary mb-3">
                    <?php esc_html_e('Option 1: Using WP Crontrol Plugin (Recommended)', 'ams-wc-amazon'); ?>
                </h6>
                <ol>
                    <li>
                        <strong><?php esc_html_e('Install WP Crontrol Plugin:', 'ams-wc-amazon'); ?></strong>
                        <ul>
                            <li><?php esc_html_e('Go to your WordPress admin panel.', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Navigate to Plugins > Add New.', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Search for "WP Crontrol" and install it.', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Activate the plugin.', 'ams-wc-amazon'); ?></li>
                        </ul>
                    </li>
                    <li>
                        <strong><?php esc_html_e('View and Manage Cron Events:', 'ams-wc-amazon'); ?></strong>
                        <ul>
                            <li><?php esc_html_e('Go to Tools > Cron Events in your WordPress admin.', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Locate "ams_daily_cron_event" in the list of scheduled events.', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Ensure it is set to run daily. If needed, you can edit the schedule.', 'ams-wc-amazon'); ?></li>
                        </ul>
                    </li>
                </ol>
                <p class="text-muted">
                    <?php esc_html_e('This method relies on WordPress to handle scheduled tasks automatically.', 'ams-wc-amazon'); ?>
                </p>

                <hr class="my-4">

                <!-- Instructions for Server-Side Cron -->
                <h6 class="text-primary mb-3">
                    <?php esc_html_e('Option 2: Setting Up Server-Side Cron Job', 'ams-wc-amazon'); ?>
                </h6>
                <ol>
                    <li>
                        <strong><?php esc_html_e('Disable WordPress Default Cron:', 'ams-wc-amazon'); ?></strong>
                        <ul>
                            <li><?php esc_html_e('Open your wp-config.php file.', 'ams-wc-amazon'); ?></li>
                            <li>
                                <?php esc_html_e('Add the following line of code:', 'ams-wc-amazon'); ?>
                                <pre><code>define('DISABLE_WP_CRON', true);</code></pre>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <strong><?php esc_html_e('Set Up Cron Job on Server:', 'ams-wc-amazon'); ?></strong>
                        <ul>
                            <li><?php esc_html_e('Log into your hosting control panel (e.g., cPanel).', 'ams-wc-amazon'); ?></li>
                            <li><?php esc_html_e('Navigate to the "Cron Jobs" or "Scheduled Tasks" section.', 'ams-wc-amazon'); ?></li>
                            <li>
                                <?php esc_html_e('Add the following command:', 'ams-wc-amazon'); ?>
                                <pre><code>wget -q -O - <?php echo esc_url(get_bloginfo('wpurl')); ?>/wp-cron.php?doing_wp_cron >/dev/null 2>&1</code></pre>
                            </li>
                            <li><?php esc_html_e('Set the interval to run once daily and save the cron job.', 'ams-wc-amazon'); ?></li>
                        </ul>
                    </li>
                </ol>
                <p class="text-muted">
                    <?php esc_html_e('This method ensures tasks are handled directly by your server, making it more reliable for high-traffic websites.', 'ams-wc-amazon'); ?>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <?php esc_html_e('Close', 'ams-wc-amazon'); ?>
                </button>
            </div>
        </div>
    </div>
</div>
<!-- Cron Guide Modal -->


<!-- Cron settings show/hide eye icon-->
<script>
    function toggleVisibility(inputId, iconClass) {
        var passwordInput = document.getElementById(inputId);
        var passwordIcon = document.querySelector('.' + iconClass);
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            passwordIcon.classList.remove('fa-eye');
            passwordIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            passwordIcon.classList.remove('fa-eye-slash');
            passwordIcon.classList.add('fa-eye');
        }
    }
</script>
<!-- Cron settings show/hide eye icon-->




<!-- Proxy section script -->
<script>
(function($) {
    $(document).ready(function() {
        function testAPI(buttonId, responseId, action) {
            $(buttonId).on('click', function(e) {
                e.preventDefault();
                let _this = $(this);
                _this.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Testing...');

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: { action: action },
                    success: function(response) {
                        var $responseEl = $(responseId);
                        $responseEl.removeClass('d-none alert-primary alert-success alert-danger');
                        
                        if (response.status) {
                            $responseEl.addClass('alert-success');
                        } else {
                            $responseEl.addClass('alert-danger');
                        }
                        
                        $responseEl.html(response.message).fadeIn();
                        _this.prop('disabled', false).html('Test');
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                        $(responseId)
                            .removeClass('d-none alert-primary alert-success')
                            .addClass('alert-danger')
                            .html('<small>An unexpected error occurred. Please try again.</small>')
                            .fadeIn();
                        _this.prop('disabled', false).html('Test');
                    }
                });
            });
        }

        testAPI('#test-it', '#test-it-response', 'scraper_api_test_code');
        testAPI('#test-scrapingant', '#test-scrapingant-response', 'scrapingant_test_code');
        testAPI('#test-decodo', '#test-decodo-response', 'decodo_api_test_code');
    });
})(jQuery);
</script>
<!-- Proxy section script -->

<!-- API Help Modal -->
<div class="modal fade" id="apiHelpModal" tabindex="-1" aria-labelledby="apiHelpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <div class="icon-shape bg-white text-primary rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                        <i class="bi bi-question-circle"></i>
                    </div>
                    <div>
                        <h5 class="modal-title mb-1" id="apiHelpModalLabel">
                            <?php esc_html_e('How to Get Amazon API Keys', 'ams-wc-amazon'); ?>
                        </h5>
                        <small class="text-white-50">Step-by-step guide to obtain your Amazon Product Advertising API credentials</small>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-list-ol me-2"></i>
                            <?php esc_html_e('Step-by-Step Process', 'ams-wc-amazon'); ?>
                        </h6>
                        <ol class="list-group list-group-numbered">
                            <li class="list-group-item border-0 ps-0">
                                <strong><?php esc_html_e('Create Amazon Associates Account', 'ams-wc-amazon'); ?></strong>
                                <p class="text-muted small mb-0">Sign up for Amazon Associates program in your target country</p>
                            </li>
                            <li class="list-group-item border-0 ps-0">
                                <strong><?php esc_html_e('Apply for Product Advertising API', 'ams-wc-amazon'); ?></strong>
                                <p class="text-muted small mb-0">Request API access through your Associates dashboard</p>
                            </li>
                            <li class="list-group-item border-0 ps-0">
                                <strong><?php esc_html_e('Get Your Credentials', 'ams-wc-amazon'); ?></strong>
                                <p class="text-muted small mb-0">Receive Access Key ID and Secret Access Key</p>
                            </li>
                            <li class="list-group-item border-0 ps-0">
                                <strong><?php esc_html_e('Note Your Associate Tag', 'ams-wc-amazon'); ?></strong>
                                <p class="text-muted small mb-0">Find your unique Associate Tag in your dashboard</p>
                            </li>
                        </ol>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-link me-2"></i>
                            <?php esc_html_e('Quick Links', 'ams-wc-amazon'); ?>
                        </h6>
                        <div class="d-grid gap-2">
                            <a href="https://affiliate-program.amazon.com/" target="_blank" class="btn btn-outline-primary">
                                <i class="bi bi-box-arrow-up-right me-2"></i>
                                <?php esc_html_e('Amazon Associates Program', 'ams-wc-amazon'); ?>
                            </a>
                            <a href="https://webservices.amazon.com/paapi5/documentation/" target="_blank" class="btn btn-outline-info">
                                <i class="bi bi-book me-2"></i>
                                <?php esc_html_e('API Documentation', 'ams-wc-amazon'); ?>
                            </a>
                            <a href="https://webservices.amazon.com/paapi5/documentation/getting-started.html" target="_blank" class="btn btn-outline-success">
                                <i class="bi bi-rocket me-2"></i>
                                <?php esc_html_e('Getting Started Guide', 'ams-wc-amazon'); ?>
                            </a>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong><?php esc_html_e('Important Note:', 'ams-wc-amazon'); ?></strong>
                            <p class="mb-0 small"><?php esc_html_e('API access is free for Associates, but you must meet certain requirements and follow Amazon\'s terms of service.', 'ams-wc-amazon'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x me-2"></i>
                    <?php esc_html_e('Close', 'ams-wc-amazon'); ?>
                </button>
                <a href="https://affiliate-program.amazon.com/" target="_blank" class="btn btn-primary">
                    <i class="bi bi-box-arrow-up-right me-2"></i>
                    <?php esc_html_e('Get Started Now', 'ams-wc-amazon'); ?>
                </a>
            </div>
        </div>
    </div>
</div>

<script>
// Enhanced API Settings JavaScript
(function() {
        function initAutoCurrency() {
        // Auto-currency selection when country changes
        // Target the specific fields in the settings form, not any duplicate fields
        const countrySelect = document.querySelector('#pills-az-settings select[name="ams_amazon_country"]');
        const currencySelect = document.querySelector('#pills-az-settings select[name="woocommerce_currency"]');
        const statusText = document.querySelector('#currency-status-text');
        
        if (countrySelect && currencySelect) {
            // Currency mapping for Amazon regions
            const currencyMap = {
                'com.au': 'AUD', // Australia
                'com.br': 'BRL', // Brazil
                'ca': 'CAD',      // Canada
                'cn': 'CNY',      // China
                'fr': 'EUR',      // France
                'de': 'EUR',      // Germany
                'in': 'INR',      // India
                'it': 'EUR',      // Italy
                'jp': 'JPY',      // Japan
                'mx': 'MXN',      // Mexico
                'nl': 'EUR',      // Netherlands
                'sa': 'SAR',      // Saudi Arabia
                'sg': 'SGD',      // Singapore
                'es': 'EUR',      // Spain
                'com.tr': 'TRY',  // Turkey
                'ae': 'AED',      // United Arab Emirates
                'co.uk': 'GBP',   // United Kingdom
                'com': 'USD',     // United States
                'pl': 'PLN'       // Poland
            };

            // Function to update currency based on selected country
            function updateCurrency() {
                const selectedCountry = countrySelect.value;
                const targetCurrency = currencyMap[selectedCountry];
                
                if (targetCurrency) {
                    // Find and select the matching currency option
                    for (let i = 0; i < currencySelect.options.length; i++) {
                        if (currencySelect.options[i].value === targetCurrency) {
                            currencySelect.selectedIndex = i;
                            
                            // Add visual feedback
                            currencySelect.classList.add('border-success');
                            setTimeout(() => {
                                currencySelect.classList.remove('border-success');
                            }, 2000);
                            
                            // Show notification only if currency actually changed
                            if (currencySelect.value !== targetCurrency) {
                                const notification = document.createElement('div');
                                notification.className = 'alert alert-info alert-dismissible fade show mt-2';
                                notification.innerHTML = `
                                    <i class="bi bi-info-circle me-2"></i>
                                    <strong>Currency Updated:</strong> Store currency has been automatically set to ${targetCurrency} for ${countrySelect.options[countrySelect.selectedIndex].text}.
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                `;
                                
                                // Insert notification after the currency field
                                const currencyRow = currencySelect.closest('.row');
                                if (currencyRow) {
                                    currencyRow.parentNode.insertBefore(notification, currencyRow.nextSibling);
                                }
                            }
                            break;
                        }
                    }
                }
            }

            // Add event listener for country change
            countrySelect.addEventListener('change', updateCurrency);
            
            // Initialize currency as disabled (read-only)
            currencySelect.disabled = true;
            statusText.textContent = 'Currency is automatically set based on the selected Amazon country.';
            
            // Also update on page load if country is already selected
            if (countrySelect.value) {
                updateCurrency();
            }
        }
    }

    // Initialize only once when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initAutoCurrency);
    } else {
        initAutoCurrency();
    }
})();

document.addEventListener('DOMContentLoaded', function() {
    // Password visibility toggle function
    window.toggleVisibility = function(inputId, iconId) {
        const input = document.getElementById(inputId);
        const icon = document.querySelector('.' + iconId);
        
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    };

    // Form validation removed - Allow saving empty values to clear API settings
});
</script>

<!-- API Error Reference Modal -->
<div class="modal fade" id="apiErrorReferenceModal" tabindex="-1" aria-labelledby="apiErrorReferenceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <h5 class="modal-title text-white fw-bold" id="apiErrorReferenceModalLabel" style="text-shadow: 0 2px 4px rgba(0,0,0,0.3);">
                    <i class="bi bi-book-open me-2"></i>
                    <?php esc_html_e('Amazon API Error Reference', 'ams-wc-amazon'); ?>
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <div class="alert alert-primary border-0 bg-light-primary mb-4">
                    <i class="bi bi-lightbulb me-2 text-primary"></i>
                    <strong class="text-primary"><?php esc_html_e('Quick Guide:', 'ams-wc-amazon'); ?></strong>
                    <span class="text-muted"><?php esc_html_e('This reference covers all possible Amazon API errors and their solutions. Use the search function to quickly find your specific error.', 'ams-wc-amazon'); ?></span>
                </div>
                
                <!-- Search Box -->
                <div class="mb-4">
                    <div class="input-group input-group-lg shadow-sm">
                        <span class="input-group-text bg-white border-end-0">
                            <i class="bi bi-search text-muted"></i>
                        </span>
                        <input type="text" class="form-control border-start-0" id="errorSearchInput" placeholder="<?php esc_attr_e('Search for specific errors...', 'ams-wc-amazon'); ?>">
                        <button class="btn btn-outline-secondary border-start-0" type="button" id="clearSearch">
                            <i class="bi bi-x"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Error Categories -->
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <div class="card h-100 border-0 shadow-sm hover-lift cursor-pointer" data-category="critical">
                            <div class="card-body text-center p-3">
                                <div class="bg-danger bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-exclamation-circle text-danger" style="font-size: 1.5rem;"></i>
                                </div>
                                <h6 class="card-title mb-2 text-danger"><?php esc_html_e('Critical Errors', 'ams-wc-amazon'); ?></h6>
                                <small class="text-muted"><?php esc_html_e('Invalid credentials, rate limiting', 'ams-wc-amazon'); ?></small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card h-100 border-0 shadow-sm hover-lift cursor-pointer" data-category="store">
                            <div class="card-body text-center p-3">
                                <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-shop text-warning" style="font-size: 1.5rem;"></i>
                                </div>
                                <h6 class="card-title mb-2 text-warning"><?php esc_html_e('Store Issues', 'ams-wc-amazon'); ?></h6>
                                <small class="text-muted"><?php esc_html_e('Wrong country, parameter errors', 'ams-wc-amazon'); ?></small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card h-100 border-0 shadow-sm hover-lift cursor-pointer" data-category="network">
                            <div class="card-body text-center p-3">
                                <div class="bg-info bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-wifi text-info" style="font-size: 1.5rem;"></i>
                                </div>
                                <h6 class="card-title mb-2 text-info"><?php esc_html_e('Network Issues', 'ams-wc-amazon'); ?></h6>
                                <small class="text-muted"><?php esc_html_e('Connection problems', 'ams-wc-amazon'); ?></small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card h-100 border-0 shadow-sm hover-lift cursor-pointer" data-category="solutions">
                            <div class="card-body text-center p-3">
                                <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-lightbulb text-success" style="font-size: 1.5rem;"></i>
                                </div>
                                <h6 class="card-title mb-2 text-success"><?php esc_html_e('Quick Fixes', 'ams-wc-amazon'); ?></h6>
                                <small class="text-muted"><?php esc_html_e('Common solutions', 'ams-wc-amazon'); ?></small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Error Reference Table -->
                <div class="table-responsive">
                    <table class="table table-hover border-0" id="errorReferenceTable">
                        <thead class="bg-light-primary">
                            <tr>
                                <th scope="col" style="width: 20%;" class="border-0 text-primary fw-bold">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <?php esc_html_e('Error Type', 'ams-wc-amazon'); ?>
                                </th>
                                <th scope="col" style="width: 30%;" class="border-0 text-primary fw-bold">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <?php esc_html_e('Description', 'ams-wc-amazon'); ?>
                                </th>
                                <th scope="col" style="width: 50%;" class="border-0 text-primary fw-bold">
                                    <i class="bi bi-tools me-2"></i>
                                    <?php esc_html_e('Solution Steps', 'ams-wc-amazon'); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Store Mismatch Errors -->
                            <tr class="border-0" data-category="store">
                                <td class="border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-warning bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                            <i class="bi bi-shop text-warning"></i>
                                        </div>
                                        <div>
                                            <strong class="text-warning d-block"><?php esc_html_e('Store Mismatch', 'ams-wc-amazon'); ?></strong>
                                            <small class="text-muted"><?php esc_html_e('Wrong country/region', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-0"><?php esc_html_e('Your credentials are valid but not authorized for the selected Amazon country/region.', 'ams-wc-amazon'); ?></td>
                                <td class="border-0">
                                    <ol class="mb-0 ps-3">
                                        <li class="mb-1"><?php esc_html_e('Visit your Amazon Associates account for the correct country', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Change the country selection in settings', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Verify your Associate Tag is approved for that region', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Rate Limiting -->
                            <tr class="border-0" data-category="critical">
                                <td class="border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-danger bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                            <i class="bi bi-clock text-danger"></i>
                                        </div>
                                        <div>
                                            <strong class="text-danger d-block"><?php esc_html_e('Rate Limiting', 'ams-wc-amazon'); ?></strong>
                                            <small class="text-muted"><?php esc_html_e('Too many requests', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-0"><?php esc_html_e('Too many API requests in a short time period. Amazon limits requests to prevent abuse.', 'ams-wc-amazon'); ?></td>
                                <td class="border-0">
                                    <ol class="mb-0 ps-3">
                                        <li class="mb-1"><?php esc_html_e('Wait 5-10 minutes before testing again', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Reduce the frequency of API calls', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Check your daily API usage limits', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Invalid Access Key -->
                            <tr class="border-0" data-category="critical">
                                <td class="border-0">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-danger bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                            <i class="bi bi-key text-danger"></i>
                                        </div>
                                        <div>
                                            <strong class="text-danger d-block"><?php esc_html_e('Invalid Access Key', 'ams-wc-amazon'); ?></strong>
                                            <small class="text-muted"><?php esc_html_e('Wrong or expired key', 'ams-wc-amazon'); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-0"><?php esc_html_e('Your Access Key ID is incorrect, expired, or doesn\'t exist.', 'ams-wc-amazon'); ?></td>
                                <td class="border-0">
                                    <ol class="mb-0 ps-3">
                                        <li class="mb-1"><?php esc_html_e('Check the Access Key ID format (should be 20 characters)', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Generate new credentials in your Associates account', 'ams-wc-amazon'); ?></li>
                                        <li class="mb-1"><?php esc_html_e('Verify the key exists in your Associates dashboard', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Invalid Secret Key -->
                            <tr class="table-danger" data-category="critical">
                                <td>
                                    <strong class="text-danger">
                                        <i class="bi bi-lock me-1"></i>
                                        <?php esc_html_e('Invalid Secret Key', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Your Secret Access Key is incorrect or doesn\'t match the Access Key.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Verify the Secret Key format (should be 40 characters)', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Generate new credentials in your Associates account', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Check for typos or extra spaces', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Invalid Associate Tag -->
                            <tr class="table-danger" data-category="critical">
                                <td>
                                    <strong class="text-danger">
                                        <i class="bi bi-tag me-1"></i>
                                        <?php esc_html_e('Invalid Associate Tag', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Your Associate Tag doesn\'t exist or is not valid for the selected region.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Check the Associate Tag format in your dashboard', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Verify it exists in your Associates account', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Use the correct tag for the selected region', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Network Error -->
                            <tr class="table-info" data-category="network">
                                <td>
                                    <strong class="text-info">
                                        <i class="bi bi-wifi me-1"></i>
                                        <?php esc_html_e('Network Error', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Connection to Amazon API failed due to network issues.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Check your internet connection', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Verify firewall settings allow API calls', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Try again later when connection is stable', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Signature Error -->
                            <tr class="table-danger" data-category="critical">
                                <td>
                                    <strong class="text-danger">
                                        <i class="bi bi-shield me-1"></i>
                                        <?php esc_html_e('Signature Error', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Request signing failed due to authentication issues.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Check your Secret Access Key is correct', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Verify your system time is accurate', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Regenerate your API credentials', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Invalid Marketplace -->
                            <tr class="table-warning" data-category="store">
                                <td>
                                    <strong class="text-warning">
                                        <i class="bi bi-globe me-1"></i>
                                        <?php esc_html_e('Invalid Marketplace', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('The selected country is not supported or not available for Associates.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Choose a supported Amazon country', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Check Associates availability for that region', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Use a different region where Associates is available', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Invalid Parameters -->
                            <tr class="table-warning" data-category="store">
                                <td>
                                    <strong class="text-warning">
                                        <i class="bi bi-gear me-1"></i>
                                        <?php esc_html_e('Invalid Parameters', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Request parameters are incorrect or missing required fields.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Check your country selection is correct', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Verify your Associate Tag format', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Use the correct marketplace for your region', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Unauthorized -->
                            <tr class="table-danger" data-category="critical">
                                <td>
                                    <strong class="text-danger">
                                        <i class="bi bi-person-x me-1"></i>
                                        <?php esc_html_e('Unauthorized', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('Your credentials are not approved for API access.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Apply for Product Advertising API access', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Wait for Amazon approval (can take days)', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Contact Amazon Associates support', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                            
                            <!-- Quota Exceeded -->
                            <tr class="table-danger" data-category="critical">
                                <td>
                                    <strong class="text-danger">
                                        <i class="bi bi-graph-up me-1"></i>
                                        <?php esc_html_e('Quota Exceeded', 'ams-wc-amazon'); ?>
                                    </strong>
                                </td>
                                <td><?php esc_html_e('You have reached your daily API request limit.', 'ams-wc-amazon'); ?></td>
                                <td>
                                    <ol class="mb-0">
                                        <li><?php esc_html_e('Wait until tomorrow when limits reset', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Reduce your API usage frequency', 'ams-wc-amazon'); ?></li>
                                        <li><?php esc_html_e('Consider upgrading your Associates plan', 'ams-wc-amazon'); ?></li>
                                    </ol>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Quick Tips Section -->
                <div class="mt-4 p-4 bg-gradient-light rounded-3 border-0 shadow-sm">
                    <h6 class="text-primary mb-4 d-flex align-items-center">
                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                            <i class="bi bi-lightbulb text-primary"></i>
                        </div>
                        <?php esc_html_e('Quick Troubleshooting Tips', 'ams-wc-amazon'); ?>
                    </h6>
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="card border-0 bg-white bg-opacity-50 h-100">
                                <div class="card-body p-3">
                                    <h6 class="text-success mb-3">
                                        <i class="bi bi-check-circle me-2"></i>
                                        <?php esc_html_e('Common Solutions', 'ams-wc-amazon'); ?>
                                    </h6>
                                    <ul class="list-unstyled mb-0">
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-success me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('Most Common Fix:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('Change your country selection to match your Associates account', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-success me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('Credential Check:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('Verify all three fields: Access Key, Secret Key, and Associate Tag', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-success me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('Wait Strategy:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('If you get rate limiting, wait 5-10 minutes before retrying', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-0 bg-white bg-opacity-50 h-100">
                                <div class="card-body p-3">
                                    <h6 class="text-info mb-3">
                                        <i class="bi bi-info-circle me-2"></i>
                                        <?php esc_html_e('Account Setup', 'ams-wc-amazon'); ?>
                                    </h6>
                                    <ul class="list-unstyled mb-0">
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-info me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('Account Verification:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('Ensure your Associates account is approved and active', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-info me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('API Access:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('Make sure you have Product Advertising API access approved', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                        <li class="mb-3 d-flex align-items-start">
                                            <i class="bi bi-arrow-right text-info me-2 mt-1"></i>
                                            <div>
                                                <strong class="text-dark"><?php esc_html_e('Regional Tags:', 'ams-wc-amazon'); ?></strong>
                                                <div class="text-muted small"><?php esc_html_e('Use the correct Associate Tag for your selected country', 'ams-wc-amazon'); ?></div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer border-0 bg-light">
                <div class="d-flex justify-content-between align-items-center w-100">
                    <div class="text-muted small">
                        <i class="bi bi-info-circle me-1"></i>
                        <?php esc_html_e('Click on category cards to filter errors', 'ams-wc-amazon'); ?>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x me-2"></i>
                            <?php esc_html_e('Close', 'ams-wc-amazon'); ?>
                        </button>
                        <a href="https://affiliate-program.amazon.com/" target="_blank" class="btn btn-primary">
                            <i class="bi bi-box-arrow-up-right me-2"></i>
                            <?php esc_html_e('Visit Amazon Associates', 'ams-wc-amazon'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    </div> <!-- End tab-content -->
</div> <!-- End setting_wrapper -->
</div> <!-- End container-fluid -->