<?php
$log_contents = isset($log_contents) ? $log_contents : '';
$current_page = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
$logs_per_page = 100; // Number of log entries per page
$total_pages = ceil(substr_count($log_contents, "\n") / $logs_per_page);
$filter = isset($_GET['filter']) ? sanitize_text_field($_GET['filter']) : '';
$filtered_logs = $this->filter_logs($log_contents, $filter);
$paginated_logs = $this->paginate_logs($filtered_logs, $current_page, $logs_per_page);
?>

<?php include "common-header.php"; ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Main Logs Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-file-text text-primary me-2"></i>
                            <?= esc_html__('Import Verification Logs', 'ams-wc-amazon'); ?>
                        </h5>
                        <div class="d-flex gap-2">
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary btn-sm dropdown-toggle" type="button" id="logsActions" data-bs-toggle="dropdown">
                                    <i class="bi bi-gear me-1"></i><?= esc_html__('Actions', 'ams-wc-amazon'); ?>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <form method="post" style="display: inline;">
                                            <input type="hidden" name="action" value="export_logs">
                                            <button type="submit" class="dropdown-item">
                                                <i class="bi bi-download me-2"></i><?= esc_html__('Export Logs', 'ams-wc-amazon'); ?>
                                            </button>
                                        </form>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <form method="post" style="display: inline;">
                                            <input type="hidden" name="action" value="clear_logs">
                                            <button type="submit" class="dropdown-item text-danger" onclick="return confirm('<?= esc_js(__('Are you sure you want to clear all logs? This action cannot be undone.', 'ams-wc-amazon')); ?>')">
                                                <i class="bi bi-trash me-2"></i><?= esc_html__('Clear All Logs', 'ams-wc-amazon'); ?>
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

            <!-- Information Panel -->
            <div class="alert alert-info border-0 mb-4" role="alert">
                <div class="d-flex">
                    <div class="flex-shrink-0">
                        <i class="bi bi-info-circle fa-lg text-info"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="alert-heading mb-2"><?= esc_html__('Import Verification Logs', 'ams-wc-amazon'); ?></h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="d-flex align-items-start">
                                    <i class="bi bi-file-text text-primary me-2 mt-1"></i>
                                    <div>
                                        <strong class="small"><?= esc_html__('Log Purpose', 'ams-wc-amazon'); ?></strong>
                                        <p class="small text-muted mb-0"><?= esc_html__('These logs track product import verification processes and API responses', 'ams-wc-amazon'); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex align-items-start">
                                    <i class="bi bi-hdd text-warning me-2 mt-1"></i>
                                    <div>
                                        <strong class="small"><?= esc_html__('Storage Location', 'ams-wc-amazon'); ?></strong>
                                        <p class="small text-muted mb-0"><?= esc_html__('Logs are stored in', 'ams-wc-amazon'); ?> <code>import_verification.log</code></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="card shadow-sm mb-4 ams-common-card-fix">
                <div class="card-body">
                    <form method="get" class="row g-3 align-items-end">
                        <input type="hidden" name="page" value="view-logs">
                        <div class="col-md-3">
                            <label class="form-label small text-muted"><?= esc_html__('Filter by Level', 'ams-wc-amazon'); ?></label>
                            <select name="filter" class="form-select form-select-sm">
                                <option value="" <?php selected($filter, ''); ?>><?= esc_html__('All Levels', 'ams-wc-amazon'); ?></option>
                                <option value="success" <?php selected($filter, 'success'); ?>><?= esc_html__('Success', 'ams-wc-amazon'); ?></option>
                                <option value="error" <?php selected($filter, 'error'); ?>><?= esc_html__('Error', 'ams-wc-amazon'); ?></option>
                                <option value="warning" <?php selected($filter, 'warning'); ?>><?= esc_html__('Warning', 'ams-wc-amazon'); ?></option>
                                <option value="info" <?php selected($filter, 'info'); ?>><?= esc_html__('Info', 'ams-wc-amazon'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-search me-1"></i><?= esc_html__('Filter', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Logs Table -->
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h6 class="mb-0 fw-semibold text-dark">
                            <i class="bi bi-list text-secondary me-2"></i>
                            <?= esc_html__('Log Entries', 'ams-wc-amazon'); ?>
                        </h6>
                        <div class="d-flex gap-2 align-items-center">
                            <small class="text-muted" id="logsCount">
                                <?php 
                                $total_lines = strlen($filtered_logs) ? substr_count($filtered_logs, "\n") : 0;
                                echo number_format($total_lines) . ' ' . esc_html__('entries found', 'ams-wc-amazon'); 
                                ?>
                            </small>
                            <button id="copy-logs-btn" class="btn btn-outline-primary btn-sm">
                                <i class="bi bi-clipboard me-1"></i><?= esc_html__('Copy All', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <?php if (empty($paginated_logs)) : ?>
                        <!-- Empty State -->
                        <div class="text-center py-5">
                            <i class="bi bi-file-text fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted"><?= esc_html__('No logs found', 'ams-wc-amazon'); ?></h5>
                            <p class="text-muted"><?= esc_html__('No import verification logs match your current filters.', 'ams-wc-amazon'); ?></p>
                        </div>
                    <?php else : ?>
                        <!-- Log Content -->
                        <div class="p-3">
                            <pre id="log-area" class="bg-light p-3 rounded border font-monospace lh-base overflow-auto" style="max-height: 500px;"><?php
$lines = explode("\n", $paginated_logs);
foreach ($lines as $i => $line) {
    $line_num = $logs_per_page * ($current_page - 1) + $i + 1;
    $highlight_class = '';
    if (stripos($line, 'error') !== false) $highlight_class = 'text-danger fw-semibold';
    elseif (stripos($line, 'success') !== false) $highlight_class = 'text-success fw-semibold';
    elseif (stripos($line, 'warning') !== false) $highlight_class = 'text-warning fw-semibold';
    elseif (stripos($line, 'info') !== false) $highlight_class = 'text-info fw-semibold';
    echo '<span class="text-muted">' . str_pad($line_num, 4, ' ', STR_PAD_LEFT) . ' | </span>';
    echo '<span class="' . $highlight_class . '">' . esc_html($line) . "</span>\n";
}
?></pre>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1) : ?>
                <div class="card-footer bg-white border-top">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-muted small">
                            <?php 
                            $start = ($current_page - 1) * $logs_per_page + 1;
                            $end = min($current_page * $logs_per_page, substr_count($filtered_logs, "\n"));
                            $total = substr_count($filtered_logs, "\n");
                            printf(esc_html__('Showing %d-%d of %d', 'ams-wc-amazon'), $start, $end, $total);
                            ?>
                        </div>
                        <nav>
                            <ul class="pagination pagination-sm mb-0">
                                <?php
                                $pagination_args = array(
                                    'base' => add_query_arg('paged', '%#%'),
                                    'format' => '',
                                    'total' => $total_pages,
                                    'current' => $current_page,
                                    'show_all' => false,
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('‹'),
                                    'next_text' => __('›'),
                                    'type' => 'array',
                                );
                                $page_links = paginate_links($pagination_args);
                                if (is_array($page_links)) {
                                    foreach ($page_links as $link) {
                                        if (strpos($link, 'current') !== false) {
                                            echo '<li class="page-item active"><span class="page-link">' . strip_tags($link) . '</span></li>';
                                        } else {
                                            // Extract page number from the link
                                            $page_num = 1;
                                            if (preg_match('/paged=(\d+)/', $link, $matches)) {
                                                $page_num = $matches[1];
                                            } elseif (preg_match('/>(\d+)</', $link, $matches)) {
                                                $page_num = $matches[1];
                                            } elseif (strpos($link, '‹') !== false) {
                                                $page_num = max(1, $current_page - 1);
                                            } elseif (strpos($link, '›') !== false) {
                                                $page_num = min($total_pages, $current_page + 1);
                                            }
                                            
                                            $href = add_query_arg(array('page' => 'view-logs', 'paged' => $page_num, 'filter' => $filter), admin_url('admin.php'));
                                            $text = strip_tags($link);
                                            echo '<li class="page-item"><a class="page-link" href="' . esc_url($href) . '">' . $text . '</a></li>';
                                        }
                                    }
                                }
                                ?>
                            </ul>
                        </nav>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy logs functionality
    var copyBtn = document.getElementById('copy-logs-btn');
    if (copyBtn) {
        copyBtn.addEventListener('click', function(e) {
            e.preventDefault();
            var logArea = document.getElementById('log-area');
            if (logArea) {
                var text = logArea.innerText;
                navigator.clipboard.writeText(text).then(function() {
                    copyBtn.innerHTML = '<i class="bi bi-check me-1"></i><?= esc_js(__('Copied!', 'ams-wc-amazon')); ?>';
                    setTimeout(function() {
                        copyBtn.innerHTML = '<i class="bi bi-clipboard me-1"></i><?= esc_js(__('Copy All', 'ams-wc-amazon')); ?>';
                    }, 1500);
                });
            }
        });
    }
});
</script>

<?php include "common-footer.php"; ?>