/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/eazy-docs/components/PreviewChoose.js":
/*!***************************************************!*\
  !*** ./src/eazy-docs/components/PreviewChoose.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PreviewChoose)
/* harmony export */ });
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




// Dynamically import all images from the widgets folder

const importAll = requireContext => {
  return requireContext.keys().map(key => {
    // Extract the file name without extension
    const fileName = key.replace('./', '').replace(/\.[^/.]+$/, '');
    // Create a label by replacing hyphens/special characters with spaces and capitalizing words
    const label = fileName.replace(/[-_]+/g, ' ') // Replace hyphens or underscores with spaces
    .replace(/[^\w\s]/g, '') // Remove special characters
    .replace(/\b\w/g, char => char.toUpperCase()); // Capitalize words
    return {
      id: fileName,
      // Use the original file name as the ID
      img: requireContext(key),
      // Image path
      label // Use the formatted label
    };
  });
};

// Presets to be dynamically loaded
const widgetPresets = importAll(__webpack_require__("./src/eazy-docs/assets/images/widgets sync \\.(png%7Cjpg%7Cjpeg%7Cgif%7Csvg)$"));

// Presets specific to "single-doc"
const singleDocPresets = ['light', 'creative', 'box', 'docbox', 'topicsbox'];

// Mapping multi-doc presets to single-doc presets
const styleMapping = {
  light: 'light',
  creative: 'creative',
  box: 'box',
  docbox: 'docbox' // Example: Map topic-box-docs to light
};
function PreviewChoose({
  attributes,
  setAttributes
}) {
  const {
    docPreset,
    docSinglePreset,
    isPreviewOpen,
    docTypes
  } = attributes;
  const closeModal = () => setAttributes({
    isPreviewOpen: false
  });
  function handlePresetPreview(type, value) {
    if (type === 'multi-doc') {
      setAttributes({
        docPreset: value
      });

      // Select corresponding single-doc style
      const mappedSingleDoc = styleMapping[value];
      if (mappedSingleDoc && singleDocPresets.includes(mappedSingleDoc)) {
        setAttributes({
          docSinglePreset: mappedSingleDoc
        });
      }
    } else if (type === 'single-doc') {
      setAttributes({
        docSinglePreset: value
      });

      // Select corresponding multi-doc style
      const mappedMultiDoc = Object.keys(styleMapping).find(key => styleMapping[key] === value);
      if (mappedMultiDoc) {
        setAttributes({
          docPreset: mappedMultiDoc
        });
      }
    }
    setAttributes({
      isPreviewOpen: false
    });
  }
  function handleChooseStyle() {
    setAttributes({
      isPreviewOpen: true
    });
  }

  // Filter presets based on docTypes
  const filteredPresets = docTypes === 'single-doc' ? widgetPresets.filter(preset => singleDocPresets.includes(preset.id)) : widgetPresets.filter(preset => preset.id !== 'topicsbox'); // Exclude 'topicsbox' for multi-doc

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.BlockControls, {
      group: "other",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ToolbarGroup, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton, {
          icon: "welcome-widgets-menus",
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose Style', 'eazydocs-pro'),
          onClick: handleChooseStyle
        })
      })
    }), isPreviewOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.Modal, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose a Style', 'eazydocs-pro'),
      onRequestClose: closeModal,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "preset-preview",
        children: filteredPresets.map(preset => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: `preset ${docTypes == 'multi-doc' && docPreset === preset.id || docTypes == 'single-doc' && docSinglePreset === preset.id ? 'preset-border' : ''}`,
          onClick: () => handlePresetPreview(docTypes, preset.id),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("strong", {
              children: preset.label
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
            src: preset.img,
            alt: `${preset.label} preview`
          })]
        }, preset.id))
      })
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/MultiPreset.js":
/*!**************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/MultiPreset.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styles_box__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./styles/box */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/box.js");
/* harmony import */ var _styles_creative__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./styles/creative */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/creative.js");
/* harmony import */ var _styles_docbox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/docbox */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/docbox.js");
/* harmony import */ var _styles_light__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles/light */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/light.js");
/* harmony import */ var _styles_topicsbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/topicsbox */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/topicsbox.js");
/* harmony import */ var _styles_boxed_tabbed_docs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles/boxed-tabbed-docs */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/boxed-tabbed-docs.js");
/* harmony import */ var _styles_flat_tabbed_docs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./styles/flat-tabbed-docs */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/flat-tabbed-docs.js");
/* harmony import */ var _styles_tabbed_doc_list__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./styles/tabbed-doc-list */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/tabbed-doc-list.js");
/* harmony import */ var _styles_collaborative_docs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./styles/collaborative-docs */ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/collaborative-docs.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);










const MultiPreset = ({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) => {
  const {
    docPreset,
    parentTitle
  } = attributes;

  // Mapping presets to components
  const presetComponents = {
    box: _styles_box__WEBPACK_IMPORTED_MODULE_0__["default"],
    creative: _styles_creative__WEBPACK_IMPORTED_MODULE_1__["default"],
    docbox: _styles_docbox__WEBPACK_IMPORTED_MODULE_2__["default"],
    light: _styles_light__WEBPACK_IMPORTED_MODULE_3__["default"],
    topicsbox: _styles_topicsbox__WEBPACK_IMPORTED_MODULE_4__["default"],
    boxed_tabbed_docs: _styles_boxed_tabbed_docs__WEBPACK_IMPORTED_MODULE_5__["default"],
    flat_tabbed_docs: _styles_flat_tabbed_docs__WEBPACK_IMPORTED_MODULE_6__["default"],
    tabbed_doc_list: _styles_tabbed_doc_list__WEBPACK_IMPORTED_MODULE_7__["default"],
    collaborative_docs: _styles_collaborative_docs__WEBPACK_IMPORTED_MODULE_8__["default"]
  };

  // Fallback to light if docPreset is not found in the mapping
  const Preset = presetComponents[docPreset] || _styles_light__WEBPACK_IMPORTED_MODULE_3__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Preset, {
    attributes: attributes,
    docSections: docSections,
    multiDocs: multiDocs,
    articlesNumber: articlesNumber
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultiPreset);

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/box.js":
/*!*************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/box.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Box)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



// Component for fetching and displaying featured image

function FeaturedImage({
  mediaId,
  title
}) {
  const [imageUrl, setImageUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (mediaId) {
      wp.apiFetch({
        path: `/wp/v2/media/${mediaId}`
      }).then(media => setImageUrl(media.source_url)).catch(error => console.error("Error fetching media:", error));
    }
  }, [mediaId]);
  return imageUrl ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
    src: imageUrl,
    alt: title.rendered
  }) : null;
}

// Component for fetching and displaying child items
function ChildItems({
  parentId,
  articlesNumber,
  parent_docs_order,
  menuOrder,
  onCountUpdate
}) {
  const docItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
    per_page: articlesNumber || 10,
    order: parent_docs_order,
    orderby: menuOrder,
    parent: parentId,
    status: ["publish", "private"]
  }), [parentId, articlesNumber, parent_docs_order, menuOrder]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (onCountUpdate) {
      onCountUpdate(docItems?.length || 0);
    }
  }, [docItems, onCountUpdate]);
  if (!docItems) return;
  if (docItems.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
    class: "ezd-list-unstyled",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
      children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
        className: "ct-content-text",
        children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          className: "icon_document_alt"
        }), " No child items available. "]
      })]
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
    className: "ezd-list-unstyled",
    children: docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
        className: "ct-content-text",
        href: "",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          className: "icon_document_alt"
        }), item.title.rendered]
      })
    }, item.id))
  });
}

// Main box component
function Box({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) {
  const {
    col,
    docs_layout,
    readMoreText,
    orderBy,
    parent_docs_order,
    child_docs_order,
    show_topic,
    isFeaturedImage
  } = attributes;

  // Determine layout type
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: `${layoutType}`,
    children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
      const {
        id,
        title,
        featured_media
      } = section;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "topic_list_item box-item wow fadeIn",
        "data-wow-delay": "0.2s",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
          href: "",
          className: "topic-title",
          children: [isFeaturedImage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
            mediaId: featured_media,
            title: title
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
            className: "ct-heading-text",
            children: title.rendered
          }), show_topic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
            className: "ezd-badge ezd-circle",
            children: articlesNumber
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ChildItems, {
          parent_docs_order: child_docs_order,
          menuOrder: orderBy,
          parentId: id,
          articlesNumber: articlesNumber
        }), readMoreText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
          href: "",
          className: "text_btn dark_btn",
          children: [readMoreText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
            className: "arrow_right"
          })]
        })]
      }, id);
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/boxed-tabbed-docs.js":
/*!***************************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/boxed-tabbed-docs.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ boxed_tabbed_docs)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function boxed_tabbed_docs({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) {
  const {
    col,
    readMoreText,
    docs_layout,
    sectionsNumber,
    orderBy,
    child_docs_order
  } = attributes;

  // State for active tab
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  // Fetch all documents (both parents and children)
  const allDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
    per_page: -1,
    // Fetch all documents
    status: ["publish", "private"],
    order: child_docs_order,
    // Specify order: 'asc' or 'desc'
    orderby: orderBy // Specify field to order by, e.g., 'menu_order', 'date', 'title'
  }), [child_docs_order, orderBy]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (docSections && docSections.length > 0) {
      // Set the first section as the default active tab
      setActiveTab(docSections[0].id);
    } else if (multiDocs && multiDocs.length > 0) {
      // Set the first multiDoc as the default active tab if docSections is empty
      setActiveTab(multiDocs[0].id);
    }
  }, [docSections, multiDocs]);
  if (!allDocs) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "Loading..."
  });
  if (allDocs.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "No documents found."
  });

  // Separate parent and child documents
  const mainDocs = allDocs.filter(doc => doc.parent === 0); // Parent docs are those with parent === 0
  const getChildDocs = parentId => allDocs.filter(doc => doc.parent === parentId);
  // Children are filtered by parentId

  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col} topic_list_inner` : `ezd-masonry-wrap ezd-masonry-col-${col} topic_list_inner`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "question_menu docs3",
    id: "Arrow_slides-bada9fe",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "tabs_sliders",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "scroller-btn left inactive",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          className: "arrow_carrot-left"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        className: "nav nav-tabs mb-5 ezd-tab-menu slide_nav_tabs",
        children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
          const {
            id,
            title,
            slug
          } = section;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
            className: "nav-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
              "data-rel": slug,
              className: `nav-link ezd_tab_title ${activeTab === id ? "active" : ""}`,
              onClick: () => setActiveTab(id),
              children: title.rendered
            })
          }, id);
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "scroller-btn right inactive",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          className: "arrow_carrot-right"
        })
      })]
    }), (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
      // Get child docs for this section
      const childDocs = getChildDocs(section.id).slice(0, sectionsNumber);
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: `doc_tab_pane ezd-tab-box ${activeTab === section.id ? "active" : ""}`,
        id: section.slug,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: layoutType,
          children: childDocs.length > 0 ? childDocs.slice(0, sectionsNumber).map(childDoc => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "topic_list_item",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
              className: "ezd_item_title",
              children: childDoc.title.rendered
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
              className: "navbar-nav",
              children: allDocs.filter(doc => doc.parent === childDoc.id).slice(0, articlesNumber).map(nestedChild => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                  href: nestedChild.link,
                  className: "ezd_item_list_title",
                  children: nestedChild.title.rendered
                })
              }, nestedChild.id))
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
              href: childDoc.link,
              className: "text_btn dark_btn ezd_btn",
              children: [readMoreText || "View All", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                className: "arrow_right"
              })]
            })]
          }, childDoc.id)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            class: "topic_list_item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
              class: "ezd_item_title",
              children: "No child documents found for this section. "
            })
          })
        })
      }, section.id);
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/collaborative-docs.js":
/*!****************************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/collaborative-docs.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CollaborativeDocs)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function CollaborativeDocs({
  attributes,
  docSections,
  articlesNumber,
  multiDocs
}) {
  const {
    col,
    readMoreText,
    docs_layout,
    isFeaturedImage
  } = attributes;
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  // Fetch all docs
  const allDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
    per_page: -1,
    status: ["publish", "private"]
  }), []);

  // Fetch all authors with their avatars
  const authors = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const users = select("core").getEntityRecords("root", "user", {
      per_page: -1
    });
    if (!users) return null;
    return users.reduce((acc, user) => {
      acc[user.id] = {
        name: user.name,
        avatar: user.avatar_urls?.["96"] || "" // Ensure correct key
      };
      return acc;
    }, {});
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (docSections && docSections.length > 0) {
      setActiveTab(docSections[0].id);
    } else if (multiDocs && multiDocs.length > 0) {
      setActiveTab(multiDocs[0].id);
    }
  }, [docSections, multiDocs]);
  if (!allDocs) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "Loading..."
  });
  if (allDocs.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "No documents found."
  });

  // Recursively count all child items for a parent doc
  const countAllChildDocs = parentId => {
    const directChildren = allDocs.filter(doc => doc.parent === parentId);
    return directChildren.reduce((count, child) => count + 1 + countAllChildDocs(child.id), 0);
  };

  // Function to trim words
  const showWords = (sentence, numberOfWords) => {
    const wordsArray = sentence.replace(/<\/?[^>]+(>|$)/g, "").split(" "); // Strip HTML tags
    return numberOfWords >= wordsArray.length ? sentence : wordsArray.slice(0, numberOfWords).join(" ");
  };
  function FeaturedImage({
    mediaId,
    title
  }) {
    const [imageUrls, setImageUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (mediaId) {
        wp.apiFetch({
          path: `/wp/v2/media/${mediaId}`
        }).then(media => setImageUrl(media.source_url)).catch(error => console.error("Error fetching media:", error));
      }
    }, [mediaId]);
    return imageUrls ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
      src: imageUrls
    }) : null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
      className: "doc6_community_area docs6 bew-topics",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "doc_community_info",
        children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
          const totalChildDocs = countAllChildDocs(section.id);
          const {
            id,
            featured_media
          } = section;
          // Fetch author data
          const authorData = authors?.[section.author];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "doc_community_item topic-item wow fadeInUp",
            "data-wow-delay": "0.1s",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "doc_community_icon ezd-docs5-icon-wrap",
              children: isFeaturedImage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
                mediaId: featured_media
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "doc_entry_content",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                href: section.link,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
                  className: "ezd_item_title",
                  children: section.title.rendered
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                className: "ezd_item_content",
                children: showWords(section.excerpt.rendered, 15)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                className: "doc_entry_info",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("ul", {
                  className: "ezd-list-unstyled author_avatar",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                    children: authorData?.avatar ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                      src: authorData.avatar,
                      alt: authorData.name
                    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                      src: "https://www.gravatar.com/avatar/?d=mp",
                      alt: "Default Avatar"
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                    class: "avatar_plus",
                    children: "+1"
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  className: "text",
                  children: [totalChildDocs, " Articles in this Doc. ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("br", {}), "Written by ", authorData?.name, " and others"]
                })]
              })]
            })]
          }, section.id);
        })
      })
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/creative.js":
/*!******************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/creative.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ creative)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function creative({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) {
  const {
    col,
    titleText,
    titleTag,
    docs_layout,
    imageUrl,
    sectionButton,
    sectionButtonText,
    child_docs_order,
    orderBy,
    isFeaturedImage
  } = attributes;
  const Title = () => {
    const tag = titleTag || 'h2';
    const Tag = titleTag;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Tag, {
      className: "title",
      "data-animation": "wow fadeInUp",
      "data-wow-delay": "0.2s",
      children: titleText
    });
  };

  // Determine layout type based on attributes
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;
  function ChildItems({
    parentId,
    articlesNumber
  }) {
    const docItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
      per_page: articlesNumber || 10,
      orderby: orderBy,
      order: child_docs_order,
      parent: parentId,
      status: ["publish", "private"]
    }), [parentId, articlesNumber, orderBy, child_docs_order]);
    if (!docItems) return;
    if (docItems.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
      className: "ezd-list-unstyled",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
          className: "ct-content-text",
          children: "No child items available"
        })
      })
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        className: "ezd-list-unstyled",
        children: docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
            className: "ct-content-text",
            href: "#",
            children: item.title.rendered
          })
        }, item.id))
      })
    });
  }

  // Component for fetching and displaying featured image
  function FeaturedImage({
    mediaId,
    title
  }) {
    const [imageUrls, setImageUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (mediaId) {
        wp.apiFetch({
          path: `/wp/v2/media/${mediaId}`
        }).then(media => setImageUrl(media.source_url)).catch(error => console.error("Error fetching media:", error));
      }
    }, [mediaId]);
    return imageUrls ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
      src: imageUrls
    }) : null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
      className: "recommended_topic_area creative-style",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "recommended_topic_inner",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
          src: imageUrl !== null && imageUrl !== void 0 ? imageUrl : ezdAssets.ezd_img_dir + '/widgets/docbg-shap.png',
          className: "doc_shap_one",
          alt: "curve shape"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_round one",
          "data-parallax": "{\"x\": -80, \"y\": -100, \"rotateY\":0}"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_round two",
          "data-parallax": "{\"x\": -10, \"y\": 70, \"rotateY\":0}"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_title text-center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Title, {})
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "ezd-container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: `${layoutType}`,
            children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
              const {
                id,
                featured_media
              } = section;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                className: "recommended_item box-item wow fadeInUp",
                "data-wow-delay": "0.2s",
                children: [isFeaturedImage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
                  mediaId: featured_media
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                  href: "#",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                    className: "ct-heading-text",
                    children: section.title.rendered
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ChildItems, {
                  parentId: id,
                  articlesNumber: articlesNumber
                })]
              }, section.id);
            })
          })
        }), sectionButton && sectionButtonText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "text-center wow fadeInUp",
          "data-wow-delay": "0.2s",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
            href: "",
            className: "question_text",
            children: [sectionButtonText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
              className: "arrow_right"
            })]
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/docbox.js":
/*!****************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/docbox.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DocBox)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function DocBox({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) {
  const {
    col,
    docs_layout,
    sectionsNumber,
    parent_docs_order,
    orderBy,
    child_docs_order
  } = attributes;
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;

  // Fetch child docs for all sections
  const sectionDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = [...(docSections || []), ...(multiDocs || [])].map(section => section.id);
    const docsBySection = {};
    parentIds.forEach(parentId => {
      docsBySection[parentId] = select("core").getEntityRecords("postType", "docs", {
        per_page: sectionsNumber,
        orderby: orderBy,
        order: parent_docs_order,
        parent: parentId,
        status: ['publish', 'private']
      });
    });
    return docsBySection;
  }, [docSections, multiDocs, sectionsNumber, parent_docs_order, orderBy]);

  // Component for fetching and displaying child items
  function ChildItems({
    parentId
  }) {
    const childItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
      return select("core").getEntityRecords("postType", "docs", {
        per_page: articlesNumber,
        orderby: orderBy,
        order: child_docs_order,
        parent: parentId,
        status: ['publish', 'private']
      });
    }, [articlesNumber, parentId, child_docs_order, orderBy]);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
      className: "navbar-nav docs-single5-nav-wrap ezd-list-unstyled",
      children: childItems && childItems.length > 0 && childItems.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
          href: "#",
          children: child.title.rendered
        })
      }, child.id))
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: layoutType,
    children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
      const docItems = sectionDocs[section.id] || [];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "docs-box-item docs-single-5-wrap doc-box-style",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h5", {
          className: "docs-5-title",
          children: section.title.rendered
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "dox5-section-item",
          children: docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "section5-article",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: "section5-section-title",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h6", {
                className: "ct-content-text",
                children: item.title.rendered
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ChildItems, {
              parentId: item.id
            })]
          }, item.id))
        })]
      }, section.id);
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/flat-tabbed-docs.js":
/*!**************************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/flat-tabbed-docs.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ flat_tabbed_docs)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function flat_tabbed_docs({
  attributes,
  docSections,
  articlesNumber,
  multiDocs
}) {
  const {
    readMoreText,
    child_docs_order,
    orderBy,
    isFeaturedImage
  } = attributes;

  // State for active tab
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  // Fetch all documents (both parents and children)
  const allDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
    per_page: -1,
    // Fetch all documents
    status: ["publish", "private"],
    order: child_docs_order,
    // Specify order: 'asc' or 'desc'
    orderby: orderBy // Specify field to order by, e.g., 'menu_order', 'date', 'title'
  }), [child_docs_order, orderBy]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (docSections && docSections.length > 0) {
      // Set the first section as the default active tab
      setActiveTab(docSections[0].id);
    } else if (multiDocs && multiDocs.length > 0) {
      // Set the first multiDoc as the default active tab if docSections is empty
      setActiveTab(multiDocs[0].id);
    }
  }, [docSections, multiDocs]);
  if (!allDocs) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "Loading..."
  });
  if (allDocs.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "No documents found."
  });

  // Separate parent and child documents
  const mainDocs = allDocs.filter(doc => doc.parent === 0); // Parent docs are those with parent === 0
  const getChildDocs = parentId => allDocs.filter(doc => doc.parent === parentId); // Children are filtered by parentId

  // Function to show first 'n' words of a sentence
  const showWords = (sentence, numberOfWords) => {
    // Split the sentence into an array of words
    let wordsArray = sentence.split(" ");

    // If the number of words to show is greater than the length of the array, return the original sentence
    if (numberOfWords >= wordsArray.length) {
      return sentence;
    }

    // Slice the array to get the desired number of words and join them back into a string
    let truncatedSentence = wordsArray.slice(0, numberOfWords).join(" ");

    // Return the truncated sentence
    return truncatedSentence;
  };
  function FeaturedImage({
    mediaId,
    title
  }) {
    const [imageUrl, setImageUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (mediaId) {
        wp.apiFetch({
          path: `/wp/v2/media/${mediaId}`
        }).then(media => setImageUrl(media.source_url)).catch(error => console.error("Error fetching media:", error));
      }
    }, [mediaId]);
    return imageUrl ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
      className: "doc-logo",
      src: imageUrl
    }) : null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("section", {
    class: "h_doc_documentation_area",
    id: "Arrow_slides-bada9fe",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      class: "tabs_sliders",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        class: "scroller-btn left inactive",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          class: "arrow_carrot-left"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        class: "nav nav-tabs documentation_tab ezd-tab-menu slide_nav_tabs ezd-list-unstyled",
        children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
          const {
            id,
            title,
            excerpt,
            slug
          } = section;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
            class: "nav-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
              "data-rel": slug,
              className: `nav-link ezd_tab_title ${activeTab === id ? "active" : ""}`,
              onClick: () => setActiveTab(id),
              children: title.rendered
            })
          }, id);
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        class: "scroller-btn right inactive",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          class: "arrow_carrot-right"
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      class: "ezd-tab-content",
      children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
        const {
          excerpt,
          featured_media
        } = section;
        // Get child docs for this section
        // const childDocs = getChildDocs(section.id);
        const childDocs = getChildDocs(section.id).slice(0, articlesNumber);
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: `documentation_tab_pane ezd-tab-box ${activeTab === section.id ? "active" : ""}`,
          id: section.slug,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            class: "ezd-grid ezd-grid-cols-12",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              class: "ezd-lg-col-4 ezd-grid-column-full",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                class: "documentation_text",
                children: [isFeaturedImage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
                  mediaId: featured_media,
                  title: section.title.rendered
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
                  class: "ezd_item_parent_title",
                  children: section.title.rendered
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                  class: "ezd_item_content",
                  children: showWords(section.excerpt.rendered.replace("<p>", "").replace("</p>", ""), 15)
                }), readMoreText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
                  href: "",
                  class: "learn_btn ezd_btn",
                  children: [readMoreText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                    className: "arrow_right"
                  })]
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              class: "ezd-lg-col-8 ezd-grid-column-full",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                class: "d-items",
                children: childDocs.map(childDoc => {
                  const {
                    featured_media
                  } = childDoc;
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                    className: "media documentation_item",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                      className: "icon bs-sm",
                      children: isFeaturedImage && featured_media ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
                        mediaId: featured_media,
                        title: childDoc.title.rendered
                      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                        decoding: "async",
                        src: "https://wordpress-plugins.spider-themes.net/checker/wp-content/plugins/eazydocs/includes/Elementor/Docs/images/folder.png",
                        alt: "Getting Started"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                      className: "media-body",
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                        href: "#",
                        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h5", {
                          className: "title ezd_item_title",
                          children: childDoc.title.rendered
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
                        className: "ezd_item_content",
                        children: showWords(childDoc.excerpt.rendered.replace("<p>", "").replace("</p>", ""), 10)
                      })]
                    })]
                  }, childDoc.id);
                })
              })
            })]
          })
        }, section.id);
      })
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/light.js":
/*!***************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/light.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ light)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



// Component for fetching and displaying featured image

function FeaturedImage({
  mediaId,
  title
}) {
  const [imageUrl, setImageUrl] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (mediaId) {
      wp.apiFetch({
        path: `/wp/v2/media/${mediaId}`
      }).then(media => setImageUrl(media.source_url)).catch(error => console.error("Error fetching media:", error));
    }
  }, [mediaId]);
  return imageUrl ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
    src: imageUrl,
    alt: title.rendered
  }) : null;
}

// Main box component
function light({
  attributes,
  docSections,
  multiDocs,
  articlesNumber
}) {
  const {
    col,
    docs_layout,
    readMoreText,
    orderBy,
    child_docs_order,
    show_topic,
    topic_label,
    sectionButton,
    sectionButtonText,
    btnURL,
    isFeaturedImage
  } = attributes;
  function ChildItems({
    parentId,
    articlesNumber,
    onCountUpdate
  }) {
    const docItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
      per_page: articlesNumber || 10,
      orderby: orderBy,
      order: child_docs_order,
      parent: parentId,
      status: ["publish", "private"]
    }), [parentId, articlesNumber, orderBy, child_docs_order]);
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (onCountUpdate) {
        onCountUpdate(docItems?.length || 0);
      }
    }, [docItems, onCountUpdate]);
    if (!docItems) return;
    if (docItems.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
      className: "ezd-list-unstyled tag_list",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          className: "icon_document_alt"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
          className: "ct-content-text",
          children: "No child items available"
        })]
      })
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        className: "ezd-list-unstyled tag_list",
        children: docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
            className: "icon_document_alt"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
            className: "ct-content-text",
            href: "#",
            children: item.title.rendered
          })]
        }, item.id))
      })
    });
  }

  // Determine layout type
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: `${layoutType}`,
      children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
        const {
          id,
          title,
          featured_media
        } = section;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "categories_guide_item box-item wow fadeInUp single-doc-layout-one light-style",
          "data-wow-delay": "0.2s",
          children: [isFeaturedImage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(FeaturedImage, {
            mediaId: featured_media,
            title: title
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "doc-top ezd-d-flex ezd-align-items-start",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
              class: "doc_tag_title",
              href: "#",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("h4", {
                class: "title",
                children: [" ", title.rendered, " "]
              }), show_topic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
                class: "ezd-badge",
                children: [" ", articlesNumber, " ", topic_label, " "]
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ChildItems, {
            parentId: id,
            articlesNumber: articlesNumber
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
            href: "#",
            className: "doc_border_btn",
            children: [readMoreText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
              className: "arrow_right"
            })]
          })]
        }, id);
      })
    }), sectionButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      class: "text-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
        href: `${btnURL}`,
        class: "action_btn all_doc_btn wow fadeinUp",
        children: [sectionButtonText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          class: "arrow_right"
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/tabbed-doc-list.js":
/*!*************************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/tabbed-doc-list.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ tabbed_doc_list)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function tabbed_doc_list({
  attributes,
  docSections,
  articlesNumber,
  multiDocs
}) {
  const {
    col,
    readMoreText,
    docs_layout,
    sectionsNumber,
    orderBy,
    child_docs_order,
    parent_docs_order
  } = attributes;

  // State for active tab
  const [activeTab, setActiveTab] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  // Fetch all documents (both parents and children)
  const allDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select("core").getEntityRecords("postType", "docs", {
    per_page: -1,
    // Fetch all documents
    status: ["publish", "private"],
    orderby: orderBy,
    order: child_docs_order
  }), [orderBy, child_docs_order]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (docSections && docSections.length > 0) {
      // Set the first section as the default active tab
      setActiveTab(docSections[0].id);
    } else if (multiDocs && multiDocs.length > 0) {
      // Set the first multiDoc as the default active tab if docSections is empty
      setActiveTab(multiDocs[0].id);
    }
  }, [docSections, multiDocs]);
  if (!allDocs) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "Loading..."
  });
  if (allDocs.length === 0) return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    children: "No documents found."
  });

  // Separate parent and child documents
  const mainDocs = allDocs.filter(doc => doc.parent === 0); // Parent docs are those with parent === 0
  const getChildDocs = parentId => allDocs.filter(doc => doc.parent === parentId); // Children are filtered by parentId

  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col} topic_list_inner` : `ezd-masonry-wrap ezd-masonry-col-${col} topic_list_inner`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("section", {
      class: "doc_tag_area",
      id: "Arrow_slides-bada9fe",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        class: "tabs_sliders",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          class: "scroller-btn left inactive",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
            class: "arrow_carrot-left"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
          class: "nav nav-tabs doc_tag ezd-tab-menu slide_nav_tabs ezd-list-unstyled",
          children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
            const {
              id,
              title,
              slug
            } = section;
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
              className: "nav-item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                "data-rel": slug,
                className: `nav-link ezd_tab_title ${activeTab === id ? "active" : ""}`,
                onClick: () => setActiveTab(id),
                children: title.rendered
              })
            }, id);
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          class: "scroller-btn right inactive",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
            class: "arrow_carrot-right"
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        class: "ezd-tab-content",
        children: (docSections || multiDocs) && [...(docSections || []), ...(multiDocs || [])].map(section => {
          // Get child docs for this section
          const childDocs = getChildDocs(section.id).slice(0, sectionsNumber);
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: `doc_tab_pane ezd-tab-box ${activeTab === section.id ? "active" : ""}`,
            id: section.slug,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              className: layoutType,
              children: childDocs.length > 0 && childDocs.map(childDoc => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  class: "doc_tag_item",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                    class: "doc_tag_title",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
                      class: "ezd_item_title",
                      children: childDoc.title.rendered
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                      class: "line"
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
                    class: "ezd-list-unstyled tag_list",
                    children: allDocs.filter(doc => doc.parent === childDoc.id).slice(0, articlesNumber) // Filter child docs
                    .map(nestedChild => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                        href: "#",
                        className: "ezd_item_list_title",
                        children: nestedChild.title.rendered
                      })
                    }, nestedChild.id))
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
                    href: childDoc.link,
                    className: "text_btn dark_btn ezd_btn",
                    children: [readMoreText || "View All", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                      className: "arrow_right"
                    })]
                  })]
                })
              }, childDoc.id))
            })
          }, section.id);
        })
      })]
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/multi-doc-presets/styles/topicsbox.js":
/*!*******************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/multi-doc-presets/styles/topicsbox.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ topicsbox)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function topicsbox({
  attributes,
  docSections
}) {
  const {
    articlesNumber,
    col,
    docs_layout,
    docId,
    excerptCharNumber
  } = attributes;
  const [exceprtText, setExceprtText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");

  // Determine layout type
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : "ezd-masonry-wrap";

  // Fetch the parent post (docId)
  const post = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    return select("core").getEntityRecord("postType", "docs", docId);
  }, [docId]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (post) {
      console.log("Post Title:", post.title.rendered);
    } else {
      console.log("Post not found or still loading.");
    }
  }, [post]);

  // Fetch all doc items (child sections) for each section in a single call
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select('core').getEntityRecords('postType', 'docs', {
        per_page: articlesNumber,
        order: 'asc',
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, docSections]);

  // Function to show first 'n' words of a sentence
  const showWords = (sentence, numberOfWords) => {
    // Split the sentence into an array of words
    let wordsArray = sentence.split(" ");

    // If the number of words to show is greater than the length of the array, return the original sentence
    if (numberOfWords >= wordsArray.length) {
      return sentence;
    }

    // Slice the array to get the desired number of words and join them back into a string
    let truncatedSentence = wordsArray.slice(0, numberOfWords).join(" ");

    // Return the truncated sentence
    return truncatedSentence;
  };

  // Helper function to get the excerpt or first N words of the content
  const getExcerptOrContent = (content, excerpt) => {
    // Check if excerpt is available and if it has a rendered value
    if (excerpt && excerpt.rendered) {
      let excerptString = excerpt.rendered;
      let updatedExcerptString = excerptString.replace("<p>", "").replace("</p>", "");
      return showWords(updatedExcerptString, excerptCharNumber);
    }
    return "";
  };

  // Render the component
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: `ezd-grid ezd-column-${col} h_content_items topic-box-style`,
    children: docSections && docSections.map(section => {
      const {
        title,
        id,
        excerpt,
        content
      } = section; // Get excerpt and content for the parent section

      // Get the excerpt or first 'excerptCharNumber' words for the parent section
      const parentExcerptOrContent = getExcerptOrContent(content.rendered, excerpt);

      // Find the child items for the current section using its parentId
      const sectionItems = allDocItems.find(item => item.parentId === id)?.items || [];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
        href: "#",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "h_item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
            className: "ct-heading-text",
            children: title.rendered || "Untitled Section"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "ct-content-text",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              children: parentExcerptOrContent
            }), sectionItems && sectionItems.length > 0 && sectionItems.map(childItem => {
              // Get the content or excerpt for each child item
              const excerptOrContent = getExcerptOrContent(childItem.excerpt.rendered);

              // Wrap child content in a <div> element
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                children: excerptOrContent
              }, childItem.id);
            })]
          })]
        })
      }, id);
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/SinglePreset.js":
/*!****************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/SinglePreset.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styles_box__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./styles/box */ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/box.js");
/* harmony import */ var _styles_creative__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./styles/creative */ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/creative.js");
/* harmony import */ var _styles_docbox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/docbox */ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/docbox.js");
/* harmony import */ var _styles_light__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles/light */ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/light.js");
/* harmony import */ var _styles_topicsbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/topicsbox */ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/topicsbox.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);







const SinglePreset = ({
  attributes,
  articlesNumber
}) => {
  const {
    docSinglePreset,
    parentTitle,
    docId,
    sectionsNumber,
    parent_docs_order,
    orderBy
  } = attributes;

  // Mapping presets to components
  const presetComponents = {
    box: _styles_box__WEBPACK_IMPORTED_MODULE_0__["default"],
    creative: _styles_creative__WEBPACK_IMPORTED_MODULE_1__["default"],
    docbox: _styles_docbox__WEBPACK_IMPORTED_MODULE_2__["default"],
    light: _styles_light__WEBPACK_IMPORTED_MODULE_3__["default"],
    topicsbox: _styles_topicsbox__WEBPACK_IMPORTED_MODULE_4__["default"]
  };

  // Fallback to StyleOne if docSinglePreset is not found in the mapping
  const Preset = presetComponents[docSinglePreset] || _styles_light__WEBPACK_IMPORTED_MODULE_3__["default"];

  // sections title post
  const docSections = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => {
    return select('core').getEntityRecords('postType', 'docs', {
      per_page: sectionsNumber,
      order: parent_docs_order,
      orderby: orderBy,
      parent: docId,
      status: ['publish', 'private']
    });
  }, [docId, sectionsNumber, parent_docs_order, orderBy]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Preset, {
    attributes: attributes,
    docSections: docSections,
    articlesNumber: articlesNumber
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SinglePreset);

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/box.js":
/*!**************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/styles/box.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ box)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function box({
  attributes,
  docSections,
  articlesNumber
}) {
  const {
    col,
    docs_layout,
    readMoreText,
    orderBy,
    child_docs_order,
    show_topic,
    isFeaturedImage
  } = attributes;

  // Determine layout type based on attributes
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;

  // Fetch all doc items for each section in a single call
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select("core").getEntityRecords("postType", "docs", {
        per_page: articlesNumber,
        order: child_docs_order,
        orderby: orderBy,
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, docSections, child_docs_order, orderBy]);

  // Count child items for each parent
  const childCounts = allDocItems.reduce((acc, {
    parentId,
    items
  }) => {
    acc[parentId] = items ? items.length : 0;
    return acc;
  }, {});

  // State for all featured media images
  const [images, setImages] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const fetchImages = async () => {
      if (!Array.isArray(docSections)) {
        return;
      }
      const imagePromises = docSections.map(async section => {
        if (section.featured_media) {
          try {
            const media = await wp.apiFetch({
              path: `/wp/v2/media/${section.featured_media}`
            });
            return {
              id: section.id,
              imageUrl: media.source_url
            };
          } catch (error) {
            console.error("Error fetching media:", error);
            return {
              id: section.id,
              imageUrl: null
            };
          }
        }
        return {
          id: section.id,
          imageUrl: null
        };
      });
      const results = await Promise.all(imagePromises);
      const imageMap = results.reduce((acc, {
        id,
        imageUrl
      }) => {
        acc[id] = imageUrl;
        return acc;
      }, {});
      setImages(imageMap);
    };
    const safeDocSections = docSections || [];
    fetchImages(safeDocSections);
  }, [docSections]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: `${layoutType}`,
    children: docSections && docSections.map(section => {
      const {
        id,
        title,
        featured_media
      } = section;

      // Find the child items for the current section
      const sectionItems = allDocItems.find(item => item.parentId === id)?.items || [];
      // Get the image URL from state
      const imageUrl = images[id];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "topic_list_item box-item wow fadeIn",
        "data-wow-delay": "0.2s",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
          href: "",
          className: "topic-title",
          children: [isFeaturedImage && imageUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
            src: imageUrl,
            alt: title.rendered
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
            className: "ct-heading-text",
            children: title?.rendered
          }), show_topic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
            className: "ezd-badge ezd-circle",
            children: childCounts[section.id]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
          className: "ezd-list-unstyled",
          children: sectionItems && sectionItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
              className: "ct-content-text",
              href: "",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
                className: "icon_document_alt"
              }), item.title?.rendered]
            })
          }, item.id))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
          href: "",
          className: "text_btn dark_btn",
          children: [readMoreText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
            className: "arrow_right"
          })]
        })]
      }, id);
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/creative.js":
/*!*******************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/styles/creative.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ creative)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function creative({
  attributes,
  docSections,
  articlesNumber
}) {
  const {
    col,
    titleText,
    titleTag,
    docs_layout,
    imageUrl,
    orderBy,
    menuOrder,
    sectionButton,
    sectionButtonText,
    btnURL,
    child_docs_order,
    isFeaturedImage
  } = attributes;
  const Title = () => {
    const tag = titleTag || 'h2';
    const Tag = titleTag;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Tag, {
      className: "title",
      "data-animation": "wow fadeInUp",
      "data-wow-delay": "0.2s",
      children: titleText
    });
  };

  // Determine layout type based on attributes
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select('core').getEntityRecords('postType', 'docs', {
        per_page: articlesNumber,
        orderby: orderBy,
        order: child_docs_order,
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, orderBy, docSections, child_docs_order]);

  // State for all featured media images
  const [images, setImages] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const fetchImages = async () => {
      if (!Array.isArray(docSections)) {
        return;
      }
      const imagePromises = docSections.map(async section => {
        if (section.featured_media) {
          try {
            const media = await wp.apiFetch({
              path: `/wp/v2/media/${section.featured_media}`
            });
            return {
              id: section.id,
              imageUrl: media.source_url
            };
          } catch (error) {
            console.error("Error fetching media:", error);
            return {
              id: section.id,
              imageUrl: null
            };
          }
        }
        return {
          id: section.id,
          imageUrl: null
        };
      });
      const results = await Promise.all(imagePromises);
      const imageMap = results.reduce((acc, {
        id,
        imageUrl
      }) => {
        acc[id] = imageUrl;
        return acc;
      }, {});
      setImages(imageMap);
    };
    const safeDocSections = docSections || [];
    fetchImages(safeDocSections);
  }, [docSections]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
      className: "recommended_topic_area",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "recommended_topic_inner",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
          src: imageUrl !== null && imageUrl !== void 0 ? imageUrl : ezdAssets.ezd_img_dir + '/widgets/docbg-shap.png',
          className: "doc_shap_one",
          alt: "curve shape"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_round one",
          "data-parallax": "{\"x\": -80, \"y\": -100, \"rotateY\":0}"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_round two",
          "data-parallax": "{\"x\": -10, \"y\": 70, \"rotateY\":0}"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "doc_title text-center",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
            className: "title",
            "data-animation": "wow fadeInUp",
            "data-wow-delay": "0.2s",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Title, {})
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "ezd-container",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: `${layoutType}`,
            children: docSections && docSections.map(section => {
              const {
                id,
                title,
                featured_media
              } = section;
              const docItems = allDocItems.find(item => item.parentId === id)?.items || [];
              const imageUrl = images[id];
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
                  className: "recommended_item box-item wow fadeInUp",
                  "data-wow-delay": "0.2s",
                  children: [isFeaturedImage && imageUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
                    src: imageUrl,
                    alt: title.rendered
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
                    href: "",
                    children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h3", {
                      className: "ct-heading-text",
                      children: title.rendered
                    }), " "]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
                    className: "ezd-list-unstyled",
                    children: docItems && docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
                        className: "ct-content-text",
                        href: "",
                        children: [" ", item.title.rendered, " "]
                      })
                    }, item.id))
                  })]
                }, id)
              });
            })
          })
        }), sectionButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "text-center wow fadeInUp",
          "data-wow-delay": "0.2s",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
            href: `${btnURL}`,
            className: "question_text",
            children: [sectionButtonText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
              className: "arrow_right"
            })]
          })
        })]
      })
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/docbox.js":
/*!*****************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/styles/docbox.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ creative)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function creative({
  attributes,
  docSections
}) {
  const {
    articlesNumber,
    col,
    docs_layout,
    docId,
    orderBy,
    child_docs_order
  } = attributes;

  // Determine layout type
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : "ezd-masonry-wrap";
  const post = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    return select("core").getEntityRecord("postType", "docs", docId);
  }, [docId]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (post) {
      console.log("Post Title:", post.title.rendered);
    } else {
      console.log("Post not found or still loading.");
    }
  }, [post]);

  // Fetch all doc items for each section in a single call
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select('core').getEntityRecords('postType', 'docs', {
        per_page: articlesNumber,
        orderby: orderBy,
        order: child_docs_order,
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, orderBy, child_docs_order, docSections]);

  // Render the component
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "docs-box-item docs-single-5-wrap doc-box-style",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("h5", {
      className: "docs-5-title",
      children: [" ", post ? post.title.rendered : '', "  "]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "dox5-section-item",
      children: docSections && Array.isArray(docSections) && docSections.map(section => {
        const {
          title,
          id
        } = section;

        // Find the child items for the current section
        const sectionItems = allDocItems.find(item => item.parentId === id)?.items || [];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "section5-article",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "section5-section-title",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h6", {
              children: title && title.rendered ? title.rendered : "No Title Available"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
            className: "navbar-nav docs-single5-nav-wrap ezd-list-unstyled",
            children: sectionItems && Array.isArray(sectionItems) && sectionItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                href: "#",
                children: item.title && item.title.rendered ? item.title.rendered : "Untitled"
              })
            }, item.id))
          })]
        }, id);
      })
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/light.js":
/*!****************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/styles/light.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ light)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function light({
  attributes,
  docSections,
  articlesNumber
}) {
  const {
    col,
    docs_layout,
    readMoreText,
    show_topic,
    topic_label,
    sectionButton,
    sectionButtonText,
    btnURL,
    orderBy,
    child_docs_order,
    sectionsNumber,
    isFeaturedImage
  } = attributes;
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : `ezd-masonry-wrap ezd-masonry-col-${col}`;
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select("core").getEntityRecords("postType", "docs", {
        per_page: articlesNumber,
        order: child_docs_order,
        orderby: orderBy,
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, docSections, child_docs_order, orderBy]);
  const childCounts = allDocItems.reduce((acc, {
    parentId,
    items
  }) => {
    acc[parentId] = items ? items.length : 0;
    return acc;
  }, {});

  // State for all featured media images
  const [images, setImages] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const fetchImages = async () => {
      if (!Array.isArray(docSections)) {
        return;
      }
      const imagePromises = docSections.map(async section => {
        if (section.featured_media) {
          try {
            const media = await wp.apiFetch({
              path: `/wp/v2/media/${section.featured_media}`
            });
            return {
              id: section.id,
              imageUrl: media.source_url
            };
          } catch (error) {
            console.error("Error fetching media:", error);
            return {
              id: section.id,
              imageUrl: null
            };
          }
        }
        return {
          id: section.id,
          imageUrl: null
        };
      });
      const results = await Promise.all(imagePromises);
      const imageMap = results.reduce((acc, {
        id,
        imageUrl
      }) => {
        acc[id] = imageUrl;
        return acc;
      }, {});
      setImages(imageMap);
    };
    const safeDocSections = docSections || [];
    fetchImages(safeDocSections);
  }, [docSections]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: `${layoutType}`,
      children: docSections && docSections.map(section => {
        const {
          id,
          title,
          featured_media
        } = section;
        const docItems = allDocItems.find(item => item.parentId === id)?.items || [];

        // Get the image URL from state
        const imageUrl = images[id];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "categories_guide_item box-item wow fadeInUp single-doc-layout-one light-style",
          children: [isFeaturedImage && imageUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
            src: imageUrl,
            alt: title.rendered
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "doc-top ezd-d-flex ezd-align-items-start",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
              className: "doc_tag_title",
              href: "#",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
                className: "title",
                children: title.rendered
              }), show_topic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
                class: "ezd-badge",
                children: [" ", childCounts[section.id], " ", topic_label]
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
            className: "ezd-list-unstyled tag_list",
            children: docItems && docItems.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
                viewBox: "0 0 32 32",
                xmlns: "http://www.w3.org/2000/svg",
                width: "16",
                height: "16",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
                  d: "M 4,32l 24,0 c 1.104,0, 2-0.896, 2-2L 30,2 c0-1.104-0.896-2-2-2L 4,0 C 2.896,0, 2,0.896, 2,2l0,28 C 2,31.104, 2.896,32, 4,32z M 4,2l 24,0 l0,28 L 4,30 L 4,2 zM 23,6l-8,0 C 14.448,6, 14,6.448, 14,7C 14,7.552, 14.448,8, 15,8l 8,0 C 23.552,8, 24,7.552, 24,7 C 24,6.448, 23.552,6, 23,6zM 23,12l-14,0 C 8.448,12, 8,12.448, 8,13C 8,13.552, 8.448,14, 9,14l 14,0 C 23.552,14, 24,13.552, 24,13 C 24,12.448, 23.552,12, 23,12zM 23,18l-14,0 C 8.448,18, 8,18.448, 8,19C 8,19.552, 8.448,20, 9,20l 14,0 c 0.552,0, 1-0.448, 1-1 C 24,18.448, 23.552,18, 23,18zM 23,24l-14,0 C 8.448,24, 8,24.448, 8,25C 8,25.552, 8.448,26, 9,26l 14,0 c 0.552,0, 1-0.448, 1-1 C 24,24.448, 23.552,24, 23,24z"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
                className: "ct-content-text",
                href: "#",
                children: item.title.rendered
              })]
            }, item.id))
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
            href: "#",
            className: "doc_border_btn",
            children: [readMoreText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
              className: "arrow_right"
            })]
          })]
        }, id);
      })
    }), sectionButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      class: "text-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("a", {
        href: `${btnURL}`,
        class: "action_btn all_doc_btn wow fadeinUp",
        children: [sectionButtonText, " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("i", {
          class: "arrow_right"
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/components-presets/single-doc-presets/styles/topicsbox.js":
/*!********************************************************************************************!*\
  !*** ./src/eazy-docs/components/components-presets/single-doc-presets/styles/topicsbox.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ topicsbox)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function topicsbox({
  attributes,
  docSections
}) {
  const {
    articlesNumber,
    col,
    docs_layout,
    docId,
    excerptCharNumber,
    isFeaturedImage
  } = attributes;
  const [exceprtText, setExceprtText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)("");

  // Determine layout type
  const layoutType = docs_layout === "grid" ? `ezd-grid ezd-column-${col}` : "ezd-masonry-wrap";

  // Fetch the parent post (docId)
  const post = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    return select("core").getEntityRecord("postType", "docs", docId);
  }, [docId]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (post) {
      console.log("Post Title:", post.title.rendered);
    } else {
      console.log("Post not found or still loading.");
    }
  }, [post]);

  // Fetch all doc items (child sections) for each section in a single call
  const allDocItems = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const parentIds = docSections?.map(section => section.id) || [];
    return parentIds.map(parentId => ({
      parentId,
      items: select('core').getEntityRecords('postType', 'docs', {
        per_page: articlesNumber,
        order: 'asc',
        parent: parentId,
        status: ['publish', 'private']
      })
    }));
  }, [articlesNumber, docSections]);

  // Function to show first 'n' words of a sentence
  const showWords = (sentence, numberOfWords) => {
    // Split the sentence into an array of words
    let wordsArray = sentence.split(" ");

    // If the number of words to show is greater than the length of the array, return the original sentence
    if (numberOfWords >= wordsArray.length) {
      return sentence;
    }

    // Slice the array to get the desired number of words and join them back into a string
    let truncatedSentence = wordsArray.slice(0, numberOfWords).join(" ");

    // Return the truncated sentence
    return truncatedSentence;
  };

  // Helper function to get the excerpt or first N words of the content
  const getExcerptOrContent = (content, excerpt) => {
    // Check if excerpt is available and if it has a rendered value
    if (excerpt && excerpt.rendered) {
      let excerptString = excerpt.rendered;
      let updatedExcerptString = excerptString.replace("<p>", "").replace("</p>", "");
      return showWords(updatedExcerptString, excerptCharNumber);
    }
    return "";
  };

  // State for all featured media images
  const [images, setImages] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const fetchImages = async () => {
      if (!Array.isArray(docSections)) {
        return;
      }
      const imagePromises = docSections.map(async section => {
        if (section.featured_media) {
          try {
            const media = await wp.apiFetch({
              path: `/wp/v2/media/${section.featured_media}`
            });
            return {
              id: section.id,
              imageUrl: media.source_url
            };
          } catch (error) {
            console.error("Error fetching media:", error);
            return {
              id: section.id,
              imageUrl: null
            };
          }
        }
        return {
          id: section.id,
          imageUrl: null
        };
      });
      const results = await Promise.all(imagePromises);
      const imageMap = results.reduce((acc, {
        id,
        imageUrl
      }) => {
        acc[id] = imageUrl;
        return acc;
      }, {});
      setImages(imageMap);
    };
    const safeDocSections = docSections || [];
    fetchImages(safeDocSections);
  }, [docSections]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: `ezd-grid ezd-column-${col} h_content_items topic-box-style`,
    children: docSections && docSections.map(section => {
      const {
        title,
        id,
        excerpt,
        content,
        featured_media
      } = section; // Get excerpt and content for the parent section

      // State and effect for featured image
      const imageUrl = images[id];

      // Get the excerpt or first 'excerptCharNumber' words for the parent section
      const parentExcerptOrContent = getExcerptOrContent(content.rendered, excerpt);

      // Find the child items for the current section using its parentId
      const sectionItems = allDocItems.find(item => item.parentId === id)?.items || [];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("a", {
        href: "#",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "h_item",
          children: [isFeaturedImage && imageUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
            src: imageUrl,
            alt: title.rendered
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
            className: "ct-heading-text",
            children: title.rendered
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "ct-content-text",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
              children: parentExcerptOrContent
            }), sectionItems && sectionItems.length > 0 && sectionItems.map(childItem => {
              // Get the content or excerpt for each child item
              const excerptOrContent = getExcerptOrContent(childItem.excerpt.rendered);

              // Wrap child content in a <div> element
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
                children: excerptOrContent
              }, childItem.id);
            })]
          })]
        })
      }, id);
    })
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/multi-doc/MulltiDoc.js":
/*!*********************************************************!*\
  !*** ./src/eazy-docs/components/multi-doc/MulltiDoc.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MultiDoc)
/* harmony export */ });
/* harmony import */ var _components_presets_multi_doc_presets_MultiPreset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components-presets/multi-doc-presets/MultiPreset */ "./src/eazy-docs/components/components-presets/multi-doc-presets/MultiPreset.js");
/* harmony import */ var _PreviewChoose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../PreviewChoose */ "./src/eazy-docs/components/PreviewChoose.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function MultiDoc({
  attributes,
  setAttributes,
  docPosts,
  multiDocs
}) {
  const {
    docPreset,
    articlesNumber,
    show_docs
  } = attributes;

  // sections title post
  const docSections = [];

  // let docPostsTitle = [ { label: 'Select a Doc title', value:null } ];
  let docPostsTitle = [];
  if (docPosts && docPosts.length > 0) {
    docPostsTitle = docPosts.map(post => ({
      label: post.title.rendered,
      value: post.id
    }));
  }
  let presetTemplate;
  presetTemplate = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_components_presets_multi_doc_presets_MultiPreset__WEBPACK_IMPORTED_MODULE_0__["default"], {
    docSections: docSections,
    attributes: attributes,
    articlesNumber: articlesNumber,
    multiDocs: multiDocs,
    show_docs: show_docs
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_PreviewChoose__WEBPACK_IMPORTED_MODULE_1__["default"], {
      attributes: attributes,
      setAttributes: setAttributes
    }), presetTemplate]
  });
}

/***/ }),

/***/ "./src/eazy-docs/components/multi-doc/custom-functions.js":
/*!****************************************************************!*\
  !*** ./src/eazy-docs/components/multi-doc/custom-functions.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   doc_ids: () => (/* binding */ doc_ids)
/* harmony export */ });
/**
 * Custom Functions
 */
function doc_ids(arr) {
  let doc_ids = '';
  if (arr) {
    for (let i = 0; i < arr.length; i++) {
      let doc_split = arr[i].split('|');
      let doc_id = doc_split[0].trim();
      let comma = i === arr.length - 1 ? '' : ',';
      doc_ids += doc_id + comma;
    }
  }
  return doc_ids;
}

/***/ }),

/***/ "./src/eazy-docs/components/single-doc/SingleDoc.js":
/*!**********************************************************!*\
  !*** ./src/eazy-docs/components/single-doc/SingleDoc.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SingleDoc)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_presets_single_doc_presets_SinglePreset__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components-presets/single-doc-presets/SinglePreset */ "./src/eazy-docs/components/components-presets/single-doc-presets/SinglePreset.js");
/* harmony import */ var _PreviewChoose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../PreviewChoose */ "./src/eazy-docs/components/PreviewChoose.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function SingleDoc({
  attributes,
  setAttributes,
  docPosts
}) {
  const {
    docSinglePreset,
    parentTitle,
    docId,
    sectionsNumber,
    articlesNumber,
    parent_docs_order
  } = attributes;

  // sections title post
  const docSections = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    return select('core').getEntityRecords('postType', 'docs', {
      per_page: sectionsNumber,
      order: parent_docs_order,
      orderby: 'menu_order',
      parent: docId,
      status: ['publish', 'private']
    });
  }, [docId, sectionsNumber, parent_docs_order]);
  let docPostsTitle = [];
  if (docPosts && docPosts.length > 0) {
    docPostsTitle = docPosts.map(post => ({
      label: post.title.rendered,
      value: post.id
    }));
  }
  let presetTemplate = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_components_presets_single_doc_presets_SinglePreset__WEBPACK_IMPORTED_MODULE_1__["default"], {
    docSections: docSections,
    attributes: attributes,
    articlesNumber: articlesNumber
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_PreviewChoose__WEBPACK_IMPORTED_MODULE_2__["default"], {
      attributes: attributes,
      setAttributes: setAttributes
    }), presetTemplate]
  });
}

/***/ }),

/***/ "./src/eazy-docs/edit.js":
/*!*******************************!*\
  !*** ./src/eazy-docs/edit.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editor.scss */ "./src/eazy-docs/editor.scss");
/* harmony import */ var _components_single_doc_SingleDoc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/single-doc/SingleDoc */ "./src/eazy-docs/components/single-doc/SingleDoc.js");
/* harmony import */ var _components_multi_doc_MulltiDoc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/multi-doc/MulltiDoc */ "./src/eazy-docs/components/multi-doc/MulltiDoc.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _components_multi_doc_custom_functions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/multi-doc/custom-functions */ "./src/eazy-docs/components/multi-doc/custom-functions.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);




// editor style







jQuery(document).ready(function () {
  jQuery(document).on('click', 'body:not(.ezd-premium) .eazydocs-pro-notice', function (e) {
    e.preventDefault();
    let href = jQuery(this).attr('href');
    Swal.fire({
      title: 'Opps...',
      html: 'This is a PRO feature. You need to <a href="admin.php?page=eazydocs-pricing"><strong class="upgrade-link">Upgrade&nbsp;&nbsp;➤</strong></a> to the Premium Version to use this feature',
      icon: "warning",
      buttons: [false, "Close"],
      dangerMode: true
    });
  });
});
function Edit({
  attributes,
  setAttributes
}) {
  const {
    docTypes,
    docPreset,
    docSinglePreset,
    docId,
    sectionsNumber,
    sectionsTwoNumber,
    articlesNumber,
    parent_docs_order,
    readMoreText,
    sectionButton,
    isFeaturedImage,
    sectionButtonText,
    btnURL,
    titleText,
    titleTag,
    excerptCharNumber,
    topic_label,
    show_topic,
    col,
    include,
    exclude,
    show_docs,
    more,
    child_docs_order,
    orderBy,
    docs_layout,
    imageUrl
  } = attributes;
  const sortBy = orderBy === 'rand' ? 'title' : orderBy;

  // Get all posts which parent is 'docs' post type 5 post in sidebar
  const docPosts = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => {
    try {
      return select('core').getEntityRecords('postType', 'docs', {
        per_page: -1,
        order: 'desc',
        orderby: 'menu_order',
        parent: 0,
        status: ['publish', 'private']
      });
    } catch (error) {
      console.error('Error fetching doc posts:', error);
      return [];
    }
  }, [child_docs_order]);
  const options = [{
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select a Doc', 'eazydocs-pro'),
    value: ''
  },
  // Empty option
  ...(docPosts ? docPosts.map(post => ({
    label: post.title.rendered,
    value: post.id
  })) : [])];
  const onImageSelect = media => {
    setAttributes({
      imageUrl: media.url
    });
  };
  const multiDocs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => {
    try {
      // Recreate multiDocsArgs every time orderBy or other dependencies change
      const multiDocsArgs = {
        per_page: show_docs,
        order: parent_docs_order,
        // or use orderBy here if needed
        orderby: sortBy,
        parent: 0,
        status: ['publish', 'private']
      };

      // Include or exclude specific docs based on include and exclude attributes
      if ((0,_components_multi_doc_custom_functions__WEBPACK_IMPORTED_MODULE_7__.doc_ids)(include).length > 0) {
        multiDocsArgs.include = (0,_components_multi_doc_custom_functions__WEBPACK_IMPORTED_MODULE_7__.doc_ids)(include);
      }
      if ((0,_components_multi_doc_custom_functions__WEBPACK_IMPORTED_MODULE_7__.doc_ids)(exclude).length > 0) {
        multiDocsArgs.exclude = (0,_components_multi_doc_custom_functions__WEBPACK_IMPORTED_MODULE_7__.doc_ids)(exclude);
      }

      // Fetch the docs using the dynamically created multiDocsArgs
      return select('core').getEntityRecords('postType', 'docs', multiDocsArgs);
    } catch (error) {
      console.error('Error fetching doc posts:', error);
      return [];
    }
  }, [show_docs, orderBy, include, exclude, parent_docs_order]);
  const docs = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_6__.useSelect)(select => {
    return select("core").getEntityRecords('postType', 'docs', {
      parent: 0,
      status: ['publish', 'private']
    });
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (docId === null) {
      if (docPosts !== undefined || docPosts.length !== 0) {
        if (docPosts) {
          setAttributes({
            docId: docPosts[0].docId
          });
        }
      }
    }
  }, [docPosts]);
  const docSuggestions = docs ? docs.map(doc => doc.id + " | " + doc.title.rendered) : [];
  // console.log("docSuggestions", docSuggestions);

  const orderOptions = [{
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Ascending', 'eazydocs-pro'),
    value: 'asc'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Descending', 'eazydocs-pro'),
    value: 'desc'
  }];
  const layoutOptions = [{
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Masonry', 'eazydocs-pro'),
    value: 'masonry'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Grid', 'eazydocs-pro'),
    value: 'grid'
  }];
  const parentOrderOptions = [{
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Title', 'eazydocs-pro'),
    value: 'title'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Post Author', 'eazydocs-pro'),
    value: 'author'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Date', 'eazydocs-pro'),
    value: 'date'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Post ID', 'eazydocs-pro'),
    value: 'id'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Last Modified Date', 'eazydocs-pro'),
    value: 'modified'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Random', 'eazydocs-pro'),
    value: 'rand'
  }, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Menu Order', 'eazydocs-pro'),
    value: 'menu_order'
  }];
  const proAlert = eazydocs_local_object.is_ezd_pro_block == 'yes' ? '' : ' Pro';
  const proAlertClass = eazydocs_local_object.is_ezd_pro_block == 'yes' ? '' : 'eazydocs-pro-notice';
  function handleDocOption(val) {
    setAttributes({
      docTypes: val
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.InspectorControls, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
        initialOpen: true,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select Doc's Type test", 'eazydocs-pro'),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalToggleGroupControl, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Doc Type", 'eazydocs-pro'),
          value: docTypes,
          isBlock: true,
          __nextHasNoMarginBottom: true,
          onChange: handleDocOption,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalToggleGroupControlOption, {
            value: "single-doc",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Single Doc", 'eazydocs-pro')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalToggleGroupControlOption, {
            value: "multi-doc",
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Multi Doc", 'eazydocs-pro')
          })]
        }), docPreset === 'creative' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
          initialOpen: false,
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Title Settings', 'eazydocs-pro'),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Title Text', 'eazydocs-pro'),
            value: titleText,
            onChange: value => setAttributes({
              titleText: value
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Title Tag', 'eazydocs-pro'),
            value: titleTag,
            options: [{
              label: 'H1',
              value: 'h1'
            }, {
              label: 'H2',
              value: 'h2'
            }, {
              label: 'H3',
              value: 'h3'
            }, {
              label: 'H4',
              value: 'h4'
            }, {
              label: 'H5',
              value: 'h5'
            }, {
              label: 'H6',
              value: 'h6'
            }],
            onChange: value => setAttributes({
              titleTag: value
            }),
            __nextHasNoMarginBottom: true
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.MediaUpload, {
            onSelect: media => setAttributes({
              imageUrl: media.url
            }),
            allowedTypes: ['image'],
            value: imageUrl !== null && imageUrl !== void 0 ? imageUrl : ezdAssets.ezd_img_dir + '/widgets/docbg-shap.png',
            render: ({
              open
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                style: {
                  marginBottom: '10px'
                },
                children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('BACKGROUND IMAGE', 'eazydocs-pro'), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
                  style: {
                    marginTop: '10px'
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
                    src: imageUrl !== null && imageUrl !== void 0 ? imageUrl : ezdAssets.ezd_img_dir + '/widgets/docbg-shap.png',
                    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Preview Image', 'eazydocs-pro'),
                    style: {
                      maxWidth: '100px',
                      height: '50px'
                    }
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
                  style: {
                    marginTop: '10px'
                  },
                  className: "button widefat",
                  onClick: open,
                  variant: "secondary",
                  children: (imageUrl !== null && imageUrl !== void 0 ? imageUrl : ezdAssets.ezd_img_dir + '/widgets/docbg-shap.png') ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Replace Image', 'eazydocs-pro') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Upload Image', 'eazydocs-pro')
                })]
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
          initialOpen: true,
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Settings', 'eazydocs-pro'),
          children: [docTypes === 'single-doc' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select a Doc', 'eazydocs-pro'),
              value: docId,
              options: options,
              onChange: newId => setAttributes({
                docId: newId
              }),
              __nextHasNoMarginBottom: true
            })
          }), docPreset != 'collaborative_docs' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [!(docTypes === 'single-doc' && ['docbox'].includes(docSinglePreset)) && !(docTypes === 'multi-doc' && ['flat_tabbed_docs'].includes(docPreset)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.RangeControl, {
              initialPosition: col,
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Columns', 'eazydocs-pro'),
              max: 6,
              min: 1,
              shiftStep: 2,
              onChange: val => {
                setAttributes({
                  col: val
                });
              }
            }), !(docTypes === 'single-doc' && ['topicsbox', 'docbox'].includes(docSinglePreset)) && !(docTypes === 'multi-doc' && ['flat_tabbed_docs'].includes(docPreset)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.RadioControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Docs Layout' + `${proAlert}`, 'eazydocs-pro'),
              selected: docs_layout,
              options: layoutOptions,
              className: `${proAlertClass}`,
              disabled: eazydocs_local_object.is_ezd_pro_block == 'yes' ? false : true,
              onChange: value => setAttributes({
                docs_layout: value
              })
            })]
          }), docPreset != 'collaborative_docs' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [docTypes === 'single-doc' && ['topicsbox', 'docbox', 'box', 'creative', 'light'].includes(docSinglePreset) || docTypes === 'multi-doc' && ['docbox', 'boxed_tabbed_docs', 'tabbed_doc_list'].includes(docPreset) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sections', 'eazydocs-pro'),
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of Sections to display. Use -1 to show all.', 'eazydocs-pro'),
              isShiftStepEnabled: true,
              onChange: newValue => setAttributes({
                sectionsNumber: newValue
              }),
              shiftStep: 10,
              value: sectionsNumber
            }) : null, docSinglePreset === 'topicsbox' && docTypes === 'single-doc' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sections 2', 'eazydocs-pro'),
                isShiftStepEnabled: true,
                onChange: newValue => setAttributes({
                  sectionsTwoNumber: newValue
                }),
                shiftStep: 10,
                value: sectionsTwoNumber
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Excerpt Chars', 'eazydocs-pro'),
                isShiftStepEnabled: true,
                onChange: newValue => setAttributes({
                  excerptCharNumber: newValue
                }),
                shiftStep: 10,
                value: excerptCharNumber
              })]
            }), docSinglePreset != 'topicsbox' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Articles', 'eazydocs-pro'),
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of articles to display. Use -1 to show all.', 'eazydocs-pro'),
              isShiftStepEnabled: true,
              onChange: newValue => setAttributes({
                articlesNumber: newValue
              }),
              shiftStep: 10,
              value: articlesNumber
            })]
          }), docPreset !== 'docbox' && docPreset !== 'collaborative_docs' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: docTypes === 'single-doc' && ['box', 'light'].includes(docSinglePreset) || docTypes === 'multi-doc' && ['box', 'light'].includes(docPreset) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Topic Count', 'eazydocs-pro'),
                checked: show_topic,
                onChange: value => setAttributes({
                  show_topic: value
                })
              }), show_topic && docPreset !== 'box' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Topic Count Text', 'eazydocs-pro'),
                value: topic_label,
                onChange: value => setAttributes({
                  topic_label: value
                })
              })]
            }) : null
          }), docTypes === 'multi-doc' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalNumberControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of Docs', 'eazydocs-pro'),
              isShiftStepEnabled: true,
              onChange: value => setAttributes({
                show_docs: value
              }),
              shiftStep: 10,
              value: show_docs,
              min: 1,
              __nextHasNoMarginBottom: true,
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of Main Docs to show', 'eazydocs-pro')
            }), exclude.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormTokenField, {
              __experimentalAutoSelectFirstMatch: true,
              __experimentalExpandOnFocus: true,
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Docs to Show', 'eazydocs-pro'),
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select specific docs to show. Leave empty to show all.', 'eazydocs-pro'),
              suggestions: docSuggestions,
              value: include,
              onChange: value => setAttributes({
                include: value
              })
            }), include.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormTokenField, {
              __experimentalAutoSelectFirstMatch: true,
              __experimentalExpandOnFocus: true,
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Docs Not to Show', 'eazydocs-pro'),
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select specific docs to exclude.', 'eazydocs-pro'),
              suggestions: docSuggestions,
              value: exclude,
              onChange: value => setAttributes({
                exclude: value
              })
            })]
          }), docSinglePreset != 'topicsbox' && docPreset != 'docbox' && docPreset != 'collaborative_docs' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [docPreset != 'creative' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Read More Button', 'eazydocs-pro'),
              value: readMoreText,
              onChange: value => setAttributes({
                readMoreText: value
              })
            }), docTypes === 'single-doc' && ['creative', 'light'].includes(docSinglePreset) || docTypes === 'multi-doc' && ['creative', 'light'].includes(docPreset) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Section Button enable', 'eazydocs-pro'),
                checked: sectionButton,
                onChange: newValue => setAttributes({
                  sectionButton: newValue
                })
              }), sectionButton && docPreset !== 'box' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Button text', 'eazydocs-pro'),
                  value: sectionButtonText,
                  onChange: value => setAttributes({
                    sectionButtonText: value
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Button URL', 'eazydocs-pro'),
                  value: btnURL,
                  onChange: value => setAttributes({
                    btnURL: value
                  })
                })]
              })]
            }) : null]
          }), !(docTypes === 'single-doc' && ['docbox'].includes(docSinglePreset)) && !(docTypes === 'multi-doc' && ['boxed_tabbed_docs', 'tabbed_doc_list', 'docbox'].includes(docPreset)) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Featured Image', 'eazydocs-pro'),
            checked: isFeaturedImage,
            onChange: newValue => setAttributes({
              isFeaturedImage: newValue
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
          initialOpen: false,
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Order", 'eazydocs-pro'),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Order by' + `${proAlert}`, 'eazydocs-pro'),
            value: orderBy,
            options: parentOrderOptions,
            disabled: eazydocs_local_object.is_ezd_pro_block == 'yes' ? false : true,
            className: `${proAlertClass}`,
            onChange: value => setAttributes({
              orderBy: value
            }),
            help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Some of the options ( Random ) might not show in the editor but will worked in frontend', 'eazydocs-pro')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Parent Docs Order', 'eazydocs-pro'),
            value: parent_docs_order,
            options: orderOptions,
            onChange: newVal => setAttributes({
              parent_docs_order: newVal
            }),
            __nextHasNoMarginBottom: true
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Child Docs Order', 'eazydocs-pro'),
            value: child_docs_order,
            options: orderOptions,
            onChange: value => setAttributes({
              child_docs_order: value
            })
          })]
        })]
      }), docTypes === 'multi-doc' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
        value: docPreset,
        style: {
          display: 'none'
        }
      }), docTypes === 'single-doc' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
        value: docSinglePreset,
        onChange: value => setAttributes({
          docSinglePreset: value
        }),
        style: {
          display: 'none'
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)(),
      children: [docTypes === "single-doc" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_single_doc_SingleDoc__WEBPACK_IMPORTED_MODULE_4__["default"], {
        attributes: attributes,
        setAttributes: setAttributes,
        articlesNumber: articlesNumber
      }), docTypes === "multi-doc" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_components_multi_doc_MulltiDoc__WEBPACK_IMPORTED_MODULE_5__["default"], {
        attributes: attributes,
        setAttributes: setAttributes,
        docPosts: docPosts,
        multiDocs: multiDocs
      })]
    })]
  });
}

/***/ }),

/***/ "./src/eazy-docs/save.js":
/*!*******************************!*\
  !*** ./src/eazy-docs/save.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
function save() {
  return null;
}

/***/ }),

/***/ "./src/eazy-docs/editor.scss":
/*!***********************************!*\
  !*** ./src/eazy-docs/editor.scss ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets sync \\.(png%7Cjpg%7Cjpeg%7Cgif%7Csvg)$":
/*!**************************************************************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/ sync nonrecursive \.(png%7Cjpg%7Cjpeg%7Cgif%7Csvg)$ ***!
  \**************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./box.png": "./src/eazy-docs/assets/images/widgets/box.png",
	"./boxed_tabbed_docs.png": "./src/eazy-docs/assets/images/widgets/boxed_tabbed_docs.png",
	"./collaborative_docs.png": "./src/eazy-docs/assets/images/widgets/collaborative_docs.png",
	"./creative.png": "./src/eazy-docs/assets/images/widgets/creative.png",
	"./docbox.png": "./src/eazy-docs/assets/images/widgets/docbox.png",
	"./flat_tabbed_docs.png": "./src/eazy-docs/assets/images/widgets/flat_tabbed_docs.png",
	"./light.png": "./src/eazy-docs/assets/images/widgets/light.png",
	"./tabbed_doc_list.png": "./src/eazy-docs/assets/images/widgets/tabbed_doc_list.png",
	"./topicsbox.png": "./src/eazy-docs/assets/images/widgets/topicsbox.png"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./src/eazy-docs/assets/images/widgets sync \\.(png%7Cjpg%7Cjpeg%7Cgif%7Csvg)$";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/box.png":
/*!*****************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/box.png ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/box.89c9d9ac.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/boxed_tabbed_docs.png":
/*!*******************************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/boxed_tabbed_docs.png ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/boxed_tabbed_docs.6feb5dad.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/collaborative_docs.png":
/*!********************************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/collaborative_docs.png ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/collaborative_docs.f00c7f29.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/creative.png":
/*!**********************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/creative.png ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/creative.c33de2bf.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/docbox.png":
/*!********************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/docbox.png ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/docbox.1d6d71b6.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/flat_tabbed_docs.png":
/*!******************************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/flat_tabbed_docs.png ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/flat_tabbed_docs.43f031f2.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/light.png":
/*!*******************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/light.png ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/light.75243420.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/tabbed_doc_list.png":
/*!*****************************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/tabbed_doc_list.png ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/tabbed_doc_list.70217c98.png";

/***/ }),

/***/ "./src/eazy-docs/assets/images/widgets/topicsbox.png":
/*!***********************************************************!*\
  !*** ./src/eazy-docs/assets/images/widgets/topicsbox.png ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
module.exports = __webpack_require__.p + "images/topicsbox.7f424143.png";

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = window["ReactJSXRuntime"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/eazy-docs/block.json":
/*!**********************************!*\
  !*** ./src/eazy-docs/block.json ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"apiVersion":3,"name":"eazydocs-pro/eazy-docs","version":"0.1.0","title":"EazyDocs Grid","category":"eazydocs","icon":"media-document","description":"Show single or multi docs in a grid layout.","supports":{"html":false,"anchor":true},"attributes":{"docTypes":{"type":"string","default":"single-doc"},"docPreset":{"type":"string","default":"light"},"docSinglePreset":{"type":"string","default":"light"},"imageUrl":{"type":"string"},"sections":{"type":"number","default":3},"articles":{"type":"number","default":3},"order":{"type":"string","default":"desc"},"include":{"type":"array","default":[]},"exclude":{"type":"array","default":[]},"show_docs":{"type":"string","default":-1},"articlesNumber":{"type":"string","default":-1},"more":{"type":"string","default":"View Details"},"orderBy":{"type":"string","default":"title"},"child_docs_order":{"type":"string","default":"desc"},"parent_docs_order":{"type":"string","default":"asc"},"docs_layout":{"type":"string","default":"grid"},"preset":{"type":"string","default":"light"},"presetPreview":{"type":"boolean","default":true},"docId":{"type":"string","default":null},"sectionsNumber":{"type":"string","default":5},"sectionsTwoNumber":{"type":"string","default":5},"readMoreText":{"type":"string","default":"Read More"},"sectionButton":{"type":"boolean","default":false},"sectionButtonText":{"type":"string","default":"View More"},"isFeaturedImage":{"type":"boolean","default":true},"btnURL":{"type":"string","default":"#"},"titleText":{"type":"string","default":"Write Title Text"},"titleTag":{"type":"string","default":"h2"},"excerptCharNumber":{"type":"string","default":12},"showMoreBtn":{"type":"boolean","default":true},"showLessBtn":{"type":"boolean","default":false},"parentTitle":{"type":"string"},"isPreviewOpen":{"type":"boolean","default":false},"col":{"type":"number","default":2},"show_topic":{"type":"boolean","default":true},"topic_label":{"type":"string","default":"Topics"}},"textdomain":"eazydocs-pro","editorScript":"file:./index.js","editorStyle":"file:./index.css"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript && document.currentScript.tagName.toUpperCase() === 'SCRIPT')
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl + "../";
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!********************************!*\
  !*** ./src/eazy-docs/index.js ***!
  \********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./block.json */ "./src/eazy-docs/block.json");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit */ "./src/eazy-docs/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./save */ "./src/eazy-docs/save.js");

//import './style.scss';



/**
 * Internal dependencies
 */



/**
 * Block Registration
 */
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_1__, {
  edit: _edit__WEBPACK_IMPORTED_MODULE_2__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_3__["default"]
});
})();

/******/ })()
;
//# sourceMappingURL=index.js.map