<?php 
// Include necessary files
include_once EAZYDOCSPRO_PATH . '/includes/feedback/action.php';

// Get current tab
$current_tab = isset( $_GET['tab'] ) && in_array( $_GET['tab'], ['doc', 'text'] ) ? $_GET['tab'] : 'doc';

// Handle search input
$feedback_search = isset( $_GET['feedback_search'] ) ? sanitize_text_field( $_GET['feedback_search'] ) : '';

// Current status filter
$current_status = isset( $_GET['status'] ) && $_GET['status'] === 'archive' ? 'archive' : 'open';

// Initialize counters
$open_count    = 0;
$archive_count = 0;

/**
 * ====================================
 * TEXT FEEDBACK TAB (comments)
 * ====================================
 */
if ( $current_tab === 'text' ) {
    $args = [
        'post_type'      => 'ezd-text-feedback',
        'posts_per_page' => -1,
        'meta_query'     => [],
    ];

    if ( $feedback_search ) {
        $args['s'] = $feedback_search;
    }

    $query = new WP_Query( $args );

    // Count open & archived
    if ( $query->have_posts() ) {
        while ( $query->have_posts() ) {
            $query->the_post();
            $is_archived = get_post_meta( get_the_ID(), 'ezd_feedback_archived', true );
            if ( $is_archived === 'true' ) {
                $archive_count++;
            } else {
                $open_count++;
            }
        }
        wp_reset_postdata();
    }

/**
 * ====================================
 * FULL DOC FEEDBACK TAB (CPT)
 * ====================================
 */
} else {
    $args = [
        'post_type'      => 'ezd_feedback',
        'posts_per_page' => -1,
        'meta_query'     => [
            'relation' => 'OR',
            [
                'key'     => 'ezd_feedback_type',
                'value'   => 'doc',
                'compare' => '='
            ],
            [
                'key'     => 'ezd_feedback_type',
                'compare' => 'NOT EXISTS'
            ]
        ]
    ];
    
    if ( $feedback_search ) {
        $args['s'] = $feedback_search;
    }
    
    $query = new WP_Query( $args );

    // Count open & archived
    if ( $query->have_posts() ) {
        while ( $query->have_posts() ) {
            $query->the_post();
            $feedback_status = get_post_meta( get_the_ID(), 'ezd_feedback_status', true );
            if ( $feedback_status === 'false' ) {
                $archive_count++;
            } else {
                $open_count++;
            }
        }
        wp_reset_postdata();
    }
}
?>

<div class="wrap">
    <h2><?php esc_html_e( 'User Feedback', 'eazydocs-pro' ); ?></h2>

    <!-- Tabs -->
    <h2 class="nav-tab-wrapper ezd-nav-tab-wrapper">
        <a href="<?php echo esc_url( add_query_arg( 'tab', 'doc', remove_query_arg( [ 'status', 'feedback_search' ] ) ) ); ?>" 
           class="nav-tab <?php echo $current_tab === 'doc' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e( 'Full Doc Feedback', 'eazydocs-pro' ); ?>
        </a>
        <a href="<?php echo esc_url( add_query_arg( 'tab', 'text', remove_query_arg( [ 'status', 'feedback_search' ] ) ) ); ?>" 
           class="nav-tab <?php echo $current_tab === 'text' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e( 'Feedback on Text', 'eazydocs-pro' ); ?>
        </a>
    </h2>

    <div class="ezd-feedback-wrap">
        <div class="ezd-head-options-wrap">
            <!-- Filters -->
            <div class="ezd-head-opt-btn"> 
                <a href="<?php echo esc_url( add_query_arg( [ 'tab' => $current_tab, 'status' => 'open' ], remove_query_arg( [ 'status', 'feedback_search' ] ) ) ); ?>" 
                   class="<?php echo $current_status === 'open' ? 'active' : ''; ?>">
                    <?php esc_html_e( 'Open', 'eazydocs-pro' ); ?>
                    <span>(<?php echo intval( $open_count ); ?>)</span>
                </a>
                <a href="<?php echo esc_url( add_query_arg( [ 'tab' => $current_tab, 'status' => 'archive' ], remove_query_arg( [ 'status', 'feedback_search' ] ) ) ); ?>" 
                   class="<?php echo $current_status === 'archive' ? 'active' : ''; ?>">
                    <?php esc_html_e( 'Archived', 'eazydocs-pro' ); ?>
                    <span>(<?php echo intval( $archive_count ); ?>)</span>
                </a>
            </div>

            <!-- Search -->
            <div class="ezd-head-opt-search"> 
                <form method="get" action="<?php echo esc_url( admin_url( 'admin.php' ) ); ?>">
                    <input type="hidden" name="page" value="ezd-user-feedback">
                    <input type="hidden" name="tab" value="<?php echo esc_attr( $current_tab ); ?>">
                    <input type="hidden" name="status" value="<?php echo esc_attr( $current_status ); ?>">
                    <input type="search" name="feedback_search" value="<?php echo esc_attr( $feedback_search ); ?>" placeholder="<?php esc_attr_e( 'Search feedback...', 'eazydocs-pro' ); ?>">
                    <input type="submit" value="<?php esc_attr_e( 'Search Feedback', 'eazydocs-pro' ); ?>" class="button button-default">
                </form>
            </div>
        </div>

        <?php 
        /**
         * =========================
         * TEXT FEEDBACK SECTION
         * =========================
         */
        if ( $current_tab === 'text' ) :
        $has_feedback = false;

        if ( $query->have_posts() ) :
            while ( $query->have_posts() ) :
                $query->the_post();
                $is_archived = get_post_meta( get_the_ID(), 'ezd_feedback_archived', true );

                if ( ( $current_status === 'archive' && $is_archived === 'true' ) ||
                    ( $current_status === 'open' && $is_archived !== 'true' ) ) :
                    $has_feedback = true;
                    do_action( 'ezd_text_feedback_loop', get_the_ID() );
                endif;
            endwhile;
            wp_reset_postdata();

            if ( ! $has_feedback ) :
                ?>
                <p class="ezd-no-feedback-found">
                    <?php echo $current_status === 'archive' 
                        ? esc_html__( 'No archived text feedback found!', 'eazydocs-pro' ) 
                        : esc_html__( 'No open text feedback found!', 'eazydocs-pro' ); ?>
                </p>
                <?php
            endif;
        else :
            ?>
            <p class="ezd-no-feedback-found"><?php esc_html_e( 'No text feedback found!', 'eazydocs-pro' ); ?></p>
            <?php
        endif;

        /**
         * =========================
         * DOC FEEDBACK SECTION
         * =========================
         */
        else :
            $has_posts = false;

            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) :
                    $query->the_post();
                   $feedback_status = get_post_meta( get_the_ID(), 'ezd_feedback_status', true );

                    if ( ( $current_status === 'archive' && $feedback_status === 'false' ) ||
                         ( $current_status === 'open' && $feedback_status !== 'false' ) ) :
                        $has_posts = true;
                        do_action( 'ezd_feedback_loop', get_the_ID() );
                    endif;
                endwhile;
                wp_reset_postdata();

                if ( ! $has_posts ) :
                    ?>
                    <p class="ezd-no-feedback-found">
                        <?php echo $current_status === 'archive' 
                            ? esc_html__( 'No archived feedback found!', 'eazydocs-pro' ) 
                            : esc_html__( 'No open feedback found!', 'eazydocs-pro' ); ?>
                    </p>
                    <?php
                endif;
            else :
                ?>
                <p class="ezd-no-feedback-found"><?php esc_html_e( 'No feedback found!', 'eazydocs-pro' ); ?></p>
                <?php
            endif;
        endif;
        ?>
    </div>
</div>