<?php

namespace WeDevs\Erp_Inventory\Classes;

/**
 * Admin Pages Handler
 */
class Admin {

    /**
     * Class constructor
     */
    public function __construct() {
        add_action( 'erp_acct_locale_script', [ $this, 'locale_script' ] );
        add_action( 'erp_acct_js_hook_loaded', [ $this, 'enqueue_scripts' ] );
    }

    /**
     * Registers locale script in admin head
     *
     * @since 1.3.6
     *
     * @return void
     */
    public function locale_script() {
        ?>
            <script>
                window.erpInventory = JSON.parse('<?php
                    echo json_encode( apply_filters( 'erp_inventory_localized_data', [] ) );
                ?>');
            </script>
        <?php
    }

    /**
     * Initialize our hooks for the admin page
     *
     * @return void
     */
    public function init_hooks() {
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
    }

    /**
     * Load scripts and styles for the app
     *
     * @return void
     */
    public function enqueue_scripts() {
        wp_enqueue_style( 'erp-acct-inventory-admin' );
        wp_enqueue_script( 'erp-acct-inventory-admin' );
    }
}
