<?php

namespace WeDevs\PaymentGateway;

/**
 * General class
 */
class PaymentGatewaySettings {

    /**
     * Class constructor
     */
    public function __construct() {
        add_filter( 'erp_get_sections_erp-ac', function( $sections ) {
            return $sections + [ 'payment' => __( 'Payment', 'erp-pro' ) ];
        } );

        add_filter( 'erp_settings_acct_section_fields', [ $this, 'get_payment_section_fields' ], 10, 2 );
    }

    /**
     * Initializes settings fields for payment
     *
     * @since 1.1.0
     *
     * @param array $fields
     * @param string $section
     *
     * @return array
     */
    public function get_payment_section_fields( $fields, $section ) {
        $form_fields   = apply_filters( 'erp_payment_gateway_settings_fields', [] );

        $data = [
            'sub_sections' => []
        ];

        foreach ( $form_fields as $key => $sub_section ) {
            $data['sub_sections'][$key ] = $sub_section[0]['title'];
            $data[ $key]                 = $sub_section;
        }

        $fields[ 'payment' ] = $data;

        return $fields;
    }
}
