<?php
	
namespace EventinPro\modules\rsvp;

class RsvpService
{
	public function __construct()
	{
		
	}
	
	public function createRsvp( $params ) {
		
		
		// Ensure required fields exist
		if ( empty($params['attendee_name']) || empty($params['attendee_email']) || empty($params['event_id']) ) {
			return new WP_Error('invalid_data', __('Missing required RSVP data', 'eventin-pro'), ['status_code' => 400]);
		}
		
		
		$attendeeEmail = $params['attendee_email'];
		$eventId       = $params['event_id'];
		$guests        = $params['guests'];
		
				
		// Check for existing RSVP
		$existingRsvps = get_posts([
			'post_status'    => 'publish',
			'post_type'      => 'etn_rsvp',
			'posts_per_page' => -1,
			'meta_query'     => [
				'relation' => 'AND',
				[
					'key'     => 'attendee_email',
					'value'   => $attendeeEmail,
					'compare' => 'IN'
				],
				[
					'key'   => 'event_id',
					'value' => $eventId
				]
			]
		]);
		
		
		// Insert new RSVP post
		$postId = wp_insert_post([
					'post_title'   => $params['attendee_name'],
					'post_content' => '',
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_parent'  => 0,
					'post_type'    => 'etn_rsvp',
				]);
		
		if ( is_wp_error($postId) ) {
			return $postId;
		}
		
		// Add metadata
		$metaFields = ['status', 'event_id', 'attendee_email'];
		
		
		foreach ( $metaFields as $field ) {
			if ( ! empty($params[$field]) ) {
				add_post_meta($postId, $field, $params[$field]);
			}
		}
		add_post_meta($postId, 'number_of_attendee', count($guests));
		add_post_meta($postId, 'etn_rsvp_value', $params['status'] );
		
		// insert guests
		foreach ( $guests as $guest ) {
			$rsvp_form_id = wp_insert_post([
						'post_title'   => $guest["name"],
						'post_content' => '',
						'post_status'  => 'publish',
						'post_author'  => 1,
						'post_parent'  => $postId,
						'post_type'    => 'etn_rsvp',
					]);
			// Store guest's individual data
			add_post_meta( $rsvp_form_id, "event_id", $eventId );
			add_post_meta( $rsvp_form_id, "attendee_email", $guest["email"] );
		}
		
		return $postId;
	}
	
	public function findAll( array $ids = [], $event_id = 0 ) {

		$args = array(
			'post_type'      => 'etn_rsvp',
			'post_parent'    => 0,
			'posts_per_page' => -1,
			'meta_query'     => array(
				array(
					'key'   => 'event_id',
					'value' => $event_id,
					'compare' => '=',
				),
    		),
		);
		
		if ( count($ids) > 0 ) {
			$args['post__in'] = $ids;
			$args['orderby'] = 'post__in';
		}
		$query = new \WP_Query( $args );
		$posts = $query->posts;
	
		
		return $posts;
	}
}