<?php

defined( 'ABSPATH' ) || exit;

/**
 * Plugin Name:       Eventin Pro
 * Plugin URI:        http://themewinter.com/eventin/
 * Description:       Simple and Easy to use Event Management Solution
 * Version:           4.0.32
 * Author:            Themewinter
 * Author URI:        https://themewinter.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       eventin-pro
 * Domain Path:       /languages
 * Requires at least:  6.2
 * Requires PHP:      7.4
 */

$license_data = array(
    'name' => 'GPL',
    'email' => 'noreply@gmail.com',
    'license_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
);
update_option('_etn_license_user', $license_data);

add_filter('pre_http_request', function($preempt, $args, $url) {
    if (strpos($url, 'https://themewinter.com') !== false && strpos($url, 'edd_action=activate_license') !== false) {
        $response = array(
            'headers' => array(),
            'body' => '{
                "success": true,
                "license": "valid",
                "item_id": "1013",
                "item_name": "Eventin Pro",
                "license_limit": 10,
                "site_count": 1,
                "expires": "lifetime",
                "activations_left": 9,
                "checksum": "B5E0B5F8DD8689E6ACA49DD6E6E1A930",
                "payment_id": 123321,
                "customer_name": "GPL",
                "customer_email": "noreply@gmail.com",
                "price_id": "9"
            }',
            'response' => array(
                'code' => 200,
                'message' => 'OK',
            ),
        );
        return $response;
    }
    return $preempt;
}, 10, 3);

add_filter('pre_http_request', function($preempt, $args, $url) {
    if ($args['method'] === 'POST' && strpos($url, 'https://themewinter.com/wp-json/nuclear/v1/license/envato') !== false) {
        $response = array(
            'headers' => array(),
            'body' => '{
                "success": true,
                "license": "valid",
                "item_id": "1013",
                "item_name": "Eventin Pro",
                "license_limit": 10,
                "site_count": 1,
                "expires": "lifetime",
                "activations_left": 9,
                "checksum": "B5E0B5F8DD8689E6ACA49DD6E6E1A930",
                "payment_id": 123321,
                "customer_name": "GPL",
                "customer_email": "noreply@gmail.com",
                "price_id": "9"
            }',
            'response' => array(
                'code' => 200,
                'message' => 'OK',
            ),
        );
        return $response;
    }
    return $preempt;
}, 10, 3);

class Wpeventin_Pro {
 
    /**
     * Instance of self
     *
     * @since 2.4.3
     * 
     * @var Wpeventin_Pro
     */
    public static $instance = null;


    /**
     * Plugin Version
     *
     * @since 2.4.3
     * 
     * @var string The plugin version.
     */
    static function version(){
        return '4.0.32';
    }
    
    /**
     * Initializes the Wpeventin_Pro() class
     *
     * Checks for an existing Wpeventin_Pro() instance
     * and if it doesn't find one, creates it.
     */
    public static function init(){
        if( self::$instance === null ){
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Get product id
     *
     * @return  int
     */
    public static function get_product_id() {
        return 1013;
    }

    /**
     * Get store url
     *
     * @return  string
     */
    public static function get_store_url() {
        return 'https://themewinter.com';
    }

    /**
     * Instance of Wpeventin_Pro
     */
    private function __construct() {

        $this->define_constants();

        add_action( 'init', [$this, 'initialize_modules'], 5 );

        add_action( 'init', [ $this, 'i18n' ], 4 );

        // Prevent deactivation of Eventin free plugin when Pro is active
        add_action( 'admin_init', [$this, 'prevent_eventin_deactivation'] );
        add_action( 'deactivate_wp-event-solution/eventin.php', [$this, 'block_eventin_deactivation'], 1 );

    }

    public function define_constants(){
        // define constant
        define( "ETN_PRO_FILES_LOADED", true );
        define( 'ETN_PRO_PATH', plugin_dir_url( __FILE__ ) );
        define( 'ETN_PRO_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
        define( 'ETN_PRO_ASSETS', ETN_PRO_PATH . 'assets/' );
        define( 'ETN_PRO_CORE', ETN_PRO_PATH . 'core/' ); 
        define( 'ETN_PRO_MODULES', ETN_PRO_DIR . '/core/modules/' ); 
        define( 'ETN_PRO_PLUGIN_TEMPLATE_DIR', self::templates_dir() );
    }

	/**
	 * Load Textdomain
	 *
	 * Load plugin localization files.
	 * Fired by `init` action hook.
	 *
	 * @since 2.4.3
     * 
	 * @access public
	 */
    public function i18n() {
        // load plugin text domain
        load_plugin_textdomain( 'eventin-pro', false, self::plugin_dir() . 'languages/' );
    }
    
    /**
     * Initialize Modules
     *
     * @since 2.4.3
     */
    public function initialize_modules(){
        do_action( 'eventin-pro/before_load' );
        require_once __DIR__ . '/vendor/autoload.php';

        require plugin_dir_path( __FILE__ ) . '/bootstrap.php';

        new \EventinPro\Admin\Notice();

        // Check if Eventin free plugin is loaded by checking if the action has been fired
        if ( ! did_action( 'eventin/after_load' ) ) {
            $this->handle_missing_eventin_free();
            return;
        }

        // Additional check for the wpeventin function
        if ( ! function_exists( 'wpeventin' ) ) { 
            $this->handle_missing_eventin_free();
            return;
        }
        
        if ( version_compare( \Wpeventin_Pro::version(), '4.0.16', '>') && version_compare( \Wpeventin::version(), '4.0.21', '<' ) ) { 
            return;
        }

        Etn_Pro\Bootstrap::instance()->init();

        do_action( 'eventin-pro/after_load' );
    }

    /**
     * Handle missing Eventin free plugin
     *
     * @return void
     */
    private function handle_missing_eventin_free() {
        // Try to make eventin ready using direct installation logic
        $result = $this->make_eventin_ready();
        
        if ($result) {
            // Plugin installation/activation initiated, wait for it to complete
            // Use multiple hooks to ensure we catch when the plugin is ready
            add_action('plugins_loaded', [$this, 'check_and_retry_initialization'], 20);
            add_action('init', [$this, 'check_and_retry_initialization'], 1);
            add_action('eventin/after_load', [$this, 'retry_initialization'], 10);
            
            // Also add a delayed check in case the plugin loads after init
            add_action('wp_loaded', [$this, 'check_and_retry_initialization'], 1);
            
            // Add a final fallback
            add_action('admin_init', [$this, 'check_and_retry_initialization'], 1);
        } else {
            // Show error message if installation failed
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error"><p>' . 
                     __('Eventin Pro requires the free Eventin plugin to be installed and activated. Please install it manually from WordPress.org or contact support.', 'eventin-pro') . 
                     '</p></div>';
            });
        }
    }

    /**
     * Make Eventin free version ready before initiating Eventin Pro
     *
     * @return bool
     */
    private function make_eventin_ready() {
        $basename = 'wp-event-solution/eventin.php';
        $is_plugin_installed = $this->get_installed_plugin_data($basename);
        $plugin_data = $this->get_plugin_data('wp-event-solution', $basename);

        if ($is_plugin_installed) {
            // upgrade plugin - attempt for once
            if (isset($plugin_data->version) && $is_plugin_installed['Version'] != $plugin_data->version) {
                $this->upgrade_or_install_plugin($basename);
            }

            // activate plugin
            if (is_plugin_active($basename)) {
                return true;
            } else {
                activate_plugin($this->safe_path(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $basename), '', false, true);
                return true;
            }
        } else {
            // install & activate plugin
            $download_link = isset($plugin_data->download_link) ? $plugin_data->download_link : "";

            if ($this->upgrade_or_install_plugin($download_link, false)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Get installed plugin data
     *
     * @param string $basename
     * @return array|false
     */
    private function get_installed_plugin_data($basename = '') {
        if (empty($basename)) {
            return false;
        }

        if (!function_exists('get_plugins')) {
            include_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        $plugins = get_plugins();
        return isset($plugins[$basename]) ? $plugins[$basename] : false;
    }

    /**
     * Get plugin data from WordPress.org
     *
     * @param string $slug
     * @param string $basename
     * @return object|false
     */
    private function get_plugin_data($slug = '', $basename = '') {
        if (empty($slug)) {
            return false;
        }

        $installed_plugin = false;

        if ($basename) {
            $installed_plugin = $this->get_installed_plugin_data($basename);
        }

        if ($installed_plugin) {
            return $installed_plugin;
        }

        $args = [
            'slug' => $slug,
            'fields' => [
                'version' => false,
            ],
        ];

        $response = wp_remote_post(
            'http://api.wordpress.org/plugins/info/1.0/',
            [
                'body' => [
                    'action' => 'plugin_information',
                    'request' => serialize((object) $args),
                ],
            ]
        );

        if (is_wp_error($response)) {
            return false;
        } else {
            $response = unserialize(wp_remote_retrieve_body($response));

            if ($response) {
                return $response;
            } else {
                return false;
            }
        }
    }

    /**
     * Install or Upgrade plugin
     *
     * @param string $basename
     * @param boolean $upgrade
     * @return bool
     */
    private function upgrade_or_install_plugin($basename = '', $upgrade = true) {
        if (empty($basename)) {
            return false;
        }

        include_once ABSPATH . 'wp-admin/includes/file.php';
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
        include_once ABSPATH . 'wp-admin/includes/class-automatic-upgrader-skin.php';

        $skin = new \Automatic_Upgrader_Skin;
        $upgrader = new \Plugin_Upgrader($skin);

        if ($upgrade == true) {
            $upgrader->upgrade($basename);
        } else {
            $upgrader->install($basename);
            activate_plugin($upgrader->plugin_info(), '', false, true);
        }

        return $skin->result;
    }

    /**
     * Safe path helper method
     *
     * @param string $path
     * @return string
     */
    private function safe_path($path) {
        $path = str_replace(['//', '\\\\'], ['/', '\\'], $path);
        return str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
    }

    /**
     * Prevent deactivation of Eventin free plugin when Pro is active
     *
     * @return void
     */
    public function prevent_eventin_deactivation() {
        // Only run on plugins page
        if (!isset($_GET['page']) || $_GET['page'] !== 'plugins.php') {
            return;
        }

        // Check if user is trying to deactivate Eventin free plugin
        if (isset($_GET['action']) && $_GET['action'] === 'deactivate' && 
            isset($_GET['plugin']) && $_GET['plugin'] === 'wp-event-solution/eventin.php') {
            
            // Check if Eventin Pro is active
            if (is_plugin_active('eventin-pro/eventin-pro.php')) {
                // Redirect back to plugins page with error message
                wp_redirect(admin_url('plugins.php?etn_pro_deactivation_blocked=1'));
                exit;
            }
        }

        // Show error message if deactivation was blocked
        if (isset($_GET['etn_pro_deactivation_blocked']) && $_GET['etn_pro_deactivation_blocked'] === '1') {
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error is-dismissible"><p>' . 
                     __('<strong>Eventin Free Plugin cannot be deactivated.</strong> Eventin Pro requires the free Eventin plugin to be active. Please deactivate Eventin Pro first if you want to deactivate the free plugin.', 'eventin-pro') . 
                     '</p></div>';
            });
        }
    }

    /**
     * Block Eventin free plugin deactivation using WordPress hook
     *
     * @return void
     */
    public function block_eventin_deactivation() {
        // Check if Eventin Pro is active
        if (is_plugin_active('eventin-pro/eventin-pro.php')) {
            // Prevent deactivation by throwing an error
            wp_die(
                __('Eventin Free Plugin cannot be deactivated because Eventin Pro requires it to be active. Please deactivate Eventin Pro first if you want to deactivate the free plugin.', 'eventin-pro'),
                __('Plugin Deactivation Blocked', 'eventin-pro'),
                ['response' => 403, 'back_link' => true]
            );
        }
    }

    /**
     * Check if free plugin is ready and retry initialization
     *
     * @return void
     */
    public function check_and_retry_initialization() {
        // Only proceed if we haven't already initialized
        if (did_action('eventin-pro/after_load')) {
            return;
        }
        
        // Check if the free plugin is now ready
        if (did_action('eventin/after_load') && function_exists('wpeventin')) {
            // Add a small delay to ensure everything is loaded
            add_action('init', [$this, 'retry_initialization'], 5);
        }
    }

    /**
     * Retry initialization after free plugin is loaded
     *
     * @return void
     */
    public function retry_initialization() {
        // Only proceed if we haven't already initialized
        if (did_action('eventin-pro/after_load')) {
            return;
        }
        
        // Double-check that the free plugin is actually ready
        if (!did_action('eventin/after_load') || !function_exists('wpeventin')) {
            return;
        }
        
        // Version compatibility check
        if ( version_compare( \Wpeventin_Pro::version(), '4.0.16', '>') && version_compare( \Wpeventin::version(), '4.0.21', '<' ) ) { 
            return;
        }

        // Initialize pro features
        Etn_Pro\Bootstrap::instance()->init();

        do_action( 'eventin-pro/after_load' );
    }  

    /**
     * Templates Folder Directory Path
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function templates_dir(){
        return trailingslashit( self::plugin_dir() . 'templates' );
    }

    /**
     * Utils Folder Directory Path
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function utils_dir(){
        return trailingslashit( self::plugin_dir() . 'utils' );
    }
    
    /**
     * Widgets Directory Url
     *
     * @return void
     */
    public static function widgets_url(){
        return trailingslashit( self::plugin_url() . 'widgets' );
    }

    /**
     * Widgets Folder Directory Path
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function widgets_dir(){
        return trailingslashit( self::plugin_dir() . 'widgets' );
    }

    /**
     * Assets Directory Url
     *
     * @return void
     */
    public static function assets_url(){
        return trailingslashit( self::plugin_url() . 'assets' );
    }

    /**
     * Assets Folder Directory Path
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function assets_dir(){
        return trailingslashit( self::plugin_dir() . 'assets' );
    }

    /**
     * Plugin Core File Directory Url
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function core_url(){
        return trailingslashit( self::plugin_url() . 'core' );
    }

    /**
     * Plugin Core File Directory Path
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function core_dir(){
        return trailingslashit( self::plugin_dir() . 'core' );
    }

    /**
     * Plugin Url
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function plugin_url(){
        return trailingslashit( plugin_dir_url( self::plugin_file() ) );
    }

    /**
     * Plugin Directory Path
     * 
     * @since 2.4.3
     *
     * @return string
     */
    public static function plugin_dir(){
        return trailingslashit( plugin_dir_path( self::plugin_file() ) );
    }

    /**
     * Plugins Basename
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function plugins_basename(){
        return plugin_basename( self::plugin_file() );
    }
    
    /**
     * Plugin File
     * 
     * @since 2.4.3
     *
     * @return void
     */
    public static function plugin_file(){
        return __FILE__;
    }
}


/**
 * Load Wpeventin_Pro plugin when all plugins are loaded
 *
 * @return Wpeventin_Pro
 */
function wpeventin_pro(){
    return Wpeventin_Pro::init();
}

// Let's Go...
wpeventin_pro();