<?php 
use Etn_Pro\Core\Modules\Rsvp\Helper;

$id = $instance['event_id'];

$etn_rsvp = \Etn_Pro\Core\Modules\Rsvp\Helper::instance()->data_query( $id );

$rsvp_by_status = [];
$all_items = [];

foreach ( $etn_rsvp as $item ) {
   
    // Status meta value
    $status = get_post_meta( $item->ID, 'etn_rsvp_value', true );

    // Attendee email & name 
    $attendee_name  = $item->post_title;
    $attendee_email = $item->attendee_email;

    $data = [
        'ID'             => $item->ID,
        'status'         => $status,
        'attendee_name'  => $attendee_name,
        'attendee_email' => $attendee_email,
    ];

    $all_items[] = $data;

    if ( ! isset( $rsvp_by_status[ $status ] ) ) {
        $rsvp_by_status[ $status ] = [];
    }
    $rsvp_by_status[ $status ][] = $data;
}

// Add "All" tab containing everyone
$rsvp_by_status = array_merge( [ 'All' => $all_items ], $rsvp_by_status );
?>

<div class="etn-rsvp-tab-wrapper etn-tab-wrapper">
    <!-- Tab Navigation -->
    <ul class="etn-nav">
        <?php $i = 0; ?>
        <?php foreach ( $rsvp_by_status as $status => $list ) : ?>
            <li>
                <a href="#" class="etn-tab-a <?php echo $i === 0 ? 'etn-active' : ''; ?>" data-id="tab-rsvp-<?php echo $i; ?>">
                    <span class="etn-tab-status"><?php echo esc_html( ucfirst( $status ) ); ?></span>
                </a>
            </li>
            <?php $i++; ?>
        <?php endforeach; ?>
    </ul>

    <!-- Tab Content -->
    <div class="etn-tab-content clearfix">
        <?php $j = 0; ?>
        <?php foreach ( $rsvp_by_status as $status => $list ) : ?>
            <div class="etn-tab <?php echo $j === 0 ? 'tab-active' : ''; ?>" data-id="tab-rsvp-<?php echo $j; ?>">
                <div class="rsvp-card-wrapper">
                    <?php foreach ( $list as $rsvp ) : ?>
                        <div class="rsvp-card">
                            <?php if (isset($show_avatar) && $show_avatar === 'yes') : ?>
                                <div class="rsvp-image">
                                    <?php
                                    $attendee_avatar = "";
                                    if (!empty($rsvp['attendee_email'])) {
                                        $attendee_avatar = get_avatar_url($rsvp['attendee_email']);
                                    } else {
                                        $default_avatar_url = \Wpeventin::assets_url() . "images/avatar.jpg";
                                        $attendee_avatar = apply_filters("etn/attendee/default_avatar", $default_avatar_url);
                                    }
                                    ?>
                                    <img src="<?php echo esc_url($attendee_avatar); ?>" alt="<?php echo esc_attr($rsvp['attendee_name']); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="rsvp-info">
                                <span class="rsvp-status status-<?php echo esc_attr( strtolower( str_replace( ' ', '-', $rsvp['status'] ) ) ); ?>">
                                    <?php echo esc_html( ucfirst( $rsvp['status'] ) ); ?>
                                </span>
                                <h4 class="rsvp-name"><?php echo esc_html( $rsvp['attendee_name'] ); ?></h4>
                                <?php if (isset($show_email) && $show_email === 'yes') : ?>
                                    <p class="rsvp-email"><?php echo esc_html( $rsvp['attendee_email'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php $j++; ?>
        <?php endforeach; ?>
    </div>
</div>
