<?php


class gg_slider_for_divi extends DiviExtension {

	public $gettext_domain = 'gg_ml';
	public $version        = GG_VER;
    
    public $name           = 'gg_slider';
    public $plugin_dir     = GG_DIR;
	public $plugin_dir_url = GG_URL .'/builders_integration/divi_elements/slider/';

    
    
    
    
	/**
	 * LWP_DiviBreadcrumbs constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct($name = false, $args = array()) {
        $this->_builder_js_data = false;

        add_action('wp_enqueue_scripts', array( $this, 'scripts_management'), 9999);
		parent::__construct($this->name, $args);
	}
    
    
    public function scripts_management() {
        
        // inject JS on builder mode (hardcoding) 
        if(strpos($_SERVER["REQUEST_URI"], 'et_fb=1') !== false) {
            wp_enqueue_script('divi_'. $this->name, $this->plugin_dir_url .'renderer.js', 999, GG_VER, true); 
            
            $js_vars = array(
                'slug'          => $this->name,
                'ajax_url'      => untrailingslashit(site_url()) .'/wp-admin/admin-ajax.php', 
                'default_display' => '',
                'field_indexes' => $GLOBALS[$this->name .'_divi_field_indexes'],
            );
            wp_localize_script('divi_'. $this->name, $this->name .'_divi_vars', $js_vars);
        }

        wp_dequeue_script("{$this->name}-frontend-bundle");
        wp_dequeue_script("{$this->name}-builder-bundle");
        wp_dequeue_style("{$this->name}-styles");
    }
}
new gg_slider_for_divi();
