<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class gg_carousel_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'g-carousel';
	}

	public function get_categories() {
		return array('global-gallery');
	}

   public function get_title() {
      return 'GG - '. esc_html__('Carousel', 'gg_ml');
   }



   protected function register_controls() {

		$this->start_controls_section(
			'main',
			array(
				'label' => 'Global Gallery - '. esc_html__('Carousel details', 'gg_ml'),
			)
		);
  
  
		$this->add_control(
		   'gid',
		   array(
			  'label' 	=> esc_html__('Choose gallery', 'gg_ml'),
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'default' => '',
			  'options' => array('' => esc_html__('Select a gallery', 'gg_ml') .' ..') + $GLOBALS['gg_emtr_galls']
		   )
		);
		
		$this->add_control(
		   'img_max_w',
		   array(
			  'label' 		=> esc_html__('Images maximum width', 'gg_ml') . ' (px)',
			  'type' => Controls_Manager::SLIDER,
			  'size_units' => array('px'),
				'default' => array(
					'unit' => 'px',
					'size' => 180,
				),
				'range' => array(
					'px' => array(
						'max' => 2000,
						'min' => 40,
						'step' => 10,
					),
				),
		   )
		);
		
		$this->add_control(
		   'height',
		   array(
			  'label' 		=> esc_html__('Images Height', 'gg_ml'),
			  'type' => Controls_Manager::SLIDER,
			  'size_units' => array('px', '%'),
				'default' => array(
					'unit' => 'px',
					'size' => 180,
				),
				'range' => array(
					'px' => array(
						'max' => 1000,
						'min' => 30,
						'step' => 10,
					),
					'%' => array(
						'max' => 200,
						'min' => 10,
						'step' => 1,
					),
				),
		   )
		);
		
		$this->add_control(
		   'rows',
		   array(
			  'label' 	=> esc_html__('Rows', 'gg_ml'),
			  'description'	=> esc_html__('Choose how many image rows to use', 'gg_ml'),
			  'type' 	=> Controls_Manager::NUMBER,
			  'default' => 1,
			  'max' => 10,
			  'min' => 1,
			  'step' => 1,
		   )
		);
		
		$this->add_control(
		   'multiscroll',
		   array(
			  'label' 		=> esc_html__('Multiple Scroll?', 'gg_ml'),
			  'description'	=> esc_html__('Slides multiple images per time', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'center',
		   array(
			  'label' 		=> esc_html__('Center mode?', 'gg_ml'),
			  'description'	=> esc_html__('Enables center display mode', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'nocrop',
		   array(
			  'label' 		=> esc_html__('Avoid images crop?', 'gg_ml'),
			  'description'	=> esc_html__('Just downscales images', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		$this->add_control(
		   'static',
		   array(
			  'label' 		=> esc_html__('Static mode?', 'gg_ml'),
			  'description'	=> esc_html__('Disables overlay and lightbox', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'random',
		   array(
			  'label' 		=> esc_html__('Random images?', 'gg_ml'),
			  'description'	=> esc_html__('Displays images randomly', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'watermark',
		   array(
			  'label' 		=> esc_html__('Use Watermark?', 'gg_ml'),
			  'description'	=> esc_html__('Applies watermark to images (where available)', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'autoplay',
		   array(
			  'label' 	=> esc_html__('Autoplay slider?', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => 'auto',
			  'options' => array(
			  	'auto' => esc_html__('(as default)', 'gg_ml'),
				1 => esc_html__('Yes', 'gg_ml'),
				0 => esc_html__('No', 'gg_ml')
			  )
		   )
		);
			
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		// manage num/unit fields
		$vals['img_max_w'] = $vals['img_max_w']['size'];
		$vals['h_type'] = $vals['height']['unit'];
		$vals['height'] = $vals['height']['size'];
		
		$parts = array('gid', 'img_max_w', 'height', 'h_type', 'rows', 'multiscroll', 'center', 'nocrop', 'static', 'random', 'watermark', 'autoplay');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[g-carousel '. $params .']');
	}

}
