<?php
// REGISTER BLOCK


// structure
$defaults = array(
	'gid' => array(
		'label'		=> esc_html__('Which gallery?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'img_max_w' => array(
		'label'		=> esc_html__('Images max width', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 2000,
		'default' 	=> 180,
		'panel'		=> 'main',
	),
	'height' => array(
		'label'		=> esc_html__('Images height', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 200,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> esc_html__('Height unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> 'px',
		'panel'		=> 'main',
	),
	'rows' => array(
		'label'		=> esc_html__('Rows', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 1,
		'max'		=> 10,
		'default' 	=> 1,
		'panel'		=> 'main',
	),
	'multiscroll' => array(
		'label'		=> esc_html__('Multi-scroll?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'center' => array(
		'label'		=> esc_html__('Center display mode?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'nocrop' => array(
		'label'		=> esc_html__('Avoid images crop?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'static' => array(
		'label'		=> esc_html__('Static mode?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> esc_html__('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> esc_html__('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'autoplay' => array(
		'label'		=> esc_html__('Autoplay carousel?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'auto'	=> esc_html__('as default', 'gg_ml'),
			'1'		=> esc_html__('Yes', 'gg_ml'),
			'0'		=> esc_html__('No', 'gg_ml'),
		),
		'default' 	=> 'auto',
		'panel'		=> 'main',
	),
);





$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-carousel', array(
	'editor_script' 	=> 'gg_car_on_guten',
	'render_callback' 	=> 'gg_carousel_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_car_defaults', $defaults);
