<?php
// REGISTER GRID BLOCK
include_once(GG_DIR .'/settings/field_options.php');



// collections array (use full list for now)
$collections = get_terms(array(
    'taxonomy'   => 'gg_collections',
    'hide_empty' => false,
));

$colls = array(); 
foreach($collections as $collection) {
	$colls[ $collection->term_id ] = $collection->name;
}


// collection filters array
$filters = array(
    '' => '('. esc_html__('none', 'gg_ml') .')'
);

$gall_cats = get_terms(array(
    'taxonomy'   => 'gg_gall_categories',
    'hide_empty' => false,
));
foreach($gall_cats as $cat) {
	$filters[ $cat->term_id ] = $cat->name;
}



/////////////////////////////////////////////



// structure
$defaults = array(
	'cid' => array(
		'label'		=> esc_html__('Which collection?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('Select a collection', 'gg_ml')) + $colls,
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> esc_html__('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
    
    'filter' => array(
		'label'		=> esc_html__('Use tags filter?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
    'def_filter' => array(
		'label'		=> esc_html__('Selected filter', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> $filters,
		'default' 	=> '',
		'panel'		=> 'main',
        
        'condition' => array(
			'filter' => array(
				'!=', 
				array('', false, 0)
			)
		)
	),
    'hide_all_filter' => array(
		'label'		=> esc_html__('Hide "All" filter?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
        
        'condition' => array(
			'filter' => array(
				'!=', 
				array('', false, 0)
			)
		)
	),
    
	'pag_sys' => array(
		'label'		=> esc_html__('Pagination system', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'' 		=> esc_html__('None', 'gg_ml'),
			'auto' 	=> esc_html__('Auto - follow global settings', 'gg_ml')
			) + gg_pag_sys(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'per_page' => array(
		'label'		=> esc_html__('How many galleries per page?', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 0,
		'max'		=> 200,
		'default' 	=> 0,
		'panel'		=> 'main',
		
		'condition' => array(
			'pag_sys' => array(
				'!=', 
				array('')
			)
		)
	),
);




$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-collection', array(
	'editor_script' 	=> 'gg_coll_on_guten',
	'render_callback' 	=> 'gg_collection_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_coll_defaults', $defaults);
