<?php
// REGISTER BLOCK
include_once(GG_DIR .'/settings/field_options.php');


// structure
$defaults = array(
	'gid' => array(
		'label'		=> esc_html__('Which gallery?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'width' => array(
		'label'		=> esc_html__('Box width', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 100,
		'panel'		=> 'main',
	),
	'w_type' => array(
		'label'		=> esc_html__('Width unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'img_h' => array(
		'label'		=> esc_html__('Images height', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 75,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> esc_html__('Height unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'layout' => array(
		'label'		=> esc_html__('Layout', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('(as default)', 'gg_ml')) + gg_itg_layouts(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'img_num' => array(
		'label'		=> esc_html__('How many images to display?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'1'	=> 1,
			'2'	=> 2,
			'4'	=> 4,
		),
		'default' 	=> '1',
		'panel'		=> 'main',
	),
	'font_size' => array(
		'label'		=> esc_html__("Custom font size", 'gg_ml') .' (rem)',
		'help'		=> esc_html__('Leave empty to use default one', 'gg_ml'),
		'type'		=> 'text',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> esc_html__('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> esc_html__('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'ol_txt' => array(
		'label'		=> esc_html__("Custom overlay text", 'gg_ml'),
		'help'		=> esc_html__('Remember you can use placeholders and FontAwesome icons as explained in settings', 'gg_ml'),
		'type'		=> 'textarea',
		'default' 	=> '',
		'panel'		=> 'main',
	),
);





$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-itg', array(
	'editor_script' 	=> 'gg_itg_on_guten',
	'render_callback' 	=> 'gg_itg_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_itg_defaults', $defaults);
