<?php


// JS FLAGS - always in head
function gg_dynamic_js_vars() {

    wp_localize_script('jquery', 'lcgg',
        array( 
            'ajax_url'          => untrailingslashit(site_url()) .'/wp-admin/admin-ajax.php',
            'nonce'             => wp_create_nonce('gg_ajax'),
            
            'rtl'               => (get_option('gg_rtl_mode')) ? true : false,
            'lightbox'          => get_option('gg_lightbox', 'lcweb'),
            'columnized_max_w'  => (int)get_option('gg_cl_thumb_max_w', 260),
            'masonry_min_w'     => (int)get_option('gg_masonry_min_width', 150),
            'phosostr_min_w'    => (int)get_option('gg_photostring_min_width', 120),
            'coll_max_w'        => (int)get_option('gg_coll_thumb_max_w', 260),
            
            'preload_hires_img' => (get_option('gg_preload_hires_img')) ? true : false,
            'back_to_gall_scroll' => (get_option('gg_coll_back_to_scroll')) ? true : false,
            'delayed_fx'        => (get_option('gg_delayed_fx')) ? false : true,
            'link_target'       => get_option('gg_link_target', '_top'),
            'no_rclick'         => get_option('gg_disable_rclick') ? true : false,
            
            'deeplinked_elems'  => (array)get_option('gg_deeplinked_elems', array()),
            'basic_deeplink'    => (get_option('gg_basic_deeplink')) ? true : false,
            'dl_coll_gall'      => (get_option('gg_dl_coll_gall')) ? true : false,
            
            'slider_toggle_info'=> (get_option('gg_slider_tgl_info')) ? true : false,
            'slider_extra_nav'  => get_option('gg_slider_extra_nav', 'thumbs'),
            'slider_cmd_pos'    => get_option('gg_lcms_nav_cmd_pos', 'h_center'),
            'slider_fx'         => get_option('gg_slider_fx', 'fadeslide'),
            'slider_easing'     => get_option('gg_slider_easing', 'ease'),
            'slider_pause_on_hover' => get_option('gg_slider_stop_on_hover'),
            'slider_fx_time'    => (int)get_option('gg_slider_fx_time', 400),
            'slider_interval'   => (int)get_option('gg_slider_interval', 3000),
        )
    );
}
add_action('wp_enqueue_scripts', 'gg_dynamic_js_vars', 999);
add_action('lc_guten_scripts', 'gg_dynamic_js_vars', 999);





// LCL FB comments meta - in head 
function gg_head_js_elements() {

	// LC LIGHTBOX - FACEBOOK COMMENTS
	if(get_option('gg_lightbox', 'lcweb') == 'lcweb' && get_option('gg_lb_lcl_comments') == 'fb') {
		?>
        <meta property="fb:app_id" content="<?php echo esc_attr(get_option('gg_lcl_fb_appid')) ?>" />
        <?php	
	}
}
add_action('wp_head', 'gg_head_js_elements', 999);





// SLIDER INIT / EDIT GALLERY HELPER / LCL facebook  - in footer 
function gg_footer_js_elements() {
    
	// logged users helper - direct link to edit items
	if(current_user_can('edit_posts'))  : ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";  
        
        let gg_remove_qeb;
            
        $(document).on('mouseenter', '.gg_lcms_slider, .gg_gallery_wrap:not(.gg_collection_wrap)',  function() {
            // not for iframes (builders) {
            if(window.self !== window.top) {
                return;
            }
            
            let gid = parseInt($(this).data('gid'), 10);
            
            if($('#gg_quick_edit_btn.ggqeb_'+ gid).length) {
                return false;
            }

            if(gg_remove_qeb) {
                clearTimeout(gg_remove_qeb);
            }
            $('#gg_quick_edit_btn').remove();

            var item_pos = $(this).offset();
            var item_padding = parseInt( $(this).css('padding-top'));
            var css_pos = 'style="top: '+ (item_pos.top + item_padding) +'px; left: '+ (item_pos.left + item_padding) +'px;"';

            var link = "<?php echo esc_url(admin_url()) ?>post.php?post="+ gid +"&action=edit";

            $('body').append('<a id="gg_quick_edit_btn" class="ggqeb_'+gid+' fas fa-pencil-alt" href="'+ link +'" target="_blank" title="<?php esc_attr_e('edit') ?>" '+css_pos+'></a>');
        });
        $(document).on('mouseleave', '.gg_galleria_slider_wrap, .gg_gallery_wrap', function() {
            if(gg_remove_qeb) {
                clearTimeout(gg_remove_qeb);
            }

            gg_remove_qeb = setTimeout(function() {
                $('#gg_quick_edit_btn').remove();
            }, 1500);
        });
    })(jQuery);   
    </script>
	<?php endif; 
	
    
    
	// LC LIGHTBOX - FACEBOOK COMMENTS
	if(get_option('gg_lightbox', 'lcweb') == 'lcweb' && (get_option('gg_lb_lcl_comments') == 'fb' || get_option('gg_lb_lcl_direct_fb'))) {
		?>
        <div id="fb-root"></div>
        
		<script type="text/javascript">
		(function(d, s, id) {
		    var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/<?php echo esc_js(get_locale()) ?>/sdk.js#xfbml=1&version=v17.0&appId=<?php echo esc_html(get_option('gg_lcl_fb_appid')) ?>&autoLogAppEvents=1";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
        </script>
        <?php
	}
}
add_action('wp_footer', 'gg_footer_js_elements', 999);

