/**
 * lc_color_picker.js - The colorpicker for modern web
 * Version: 2.0.0
 * Author: Luca Montanari (LCweb)
 * Website: https://lcweb.it
 * Licensed under the MIT license
 */

!function(){"use strict";if(void 0!==window.lc_color_picker)return!1;let e=[],t=null,n=null,c=null,r=null,a=null,i=null,o=null,p="solid",l=0,d={deg:0,radial_circle:!1,steps:[]};const s={modes:["solid","linear-gradient","radial-gradient"],open_on_focus:!0,transparency:!0,dark_theme:!1,no_input_mode:!1,wrap_width:"auto",preview_style:{input_padding:35,side:"right",width:30,separator_color:"#ccc"},fallback_colors:["#008080","linear-gradient(90deg, #fff 0%, #000 100%)"],on_change:null,labels:["click to change color","Solid","Linear Gradient","Radial Gradient","add gradient step","gradient angle","gradient shape","color","opacity"]},_='input:not([type="color"])',g=function(e,t=!1){return new CustomEvent("lccp_input_val_check",{bubbles:!0,detail:{picker_id:e,hide_picker:t}})};document.addEventListener("click",(function(e){const t=document.querySelector("#lc-color-picker.lccp-shown");if(!t||e.target.classList.contains("lccp-preview"))return!0;for(const t of document.getElementsByClassName("lccp-preview"))if(t.contains(e.target))return!0;if(e.target.parentNode&&e.target.parentNode.classList&&e.target.parentNode.classList.contains("lccp-el-wrap")&&document.getElementById(r))return!0;if(!t.contains(e.target)&&!e.target.classList.contains("lccp-shown")){const e=t.getAttribute("data-trigger-id");document.getElementById(e).parentNode.querySelector(_).dispatchEvent(g(e,!0))}return!0})),window.addEventListener("resize",(function(e){const n=document.querySelector("#lc-color-picker.lccp-shown");if(!n||t==window.innerWidth)return!0;const c=n.getAttribute("data-trigger-id");document.getElementById(c).parentNode.querySelector(_).dispatchEvent(g(c,!0))})),String.prototype.lccpReplaceArray=function(e,t){let n=this;for(var c=0;c<e.length;c++){const r=new RegExp(e[c],"g");n="object"==typeof t?n.replace(r,t[c]):n.replace(r,t)}return n},window.lc_color_picker=function(h,A={}){let m,f;if(this.attachTo=h,!this.attachTo)return console.error("You must provide a valid selector string first argument");if("object"!=typeof A)return console.error("Options must be an object");const y=A;A=Object.assign({},s,A),void 0!==y.preview_style&&(A.preview_style=Object.assign({},s.preview_style,y.preview_style)),this.init=function(){const e=this;n||(this.generate_style(),n=!0),u(h).forEach((function(t){"INPUT"==t.tagName&&"text"!=t.getAttribute("type")||t.parentNode.classList.length&&t.parentNode.classList.contains("lcslt_wrap")||e.wrap_element(t)}))},this.wrap_element=function(e){m=Math.random().toString(36).substr(2,9);const t=this,n="right"==A.preview_style.side?"borderRightWidth":"borderLeftWidth";let a="width:"+(A.no_input_mode?"calc(100% - "+parseInt(getComputedStyle(e).borderRightWidth,10)+"px - "+parseInt(getComputedStyle(e).borderLeftWidth,10)+"px);":A.preview_style.width+"px;")+A.preview_style.side+":"+parseInt(getComputedStyle(e)[n],10)+"px;top:"+parseInt(getComputedStyle(e).borderTopWidth,10)+"px;height: calc(100% - "+parseInt(getComputedStyle(e).borderTopWidth,10)+"px - "+parseInt(getComputedStyle(e).borderBottomWidth,10)+"px);",i=a+"background:"+e.value+";border-color:"+A.preview_style.separator_color+";",o=document.createElement("div");o.className="lccp-preview-"+A.preview_style.side,o.setAttribute("data-for",e.getAttribute("name")),"auto"!=A.wrap_width&&(o.style.width="inherit"==A.wrap_width?Math.round(e.getBoundingClientRect().width)+"px":A.wrap_width);const p=A.transparency||1!=A.modes.length||"solid"!=A.modes[0]?"":'<input type="color" name="'+m+'_direct_cp" value="'+e.value+'" class="lccp-direct-cp-f" />';o.classList.add("lccp-el-wrap"),o.innerHTML='<span class="lccp-preview-bg" style="'+a+'"></span><span id="'+m+'" class="lccp-preview" style="'+i+'" title="'+A.labels[0]+'"></span>'+p,e.parentNode.insertBefore(o,e),o.appendChild(e),A.no_input_mode||("right"==A.preview_style.side?o.querySelector('input:not([type="color"])').style.paddingRight=A.preview_style.input_padding+"px":o.querySelector('input:not([type="color"])').style.paddingLeft=A.preview_style.input_padding+"px"),o.querySelector(".lccp-direct-cp-f")&&o.querySelector(".lccp-direct-cp-f").addEventListener("input",(e=>{o.querySelector('input:not([type="color"])').value=e.target.value,o.querySelector(".lccp-preview").style.background=e.target.value}));const l=document.getElementById(m);l.addEventListener("click",(e=>{this.show_picker(l)})),A.open_on_focus&&o.querySelector(_).addEventListener("focus",(e=>{l!=c&&(c&&(document.getElementById("lc-color-picker").classList.remove("lccp-shown"),c=null),t.debounce("open_on_focus",10,"show_picker",l))})),o.querySelector(_).addEventListener("keyup",(e=>{if(9==e.keyCode||"Enter"===e.key||13===e.keyCode)return;const n=!!(r=m&&document.querySelector("#lc-color-picker.lccp-shown"));c=l,r=m,t.debounce("manual_input_sync",510,"val_to_picker",!0),n&&(t.debounce("manual_input_sync_cp",500,"append_color_picker",!1),t.debounce("reopen_picker_after_manual_edit",510,"show_picker",l))})),o.querySelector(_).addEventListener("focusout",(e=>{if("BODY"==document.activeElement.tagName&&document.querySelector('#lc-color-picker.lccp-shown[data-trigger-id="'+r+'"]'))return!0;e.target.dispatchEvent(g(r,!0))})),o.querySelector(_).addEventListener("lccp_input_val_check",(e=>{const n=e.target.value,a=document.createElement("div");a.style.background=n;let i,o=a.style.background;n.trim().length&&o?(o=o.replaceAll("0.",".").replace(/rgb\([^\)]+\)/g,(e=>t.RGB_to_hex(e))),i="rgb("==o.trim().toLowerCase().substr(0,4)?t.RGB_to_hex(o):o):i=-1===e.target.value.toLowerCase().indexOf("gradient")?-1===A.fallback_colors[0].toLowerCase().indexOf("rgba")?t.RGB_to_hex(A.fallback_colors[0]):A.fallback_colors[0]:A.fallback_colors[1],i!=n&&(e.target.value=i),"function"==typeof A.on_change&&f!=i&&A.on_change.call(t,i,e.target),e.detail.picker_id==r&&(c=null,r=null);const p=document.querySelector('#lc-color-picker.lccp-shown[data-trigger-id="'+e.detail.picker_id+'"]');p&&(p.classList.remove("lccp-shown"),document.getElementById("lc-color-picker").remove())}))},this.show_picker=function(e){if(document.querySelector('#lc-color-picker.lccp-shown[data-trigger-id="'+r+'"]'))return document.getElementById("lc-color-picker").remove(),c=null,r=null,!1;const n=e.parentNode.querySelector(".lccp-direct-cp-f");if(n&&(!A.open_on_focus||A.open_on_focus&&!navigator.userAgent.toLowerCase().includes("firefox")))return n.value=a,n.click(),!0;t=window.innerWidth,c=e,r=m,this.val_to_picker(),this.append_color_picker();const i=document.getElementById("lc-color-picker"),o=i.offsetWidth,p=i.offsetHeight,l=c.getBoundingClientRect(),d=parseInt(c.clientHeight,10)+parseInt(getComputedStyle(c).borderTopWidth,10)+parseInt(getComputedStyle(c).borderBottomWidth,10),s=parseInt(l.y,10)+parseInt(window.pageYOffset,10)+d+5;let _=parseInt(l.right,10)-o;_<0&&(_=0),window.innerWidth<700&&(_=Math.floor((window.innerWidth-o)/2));const g=s+p-document.documentElement.scrollTop<window.innerHeight?"top:"+s:"transform: translate3d(0, calc((100% + "+(c.offsetHeight+10)+"px) * -1), 0); top:"+s;i.setAttribute("style",g+"px; left: "+_+"px;"),i.classList.add("lccp-shown")},this.val_to_picker=function(e){if(!c)return!1;const t=c.parentNode.querySelector(_).value.trim().toLowerCase();f=t;let n=document.createElement("div");n.style.background=t,t.length&&n.style.background.length?(p=-1!==t.indexOf("linear-gradient")?"linear-gradient":-1!==t.indexOf("radial-gradient")?"radial-gradient":"solid","solid"==p?(a=t,o=A.fallback_colors[1]):(a=A.fallback_colors[0],o=t)):(a=A.fallback_colors[0],o=A.fallback_colors[1],p=-1!==t.indexOf("linear-gradient")?"linear-gradient":-1!==t.indexOf("radial-gradient")?"radial-gradient":"solid"),c.style.background=t,(!e||e&&A.open_on_focus)&&(this.load_solid_data(a),o&&this.load_gradient_data(o))},this.load_solid_data=function(e){if(i=1,-1!==e.indexOf("rgba")){const t=this.RGBA_to_hexA(e);a=t[0],i=t[1]}else a=-1!==e.indexOf("rgba")?this.RGB_to_hex(e):this.short_hex_fix(e)},this.load_gradient_data=function(e){const t=this,n=-1!==e.indexOf("radial-gradient");e=(e=e.replace(/,\./g,",0.").replace(/ \./g," 0.").replace(/rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)/g,"rgbaZ($1|$2|$3|$4)").replace(/\|\)/g,"|1)")).replace("top right","45deg").replace("right top","45deg").replace("bottom right","135deg").replace("bottom right","135deg").replace("top left","315deg").replace("left top","315deg").replace("bottom left","225deg").replace("bottom left","225deg").replace("right","90deg").replace("left","270deg").replace("top","0deg").replace("bottom","180deg"),n&&-1===e.indexOf("ellipse")&&-1===e.indexOf("circle")&&e.replace("\\(","(ellipse "),n||-1!==e.indexOf("deg")||e.replace("\\(","(180deg");const c=(e=e.lccpReplaceArray(["linear-gradient","radial-gradient","","\\(","to","\\)"],"")).split(","),r=100/c.length;d.steps=[],c.some((function(e,a){if(a){let n="";n=(e=e.trim().split(" ")).length<2?1===a?"0%":a==c.length-1?"100%":r*a+"%":e[1];let i=e[0],o=1;if(-1!==i.indexOf("rgbaZ")){const e=t.RGBA_to_hexA(i.replace("rgbaZ","rgba").replace(/\|/g,","));i=e[0],o=e[1]}d.steps.push({color:t.short_hex_fix(i),opacity:o,position:parseInt(n,10)})}else n?d.radial_circle=-1!==e.indexOf("circle"):d.deg=parseInt(e.replace("deg",""),10)}))},this.RGBA_to_hexA=function(e){const t=(e=e.lccpReplaceArray(["rgba","\\(","\\)"],"")).split(",");let n=void 0!==t[3]?t[3]:"1";return"."==n.substring(0,1)&&(n=0+n),t.splice(3,1),[this.RGB_to_hex("rgb("+t.join(",")+")"),parseFloat(n)]},this.RGB_to_hex=function(e){const t=(e=e.lccpReplaceArray(["rgb","\\(","\\)"],"")).split(",");if(t.length<3)return"#000";let n=parseInt(t[0].trim(),10).toString(16),c=parseInt(t[1].trim(),10).toString(16),r=parseInt(t[2].trim(),10).toString(16);return 1==n.length&&(n="0"+n),1==c.length&&(c="0"+c),1==r.length&&(r="0"+r),this.shorten_hex(n+c+r)},this.shorten_hex=function(e){return(e=e.replace("#","").split("")).length>=6&&e[0]===e[1]&&e[2]===e[3]&&e[4]===e[5]?"#"+e[0]+e[2]+e[4]:"#"+e.join("")},this.short_hex_fix=function(e){if(4==e.length){const t=e.split("");e=t[0]+t[1]+t[1]+t[2]+t[2]+t[3]+t[3]}return e.toLowerCase()},this.hex_to_RGB=function(e){let t=0,n=0,c=0;return 4==e.length?(t="0x"+e[1]+e[1],n="0x"+e[2]+e[2],c="0x"+e[3]+e[3]):7==e.length&&(t="0x"+e[1]+e[2],n="0x"+e[3]+e[4],c="0x"+e[5]+e[6]),"rgb("+ +t+", "+ +n+", "+ +c+")"},this.hex_to_RGBA=function(e,t){if(1===parseFloat(t))return this.shorten_hex(e);return this.hex_to_RGB(e).replace("(","a(").replace(")",", "+t.toString().replace("0.",".")+")")},this.append_color_picker=function(e=!1){const t=this;document.getElementById("lc-color-picker")&&!e&&document.getElementById("lc-color-picker").remove();const n=A.dark_theme?"lccp_dark_theme":"lccp_light_theme",c="solid"==p?a:d.steps[0].color,r="solid"==p?i:A.transparency?d.steps[0].opacity:null,l=-1!==A.modes.indexOf("linear-gradient")||-1!==A.modes.indexOf("radial-gradient");let s,_="";if(e&&document.getElementById("lc-color-picker")?(s=document.getElementById("lc-color-picker"),s.setAttribute("data-mode",p),s.setAttribute("data-trigger-id",m)):_='<div id="lc-color-picker" class="'+n+'" data-mode="'+p+'" data-trigger-id="'+m+'">',A.modes.length>1&&(_+=`\n                <div id="lccp_modes_wrap">\n                    <span class="${"solid"==p?"lccp_sel_mode":""}" ${-1===A.modes.indexOf("solid")?'style="display: none;"':""} data-mode="solid">${A.labels[1]}</span>\n                    <span class="${"linear-gradient"==p?"lccp_sel_mode":""}" ${-1===A.modes.indexOf("linear-gradient")?'style="display: none;"':""} data-mode="linear-gradient">${A.labels[2]}</span>\n                    <span class="${"radial-gradient"==p?"lccp_sel_mode":""}" ${-1===A.modes.indexOf("radial-gradient")?'style="display: none;"':""} data-mode="radial-gradient">${A.labels[3]}</span>\n                </div>`),l&&(_+=`\n                <div class="lccp_gradient_wizard" ${"solid"==p?'style="display: none;"':""}>\n                    <div class="lccp_gradient lccp_gradient-bg"></div>\n                    <div class="lccp_gradient" style="background: ${o}" title="${A.labels[4]}"></div>\n                        \n                    <div class="lccp_gradient_ranges"></div>\n\n                    <div class="pccp_deg_f_wrap" ${"radial-gradient"==p?'style="display: none;"':""}>\n                        <img src="   data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAYAAADE6YVjAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAZJJREFUeNqsVetthDAMzp06QEagEv/LBk03oBswAhuQDVAn6AgZgTIBbAAb5DZIE+ScUs42OVRLVvBd7M+v2BeRRxVwEQSttei6LlNV/HB/ymDP8+LZYVxVlev73llrXUrLsqSipgBaz5YyvmcppfPRbRYDYJCNMSzId67xPSulXNu223c4KZDTAFgqMRDNKAXwGuokoAEazwMHBLW6gxTExQm6iqOGAoG66Ctc7BHl2fMHnBT1ECVK4zgKLgqbpIYjm1EX/eIFhSh/eb5lgLyC/jucf1I7z7NY1/Ue8t4LybwfDU1APeAabIZ6urIsg85DhyxM/tN7de5cuSK/rcz84uSnQKhU3Q7kNKUqDtNIJrMmEu4ORMvH6NDUtwhII85TBfXSYBtF54p/tBoGMI6mfCDm1bM0JU4+vD/FDMYc6pMUx11ksIuGAFrAAJYCtctEk5PT6WBPTOCMTKKPDljg4j+AHABEw0PSQBMxC8n3cASSbtLibL8rZvOpxHtztBYuGWAFPK63xOPPzFWw0a8AAwA+dEfwP/CgZgAAAABJRU5ErkJggg==" alt="angle" title="${A.labels[5]}" />\n\n                        <input type="range" name="deg" value="${d.deg}" min="0" max="360" step="1" />\n                        <input type="number" name="deg-num" value="${d.deg}" min="0" max="360" step="1" />\n                    </div>\n                    <div class="pccp_circle_f_wrap" ${"radial-gradient"==p?"":'style="display: none;"'}>\n                        <img src="    data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAAhQAAAIUB4uz/wQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAEZSURBVEiJzdQxSgRBFATQ52hionsKxcjQTERYUzMv4F28hImsiwcQExFEBfUCggtGXkBccRNR1qBnQHRme9p2wYJigu5f9Wd+zaceXexjgFeM8IADbGGmoS6KJVxiHOENVlLF1/HUQrziEBspnaeIV3zGchuD81+IV7wWmUk3Q7ziZpP4HHYib/eBU9yVYnWYnyQwmNDZI1YjDUTx0iD+Xop30BdSk5Kww7LWqOHSSdlAP0H4O3uEP7TucK80SOn8R4wLIWZ1eCufC03ftgUWCxxlCERR4Ay30zQYY1dI01QM4B7bwkCnYgAXWMPVXxo0LalNzArzaVoPWQZfkWVQxK/k4V8Y5MR32MbgOMOgVW1H2Iqp67qHzif097OAt54XXQAAAABJRU5ErkJggg==" alt="shape" title="${A.labels[6]}" />\n\n                        <span class="pcpp_ellipse_shape ${d.radial_circle?"":"pcpp_circle_btn_active"}" data-val="ellipse">Ellipse</span>\n                        <span class="pcpp_circle_shape ${d.radial_circle?"pcpp_circle_btn_active":""}" data-val="circle">Circle</span>\n                    </div>\n                    <hr/>\n                </div>`),_+=`\n            <div class="pccp_color_f_wrap" ${l?"":'style="margin-top: 0;"'}>\n                <img src="  data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAA2wAAANsB8FDmnAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAFzSURBVEiJrdU/SxxRFIbx3wgWCjbRSkEICCHBzhCwUCurQDr3I6QLaJEqTcDWJoVNPoAWqW2sXAJW22hhkX+F1VYKBlwQ15ti7+Cy2Z29M+OFt5i5nOdhztw5I4QgNXiFH/iYXFMCPoFThJhPTy340AcPeEDjSQRYxN8BQcAt3tQSYBInQ+B52pitI/haAM/zpZIAOwnwgDsslRLgLbqJgoBvyQIs46YEPM/qWAGm8asCPOB7imCvIjzPy5ECrOC+pmC3SJByJMflvEhwUQO8j0t0kP0nwDO9+VIFfh8Px0m8nh8mmKrR/zO9aXsTGVM5d0JcIYRObFGV1cQLzOAisojW/tWqAG/jM94PZQy85IZyrenqjZR1j2OlMfIURclRIvwP1jCH3/HeUcqXvIDrEdCfOMC2Xr/fxRaFWLOQOuw2+wrzHMe959iKonyvjc2y43oWhwOSqyFPdajgj5ZF2MiVZdkGNvA6Jj8pLTRDCM2i+n/jlZhJOn4yuAAAAABJRU5ErkJggg==" alt="color" title="${A.labels[7]}" />\n\n                <div>\n                    <input type="color" name="color" value="${c}" style="opacity: ${i};" />\n                </div>\n                <input type="text" name="hex" value="${c.toLowerCase()}" />\n            </div>`,A.transparency&&(_+=`\n                <div class="pccp_opacity_f_wrap">\n                    <img src=" data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAApgAAAKYB3X3/OAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAF9SURBVEiJtda/ihRBEMfxT42D4Jmdq5GHIBqJIHgYGCuIIhcYaGRgYGDsU4i+gqFgJogXivgGwkUmKpqcnhgJJ/4pg5mV3XVmd3q5K+iku+v37e7qrurITH0WEUdwC5dwCiexi21sZub9XufW6h7ho3iEmzg4M/wOm3i/SBxk5lTDDXxB9rRnHT7H8QYX/hubmXgHf+aI9wEO4CW+Yb0T0B7HIvFOQOu/glct5PwUAMfwdYB4L6DVOYzX+DTuGwf5IVYHBW2OZeb3iLiC9cn+EX4OXP3cHXS1qj37zuu6F1bjaqFP/8ucsIi4jtM1ThQCYuC8azhXYa0QUGTVfoqPAR/3E1DjA84U+AwKMl7gba3JjCU3aVCQM/M5zRE9xa8CQJFVmbmDJ3slGBGHIuLiv442SY3MrwFLJ7uqhezgriZdL7vyFU1gz2JjagcTK7iN36U7MKTgzJTMz4WANWxZVDInHEZ4jB8dgC08wL0h6ToWfFtWNd+Wy5b8tvwFZS60TLZpD/8AAAAASUVORK5CYII=" alt="opacity" title="${A.labels[8]}" />\n                    \n                    <input type="range" name="opacity" value="${r}" min="0" max="1" step="0.01" />\n                    <input type="number" name="opacity-num" value="${r}" min="0" max="1" step="0.05" />\n                </div>`),e&&document.getElementById("lc-color-picker")?s.innerHTML=_:document.body.insertAdjacentHTML("beforeend",_+"</div>"),A.modes.length>1)for(const e of document.querySelectorAll("#lccp_modes_wrap span"))e.addEventListener("click",(e=>{t.mode_change(e.target,e.target.getAttribute("data-mode"))}));if(l&&(d.steps.some((function(e,n){t.add_draggable_element(n,e.position,e.color)})),document.querySelector(".lccp_gradient:not(.lccp_gradient-bg)").addEventListener("click",(e=>{this.add_gradient_step(e)}))),-1!==A.modes.indexOf("linear-gradient")&&(document.querySelector(".pccp_deg_f_wrap input[type=range]").addEventListener("input",(e=>{this.track_deg_range_change(e)})),document.querySelector(".pccp_deg_f_wrap input[name=deg-num]").addEventListener("change",(e=>{this.track_deg_num_change(e)})),document.querySelector(".pccp_deg_f_wrap input[name=deg-num]").addEventListener("keyup",(e=>{this.debounce("deg_f_change",500,"track_deg_num_change",e)}))),-1!==A.modes.indexOf("radial-gradient"))for(const e of document.querySelectorAll(".pccp_circle_f_wrap span"))e.addEventListener("click",(e=>{t.set_ellipse_circle(e.target,e.target.getAttribute("data-val"))}));document.querySelector('.pccp_color_f_wrap input[type="color"]').addEventListener("input",(e=>{this.track_color_change(e)})),document.querySelector('.pccp_color_f_wrap input[type="color"]').addEventListener("change",(e=>{this.track_color_change(e)})),document.querySelector(".pccp_color_f_wrap input[name=hex]").addEventListener("keyup",(e=>{this.debounce("hex_f_change",600,"track_color_hex_change",e)})),A.transparency&&(document.querySelector(".pccp_opacity_f_wrap input[type=range]").addEventListener("input",(e=>{this.track_opacity_range_change(e)})),document.querySelector(".pccp_opacity_f_wrap input[name=opacity-num]").addEventListener("change",(e=>{this.track_opacity_num_change(e)})),document.querySelector(".pccp_opacity_f_wrap input[name=opacity-num]").addEventListener("keyup",(e=>{this.debounce("opacity_f_change",500,"track_opacity_num_change",e)})))},this.add_draggable_element=function(e,t,n){const c=this,r=document.querySelector(".lccp_gradient_ranges"),a=e?"":"lccp_sel_step",i=d.steps.length>2?"":'style="display: none;"';r.innerHTML+='<span class="lccp_gradient_range '+a+'" data-step-num="'+e+'" style="background: '+n+"; left: "+t+'%;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJFJREFUeNpiYMAOFIC4H4jPA/F/NHweKqfAQAQQgCr+TyTuJ2TYeRIMQ3axADYD8RlWAMVEG9pAwBUwQJT3FYjwFjEGgrACE5BIYKAeyGcgMiKIdeF9RjQNuAAjkoEEAXpskgpQYp+JgcqA6l4GufACFR34AGTgRioauIHqCZsmWY8mhQNNii+qF7BUqQIAAgwANgu7Y7cw5VAAAAAASUVORK5CYII=" '+i+" /></span>";let o=!1;const p=function(e,t,n){o=e},l=function(){o=!1,c.apply_changes()},s=function(e,t,n){if(!1!==o&&e==o){n.preventDefault();const a=r.getBoundingClientRect();let i="touchmove"===n.type?n.touches[0].clientX-a.left:n.clientX-a.left;i=Math.round(100*i/r.offsetWidth),i<0?i=0:i>100&&(i=100);const o=e?d.steps[e-1].position:0,p=e==d.steps.length-1?100:d.steps[e+1].position;i<o?i=o+1:i>p&&(i=p-1),d.steps[e].position=i,t.style.left=i+"%",c.apply_gradient_changes()}};document.querySelectorAll(".lccp_gradient_range").forEach((e=>{const t=parseInt(e.getAttribute("data-step-num"),10);e.removeEventListener("touchstart",null),e.removeEventListener("touchend",null),e.removeEventListener("touchmove",null),e.removeEventListener("click",null),e.removeEventListener("mousedown",null),e.removeEventListener("mouseup",null),e.addEventListener("touchstart",(e=>{p(t,e.target)})),e.addEventListener("mousedown",(e=>{p(t,e.target)})),e.addEventListener("click",(e=>{c.select_gradient_color(t)})),r.addEventListener("touchmove",(n=>{s(t,e,n)})),r.addEventListener("mousemove",(n=>{s(t,e,n)})),e.addEventListener("mouseup",(e=>{l()})),e.addEventListener("touchend",(e=>{l()})),document.addEventListener("mouseup",(e=>{l()}))})),document.querySelectorAll(".lccp_gradient_range img").forEach((e=>{e.addEventListener("click",(e=>{if(document.querySelectorAll(".lccp_gradient_range").length<3)return!1;setTimeout((()=>{const t=e.target.parentNode,n=parseInt(t.getAttribute("data-step-num"),10),r=n?n-1:0;d.steps.splice(n,1),document.querySelectorAll(".lccp_gradient_range").forEach((e=>e.remove())),d.steps.some((function(e,t){c.add_draggable_element(t,e.position,e.color)})),document.querySelector('.lccp_gradient_range[data-step-num="'+r+'"]').click(),this.apply_gradient_changes(!0)}),20)}))}))},this.select_gradient_color=function(e){l=e,document.querySelectorAll(".lccp_gradient_range").forEach((e=>e.classList.remove("lccp_sel_step"))),document.querySelector('.lccp_gradient_range[data-step-num="'+e+'"]').classList.add("lccp_sel_step"),a=d.steps[e].color,i=d.steps[e].opacity,document.querySelector('#lc-color-picker input[type="color"]').value=a,document.querySelector(".pccp_color_f_wrap input[name=hex]").value=a,A.transparency&&(document.querySelector(".pccp_opacity_f_wrap input[type=range]").value=i,document.querySelector(".pccp_opacity_f_wrap input[name=opacity-num]").value=i)},this.apply_gradient_changes=function(e){const t=this;let n=p+"(";n+="linear-gradient"==p?d.deg+"deg":d.radial_circle?"circle":"ellipse",n+=", ";let c=[];d.steps.some((function(e,n){let r=A.transparency?t.hex_to_RGBA(e.color,e.opacity):t.shorten_hex(e.color);(d.steps.length>2||d.steps.length<=2&&(!n&&parseInt(e.position,10)||n&&n<d.steps.length-1||n==d.steps.length-1&&100!=parseInt(e.position,10)))&&(r+=" "+e.position+"%"),c.push(r)})),o=n+c.join(", ")+")",document.querySelector(".lccp_gradient:not(.lccp_gradient-bg)")&&(document.querySelector(".lccp_gradient:not(.lccp_gradient-bg)").style.background=o),e&&this.apply_changes()},this.apply_changes=function(){if(!c)return!1;let t="";"solid"==p?(t=this.shorten_hex(a),A.transparency&&document.querySelector(".pccp_opacity_f_wrap input[type=range]")&&(i=document.querySelector(".pccp_opacity_f_wrap input[type=range]").value,t=this.hex_to_RGBA(t,i))):t=o,c.style.background=t;const n=c.parentNode.querySelector(_);n.value!=t&&(n.value=t,f=t,"function"==typeof A.on_change&&(null!=typeof e.on_change_cb&&e.on_change_cb&&clearTimeout(e.on_change_cb),e.on_change_cb=setTimeout((()=>{A.on_change.call(this,t,n)}),300)))},this.mode_change=function(e,t){if(p==t)return!1;let n,c;"solid"==t?(n=a,A.transparency&&(c=i)):(n=d.steps[0].color,A.transparency&&(c=d.steps[0].opacity)),document.querySelector('#lc-color-picker input[type="color"]').value=n,document.querySelector(".pccp_color_f_wrap input[name=hex]").value=n,A.transparency&&(document.querySelector(".pccp_opacity_f_wrap input[type=range]").value=c,document.querySelector(".pccp_opacity_f_wrap input[name=opacity-num]").value=c),A.modes.length>1&&(document.querySelector(".pccp_deg_f_wrap").style.display="linear-gradient"==t?"flex":"none",document.querySelector(".pccp_circle_f_wrap").style.display="radial-gradient"==t?"block":"none"),-1===A.modes.indexOf("linear-gradient")&&-1===A.modes.indexOf("radial-gradient")||(document.querySelector(".lccp_gradient_wizard").style.display="solid"!=t?"block":"none"),document.querySelectorAll("#lccp_modes_wrap span").forEach((e=>e.classList.remove("lccp_sel_mode"))),e.classList.add("lccp_sel_mode"),p=t,"solid"==t?this.apply_changes():this.apply_gradient_changes(!0)},this.add_gradient_step=function(e){const t=this,n=Math.round(100*e.layerX/e.target.offsetWidth);let c=0;for(let e of d.steps){if(e.position>n){const t={color:c-1<0?e.color:d.steps[c-1].color,opacity:1,position:n};d.steps.splice(c,0,t);break}c++}document.querySelectorAll(".lccp_gradient_range").forEach((e=>e.remove())),d.steps.some((function(e,n){t.add_draggable_element(n,e.position,e.color)})),document.querySelector('.lccp_gradient_range[data-step-num="'+c+'"]').click(),this.apply_gradient_changes(!0)},this.set_ellipse_circle=function(e,t){if(d.radial_circle&&"circle"==t||!d.radial_circle&&"circle"!=t)return!1;d.radial_circle=!d.radial_circle,document.querySelectorAll(".pccp_circle_f_wrap span").forEach((e=>e.classList.remove("pcpp_circle_btn_active"))),e.classList.add("pcpp_circle_btn_active"),this.apply_gradient_changes(!0)},this.track_deg_range_change=function(e){document.querySelector(".pccp_deg_f_wrap input[name=deg-num]").value=e.target.value,d.deg=e.target.value,this.apply_gradient_changes(!0)},this.track_deg_num_change=function(e){let t=parseFloat(e.target.value);(isNaN(t)||t<0||t>360)&&(t=90),e.target.value=t,document.querySelector(".pccp_deg_f_wrap input[type=range]")&&(document.querySelector(".pccp_deg_f_wrap input[type=range]").value=t),d.deg=t,this.apply_gradient_changes(!0)},this.track_color_change=function(e){const t=e.target.value.toLowerCase();document.querySelector(".pccp_color_f_wrap input[name=hex]").value=t,this.apply_color_change(t)},this.track_color_hex_change=function(e){let t=this.short_hex_fix(e.target.value);null===t.match(/^#[a-f0-9]{6}$/i)&&(t=a.toLowerCase()),e.target.value=t,document.querySelector('#lc-color-picker input[type="color"]').value=t,this.apply_color_change(t)},this.apply_color_change=function(e){"solid"==p?(a=e,this.apply_changes()):(d.steps[l].color=e,document.querySelector(".lccp_sel_step").style.background=e,this.apply_gradient_changes(!0))},this.track_opacity_range_change=function(e){document.querySelector(".pccp_opacity_f_wrap input[name=opacity-num]").value=e.target.value,this.alter_hex_opacity(e.target.value)},this.track_opacity_num_change=function(e){let t=parseFloat(e.target.value);(isNaN(t)||t<0||t>1)&&(t=.5),e.target.value=t,document.querySelector(".pccp_opacity_f_wrap input[type=range]")&&(document.querySelector(".pccp_opacity_f_wrap input[type=range]").value=t,this.alter_hex_opacity(t))},this.alter_hex_opacity=function(e){document.querySelector('#lc-color-picker input[type="color"]').style.opacity=e,"solid"==p?(i=e,this.apply_changes()):(d.steps[l].opacity=e,this.apply_gradient_changes(!0))},this.debounce=function(t,n,c,r){void 0!==e[t]&&e[t]&&clearTimeout(e[t]);const a=this;e[t]=setTimeout((()=>{a[c].call(a,r)}),n)},this.generate_style=function(){document.head.insertAdjacentHTML("beforeend",'<style>\n.lccp-el-wrap {\n    position: relative;\n    display: inline-block;\n}\n.lccp-el-wrap > input {\n    margin: 0;\n    min-width: 100%;\n    max-width: 100%;\n    width: auto;\n}\n.lccp-preview,\n.lccp-preview-bg {\n    display: inline-block;\n    position: absolute;\n    cursor: pointer;\n    z-index: 15;\n}\n.lccp-preview-bg {\n    z-index: 10;\n}\n.lccp-preview-right .lccp-preview { \n    border-left: 1px solid #ccc;\n}\n.lccp-preview-left .lccp-preview { \n    border-right: 1px solid #ccc;\n}\n.lccp-direct-cp-f {\n    padding: 0 !important;\n    margin: 0 !important;\n    width: 0 !important;\n    height: 0 !important;\n    position: absolute;\n    bottom: 0;\n    visibility: hidden;\n}\n.lccp-preview-right .lccp-direct-cp-f { \n    right: 0;\n}\n.lccp-preview-left .lccp-direct-cp-f{ \n    left: 0;\n}\n#lc-color-picker,\n#lc-color-picker * {\n    box-sizing: border-box;\n    font-family: sans-serif;\n}\n#lc-color-picker {\n    visibility: hidden;\n    z-index: -100;\n    opacity: 0;\n    position: absolute;\n    top: -9999px;\n    z-index: 9999999999;\n    width: 280px;\n    background: #fff;\n    box-shadow: 0px 2px 13px -2px rgba(0, 0, 0, .18);\n    border-radius: 4px;\n    overflow: hidden;\n    padding: 10px;\n    border: 1px solid #ccc;\n    transition: opacity .15s ease;\n}\n#lc-color-picker.lccp-shown {\n    visibility: visible;\n    opacity: 1;\n\n}\n\n#lccp_modes_wrap {\n\tdisplay: flex;\n\tflex-direction: row;\n\tjustify-content: space-between;\n    margin-bottom: 10px;\n}\n#lccp_modes_wrap span,\n.pccp_circle_f_wrap span {\n\tdisplay: inline-block;\n\tborder: 1px solid #e8e8e8;\n\tbackground: #e8e8e8;\n    opacity: .78;\n\tpadding: 4px 7px;\n\tfont-size: 11.5px;\n\tborder-radius: 3px;\n\tline-height: normal;\n    cursor: pointer;\n    user-select: none; \n    transition: all .2s ease;\n}\n#lccp_modes_wrap span.lccp_sel_mode,\n.pccp_circle_f_wrap span.pcpp_circle_btn_active {\n\tborder: 1px solid #bbb;\n\tbackground: #fff;\n    opacity: 1;\n\tcursor: default;\n}\n.lccp_gradient_wizard,\n.lccp_gradient_ranges {\n    position: relative;\n}\n.lccp_gradient {    \n    height: 35px;\n    border: 1px solid #aaa;\n    cursor: crosshair;\n    position: relative;\n    z-index: 10;\n    user-select: none;\n}\n.lccp_gradient-bg {\n\tposition: absolute;\n\ttop: 0;\n\tz-index: 0;\n\twidth: 100%;\n\tmargin: 0;\n}\n.lccp_gradient_ranges {\n    margin: 2px 7px 25px 8px;\n    height: 20px;\n}\n.lccp_gradient_range {\n\tdisplay: inline-block;\n\twidth: 13px;\n\theight: 13px;\n\tborder: 1px solid #ccc;\n\tborder-radius: 0 50% 50% 50%;\n\ttransform: rotate(45deg) translate3d(-5px, 5px, 0);\n\tcursor: col-resize;\n\tposition: absolute;\n    top: 3px;\n}\n.lccp_gradient_range img {\n\twidth: 13px;\n\tposition: relative;\n\ttop: 11px;\n\tleft: 11px;\n\topacity: .3;\n\tcursor: pointer;\n    transition: all .2s ease;\n}\n.lccp_gradient_range img:hover {\n    opacity: .5;\n}\n.lccp_sel_step {\n    border: 1px solid #333;\n    box-shadow: 0 0 2px 1px teal;\n}\n.pccp_deg_f_wrap,\n.pccp_circle_f_wrap {\n    margin-bottom: 10px;\n}\n.pccp_circle_f_wrap * {\n    float: left;\n}\n.pccp_circle_f_wrap:after {\n    content: "";\n    clear: both;\n    display: block;\n}\n.pccp_circle_f_wrap img {\n    position: relative;\n    top: 4px;\n}\n.pccp_circle_f_wrap span {\n    margin-left: 13px;\n}\n.pccp_circle_f_wrap span:not(.pcpp_circle_btn_active) {\n    cursr: pointer;\n}\n.pccp_deg_f_wrap,\n.pccp_color_f_wrap,\n.pccp_opacity_f_wrap {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    align-items: center;\n    clear: both;\n}\n.pccp_deg_f_wrap input,\n.pccp_color_f_wrap input,\n.pccp_opacity_f_wrap input {\n    border: 1px solid #aaa;\n    border-radius: 3px;\n    padding: 0;\n}\n.lccp-preview-bg,\n.pccp_color_f_wrap div,\n.lccp_gradient-bg {  \n    background: url(\'data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAQDAwMDAwQDAwQGBAMEBgcFBAQFBwgGBgcGBggKCAkJCQkICgoMDAwMDAoMDA0NDAwRERERERQUFBQUFBQUFBT/2wBDAQQFBQgHCA8KCg8UDg4OFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wAARCAAoACgDAREAAhEBAxEB/8QAFwABAQEBAAAAAAAAAAAAAAAAAAUGCP/EACIQAQAABQMFAQAAAAAAAAAAAAAFFUNjgqLB4RESEzVRkf/EABQBAQAAAAAAAAAAAAAAAAAAAAD/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwDv4AE6K0stgTgAaIAE6K0stgTgAUZra1cATW1q4A9na8WXXu/PgEqu6eQJVd08gnAAowqrjuCiADOgAowqrjuCiAD/2Q==\') repeat;\n    background-size: 15px;\n}\n#lc-color-picker hr {\n\tmargin: 14px 0 0;\n\theight: 0;\n\tborder-width: 1px 0;\n\tborder-style: dashed;\n\tborder-color: #e3e3e3;\n}\n.pccp_color_f_wrap div {    \n    width: calc(100% - 25px - 85px);\n    height: 25px;\n    border: 1px solid #aaa;\n    border-radius: 2px;\n    overflow: hidden;\n}\n.pccp_deg_f_wrap img,\n.pccp_circle_f_wrap img,\n.pccp_color_f_wrap img, \n.pccp_opacity_f_wrap img {\n\tmax-width: 15px;\n\topacity: .6;\n    cursor: help;\n    user-select: none;  \n}\n.pccp_color_f_wrap input[type=color] {   \n    -webkit-appearance: none;\n    padding: 0;\n    width: 110%;\n    height: 110%;\n    transform: translate(-5%, -5%);\n    cursor: pointer;\n    border: none;\n}\n.pccp_color_f_wrap input:focus {\n    outline: none;\n}\n.pccp_color_f_wrap input::-webkit-color-swatch-wrapper {\n    padding: 0;\n}\n.pccp_color_f_wrap input::-webkit-color-swatch {\n    border: none;\n}\n.pccp_color_f_wrap input[name=hex] { \n    width: 70px;\n    height: 25px;\n    text-align: center;\n}\n.pccp_color_f_wrap {\n    margin-top: 17px;\n}\n.pccp_opacity_f_wrap {\n    margin-top: 10px;\n}\n.pccp_deg_f_wrap input[type=range],\n.pccp_opacity_f_wrap input[type=range] {\n    width: calc(100% - 25px - 70px);\n    height: 25px;\n}\n.pccp_deg_f_wrap input[type="number"],\n.pccp_opacity_f_wrap input[type="number"] {\n\twidth: 53px;\n\theight: 25px;\n\ttext-align: center;\n}\n.pccp_deg_f_wrap input[type=range],\n.pccp_opacity_f_wrap input[type=range] {\n    -webkit-appearance: none;\n    height: 5px;\n    background: #d5d5d5;\n    outline: none;\n    border: none;\n}\n.pccp_deg_f_wrap input::-webkit-slider-thumb,\n.pccp_opacity_f_wrap input::-webkit-slider-thumb {\n    -webkit-appearance: none;\n    appearance: none;\n    width: 17px;\n    height: 17px;\n    background: #888;\n    cursor: pointer;\n    border-radius: 50%;\n    border: 1px solid #aaa;\n    box-shadow: 0 0 0 5px #fff inset, 0 0 2px rgba(0,0,0,.15);\n}\n.pccp_deg_f_wrap input::-moz-range-thumb,\n.pccp_opacity_f_wrap input::-moz-range-thumb {\n    width: 15px;\n    height: 15px;\n    background: #888;\n    cursor: pointer;\n    border-radius: 50%;\n    border: 1px solid #aaa;\n    box-shadow: 0 0 0 5px #fff inset, 0 0 2px rgba(0,0,0,.15);\n}\n\n#lc-color-picker.lccp_dark_theme {\n    background: #333;\n    border-color: #505050;\n}\n.lccp_dark_theme img {\n\tfilter: invert(100%);\n    opacity: .85;\n}\n.lccp_dark_theme .lccp_gradient_range img {\n\topacity: .6;\n}\n.lccp_dark_theme .lccp_gradient_range img:hover {\n    opacity: .8;\n}\n.lccp_dark_theme .lccp_gradient {\n    border-color: #626262;\n}\n.lccp_dark_theme .lccp_sel_step {\n\tbox-shadow: 0 0 2px 1px orange;\n}\n#lc-color-picker.lccp_dark_theme hr {\n\tborder-color: #727272;\n}\n.lccp_dark_theme .pccp_deg_f_wrap input, \n.lccp_dark_theme .pccp_color_f_wrap input, \n.lccp_dark_theme .pccp_opacity_f_wrap input {\n\tborder-color: #777;\n\tbackground: #505050;\n\tcolor: #f3f3f3;\n}\n.lccp_dark_theme input[type=range] {\n    background: #808080;\n}\n</style>')},this.init()};const u=e=>{if("string"!=typeof e){if(e instanceof Element)return[e];{let t=[];for(const n of e)n instanceof Element&&t.push(n);return t}}return(e.match(/(#[0-9][^\s:,]*)/g)||[]).forEach((function(t){e=e.replace(t,'[id="'+t.replace("#","")+'"]')})),document.querySelectorAll(e)}}();