/*
 * jQuery File Upload Plugin v10.31.0
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 */

/* global define, require */
/* eslint-disable new-cap */

(function(e){"function"===typeof define&&define.amd?define(["jquery","jquery-ui/ui/widget"],e):"object"===typeof exports?e(require("jquery"),require("./vendor/jquery.ui.widget")):e(window.jQuery)})(function(e){function x(a){var b="dragover"===a;return function(c){c.dataTransfer=c.originalEvent&&c.originalEvent.dataTransfer;var d=c.dataTransfer;d&&-1!==e.inArray("Files",d.types)&&!1!==this._trigger(a,e.Event(a,{delegatedEvent:c}))&&(c.preventDefault(),b&&(d.dropEffect="copy"))}}e.support.fileInput=
!(/(Android (1\.[0156]|2\.[01]))|(Windows Phone (OS 7|8\.0))|(XBLWP)|(ZuneWP)|(WPDesktop)|(w(eb)?OSBrowser)|(webOS)|(Kindle\/(1\.0|2\.[05]|3\.0))/.test(window.navigator.userAgent)||e('<input type="file"/>').prop("disabled"));e.support.xhrFileUpload=!(!window.ProgressEvent||!window.FileReader);e.support.xhrFormDataFileUpload=!!window.FormData;e.support.blobSlice=window.Blob&&(Blob.prototype.slice||Blob.prototype.webkitSlice||Blob.prototype.mozSlice);e.widget("blueimp.fileupload",{options:{dropZone:e(document),
pasteZone:void 0,fileInput:void 0,replaceFileInput:!0,paramName:void 0,singleFileUploads:!0,limitMultiFileUploads:void 0,limitMultiFileUploadSize:void 0,limitMultiFileUploadSizeOverhead:512,sequentialUploads:!1,limitConcurrentUploads:void 0,forceIframeTransport:!1,redirect:void 0,redirectParamName:void 0,postMessage:void 0,multipart:!0,maxChunkSize:void 0,uploadedBytes:void 0,recalculateProgress:!0,progressInterval:100,bitrateInterval:500,autoUpload:!0,uniqueFilenames:void 0,messages:{uploadedBytes:"Uploaded bytes exceed file size"},
i18n:function(a,b){a=this.messages[a]||a.toString();b&&e.each(b,function(c,d){a=a.replace("{"+c+"}",d)});return a},formData:function(a){return a.serializeArray()},add:function(a,b){if(a.isDefaultPrevented())return!1;(b.autoUpload||!1!==b.autoUpload&&e(this).fileupload("option","autoUpload"))&&b.process().done(function(){b.submit()})},processData:!1,contentType:!1,cache:!1,timeout:0},_promisePipe:function(){var a=e.fn.jquery.split(".");return 1<Number(a[0])||7<Number(a[1])?"then":"pipe"}(),_specialOptions:["fileInput",
"dropZone","pasteZone","multipart","forceIframeTransport"],_blobSlice:e.support.blobSlice&&function(){return(this.slice||this.webkitSlice||this.mozSlice).apply(this,arguments)},_BitrateTimer:function(){this.timestamp=Date.now?Date.now():(new Date).getTime();this.bitrate=this.loaded=0;this.getBitrate=function(a,b,c){var d=a-this.timestamp;if(!this.bitrate||!c||d>c)this.bitrate=1E3/d*(b-this.loaded)*8,this.loaded=b,this.timestamp=a;return this.bitrate}},_isXHRUpload:function(a){return!a.forceIframeTransport&&
(!a.multipart&&e.support.xhrFileUpload||e.support.xhrFormDataFileUpload)},_getFormData:function(a){if("function"===e.type(a.formData))return a.formData(a.form);if(e.isArray(a.formData))return a.formData;if("object"===e.type(a.formData)){var b=[];e.each(a.formData,function(c,d){b.push({name:c,value:d})});return b}return[]},_getTotal:function(a){var b=0;e.each(a,function(c,d){b+=d.size||1});return b},_initProgressObject:function(a){var b={loaded:0,total:0,bitrate:0};a._progress?e.extend(a._progress,
b):a._progress=b},_initResponseObject:function(a){var b;if(a._response)for(b in a._response)Object.prototype.hasOwnProperty.call(a._response,b)&&delete a._response[b];else a._response={}},_onProgress:function(a,b){if(a.lengthComputable){var c=Date.now?Date.now():(new Date).getTime();if(!(b._time&&b.progressInterval&&c-b._time<b.progressInterval&&a.loaded!==a.total)){b._time=c;var d=Math.floor(a.loaded/a.total*(b.chunkSize||b._progress.total))+(b.uploadedBytes||0);this._progress.loaded+=d-b._progress.loaded;
this._progress.bitrate=this._bitrateTimer.getBitrate(c,this._progress.loaded,b.bitrateInterval);b._progress.loaded=b.loaded=d;b._progress.bitrate=b.bitrate=b._bitrateTimer.getBitrate(c,d,b.bitrateInterval);this._trigger("progress",e.Event("progress",{delegatedEvent:a}),b);this._trigger("progressall",e.Event("progressall",{delegatedEvent:a}),this._progress)}}},_initProgressListener:function(a){var b=this,c=a.xhr?a.xhr():e.ajaxSettings.xhr();c.upload&&(e(c.upload).on("progress",function(d){var f=d.originalEvent;
d.lengthComputable=f.lengthComputable;d.loaded=f.loaded;d.total=f.total;b._onProgress(d,a)}),a.xhr=function(){return c})},_deinitProgressListener:function(a){a=a.xhr?a.xhr():e.ajaxSettings.xhr();a.upload&&e(a.upload).off("progress")},_isInstanceOf:function(a,b){return Object.prototype.toString.call(b)==="[object "+a+"]"},_getUniqueFilename:function(a,b){a=String(a);if(b[a])return a=a.replace(/(?: \(([\d]+)\))?(\.[^.]+)?$/,function(c,d,f){return" ("+(d?Number(d)+1:1)+")"+(f||"")}),this._getUniqueFilename(a,
b);b[a]=!0;return a},_initXHRData:function(a){var b=this,c=a.files[0],d=a.multipart||!e.support.xhrFileUpload,f="array"===e.type(a.paramName)?a.paramName[0]:a.paramName;a.headers=e.extend({},a.headers);a.contentRange&&(a.headers["Content-Range"]=a.contentRange);d&&!a.blob&&this._isInstanceOf("File",c)||(a.headers["Content-Disposition"]='attachment; filename="'+encodeURI(c.uploadName||c.name)+'"');if(!d)a.contentType=c.type||"application/octet-stream",a.data=a.blob||c;else if(e.support.xhrFormDataFileUpload){if(a.postMessage){var g=
this._getFormData(a);a.blob?g.push({name:f,value:a.blob}):e.each(a.files,function(m,k){g.push({name:"array"===e.type(a.paramName)&&a.paramName[m]||f,value:k})})}else b._isInstanceOf("FormData",a.formData)?g=a.formData:(g=new FormData,e.each(this._getFormData(a),function(m,k){g.append(k.name,k.value)})),a.blob?g.append(f,a.blob,c.uploadName||c.name):e.each(a.files,function(m,k){if(b._isInstanceOf("File",k)||b._isInstanceOf("Blob",k)){var n=k.uploadName||k.name;a.uniqueFilenames&&(n=b._getUniqueFilename(n,
a.uniqueFilenames));g.append("array"===e.type(a.paramName)&&a.paramName[m]||f,k,n)}});a.data=g}a.blob=null},_initIframeSettings:function(a){var b=e("<a></a>").prop("href",a.url).prop("host");a.dataType="iframe "+(a.dataType||"");a.formData=this._getFormData(a);a.redirect&&b&&b!==location.host&&a.formData.push({name:a.redirectParamName||"redirect",value:a.redirect})},_initDataSettings:function(a){this._isXHRUpload(a)?(this._chunkedUpload(a,!0)||(a.data||this._initXHRData(a),this._initProgressListener(a)),
a.postMessage&&(a.dataType="postmessage "+(a.dataType||""))):this._initIframeSettings(a)},_getParamName:function(a){var b=e(a.fileInput),c=a.paramName;c?e.isArray(c)||(c=[c]):(c=[],b.each(function(){var d=e(this),f=d.prop("name")||"files[]";for(d=(d.prop("files")||[1]).length;d;)c.push(f),--d}),c.length||(c=[b.prop("name")||"files[]"]));return c},_initFormSettings:function(a){a.form&&a.form.length||(a.form=e(a.fileInput.prop("form")),a.form.length||(a.form=e(this.options.fileInput.prop("form"))));
a.paramName=this._getParamName(a);a.url||(a.url=a.form.prop("action")||location.href);a.type=(a.type||"string"===e.type(a.form.prop("method"))&&a.form.prop("method")||"").toUpperCase();"POST"!==a.type&&"PUT"!==a.type&&"PATCH"!==a.type&&(a.type="POST");a.formAcceptCharset||(a.formAcceptCharset=a.form.attr("accept-charset"))},_getAJAXSettings:function(a){a=e.extend({},this.options,a);this._initFormSettings(a);this._initDataSettings(a);return a},_getDeferredState:function(a){return a.state?a.state():
a.isResolved()?"resolved":a.isRejected()?"rejected":"pending"},_enhancePromise:function(a){a.success=a.done;a.error=a.fail;a.complete=a.always;return a},_getXHRPromise:function(a,b,c){var d=e.Deferred(),f=d.promise();b=b||this.options.context||f;!0===a?d.resolveWith(b,c):!1===a&&d.rejectWith(b,c);f.abort=d.promise;return this._enhancePromise(f)},_addConvenienceMethods:function(a,b){var c=this,d=function(f){return e.Deferred().resolveWith(c,f).promise()};b.process=function(f,g){if(f||g)b._processQueue=
this._processQueue=(this._processQueue||d([this]))[c._promisePipe](function(){return b.errorThrown?e.Deferred().rejectWith(c,[b]).promise():d(arguments)})[c._promisePipe](f,g);return this._processQueue||d([this])};b.submit=function(){"pending"!==this.state()&&(b.jqXHR=this.jqXHR=!1!==c._trigger("submit",e.Event("submit",{delegatedEvent:a}),this)&&c._onSend(a,this));return this.jqXHR||c._getXHRPromise()};b.abort=function(){if(this.jqXHR)return this.jqXHR.abort();this.errorThrown="abort";c._trigger("fail",
null,this);return c._getXHRPromise(!1)};b.state=function(){if(this.jqXHR)return c._getDeferredState(this.jqXHR);if(this._processQueue)return c._getDeferredState(this._processQueue)};b.processing=function(){return!this.jqXHR&&this._processQueue&&"pending"===c._getDeferredState(this._processQueue)};b.progress=function(){return this._progress};b.response=function(){return this._response}},_getUploadedBytes:function(a){return(a=(a=(a=a.getResponseHeader("Range"))&&a.split("-"))&&1<a.length&&parseInt(a[1],
10))&&a+1},_chunkedUpload:function(a,b){a.uploadedBytes=a.uploadedBytes||0;var c=this,d=a.files[0],f=d.size,g=a.uploadedBytes,m=a.maxChunkSize||f,k=this._blobSlice,n=e.Deferred(),l=n.promise(),p;if(!(this._isXHRUpload(a)&&k&&(g||("function"===e.type(m)?m(a):m)<f))||a.data)return!1;if(b)return!0;if(g>=f)return d.error=a.i18n("uploadedBytes"),this._getXHRPromise(!1,a.context,[null,"error",d.error]);var q=function(){var h=e.extend({},a),u=h._progress.loaded;h.blob=k.call(d,g,g+("function"===e.type(m)?
m(h):m),d.type);h.chunkSize=h.blob.size;h.contentRange="bytes "+g+"-"+(g+h.chunkSize-1)+"/"+f;c._trigger("chunkbeforesend",null,h);c._initXHRData(h);c._initProgressListener(h);p=(!1!==c._trigger("chunksend",null,h)&&e.ajax(h)||c._getXHRPromise(!1,h.context)).done(function(r,v,t){g=c._getUploadedBytes(t)||g+h.chunkSize;u+h.chunkSize-h._progress.loaded&&c._onProgress(e.Event("progress",{lengthComputable:!0,loaded:g-h.uploadedBytes,total:g-h.uploadedBytes}),h);a.uploadedBytes=h.uploadedBytes=g;h.result=
r;h.textStatus=v;h.jqXHR=t;c._trigger("chunkdone",null,h);c._trigger("chunkalways",null,h);g<f?q():n.resolveWith(h.context,[r,v,t])}).fail(function(r,v,t){h.jqXHR=r;h.textStatus=v;h.errorThrown=t;c._trigger("chunkfail",null,h);c._trigger("chunkalways",null,h);n.rejectWith(h.context,[r,v,t])}).always(function(){c._deinitProgressListener(h)})};this._enhancePromise(l);l.abort=function(){return p.abort()};q();return l},_beforeSend:function(a,b){0===this._active&&(this._trigger("start"),this._bitrateTimer=
new this._BitrateTimer,this._progress.loaded=this._progress.total=0,this._progress.bitrate=0);this._initResponseObject(b);this._initProgressObject(b);b._progress.loaded=b.loaded=b.uploadedBytes||0;b._progress.total=b.total=this._getTotal(b.files)||1;b._progress.bitrate=b.bitrate=0;this._active+=1;this._progress.loaded+=b.loaded;this._progress.total+=b.total},_onDone:function(a,b,c,d){var f=d._progress.total,g=d._response;d._progress.loaded<f&&this._onProgress(e.Event("progress",{lengthComputable:!0,
loaded:f,total:f}),d);g.result=d.result=a;g.textStatus=d.textStatus=b;g.jqXHR=d.jqXHR=c;this._trigger("done",null,d)},_onFail:function(a,b,c,d){var f=d._response;d.recalculateProgress&&(this._progress.loaded-=d._progress.loaded,this._progress.total-=d._progress.total);f.jqXHR=d.jqXHR=a;f.textStatus=d.textStatus=b;f.errorThrown=d.errorThrown=c;this._trigger("fail",null,d)},_onAlways:function(a,b,c,d){this._trigger("always",null,d)},_onSend:function(a,b){b.submit||this._addConvenienceMethods(a,b);var c=
this,d,f,g=c._getAJAXSettings(b),m=function(){c._sending+=1;g._bitrateTimer=new c._BitrateTimer;return d=d||((f||!1===c._trigger("send",e.Event("send",{delegatedEvent:a}),g))&&c._getXHRPromise(!1,g.context,f)||c._chunkedUpload(g)||e.ajax(g)).done(function(l,p,q){c._onDone(l,p,q,g)}).fail(function(l,p,q){c._onFail(l,p,q,g)}).always(function(l,p,q){c._deinitProgressListener(g);c._onAlways(l,p,q,g);--c._sending;--c._active;if(g.limitConcurrentUploads&&g.limitConcurrentUploads>c._sending)for(l=c._slots.shift();l;){if("pending"===
c._getDeferredState(l)){l.resolve();break}l=c._slots.shift()}0===c._active&&c._trigger("stop")})};this._beforeSend(a,g);if(this.options.sequentialUploads||this.options.limitConcurrentUploads&&this.options.limitConcurrentUploads<=this._sending){if(1<this.options.limitConcurrentUploads){var k=e.Deferred();this._slots.push(k);var n=k[c._promisePipe](m)}else n=this._sequence=this._sequence[c._promisePipe](m,m);n.abort=function(){f=[void 0,"abort","abort"];return d?d.abort():(k&&k.rejectWith(g.context,
f),m())};return this._enhancePromise(n)}return m()},_onAdd:function(a,b){var c=this,d=!0,f=e.extend({},this.options,b),g=b.files,m=g.length,k=f.limitMultiFileUploads,n=f.limitMultiFileUploadSize,l=f.limitMultiFileUploadSizeOverhead,p=0,q=this._getParamName(f),h=0;if(!m)return!1;n&&void 0===g[0].size&&(n=void 0);if((f.singleFileUploads||k||n)&&this._isXHRUpload(f))if(f.singleFileUploads||n||!k)if(!f.singleFileUploads&&n){var u=[];var r=[];for(f=0;f<m;f+=1)if(p+=g[f].size+l,f+1===m||p+g[f+1].size+l>
n||k&&f+1-h>=k)u.push(g.slice(h,f+1)),p=q.slice(h,f+1),p.length||(p=q),r.push(p),h=f+1,p=0}else r=q;else for(u=[],r=[],f=0;f<m;f+=k)u.push(g.slice(f,f+k)),p=q.slice(f,f+k),p.length||(p=q),r.push(p);else u=[g],r=[q];b.originalFiles=g;e.each(u||g,function(v,t){var w=e.extend({},b);w.files=u?t:[t];w.paramName=r[v];c._initResponseObject(w);c._initProgressObject(w);c._addConvenienceMethods(a,w);return d=c._trigger("add",e.Event("add",{delegatedEvent:a}),w)});return d},_replaceFileInput:function(a){var b=
a.fileInput,c=b.clone(!0),d=b.is(document.activeElement);a.fileInputClone=c;e("<form></form>").append(c)[0].reset();b.after(c).detach();d&&c.trigger("focus");e.cleanData(b.off("remove"));this.options.fileInput=this.options.fileInput.map(function(f,g){return g===b[0]?c[0]:g});b[0]===this.element[0]&&(this.element=c)},_handleFileTreeEntry:function(a,b){var c=this,d=e.Deferred(),f=[],g=function(l){l&&!l.entry&&(l.entry=a);d.resolve([l])},m=function(l){c._handleFileTreeEntries(l,b+a.name+"/").done(function(p){d.resolve(p)}).fail(g)},
k=function(){n.readEntries(function(l){l.length?(f=f.concat(l),k()):m(f)},g)};b=b||"";if(a.isFile)a._file?(a._file.relativePath=b,d.resolve(a._file)):a.file(function(l){l.relativePath=b;d.resolve(l)},g);else if(a.isDirectory){var n=a.createReader();k()}else d.resolve([]);return d.promise()},_handleFileTreeEntries:function(a,b){var c=this;return e.when.apply(e,e.map(a,function(d){return c._handleFileTreeEntry(d,b)}))[this._promisePipe](function(){return Array.prototype.concat.apply([],arguments)})},
_getDroppedFiles:function(a){a=a||{};var b=a.items;return b&&b.length&&(b[0].webkitGetAsEntry||b[0].getAsEntry)?this._handleFileTreeEntries(e.map(b,function(c){var d;if(c.webkitGetAsEntry){if(d=c.webkitGetAsEntry())d._file=c.getAsFile();return d}return c.getAsEntry()})):e.Deferred().resolve(e.makeArray(a.files)).promise()},_getSingleFileInputFiles:function(a){a=e(a);var b=a.prop("webkitEntries")||a.prop("entries");if(b&&b.length)return this._handleFileTreeEntries(b);b=e.makeArray(a.prop("files"));
if(b.length)void 0===b[0].name&&b[0].fileName&&e.each(b,function(c,d){d.name=d.fileName;d.size=d.fileSize});else{a=a.prop("value");if(!a)return e.Deferred().resolve([]).promise();b=[{name:a.replace(/^.*\\/,"")}]}return e.Deferred().resolve(b).promise()},_getFileInputFiles:function(a){return a instanceof e&&1!==a.length?e.when.apply(e,e.map(a,this._getSingleFileInputFiles))[this._promisePipe](function(){return Array.prototype.concat.apply([],arguments)}):this._getSingleFileInputFiles(a)},_onChange:function(a){var b=
this,c={fileInput:e(a.target),form:e(a.target.form)};this._getFileInputFiles(c.fileInput).always(function(d){c.files=d;b.options.replaceFileInput&&b._replaceFileInput(c);!1!==b._trigger("change",e.Event("change",{delegatedEvent:a}),c)&&b._onAdd(a,c)})},_onPaste:function(a){var b=a.originalEvent&&a.originalEvent.clipboardData&&a.originalEvent.clipboardData.items,c={files:[]};b&&b.length&&(e.each(b,function(d,f){var g=f.getAsFile&&f.getAsFile();g&&c.files.push(g)}),!1!==this._trigger("paste",e.Event("paste",
{delegatedEvent:a}),c)&&this._onAdd(a,c))},_onDrop:function(a){a.dataTransfer=a.originalEvent&&a.originalEvent.dataTransfer;var b=this,c=a.dataTransfer,d={};c&&c.files&&c.files.length&&(a.preventDefault(),this._getDroppedFiles(c).always(function(f){d.files=f;!1!==b._trigger("drop",e.Event("drop",{delegatedEvent:a}),d)&&b._onAdd(a,d)}))},_onDragOver:x("dragover"),_onDragEnter:x("dragenter"),_onDragLeave:x("dragleave"),_initEventHandlers:function(){this._isXHRUpload(this.options)&&(this._on(this.options.dropZone,
{dragover:this._onDragOver,drop:this._onDrop,dragenter:this._onDragEnter,dragleave:this._onDragLeave}),this._on(this.options.pasteZone,{paste:this._onPaste}));e.support.fileInput&&this._on(this.options.fileInput,{change:this._onChange})},_destroyEventHandlers:function(){this._off(this.options.dropZone,"dragenter dragleave dragover drop");this._off(this.options.pasteZone,"paste");this._off(this.options.fileInput,"change")},_destroy:function(){this._destroyEventHandlers()},_setOption:function(a,b){var c=
-1!==e.inArray(a,this._specialOptions);c&&this._destroyEventHandlers();this._super(a,b);c&&(this._initSpecialOptions(),this._initEventHandlers())},_initSpecialOptions:function(){var a=this.options;void 0===a.fileInput?a.fileInput=this.element.is('input[type="file"]')?this.element:this.element.find('input[type="file"]'):a.fileInput instanceof e||(a.fileInput=e(a.fileInput));a.dropZone instanceof e||(a.dropZone=e(a.dropZone));a.pasteZone instanceof e||(a.pasteZone=e(a.pasteZone))},_getRegExp:function(a){a=
a.split("/");var b=a.pop();a.shift();return new RegExp(a.join("/"),b)},_isRegExpOption:function(a,b){return"url"!==a&&"string"===e.type(b)&&/^\/.*\/[igm]{0,3}$/.test(b)},_initDataAttributes:function(){var a=this,b=this.options,c=this.element.data();e.each(this.element[0].attributes,function(d,f){var g=f.name.toLowerCase();if(/^data-/.test(g)){g=g.slice(5).replace(/-[a-z]/g,function(k){return k.charAt(1).toUpperCase()});var m=c[g];a._isRegExpOption(g,m)&&(m=a._getRegExp(m));b[g]=m}})},_create:function(){this._initDataAttributes();
this._initSpecialOptions();this._slots=[];this._sequence=this._getXHRPromise(!0);this._sending=this._active=0;this._initProgressObject(this);this._initEventHandlers()},active:function(){return this._active},progress:function(){return this._progress},add:function(a){var b=this;a&&!this.options.disabled&&(a.fileInput&&!a.files?this._getFileInputFiles(a.fileInput).always(function(c){a.files=c;b._onAdd(null,a)}):(a.files=e.makeArray(a.files),this._onAdd(null,a)))},send:function(a){if(a&&!this.options.disabled){if(a.fileInput&&
!a.files){var b=this,c=e.Deferred(),d=c.promise(),f,g;d.abort=function(){g=!0;if(f)return f.abort();c.reject(null,"abort","abort");return d};this._getFileInputFiles(a.fileInput).always(function(m){g||(m.length?(a.files=m,f=b._onSend(null,a),f.then(function(k,n,l){c.resolve(k,n,l)},function(k,n,l){c.reject(k,n,l)})):c.reject())});return this._enhancePromise(d)}a.files=e.makeArray(a.files);if(a.files.length)return this._onSend(null,a)}return this._getXHRPromise(!1,a&&a.context)}})});