// custom field type for number + unit dropdown

(function($) {
    "use strict"; 
    
	var merge_vals = function($subj) {
		var num = parseInt($subj.find('input[type=number]').val());
		if(isNaN(num)) {
            num = 80;
        }
		
		var unit = $subj.find('select').val();
		
		$subj.find('input[type=hidden]').val( num + unit );	
	}
	
	// on unit change
	$('.gg_num_unit_wrap select').on('change', function() {
		var $subj = $(this).parents('.gg_num_unit_wrap');
		merge_vals($subj);
	});
	
	// on unit change
	$(".gg_num_unit_wrap input[type=number]").on('keyup change click', function () {
		var $subj = $(this).parents('.gg_num_unit_wrap');
		merge_vals($subj);
	});
})(jQuery);