<?php 
include_once(GG_DIR . '/settings/field_options.php'); 
include_once(GG_DIR . '/settings/preset_styles.php'); 


// no more slider's oldstyle graphic
delete_option('gg_slider_old_cmd');


// collection layout - use just min and max cols width
//// if gg_coll_thumb_w already exists - set a max-width default value using this algorithm: ((elems_max_w / coll_cols) + 50) 
if(!get_option('gg_coll_thumb_max_w')) {
	$elems_basewidth = ((int)get_option('gg_masonry_basewidth', 1400)) ? (int)get_option('gg_masonry_basewidth', 1400) : 1400;
	$old_coll_cols = ((int)get_option('gg_coll_thumb_w', 4)) ? (int)get_option('gg_coll_thumb_w', 4) : 4;
	
	$val = ($elems_basewidth / $old_coll_cols)	+ 50;
	update_option('gg_coll_thumb_max_w', round($val));
}



// Custom post types list
$args = array(
    'public'   => true,
    'publicly_queryable' => true,
    '_builtin' => false
);
$cpt_obj = get_post_types($args, 'objects');

$cpt = false;
if(is_array($cpt_obj) && count($cpt_obj)) {
    $cpt = array();
    
    foreach($cpt_obj as $id => $obj) {
        $cpt[$id] = $obj->labels->name;	
    }
}	



// GG-FILTER - manipulate settings tabs
$tabs = array(
	'main_opts' => esc_html__('Main Options', 'gg_ml'),
	'layouts' 	=> esc_html__('Layouts', 'gg_ml'),
	'styling' 	=> esc_html__('Styling', 'gg_ml'),
	'lightbox'	=> esc_html__('Lightbox', 'gg_ml'),
	'watermark'	=> esc_html__('Watermark', 'gg_ml'),
	'cust_css'	=> esc_html__('Custom CSS', 'gg_ml'),
);
$GLOBALS['gg_settings_tabs'] = apply_filters('gg_settings_tabs', $tabs);	


// STRUCTURE
/* tabs index => array( 
	'sect_id' => array(
		'sect_name'	=> name
		'fields'	=> array(
			...
		)
	)
   )
*/

$structure = array();



####################################
########## MAIN OPTIONS ############
####################################
$structure['main_opts'] = array(
	
	'def_gall_sett' => array(
		'sect_name'	=>  esc_html__('Default Gallery Settings', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_layout' => array(
				'label' 	=> esc_html__('Default galleries layout', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'standard' 	 => 'Standard', 
					'columnized' => 'Columnized', 
					'masonry' 	 => 'Masonry',
					'string'	 => 'PhotoString',
				),
				'note'		=> ''
			),   
			'gg_masonry_basewidth' => array(
				'label' 	=> esc_html__('Elements maximum width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 850,
				'max_val'	=> 2000,	
				'step'		=> 50,
				'def'		=> 1400,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set maximum container's width where plugin elements will be placed", 'gg_ml'),
			),
			'gg_link_target' => array(
				'label' 	=> esc_html__('Linked images behavior', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'_top' 		=> esc_html__('Open link in same page', 'gg_ml'), 
					'_blank'	=> esc_html__('Open link in a new page', 'gg_ml'),
				),
				'note'		=> esc_html__('Choose how linked images are managed', 'gg_ml'), 
			),   
			'gg_delayed_fx' => array(
				'label' => esc_html__('Show images without delay?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, shows gallery images without delayed effect", 'gg_ml'),
			), 
			'gg_affect_wp_gall' => array(
				'label' => esc_html__('Manage WP galleries with Global Gallery by default?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, displays wordpress galleries through Global Gallery engine", 'gg_ml'),
			), 
			'gg_extend_wp_gall' => array(
				'label' 	=> esc_html__('Extend WP galleries management for these custom post types', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> $cpt,
				'multiple'	=> true,
				'fullwidth'	=> true,
				'hide'		=> (empty($cpt)) ? true : false,
				'note'		=> ''
			),   
			'gg_preview_pag' => array(
				'label' 	=> esc_html__('Preview container', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_get_pages(),
				'note'		=> esc_html__('Choose the page to use as galleries preview container', 'gg_ml'), 
			),  
			'spcr1' => array(
				'type' => 'spacer',
			),  
			'xml_sitemap_url' => array(
				'label' 	=> esc_html__("Images XML sitemap location", 'gg_ml'),
				'type'		=> 'label_message',
				'content'	=> '<a href="'.GG_URL.'/galleries_xml_sitemap.php" target="_blank"><strong>'.GG_URL.'/galleries_xml_sitemap.php</strong></a>',
			), 
		),
	),
	
	
	
	'filters' => array(
		'sect_name'	=>  esc_html__('Tags and collection filters', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_filters_align' => array(
				'label' 	=> esc_html__('Filters alignment', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'center' 	=> esc_html__('Center', 'gg_ml'), 
					'left' 		=> esc_html__('Left', 'gg_ml'),
					'right'		=> esc_html__('Right', 'gg_ml'),
				),
				'note'		=> '' 
			),  
			'gg_dd_mobile_filter' => array(
				'label' => esc_html__('Use dropdown on mobile mode?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__('If checked, replace filters with a dropdown on mobile mode', 'gg_ml'),
			),
			'gg_use_old_filters' => array(
				'label' => esc_html__('Use textual filters style?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> '',
			),  
			'gg_os_filters_separator' => array(
				'label' => esc_html__('Textual filters - separator', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__("Specify what divides filters", 'gg_ml'),
				
				'js_vis'=> array(
					'linked_field' 	=> 'gg_use_old_filters',
					'condition'		=> true 
				)
			),	
			'spcr1' => array(
				'type' => 'spacer',
			),
			'gg_tags_all_txt' => array(
				'label' => esc_html__('Tags - custom "All" filter\'s text', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__("Leave empty to use the default 'All' value", 'gg_ml'),
			),	
			'gg_filters_all_txt' => array(
				'label' => esc_html__('Collections - custom "All" filter\'s text', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__("Leave empty to use the default 'All' value", 'gg_ml'),
			),	
			'spcr2' => array(
				'type' => 'spacer',
			),
			'gg_tags_sort' => array(
				'label' 	=> esc_html__('Sort tags by', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'name' 	=> esc_html__('Name (A to Z)', 'gg_ml'), 
					'count' => esc_html__('Matching images count', 'gg_ml'),
				),
				'note'		=> '' 
			),  
			'gg_show_tags_counter' => array(
				'label' => esc_html__('Show matched images count? (only for tags)', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> '',
			),  
			'gg_discard_tags' => array(
				'label' 	=> esc_html__('Discard tags matching less than this images number', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1,
				'max_val'	=> 10,	
				'step'		=> 1,
				'def'		=> 1,
				'value'		=> '',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Use '1' to show every tag", 'gg_ml'),
			), 
		),
	),
	
	
	
	'pag' => array(
		'sect_name'	=>  esc_html__('Pagination Settings', 'gg_ml'),
		'fields' 	=> array(
            
            'gg_paginate' => array(
				'label' => esc_html__('Use pagination?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Whether to split galleries into pages by default", 'gg_ml'),
			), 
			'gg_per_page' => array(
				'label' 	=> esc_html__('Default images number per page', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 8,
				'value'		=> '',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> '',
			), 
			'gg_pag_system' => array(
				'label' 	=> esc_html__('Pagination system', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_pag_sys(),
				'note'		=> esc_html__('Select default pagination system', 'gg_ml'), 
			),   
			'gg_pag_layout' => array(
				'label' 	=> esc_html__('Standard pagination - Layout', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_pag_layouts(),
				'note'		=> esc_html__('Select standard pagination elements layout', 'gg_ml'), 
				
				'js_vis'=> array(
					'linked_field' 	=> 'gg_pag_system',
					'condition'		=> 'standard'
				)
			),  
			'gg_pag_align' => array(
				'label' 	=> esc_html__('Buttons alignment', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'center' 	=> esc_html__('Center', 'gg_ml'), 
					'left' 		=> esc_html__('Left', 'gg_ml'),
					'right'		=> esc_html__('Right', 'gg_ml'),
				),
				'note'		=> '' 
			),    
		),
	),
	
	
	'itg' => array(
		'sect_name'	=>  esc_html__('Image-to-Gallery Settings', 'gg_ml'),
		'fields' 	=> array(
			  
			'gg_itg_layout' => array(
				'label' 	=> esc_html__('Default layout', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_itg_layouts(),
				'note'		=> '', 
				'fullwidth'	=> true,
			),   
			'gg_itg_text' => array(
				'label' 	=> esc_html__('Default overlay text', 'gg_ml'),
				'type'		=> 'textarea',
				'def' 		=> '+ %IMG-NUM% &nbsp;<i class="fa fa-camera-retro"></i>',
				'required'	=> true,
				'fullwidth'	=> true,
				'note' => sprintf(
                    esc_html__("This text will be applied by default to image's overlay%1\$sAvailable keywords: %2\$s%%IMG-NUM%%%3\$s and %4\$s%%GALL-TITLE%%%5\$s -", 'gg_ml'),
                    '<br/>',
                    '<strong>', '</strong>',
                    '<strong>', '</strong>'
                ) . '<a href="http://fontawesome.io/icons/" target="_blank">'. esc_html__('you can use also any FontAwesome icon using HTML', 'gg_ml') .'</a>',
			), 
			'gg_itg_margin' => array(
				'label' 	=> esc_html__('Images margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
			),  
		),
	),
	
	
	'coll' => array(
		'sect_name'	=>  esc_html__('Collection Settings', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_coll_back_to' => array(
				'label' => esc_html__("\"back to collection\" filter's text", 'gg_ml'),
				'type'	=> 'text',
				'def' 	=> 'Back to collection',
				'note'	=> esc_html__("Use a custom text for \"back to collection\" button", 'gg_ml'),
			),
			'gg_coll_show_gall_title' => array(
				'label' => esc_html__('Display loaded galleries title?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__('If checked, displays title on top of loaded galleries', 'gg_ml'),
			),  
			'gg_coll_back_to_scroll' => array(
				'label' => esc_html__('"Back to collection" - keep visible on scroll?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__('If checked, "back to collection" button is kept visible on scroll', 'gg_ml'),
			),
		),
	),
	
	
	'slider' => array(
		'sect_name'	=>  esc_html__('Slider Settings', 'gg_ml'),
		'fields' 	=> array(
			
            'gg_min_slider_h' => array(
				'label' 	=> esc_html__('Minimum height', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 50,
				'max_val'	=> 1200,	
				'step'		=> 50,
				'def'		=> 200,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Safety option to avoid tiny responsive sliders on mobile contexts", 'gg_ml'),
			), 
			'gg_slider_crop' => array(
				'label' 	=> esc_html__('Images management method', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_slider_crop_methods(false),
				'note'		=> esc_html__('Select how images will be rendered', 'gg_ml'), 
			),
            'gg_slider_easing' => array(
				'label' 	=> esc_html__("Transition easing", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_slider_easings(),
				'note'		=> esc_html__('Select transition effects easing', 'gg_ml'), 
			),  
			'gg_slider_fx' => array(
				'label' 	=> esc_html__('Transition effect', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_slider_fx(),
				'note'		=> esc_html__('Select transition effect between slides', 'gg_ml'), 
			), 
			'gg_slider_fx_time' => array(
				'label' 	=> esc_html__('Transition duration', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 100,
				'max_val'	=> 1200,	
				'step'		=> 50,
				'def'		=> 400,
				'value'		=> 'ms',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("How much time transition takes (in milliseconds)", 'gg_ml'),
			),
			'gg_slider_autoplay' => array(
				'label' => esc_html__('Autoplay slideshow?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Check to autoplay slider's slideshow by default", 'gg_ml'),
			),
            'gg_slider_stop_on_hover' => array(
				'label' => esc_html__('Stop slideshow on hover?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked and slider is performing slideshow, the process will stop hovering the image", 'gg_ml'),
			),
			'gg_slider_interval' => array(
				'label' 	=> esc_html__('Slideshow interval', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1000,
				'max_val'	=> 10000,	
				'step'		=> 500,
				'def'		=> 3500,
				'value'		=> 'ms',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("How long each slide will be shown (in milliseconds)", 'gg_ml'),
			), 
            'gg_slider_extra_nav' => array(
				'label' 	=> esc_html__('Extra navigation system', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
                    'thumbs' => esc_html__('Thumbnails', 'gg_ml'),
                    'dots'   => esc_html__('Dots', 'gg_ml'),
                    'none'   => esc_html__('None', 'gg_ml'),
                ),
				'note'		=> esc_html__('Select which navigation system to show below sliders', 'gg_ml'), 
			), 
			'gg_slider_thumb_sizes' => array(
				'label' 	=> esc_html__("Thumbnails size", 'gg_ml'),
                'type'		=> '2_numbers',
				'min_val'	=> 10,
				'max_val'	=> 200,	
				'value'		=> 'px',
				'def'		=> array(100, 75),
                'note'		=> esc_html__("Define slider's navigation thumbnail sizes (width x height)", 'gg_ml'),
                
				'js_vis'=> array(
					'linked_field' 	=> 'gg_slider_extra_nav',
					'condition'		=> 'thumbs',
				)
			),
            'gg_slider_thumbs' => array(
				'label' 	=> esc_html__('Show thumbnails?', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_slider_thumb_opts(),
				'note'		=> esc_html__('Select whether and how thumbs will be shown', 'gg_ml'),
                
				'js_vis'=> array(
					'linked_field' 	=> 'gg_slider_extra_nav',
					'condition'		=> 'thumbs',
				)
			),
			'gg_slider_to_hide' => array(
				'label' 	=> esc_html__('Elements to remove', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_slider_elems_to_hide(),
				'multiple'	=> true,
				'note'		=> esc_html__('Select slider elements you want to remove', 'gg_ml'), 
			),
            'gg_slider_tgl_info' => array(
				'label' => esc_html__("Hide image's data by default?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, hides image's title/description by default. They can be toggled clicking on the related command", 'gg_ml'),
                
				'js_vis'=> array(
					'linked_field' 	=> 'gg_slider_to_hide',
					'condition'		=> 'info',
                    'operator'		=> '!=',
				)
			),
		),
	),
	
	
	'carousel' => array(
		'sect_name'	=>  esc_html__('Carousel Settings', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_car_elem_style' => array(
				'label' 	=> esc_html__('Style', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'light' => esc_html__('Light', 'gg_ml'), 
					'dark' 	=> esc_html__('Dark', 'gg_ml'),
				),
				'note'		=> '', 
			),  
			'gg_car_hor_margin' => array(
				'label' 	=> esc_html__('Horizontal margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set horizontal margin between images", 'gg_ml'),
			),  
			'gg_car_ver_margin' => array(
				'label' 	=> esc_html__('Vertical margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set vertical margin between images", 'gg_ml'),
			), 
			'gg_car_infinite' => array(
				'label' => esc_html__("Infinite loop sliding?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, navigation won't stop if latest image is reached", 'gg_ml'),
			), 
			'gg_car_ss_time' => array(
				'label' 	=> esc_html__('Slideshow interval', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1000,
				'max_val'	=> 10000,	
				'step'		=> 500,
				'def'		=> 5000,
				'value'		=> 'ms',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set slideshow interval time in milliseconds  (in milliseconds)", 'gg_ml'),
			), 
			'gg_car_autoplay' => array(
				'label' => esc_html__("Autoplay slideshow?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Check to autoplay carousel slideshow by default", 'gg_ml'),
			), 
			'gg_car_pause_on_h' => array(
				'label' => esc_html__("Pause slideshow on hover?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, slideshow will be paused hovering an image", 'gg_ml'),
			), 
			'gg_car_hide_nav_elem' => array(
				'label' 	=> esc_html__('Hide navigation elements', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array( 
					 'arrows' 	=> esc_html__('Side arrows', 'gg_ml'),
					 'dots' 	=> esc_html__('Bottom dots', 'gg_ml') 
				),
				'multiple'	=> true,
				'note'		=> esc_html__('Select navigation elements to hide in carousels', 'gg_ml'), 
			),   
		),
	),
	
	
	'img_protect' => array(
		'sect_name'	=>  esc_html__('Images Protection', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_disable_rclick' => array(
				'label' => esc_html__("Disable right click?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, disables right click on gallery images", 'gg_ml'),
			), 
		),
	),
	
	
	'deeplinking' => array(
		'sect_name'	=>  esc_html__('Deeplinking', 'gg_ml') . ' <small>('. esc_html__('system adding URL parameters for direct linking', 'gg_ml') .')</small>',
		'fields' 	=> array(
			
			'gg_deeplinked_elems' => array(
				'label' 	=> esc_html__("Deeplinked elements", 'gg_ml'),
				'type'		=> 'select',
				'multiple'	=> true,
				'val' 		=> gg_deeplink_elems(),
				'fullwidth'	=> true,
				'def' 		=> array_keys(gg_deeplink_elems()),
				'note'		=> esc_html__('Choose which plugin systems will have their direct URL', 'gg_ml'), 
			),  
			'gg_basic_deeplink' => array(
				'label' => esc_html__('Basic deeplinking mode?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, a single browser's history step is created for deeplinked operations", 'gg_ml'),
			),
			'gg_dl_coll_gall' => array(
				'label' => esc_html__("Deeplink also collection galleries?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables deeplinks also for galleries opened through a collection", 'gg_ml'),
			), 
		),
	),
	
	
	'advanced' => array(
		'sect_name'	=>  esc_html__('Advanced', 'gg_ml'),
		'fields' 	=> array(
			  
			'gg_thumb_q' => array(
				'label' 	=> esc_html__('Thumbnails quality', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 30,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 90,
				'value'		=> '%',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set thumbnails quality. Low value = lighter but fuzzier images (default: 90%)", 'gg_ml'),
			),
            'gg_fetched_img_max_size' => array(
				'label' 	=> esc_html__('Fetched images max sizes', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array( 
					'max' 	=> esc_html__('Maximum available', 'gg_ml'),
					'big' 	=> esc_html__('Big', 'gg_ml'),
                    'medium'=> esc_html__('Medium', 'gg_ml'),
				),
				'note'		=> esc_html__('Select the fetched images size where the source allows it (WP-based images and Flickr)', 'gg_ml'), 
			),
			'gg_preload_hires_img' => array(
				'label' => esc_html__('Preload full-resolution images?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Check to preload full resolution images once galleries are shown. This speeds-up lightbox opening but increases page's weight", 'gg_ml'),
			), 
            'gg_use_url_for_wp_thumbs' => array(
				'label' => esc_html__('Use WP image URL to create thumbnails?', 'gg_ml'),
				'type'	=> 'checkbox', 
                //'def'   => true, // dangerous for HTACCESS protected websites 
				'note'	=> esc_html__("Enable it ONLY if you notice problems creating thumbnails from WP-based and Global Gallery Album sources. Might be handy if you are using a CDN. NEVER use it on HTACCESS-protected websites.", 'gg_ml'),
			), 
			'gg_use_admin_thumbs' => array(
				'label' => esc_html__('Use thumbnails on admin side?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Check to use thumbnails on admin side", 'gg_ml') .'. <strong>'. esc_html__('Could slow down the server in case of huge galleries', 'gg_ml') .'</strong>',
			), 
			'gg_wp_term_autolink' => array(
				'label' => esc_html__('Auto-link images coming from WP posts?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, automatically set added images to link to their related posts (only for WP category and CPT sources)", 'gg_ml'),
			), 
			'gga_img_title_src' => array(
				'label' 	=> esc_html__('Global Gallery Albums - images title', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'filename' 	=> esc_html__('File name', 'gg_ml'), 
					'iptc' 		=> esc_html__('IPTC metadata', 'gg_ml'),
				),
				'note'		=> esc_html__('Choose what is used to get GG album images title', 'gg_ml'), 
			), 
			'gg_force_inline_css' => array(
				'label' => esc_html__('Use custom CSS inline?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, uses custom CSS inline", 'gg_ml') .'. <strong>('. esc_html__('useful for multisite installations', 'gg_ml') .')</strong>',
			), 
			'gg_js_head' => array(
				'label' => esc_html__("Use javascript in website's head?", 'gg_ml'),
				'type'	=> 'checkbox',
				// translators: 1: opening <strong> tag, 2: opening <strong> tag for ONLY IF, 3: closing </strong> tag, 4: closing </strong> tag.
                'note' => sprintf( esc_html__( '%1$sCheck it %2$sONLY IF%3$s you notice some incompatibilities%4$s', 'gg_ml' ), '<strong>', '<strong>', '</strong>', '</strong>' ),
			),   
			'gg_rtl_mode' => array(
				'label' => esc_html__("RTL mode?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Checking it, elements layout is changed to be viewed on a RTL site", 'gg_ml'),
			),
            'gg_no_front_nonce' => array(
				'label' => esc_html__("Disable the security check on frontend ajax calls?", 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Check it ONLY if you are having troubles with ajax data validations due to cache systems", 'gg_ml'),
			),
			'spcr1' => array(
				'type' => 'spacer',
			),    
			'gg_use_timthumb' => array(
				'label' => esc_html__('Use TimThumb?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, use Timthumb instead of Easy WP Thumbs", 'gg_ml'),
			),
            'gg_no_async_ewpt' => array(
				'label' => esc_html__('Avoid calling Easy WP Thumbs asynchronously?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("By default Easy WP Thumbs create thumbnails with the remote URL method. This avoid excessive loads on single pages and spped up the rendering. Check this option oonly if you notice incompatibilities (eg. with security plugins)", 'gg_ml'),
				
				'js_vis'=> array(
					'linked_field' 	=> 'gg_use_timthumb',
					'condition'		=> false
				)
			),
			'gg_ewpt_force' => array(
				'label' => esc_html__('Use Easy WP Thumbs forcing system?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Tries forcing thumbnails creation", 'gg_ml') .', <strong>'. esc_html__('check it ONLY if you notice thumbnail issues', 'gg_ml') .'</strong>',
				
				'js_vis'=> array(
					'linked_field' 	=> 'gg_use_timthumb',
					'condition'		=> false
				)
			),   
		),
	),
	
	
	'ewpt_status' => array(
		'sect_name'	=> '',
		'fields' 	=> array(
			
			'ewpt_status' => array(
				'type'		=> 'custom',
				'callback'	=> 'gg_ewpt_status',
			), 
		),
	),
);	
	
	
	
	
####################################
############ LAYOUTS ###############
####################################		
$structure['layouts'] = array(
	
	'standard_lyt' => array(
		'sect_name'	=>  esc_html__('Standard Galleries Layout (fixed sizes)', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_standard_hor_margin' => array(
				'label' 	=> esc_html__('Horizontal margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set horizontal margin between images", 'gg_ml'),
			),  
			'gg_standard_ver_margin' => array(
				'label' 	=> esc_html__('Vertical margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set vertical margin between images", 'gg_ml'),
			), 
			'gg_slayout_sizes' => array(
				'label' 	=> esc_html__("Images size", 'gg_ml'),
                'type'		=> '2_numbers',
				'min_val'	=> 30,
				'max_val'	=> 1000,	
				'value'		=> 'px',
				'def'		=> array(220, 280),
                'note'		=> esc_html__('Set default thumbnail sizes for standard layout (width x height)', 'gg_ml'),
			),
		),
	),
	
	
	'colnzd_lyt' => array(
		'sect_name'	=>  esc_html__('Columnized Galleries Layout', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_colnzd_thumb_max_w' => array(
				'label' 	=> esc_html__('Gallery columns maximum width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 40,
				'max_val'	=> 2000,	
				'step'		=> 20,
				'def'		=> 260,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Over this threshold, gallery columns number will be increased", 'gg_ml'),
			),   
			'gg_colnzd_thumb_h' => array(
				'label' 	=> esc_html__("Thumbnails height", 'gg_ml'),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 4,
				'def'			=> 140,
				'types' 		=> array(
					'px'   => 'px',
					'%'    => '%',
				),
				'note'		=> esc_html__("Sets columnized gallery thumbnails height (percentage value is related to image's width)", 'gg_ml'),
			),
			'gg_colnzd_hor_margin' => array(
				'label' 	=> esc_html__('Horizontal margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set horizontal margin between images", 'gg_ml'),
			), 
			'gg_colnzd_ver_margin' => array(
				'label' 	=> esc_html__('Vertical margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Set vertical margin between images", 'gg_ml'),
			), 
		),
	),
	
	
	'masonry_lyt' => array(
		'sect_name'	=>  esc_html__('Masonry Galleries Layout', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_masonry_cols' => array(
				'label' 	=> esc_html__('Image columns', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1,
				'max_val'	=> 20,	
				'step'		=> 1,
				'def'		=> 4,
				'value'		=> '',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets default columns number for masonry galleries", 'gg_ml'),
			), 
			'gg_masonry_min_width' => array(
				'label' 	=> esc_html__('Minimum images width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 40,
				'max_val'	=> 350,	
				'step'		=> 10,
				'def'		=> 150,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets minimum images width in masonry galleries", 'gg_ml'),
			),  
			'gg_masonry_margin' => array(
				'label' 	=> esc_html__('Images margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 7,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets images margin in masonry galleries", 'gg_ml'),
			), 
		),
	),
	
	
	'photostring_lyt' => array(
		'sect_name'	=>  esc_html__('PhotoString Galleries Layout', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_photostring_h' => array(
				'label' 	=> esc_html__('Thumbnails height', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 40,
				'max_val'	=> 400,	
				'step'		=> 10,
				'def'		=> 140,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets default columns number for photostring layout", 'gg_ml'),
			), 
			'gg_photostring_min_width' => array(
				'label' 	=> esc_html__('Minimum images width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 40,
				'max_val'	=> 350,	
				'step'		=> 10,
				'def'		=> 120,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets minimum images width in photostring galleries", 'gg_ml'),
			),  
			'gg_photostring_margin' => array(
				'label' 	=> esc_html__('Images margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 7,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets images margin in photostring galleries", 'gg_ml'),
			),
		),
	),
	
	
	'coll_lyt' => array(
		'sect_name'	=>  esc_html__('Collections Layout', 'gg_ml'),
		'fields' 	=> array(
			 
			'gg_coll_thumb_max_w' => array(
				'label' 	=> esc_html__('Collection columns maximum width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 100,
				'max_val'	=> 1800,	
				'step'		=> 20,
				'def'		=> 260,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Over this threshold, collection columns number will be increased", 'gg_ml'),
			),   
			'gg_coll_thumb_h' => array(
				'label' 	=> esc_html__("Thumbnails height", 'gg_ml'),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 4,
				'def'			=> 140,
				'types' 		=> array(
					'px'   => 'px',
					'%'    => '%',
				),
                'note'		=> esc_html__("Sets collection thumbnails height (percentage value is related to image's width)", 'gg_ml'),
			),
			'gg_coll_hor_margin' => array(
				'label' 	=> esc_html__('Horizontal margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets horizontal margin between collection images", 'gg_ml'),
			), 
			'gg_coll_ver_margin' => array(
				'label' 	=> esc_html__('Vertical margin', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'step'		=> 1,
				'def'		=> 10,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets vertical margin between collection images", 'gg_ml'),
			), 
			'gg_coll_title_under' => array(
				'label' => esc_html__('Texts under images?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, texts will be displayed under collection images", 'gg_ml'),
			), 
		),
	),
);

	
	
	
	
####################################
############ STYLING ###############
####################################		
$structure['styling'] = array(
		
	'preset_styles' => array(
		'sect_name'	=>  esc_html__('Preset Styles', 'gg_ml'),
		'fields' 	=> array(
			
			'preset_styles_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'gg_preset_styles'
			), 
		),
	),
	
	
	'loader' => array(
		'sect_name'	=>  esc_html__('Loader', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_loader' => array(
				'label' 	=> esc_html__("Preloader", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_preloader_types(),
				'required'	=> true,
				'note'		=> ''
			),
			'gg_loader_color' => array(
				'label' 	=> esc_html__("Preloader color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#aaaaaa',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
		),
	),
	
	
	'img_layout' => array(
		'sect_name'	=>  esc_html__('Images Layout', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_img_border' => array(
				'label' 	=> esc_html__('Images border width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 15,	
				'step'		=> 1,
				'def'		=> 4,
				'value'		=> 'px',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> ''
			),  
			'gg_img_border_color' => array(
				'label' 	=> esc_html__("Images border color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#fafafa',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			'gg_img_shadow' => array(
				'label' 	=> esc_html__('Outer image effect', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'' 			=> esc_html__('No effect', 'gg_ml'), 
					'outshadow'	=> esc_html__('Soft shadow', 'gg_ml'),
					'outline'	=> esc_html__('Outline', 'gg_ml'),
				),
				'note'		=> esc_html__('Choose which effect use for images aspect', 'gg_ml'), 
			),
			'gg_img_outline_color' => array(
				'label' 	=> esc_html__("Images outline color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#aaaaaa',
                'extra_modes' => array('alpha'),
				'required'	=> true,
				'note'		=> esc_html__('Sets images outline color (must be enabled to be shown)', 'gg_ml'),
			),  
			'gg_img_radius' => array(
				'label' 	=> esc_html__('Images border radius', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 25,	
				'step'		=> 1,
				'def'		=> 2,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
			), 
            'gg_slowzoom_ol' => array(
				'label' => esc_html__('Slowly zoom images on hover?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, images will be slowly zoomed on hover, giving a bit of animation to galleries", 'gg_ml'),
			), 
		),
	),
	
    
    'img_fx' => array(
		'sect_name'	=>  esc_html__('Extra Image Effects (applied to galleries, carousels and collections)', 'gg_ml'),
		'fields' 	=> array(
            
            'gg_img_fx_behavior' => array(
				'label' 	=> esc_html__('Effect behavior', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'' 		          => esc_html__('Do not apply', 'gg_ml'), 
					'default_status'  => esc_html__('Apply on initial status', 'gg_ml'),
					'hover_status'    => esc_html__('Apply on hover', 'gg_ml'),
				),
				'note'		=> esc_html__('Choose when effects are applied', 'gg_ml'), 
			), 
            'gg_img_fx_blur' => array(
				'label' 	=> esc_html__('Blur', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 10,	
				'step'		=> 0.1,
				'def'		=> 0,
				'value'		=> 'px',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 0',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),  
            'gg_img_fx_brightness' => array(
				'label' 	=> esc_html__('Brightness', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 400,	
				'step'		=> 1,
				'def'		=> 100,
				'value'		=> '%',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 100',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_contrast' => array(
				'label' 	=> esc_html__('Contrast', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0.3,
				'max_val'	=> 10,	
				'step'		=> 0.1,
				'def'		=> 1,
				'value'		=> '&nbsp;',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 1',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_grayscale' => array(
				'label' 	=> esc_html__('Grayscale', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 0,
				'value'		=> '%',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 0',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_hue' => array(
				'label' 	=> esc_html__('Hue-rotate', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 360,	
				'step'		=> 1,
				'def'		=> 0,
				'value'		=> '',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 0',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_invert' => array(
				'label' 	=> esc_html__('Invert', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 0,
				'value'		=> '%',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 0',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_saturate' => array(
				'label' 	=> esc_html__('Saturation', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 1,
				'max_val'	=> 20,	
				'step'		=> 0.1,
				'def'		=> 1,
				'value'		=> '&nbsp;',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 1',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
            'gg_img_fx_sepia' => array(
				'label' 	=> esc_html__('Sepia', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 0,
				'value'		=> '%',
                'respect_limits' => true,
				'required'	=> true,
				'note'		=> esc_html__('Initial value', 'gg_ml') .': 0',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),

            'gg_img_fx_preview' => array(
				'label' 	=> esc_html__("Preview", 'gg_ml'),
				'type'		=> 'custom',
				'callback'	=> 'gg_img_fx_preview',
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_img_fx_behavior',
					'condition'		=> array('default_status', 'hover_status')
				)
			),
		),
	),
    
    
	
	'overlays' => array(
		'sect_name'	=>  esc_html__('Overlays', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_overlay_type' => array(
				'label' 	=> esc_html__('Overlay type', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'both'		=> esc_html__('Both overlays', 'gg_ml'),
					'primary'	=> esc_html__('Only main overlay', 'gg_ml'),
					'' 			=> esc_html__('No overlay', 'gg_ml'), 
				),
			),
			'gg_main_overlay' => array(
				'label' 	=> esc_html__('Main overlay mode', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'bottom' 	=> esc_html__('Bottom bar', 'gg_ml'), 
					'top'		=> esc_html__('Top bar', 'gg_ml'),
					'full'		=> esc_html__('Full image', 'gg_ml'),
				),
			),
			'gg_main_ol_behav' => array(
				'label' 	=> esc_html__('Main overlay behavior', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'show_on_h'		=> esc_html__('Show on hover', 'gg_ml'), 
					'always_shown'	=> esc_html__('Always shown', 'gg_ml'),
					'hide_on_h'		=> esc_html__('Hide on hover', 'gg_ml'),
				),
			),
			'gg_main_ol_color' => array(
				'label' 	=> esc_html__("Main overlay color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> 'rgba(253, 253, 253, 0.3)',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			), 
            'gg_main_ol_full_txt_bg' => array(
				'label' 	=> esc_html__("Title's background color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#fdfdfd',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
                
                'js_vis' => array(
					'linked_field' 	=> 'gg_overlay_type',
					'condition'		=> array('both')
				)
			), 
			'gg_main_ol_txt_color' => array(
				'label' 	=> esc_html__("Main overlay - text color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#444444',
                'extra_modes' => false,
				'required'	=> true,
			),  
			'gg_sec_overlay' => array(
				'label' 	=> esc_html__('Secondary overlay position', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'tl'	=> esc_html__('Top-left corner', 'gg_ml'), 
					'tr'	=> esc_html__('Top-right corner', 'gg_ml'),
					'bl'	=> esc_html__('Bottom-left corner', 'gg_ml'), 
					'br'	=> esc_html__('Bottom-right corner', 'gg_ml'),
				),
			), 
			'gg_sec_ol_color' => array(
				'label' 	=> esc_html__("Secondary overlay color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#747474',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
				'note'		=> esc_html__("Sets secondary overlay's background color", 'gg_ml'), 
			),
			'gg_sec_ol_icon' => array(
				'label' 	=> esc_html__('Secondary overlay - icon type', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'eye'		=> esc_html__('Eye', 'gg_ml'), 
					'camera'	=> esc_html__('Camera', 'gg_ml'),
					'magnifier'	=> esc_html__('Magnifier', 'gg_ml'), 
					'image'		=> esc_html__('Image', 'gg_ml'),
				),
			),
			'gg_icons_col' => array(
				'label' 	=> esc_html__("Secondary overlay - icon color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#fcfcfc',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
		),
	),
	
	
	'itg_ols' => array(
		'sect_name'	=>  esc_html__('Image-to-Gallery overlay', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_itg_bg_color' => array(
				'label' 	=> esc_html__("Overlay's background color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#333333',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_itg_txt_color' => array(
				'label' 	=> esc_html__("Overlay's text color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#fefefe',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_itg_ol_on_h' => array(
				'label' => esc_html__('Only show overlays on hover?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, overlays will be hidden by default, showing clean images", 'gg_ml'),
			), 
		),
	),
	
	
	'coll_tui' => array(
		'sect_name'	=>  esc_html__('Collections - Texts Under Images', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_txt_u_title_color' => array(
				'label' 	=> esc_html__("Titles color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#444444',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_txt_u_descr_color' => array(
				'label' 	=> esc_html__("Descriptions color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#686868',
                'extra_modes' => false,
				'required'	=> true,
			),
		),
	),
	
	
	'filters' => array(
		'sect_name'	=>  esc_html__('Filters', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_filters_padding' => array(
				'label' 	=> esc_html__("Padding", 'gg_ml'),
				'type'		=> '2_numbers',
				'min_val'	=> 0,
				'max_val'	=> 20,	
				'value'		=> 'px',
				'def'		=> array(6, 12),
				'note'		=> esc_html__('Sets filters padding (vertical / horizontal)', 'gg_ml')
			),	
			'gg_filters_font_size' => array(
				'label' 	=> esc_html__('Font size', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 8,
				'max_val'	=> 20,	
				'step'		=> 1,
				'def'		=> 15,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
			),
			'gg_filters_border_w' => array(
				'label' 	=> esc_html__("Border's width", 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 4,	
				'step'		=> 1,
				'def'		=> 1,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets filters border width (not for textual mode)", 'gg_ml'),
			),
			'gg_filters_radius' => array(
				'label' 	=> esc_html__('Border radius', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 15,	
				'step'		=> 1,
				'def'		=> 2,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
				'note'		=> esc_html__("Sets filters border radius (not for textual mode)", 'gg_ml'),
			), 
			
			'spcr1' => array(
				'type' => 'spacer',
			),
			
			'gg_filters_txt_color' => array(
				'label' 	=> esc_html__("Filters text color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#444444',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_filters_bg_color' => array(
				'label' 	=> esc_html__("Filters background color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ffffff',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_filters_border_color' => array(
				'label' 	=> esc_html__("Filters border color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#999999',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			'gg_filters_txt_color_h' => array(
				'label' 	=> esc_html__("Filters text color", 'gg_ml') .' - '. esc_html__('hover state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#666666',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_filters_bg_color_h' => array(
				'label' 	=> esc_html__("Filters background color", 'gg_ml') .' - '. esc_html__('hover state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ffffff',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_filters_border_color_h' => array(
				'label' 	=> esc_html__("Filters border color", 'gg_ml') .' - '. esc_html__('hover state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#666666',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			'gg_filters_txt_color_sel' => array(
				'label' 	=> esc_html__("Filters text color", 'gg_ml') .' - '. esc_html__('selected state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#333333',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_filters_bg_color_sel' => array(
				'label' 	=> esc_html__("Filters background color", 'gg_ml') .' - '. esc_html__('selected state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f0f0f0',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_filters_border_color_sel' => array(
				'label' 	=> esc_html__("Filters border color", 'gg_ml') .' - '. esc_html__('selected state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#555555',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			
			'spcr2' => array(
				'type' => 'spacer',
			),
			
			'gg_search_txt_color' => array(
				'label' 	=> esc_html__("Search bar text color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#707070',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			'gg_search_bg_color' => array(
				'label' 	=> esc_html__("Search bar background color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f5f5f5',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_search_border_color' => array(
				'label' 	=> esc_html__("Search bar border color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f1f1f1',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			'gg_search_txt_color_h' => array(
				'label' 	=> esc_html__("Search bar text color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#5e5e5e',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_search_bg_color_h' => array(
				'label' 	=> esc_html__("Search bar background color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ffffff',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_search_border_color_h' => array(
				'label' 	=> esc_html__("Search bar border color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#707070',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
		),
	),
	
	
	'pag_btns' => array(
		'sect_name'	=>  esc_html__('Pagination Elements', 'gg_ml'),
		'fields' 	=> array(
   
   			'gg_pag_txt_col' => array(
				'label' 	=> esc_html__("Texts and arrows color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#707070',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_pag_bg_col' => array(
				'label' 	=> esc_html__("Background color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f5f5f5',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_pag_border_col' => array(
				'label' 	=> esc_html__("Border color", 'gg_ml') .' - '. esc_html__('default state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f5f5f5',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
			
			'spcr2' => array(
				'type' => 'spacer',
			),
			
			'gg_pag_txt_col_h' => array(
				'label' 	=> esc_html__("Texts and arrows color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#5e5e5e',
                'extra_modes' => false,
				'required'	=> true,
			),
			'gg_pag_bg_col_h' => array(
				'label' 	=> esc_html__("Background color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f0f0f0',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
			'gg_pag_border_col_h' => array(
				'label' 	=> esc_html__("Border color", 'gg_ml') .' - '. esc_html__('active state', 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#999999',
                'extra_modes' => array('alpha'),
				'required'	=> true,
			),
		),
	),
    
	
	'slider' => array(
		'sect_name'	=>  esc_html__('Slider', 'gg_ml'),
		'fields' 	=> array(
   
   			'gg_lcms_bg' => array(
				'label' 	=> esc_html__("Background color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ffffff',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
            'gg_lcms_padding' => array(
				'label' 	=> esc_html__('Border size', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 30,	
				'step'		=> 1,
				'def'		=> 7,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
			),
            'gg_lcms_border_radius' => array(
				'label' 	=> esc_html__('Border radius', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 50,	
				'step'		=> 1,
				'def'		=> 2,
				'value'		=> 'px',
                'respect_limits' => false,
                'required'	=> true,
			),
            'gg_lcms_border_w' => array(
				'label' 	=> esc_html__('Outline', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 30,	
				'step'		=> 1,
				'def'		=> 1,
				'value'		=> 'px',
                'respect_limits' => false,
				'required'	=> true,
			),
            'gg_lcms_border_col' => array(
				'label' 	=> esc_html__("Outline color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ebebeb',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
            'gg_lcms_shadow' => array(
				'label' 	=> esc_html__('Outer shadow', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'' 	    => esc_html__('None', 'gg_ml'), 
					'soft'	=> esc_html__('Soft', 'gg_ml'),
					'heavy'	=> esc_html__('Heavy', 'gg_ml'),
				),
			),
            'gg_lcms_dots_col' => array(
				'label' 	=> esc_html__("Navigation dots color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#666',
				'extra_modes' => array(),
				'required'	=> true,
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_slider_extra_nav',
					'condition'		=> 'dots',
				)
			),
            
			'spcr1' => array(
				'type' => 'spacer',
			),
			
            'gg_lcms_txt_layout' => array(
				'label' 	=> esc_html__('Text bock layout', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'bottom_box'   => esc_html__('Bottom box', 'gg_ml'), 
					'bottom_bar'   => esc_html__('Bottom fullwidth bar', 'gg_ml'),
				),
			),
            'gg_lcms_txt_font_size' => array(
				'label' 	=> esc_html__("Text block's font size", 'gg_ml'),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 3,
				'def'			=> 15,
				'types' 		=> array(
					'px'	=> 'px',
					'rem'	=> 'rem',
					'vmax'	=> 'vmax',
				),
                'required'  => true,
			),
            'gg_lcms_txt_bg' => array(
				'label' 	=> esc_html__("Text block background", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> 'rgba(0,0,0, 0.5)',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
            'gg_lcms_txt_col' => array(
				'label' 	=> esc_html__("Texts color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#fdfdfd',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
            
			'spcr2' => array(
				'type' => 'spacer',
			),
			
            'gg_lcms_cmd_bg' => array(
				'label' 	=> esc_html__("Buttons background", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#ffffff',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'required'	=> true,
			),
            'gg_lcms_cmd_col' => array(
				'label' 	=> esc_html__("Buttons color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#282828',
				'extra_modes' => array('alpha'),
				'required'	=> true,
			),
            'gg_lcms_nav_cmd_pos' => array(
				'label' 	=> esc_html__('Navigation commands position', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
                    'h_center'     => esc_html__('Vertically centered', 'gg_ml'),
					'h_center_alt' => esc_html__('Vertically centered (creative)', 'gg_ml'),
					'topbar'       => esc_html__('On top', 'gg_ml'),
				),
			),
            'gg_lcms_progressbar' => array(
				'label' => esc_html__('Show progress bar?', 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'' 		  => esc_html__('No', 'gg_ml'), 
					'top'	  => esc_html__('On top', 'gg_ml'),
					'bottom'  => esc_html__('On bottom', 'gg_ml'),
				),
			),
            'gg_lcms_progressbar_col' => array(
				'label' 	=> esc_html__("Progress bar color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#f04a23',
				'extra_modes' => array('alpha'),
                
                'js_vis'=> array(
					'linked_field' 	=> 'gg_lcms_progressbar',
					'condition'		=> '',
                    'operator'      => '!=',
				)
			),
        ),
    ),

);
	
	


	
####################################
########### LIGHTBOX ###############
####################################		
$structure['lightbox'] = array(
		
	'lightbox' => array(
		'sect_name'	=>  '&nbsp;',
		'fields' 	=> array(
			
			'gg_lightbox' => array(
				'label' 	=> esc_html__("Which lightbox to use?", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_lightboxes(),
				'required'	=> true,
				'note'		=> ''
			),
		),
	),	
		
	/*
	'lcweb' 	=> 'LC Lightbox',
    'photoswipe'=> 'PhotoSwipe',
	'lightcase' => 'Lightcase',
	'simplelb' 	=> 'Simple Lightbox',
	'mag_popup' => 'Magnific Popup',
	'imagelb' 	=> 'imageLightbox',
	'photobox' 	=> 'Photobox',
	*/
	
	
	'lb_opts' => array(
		'sect_name'	=> esc_html__('Lightbox Options', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_lb_lcl_style' => array(
				'label' 	=> esc_html__("Style", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'minimal'	=> esc_html__('Minimal', 'gg_ml'), 
					'light'		=> esc_html__('Light', 'gg_ml'),
					'dark'		=> esc_html__('Dark', 'gg_ml'), 
				),
				'note'		=> esc_html__('Select lightbox skin', 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_lcl_openclose' => array(
				'label' 	=> esc_html__("Open/close effect", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_lcl_openclose_list(),
				// translators: 1–4: <em> and </em> tags used around class names.
                'note' => sprintf( esc_html__( 'Select which opening/closing effect to use (for custom CSS, classes are %1$s.lcl_pre_show%2$s and %3$s.lcl_is_closing%4$s)', 'gg_ml' ), '<em>', '</em>', '<em>', '</em>' ),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_simplelb_style' => array(
				'label' 	=> esc_html__("Style", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'light'		=> esc_html__('Light', 'gg_ml'),
					'dark'		=> esc_html__('Dark', 'gg_ml'), 
				),
				'note'		=> esc_html__('Select lightbox skin', 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('simplelb')
				)
			),
			'gg_lb_opacity' => array(
				'label' 	=> esc_html__('Overlay opacity', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 100,	
				'step'		=> 5,
				'def'		=> 70,
				'value'		=> '%',
                'respect_limits' => true,
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photoswipe', 'lightcase', 'mag_popup', 'simplelb', 'imagelb')
				)
			), 
			'gg_lb_ol_color' => array(
				'label' 	=> esc_html__("Overlay color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#333333',
                'extra_modes' => array('linear-gradient', 'radial-gradient'),
                'note'		=> esc_html__("NB: using gradients you will automatically exclude patterns", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'lightcase', 'mag_popup', 'simplelb', 'imagelb')
				)
			), 
			'gg_lb_ol_pattern' => array(
				'type'		=> 'custom',
				'callback'	=> 'gg_lb_ol_pattern_f',
				'validation'=> array(
					array('index' => 'gg_lb_ol_pattern', 'label' => 'Lb overlay pattern'),
				),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'lightcase', 'mag_popup', 'simplelb', 'imagelb')
				)
			), 
			'gg_lb_max_w' => array(
				'label' 	=> esc_html__('Maximum width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 20,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 85,
				'value'		=> '%',
                'respect_limits' => true,
				'note'		=> esc_html__("Set lightbox max width, in relation to browser's one", 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photoswipe', 'lightcase', 'mag_popup', 'simplelb')
				)
			), 
			'gg_lb_max_h' => array(
				'label' 	=> esc_html__('Maximum height', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 20,
				'max_val'	=> 100,	
				'step'		=> 1,
				'def'		=> 85,
				'value'		=> '%',
                'respect_limits' => true,
				'note'		=> esc_html__("Set lightbox max height, in relation to browser's one", 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photoswipe', 'lightcase', 'simplelb', 'imagelb')
				)
			), 
			'gg_lb_padding' => array(
				'label' 	=> esc_html__('Contents padding', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 20,	
				'step'		=> 1,
				'def'		=> 0,
				'value'		=> 'px',
                'respect_limits' => false,

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			'gg_lb_border_w' => array(
				'label' 	=> esc_html__('Border width', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 20,	
				'step'		=> 1,
				'def'		=> 2,
				'value'		=> 'px',
                'respect_limits' => false,

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			'gg_lb_border_col' => array(
				'label' 	=> esc_html__("Border color", 'gg_ml'),
				'type'		=> 'color',
				'def'		=> '#888888',
                'extra_modes' => array('alpha'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			'gg_lb_radius' => array(
				'label' 	=> esc_html__('Border radius', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 25,	
				'step'		=> 1,
				'def'		=> 2,
				'value'		=> 'px',
                'respect_limits' => false,

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'simplelb')
				)
			),
			'gg_lb_use_shadow' => array(
				'label' => esc_html__('Outer shadow?', 'gg_ml'),
				'type'	=> 'checkbox',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			'gg_lcl_txt_pos' => array(
				'label' 	=> esc_html__("Text position", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'under'	=> esc_html__('Under image', 'gg_ml'),
					'over'	=> esc_html__('Over image', 'gg_ml'), 
					'rside'	=> esc_html__('On right side', 'gg_ml'),
					'lside'	=> esc_html__('On left side', 'gg_ml'), 
				),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_txt_treshold' => array(
				'label' 	=> esc_html__('Text visibility threshold', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 200,
				'max_val'	=> 3500,	
				'step'		=> 100,
				'def'		=> 600,
				'value'		=> 'px',
                'respect_limits' => false,
				'note'		=> esc_html__("Screens smaller than this value have text hidden by default", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_cmd_pos' => array(
				'label' 	=> esc_html__("Commands position", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'inner'	=> esc_html__('Inner', 'gg_ml'),
					'outer'	=> esc_html__('Outer', 'gg_ml'), 
				),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_corner_close' => array(
				'label' => esc_html__('Closing button in corner position?', 'gg_ml'),
				'type'	=> 'checkbox',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			'gg_lb_middle_nav_pos' => array(
				'label' => esc_html__('Navigation buttons in middle position?', 'gg_ml'),
				'type'	=> 'checkbox',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			), 
			
			'gg_lb_thumbs' => array(
				'label' => esc_html__('Use thumbnails navigation?', 'gg_ml'),
				'type'	=> 'checkbox',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photobox')
				)
			),
			'gg_lb_tn_treshold' => array(
				'label' 	=> esc_html__('Thumbnails visibility threshold', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 200,
				'max_val'	=> 2500,	
				'step'		=> 100,
				'def'		=> 600,
				'value'		=> 'px',
                'respect_limits' => false,
				'note'		=> esc_html__("Screens smaller than this value have thumbnails hidden by default", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_thumb_sizes' => array(
				'label' 	=> esc_html__("Thumbnail sizes", 'gg_ml'),
                'type'		=> '2_numbers',
				'min_val'	=> 10,
				'max_val'	=> 300,	
				'value'		=> 'px',
				'def'		=> array(100, 100),
                'note'		=> esc_html__('Set lightbox thumbnail sizes (width x height)', 'gg_ml'),
                
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_thumbs_full_img' => array(
				'label' => esc_html__('Use full images in thumbnails navigation?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'		=> esc_html__("If checked, fills thumbnails with full-size images", 'gg_ml') .', <strong>('. esc_html__('use ONLY if you note thumbs loading issues', 'gg_ml') .')</strong>',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_fullscreen' => array(
				'label' => esc_html__('Enable fullscreen?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, allows to use the fullscreen mode", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
            'gg_lb_no_touchswipe' => array(
				'label' => esc_html__('Disable touch interactions?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, disables touch interactions on mobile devices. Should be checked only in specific incompatibility cases", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_fs_treshold' => array(
				'label' 	=> esc_html__('Fullscreen threshold', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 200,
				'max_val'	=> 2500,	
				'step'		=> 100,
				'def'		=> 600,
				'value'		=> 'px',
                'respect_limits' => false,
				'note'		=> esc_html__("Lightbox will be only in fullscreen mode for screens smaller than this value", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_deeplink' => array(
				'label' => esc_html__('Enable deeplink?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables images deeplinking", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_download' => array(
				'label' => esc_html__('Download button?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables images download button (only for self hosted images)", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_zoom' => array(
				'label' => esc_html__('Images zoom?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables images zooming system", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photoswipe')
				)
			),
			'gg_photobox_zoom' => array(
				'label' => esc_html__('Images zoom?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables images zooming system with mousewheel", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('photobox')
				)
			),
			'gg_lb_counter' => array(
				'label' => esc_html__('Show counter?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, displays images count and progress", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'photoswipe')
				)
			),
			'gg_lb_socials' => array(
				'label' => esc_html__('Enable socials?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, enables social share", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_lcl_direct_fb' => array(
				'label' => esc_html__('Direct Facebook contents sharing?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("Allows direct photo + contents sharing on Facebook", 'gg_ml') .'. <strong class="lcwp_settings_rednote">'. esc_html__('Requires a valid App ID linked to this domain', 'gg_ml') .'</strong>',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
				
			'gg_lb_lcl_comments' => array(
				'label' 	=> esc_html__("Comments system", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					''			=> esc_html__('None', 'gg_ml'),
					'disqus'	=> esc_html__('Disqus', 'gg_ml'),
					'fb' 		=> esc_html__('Facebook Comments', 'gg_ml'), 
				),
				'note'	=> '<font class="lcwp_settings_rednote">'. esc_html__("Comments are applied only using texts on right or left side. Facebook moderation requires a valid App ID", 'gg_ml') .'</font>',

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			
			'gg_lcl_disqus_shortname' => array(
				'label' => esc_html__('Disqus shortname', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__("Required to use Disqus comments", 'gg_ml') .'. <a href="https://help.disqus.com/customer/portal/articles/466208" target="_blank">'. esc_html__("Get one", 'gg_ml') .'</a>',
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),				
			'gg_lcl_fb_appid' => array(
				'label' => esc_html__('Facebook App ID', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__("Required to use FB direct contents share and moderate FB comments", 'gg_ml') .'. <a href="https://developers.facebook.com/docs/apps/register" target="_blank">'. esc_html__("Create an app", 'gg_ml') .'</a>',
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
            'gg_lcl_author_by_txt' => array(
				'label' => esc_html__('Author "by" text', 'gg_ml'),
				'type'	=> 'text',
				'note'	=> esc_html__('Defining which text is used before the author name, by default is "by"', 'gg_ml'),
                'def'   => 'by',
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
					
					
			'gg_lb_slideshow' => array(
				'label' => esc_html__('Auto start slideshow?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, starts slideshow on lightbox opening", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'lightcase', 'photobox')
				)
			),
			'gg_lb_progressbar' => array(
				'label' => esc_html__('Show progressbar?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, shows a progressbar during slideshow", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			
			'gg_lb_oc_time' => array(
				'label' 	=> esc_html__('Open / Close timing', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 2000,	
				'step'		=> 50,
				'def'		=> 500,
				'value'		=> 'ms',
                'respect_limits' => false,
				'note'		=> esc_html__("Set open/close lightbox timing (in milliseconds - default: 500)", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb')
				)
			),
			'gg_lb_time' => array(
				'label' 	=> esc_html__('Sliding animation timing', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 2000,	
				'step'		=> 50,
				'def'		=> 500,
				'value'		=> 'ms',
                'respect_limits' => false,
				'note'		=> esc_html__("Set minimum time to switch from an image to another (in milliseconds - default: 400)", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'lightcase', 'simplelb', 'imagelb')
				)
			),
			'gg_lb_ss_time' => array(
				'label' 	=> esc_html__('Slideshow interval', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 2000,
				'max_val'	=> 15000,	
				'step'		=> 200,
				'def'		=> 5000,
				'value'		=> 'ms',
                'respect_limits' => false,
				'note'		=> esc_html__("Set slideshow interval's time in milliseconds (default 5000)", 'gg_ml'),

				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('lcweb', 'lightcase', 'simplelb')
				)
			),
			'gg_lb_anim_behav' => array(
				'label' 	=> esc_html__("Animation's behavior", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> array(
					'slide'	=> esc_html__('Slide', 'gg_ml'),
					'fade'	=> esc_html__('Fade', 'gg_ml'), 
				),
				'note'		=> esc_html__("Select animation's behavior navigating through images", 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('simplelb')
				)
			),
			'gg_lb_anim_behav' => array(
				'label' 	=> esc_html__("Animation's behavior", 'gg_ml'),
				'type'		=> 'select',
				'val' 		=> gg_lightcase_trans_styles(),
				'note'		=> esc_html__("Select animation's behavior navigating through images", 'gg_ml'),
				
				'js_vis' => array(
					'linked_field' 	=> 'gg_lightbox',
					'condition'		=> array('gg_lightcase_anim_behav')
				)
			),
			
		),
	),	
);
	
	
	
	
	
####################################
########### WATERMARK ##############
####################################		
$structure['watermark'] = array(
	
	'watermark_block' => array(
		'sect_name'	=>  esc_html__('Watermark Settings', 'gg_ml'),
		'fields' 	=> array(
			
			'gg_uwm_block' => array(
				'label' 	=> 'upper watermark block',
				'type'		=> 'custom',
				'callback'	=> 'gg_u_wm_fields',
				'validation'=> array(
					array('index' => 'gg_watermark_img', 'label' => esc_html__( 'Watermark Image', 'gg_ml'), 'type'=>'url'),
					array('index' => 'gg_watermark_pos', 'label' => 'Watermark Position')
				)
			),
			'gg_wm_margin' => array(
				'label' 	=> esc_html__("Watermark's margin", 'gg_ml'),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 3,
				'def'			=> 10,
				'types' 		=> array(
					'%'    => '%',
                    'px'   => 'px',
				),
                'note'		=> esc_html__("Sets margin from image edges (percentage value is related to image sizes)", 'gg_ml'),
			),
			'gg_wm_proport' => array(
				'label' => esc_html__('Proportional size?', 'gg_ml'),
				'type'	=> 'checkbox',
				'note'	=> esc_html__("If checked, watermark will be resized basing on image sizes", 'gg_ml'),
			),
			'gg_wm_prop_val' => array(
				'label' 	=> esc_html__("Proportional sizes", 'gg_ml'),
				'type'		=> '2_numbers',
				'min_val'	=> 1,
				'max_val'	=> 100,	
				'value'		=> '%',
				'def'		=> array(10, 10),
				'note'		=> esc_html__('Sets watermark proportional sizes related to images one (horizontally / vertically)', 'gg_ml'),
			),	
			 
			'gg_watermark_opacity' => array(
				'label' 	=> esc_html__('Watermark opacity', 'gg_ml'),
				'type'		=> 'slider',
				'min_val'	=> 5,
				'max_val'	=> 100,	
				'step'		=> 5,
				'def'		=> 100,
				'value'		=> '%',
                'respect_limits' => true,
			),
			
			'spcr1' => array(
				'type' => 'spacer',
			),    
			'gg_lwm_block' => array(
				'label' 	=> 'upper watermark block',
				'type'		=> 'custom',
				'callback'	=> 'gg_l_wm_fields'
			),
		),
	),
	
);
	





####################################
########### CUSTOM CSS #############
####################################		
$structure['cust_css'] = array(	
	'custom_css_wrap' => array(
		'sect_name'	=>  esc_html__('High-priority code - applied to Global Gallery elements', 'gg_ml'),
		'fields' 	=> array(
		
			'gg_custom_css' => array(
				'label' 	=> esc_html__('Custom CSS', 'gg_ml'),
				'type'		=> 'code_editor',
				'language'	=> 'css',
			),
		),
	),
);




// GG-FILTER - manipulate settings structure
$GLOBALS['gg_settings_structure'] = apply_filters('gg_settings_structure', $structure);
