<?php

/////////////////////////////////////////////////////
// [g-slider]
function gg_slider_shortcode( $atts, $content = null ) {
	global $wp_version;
	
	extract( shortcode_atts( array(
		'gid'         => '',
		'width'       => '100%',
		'height'      => '55%', 
		
        'crop_method'  => 'auto',
        'no_extra_nav' => 0,
        'zoom_on_hover'=> 0,
        'random'      => 0,
		'watermark'   => 0,
		'autoplay'    => 'auto',
        'hidden_elems' => '',
        
		'wp_gall_hash'=> '' // hidden parameter for WP galleries - images list hash
	), $atts ));

	if(!absint($gid)) {
        return '';
    }
	
	// width and height sanitization (for cornerstone)
	if(strpos($width, '%') === false && strpos($width, 'px') === false) {
        $width .= '%';
    }
	if(strpos($height, '%') === false && strpos($height, 'px') === false) {
        $height .= '%';
    }
	
    
	// init
    $unique_id = uniqid();
	$type      = (!empty($wp_gall_hash)) ? 'wp_gall' : get_post_meta($gid, 'gg_type', true);
    $style     = get_option('gg_slider_style', 'light');
    
    $min_slider_h = (int)get_option('gg_slider_min_h', 100);
    $wrap_classes = array();
    
    
    //// prepare images
	// get them
	$images = gg_gall_static::frontend_img_prepare($gid, $type, $wp_gall_hash);
	if(!is_array($images) || !count($images)) {
        return '';
    }

	// randomize images 
	$randomized_order = ((int)$random) ? gg_static::random_img_indexes(count($images)) : false;

	// images array to be used (eventually watermarked) 
	$images = gg_gall_static::frontend_img_split($gid, $images, 'all', $randomized_order, $watermark);	
	if(!is_array($images) || !count($images)) {
        return '';
    }
    
    // hidden elements?
    $elems_to_hide = (array)get_option('gg_slider_to_hide', array());
    if(!empty($hidden_elems)) {
        $elems_to_hide = array_map('trim', explode(',', $hidden_elems));
    }

    // images display mode
    $idm_to_use = get_option('gg_slider_crop', 'cover');
    if(in_array($crop_method, array('cover', 'contain', 'contain_blur'))) {
        $idm_to_use = $crop_method;   
    }
    switch($idm_to_use) {
        case 'contain' : 
            $wrap_classes[] = 'gg_lcms_contain_mode';
            break;

        case 'contain_blur' : 
            $wrap_classes[] = 'gg_lcms_contain_blur_mode';
            break;
    }
    
    // zoom on hover?
    if(absint($zoom_on_hover)) {
        $wrap_classes[] = 'gg_lcms_zoh';
    }
    
    
    // slider thumbs visibility class
    $extra_nav = false;
    if(!absint($no_extra_nav)) {
        $extra_nav = get_option('gg_slider_extra_nav', 'thumbs');
        if($extra_nav == 'thumbs') {
            $thumbs_visiblity = get_option('gg_slider_thumbs', 'yes');
            $thumb_sizes = get_option('gg_slider_thumb_sizes', array(100, 75));

            $wrap_classes[] = 'gg_lcms_has_thumbs';

            switch($thumbs_visiblity) {
                case 'always' :
                case 'yes' :
                    $wrap_classes[] = ' gg_lcms_thumbs_shown'; 
                    break;

                case 'no' : 
                default :    
                    $wrap_classes[] = ' gg_lcms_thumbs_hidden'; 
                    break;
            }
        }
        elseif($extra_nav == 'dots') {
            $wrap_classes[] = 'gg_lcms_has_dots';
        }
    }
    
    
    // play command visibility and autoplay
    $ss_cmd       = (in_array('play', $elems_to_hide)) ? 0 : 1;
    $ss_autoplay  = ($autoplay == 'auto') ? (int)get_option('gg_slider_autoplay') : (int)$autoplay;  


    // additional commands
    $addit_cmd = '';
    if(!in_array('lightbox', $elems_to_hide)) {
        $addit_cmd .= '<span class="gg_lcms_trigger_lb fas fa-expand-alt" title="'. esc_attr__('open in lightox', 'gg_ml') .'" role="button" tabindex="0"></span>';
    }
    if(!in_array('info', $elems_to_hide)) {
        $addit_cmd .= '<span class="gg_lcms_toggle_texts fas fa-quote-right" title="'. esc_attr__('toggle texts', 'gg_ml') .'" role="button" tabindex="0"></span>'; 
    }
    if($extra_nav == 'thumbs' && $thumbs_visiblity != 'always') {
        $addit_cmd .= '<span class="gg_lcms_toggle_thumbs fas fa-ellipsis-h" title="'. esc_attr__('toggle thumbnails', 'gg_ml') .'" role="button" tabindex="0"></span>';
    }
    if(!in_array('counter', $elems_to_hide)) {
        $addit_cmd .= '<span class="gg_lcms_counter">1 / '. count((array)$images) .'</span>';           
    }
    
    
    // progress bar?
    if(get_option('gg_lcms_progressbar')) {
        $wrap_classes[] = 'gg_lcms_has_progbar';
        $addit_cmd .= '<span class="gg_lcms_progbar"></span>';
    }
    
    // hidden text by default?
    if(!in_array('info', $elems_to_hide) && get_option('gg_slider_tgl_info')) {
        $wrap_classes[] = 'gg_lcms_hidden_txt';
    }
    
	// build
    $slider = '
    <div id="'. $unique_id .'" class="gg_lcms_slider '. implode(' ', $wrap_classes) .'" style="width: '. $width .'; padding-bottom: '. $height .'; min-height: '. $min_slider_h .'px;" data-nav-cmd="'. esc_attr(get_option('gg_lcms_nav_cmd_pos', 'h_center')) .'" data-ss-cmd="'. $ss_cmd .'" data-autoplay="'. $ss_autoplay .'" data-gid="'. absint($gid) .'">
        <ul class="gg_displaynone">';

        // compose slider structure
        $gall_lb_data = array();
        foreach($images as $img) {

            // dunno why, but wp gall managed src must be managed
            if($wp_gall_hash) {
              $img['url'] = gg_static::img_id_to_url($img['url']);  
            }
            
            $img_src = ($watermark) ? $img['wm_path'] : gg_static::img_src_on_type($img['img_src'], $type);
            $img_srcest = gg_static::slider_srcset_val($img_src, $img['thumb'], $width, $height);
            
            
            $caption_code = '';
            if(!in_array('info', $elems_to_hide)) {
                if(!empty($img['title'])) {
                    $caption_code .= '<div class="gg_lcms_img_title">'. trim(strip_tags($img['title'], '<a><strong><em>')) .'</div>';
                }
                if(!empty($img['author'])) {
                    $caption_code .= '<div class="gg_lcms_img_author"><span>'. esc_html__('by', 'gg_ml') .'</span> '. trim(strip_tags($img['author'], '<a><strong><em>')) .'</div>';
                }
                if(!empty($img['descr'])) {
                    $caption_code .= '<div class="gg_lcms_img_descr">'. trim(strip_tags($img['descr'], '<a><strong><em>')) .'</div>';
                }
            }

            $img_url = gg_gall_static::gdrive_img_url_trick($img['url']);
            $slider .= '<li data-srcset="'. esc_attr($img_srcest) .'">'. $caption_code .'</li>';
            
            $gall_lb_data[$img['url']] = array(
                'img'   => $img['url'],
                'title' => addslashes($img['title']),
                'descr' => addslashes($img['descr']),
                'author'=> addslashes($img['author']),
            );
        }

        $slider .= '    
        </ul>
    </div>';
    
    
    
	// slider init
	$slider .= '
    <script type="text/javascript"> 
	(function() { 
        "use strict"; 
        
        if(typeof(window.gg_lcms_images) == "undefined") {window.gg_lcms_images = {};}
        window.gg_lcms_images["'. $unique_id .'"] = `'. json_encode($gall_lb_data) .'`;
        
        const intval = setInterval(() => {
            if(typeof(jQuery) == "undefined" || typeof(gg_lcms_init) == "undefined") {
                return true;
            }
            else {
                clearTimeout(intval);
                gg_lcms_init("#'.$unique_id.'", `'. $addit_cmd .'`);
            }
        }, 50);
    })();   
	</script>';

    return str_replace(array("\r", "\n", "\t", "\v"), '', $slider);
}
add_shortcode('g-slider', 'gg_slider_shortcode');

